<?php
/* Template Name: Subsciber Profil */
$current_user = wp_get_current_user();
$wait = '';
$default_doc_img_url = get_stylesheet_directory_uri() . '/assets/pictures/default-img-doc.png';
$default_user_img_url = get_stylesheet_directory_uri() . '/assets/pictures/default-img-user-white.png';

$userIsCurrentUser = false;
if (isset($_GET['id']) && $current_user->ID ===  intval($_GET['id'])) {
    $userIsCurrentUser = true;
} else if (!isset($_GET['id']) && is_user_logged_in()) {
    $userIsCurrentUser = true;
}

// Si c’est la page d’un autre utilisateur :
$user_id = isset($_GET['id']) ? intval($_GET['id']) : $current_user->ID;

$url_doc = '';

// Récupération des infos
$user_data = get_user_profile_data($user_id);
if (!$user_data) {
    echo '<p>Utilisateur introuvable.</p>';
    get_footer();
    exit;
}

if (!empty($user_data['additionnal_file'])) {
    if(is_array(getimagesize($user_data['additionnal_file']))){
        $url_doc = $user_data['additionnal_file'];
    } else {
        $url_doc = $default_doc_img_url;
    }
}

if (isset($_POST['delete_account'])) {
    $wait = 1;
    focusantilles_deactivate_user(get_current_user_id());
    print_r('bah alors ?');

    echo '<p class="info-message">Votre compte a été désactivé et sera supprimé sous 30 jours.</p>';
}



if ($user_id) {
    $status = get_user_meta($user_id, 'account_status', true);
    if ($status === 'pending_deletion' && !empty($wait)) {
        wp_safe_redirect(site_url('/404')); // une page d’info que tu peux créer
        exit;
    }
}

// A FAIRE POUR SAVOIR LE % DU PROFIL RENSEIGNÉ
// $fields = ['user_region', 'user_postes', 'user_experiences'];
// $filled = array_filter($fields, fn($f) => !empty(get_user_meta($user_id, $f, true)));
// $progress = round((count($filled) / count($fields)) * 100);

get_header();
?>

<div class="profil-page p-r-l-40 max-height">
    <?php if (!empty($wait)) : ?>
        <div>coucou</div>
    <?php endif?>
    <div class="user-info">
        <div class="user-picture" style="background-image: url('<?php echo !empty($user_data['profile_picture']) ? esc_url($user_data['profile_picture']) : $default_user_img_url; ?>');"></div>
        <?php if (!empty($user_data['first_name'] && $user_data['last_name'])) :?>
            <h4 class="user-name"><?php echo esc_html($user_data['first_name']) . ' ' . esc_html($user_data['last_name']);?></h4>
        <?php else :?>
            <h4 class="user-name"><?php echo esc_html($user_data['display_name']);?></h4>
        <?php endif; ?>
        <div class="user-region user-section">
            <div class="sub-title">Région</div>
            <?php if (!empty($user_data['region_label'])) :?>
                <h4><?php echo esc_html($user_data['region_label']); ?></h4>
            <?php else :?>
                <span class="non-com">N.C.</span>
            <?php endif; ?>
        </div>
        <?php if ($userIsCurrentUser || $user_data['show_phone']) :?>
            <div class="user-phone user-section">
                <?php if ($userIsCurrentUser) :?>
                    <div class="sub-title">Téléphone <?php echo (empty($user_data['show_phone'])) ? '<span>- caché pour tous </span>' : '<span>- visible par tous </span>';?></div>
                <?php else :?>
                    <div class="sub-title">Téléphone</div>
                <?php endif;?>
                <?php if (!empty($user_data['phone'])) :?>
                    <h4><?php echo esc_html($user_data['phone']); ?></h4>
                <?php else :?>
                    <span class="non-com">N.C.</span>
                <?php endif; ?>
            </div>
        <?php endif; ?>
        <?php if ($userIsCurrentUser || $user_data['show_email']) :?>
            <div class="user-mail user-section">
                <?php if ($userIsCurrentUser) :?>
                    <div class="sub-title">Email <?php echo (empty($user_data['show_email'])) ? '<span>- caché pour tous </span>' : '<span>- visible par tous </span>';?></div>
                <?php else :?>
                    <div class="sub-title">Email</div>
                <?php endif;?>
                <h4><?php echo esc_html($user_data['email']); ?></h4>
            </div>
            <div class="user-post user-section">
                <div class="sub-title">Poste principale</div>
                <?php if (!empty($user_data['poste_principal_label'])) :?>
                    <h4><?php echo esc_html($user_data['poste_principal_label']); ?></h4>
                <?php else :?>
                    <span class="non-com">N.C.</span>
                <?php endif; ?>
            </div>
        <?php endif; ?>
        <div class="user-other-post user-section">
            <div class="sub-title">Autres postes</div>
            <?php if (!empty($user_data['postes_labels'])) :?>
                <?php foreach ($user_data['postes_labels'] as $poste) : 
                    echo '<h4>' . esc_html($poste) . '</h4>';
                endforeach; ?>
            <?php else :?>
                <span class="non-com">N.C.</span>
            <?php endif; ?>
        </div>
        <div class="user-permis user-section">
            <div class="sub-title">Permis</div>
            <?php if (!empty($user_data['permis_label'])) :?>
                <?php foreach ($user_data['permis_label'] as $permis) : 
                    echo '<h4>' . esc_html($permis) . '</h4>';
                endforeach; ?>
            <?php else :?>
                <span class="non-com">N.C.</span>
            <?php endif; ?>
            
        </div>
        <?php if ($userIsCurrentUser) :?>
            <div>
                <button onclick="openModal()" class="button danger">Supprimer mon compte</button>
            </div>
        <?php endif; ?>
    </div>
    <div class="container">
        <div class="container-left">
            <div class="experience">
                <h3>Mon experience</h3>
                <div class="experience-container">
                    <?php if (!empty($user_data['experiences'])) :?>
                        <?php foreach($user_data['experiences'] as $experience) :?>
                            <div class="experience-card">
                                <?php if (!empty($experience['titre'])) :?>
                                    <div>
                                        <span class="title">Titre du tournage :</span>
                                        <span class="content"><?php  echo esc_html($experience['titre']); ?></span>
                                    </div>
                                <?php endif; ?>
                                <?php if (!empty($experience['year'])) :?>
                                <div>
                                    <span class="title">Année :</span>
                                    <span class="content"> <?php  echo esc_html($experience['year']); ?></span>
                                </div>
                                <?php endif; ?>
                                <?php if (!empty($experience['prod'])) :?>
                                <div>
                                    <span class="title">Production :</span>
                                    <span class="content"> <?php  echo esc_html($experience['prod']); ?> </span>
                                </div>
                                <?php endif; ?>
                                <?php if (!empty($experience['poste'])) :?>
                                <div>
                                    <span class="title">Poste :</span>
                                    <span class="content"><?php  echo esc_html($experience['poste']); ?></span>
                                </div>
                                <?php endif; ?>
                                <?php if (!empty($experience['poste_chef'])) :?>
                                <div>
                                    <span class="title">Chef de poste :</span>
                                    <span class="content"><?php  echo esc_html($experience['poste_chef']); ?></span>
                                </div>
                                <?php endif; ?>
                                <?php if (!empty($experience['real'])) :?>
                                <div>
                                    <span class="title">Réalisateur :</span>
                                    <span class="content"><?php  echo esc_html($experience['real']); ?></span>
                                </div>
                                <?php endif; ?>
                            </div>
                        <?php endforeach; ?>
                    <?php else :?>
                        <span class="non-com">Aucune expérience renseignée pour le moment.</span>
                    <?php endif; ?>
                </div>
            </div>
            <div class="competence">
                <h3>Compétence annexe</h3>
                <div class="competence-container">
                    <?php if (!empty($user_data['competences'])) :?>
                        <?php foreach($user_data['competences'] as $competence) :?>
                            <div class="bubule"><span><?php  echo esc_html($competence); ?></span></div>
                        <?php endforeach; ?>
                    <?php else :?>
                        <span class="non-com">Aucune compétence renseignée pour le moment.</span>
                    <?php endif; ?>
                </div>
            </div>
        </div>
        <div class="container-right">
            <div class="presentation">
                <h3>Présentation</h3>
                <div class="presentation-container">
                    <?php if (!empty($user_data['description'])) :?>
                        <p class="text-prewrap"> <?php echo esc_textarea($user_data['description']); ?></p>
                    <?php else :?>
                        <span class="non-com">Aucune présentation renseignée pour le moment.</span>
                    <?php endif; ?>
                </div>
            </div>
            <div class="materiel">
                <h3>Mon matériel</h3>
                <div class="materiel-container">
                    <?php if (!empty($user_data['additionnal_file'])) :?>
                            <a class="materiel-picture" target="_blank" href="<?php echo esc_url($user_data['additionnal_file']); ?>" style="background-image: url('<?php echo esc_url($url_doc); ?>');"></a>
                    <?php else :?>
                        <span class="non-com">Aucune matériel renseigné pour le moment.</span>
                    <?php endif; ?>
                </div>
            </div>
        </div>
    </div>
    <?php if ($userIsCurrentUser) :?>
    <div class="fixed-button">
        <div class="button">
            <?php
                $edit_url = site_url('edit-profil');
                echo '<a href="' . esc_url($edit_url) . '" >Modifier</a>';
            ?>
        </div>
    </div>
    <?php endif; ?>
    <div class="modal" id="modal" style="display: none;">
        <div class="modal-close"><span onclick="closeModal()">×</span></div>
        <div class="modal-container">
            <h2>Supprimer votre comptes</h2>
            <div>
                <p>Etes vous sur de vouloir supprimer votre compte ?</p>
                <p>Si oui, votre compte sera desactivé puis supprimé au bout de 30 jours.</p>
                <p>Vous pouvez nous contacter pour reactiver ou supprimer définitivement votre compte</p>
            </div>
            <div class="modal-button">
                <button class="button" onclick="closeModal()">Annuler</button>
                <form method="post">
                    <input type="hidden" name="delete_account" value="1"></input>
                    <button type="submit" class="button danger">Supprimer mon compte</button>
                </form>
            </div>
        </div>
    </div>
</div>

<script>
    const modal = document.getElementById('modal')
    function closeModal () {
        modal.style.display = 'none';
    }
    function openModal () {
        modal.style.display = '';
    }
</script>

<?php 
    get_footer();
?>