
<?php
/* Template Name: Page Connexion */

$error_message = '';   // message d'erreur à afficher (vide si ok)
$user = null;          // on initialise la variable pour éviter "Undefined variable"

/* Si l'utilisateur est déjà connecté : on le redirige avant le chargement du header */
if ( is_user_logged_in() ) {
    wp_safe_redirect( site_url('profil') );
    exit;
}

/* Traitement du formulaire si soumis */
if ( isset($_POST['login_nonce']) && wp_verify_nonce( $_POST['login_nonce'], 'login_action' ) ) {

    // Vérifie que les champs existent
    if ( ! empty($_POST['log']) && ! empty($_POST['pwd']) ) {

        $creds = array(
            'user_login'    => sanitize_user( wp_unslash($_POST['log']) ),
            'user_password' => wp_unslash($_POST['pwd']),
            'remember'      => isset($_POST['rememberme']) ? true : false,
        );

        $user = wp_signon( $creds, false );

        if ( is_wp_error( $user ) ) {
            // Récupère le message d'erreur pour l'afficher proprement
            $error_message = $user->get_error_message();
        } else {
            // Connexion OK -> redirection
            wp_safe_redirect( site_url('profil') );
            exit;
        }

    } else {
        $error_message = 'Veuillez renseigner votre identifiant et votre mot de passe.';
    }
}

/* Ensuite on charge l'en-tête et on affiche le formulaire */
get_header();
?>

<div class="login-page max-height">
    <div class="container">
        <h2>Connexion</h2>
        <form method="post" class="login-form" novalidate>
            <?php wp_nonce_field( 'login_action', 'login_nonce' ); ?>

            <div class="input">
                <label for="log">Nom d’utilisateur ou e-mail</label>
                <input type="text" name="log" id="log" required value="<?php echo isset($_POST['log']) ? esc_attr(sanitize_user(wp_unslash($_POST['log']))) : ''; ?>" />
            </div>

            <div class="input">
                <label for="pwd">Mot de passe</label>
                <div class="password">
                    <input type="password" name="pwd" id="pwd" required />
                    <img id="img" onclick="myFunction()" src="<?php echo esc_url( get_stylesheet_directory_uri() . '/assets/icons/oeil-show.png' ); ?>" alt="Afficher/masquer le mot de passe">
                </div>
            </div>

            <!-- Affiche l'erreur si besoin -->
            <?php 
                if ( is_wp_error($user) ) {
                    echo '<p class="login-error">' . $user->get_error_message() . '</p>';
                }
            ?>
            <p class="forget-pwd"><a href="<?php echo esc_url( wp_lostpassword_url() ); ?>">Mot de passe oublié ?</a></p>

            <div class="buttons">
                <div class="button">
                <?php
                        $signin_url = site_url('inscription');
                        $signin_url = wp_registration_url();
                        echo '<a href="' . esc_url($signin_url) . '" >Créer un compte</a>';
                    ?>
                </div>
                <button class="button" type="submit">Se connecter</button>
            </div>
        </form>
    </div>
</div>

<script>
function myFunction() {
    var x = document.getElementById("pwd");
    var img = document.getElementById("img");
    var baseUrl = "<?php echo esc_js( get_stylesheet_directory_uri() . '/assets/icons/' ); ?>";

    if (x.type === "password") {
        x.type = "text";
        img.src = baseUrl + "oeil-hide.png";
    } else {
        x.type = "password";
        img.src = baseUrl + "oeil-show.png";
    }
}
</script>

<?php get_footer(); ?>