<?php
/* Template Name: Page Inscription */

if (is_user_logged_in()) {
    wp_safe_redirect(site_url('profil'));
    exit;
}

if ($_SERVER['REQUEST_METHOD'] === 'POST') {

    $username = sanitize_user($_POST['username']);
    $email = sanitize_email($_POST['email']);
    $password = $_POST['password'];

    // // Champs personnalisésd
    // $localisation = sanitize_text_field($_POST['localisation']);
    // $poste = sanitize_text_field($_POST['poste']);
    // $permis = isset($_POST['permis']) ? array_map('sanitize_text_field', $_POST['permis']) : [];

    // Vérifie si utilisateur existe
    if (!username_exists($username) && !email_exists($email)) {

        $user_id = wp_create_user($username, $password, $email);
        update_user_meta($user_id, 'user_email', sanitize_email($_POST['email']));
        if (!is_wp_error($user_id)) {
            // Sauvegarde des champs supplémentaires
            // update_user_meta($user_id, 'localisation', $localisation);
            // update_user_meta($user_id, 'poste', $poste);
            // update_user_meta($user_id, 'permis', implode(',', $permis));

            // Connecte automatiquement l'utilisateur
            wp_set_current_user($user_id);
            wp_set_auth_cookie($user_id);
            wp_safe_redirect(site_url('profil'));
            exit;
        } else {
            $error = $user_id->get_error_message();
        }
    } else {
        $error = "Ce nom d’utilisateur ou cet email existe déjà.";
    }
}

get_header();
?>

<div class="signup-page max-height">
    <div class="container">
        <h2>Créer un compte</h2>

        <?php if (!empty($error)) : ?>
            <p class="login-error"><?php echo esc_html($error); ?></p>
        <?php endif; ?>

        <form method="POST" class="signup-form">
            <div class="input">
                <label for="username">Identifiant *</label>
                <input type="text" name="username" id="username" required>
            </div>

            <div class="input">
                <label for="email">Adresse e-mail *</label>
                <input type="email" name="email" id="email" required>
            </div>

            <div class="input">
                <label for="password">Mot de passe *</label>
                <div class="password">
                    <input type="password" name="password" id="password" required>
                    <img id="img" onclick="myFunction()" src="<?php echo esc_url( get_stylesheet_directory_uri() . '/assets/icons/oeil-show.png' ); ?>" alt="Afficher/masquer le mot de passe">
                </div>
            </div>
            <button type="submit" class="button">Créer mon compte</button>
            <div class="info">
                <span class="info-texte">
                    En créant un compte, vous acceptez que vos données soient utilisées
                    pour la gestion de votre profil sur Focus Antilles, conformément à notre 
                    <a href="/politique-de-confidentialite" target="_blank">politique de confidentialité</a>.
                </span>
            </div>
        </form>
    </div>
</div>

<script>
function myFunction() {
    var x = document.getElementById("password");
    var img = document.getElementById("img");
    var baseUrl = "<?php echo esc_js( get_stylesheet_directory_uri() . '/assets/icons/' ); ?>";

    if (x.type === "password") {
        x.type = "text";
        img.src = baseUrl + "oeil-hide.png";
    } else {
        x.type = "password";
        img.src = baseUrl + "oeil-show.png";
    }
}
</script>

<?php get_footer(); ?>
