<?php
/* Template Name: Page Accueil */
get_header(); 
$image_url = wp_get_attachment_url(55);
?>

<div class="home-page">
    <div class="max-height" id="wrapper">
        <!-- <div class="site-title has-roca-two-font-family"><h1>Focus</h1> <h1>Antilles</h1></div> -->
        <div class="wrapper-container width-50 height-100 content-center p-r-l-40">
            <div class="home-h2">
                <h2>Le site qui <span>référence</span> les intermittents du spectacle dans les <span>Antilles-Guyane</span></h2>
            </div>
        </div>
        <div class="wrapper-container width-50 height-100 img p-r-l-40" style="background-image: url('<?php echo esc_url($image_url); ?>');"></div>
    </div>
    <div class="p-r-l-40 max-height search-and-about">
        <div class="search-home-bar">
            <div class="dep">
                <span>Recherche par département</span>
            </div>

            <form class="search" id="searchForm">
                <div class="search-child left">
                    <?php 
                    $departements = get_terms(array(
                        'taxonomy' => 'metier',
                        'parent'   => 0,
                        'hide_empty' => false
                    ));

                    if (!empty($departements)) :
                        echo '<select id="selectDep" name="departement">';
                        echo '<option value="">Choisir un département</option>';
                        foreach ($departements as $dep) {
                            echo '<option data-slug="' . esc_attr($dep->slug) . '" value="' . esc_attr($dep->term_id) . '">' . esc_html($dep->name) . '</option>';
                        }
                        echo '</select>';
                    endif;
                    ?>
                </div>

                <div class="search-child right">
                    <span id="selectedDep">Aucun département sélectionné</span>
                    <button class="button" type="submit">Rechercher</button>
                </div>
            </form>
        </div>

        <div class="about">
            <div class="title"><h2>À propos</h2></div>
            <div class="content">
                <div class="section">
                    <h3>Qui peut s’inscrire ?</h3>
                    <p>Ce site est ouvert à tous les techniciens résidant dans les Antilles françaises. Il s’adresse également aux professionnels partis exercer en métropole mais qui conservent un ancrage dans les DOM-TOM caribéens.</p>
                </div>
                <div class="section">
                    <h3>Fonctionnement</h3>
                    <p>Chaque technicien peut créer son profil et choisir librement les informations à partager. Le projet est entièrement bénévole et son évolution sera pensée collectivement : des techniciens, pour les techniciens.</p>
                </div>
                <div class="section">
                    <h3>Vision</h3>
                    <p>Ce site met en lumière la richesse des savoir-faire locaux et renforce la visibilité de la filière cinéma et audiovisuel dans nos territoires.</p>
                </div>
            </div>
        </div>
        <div class="contact">
            <div class="title"><h2>Contact</h2></div>
            <div class="content">
                <p>Une question ? Besoin d'aide ? Vous pouvez nous joindre via l'adresse mail <a href="mailto:contact@focus-antilles.fr">contact@focus-antilles.fr</a></p>
            </div>
        </div>
    </div>
</div>

<script>
document.addEventListener("DOMContentLoaded", function() {
    const select = document.getElementById("selectDep");
    const span = document.getElementById("selectedDep");
    const form = document.getElementById("searchForm");
    const defaultText = "Choisir un département";

    select.addEventListener("change", function() {
        const selectedOption = select.options[select.selectedIndex];
        const slug = selectedOption.getAttribute("data-slug");
        const name = selectedOption.text;

        // On met à jour le texte affiché
        if (slug) {
            span.textContent = name;
        } else {
            span.textContent = "Aucun département sélectionné";
        }

        // ⚠️ On remet le select à la valeur par défaut visuellement
        select.selectedIndex = 0;

        // Mais on garde le slug choisi en mémoire
        select.dataset.slug = slug;
    });

    form.addEventListener("submit", function(e) {
        e.preventDefault();

        const slug = select.dataset.slug;

        if (!slug) {
            return;
        }

        // Redirection vers la page du département choisi
        window.location.href = "<?php echo site_url('metier/'); ?>" + slug;
    });
});
</script>

<?php get_footer(); ?>