<?php
/* Template Name: Mot de passe oublié */

$error_message = '';

if (isset($_POST['reset_password'])) {
  $user = check_password_reset_key($_POST['key'], $_POST['login']);
  if (!is_wp_error($user)) {
      if ($_POST['pass1'] === $_POST['pass2']) {
          reset_password($user, $_POST['pass1']);
          wp_safe_redirect(site_url('connexion'));
      } else {
        $error_message = '<p>Les mots de passe ne correspondent pas.</p>';
      }
  } else {
    $error_message = $user->get_error_message();
  }
}

get_header(); 
?>

<div class="lost-password-page max-height">
  <div class="container">
    <h2>Mot de passe oublié</h2>
    <?php if (isset($_GET['login']) && isset($_GET['key'])) : ?>
      <form method="post"  class="lostpass-form">
        <input type="hidden" name="login" value="<?php echo esc_attr($_GET['login'] ?? ''); ?>">
        <input type="hidden" name="key" value="<?php echo esc_attr($_GET['key'] ?? ''); ?>">
        
        <div class="input">
            <label>Nouveau mot de passe</label>
            <input type="password" name="pass1" required>
        </div>
        <div class="input">
            <label>Confirmer le mot de passe</label>
            <input type="password" name="pass2" required>
        </div>
        <div class="error-gestion">
            <?php
              if ( isset($error_message) ) {
                  echo $error_message;
              }
            ?>
        </div>
        <button type="submit" name="reset_password" class="button">Réinitialiser le mot de passe</button>
      </form>
    <?php else : ?>
      <form method="post" class="lostpass-form">
        <div class="input">
          <label for="user_login">Adresse e-mail ou nom d’utilisateur</label>
          <input type="text" name="user_login" id="user_login" required />
        </div>
        <div class="error-gestion">
              <?php
              if ( isset($_POST['user_login']) ) {
                  $login = sanitize_text_field($_POST['user_login']);
                  $result = retrieve_password($login);

                  if ( is_wp_error($result) ) {
                      echo '<p class="error">'.$result->get_error_message().'</p>';
                  } else {
                      echo '<p class="success">Un lien de réinitialisation a été envoyé à votre adresse e-mail.</p>';
                  }
              }
              ?>
          </div>
        <button type="submit" class="button">Réinitialiser le mot de passe</button>
      </form>
    <?php endif ?>
  </div>
</div>

<?php get_footer(); ?>