<?php
/* Template Name: Confidentialité */

get_header(); 
?>

<div class="confidentiality">
    <div class="container">
        <h1>
            🔒 Politique de confidentialité – Focus Antilles
        </h1>
        <p class="update-date">
            Dernière mise à jour : <?php echo date_i18n('d F Y'); ?>
        </p>
        <div>
            <p>
                Focus Antilles accorde une grande importance à la protection de vos données personnelles.
                La présente politique de confidentialité a pour objectif de vous informer sur la manière dont nous collectons, utilisons et protégeons vos informations lorsque vous utilisez notre site internet <a href="https://focus-antilles.fr">https://focus-antilles.fr</a>.
            </p>
        </div>
       
        <h2>
            1. Responsable du traitement 
        </h2>
        <div>
            <p>
                Le responsable du traitement des données personnelles est :
            </p>
            <p>
                Focus Antilles
            </p>
            <p>
                Email : contact@focus-antilles.fr
            </p>
        </div>
        <h2>
            2. Données collectées
        </h2>
        <div>
            <p>
            Lorsque vous utilisez le Site, plusieurs types de données peuvent être collectées :
            </p>
            <ul>
                <li>
                    <h3>
                        a. Données que vous fournissez directement :
                    </h3>
                    <p>
                        Lors de la création ou de la mise à jour de votre profil :
                    </p>
                    <ul>
                        <li>
                            Nom, prénom, pseudonyme, email, numéro de téléphone (facultatif)
                        </li>
                        <li>
                            Région, métiers exercés, permis détenus
                        </li>
                        <li>
                            Photo de profil, description, expériences professionnelles, compétences, documents (ex. liste de matériel)
                        </li>
                        <li>
                            Identifiants de connexion (stockés de manière sécurisée par WordPress)
                        </li>
                    </ul>
                </li>
                <li>
                    <h3>
                        b. Données collectées automatiquement :
                    </h3>
                    <ul>
                        <li>
                        Adresse IP, navigateur, type d’appareil (collectés automatiquement par le serveur OVH à des fins de sécurité et de statistiques)
                        </li>
                    </ul>
                    <p>
                        Aucune donnée sensible (origine ethnique, opinions politiques, santé, etc.) n’est collectée.
                    </p>
                </li>
            </ul>
        </div>
        <h2>
            3. Finalités du traitement
        </h2>
        <div>
            <p>Vos données sont collectées uniquement pour :</p>
            <ul>
                <li>
                    Créer et gérer votre profil utilisateur sur le site
                </li>
                <li>
                    Permettre la mise en relation entre professionnels du spectacle
                </li>
                <li>
                    Vous permettre de modifier ou supprimer vos informations
                </li>
                <li>
                    Vous envoyer un email de réinitialisation de mot de passe si nécessaire
                </li>
                <li>
                    Améliorer l’expérience utilisateur et la sécurité du site
                </li>
            </ul>
            <p>Aucune donnée n’est utilisée à des fins publicitaires ou commerciales externes.</p>
        </div>
        <h2>
            4. Base légale du traitement
        </h2>
        <div>
            <p>
                Le traitement de vos données repose sur :
            </p>
            <ul>
                <li>
                    L’exécution d’un contrat (votre inscription et utilisation du site)
                </li>
                <li>
                    Votre consentement, notamment pour les informations rendues publiques sur votre profil
                </li>
                <li>
                    L’intérêt légitime du site pour assurer la sécurité et le bon fonctionnement du service
                </li>
            </ul>
        </div>
        <h2>
            5. Destinataires des données
        </h2>
        <div>
            <p>
                Vos données personnelles sont accessibles uniquement :
            </p>
            <ul>
                <li>
                    À l’équipe de gestion de Focus Antilles (pour la maintenance et la modération)
                </li>
                <li>
                    Aux autres utilisateurs du site, uniquement pour les informations que vous choisissez de rendre publiques (ex : métier, région, profil professionnel)
                </li>
                <li>
                    À notre hébergeur OVH (France), qui garantit la conformité RGPD et la sécurité des données
                </li>
            </ul>
            <p>
                Aucune donnée n’est transférée hors de l’Union européenne.
            </p>
        </div>
        <h2>
            6. Durée de conservation
        </h2>
        <div>
            <p>
                Vos données sont conservées tant que votre compte utilisateur est actif.
            </p>
            <p>
                En cas de suppression de votre compte, vos données sont effacées dans un délai maximum de 30 jours.
            </p>
            <p>
                Les sauvegardes techniques peuvent être conservées jusqu’à 90 jours avant suppression définitive.            </p>
        </div>
        <h2>
            7. Sécurité des données
        </h2>
        <div>
            <p>
                Vos données sont hébergées en France sur les serveurs sécurisés d’OVH.
            </p>
            <p>
                Nous mettons en œuvre des mesures techniques et organisationnelles adaptées :
            </p>
            <ul>
                <li>
                    Connexion chiffrée en HTTPS
                </li>
                <li>
                    Mises à jour régulières du CMS WordPress et des extensions
                </li>
                <li>
                    Accès administrateurs limités et protégés
                </li>
                <li>
                    Sauvegardes régulières
                </li>
            </ul>
        </div>
        <h2>
            8. Vos droits
        </h2>
        <div>
            <p>
                Conformément au RGPD, vous disposez des droits suivants :
            </p>
            <ul>
                <li>
                    Droit d’accès à vos données
                </li>
                <li>
                    Droit de rectification ou de suppression
                </li>
                <li>
                    Droit de limiter ou d’opposer le traitement
                </li>
                <li>
                    Droit à la portabilité des données
                </li>
            </ul>
            <p>
                Pour exercer ces droits, vous pouvez nous contacter à l’adresse suivante :
            </p>
            <p>
                📩 <a href="mailto:contact@focus-antilles.fr">contact@focus-antilles.fr</a>
            </p>
            <p>
                Nous vous répondrons dans un délai maximum de 30 jours.
            </p>
        </div>
        <h2>9. Cookies</h2>
        <div>
            <p>Focus Antilles utilise uniquement des cookies essentiels au fonctionnement du site (connexion, session, préférences).</p>
            <p>Aucun cookie publicitaire ni de suivi externe n’est utilisé.</p>
            <p>Si, à l’avenir, nous utilisons des cookies d’analyse ou de mesure d’audience (type Google Analytics), un bandeau de consentement apparaîtra lors de votre première visite.</p>
        </div>
        <h2>10. Liens externes</h2>
        <div>
            <p>Le site peut contenir des liens vers d’autres sites web.</p>
            <p>Focus Antilles n’est pas responsable du contenu ni des pratiques de confidentialité de ces sites tiers.</p>
        </div>
        <h2>
            11. Modification de cette politique
        </h2>
        <div>
            <p>
                Cette politique de confidentialité peut être mise à jour à tout moment pour refléter les évolutions du site ou de la réglementation.
            </p>
            <p>
                La date de dernière mise à jour est toujours indiquée en haut de la page.
            </p>
        </div>
        <h2>
            12. Contact
        </h2>
        <div>
            <p>Pour toute question relative à la protection des données personnelles :</p>
            <p>
                📩 <a href="mailto:contact@focus-antilles.fr">contact@focus-antilles.fr</a>
            </p>
        </div>
    </div>

</div>


<script>
</script>

<?php get_footer(); ?>