<?php
/**
 * Title: Header
 * Slug: inter-theme/header
 * Categories: header
 * Block Types: core/template-part/header
 * Description: Site header with site title and navigation.
 *
 * @package WordPress
 */

?>

<!DOCTYPE html>
<html <?php language_attributes(); ?>>
<head>
    <meta charset="<?php bloginfo('charset'); ?>">
    <meta name="viewport" content="width=device-width, initial-scale=1"/>
    
    <?php wp_head(); ?>
</head>

<body <?php body_class(); ?>>
    
    <?php wp_body_open(); ?>

	<header>
		<div class="header">
			<a href="<?php echo get_home_url(); ?>">
				<!-- <div class="rond"></div> -->
				<div class="go-home"></div>
			</a>
			<?php if (!wp_is_mobile()) :?>
				<div>
					<div class="button">
						<?php
						if ( is_user_logged_in() ) {
							$current_user = wp_get_current_user();
							$profil_url = site_url('profil'); // page "Mon espace" -> adapte l’URL
							echo '<a href="' . esc_url($profil_url) . '" >Mon espace</a>';
						} else {
							$signin_url = site_url('inscription');
							// $signin_url = wp_registration_url();
							echo '<a href="' . esc_url($signin_url) . '" >Créer un compte</a>';
						}
						?>
					</div>
					<div class="button">
						<?php
							if ( is_user_logged_in() ) {
								$logout_url = wp_logout_url( home_url() );
								echo '<a href="' . esc_url($logout_url) . '" >Déconnexion</a>';
							} else {
								$login_url = site_url('connexion');
								echo '<a href="' . esc_url($login_url) . '" >Connexion</a>';
							}
						?>
					</div>
				</div>
			<?php else :?>
				<button id="menu-toggle" class="menu-toggle" aria-expanded="false" aria-controls="nav-menu">
					<span class="bar"></span>
					<span class="bar"></span>
					<span class="bar"></span>
					<!-- <span class="sr-only">Ouvrir le menu</span> -->
				</button>

				<nav id="nav-menu" class="nav-menu">
					<ul>
						<li>
							<?php
								if ( is_user_logged_in() ) {
									$current_user = wp_get_current_user();
									$profil_url = site_url('profil'); // page "Mon espace" -> adapte l’URL
									echo '<a href="' . esc_url($profil_url) . '" >Mon espace</a>';
								} else {
									$signin_url = site_url('inscription');
									// $signin_url = wp_registration_url();
									echo '<a href="' . esc_url($signin_url) . '" >Créer un compte</a>';
								}
							?>
						</li>
						<li>
							<?php
								if ( is_user_logged_in() ) {
									$logout_url = wp_logout_url( home_url() );
									echo '<a href="' . esc_url($logout_url) . '" >Déconnexion</a>';
								} else {
									$login_url = site_url('connexion');
									echo '<a href="' . esc_url($login_url) . '" >Connexion</a>';
								}
							?>
						</li>
					</ul>
				</nav>
			<?php endif; ?>
		</div>
	</header>


	<script>
		const menuToggle = document.getElementById('menu-toggle');
		const navMenu = document.getElementById('nav-menu');

		menuToggle.addEventListener('click', () => {
			const isOpen = navMenu.classList.toggle('open');
			menuToggle.classList.toggle('active');
			menuToggle.setAttribute('aria-expanded', isOpen);
		});
	</script>