<?php

function mon_theme_enqueue_styles() {

    // Charger la feuille de style du thème parent (si elle existe)
    wp_enqueue_style(
        'parent-style',
        get_template_directory_uri() . '/style.css'
    );

    // Charger ton reset CSS
    wp_enqueue_style(
        'reset-style',
        get_stylesheet_directory_uri() . '/css/reset.css',
        array('parent-style'), // dépend du style parent
        filemtime(get_stylesheet_directory() . '/css/reset.css') // met à jour automatiquement la version
    );

    // Charger ton style principal du thème enfant
    wp_enqueue_style(
        'child-style',
        get_stylesheet_directory_uri() . '/style.css',
        array('reset-style'),
        filemtime(get_stylesheet_directory() . '/style.css')
    );
}
add_action('wp_enqueue_scripts', 'mon_theme_enqueue_styles');

function theme_enqueue_styles() {
    // Police Montserrat via Google Fonts
    wp_enqueue_style('theme-fonts', 'https://fonts.googleapis.com/css2?family=Montserrat:wght@300;400;500;600;700&display=swap', false);
}
add_action('wp_enqueue_scripts', 'theme_enqueue_styles');

// Ajout des champs dans le profil admin WordPress
function custom_user_profile_fields($user) {
    ?>
    <h3>Informations supplémentaires</h3>
    <table class="form-table">
        <tr>
            <th><label for="localisation">Localisation</label></th>
            <td>
                <input type="text" name="localisation" id="localisation" 
                       value="<?php echo esc_attr(get_user_meta($user->ID, 'localisation', true)); ?>" 
                       class="regular-text" />
            </td>
        </tr>
        <tr>
            <th><label for="permis">Permis</label></th>
            <td>
                <input type="text" name="permis" id="permis" 
                       value="<?php echo esc_attr(get_user_meta($user->ID, 'permis', true)); ?>" 
                       class="regular-text" />
            </td>
        </tr>
    </table>
    <?php
}
add_action('show_user_profile', 'custom_user_profile_fields');
add_action('edit_user_profile', 'custom_user_profile_fields');

// Sauvegarde des champs
function save_custom_user_profile_fields($user_id) {
    if (!current_user_can('edit_user', $user_id)) return false;

    update_user_meta($user_id, 'localisation', sanitize_text_field($_POST['localisation']));
    update_user_meta($user_id, 'permis', sanitize_text_field($_POST['permis']));
}
add_action('personal_options_update', 'save_custom_user_profile_fields');
add_action('edit_user_profile_update', 'save_custom_user_profile_fields');

add_action( 'init', function() {
    global $pagenow;
    if ( 'wp-login.php' === $pagenow && isset($_GET['action']) && $_GET['action'] === 'lostpassword' ) {
        wp_redirect( site_url('mot-de-passe-oublie/') );
        exit;
    }
});

function montheme_register_metier() {
    register_taxonomy('metier', 'post', [
        'labels' => [
            'name' => 'Métier',
            'singular_name'     => 'Métier',
            'plural_name'       => 'Métiers',
            'search_items'      => 'Rechercher des métiers',
            'all_items'         => 'Tous les métiers',
            'edit_item'         => 'Editer le métier',
            'update_item'       => 'Mettre à jour le métier',
            'add_new_item'      => 'Ajouter un nouveau métier',
            'new_item_name'     => 'Ajouter un nouveau métier',
            'menu_name'         => 'Métier',
        ],
        'show_in_rest' => true,
        'hierarchical' => true,
        'show_admin_column' => true,
    ]);
}
add_action('init', 'montheme_register_metier');

function montheme_register_permis() {
    register_taxonomy('permis', 'post', [
        'labels' => [
            'name' => 'Permis',
            'singular_name'     => 'Permis',
            'plural_name'       => 'Permis',
            'search_items'      => 'Rechercher des permis',
            'all_items'         => 'Tous les permis',
            'edit_item'         => 'Editer le permis',
            'update_item'       => 'Mettre à jour le permis',
            'add_new_item'      => 'Ajouter un nouveau permis',
            'new_item_name'     => 'Ajouter un nouveau permis',
            'menu_name'         => 'Permis',
        ],
        'show_in_rest' => true,
        'hierarchical' => true,
        'show_admin_column' => true,
    ]);
}
add_action('init', 'montheme_register_permis');

function montheme_register_region() {
    register_taxonomy('region', 'post', [
        'labels' => [
            'name' => 'Région',
            'singular_name'     => 'Région',
            'plural_name'       => 'Régions',
            'search_items'      => 'Rechercher des régions',
            'all_items'         => 'Toutes les régions',
            'edit_item'         => 'Editer le permis',
            'update_item'       => 'Mettre à jour la régions',
            'add_new_item'      => 'Ajouter une nouvelle région',
            'new_item_name'     => 'Ajouter une nouvelle région',
            'menu_name'         => 'Région',
        ],
        'show_in_rest' => true,
        'hierarchical' => true,
        'show_admin_column' => true,
    ]);
}
add_action('init', 'montheme_register_region');

function get_user_profile_data($user_id) {
    if (!$user_id) return null;

    $user = get_userdata($user_id);
    if (!$user) return null;

    // Récupération propre des metas
    $data = [
        'id'               => $user->ID,
        'display_name'     => $user->display_name,
        'email'            => $user->user_email,
        'phone'            => get_user_meta($user_id, 'phone', true),
        'first_name'       => $user->first_name,
        'last_name'        =>  $user->last_name,
        'profile_picture'  => get_user_meta($user_id, 'profile_picture', true),
        'region'           => get_user_meta($user_id, 'region', true),
        'permis'           => (array) get_user_meta($user_id, 'permis', true),
        'postes'           => (array) get_user_meta($user_id, 'postes', true),
        'poste_principal'  => get_user_meta($user_id, 'poste_principal', true),
        'show_phone'       => get_user_meta($user_id, 'show_phone', true),
        'show_email'       => get_user_meta($user_id, 'show_email', true),
        'description'      => get_user_meta($user_id, 'description', true),
        'additionnal_file' => get_user_meta($user_id, 'additionnal_file', true),
    ];

    $experiences = get_user_meta($user_id, 'experiences', true);
    $competences = get_user_meta($user_id, 'competences', true);

    // Récupération des experiences
    if (!empty($experiences)) {
        $data['experiences'] = (array) $experiences;
    } else {
        $data['experiences'] = [];
    }

    if (!empty($competences)) {
        $data['competences'] = (array) $competences;
    } else {
        $data['competences'] = [];
    }

    // Récupération lisible du poste principal (taxonomy)
    if (!empty($data['poste_principal'])) {
        $term = get_term($data['poste_principal'], 'metier');
        if ($term && !is_wp_error($term)) {
            $data['poste_principal_label'] = $term->name;
        }
    }

    // Récupération des postes multiples (taxonomy)
    if (!empty($data['postes'])) {
        $data['postes_labels'] = [];
        foreach ($data['postes'] as $pid) {
            $term = get_term($pid, 'metier');
            if ($term && !is_wp_error($term)) {
                $data['postes_labels'][] = $term->name;
            }
        }
    }

     // Récupération des permis multiples (taxonomy)
     if (!empty($data['permis'])) {
        $data['permis_label'] = [];
        foreach ($data['permis'] as $pid) {
            $term = get_term($pid, 'permis');
            if ($term && !is_wp_error($term)) {
                $data['permis_label'][] = $term->name;
            }
        }
    }

    // Récupération de la région (taxonomy)
    if (!empty($data['region'])) {
        $data['region_label'] = '';
        $term = get_term($data['region'], 'region');
        $data['region_label'] = $term->name;
    }

    return $data;
}


add_action('wp_ajax_load_users', 'ajax_load_users');
add_action('wp_ajax_nopriv_load_users', 'ajax_load_users');

function ajax_load_users() {
    $paged = isset($_POST['paged']) ? intval($_POST['paged']) : 1;
    $posts_per_page = 10;

    $filters = json_decode(stripslashes($_POST['filters'] ?? '{}'), true);
    // $dep = $_POST['dep'] ?? [];

    $args = [
        'role'    => 'Subscriber',
        'number'  => $posts_per_page,
        'paged'   => $paged,
        'meta_query' => [
            'relation' => 'AND', // toutes les conditions doivent matcher
        ]
    ];

    // SET UP DE BASE
    
    if (!empty($filters['metiers'])) {
        $metier_ids = array_map('intval', (array)$filters['metiers']);

        $or_postes = ['relation' => 'OR'];

        foreach ($metier_ids as $id) {
            $or_postes[] = [
                'key'     => 'postes',
                'value'   => 'i:' . $id . ';',
                'compare' => 'LIKE',
            ];
        }

        $args['meta_query'][] = [
            'relation' => 'OR',
            [
                'key'     => 'poste_principal',
                'value'   => $metier_ids,
                'compare' => 'IN'
            ],
            $or_postes,
        ];
    }

    $args['meta_query'][] = [
        'relation' => 'OR',
        [
            'key'     => 'account_status',
            'compare' => 'NOT EXISTS',
        ],
        [
            'key'     => 'account_status',
            'value'   => 'pending_deletion',
            'compare' => '!=',
        ],
    ];


    // $args['meta_query'][] = [
    //     [
    //         'key'     => 'account_status',
    //         'value'   => 'pending_deletion',
    //         'compare' => '!='
    //     ],
    // ];

    // Exemple : filtrer par région
    if (!empty($filters['region'])) {

        $regions_ids = array_map('intval', (array)$filters['region']);

        $or_postes = ['relation' => 'OR'];

        foreach ($regions_ids as $id) {
            $or_postes[] = [
                'key'     => 'region',
                'value'   => $id,
                'compare' => '=',
            ];
        }

        $args['meta_query'][] = [
            'relation' => 'OR',
            $or_postes,
        ];
    }

    // Exemple : filtrer par poste
    if (!empty($filters['postes'])) {
        $postes_ids = array_map('intval', (array)$filters['postes']);

        $or_postes = ['relation' => 'OR'];

        foreach ($postes_ids as $id) {
            $or_postes[] = [
                'key'     => 'postes',
                'value'   => 'i:' . $id . ';',
                'compare' => 'LIKE',
            ];
        }

        $args['meta_query'][] = [
            'relation' => 'OR',
            [
                'key'     => 'poste_principal',
                'value'   => $postes_ids,
                'compare' => 'IN'
            ],
            $or_postes,
        ];
    }

    // if (!empty($filters['permis'])) {
            
    //     foreach ((array)$filters['permis'] as $id) {
    //         $id = intval($id);
    //         // Chaque permis doit chercher la séquence 'i:ID;' dans la valeur sérialisée
    //         $permis_conditions[] = [
    //             'key'     => 'permis',
    //             'value'   => 'i:' . $id . ';',
    //             'compare' => 'LIKE',
    //         ];
    //     }
    
    //     // on ajoute le bloc "OR" à la meta_query globale
    //     $args['meta_query'][] = $permis_conditions;
    // }

    // Exemple : filtrer par permis
    if (!empty($filters['permis'])) {
        $permis_conditions = ['relation' => 'OR'];
    
        foreach ((array)$filters['permis'] as $id) {
            $id = (string)intval($id);
            $len = strlen($id);
            // Chaque permis doit chercher la séquence 'i:ID;' dans la valeur sérialisée
            $permis_conditions[] = [
                'key'     => 'permis',
                'value'   => 's:' . $len . ':"' . $id . '";',
                'compare' => 'LIKE',
            ];
        }
    
        // on ajoute le bloc "OR" à la meta_query globale
        $args['meta_query'][] = $permis_conditions;
    }

    $user_query = new WP_User_Query($args);
    $users = $user_query->get_results();
    $total = $user_query->get_total();
    ob_start();
    $default_user_img_url = get_stylesheet_directory_uri() . '/assets/pictures/default-img-user.png';
    foreach ($users as $user) {
        

        $meta = get_user_meta($user->ID);
        $term = get_term($meta['region'][0], 'region');
        $regionLabel = $term->name;
        ?>
        <div class="tech-card">
            <a href="<?php echo site_url('profil') . '?id=' . esc_html($user->ID); ?>">
                <div class="background-picture" style="background-image: url('<?php echo !empty($meta['profile_picture'][0]) ? esc_url($meta['profile_picture'][0]) :  esc_url($default_user_img_url); ?>');"></div>
                <div class="etiquette">
                    <h4><?php echo esc_html($meta['first_name'][0]) . ' ' . esc_html($meta['last_name'][0]); ?></h4>
                    <span><?php echo esc_html($regionLabel); ?></span>
                </div>
                <span>
                </span>
            </a>
        </div>
        <?php
    }
    $html = ob_get_clean();

    wp_send_json([
        'html' => $html,
        'has_more' => count($users) === $posts_per_page,
        'query' => $args,
        'total' => $total
    ]);
}

// function redirect_mobile_users() {
//     if (wp_is_mobile() && !is_page('mobile-bloque')) {
//         wp_safe_redirect(site_url('mobile-bloque'));
//         exit;
//     }
// }
// add_action('template_redirect', 'redirect_mobile_users');


add_filter('retrieve_password_title', function($title, $user_login, $user_data) {
    return '🔑 Réinitialisation de votre mot de passe - Focus Antilles';
}, 10, 3);

add_filter('retrieve_password_message', function($message, $key, $user_login, $user_data) {
    $custom_reset_link = site_url("mot-de-passe-oublie/?key=$key&login=" . rawurlencode($user_login));
    $message = "Bonjour $user_login,\n\nCliquez sur le lien suivant pour réinitialiser votre mot de passe :\n";
    $message .= $custom_reset_link . "\n\nMerci,\nL’équipe Focus Antilles";
    return $message;
}, 10, 4);


function focus_limit_file_upload_size( $file ) {
    $max_size_mb = 5; // 💡 Taille max autorisée : ici 5 Mo
    $max_size_bytes = $max_size_mb * 1024 * 1024;

    if ( $file['size'] > $max_size_bytes ) {
        $file['error'] = "Le fichier dépasse la taille maximale autorisée de {$max_size_mb} Mo.";
    }

    return $file;
}
add_filter( 'wp_handle_upload_prefilter', 'focus_limit_file_upload_size' );

function focus_allowed_mime_types( $mimes ) {
    return [
        'jpg|jpeg|jpe' => 'image/jpeg',
        'png'          => 'image/png',
        'pdf'          => 'application/pdf',
        'xls|xlsx'     => 'application/vnd.openxmlformats-officedocument.spreadsheetml.sheet',
        'ods'          => 'application/vnd.oasis.opendocument.spreadsheet',
    ];
}
add_filter( 'upload_mimes', 'focus_allowed_mime_types' );


// Désactiver temporairement un utilisateur
function focusantilles_deactivate_user($user_id) {
    print_r('focusantilles_deactivate_user ?');
    update_user_meta($user_id, 'account_status', 'pending_deletion');
    print_r('normalement on a update le user ?');
    update_user_meta($user_id, 'deletion_requested_at', current_time('mysql'));

    // Déconnecter l'utilisateur immédiatement
    wp_destroy_current_session();
    wp_clear_auth_cookie();
}

add_filter('authenticate', function($user, $username, $password) {
    if ($user instanceof WP_User) {
        $status = get_user_meta($user->ID, 'account_status', true);
        if ($status === 'pending_deletion') {
            return new WP_Error(
                'account_pending_deletion',
                'Votre compte est en cours de suppression (réactivation impossible).'
            );
        }
    }
    return $user;
}, 30, 3);


// Planifier la vérification quotidienne si elle n'existe pas déjà
if (!wp_next_scheduled('focusantilles_delete_expired_users')) {
    wp_schedule_event(time(), 'daily', 'focusantilles_delete_expired_users');
}

// Fonction appelée par le cron
add_action('focusantilles_delete_expired_users', function() {
    $users = get_users([
        'meta_key'   => 'account_status',
        'meta_value' => 'pending_deletion'
    ]);

    foreach ($users as $user) {
        $requested_at = get_user_meta($user->ID, 'deletion_requested_at', true);
        if ($requested_at && strtotime($requested_at) <= strtotime('-30 days')) {
            // Supprimer définitivement
            require_once(ABSPATH.'wp-admin/includes/user.php');
            wp_delete_user($user->ID);
        }
    }
});


// add_action('pre_user_query', function($query) {
//     global $wpdb;

//     // Vérifie qu'on ne touche pas au back-office
//     if (is_admin()) return;

//     // Ne rien faire si c’est une requête système
//     if (empty($query->query_vars['fields']) || $query->query_vars['fields'] === 'ID') return;

//     // Jointure sur les métadonnées du user
//     $query->query_from .= " LEFT JOIN {$wpdb->usermeta} AS um_del 
//                             ON {$wpdb->users}.ID = um_del.user_id 
//                             AND um_del.meta_key = 'account_status'";

//     // Exclure ceux qui ont 'pending_deletion'
//     $query->query_where .= " AND (um_del.meta_value IS NULL OR um_del.meta_value != 'pending_deletion')";
//     print_r('$query');
//     print_r($query);
// });

// // Exclure les utilisateurs en cours de suppression (pending_deletion)
// add_filter('get_users', function($users) {
//     // Ne rien faire si on est dans l’admin
//     if (is_admin()) return $users;

//     // Filtrer les utilisateurs
//     $filtered = [];
//     foreach ($users as $user) {
//         $status = get_user_meta($user->ID, 'account_status', true);
//         if ($status !== 'pending_deletion') {
//             $filtered[] = $user;
//         }
//     }

//     return $filtered;
// });



// ADMIN USER DELETE 

// Ajouter une colonne dans la liste des utilisateurs
add_filter('manage_users_columns', function($columns) {
    $columns['account_status'] = 'Statut du compte';
    return $columns;
});

add_filter('manage_users_custom_column', function($output, $column_name, $user_id) {
    if ($column_name === 'account_status') {
        $status = get_user_meta($user_id, 'account_status', true);
        if ($status === 'pending_deletion') {
            $output = '<span style="color:#e67e22;">En attente de suppression</span>';
        } else {
            $output = '<span style="color:#27ae60;">Actif</span>';
        }
    }
    return $output;
}, 10, 3);


// Ajouter des actions sous chaque utilisateur
add_filter('user_row_actions', function($actions, $user) {
    if (current_user_can('delete_users')) {
        $status = get_user_meta($user->ID, 'account_status', true);

        if ($status === 'pending_deletion') {
            $reactivate_url = wp_nonce_url(
                add_query_arg([
                    'action' => 'reactivate_user',
                    'user_id' => $user->ID
                ], admin_url('users.php')),
                'reactivate_user_' . $user->ID
            );
            $delete_url = wp_nonce_url(
                add_query_arg([
                    'action' => 'delete_user_final',
                    'user_id' => $user->ID
                ], admin_url('users.php')),
                'delete_user_final_' . $user->ID
            );

            $actions['reactivate_user'] = '<a href="' . esc_url($reactivate_url) . '" style="color:#27ae60;">Réactiver</a>';
            $actions['delete_user_final'] = '<a href="' . esc_url($delete_url) . '" style="color:#c0392b;">Supprimer définitivement</a>';
        }
    }

    return $actions;
}, 10, 2);

add_action('admin_init', function() {
    if (!current_user_can('delete_users')) return;

    // Réactivation
    if (isset($_GET['action'], $_GET['user_id']) && $_GET['action'] === 'reactivate_user') {
        $user_id = intval($_GET['user_id']);
        check_admin_referer('reactivate_user_' . $user_id);

        delete_user_meta($user_id, 'account_status');
        wp_safe_redirect(admin_url('users.php?user-reactivated=1'));
        exit;
    }

    // Suppression définitive
    if (isset($_GET['action'], $_GET['user_id']) && $_GET['action'] === 'delete_user_final') {
        $user_id = intval($_GET['user_id']);
        check_admin_referer('delete_user_final_' . $user_id);

        require_once(ABSPATH . 'wp-admin/includes/user.php');
        wp_delete_user($user_id);
        wp_safe_redirect(admin_url('users.php?user-deleted=1'));
        exit;
    }
});

add_action('admin_notices', function() {
    if (isset($_GET['user-reactivated'])) {
        echo '<div class="notice notice-success"><p>✅ L’utilisateur a été réactivé avec succès.</p></div>';
    }
    if (isset($_GET['user-deleted'])) {
        echo '<div class="notice notice-success"><p>🗑️ L’utilisateur a été supprimé définitivement.</p></div>';
    }
});
