/* DUPLICATOR-LITE (PHP BUILD MODE) MYSQL SCRIPT CREATED ON : 2025-10-24 19:06:46 */

/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;

SET FOREIGN_KEY_CHECKS = 0;

CREATE TABLE `inter_actionscheduler_actions` (
  `action_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `hook` varchar(191) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `status` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `scheduled_date_gmt` datetime DEFAULT '0000-00-00 00:00:00',
  `scheduled_date_local` datetime DEFAULT '0000-00-00 00:00:00',
  `priority` tinyint unsigned NOT NULL DEFAULT '10',
  `args` varchar(191) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `schedule` longtext COLLATE utf8mb4_unicode_520_ci,
  `group_id` bigint unsigned NOT NULL DEFAULT '0',
  `attempts` int NOT NULL DEFAULT '0',
  `last_attempt_gmt` datetime DEFAULT '0000-00-00 00:00:00',
  `last_attempt_local` datetime DEFAULT '0000-00-00 00:00:00',
  `claim_id` bigint unsigned NOT NULL DEFAULT '0',
  `extended_args` varchar(8000) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  PRIMARY KEY (`action_id`),
  KEY `hook_status_scheduled_date_gmt` (`hook`(163),`status`,`scheduled_date_gmt`),
  KEY `status_scheduled_date_gmt` (`status`,`scheduled_date_gmt`),
  KEY `scheduled_date_gmt` (`scheduled_date_gmt`),
  KEY `args` (`args`),
  KEY `group_id` (`group_id`),
  KEY `last_attempt_gmt` (`last_attempt_gmt`),
  KEY `claim_id_status_scheduled_date_gmt` (`claim_id`,`status`,`scheduled_date_gmt`)
) ENGINE=InnoDB AUTO_INCREMENT=86 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `inter_actionscheduler_claims` (
  `claim_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `date_created_gmt` datetime DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`claim_id`),
  KEY `date_created_gmt` (`date_created_gmt`)
) ENGINE=InnoDB AUTO_INCREMENT=17 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `inter_actionscheduler_groups` (
  `group_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `slug` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  PRIMARY KEY (`group_id`),
  KEY `slug` (`slug`(191))
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `inter_actionscheduler_logs` (
  `log_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `action_id` bigint unsigned NOT NULL,
  `message` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `log_date_gmt` datetime DEFAULT '0000-00-00 00:00:00',
  `log_date_local` datetime DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`log_id`),
  KEY `action_id` (`action_id`),
  KEY `log_date_gmt` (`log_date_gmt`)
) ENGINE=InnoDB AUTO_INCREMENT=11 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `inter_commentmeta` (
  `meta_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `comment_id` bigint unsigned NOT NULL DEFAULT '0',
  `meta_key` varchar(255) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `meta_value` longtext COLLATE utf8mb4_unicode_520_ci,
  PRIMARY KEY (`meta_id`),
  KEY `comment_id` (`comment_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `inter_comments` (
  `comment_ID` bigint unsigned NOT NULL AUTO_INCREMENT,
  `comment_post_ID` bigint unsigned NOT NULL DEFAULT '0',
  `comment_author` tinytext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `comment_author_email` varchar(100) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `comment_author_url` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `comment_author_IP` varchar(100) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `comment_date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `comment_date_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `comment_content` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `comment_karma` int NOT NULL DEFAULT '0',
  `comment_approved` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '1',
  `comment_agent` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `comment_type` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'comment',
  `comment_parent` bigint unsigned NOT NULL DEFAULT '0',
  `user_id` bigint unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`comment_ID`),
  KEY `comment_post_ID` (`comment_post_ID`),
  KEY `comment_approved_date_gmt` (`comment_approved`,`comment_date_gmt`),
  KEY `comment_date_gmt` (`comment_date_gmt`),
  KEY `comment_parent` (`comment_parent`),
  KEY `comment_author_email` (`comment_author_email`(10))
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `inter_duplicator_packages` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(250) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `hash` varchar(50) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `status` int NOT NULL,
  `created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `owner` varchar(60) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `package` longtext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  PRIMARY KEY (`id`),
  KEY `hash` (`hash`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `inter_links` (
  `link_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `link_url` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `link_name` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `link_image` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `link_target` varchar(25) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `link_description` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `link_visible` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'Y',
  `link_owner` bigint unsigned NOT NULL DEFAULT '1',
  `link_rating` int NOT NULL DEFAULT '0',
  `link_updated` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `link_rel` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `link_notes` mediumtext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `link_rss` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`link_id`),
  KEY `link_visible` (`link_visible`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `inter_options` (
  `option_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `option_name` varchar(191) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `option_value` longtext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `autoload` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'yes',
  PRIMARY KEY (`option_id`),
  UNIQUE KEY `option_name` (`option_name`),
  KEY `autoload` (`autoload`)
) ENGINE=InnoDB AUTO_INCREMENT=2168 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `inter_postmeta` (
  `meta_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `post_id` bigint unsigned NOT NULL DEFAULT '0',
  `meta_key` varchar(255) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `meta_value` longtext COLLATE utf8mb4_unicode_520_ci,
  PRIMARY KEY (`meta_id`),
  KEY `post_id` (`post_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=InnoDB AUTO_INCREMENT=122 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `inter_posts` (
  `ID` bigint unsigned NOT NULL AUTO_INCREMENT,
  `post_author` bigint unsigned NOT NULL DEFAULT '0',
  `post_date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_date_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_content` longtext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `post_title` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `post_excerpt` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `post_status` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'publish',
  `comment_status` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'open',
  `ping_status` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'open',
  `post_password` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `post_name` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `to_ping` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `pinged` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `post_modified` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_modified_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_content_filtered` longtext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `post_parent` bigint unsigned NOT NULL DEFAULT '0',
  `guid` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `menu_order` int NOT NULL DEFAULT '0',
  `post_type` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'post',
  `post_mime_type` varchar(100) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `comment_count` bigint NOT NULL DEFAULT '0',
  PRIMARY KEY (`ID`),
  KEY `post_name` (`post_name`(191)),
  KEY `type_status_date` (`post_type`,`post_status`,`post_date`,`ID`),
  KEY `post_parent` (`post_parent`),
  KEY `post_author` (`post_author`)
) ENGINE=InnoDB AUTO_INCREMENT=104 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `inter_term_relationships` (
  `object_id` bigint unsigned NOT NULL DEFAULT '0',
  `term_taxonomy_id` bigint unsigned NOT NULL DEFAULT '0',
  `term_order` int NOT NULL DEFAULT '0',
  PRIMARY KEY (`object_id`,`term_taxonomy_id`),
  KEY `term_taxonomy_id` (`term_taxonomy_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `inter_term_taxonomy` (
  `term_taxonomy_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `term_id` bigint unsigned NOT NULL DEFAULT '0',
  `taxonomy` varchar(32) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `description` longtext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `parent` bigint unsigned NOT NULL DEFAULT '0',
  `count` bigint NOT NULL DEFAULT '0',
  PRIMARY KEY (`term_taxonomy_id`),
  UNIQUE KEY `term_id_taxonomy` (`term_id`,`taxonomy`),
  KEY `taxonomy` (`taxonomy`)
) ENGINE=InnoDB AUTO_INCREMENT=127 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `inter_termmeta` (
  `meta_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `term_id` bigint unsigned NOT NULL DEFAULT '0',
  `meta_key` varchar(255) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `meta_value` longtext COLLATE utf8mb4_unicode_520_ci,
  PRIMARY KEY (`meta_id`),
  KEY `term_id` (`term_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `inter_terms` (
  `term_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `slug` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `term_group` bigint NOT NULL DEFAULT '0',
  PRIMARY KEY (`term_id`),
  KEY `slug` (`slug`(191)),
  KEY `name` (`name`(191))
) ENGINE=InnoDB AUTO_INCREMENT=127 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `inter_usermeta` (
  `umeta_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `user_id` bigint unsigned NOT NULL DEFAULT '0',
  `meta_key` varchar(255) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `meta_value` longtext COLLATE utf8mb4_unicode_520_ci,
  PRIMARY KEY (`umeta_id`),
  KEY `user_id` (`user_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=InnoDB AUTO_INCREMENT=509 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `inter_users` (
  `ID` bigint unsigned NOT NULL AUTO_INCREMENT,
  `user_login` varchar(60) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `user_pass` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `user_nicename` varchar(50) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `user_email` varchar(100) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `user_url` varchar(100) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `user_registered` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `user_activation_key` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `user_status` int NOT NULL DEFAULT '0',
  `display_name` varchar(250) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`ID`),
  KEY `user_login_key` (`user_login`),
  KEY `user_nicename` (`user_nicename`),
  KEY `user_email` (`user_email`)
) ENGINE=InnoDB AUTO_INCREMENT=21 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `inter_wpmailsmtp_debug_events` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `content` text COLLATE utf8mb4_unicode_520_ci,
  `initiator` text COLLATE utf8mb4_unicode_520_ci,
  `event_type` tinyint unsigned NOT NULL DEFAULT '0',
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `inter_wpmailsmtp_tasks_meta` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `action` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `data` longtext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `date` datetime NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

/***** TABLE CREATION END *****/


/* INSERT TABLE DATA: inter_actionscheduler_actions */
INSERT INTO `inter_actionscheduler_actions` VALUES("82", "action_scheduler/migration_hook", "complete", "2025-10-20 18:23:59", "2025-10-20 20:23:59", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1760984639;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1760984639;}", "1", "1", "2025-10-20 18:24:12", "2025-10-20 20:24:12", "0", NULL);
INSERT INTO `inter_actionscheduler_actions` VALUES("83", "wp_mail_smtp_summary_report_email", "canceled", "2025-10-27 13:00:00", "2025-10-27 14:00:00", "10", "[null]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1761570000;s:18:\"\0*\0first_timestamp\";i:1761570000;s:13:\"\0*\0recurrence\";i:604800;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1761570000;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:604800;}", "2", "0", "0000-00-00 00:00:00", "0000-00-00 00:00:00", "0", NULL);
INSERT INTO `inter_actionscheduler_actions` VALUES("84", "wp_mail_smtp_admin_notifications_update", "complete", "2025-10-20 18:25:15", "2025-10-20 20:25:15", "10", "[1]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1760984715;s:18:\"\0*\0first_timestamp\";i:1760984715;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1760984715;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "2", "1", "2025-10-20 18:25:22", "2025-10-20 20:25:22", "0", NULL);
INSERT INTO `inter_actionscheduler_actions` VALUES("85", "wp_mail_smtp_admin_notifications_update", "canceled", "2025-10-21 18:25:22", "2025-10-21 20:25:22", "10", "[1]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1761071122;s:18:\"\0*\0first_timestamp\";i:1760984715;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1761071122;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "2", "0", "0000-00-00 00:00:00", "0000-00-00 00:00:00", "0", NULL);

/* INSERT TABLE DATA: inter_actionscheduler_groups */
INSERT INTO `inter_actionscheduler_groups` VALUES("1", "action-scheduler-migration");
INSERT INTO `inter_actionscheduler_groups` VALUES("2", "wp_mail_smtp");

/* INSERT TABLE DATA: inter_actionscheduler_logs */
INSERT INTO `inter_actionscheduler_logs` VALUES("1", "82", "action created", "2025-10-20 18:22:59", "2025-10-20 20:22:59");
INSERT INTO `inter_actionscheduler_logs` VALUES("2", "82", "action started via WP Cron", "2025-10-20 18:24:12", "2025-10-20 20:24:12");
INSERT INTO `inter_actionscheduler_logs` VALUES("3", "82", "action complete via WP Cron", "2025-10-20 18:24:12", "2025-10-20 20:24:12");
INSERT INTO `inter_actionscheduler_logs` VALUES("4", "83", "action created", "2025-10-20 18:24:15", "2025-10-20 20:24:15");
INSERT INTO `inter_actionscheduler_logs` VALUES("5", "84", "action created", "2025-10-20 18:24:15", "2025-10-20 20:24:15");
INSERT INTO `inter_actionscheduler_logs` VALUES("6", "84", "action started via WP Cron", "2025-10-20 18:25:22", "2025-10-20 20:25:22");
INSERT INTO `inter_actionscheduler_logs` VALUES("7", "84", "action complete via WP Cron", "2025-10-20 18:25:22", "2025-10-20 20:25:22");
INSERT INTO `inter_actionscheduler_logs` VALUES("8", "85", "action created", "2025-10-20 18:25:22", "2025-10-20 20:25:22");
INSERT INTO `inter_actionscheduler_logs` VALUES("9", "85", "action canceled", "2025-10-20 18:39:44", "2025-10-20 20:39:44");
INSERT INTO `inter_actionscheduler_logs` VALUES("10", "83", "action canceled", "2025-10-20 18:39:44", "2025-10-20 20:39:44");

/* INSERT TABLE DATA: inter_comments */
INSERT INTO `inter_comments` VALUES("1", "1", "Un commentateur ou commentatrice WordPress", "wapuu@wordpress.example", "https://fr.wordpress.org/", "", "2025-09-23 20:25:50", "2025-09-23 18:25:50", "Bonjour, ceci est un commentaire.\nPour débuter avec la modération, la modification et la suppression de commentaires, veuillez visiter l’écran des Commentaires dans le Tableau de bord.\nLes avatars des personnes qui commentent arrivent depuis <a href=\"https://fr.gravatar.com/\">Gravatar</a>.", "0", "post-trashed", "", "comment", "0", "0");

/* INSERT TABLE DATA: inter_duplicator_packages */
INSERT INTO `inter_duplicator_packages` VALUES("1", "20251021_focusantilles", "3f68925b0d8b89274986_20251021205704", "100", "2025-10-21 20:57:08", "ambre_palanque", "O:11:\"DUP_Package\":23:{s:7:\"Created\";s:19:\"2025-10-21 20:57:04\";s:7:\"Version\";s:6:\"1.5.14\";s:9:\"VersionWP\";s:5:\"6.8.3\";s:9:\"VersionDB\";s:6:\"8.0.40\";s:10:\"VersionPHP\";s:6:\"8.3.14\";s:9:\"VersionOS\";s:6:\"Darwin\";s:2:\"ID\";i:1;s:4:\"Name\";s:22:\"20251021_focusantilles\";s:4:\"Hash\";s:35:\"3f68925b0d8b89274986_20251021205704\";s:8:\"NameHash\";s:58:\"20251021_focusantilles_3f68925b0d8b89274986_20251021205704\";s:4:\"Type\";i:0;s:5:\"Notes\";s:0:\"\";s:8:\"ScanFile\";s:68:\"20251021_focusantilles_3f68925b0d8b89274986_20251021205704_scan.json\";s:10:\"TimerStart\";i:-1;s:7:\"Runtime\";s:9:\"9.61 sec.\";s:7:\"ExeSize\";s:7:\"73.49KB\";s:7:\"ZipSize\";s:7:\"62.54MB\";s:6:\"Status\";s:5:\"100.0\";s:6:\"WPUser\";s:14:\"ambre_palanque\";s:7:\"Archive\";O:11:\"DUP_Archive\":26:{s:10:\"FilterDirs\";s:0:\"\";s:11:\"FilterFiles\";s:0:\"\";s:10:\"FilterExts\";s:0:\"\";s:13:\"FilterDirsAll\";a:0:{}s:14:\"FilterFilesAll\";a:0:{}s:13:\"FilterExtsAll\";a:0:{}s:8:\"FilterOn\";i:0;s:12:\"ExportOnlyDB\";i:0;s:4:\"File\";s:70:\"20251021_focusantilles_3f68925b0d8b89274986_20251021205704_archive.zip\";s:6:\"Format\";s:3:\"ZIP\";s:7:\"PackDir\";s:53:\"/Applications/MAMP/htdocs/localsites/intermitent_site\";s:4:\"Size\";i:65577612;s:4:\"Dirs\";a:0:{}s:9:\"dirsCount\";i:644;s:5:\"Files\";a:0:{}s:10:\"filesCount\";i:4690;s:10:\"FilterInfo\";O:23:\"DUP_Archive_Filter_Info\":8:{s:4:\"Dirs\";O:34:\"DUP_Archive_Filter_Scope_Directory\":6:{s:4:\"Core\";a:0:{}s:6:\"Global\";a:0:{}s:8:\"Instance\";a:0:{}s:7:\"Warning\";a:0:{}s:10:\"Unreadable\";a:0:{}s:10:\"AddonSites\";a:0:{}}s:5:\"Files\";O:29:\"DUP_Archive_Filter_Scope_File\":7:{s:4:\"Core\";a:0:{}s:6:\"Global\";a:0:{}s:8:\"Instance\";a:0:{}s:7:\"Warning\";a:0:{}s:10:\"Unreadable\";a:0:{}s:10:\"AddonSites\";a:0:{}s:4:\"Size\";a:0:{}}s:4:\"Exts\";O:29:\"DUP_Archive_Filter_Scope_Base\":3:{s:4:\"Core\";a:0:{}s:6:\"Global\";a:0:{}s:8:\"Instance\";a:0:{}}s:9:\"UDirCount\";i:0;s:10:\"UFileCount\";i:0;s:9:\"UExtCount\";i:0;s:8:\"TreeSize\";a:0:{}s:11:\"TreeWarning\";a:0:{}}s:14:\"RecursiveLinks\";a:0:{}s:10:\"file_count\";i:5333;s:10:\"\0*\0Package\";r:1;s:29:\"\0DUP_Archive\0tmpFilterDirsAll\";a:0:{}s:24:\"\0DUP_Archive\0wpCorePaths\";a:3:{i:0;s:62:\"/Applications/MAMP/htdocs/localsites/intermitent_site/wp-admin\";i:1;s:65:\"/Applications/MAMP/htdocs/localsites/intermitent_site/wp-includes\";i:2;s:74:\"/Applications/MAMP/htdocs/localsites/intermitent_site/wp-content/languages\";}s:29:\"\0DUP_Archive\0wpCoreExactPaths\";a:7:{i:0;s:53:\"/Applications/MAMP/htdocs/localsites/intermitent_site\";i:1;s:53:\"/Applications/MAMP/htdocs/localsites/intermitent_site\";i:2;s:64:\"/Applications/MAMP/htdocs/localsites/intermitent_site/wp-content\";i:3;s:72:\"/Applications/MAMP/htdocs/localsites/intermitent_site/wp-content/uploads\";i:4;s:72:\"/Applications/MAMP/htdocs/localsites/intermitent_site/wp-content/plugins\";i:5;s:75:\"/Applications/MAMP/htdocs/localsites/intermitent_site/wp-content/mu-plugins\";i:6;s:71:\"/Applications/MAMP/htdocs/localsites/intermitent_site/wp-content/themes\";}s:31:\"\0DUP_Archive\0relativeFiltersDir\";a:2:{i:0;s:85:\"/Applications/MAMP/htdocs/localsites/intermitent_site/wp-content/backups-dup-lite/tmp\";i:1;s:15:\"backups-dup-pro\";}s:24:\"\0DUP_Archive\0listFileObj\";N;s:23:\"\0DUP_Archive\0listDirObj\";N;}s:9:\"Installer\";O:13:\"DUP_Installer\":15:{s:4:\"File\";s:76:\"20251021_focusantilles_3f68925b0d8b89274986_20251021205704_installer.php.bak\";s:4:\"Size\";i:75257;s:10:\"OptsDBHost\";s:0:\"\";s:10:\"OptsDBPort\";s:0:\"\";s:10:\"OptsDBName\";s:0:\"\";s:10:\"OptsDBUser\";s:0:\"\";s:13:\"OptsDBCharset\";s:0:\"\";s:15:\"OptsDBCollation\";s:0:\"\";s:12:\"OptsSecureOn\";i:0;s:14:\"OptsSecurePass\";s:0:\"\";s:13:\"numFilesAdded\";i:0;s:12:\"numDirsAdded\";i:0;s:10:\"\0*\0Package\";r:1;s:17:\"\0*\0origFileManger\";O:40:\"Duplicator\\Libs\\Snap\\SnapOrigFileManager\":4:{s:18:\"\0*\0persistanceFile\";s:137:\"/Applications/MAMP/htdocs/localsites/intermitent_site/wp-content/backups-dup-lite/tmp/original_files_3f68925-21205704/entries_stored.json\";s:18:\"\0*\0origFilesFolder\";s:117:\"/Applications/MAMP/htdocs/localsites/intermitent_site/wp-content/backups-dup-lite/tmp/original_files_3f68925-21205704\";s:20:\"\0*\0origFolderEntries\";a:0:{}s:11:\"\0*\0rootPath\";s:53:\"/Applications/MAMP/htdocs/localsites/intermitent_site\";}s:32:\"\0DUP_Installer\0configTransformer\";O:44:\"Duplicator\\Libs\\WpConfig\\WPConfigTransformer\":3:{s:17:\"\0*\0wp_config_path\";s:67:\"/Applications/MAMP/htdocs/localsites/intermitent_site/wp-config.php\";s:16:\"\0*\0wp_config_src\";s:3514:\"<?php\n/**\n * The base configuration for WordPress\n *\n * The wp-config.php creation script uses this file during the installation.\n * You don\'t have to use the website, you can copy this file to \"wp-config.php\"\n * and fill in the values.\n *\n * This file contains the following configurations:\n *\n * * Database settings\n * * Secret keys\n * * Database table prefix\n * * ABSPATH\n *\n * @link https://developer.wordpress.org/advanced-administration/wordpress/wp-config/\n *\n * @package WordPress\n */\n\n// ** Database settings - You can get this info from your web host ** //\n/** The name of the database for WordPress */\ndefine( \'DB_NAME\', \'intermitent_bdd\' );\n\n/** Database username */\ndefine( \'DB_USER\', \'root\' );\n\n/** Database password */\ndefine( \'DB_PASSWORD\', \'root\' );\n\n/** Database hostname */\ndefine( \'DB_HOST\', \'localhost\' );\n\n/** Database charset to use in creating database tables. */\ndefine( \'DB_CHARSET\', \'utf8mb4\' );\n\n/** The database collate type. Don\'t change this if in doubt. */\ndefine( \'DB_COLLATE\', \'\' );\n\n/**#@+\n * Authentication unique keys and salts.\n *\n * Change these to different unique phrases! You can generate these using\n * the {@link https://api.wordpress.org/secret-key/1.1/salt/ WordPress.org secret-key service}.\n *\n * You can change these at any point in time to invalidate all existing cookies.\n * This will force all users to have to log in again.\n *\n * @since 2.6.0\n */\ndefine( \'AUTH_KEY\',         \'J|*99/[^NJj[Y#2]jmC~ ID-uvF d[0InWxD=C|J%Am4Y.Ns7J*T*w%wI#KP7YoR\' );\ndefine( \'SECURE_AUTH_KEY\',  \' Q:r@nF[M8(3U4VNKV]avb7VPAa_./0yjC8X8~Ov1-2~gRd^lU{)!zF!Y:1e eb&\' );\ndefine( \'LOGGED_IN_KEY\',    \'xWO kfQ8-jMaARstD(Cu E}=,ek,/6>tm`I<>)=w8D[SbTP6_pKa[@#e4XI7pS6y\' );\ndefine( \'NONCE_KEY\',        \'G%%[(.z>}5Z[Wjex)h;Z*^A3[A)bC,X@nvuIyR)z@b:,jugnaV5(*NPE0(`cqbd)\' );\ndefine( \'AUTH_SALT\',        \'@I?9tqR>U^=CM1Ef(9^7u^hv~4`~vK[JN#4`beP;LL^Ueg?@hM{#,7^X lS5kWUy\' );\ndefine( \'SECURE_AUTH_SALT\', \'c$rlJiz8(zA<PY.jd/z}cN)U&Dx2Uq1K0!q]6PVd=<ZA?O{Ive];BhoNROXH^V@|\' );\ndefine( \'LOGGED_IN_SALT\',   \'`_ytTHM B:53Lvm`CEAwp(HInpmO;Zf-y_.39w9U6_{$y<HEGFMi/WTwS;uTrgC,\' );\ndefine( \'NONCE_SALT\',       \'Ik[tu]G-zH8/EEh(L)1o>5?4R%m@:Yq[0-XSGxM-~h$ 4an8e?`hx{6S{~NU4cAc\' );\n\n/**#@-*/\n\n/**\n * WordPress database table prefix.\n *\n * You can have multiple installations in one database if you give each\n * a unique prefix. Only numbers, letters, and underscores please!\n *\n * At the installation time, database tables are created with the specified prefix.\n * Changing this value after WordPress is installed will make your site think\n * it has not been installed.\n *\n * @link https://developer.wordpress.org/advanced-administration/wordpress/wp-config/#table-prefix\n */\n$table_prefix = \'inter_\';\n\n/**\n * For developers: WordPress debugging mode.\n *\n * Change this to true to enable the display of notices during development.\n * It is strongly recommended that plugin and theme developers use WP_DEBUG\n * in their development environments.\n *\n * For information on other constants that can be used for debugging,\n * visit the documentation.\n *\n * @link https://developer.wordpress.org/advanced-administration/debug/debug-wordpress/\n */\ndefine( \'WP_DEBUG\', false );\n/* Add any custom values between this line and the \"stop editing\" line. */\n\n\n\n/* That\'s all, stop editing! Happy publishing. */\n\n/** Absolute path to the WordPress directory. */\nif ( ! defined( \'ABSPATH\' ) ) {\n	define( \'ABSPATH\', __DIR__ . \'/\' );\n}\n\n/** Sets up WordPress vars and included files. */\nrequire_once ABSPATH . \'wp-settings.php\';\n\";s:13:\"\0*\0wp_configs\";a:2:{s:8:\"constant\";a:16:{s:7:\"DB_NAME\";a:3:{s:3:\"src\";s:39:\"define( \'DB_NAME\', \'intermitent_bdd\' );\";s:5:\"value\";s:17:\"\'intermitent_bdd\'\";s:5:\"parts\";a:3:{i:0;s:17:\"define( \'DB_NAME\'\";i:1;s:20:\", \'intermitent_bdd\' \";i:2;s:2:\");\";}}s:7:\"DB_USER\";a:3:{s:3:\"src\";s:28:\"define( \'DB_USER\', \'root\' );\";s:5:\"value\";s:6:\"\'root\'\";s:5:\"parts\";a:3:{i:0;s:17:\"define( \'DB_USER\'\";i:1;s:9:\", \'root\' \";i:2;s:2:\");\";}}s:11:\"DB_PASSWORD\";a:3:{s:3:\"src\";s:32:\"define( \'DB_PASSWORD\', \'root\' );\";s:5:\"value\";s:6:\"\'root\'\";s:5:\"parts\";a:3:{i:0;s:21:\"define( \'DB_PASSWORD\'\";i:1;s:9:\", \'root\' \";i:2;s:2:\");\";}}s:7:\"DB_HOST\";a:3:{s:3:\"src\";s:33:\"define( \'DB_HOST\', \'localhost\' );\";s:5:\"value\";s:11:\"\'localhost\'\";s:5:\"parts\";a:3:{i:0;s:17:\"define( \'DB_HOST\'\";i:1;s:14:\", \'localhost\' \";i:2;s:2:\");\";}}s:10:\"DB_CHARSET\";a:3:{s:3:\"src\";s:34:\"define( \'DB_CHARSET\', \'utf8mb4\' );\";s:5:\"value\";s:9:\"\'utf8mb4\'\";s:5:\"parts\";a:3:{i:0;s:20:\"define( \'DB_CHARSET\'\";i:1;s:12:\", \'utf8mb4\' \";i:2;s:2:\");\";}}s:10:\"DB_COLLATE\";a:3:{s:3:\"src\";s:27:\"define( \'DB_COLLATE\', \'\' );\";s:5:\"value\";s:2:\"\'\'\";s:5:\"parts\";a:3:{i:0;s:20:\"define( \'DB_COLLATE\'\";i:1;s:5:\", \'\' \";i:2;s:2:\");\";}}s:8:\"AUTH_KEY\";a:3:{s:3:\"src\";s:97:\"define( \'AUTH_KEY\',         \'J|*99/[^NJj[Y#2]jmC~ ID-uvF d[0InWxD=C|J%Am4Y.Ns7J*T*w%wI#KP7YoR\' );\";s:5:\"value\";s:66:\"\'J|*99/[^NJj[Y#2]jmC~ ID-uvF d[0InWxD=C|J%Am4Y.Ns7J*T*w%wI#KP7YoR\'\";s:5:\"parts\";a:3:{i:0;s:18:\"define( \'AUTH_KEY\'\";i:1;s:77:\",         \'J|*99/[^NJj[Y#2]jmC~ ID-uvF d[0InWxD=C|J%Am4Y.Ns7J*T*w%wI#KP7YoR\' \";i:2;s:2:\");\";}}s:15:\"SECURE_AUTH_KEY\";a:3:{s:3:\"src\";s:97:\"define( \'SECURE_AUTH_KEY\',  \' Q:r@nF[M8(3U4VNKV]avb7VPAa_./0yjC8X8~Ov1-2~gRd^lU{)!zF!Y:1e eb&\' );\";s:5:\"value\";s:66:\"\' Q:r@nF[M8(3U4VNKV]avb7VPAa_./0yjC8X8~Ov1-2~gRd^lU{)!zF!Y:1e eb&\'\";s:5:\"parts\";a:3:{i:0;s:25:\"define( \'SECURE_AUTH_KEY\'\";i:1;s:70:\",  \' Q:r@nF[M8(3U4VNKV]avb7VPAa_./0yjC8X8~Ov1-2~gRd^lU{)!zF!Y:1e eb&\' \";i:2;s:2:\");\";}}s:13:\"LOGGED_IN_KEY\";a:3:{s:3:\"src\";s:97:\"define( \'LOGGED_IN_KEY\',    \'xWO kfQ8-jMaARstD(Cu E}=,ek,/6>tm`I<>)=w8D[SbTP6_pKa[@#e4XI7pS6y\' );\";s:5:\"value\";s:66:\"\'xWO kfQ8-jMaARstD(Cu E}=,ek,/6>tm`I<>)=w8D[SbTP6_pKa[@#e4XI7pS6y\'\";s:5:\"parts\";a:3:{i:0;s:23:\"define( \'LOGGED_IN_KEY\'\";i:1;s:72:\",    \'xWO kfQ8-jMaARstD(Cu E}=,ek,/6>tm`I<>)=w8D[SbTP6_pKa[@#e4XI7pS6y\' \";i:2;s:2:\");\";}}s:9:\"NONCE_KEY\";a:3:{s:3:\"src\";s:97:\"define( \'NONCE_KEY\',        \'G%%[(.z>}5Z[Wjex)h;Z*^A3[A)bC,X@nvuIyR)z@b:,jugnaV5(*NPE0(`cqbd)\' );\";s:5:\"value\";s:66:\"\'G%%[(.z>}5Z[Wjex)h;Z*^A3[A)bC,X@nvuIyR)z@b:,jugnaV5(*NPE0(`cqbd)\'\";s:5:\"parts\";a:3:{i:0;s:19:\"define( \'NONCE_KEY\'\";i:1;s:76:\",        \'G%%[(.z>}5Z[Wjex)h;Z*^A3[A)bC,X@nvuIyR)z@b:,jugnaV5(*NPE0(`cqbd)\' \";i:2;s:2:\");\";}}s:9:\"AUTH_SALT\";a:3:{s:3:\"src\";s:97:\"define( \'AUTH_SALT\',        \'@I?9tqR>U^=CM1Ef(9^7u^hv~4`~vK[JN#4`beP;LL^Ueg?@hM{#,7^X lS5kWUy\' );\";s:5:\"value\";s:66:\"\'@I?9tqR>U^=CM1Ef(9^7u^hv~4`~vK[JN#4`beP;LL^Ueg?@hM{#,7^X lS5kWUy\'\";s:5:\"parts\";a:3:{i:0;s:19:\"define( \'AUTH_SALT\'\";i:1;s:76:\",        \'@I?9tqR>U^=CM1Ef(9^7u^hv~4`~vK[JN#4`beP;LL^Ueg?@hM{#,7^X lS5kWUy\' \";i:2;s:2:\");\";}}s:16:\"SECURE_AUTH_SALT\";a:3:{s:3:\"src\";s:97:\"define( \'SECURE_AUTH_SALT\', \'c$rlJiz8(zA<PY.jd/z}cN)U&Dx2Uq1K0!q]6PVd=<ZA?O{Ive];BhoNROXH^V@|\' );\";s:5:\"value\";s:66:\"\'c$rlJiz8(zA<PY.jd/z}cN)U&Dx2Uq1K0!q]6PVd=<ZA?O{Ive];BhoNROXH^V@|\'\";s:5:\"parts\";a:3:{i:0;s:26:\"define( \'SECURE_AUTH_SALT\'\";i:1;s:69:\", \'c$rlJiz8(zA<PY.jd/z}cN)U&Dx2Uq1K0!q]6PVd=<ZA?O{Ive];BhoNROXH^V@|\' \";i:2;s:2:\");\";}}s:14:\"LOGGED_IN_SALT\";a:3:{s:3:\"src\";s:97:\"define( \'LOGGED_IN_SALT\',   \'`_ytTHM B:53Lvm`CEAwp(HInpmO;Zf-y_.39w9U6_{$y<HEGFMi/WTwS;uTrgC,\' );\";s:5:\"value\";s:66:\"\'`_ytTHM B:53Lvm`CEAwp(HInpmO;Zf-y_.39w9U6_{$y<HEGFMi/WTwS;uTrgC,\'\";s:5:\"parts\";a:3:{i:0;s:24:\"define( \'LOGGED_IN_SALT\'\";i:1;s:71:\",   \'`_ytTHM B:53Lvm`CEAwp(HInpmO;Zf-y_.39w9U6_{$y<HEGFMi/WTwS;uTrgC,\' \";i:2;s:2:\");\";}}s:10:\"NONCE_SALT\";a:3:{s:3:\"src\";s:97:\"define( \'NONCE_SALT\',       \'Ik[tu]G-zH8/EEh(L)1o>5?4R%m@:Yq[0-XSGxM-~h$ 4an8e?`hx{6S{~NU4cAc\' );\";s:5:\"value\";s:66:\"\'Ik[tu]G-zH8/EEh(L)1o>5?4R%m@:Yq[0-XSGxM-~h$ 4an8e?`hx{6S{~NU4cAc\'\";s:5:\"parts\";a:3:{i:0;s:20:\"define( \'NONCE_SALT\'\";i:1;s:75:\",       \'Ik[tu]G-zH8/EEh(L)1o>5?4R%m@:Yq[0-XSGxM-~h$ 4an8e?`hx{6S{~NU4cAc\' \";i:2;s:2:\");\";}}s:8:\"WP_DEBUG\";a:3:{s:3:\"src\";s:28:\"define( \'WP_DEBUG\', false );\";s:5:\"value\";s:5:\"false\";s:5:\"parts\";a:3:{i:0;s:18:\"define( \'WP_DEBUG\'\";i:1;s:8:\", false \";i:2;s:2:\");\";}}s:7:\"ABSPATH\";a:3:{s:3:\"src\";s:36:\"	define( \'ABSPATH\', __DIR__ . \'/\' );\";s:5:\"value\";s:13:\"__DIR__ . \'/\'\";s:5:\"parts\";a:3:{i:0;s:18:\"	define( \'ABSPATH\'\";i:1;s:16:\", __DIR__ . \'/\' \";i:2;s:2:\");\";}}}s:8:\"variable\";a:1:{s:12:\"table_prefix\";a:3:{s:3:\"src\";s:25:\"$table_prefix = \'inter_\';\";s:5:\"value\";s:8:\"\'inter_\'\";s:5:\"parts\";a:2:{i:0;s:15:\"$table_prefix =\";i:1;s:10:\" \'inter_\';\";}}}}}}s:8:\"Database\";O:12:\"DUP_Database\":15:{s:4:\"Type\";s:5:\"MySQL\";s:4:\"Size\";i:3609928;s:4:\"File\";s:71:\"20251021_focusantilles_3f68925b0d8b89274986_20251021205704_database.sql\";s:4:\"Path\";N;s:12:\"FilterTables\";s:0:\"\";s:8:\"FilterOn\";i:0;s:4:\"Name\";N;s:10:\"Compatible\";s:0:\"\";s:8:\"Comments\";s:19:\"Source distribution\";s:19:\"sameNameTableExists\";b:0;s:4:\"info\";O:16:\"DUP_DatabaseInfo\":23:{s:9:\"buildMode\";s:3:\"PHP\";s:11:\"charSetList\";a:1:{i:0;s:7:\"utf8mb4\";}s:13:\"collationList\";a:1:{i:0;s:22:\"utf8mb4_unicode_520_ci\";}s:10:\"engineList\";a:1:{i:0;s:6:\"InnoDB\";}s:17:\"isTablesUpperCase\";i:0;s:15:\"isNameUpperCase\";i:0;s:4:\"name\";s:15:\"intermitent_bdd\";s:15:\"tablesBaseCount\";i:19;s:16:\"tablesFinalCount\";i:19;s:20:\"muFilteredTableCount\";i:0;s:14:\"tablesRowCount\";i:996;s:16:\"tablesSizeOnDisk\";i:5390336;s:10:\"tablesList\";a:19:{s:29:\"inter_actionscheduler_actions\";a:3:{s:14:\"inaccurateRows\";i:4;s:12:\"insertedRows\";i:4;s:4:\"size\";i:131072;}s:28:\"inter_actionscheduler_claims\";a:3:{s:14:\"inaccurateRows\";i:0;s:12:\"insertedRows\";i:0;s:4:\"size\";i:32768;}s:28:\"inter_actionscheduler_groups\";a:3:{s:14:\"inaccurateRows\";i:2;s:12:\"insertedRows\";i:2;s:4:\"size\";i:32768;}s:26:\"inter_actionscheduler_logs\";a:3:{s:14:\"inaccurateRows\";i:10;s:12:\"insertedRows\";i:10;s:4:\"size\";i:49152;}s:17:\"inter_commentmeta\";a:3:{s:14:\"inaccurateRows\";i:0;s:12:\"insertedRows\";i:0;s:4:\"size\";i:49152;}s:14:\"inter_comments\";a:3:{s:14:\"inaccurateRows\";i:1;s:12:\"insertedRows\";i:1;s:4:\"size\";i:98304;}s:25:\"inter_duplicator_packages\";a:3:{s:14:\"inaccurateRows\";i:0;s:12:\"insertedRows\";i:1;s:4:\"size\";i:32768;}s:11:\"inter_links\";a:3:{s:14:\"inaccurateRows\";i:0;s:12:\"insertedRows\";i:0;s:4:\"size\";i:32768;}s:13:\"inter_options\";a:3:{s:14:\"inaccurateRows\";i:203;s:12:\"insertedRows\";i:209;s:4:\"size\";i:4259840;}s:14:\"inter_postmeta\";a:3:{s:14:\"inaccurateRows\";i:98;s:12:\"insertedRows\";i:98;s:4:\"size\";i:81920;}s:11:\"inter_posts\";a:3:{s:14:\"inaccurateRows\";i:73;s:12:\"insertedRows\";i:73;s:4:\"size\";i:229376;}s:24:\"inter_term_relationships\";a:3:{s:14:\"inaccurateRows\";i:12;s:12:\"insertedRows\";i:12;s:4:\"size\";i:32768;}s:19:\"inter_term_taxonomy\";a:3:{s:14:\"inaccurateRows\";i:122;s:12:\"insertedRows\";i:122;s:4:\"size\";i:49152;}s:14:\"inter_termmeta\";a:3:{s:14:\"inaccurateRows\";i:0;s:12:\"insertedRows\";i:0;s:4:\"size\";i:49152;}s:11:\"inter_terms\";a:3:{s:14:\"inaccurateRows\";i:122;s:12:\"insertedRows\";i:122;s:4:\"size\";i:49152;}s:14:\"inter_usermeta\";a:3:{s:14:\"inaccurateRows\";i:334;s:12:\"insertedRows\";i:334;s:4:\"size\";i:81920;}s:11:\"inter_users\";a:3:{s:14:\"inaccurateRows\";i:14;s:12:\"insertedRows\";i:14;s:4:\"size\";i:65536;}s:29:\"inter_wpmailsmtp_debug_events\";a:3:{s:14:\"inaccurateRows\";i:0;s:12:\"insertedRows\";i:0;s:4:\"size\";i:16384;}s:27:\"inter_wpmailsmtp_tasks_meta\";a:3:{s:14:\"inaccurateRows\";i:1;s:12:\"insertedRows\";i:1;s:4:\"size\";i:16384;}}s:19:\"lowerCaseTableNames\";i:2;s:8:\"dbEngine\";s:5:\"MySQL\";s:7:\"version\";s:6:\"8.0.40\";s:14:\"versionComment\";s:19:\"Source distribution\";s:9:\"viewCount\";i:0;s:9:\"procCount\";i:0;s:9:\"funcCount\";i:0;s:11:\"triggerList\";a:0:{}s:33:\"\0DUP_DatabaseInfo\0intFieldsStruct\";a:0:{}s:42:\"\0DUP_DatabaseInfo\0indexProcessedSchemaSize\";a:0:{}}s:10:\"\0*\0Package\";r:1;s:24:\"\0DUP_Database\0tempDbPath\";s:157:\"/Applications/MAMP/htdocs/localsites/intermitent_site/wp-content/backups-dup-lite/tmp/20251021_focusantilles_3f68925b0d8b89274986_20251021205704_database.sql\";s:23:\"\0DUP_Database\0EOFMarker\";s:0:\"\";s:26:\"\0DUP_Database\0networkFlush\";b:0;}s:13:\"BuildProgress\";O:18:\"DUP_Build_Progress\":12:{s:17:\"thread_start_time\";N;s:11:\"initialized\";b:0;s:15:\"installer_built\";b:1;s:15:\"archive_started\";b:0;s:20:\"archive_has_database\";b:0;s:13:\"archive_built\";b:0;s:21:\"database_script_built\";b:0;s:6:\"failed\";b:0;s:7:\"retries\";i:0;s:14:\"build_failures\";a:0:{}s:19:\"validation_failures\";a:0:{}s:27:\"\0DUP_Build_Progress\0package\";O:11:\"DUP_Package\":23:{s:7:\"Created\";s:19:\"2025-10-21 20:57:04\";s:7:\"Version\";s:6:\"1.5.14\";s:9:\"VersionWP\";s:5:\"6.8.3\";s:9:\"VersionDB\";s:6:\"8.0.40\";s:10:\"VersionPHP\";s:6:\"8.3.14\";s:9:\"VersionOS\";s:6:\"Darwin\";s:2:\"ID\";N;s:4:\"Name\";s:22:\"20251021_focusantilles\";s:4:\"Hash\";s:35:\"3f68925b0d8b89274986_20251021205704\";s:8:\"NameHash\";s:58:\"20251021_focusantilles_3f68925b0d8b89274986_20251021205704\";s:4:\"Type\";i:0;s:5:\"Notes\";s:0:\"\";s:8:\"ScanFile\";N;s:10:\"TimerStart\";i:-1;s:7:\"Runtime\";N;s:7:\"ExeSize\";N;s:7:\"ZipSize\";N;s:6:\"Status\";i:0;s:6:\"WPUser\";N;s:7:\"Archive\";r:21;s:9:\"Installer\";r:84;s:8:\"Database\";r:227;s:13:\"BuildProgress\";r:345;}}}");
INSERT INTO `inter_duplicator_packages` VALUES("2", "20251021_focusantilles", "ec99491b3b9410b72304_20251024190641", "23", "2025-10-24 19:06:46", "ambre_palanque", "O:11:\"DUP_Package\":23:{s:7:\"Created\";s:19:\"2025-10-24 19:06:41\";s:7:\"Version\";s:6:\"1.5.14\";s:9:\"VersionWP\";s:5:\"6.8.3\";s:9:\"VersionDB\";s:6:\"8.0.40\";s:10:\"VersionPHP\";s:6:\"8.3.14\";s:9:\"VersionOS\";s:6:\"Darwin\";s:2:\"ID\";i:2;s:4:\"Name\";s:22:\"20251021_focusantilles\";s:4:\"Hash\";s:35:\"ec99491b3b9410b72304_20251024190641\";s:8:\"NameHash\";s:58:\"20251021_focusantilles_ec99491b3b9410b72304_20251024190641\";s:4:\"Type\";i:0;s:5:\"Notes\";s:0:\"\";s:8:\"ScanFile\";s:68:\"20251021_focusantilles_ec99491b3b9410b72304_20251024190641_scan.json\";s:10:\"TimerStart\";i:-1;s:7:\"Runtime\";N;s:7:\"ExeSize\";N;s:7:\"ZipSize\";N;s:6:\"Status\";s:4:\"23.2\";s:6:\"WPUser\";s:14:\"ambre_palanque\";s:7:\"Archive\";O:11:\"DUP_Archive\":26:{s:10:\"FilterDirs\";s:0:\"\";s:11:\"FilterFiles\";s:0:\"\";s:10:\"FilterExts\";s:0:\"\";s:13:\"FilterDirsAll\";a:0:{}s:14:\"FilterFilesAll\";a:0:{}s:13:\"FilterExtsAll\";a:0:{}s:8:\"FilterOn\";i:0;s:12:\"ExportOnlyDB\";i:0;s:4:\"File\";s:70:\"20251021_focusantilles_ec99491b3b9410b72304_20251024190641_archive.zip\";s:6:\"Format\";s:3:\"ZIP\";s:7:\"PackDir\";s:53:\"/Applications/MAMP/htdocs/localsites/intermitent_site\";s:4:\"Size\";i:0;s:4:\"Dirs\";a:0:{}s:9:\"dirsCount\";i:644;s:5:\"Files\";a:0:{}s:10:\"filesCount\";i:4693;s:10:\"FilterInfo\";O:23:\"DUP_Archive_Filter_Info\":8:{s:4:\"Dirs\";O:34:\"DUP_Archive_Filter_Scope_Directory\":6:{s:4:\"Core\";a:0:{}s:6:\"Global\";a:0:{}s:8:\"Instance\";a:0:{}s:7:\"Warning\";a:0:{}s:10:\"Unreadable\";a:0:{}s:10:\"AddonSites\";a:0:{}}s:5:\"Files\";O:29:\"DUP_Archive_Filter_Scope_File\":7:{s:4:\"Core\";a:0:{}s:6:\"Global\";a:0:{}s:8:\"Instance\";a:0:{}s:7:\"Warning\";a:0:{}s:10:\"Unreadable\";a:0:{}s:10:\"AddonSites\";a:0:{}s:4:\"Size\";a:0:{}}s:4:\"Exts\";O:29:\"DUP_Archive_Filter_Scope_Base\":3:{s:4:\"Core\";a:0:{}s:6:\"Global\";a:0:{}s:8:\"Instance\";a:0:{}}s:9:\"UDirCount\";i:0;s:10:\"UFileCount\";i:0;s:9:\"UExtCount\";i:0;s:8:\"TreeSize\";a:0:{}s:11:\"TreeWarning\";a:0:{}}s:14:\"RecursiveLinks\";a:0:{}s:10:\"file_count\";i:-1;s:10:\"\0*\0Package\";O:11:\"DUP_Package\":23:{s:7:\"Created\";s:19:\"2025-10-24 19:06:41\";s:7:\"Version\";s:6:\"1.5.14\";s:9:\"VersionWP\";s:5:\"6.8.3\";s:9:\"VersionDB\";s:6:\"8.0.40\";s:10:\"VersionPHP\";s:6:\"8.3.14\";s:9:\"VersionOS\";s:6:\"Darwin\";s:2:\"ID\";N;s:4:\"Name\";s:22:\"20251021_focusantilles\";s:4:\"Hash\";s:35:\"ec99491b3b9410b72304_20251024190641\";s:8:\"NameHash\";s:58:\"20251021_focusantilles_ec99491b3b9410b72304_20251024190641\";s:4:\"Type\";i:0;s:5:\"Notes\";s:0:\"\";s:8:\"ScanFile\";N;s:10:\"TimerStart\";i:-1;s:7:\"Runtime\";N;s:7:\"ExeSize\";N;s:7:\"ZipSize\";N;s:6:\"Status\";i:0;s:6:\"WPUser\";N;s:7:\"Archive\";r:21;s:9:\"Installer\";O:13:\"DUP_Installer\":15:{s:4:\"File\";s:76:\"20251021_focusantilles_ec99491b3b9410b72304_20251024190641_installer.php.bak\";s:4:\"Size\";i:0;s:10:\"OptsDBHost\";s:0:\"\";s:10:\"OptsDBPort\";s:0:\"\";s:10:\"OptsDBName\";s:0:\"\";s:10:\"OptsDBUser\";s:0:\"\";s:13:\"OptsDBCharset\";s:0:\"\";s:15:\"OptsDBCollation\";s:0:\"\";s:12:\"OptsSecureOn\";i:0;s:14:\"OptsSecurePass\";s:0:\"\";s:13:\"numFilesAdded\";i:0;s:12:\"numDirsAdded\";i:0;s:10:\"\0*\0Package\";r:65;s:17:\"\0*\0origFileManger\";N;s:32:\"\0DUP_Installer\0configTransformer\";O:44:\"Duplicator\\Libs\\WpConfig\\WPConfigTransformer\":3:{s:17:\"\0*\0wp_config_path\";s:67:\"/Applications/MAMP/htdocs/localsites/intermitent_site/wp-config.php\";s:16:\"\0*\0wp_config_src\";N;s:13:\"\0*\0wp_configs\";a:0:{}}}s:8:\"Database\";O:12:\"DUP_Database\":15:{s:4:\"Type\";s:5:\"MySQL\";s:4:\"Size\";N;s:4:\"File\";s:71:\"20251021_focusantilles_ec99491b3b9410b72304_20251024190641_database.sql\";s:4:\"Path\";N;s:12:\"FilterTables\";s:0:\"\";s:8:\"FilterOn\";i:0;s:4:\"Name\";N;s:10:\"Compatible\";s:0:\"\";s:8:\"Comments\";s:19:\"Source distribution\";s:19:\"sameNameTableExists\";b:0;s:4:\"info\";O:16:\"DUP_DatabaseInfo\":23:{s:9:\"buildMode\";s:3:\"PHP\";s:11:\"charSetList\";a:0:{}s:13:\"collationList\";a:0:{}s:10:\"engineList\";a:0:{}s:17:\"isTablesUpperCase\";b:0;s:15:\"isNameUpperCase\";b:0;s:4:\"name\";s:0:\"\";s:15:\"tablesBaseCount\";i:0;s:16:\"tablesFinalCount\";i:0;s:20:\"muFilteredTableCount\";i:0;s:14:\"tablesRowCount\";i:0;s:16:\"tablesSizeOnDisk\";i:0;s:10:\"tablesList\";a:0:{}s:19:\"lowerCaseTableNames\";i:0;s:8:\"dbEngine\";s:0:\"\";s:7:\"version\";i:0;s:14:\"versionComment\";i:0;s:9:\"viewCount\";i:0;s:9:\"procCount\";i:0;s:9:\"funcCount\";i:0;s:11:\"triggerList\";a:0:{}s:33:\"\0DUP_DatabaseInfo\0intFieldsStruct\";a:0:{}s:42:\"\0DUP_DatabaseInfo\0indexProcessedSchemaSize\";a:0:{}}s:10:\"\0*\0Package\";r:1;s:24:\"\0DUP_Database\0tempDbPath\";s:157:\"/Applications/MAMP/htdocs/localsites/intermitent_site/wp-content/backups-dup-lite/tmp/20251021_focusantilles_ec99491b3b9410b72304_20251024190641_database.sql\";s:23:\"\0DUP_Database\0EOFMarker\";s:0:\"\";s:26:\"\0DUP_Database\0networkFlush\";b:0;}s:13:\"BuildProgress\";O:18:\"DUP_Build_Progress\":12:{s:17:\"thread_start_time\";N;s:11:\"initialized\";b:0;s:15:\"installer_built\";b:0;s:15:\"archive_started\";b:0;s:20:\"archive_has_database\";b:0;s:13:\"archive_built\";b:0;s:21:\"database_script_built\";b:0;s:6:\"failed\";b:0;s:7:\"retries\";i:0;s:14:\"build_failures\";a:0:{}s:19:\"validation_failures\";a:0:{}s:27:\"\0DUP_Build_Progress\0package\";r:65;}}s:29:\"\0DUP_Archive\0tmpFilterDirsAll\";a:0:{}s:24:\"\0DUP_Archive\0wpCorePaths\";a:3:{i:0;s:62:\"/Applications/MAMP/htdocs/localsites/intermitent_site/wp-admin\";i:1;s:65:\"/Applications/MAMP/htdocs/localsites/intermitent_site/wp-includes\";i:2;s:74:\"/Applications/MAMP/htdocs/localsites/intermitent_site/wp-content/languages\";}s:29:\"\0DUP_Archive\0wpCoreExactPaths\";a:7:{i:0;s:53:\"/Applications/MAMP/htdocs/localsites/intermitent_site\";i:1;s:53:\"/Applications/MAMP/htdocs/localsites/intermitent_site\";i:2;s:64:\"/Applications/MAMP/htdocs/localsites/intermitent_site/wp-content\";i:3;s:72:\"/Applications/MAMP/htdocs/localsites/intermitent_site/wp-content/uploads\";i:4;s:72:\"/Applications/MAMP/htdocs/localsites/intermitent_site/wp-content/plugins\";i:5;s:75:\"/Applications/MAMP/htdocs/localsites/intermitent_site/wp-content/mu-plugins\";i:6;s:71:\"/Applications/MAMP/htdocs/localsites/intermitent_site/wp-content/themes\";}s:31:\"\0DUP_Archive\0relativeFiltersDir\";a:2:{i:0;s:85:\"/Applications/MAMP/htdocs/localsites/intermitent_site/wp-content/backups-dup-lite/tmp\";i:1;s:15:\"backups-dup-pro\";}s:24:\"\0DUP_Archive\0listFileObj\";N;s:23:\"\0DUP_Archive\0listDirObj\";N;}s:9:\"Installer\";r:86;s:8:\"Database\";r:105;s:13:\"BuildProgress\";r:144;}");

/* INSERT TABLE DATA: inter_options */
INSERT INTO `inter_options` VALUES("1", "cron", "a:13:{i:1761333950;a:2:{s:16:\"wp_version_check\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}s:34:\"wp_privacy_delete_old_export_files\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"hourly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:3600;}}}i:1761335750;a:1:{s:17:\"wp_update_plugins\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1761337550;a:1:{s:16:\"wp_update_themes\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1761373566;a:1:{s:21:\"wp_update_user_counts\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1761403931;a:1:{s:34:\"focusantilles_delete_expired_users\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1761416750;a:1:{s:32:\"recovery_mode_clean_expired_keys\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1761416766;a:2:{s:19:\"wp_scheduled_delete\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}s:25:\"delete_expired_transients\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1761416768;a:1:{s:30:\"wp_scheduled_auto_draft_delete\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1761566400;a:1:{s:29:\"duplicator_email_summary_cron\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:22:\"duplicator_weekly_cron\";s:4:\"args\";a:0:{}s:8:\"interval\";i:604800;}}}i:1761572648;a:1:{s:30:\"duplicator_usage_tracking_cron\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:22:\"duplicator_weekly_cron\";s:4:\"args\";a:0:{}s:8:\"interval\";i:604800;}}}i:1761676041;a:1:{s:30:\"wp_delete_temp_updater_backups\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"weekly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:604800;}}}i:1761762350;a:1:{s:30:\"wp_site_health_scheduled_check\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"weekly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:604800;}}}s:7:\"version\";i:2;}", "on");
INSERT INTO `inter_options` VALUES("2", "siteurl", "http://localhost:8888/intermitent_site", "on");
INSERT INTO `inter_options` VALUES("3", "home", "http://localhost:8888/intermitent_site", "on");
INSERT INTO `inter_options` VALUES("4", "blogname", "", "on");
INSERT INTO `inter_options` VALUES("5", "blogdescription", "", "on");
INSERT INTO `inter_options` VALUES("6", "users_can_register", "1", "on");
INSERT INTO `inter_options` VALUES("7", "admin_email", "ambre.palanque@hotmail.com", "on");
INSERT INTO `inter_options` VALUES("8", "start_of_week", "1", "on");
INSERT INTO `inter_options` VALUES("9", "use_balanceTags", "0", "on");
INSERT INTO `inter_options` VALUES("10", "use_smilies", "1", "on");
INSERT INTO `inter_options` VALUES("11", "require_name_email", "1", "on");
INSERT INTO `inter_options` VALUES("12", "comments_notify", "1", "on");
INSERT INTO `inter_options` VALUES("13", "posts_per_rss", "10", "on");
INSERT INTO `inter_options` VALUES("14", "rss_use_excerpt", "0", "on");
INSERT INTO `inter_options` VALUES("15", "mailserver_url", "mail.example.com", "on");
INSERT INTO `inter_options` VALUES("16", "mailserver_login", "login@example.com", "on");
INSERT INTO `inter_options` VALUES("17", "mailserver_pass", "", "on");
INSERT INTO `inter_options` VALUES("18", "mailserver_port", "110", "on");
INSERT INTO `inter_options` VALUES("19", "default_category", "1", "on");
INSERT INTO `inter_options` VALUES("20", "default_comment_status", "open", "on");
INSERT INTO `inter_options` VALUES("21", "default_ping_status", "open", "on");
INSERT INTO `inter_options` VALUES("22", "default_pingback_flag", "1", "on");
INSERT INTO `inter_options` VALUES("23", "posts_per_page", "10", "on");
INSERT INTO `inter_options` VALUES("24", "date_format", "j F Y", "on");
INSERT INTO `inter_options` VALUES("25", "time_format", "G\\hi", "on");
INSERT INTO `inter_options` VALUES("26", "links_updated_date_format", "d F Y G\\hi", "on");
INSERT INTO `inter_options` VALUES("27", "comment_moderation", "0", "on");
INSERT INTO `inter_options` VALUES("28", "moderation_notify", "1", "on");
INSERT INTO `inter_options` VALUES("29", "permalink_structure", "/%postname%/", "on");
INSERT INTO `inter_options` VALUES("30", "rewrite_rules", "a:107:{s:11:\"^wp-json/?$\";s:22:\"index.php?rest_route=/\";s:14:\"^wp-json/(.*)?\";s:33:\"index.php?rest_route=/$matches[1]\";s:21:\"^index.php/wp-json/?$\";s:22:\"index.php?rest_route=/\";s:24:\"^index.php/wp-json/(.*)?\";s:33:\"index.php?rest_route=/$matches[1]\";s:17:\"^wp-sitemap\\.xml$\";s:23:\"index.php?sitemap=index\";s:17:\"^wp-sitemap\\.xsl$\";s:36:\"index.php?sitemap-stylesheet=sitemap\";s:23:\"^wp-sitemap-index\\.xsl$\";s:34:\"index.php?sitemap-stylesheet=index\";s:48:\"^wp-sitemap-([a-z]+?)-([a-z\\d_-]+?)-(\\d+?)\\.xml$\";s:75:\"index.php?sitemap=$matches[1]&sitemap-subtype=$matches[2]&paged=$matches[3]\";s:34:\"^wp-sitemap-([a-z]+?)-(\\d+?)\\.xml$\";s:47:\"index.php?sitemap=$matches[1]&paged=$matches[2]\";s:47:\"category/(.+?)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:52:\"index.php?category_name=$matches[1]&feed=$matches[2]\";s:42:\"category/(.+?)/(feed|rdf|rss|rss2|atom)/?$\";s:52:\"index.php?category_name=$matches[1]&feed=$matches[2]\";s:23:\"category/(.+?)/embed/?$\";s:46:\"index.php?category_name=$matches[1]&embed=true\";s:35:\"category/(.+?)/page/?([0-9]{1,})/?$\";s:53:\"index.php?category_name=$matches[1]&paged=$matches[2]\";s:17:\"category/(.+?)/?$\";s:35:\"index.php?category_name=$matches[1]\";s:44:\"tag/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:42:\"index.php?tag=$matches[1]&feed=$matches[2]\";s:39:\"tag/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:42:\"index.php?tag=$matches[1]&feed=$matches[2]\";s:20:\"tag/([^/]+)/embed/?$\";s:36:\"index.php?tag=$matches[1]&embed=true\";s:32:\"tag/([^/]+)/page/?([0-9]{1,})/?$\";s:43:\"index.php?tag=$matches[1]&paged=$matches[2]\";s:14:\"tag/([^/]+)/?$\";s:25:\"index.php?tag=$matches[1]\";s:45:\"type/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?post_format=$matches[1]&feed=$matches[2]\";s:40:\"type/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?post_format=$matches[1]&feed=$matches[2]\";s:21:\"type/([^/]+)/embed/?$\";s:44:\"index.php?post_format=$matches[1]&embed=true\";s:33:\"type/([^/]+)/page/?([0-9]{1,})/?$\";s:51:\"index.php?post_format=$matches[1]&paged=$matches[2]\";s:15:\"type/([^/]+)/?$\";s:33:\"index.php?post_format=$matches[1]\";s:47:\"metier/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:45:\"index.php?metier=$matches[1]&feed=$matches[2]\";s:42:\"metier/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:45:\"index.php?metier=$matches[1]&feed=$matches[2]\";s:23:\"metier/([^/]+)/embed/?$\";s:39:\"index.php?metier=$matches[1]&embed=true\";s:35:\"metier/([^/]+)/page/?([0-9]{1,})/?$\";s:46:\"index.php?metier=$matches[1]&paged=$matches[2]\";s:17:\"metier/([^/]+)/?$\";s:28:\"index.php?metier=$matches[1]\";s:47:\"permis/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:45:\"index.php?permis=$matches[1]&feed=$matches[2]\";s:42:\"permis/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:45:\"index.php?permis=$matches[1]&feed=$matches[2]\";s:23:\"permis/([^/]+)/embed/?$\";s:39:\"index.php?permis=$matches[1]&embed=true\";s:35:\"permis/([^/]+)/page/?([0-9]{1,})/?$\";s:46:\"index.php?permis=$matches[1]&paged=$matches[2]\";s:17:\"permis/([^/]+)/?$\";s:28:\"index.php?permis=$matches[1]\";s:47:\"region/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:45:\"index.php?region=$matches[1]&feed=$matches[2]\";s:42:\"region/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:45:\"index.php?region=$matches[1]&feed=$matches[2]\";s:23:\"region/([^/]+)/embed/?$\";s:39:\"index.php?region=$matches[1]&embed=true\";s:35:\"region/([^/]+)/page/?([0-9]{1,})/?$\";s:46:\"index.php?region=$matches[1]&paged=$matches[2]\";s:17:\"region/([^/]+)/?$\";s:28:\"index.php?region=$matches[1]\";s:48:\".*wp-(atom|rdf|rss|rss2|feed|commentsrss2)\\.php$\";s:18:\"index.php?feed=old\";s:20:\".*wp-app\\.php(/.*)?$\";s:19:\"index.php?error=403\";s:18:\".*wp-register.php$\";s:23:\"index.php?register=true\";s:32:\"feed/(feed|rdf|rss|rss2|atom)/?$\";s:27:\"index.php?&feed=$matches[1]\";s:27:\"(feed|rdf|rss|rss2|atom)/?$\";s:27:\"index.php?&feed=$matches[1]\";s:8:\"embed/?$\";s:21:\"index.php?&embed=true\";s:20:\"page/?([0-9]{1,})/?$\";s:28:\"index.php?&paged=$matches[1]\";s:27:\"comment-page-([0-9]{1,})/?$\";s:39:\"index.php?&page_id=23&cpage=$matches[1]\";s:41:\"comments/feed/(feed|rdf|rss|rss2|atom)/?$\";s:42:\"index.php?&feed=$matches[1]&withcomments=1\";s:36:\"comments/(feed|rdf|rss|rss2|atom)/?$\";s:42:\"index.php?&feed=$matches[1]&withcomments=1\";s:17:\"comments/embed/?$\";s:21:\"index.php?&embed=true\";s:44:\"search/(.+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:40:\"index.php?s=$matches[1]&feed=$matches[2]\";s:39:\"search/(.+)/(feed|rdf|rss|rss2|atom)/?$\";s:40:\"index.php?s=$matches[1]&feed=$matches[2]\";s:20:\"search/(.+)/embed/?$\";s:34:\"index.php?s=$matches[1]&embed=true\";s:32:\"search/(.+)/page/?([0-9]{1,})/?$\";s:41:\"index.php?s=$matches[1]&paged=$matches[2]\";s:14:\"search/(.+)/?$\";s:23:\"index.php?s=$matches[1]\";s:47:\"author/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?author_name=$matches[1]&feed=$matches[2]\";s:42:\"author/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?author_name=$matches[1]&feed=$matches[2]\";s:23:\"author/([^/]+)/embed/?$\";s:44:\"index.php?author_name=$matches[1]&embed=true\";s:35:\"author/([^/]+)/page/?([0-9]{1,})/?$\";s:51:\"index.php?author_name=$matches[1]&paged=$matches[2]\";s:17:\"author/([^/]+)/?$\";s:33:\"index.php?author_name=$matches[1]\";s:69:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/feed/(feed|rdf|rss|rss2|atom)/?$\";s:80:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&feed=$matches[4]\";s:64:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/(feed|rdf|rss|rss2|atom)/?$\";s:80:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&feed=$matches[4]\";s:45:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/embed/?$\";s:74:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&embed=true\";s:57:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/page/?([0-9]{1,})/?$\";s:81:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&paged=$matches[4]\";s:39:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/?$\";s:63:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]\";s:56:\"([0-9]{4})/([0-9]{1,2})/feed/(feed|rdf|rss|rss2|atom)/?$\";s:64:\"index.php?year=$matches[1]&monthnum=$matches[2]&feed=$matches[3]\";s:51:\"([0-9]{4})/([0-9]{1,2})/(feed|rdf|rss|rss2|atom)/?$\";s:64:\"index.php?year=$matches[1]&monthnum=$matches[2]&feed=$matches[3]\";s:32:\"([0-9]{4})/([0-9]{1,2})/embed/?$\";s:58:\"index.php?year=$matches[1]&monthnum=$matches[2]&embed=true\";s:44:\"([0-9]{4})/([0-9]{1,2})/page/?([0-9]{1,})/?$\";s:65:\"index.php?year=$matches[1]&monthnum=$matches[2]&paged=$matches[3]\";s:26:\"([0-9]{4})/([0-9]{1,2})/?$\";s:47:\"index.php?year=$matches[1]&monthnum=$matches[2]\";s:43:\"([0-9]{4})/feed/(feed|rdf|rss|rss2|atom)/?$\";s:43:\"index.php?year=$matches[1]&feed=$matches[2]\";s:38:\"([0-9]{4})/(feed|rdf|rss|rss2|atom)/?$\";s:43:\"index.php?year=$matches[1]&feed=$matches[2]\";s:19:\"([0-9]{4})/embed/?$\";s:37:\"index.php?year=$matches[1]&embed=true\";s:31:\"([0-9]{4})/page/?([0-9]{1,})/?$\";s:44:\"index.php?year=$matches[1]&paged=$matches[2]\";s:13:\"([0-9]{4})/?$\";s:26:\"index.php?year=$matches[1]\";s:27:\".?.+?/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:37:\".?.+?/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:57:\".?.+?/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:52:\".?.+?/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:52:\".?.+?/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:33:\".?.+?/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:16:\"(.?.+?)/embed/?$\";s:41:\"index.php?pagename=$matches[1]&embed=true\";s:20:\"(.?.+?)/trackback/?$\";s:35:\"index.php?pagename=$matches[1]&tb=1\";s:40:\"(.?.+?)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:47:\"index.php?pagename=$matches[1]&feed=$matches[2]\";s:35:\"(.?.+?)/(feed|rdf|rss|rss2|atom)/?$\";s:47:\"index.php?pagename=$matches[1]&feed=$matches[2]\";s:28:\"(.?.+?)/page/?([0-9]{1,})/?$\";s:48:\"index.php?pagename=$matches[1]&paged=$matches[2]\";s:35:\"(.?.+?)/comment-page-([0-9]{1,})/?$\";s:48:\"index.php?pagename=$matches[1]&cpage=$matches[2]\";s:24:\"(.?.+?)(?:/([0-9]+))?/?$\";s:47:\"index.php?pagename=$matches[1]&page=$matches[2]\";s:27:\"[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:37:\"[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:57:\"[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:52:\"[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:52:\"[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:33:\"[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:16:\"([^/]+)/embed/?$\";s:37:\"index.php?name=$matches[1]&embed=true\";s:20:\"([^/]+)/trackback/?$\";s:31:\"index.php?name=$matches[1]&tb=1\";s:40:\"([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:43:\"index.php?name=$matches[1]&feed=$matches[2]\";s:35:\"([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:43:\"index.php?name=$matches[1]&feed=$matches[2]\";s:28:\"([^/]+)/page/?([0-9]{1,})/?$\";s:44:\"index.php?name=$matches[1]&paged=$matches[2]\";s:35:\"([^/]+)/comment-page-([0-9]{1,})/?$\";s:44:\"index.php?name=$matches[1]&cpage=$matches[2]\";s:24:\"([^/]+)(?:/([0-9]+))?/?$\";s:43:\"index.php?name=$matches[1]&page=$matches[2]\";s:16:\"[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:26:\"[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:46:\"[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:41:\"[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:41:\"[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:22:\"[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";}", "on");
INSERT INTO `inter_options` VALUES("31", "hack_file", "0", "on");
INSERT INTO `inter_options` VALUES("32", "blog_charset", "UTF-8", "on");
INSERT INTO `inter_options` VALUES("33", "moderation_keys", "", "off");
INSERT INTO `inter_options` VALUES("34", "active_plugins", "a:3:{i:0;s:47:\"better-search-replace/better-search-replace.php\";i:1;s:25:\"duplicator/duplicator.php\";i:2;s:73:\"hide-admin-bar-based-on-user-roles/hide-admin-bar-based-on-user-roles.php\";}", "on");
INSERT INTO `inter_options` VALUES("35", "category_base", "", "on");
INSERT INTO `inter_options` VALUES("36", "ping_sites", "https://rpc.pingomatic.com/", "on");
INSERT INTO `inter_options` VALUES("37", "comment_max_links", "2", "on");
INSERT INTO `inter_options` VALUES("38", "gmt_offset", "", "on");
INSERT INTO `inter_options` VALUES("39", "default_email_category", "1", "on");
INSERT INTO `inter_options` VALUES("40", "recently_edited", "", "off");
INSERT INTO `inter_options` VALUES("41", "template", "twentytwentyfour", "on");
INSERT INTO `inter_options` VALUES("42", "stylesheet", "inter-theme", "on");
INSERT INTO `inter_options` VALUES("43", "comment_registration", "0", "on");
INSERT INTO `inter_options` VALUES("44", "html_type", "text/html", "on");
INSERT INTO `inter_options` VALUES("45", "use_trackback", "0", "on");
INSERT INTO `inter_options` VALUES("46", "default_role", "subscriber", "on");
INSERT INTO `inter_options` VALUES("47", "db_version", "60421", "on");
INSERT INTO `inter_options` VALUES("48", "uploads_use_yearmonth_folders", "1", "on");
INSERT INTO `inter_options` VALUES("49", "upload_path", "", "on");
INSERT INTO `inter_options` VALUES("50", "blog_public", "1", "on");
INSERT INTO `inter_options` VALUES("51", "default_link_category", "2", "on");
INSERT INTO `inter_options` VALUES("52", "show_on_front", "page", "on");
INSERT INTO `inter_options` VALUES("53", "tag_base", "", "on");
INSERT INTO `inter_options` VALUES("54", "show_avatars", "1", "on");
INSERT INTO `inter_options` VALUES("55", "avatar_rating", "G", "on");
INSERT INTO `inter_options` VALUES("56", "upload_url_path", "", "on");
INSERT INTO `inter_options` VALUES("57", "thumbnail_size_w", "150", "on");
INSERT INTO `inter_options` VALUES("58", "thumbnail_size_h", "150", "on");
INSERT INTO `inter_options` VALUES("59", "thumbnail_crop", "1", "on");
INSERT INTO `inter_options` VALUES("60", "medium_size_w", "300", "on");
INSERT INTO `inter_options` VALUES("61", "medium_size_h", "300", "on");
INSERT INTO `inter_options` VALUES("62", "avatar_default", "mystery", "on");
INSERT INTO `inter_options` VALUES("63", "large_size_w", "1024", "on");
INSERT INTO `inter_options` VALUES("64", "large_size_h", "1024", "on");
INSERT INTO `inter_options` VALUES("65", "image_default_link_type", "none", "on");
INSERT INTO `inter_options` VALUES("66", "image_default_size", "", "on");
INSERT INTO `inter_options` VALUES("67", "image_default_align", "", "on");
INSERT INTO `inter_options` VALUES("68", "close_comments_for_old_posts", "0", "on");
INSERT INTO `inter_options` VALUES("69", "close_comments_days_old", "14", "on");
INSERT INTO `inter_options` VALUES("70", "thread_comments", "1", "on");
INSERT INTO `inter_options` VALUES("71", "thread_comments_depth", "5", "on");
INSERT INTO `inter_options` VALUES("72", "page_comments", "0", "on");
INSERT INTO `inter_options` VALUES("73", "comments_per_page", "50", "on");
INSERT INTO `inter_options` VALUES("74", "default_comments_page", "newest", "on");
INSERT INTO `inter_options` VALUES("75", "comment_order", "asc", "on");
INSERT INTO `inter_options` VALUES("76", "sticky_posts", "a:0:{}", "on");
INSERT INTO `inter_options` VALUES("77", "widget_categories", "a:0:{}", "on");
INSERT INTO `inter_options` VALUES("78", "widget_text", "a:0:{}", "on");
INSERT INTO `inter_options` VALUES("79", "widget_rss", "a:0:{}", "on");
INSERT INTO `inter_options` VALUES("80", "uninstall_plugins", "a:0:{}", "off");
INSERT INTO `inter_options` VALUES("81", "timezone_string", "Europe/Paris", "on");
INSERT INTO `inter_options` VALUES("82", "page_for_posts", "0", "on");
INSERT INTO `inter_options` VALUES("83", "page_on_front", "23", "on");
INSERT INTO `inter_options` VALUES("84", "default_post_format", "0", "on");
INSERT INTO `inter_options` VALUES("85", "link_manager_enabled", "0", "on");
INSERT INTO `inter_options` VALUES("86", "finished_splitting_shared_terms", "1", "on");
INSERT INTO `inter_options` VALUES("87", "site_icon", "94", "on");
INSERT INTO `inter_options` VALUES("88", "medium_large_size_w", "768", "on");
INSERT INTO `inter_options` VALUES("89", "medium_large_size_h", "0", "on");
INSERT INTO `inter_options` VALUES("90", "wp_page_for_privacy_policy", "3", "on");
INSERT INTO `inter_options` VALUES("91", "show_comments_cookies_opt_in", "1", "on");
INSERT INTO `inter_options` VALUES("92", "admin_email_lifespan", "1774203950", "on");
INSERT INTO `inter_options` VALUES("93", "disallowed_keys", "", "off");
INSERT INTO `inter_options` VALUES("94", "comment_previously_approved", "1", "on");
INSERT INTO `inter_options` VALUES("95", "auto_plugin_theme_update_emails", "a:0:{}", "off");
INSERT INTO `inter_options` VALUES("96", "auto_update_core_dev", "enabled", "on");
INSERT INTO `inter_options` VALUES("97", "auto_update_core_minor", "enabled", "on");
INSERT INTO `inter_options` VALUES("98", "auto_update_core_major", "enabled", "on");
INSERT INTO `inter_options` VALUES("99", "wp_force_deactivated_plugins", "a:0:{}", "on");
INSERT INTO `inter_options` VALUES("100", "wp_attachment_pages_enabled", "0", "on");
INSERT INTO `inter_options` VALUES("101", "initial_db_version", "60421", "on");
INSERT INTO `inter_options` VALUES("102", "inter_user_roles", "a:5:{s:13:\"administrator\";a:2:{s:4:\"name\";s:13:\"Administrator\";s:12:\"capabilities\";a:61:{s:13:\"switch_themes\";b:1;s:11:\"edit_themes\";b:1;s:16:\"activate_plugins\";b:1;s:12:\"edit_plugins\";b:1;s:10:\"edit_users\";b:1;s:10:\"edit_files\";b:1;s:14:\"manage_options\";b:1;s:17:\"moderate_comments\";b:1;s:17:\"manage_categories\";b:1;s:12:\"manage_links\";b:1;s:12:\"upload_files\";b:1;s:6:\"import\";b:1;s:15:\"unfiltered_html\";b:1;s:10:\"edit_posts\";b:1;s:17:\"edit_others_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:10:\"edit_pages\";b:1;s:4:\"read\";b:1;s:8:\"level_10\";b:1;s:7:\"level_9\";b:1;s:7:\"level_8\";b:1;s:7:\"level_7\";b:1;s:7:\"level_6\";b:1;s:7:\"level_5\";b:1;s:7:\"level_4\";b:1;s:7:\"level_3\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:17:\"edit_others_pages\";b:1;s:20:\"edit_published_pages\";b:1;s:13:\"publish_pages\";b:1;s:12:\"delete_pages\";b:1;s:19:\"delete_others_pages\";b:1;s:22:\"delete_published_pages\";b:1;s:12:\"delete_posts\";b:1;s:19:\"delete_others_posts\";b:1;s:22:\"delete_published_posts\";b:1;s:20:\"delete_private_posts\";b:1;s:18:\"edit_private_posts\";b:1;s:18:\"read_private_posts\";b:1;s:20:\"delete_private_pages\";b:1;s:18:\"edit_private_pages\";b:1;s:18:\"read_private_pages\";b:1;s:12:\"delete_users\";b:1;s:12:\"create_users\";b:1;s:17:\"unfiltered_upload\";b:1;s:14:\"edit_dashboard\";b:1;s:14:\"update_plugins\";b:1;s:14:\"delete_plugins\";b:1;s:15:\"install_plugins\";b:1;s:13:\"update_themes\";b:1;s:14:\"install_themes\";b:1;s:11:\"update_core\";b:1;s:10:\"list_users\";b:1;s:12:\"remove_users\";b:1;s:13:\"promote_users\";b:1;s:18:\"edit_theme_options\";b:1;s:13:\"delete_themes\";b:1;s:6:\"export\";b:1;}}s:6:\"editor\";a:2:{s:4:\"name\";s:6:\"Editor\";s:12:\"capabilities\";a:34:{s:17:\"moderate_comments\";b:1;s:17:\"manage_categories\";b:1;s:12:\"manage_links\";b:1;s:12:\"upload_files\";b:1;s:15:\"unfiltered_html\";b:1;s:10:\"edit_posts\";b:1;s:17:\"edit_others_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:10:\"edit_pages\";b:1;s:4:\"read\";b:1;s:7:\"level_7\";b:1;s:7:\"level_6\";b:1;s:7:\"level_5\";b:1;s:7:\"level_4\";b:1;s:7:\"level_3\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:17:\"edit_others_pages\";b:1;s:20:\"edit_published_pages\";b:1;s:13:\"publish_pages\";b:1;s:12:\"delete_pages\";b:1;s:19:\"delete_others_pages\";b:1;s:22:\"delete_published_pages\";b:1;s:12:\"delete_posts\";b:1;s:19:\"delete_others_posts\";b:1;s:22:\"delete_published_posts\";b:1;s:20:\"delete_private_posts\";b:1;s:18:\"edit_private_posts\";b:1;s:18:\"read_private_posts\";b:1;s:20:\"delete_private_pages\";b:1;s:18:\"edit_private_pages\";b:1;s:18:\"read_private_pages\";b:1;}}s:6:\"author\";a:2:{s:4:\"name\";s:6:\"Author\";s:12:\"capabilities\";a:10:{s:12:\"upload_files\";b:1;s:10:\"edit_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:4:\"read\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:12:\"delete_posts\";b:1;s:22:\"delete_published_posts\";b:1;}}s:11:\"contributor\";a:2:{s:4:\"name\";s:11:\"Contributor\";s:12:\"capabilities\";a:5:{s:10:\"edit_posts\";b:1;s:4:\"read\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:12:\"delete_posts\";b:1;}}s:10:\"subscriber\";a:2:{s:4:\"name\";s:10:\"Subscriber\";s:12:\"capabilities\";a:2:{s:4:\"read\";b:1;s:7:\"level_0\";b:1;}}}", "on");
INSERT INTO `inter_options` VALUES("103", "fresh_site", "0", "off");
INSERT INTO `inter_options` VALUES("104", "WPLANG", "fr_FR", "auto");
INSERT INTO `inter_options` VALUES("105", "user_count", "15", "off");
INSERT INTO `inter_options` VALUES("106", "widget_block", "a:6:{i:2;a:1:{s:7:\"content\";s:19:\"<!-- wp:search /-->\";}i:3;a:1:{s:7:\"content\";s:159:\"<!-- wp:group --><div class=\"wp-block-group\"><!-- wp:heading --><h2>Articles récents</h2><!-- /wp:heading --><!-- wp:latest-posts /--></div><!-- /wp:group -->\";}i:4;a:1:{s:7:\"content\";s:233:\"<!-- wp:group --><div class=\"wp-block-group\"><!-- wp:heading --><h2>Commentaires récents</h2><!-- /wp:heading --><!-- wp:latest-comments {\"displayAvatar\":false,\"displayDate\":false,\"displayExcerpt\":false} /--></div><!-- /wp:group -->\";}i:5;a:1:{s:7:\"content\";s:146:\"<!-- wp:group --><div class=\"wp-block-group\"><!-- wp:heading --><h2>Archives</h2><!-- /wp:heading --><!-- wp:archives /--></div><!-- /wp:group -->\";}i:6;a:1:{s:7:\"content\";s:151:\"<!-- wp:group --><div class=\"wp-block-group\"><!-- wp:heading --><h2>Catégories</h2><!-- /wp:heading --><!-- wp:categories /--></div><!-- /wp:group -->\";}s:12:\"_multiwidget\";i:1;}", "auto");
INSERT INTO `inter_options` VALUES("107", "sidebars_widgets", "a:2:{s:19:\"wp_inactive_widgets\";a:5:{i:0;s:7:\"block-2\";i:1;s:7:\"block-3\";i:2;s:7:\"block-4\";i:3;s:7:\"block-5\";i:4;s:7:\"block-6\";}s:13:\"array_version\";i:3;}", "auto");
INSERT INTO `inter_options` VALUES("108", "widget_pages", "a:1:{s:12:\"_multiwidget\";i:1;}", "auto");
INSERT INTO `inter_options` VALUES("109", "widget_calendar", "a:1:{s:12:\"_multiwidget\";i:1;}", "auto");
INSERT INTO `inter_options` VALUES("110", "widget_archives", "a:1:{s:12:\"_multiwidget\";i:1;}", "auto");
INSERT INTO `inter_options` VALUES("111", "widget_media_audio", "a:1:{s:12:\"_multiwidget\";i:1;}", "auto");
INSERT INTO `inter_options` VALUES("112", "widget_media_image", "a:1:{s:12:\"_multiwidget\";i:1;}", "auto");
INSERT INTO `inter_options` VALUES("113", "widget_media_gallery", "a:1:{s:12:\"_multiwidget\";i:1;}", "auto");
INSERT INTO `inter_options` VALUES("114", "widget_media_video", "a:1:{s:12:\"_multiwidget\";i:1;}", "auto");
INSERT INTO `inter_options` VALUES("115", "widget_meta", "a:1:{s:12:\"_multiwidget\";i:1;}", "auto");
INSERT INTO `inter_options` VALUES("116", "widget_search", "a:1:{s:12:\"_multiwidget\";i:1;}", "auto");
INSERT INTO `inter_options` VALUES("117", "widget_recent-posts", "a:1:{s:12:\"_multiwidget\";i:1;}", "auto");
INSERT INTO `inter_options` VALUES("118", "widget_recent-comments", "a:1:{s:12:\"_multiwidget\";i:1;}", "auto");
INSERT INTO `inter_options` VALUES("119", "widget_tag_cloud", "a:1:{s:12:\"_multiwidget\";i:1;}", "auto");
INSERT INTO `inter_options` VALUES("120", "widget_nav_menu", "a:1:{s:12:\"_multiwidget\";i:1;}", "auto");
INSERT INTO `inter_options` VALUES("121", "widget_custom_html", "a:1:{s:12:\"_multiwidget\";i:1;}", "auto");
INSERT INTO `inter_options` VALUES("122", "_transient_wp_core_block_css_files", "a:2:{s:7:\"version\";s:5:\"6.8.3\";s:5:\"files\";a:536:{i:0;s:23:\"archives/editor-rtl.css\";i:1;s:27:\"archives/editor-rtl.min.css\";i:2;s:19:\"archives/editor.css\";i:3;s:23:\"archives/editor.min.css\";i:4;s:22:\"archives/style-rtl.css\";i:5;s:26:\"archives/style-rtl.min.css\";i:6;s:18:\"archives/style.css\";i:7;s:22:\"archives/style.min.css\";i:8;s:20:\"audio/editor-rtl.css\";i:9;s:24:\"audio/editor-rtl.min.css\";i:10;s:16:\"audio/editor.css\";i:11;s:20:\"audio/editor.min.css\";i:12;s:19:\"audio/style-rtl.css\";i:13;s:23:\"audio/style-rtl.min.css\";i:14;s:15:\"audio/style.css\";i:15;s:19:\"audio/style.min.css\";i:16;s:19:\"audio/theme-rtl.css\";i:17;s:23:\"audio/theme-rtl.min.css\";i:18;s:15:\"audio/theme.css\";i:19;s:19:\"audio/theme.min.css\";i:20;s:21:\"avatar/editor-rtl.css\";i:21;s:25:\"avatar/editor-rtl.min.css\";i:22;s:17:\"avatar/editor.css\";i:23;s:21:\"avatar/editor.min.css\";i:24;s:20:\"avatar/style-rtl.css\";i:25;s:24:\"avatar/style-rtl.min.css\";i:26;s:16:\"avatar/style.css\";i:27;s:20:\"avatar/style.min.css\";i:28;s:21:\"button/editor-rtl.css\";i:29;s:25:\"button/editor-rtl.min.css\";i:30;s:17:\"button/editor.css\";i:31;s:21:\"button/editor.min.css\";i:32;s:20:\"button/style-rtl.css\";i:33;s:24:\"button/style-rtl.min.css\";i:34;s:16:\"button/style.css\";i:35;s:20:\"button/style.min.css\";i:36;s:22:\"buttons/editor-rtl.css\";i:37;s:26:\"buttons/editor-rtl.min.css\";i:38;s:18:\"buttons/editor.css\";i:39;s:22:\"buttons/editor.min.css\";i:40;s:21:\"buttons/style-rtl.css\";i:41;s:25:\"buttons/style-rtl.min.css\";i:42;s:17:\"buttons/style.css\";i:43;s:21:\"buttons/style.min.css\";i:44;s:22:\"calendar/style-rtl.css\";i:45;s:26:\"calendar/style-rtl.min.css\";i:46;s:18:\"calendar/style.css\";i:47;s:22:\"calendar/style.min.css\";i:48;s:25:\"categories/editor-rtl.css\";i:49;s:29:\"categories/editor-rtl.min.css\";i:50;s:21:\"categories/editor.css\";i:51;s:25:\"categories/editor.min.css\";i:52;s:24:\"categories/style-rtl.css\";i:53;s:28:\"categories/style-rtl.min.css\";i:54;s:20:\"categories/style.css\";i:55;s:24:\"categories/style.min.css\";i:56;s:19:\"code/editor-rtl.css\";i:57;s:23:\"code/editor-rtl.min.css\";i:58;s:15:\"code/editor.css\";i:59;s:19:\"code/editor.min.css\";i:60;s:18:\"code/style-rtl.css\";i:61;s:22:\"code/style-rtl.min.css\";i:62;s:14:\"code/style.css\";i:63;s:18:\"code/style.min.css\";i:64;s:18:\"code/theme-rtl.css\";i:65;s:22:\"code/theme-rtl.min.css\";i:66;s:14:\"code/theme.css\";i:67;s:18:\"code/theme.min.css\";i:68;s:22:\"columns/editor-rtl.css\";i:69;s:26:\"columns/editor-rtl.min.css\";i:70;s:18:\"columns/editor.css\";i:71;s:22:\"columns/editor.min.css\";i:72;s:21:\"columns/style-rtl.css\";i:73;s:25:\"columns/style-rtl.min.css\";i:74;s:17:\"columns/style.css\";i:75;s:21:\"columns/style.min.css\";i:76;s:33:\"comment-author-name/style-rtl.css\";i:77;s:37:\"comment-author-name/style-rtl.min.css\";i:78;s:29:\"comment-author-name/style.css\";i:79;s:33:\"comment-author-name/style.min.css\";i:80;s:29:\"comment-content/style-rtl.css\";i:81;s:33:\"comment-content/style-rtl.min.css\";i:82;s:25:\"comment-content/style.css\";i:83;s:29:\"comment-content/style.min.css\";i:84;s:26:\"comment-date/style-rtl.css\";i:85;s:30:\"comment-date/style-rtl.min.css\";i:86;s:22:\"comment-date/style.css\";i:87;s:26:\"comment-date/style.min.css\";i:88;s:31:\"comment-edit-link/style-rtl.css\";i:89;s:35:\"comment-edit-link/style-rtl.min.css\";i:90;s:27:\"comment-edit-link/style.css\";i:91;s:31:\"comment-edit-link/style.min.css\";i:92;s:32:\"comment-reply-link/style-rtl.css\";i:93;s:36:\"comment-reply-link/style-rtl.min.css\";i:94;s:28:\"comment-reply-link/style.css\";i:95;s:32:\"comment-reply-link/style.min.css\";i:96;s:30:\"comment-template/style-rtl.css\";i:97;s:34:\"comment-template/style-rtl.min.css\";i:98;s:26:\"comment-template/style.css\";i:99;s:30:\"comment-template/style.min.css\";i:100;s:42:\"comments-pagination-numbers/editor-rtl.css\";i:101;s:46:\"comments-pagination-numbers/editor-rtl.min.css\";i:102;s:38:\"comments-pagination-numbers/editor.css\";i:103;s:42:\"comments-pagination-numbers/editor.min.css\";i:104;s:34:\"comments-pagination/editor-rtl.css\";i:105;s:38:\"comments-pagination/editor-rtl.min.css\";i:106;s:30:\"comments-pagination/editor.css\";i:107;s:34:\"comments-pagination/editor.min.css\";i:108;s:33:\"comments-pagination/style-rtl.css\";i:109;s:37:\"comments-pagination/style-rtl.min.css\";i:110;s:29:\"comments-pagination/style.css\";i:111;s:33:\"comments-pagination/style.min.css\";i:112;s:29:\"comments-title/editor-rtl.css\";i:113;s:33:\"comments-title/editor-rtl.min.css\";i:114;s:25:\"comments-title/editor.css\";i:115;s:29:\"comments-title/editor.min.css\";i:116;s:23:\"comments/editor-rtl.css\";i:117;s:27:\"comments/editor-rtl.min.css\";i:118;s:19:\"comments/editor.css\";i:119;s:23:\"comments/editor.min.css\";i:120;s:22:\"comments/style-rtl.css\";i:121;s:26:\"comments/style-rtl.min.css\";i:122;s:18:\"comments/style.css\";i:123;s:22:\"comments/style.min.css\";i:124;s:20:\"cover/editor-rtl.css\";i:125;s:24:\"cover/editor-rtl.min.css\";i:126;s:16:\"cover/editor.css\";i:127;s:20:\"cover/editor.min.css\";i:128;s:19:\"cover/style-rtl.css\";i:129;s:23:\"cover/style-rtl.min.css\";i:130;s:15:\"cover/style.css\";i:131;s:19:\"cover/style.min.css\";i:132;s:22:\"details/editor-rtl.css\";i:133;s:26:\"details/editor-rtl.min.css\";i:134;s:18:\"details/editor.css\";i:135;s:22:\"details/editor.min.css\";i:136;s:21:\"details/style-rtl.css\";i:137;s:25:\"details/style-rtl.min.css\";i:138;s:17:\"details/style.css\";i:139;s:21:\"details/style.min.css\";i:140;s:20:\"embed/editor-rtl.css\";i:141;s:24:\"embed/editor-rtl.min.css\";i:142;s:16:\"embed/editor.css\";i:143;s:20:\"embed/editor.min.css\";i:144;s:19:\"embed/style-rtl.css\";i:145;s:23:\"embed/style-rtl.min.css\";i:146;s:15:\"embed/style.css\";i:147;s:19:\"embed/style.min.css\";i:148;s:19:\"embed/theme-rtl.css\";i:149;s:23:\"embed/theme-rtl.min.css\";i:150;s:15:\"embed/theme.css\";i:151;s:19:\"embed/theme.min.css\";i:152;s:19:\"file/editor-rtl.css\";i:153;s:23:\"file/editor-rtl.min.css\";i:154;s:15:\"file/editor.css\";i:155;s:19:\"file/editor.min.css\";i:156;s:18:\"file/style-rtl.css\";i:157;s:22:\"file/style-rtl.min.css\";i:158;s:14:\"file/style.css\";i:159;s:18:\"file/style.min.css\";i:160;s:23:\"footnotes/style-rtl.css\";i:161;s:27:\"footnotes/style-rtl.min.css\";i:162;s:19:\"footnotes/style.css\";i:163;s:23:\"footnotes/style.min.css\";i:164;s:23:\"freeform/editor-rtl.css\";i:165;s:27:\"freeform/editor-rtl.min.css\";i:166;s:19:\"freeform/editor.css\";i:167;s:23:\"freeform/editor.min.css\";i:168;s:22:\"gallery/editor-rtl.css\";i:169;s:26:\"gallery/editor-rtl.min.css\";i:170;s:18:\"gallery/editor.css\";i:171;s:22:\"gallery/editor.min.css\";i:172;s:21:\"gallery/style-rtl.css\";i:173;s:25:\"gallery/style-rtl.min.css\";i:174;s:17:\"gallery/style.css\";i:175;s:21:\"gallery/style.min.css\";i:176;s:21:\"gallery/theme-rtl.css\";i:177;s:25:\"gallery/theme-rtl.min.css\";i:178;s:17:\"gallery/theme.css\";i:179;s:21:\"gallery/theme.min.css\";i:180;s:20:\"group/editor-rtl.css\";i:181;s:24:\"group/editor-rtl.min.css\";i:182;s:16:\"group/editor.css\";i:183;s:20:\"group/editor.min.css\";i:184;s:19:\"group/style-rtl.css\";i:185;s:23:\"group/style-rtl.min.css\";i:186;s:15:\"group/style.css\";i:187;s:19:\"group/style.min.css\";i:188;s:19:\"group/theme-rtl.css\";i:189;s:23:\"group/theme-rtl.min.css\";i:190;s:15:\"group/theme.css\";i:191;s:19:\"group/theme.min.css\";i:192;s:21:\"heading/style-rtl.css\";i:193;s:25:\"heading/style-rtl.min.css\";i:194;s:17:\"heading/style.css\";i:195;s:21:\"heading/style.min.css\";i:196;s:19:\"html/editor-rtl.css\";i:197;s:23:\"html/editor-rtl.min.css\";i:198;s:15:\"html/editor.css\";i:199;s:19:\"html/editor.min.css\";i:200;s:20:\"image/editor-rtl.css\";i:201;s:24:\"image/editor-rtl.min.css\";i:202;s:16:\"image/editor.css\";i:203;s:20:\"image/editor.min.css\";i:204;s:19:\"image/style-rtl.css\";i:205;s:23:\"image/style-rtl.min.css\";i:206;s:15:\"image/style.css\";i:207;s:19:\"image/style.min.css\";i:208;s:19:\"image/theme-rtl.css\";i:209;s:23:\"image/theme-rtl.min.css\";i:210;s:15:\"image/theme.css\";i:211;s:19:\"image/theme.min.css\";i:212;s:29:\"latest-comments/style-rtl.css\";i:213;s:33:\"latest-comments/style-rtl.min.css\";i:214;s:25:\"latest-comments/style.css\";i:215;s:29:\"latest-comments/style.min.css\";i:216;s:27:\"latest-posts/editor-rtl.css\";i:217;s:31:\"latest-posts/editor-rtl.min.css\";i:218;s:23:\"latest-posts/editor.css\";i:219;s:27:\"latest-posts/editor.min.css\";i:220;s:26:\"latest-posts/style-rtl.css\";i:221;s:30:\"latest-posts/style-rtl.min.css\";i:222;s:22:\"latest-posts/style.css\";i:223;s:26:\"latest-posts/style.min.css\";i:224;s:18:\"list/style-rtl.css\";i:225;s:22:\"list/style-rtl.min.css\";i:226;s:14:\"list/style.css\";i:227;s:18:\"list/style.min.css\";i:228;s:22:\"loginout/style-rtl.css\";i:229;s:26:\"loginout/style-rtl.min.css\";i:230;s:18:\"loginout/style.css\";i:231;s:22:\"loginout/style.min.css\";i:232;s:25:\"media-text/editor-rtl.css\";i:233;s:29:\"media-text/editor-rtl.min.css\";i:234;s:21:\"media-text/editor.css\";i:235;s:25:\"media-text/editor.min.css\";i:236;s:24:\"media-text/style-rtl.css\";i:237;s:28:\"media-text/style-rtl.min.css\";i:238;s:20:\"media-text/style.css\";i:239;s:24:\"media-text/style.min.css\";i:240;s:19:\"more/editor-rtl.css\";i:241;s:23:\"more/editor-rtl.min.css\";i:242;s:15:\"more/editor.css\";i:243;s:19:\"more/editor.min.css\";i:244;s:30:\"navigation-link/editor-rtl.css\";i:245;s:34:\"navigation-link/editor-rtl.min.css\";i:246;s:26:\"navigation-link/editor.css\";i:247;s:30:\"navigation-link/editor.min.css\";i:248;s:29:\"navigation-link/style-rtl.css\";i:249;s:33:\"navigation-link/style-rtl.min.css\";i:250;s:25:\"navigation-link/style.css\";i:251;s:29:\"navigation-link/style.min.css\";i:252;s:33:\"navigation-submenu/editor-rtl.css\";i:253;s:37:\"navigation-submenu/editor-rtl.min.css\";i:254;s:29:\"navigation-submenu/editor.css\";i:255;s:33:\"navigation-submenu/editor.min.css\";i:256;s:25:\"navigation/editor-rtl.css\";i:257;s:29:\"navigation/editor-rtl.min.css\";i:258;s:21:\"navigation/editor.css\";i:259;s:25:\"navigation/editor.min.css\";i:260;s:24:\"navigation/style-rtl.css\";i:261;s:28:\"navigation/style-rtl.min.css\";i:262;s:20:\"navigation/style.css\";i:263;s:24:\"navigation/style.min.css\";i:264;s:23:\"nextpage/editor-rtl.css\";i:265;s:27:\"nextpage/editor-rtl.min.css\";i:266;s:19:\"nextpage/editor.css\";i:267;s:23:\"nextpage/editor.min.css\";i:268;s:24:\"page-list/editor-rtl.css\";i:269;s:28:\"page-list/editor-rtl.min.css\";i:270;s:20:\"page-list/editor.css\";i:271;s:24:\"page-list/editor.min.css\";i:272;s:23:\"page-list/style-rtl.css\";i:273;s:27:\"page-list/style-rtl.min.css\";i:274;s:19:\"page-list/style.css\";i:275;s:23:\"page-list/style.min.css\";i:276;s:24:\"paragraph/editor-rtl.css\";i:277;s:28:\"paragraph/editor-rtl.min.css\";i:278;s:20:\"paragraph/editor.css\";i:279;s:24:\"paragraph/editor.min.css\";i:280;s:23:\"paragraph/style-rtl.css\";i:281;s:27:\"paragraph/style-rtl.min.css\";i:282;s:19:\"paragraph/style.css\";i:283;s:23:\"paragraph/style.min.css\";i:284;s:35:\"post-author-biography/style-rtl.css\";i:285;s:39:\"post-author-biography/style-rtl.min.css\";i:286;s:31:\"post-author-biography/style.css\";i:287;s:35:\"post-author-biography/style.min.css\";i:288;s:30:\"post-author-name/style-rtl.css\";i:289;s:34:\"post-author-name/style-rtl.min.css\";i:290;s:26:\"post-author-name/style.css\";i:291;s:30:\"post-author-name/style.min.css\";i:292;s:26:\"post-author/editor-rtl.css\";i:293;s:30:\"post-author/editor-rtl.min.css\";i:294;s:22:\"post-author/editor.css\";i:295;s:26:\"post-author/editor.min.css\";i:296;s:25:\"post-author/style-rtl.css\";i:297;s:29:\"post-author/style-rtl.min.css\";i:298;s:21:\"post-author/style.css\";i:299;s:25:\"post-author/style.min.css\";i:300;s:33:\"post-comments-form/editor-rtl.css\";i:301;s:37:\"post-comments-form/editor-rtl.min.css\";i:302;s:29:\"post-comments-form/editor.css\";i:303;s:33:\"post-comments-form/editor.min.css\";i:304;s:32:\"post-comments-form/style-rtl.css\";i:305;s:36:\"post-comments-form/style-rtl.min.css\";i:306;s:28:\"post-comments-form/style.css\";i:307;s:32:\"post-comments-form/style.min.css\";i:308;s:26:\"post-content/style-rtl.css\";i:309;s:30:\"post-content/style-rtl.min.css\";i:310;s:22:\"post-content/style.css\";i:311;s:26:\"post-content/style.min.css\";i:312;s:23:\"post-date/style-rtl.css\";i:313;s:27:\"post-date/style-rtl.min.css\";i:314;s:19:\"post-date/style.css\";i:315;s:23:\"post-date/style.min.css\";i:316;s:27:\"post-excerpt/editor-rtl.css\";i:317;s:31:\"post-excerpt/editor-rtl.min.css\";i:318;s:23:\"post-excerpt/editor.css\";i:319;s:27:\"post-excerpt/editor.min.css\";i:320;s:26:\"post-excerpt/style-rtl.css\";i:321;s:30:\"post-excerpt/style-rtl.min.css\";i:322;s:22:\"post-excerpt/style.css\";i:323;s:26:\"post-excerpt/style.min.css\";i:324;s:34:\"post-featured-image/editor-rtl.css\";i:325;s:38:\"post-featured-image/editor-rtl.min.css\";i:326;s:30:\"post-featured-image/editor.css\";i:327;s:34:\"post-featured-image/editor.min.css\";i:328;s:33:\"post-featured-image/style-rtl.css\";i:329;s:37:\"post-featured-image/style-rtl.min.css\";i:330;s:29:\"post-featured-image/style.css\";i:331;s:33:\"post-featured-image/style.min.css\";i:332;s:34:\"post-navigation-link/style-rtl.css\";i:333;s:38:\"post-navigation-link/style-rtl.min.css\";i:334;s:30:\"post-navigation-link/style.css\";i:335;s:34:\"post-navigation-link/style.min.css\";i:336;s:27:\"post-template/style-rtl.css\";i:337;s:31:\"post-template/style-rtl.min.css\";i:338;s:23:\"post-template/style.css\";i:339;s:27:\"post-template/style.min.css\";i:340;s:24:\"post-terms/style-rtl.css\";i:341;s:28:\"post-terms/style-rtl.min.css\";i:342;s:20:\"post-terms/style.css\";i:343;s:24:\"post-terms/style.min.css\";i:344;s:24:\"post-title/style-rtl.css\";i:345;s:28:\"post-title/style-rtl.min.css\";i:346;s:20:\"post-title/style.css\";i:347;s:24:\"post-title/style.min.css\";i:348;s:26:\"preformatted/style-rtl.css\";i:349;s:30:\"preformatted/style-rtl.min.css\";i:350;s:22:\"preformatted/style.css\";i:351;s:26:\"preformatted/style.min.css\";i:352;s:24:\"pullquote/editor-rtl.css\";i:353;s:28:\"pullquote/editor-rtl.min.css\";i:354;s:20:\"pullquote/editor.css\";i:355;s:24:\"pullquote/editor.min.css\";i:356;s:23:\"pullquote/style-rtl.css\";i:357;s:27:\"pullquote/style-rtl.min.css\";i:358;s:19:\"pullquote/style.css\";i:359;s:23:\"pullquote/style.min.css\";i:360;s:23:\"pullquote/theme-rtl.css\";i:361;s:27:\"pullquote/theme-rtl.min.css\";i:362;s:19:\"pullquote/theme.css\";i:363;s:23:\"pullquote/theme.min.css\";i:364;s:39:\"query-pagination-numbers/editor-rtl.css\";i:365;s:43:\"query-pagination-numbers/editor-rtl.min.css\";i:366;s:35:\"query-pagination-numbers/editor.css\";i:367;s:39:\"query-pagination-numbers/editor.min.css\";i:368;s:31:\"query-pagination/editor-rtl.css\";i:369;s:35:\"query-pagination/editor-rtl.min.css\";i:370;s:27:\"query-pagination/editor.css\";i:371;s:31:\"query-pagination/editor.min.css\";i:372;s:30:\"query-pagination/style-rtl.css\";i:373;s:34:\"query-pagination/style-rtl.min.css\";i:374;s:26:\"query-pagination/style.css\";i:375;s:30:\"query-pagination/style.min.css\";i:376;s:25:\"query-title/style-rtl.css\";i:377;s:29:\"query-title/style-rtl.min.css\";i:378;s:21:\"query-title/style.css\";i:379;s:25:\"query-title/style.min.css\";i:380;s:25:\"query-total/style-rtl.css\";i:381;s:29:\"query-total/style-rtl.min.css\";i:382;s:21:\"query-total/style.css\";i:383;s:25:\"query-total/style.min.css\";i:384;s:20:\"query/editor-rtl.css\";i:385;s:24:\"query/editor-rtl.min.css\";i:386;s:16:\"query/editor.css\";i:387;s:20:\"query/editor.min.css\";i:388;s:19:\"quote/style-rtl.css\";i:389;s:23:\"quote/style-rtl.min.css\";i:390;s:15:\"quote/style.css\";i:391;s:19:\"quote/style.min.css\";i:392;s:19:\"quote/theme-rtl.css\";i:393;s:23:\"quote/theme-rtl.min.css\";i:394;s:15:\"quote/theme.css\";i:395;s:19:\"quote/theme.min.css\";i:396;s:23:\"read-more/style-rtl.css\";i:397;s:27:\"read-more/style-rtl.min.css\";i:398;s:19:\"read-more/style.css\";i:399;s:23:\"read-more/style.min.css\";i:400;s:18:\"rss/editor-rtl.css\";i:401;s:22:\"rss/editor-rtl.min.css\";i:402;s:14:\"rss/editor.css\";i:403;s:18:\"rss/editor.min.css\";i:404;s:17:\"rss/style-rtl.css\";i:405;s:21:\"rss/style-rtl.min.css\";i:406;s:13:\"rss/style.css\";i:407;s:17:\"rss/style.min.css\";i:408;s:21:\"search/editor-rtl.css\";i:409;s:25:\"search/editor-rtl.min.css\";i:410;s:17:\"search/editor.css\";i:411;s:21:\"search/editor.min.css\";i:412;s:20:\"search/style-rtl.css\";i:413;s:24:\"search/style-rtl.min.css\";i:414;s:16:\"search/style.css\";i:415;s:20:\"search/style.min.css\";i:416;s:20:\"search/theme-rtl.css\";i:417;s:24:\"search/theme-rtl.min.css\";i:418;s:16:\"search/theme.css\";i:419;s:20:\"search/theme.min.css\";i:420;s:24:\"separator/editor-rtl.css\";i:421;s:28:\"separator/editor-rtl.min.css\";i:422;s:20:\"separator/editor.css\";i:423;s:24:\"separator/editor.min.css\";i:424;s:23:\"separator/style-rtl.css\";i:425;s:27:\"separator/style-rtl.min.css\";i:426;s:19:\"separator/style.css\";i:427;s:23:\"separator/style.min.css\";i:428;s:23:\"separator/theme-rtl.css\";i:429;s:27:\"separator/theme-rtl.min.css\";i:430;s:19:\"separator/theme.css\";i:431;s:23:\"separator/theme.min.css\";i:432;s:24:\"shortcode/editor-rtl.css\";i:433;s:28:\"shortcode/editor-rtl.min.css\";i:434;s:20:\"shortcode/editor.css\";i:435;s:24:\"shortcode/editor.min.css\";i:436;s:24:\"site-logo/editor-rtl.css\";i:437;s:28:\"site-logo/editor-rtl.min.css\";i:438;s:20:\"site-logo/editor.css\";i:439;s:24:\"site-logo/editor.min.css\";i:440;s:23:\"site-logo/style-rtl.css\";i:441;s:27:\"site-logo/style-rtl.min.css\";i:442;s:19:\"site-logo/style.css\";i:443;s:23:\"site-logo/style.min.css\";i:444;s:27:\"site-tagline/editor-rtl.css\";i:445;s:31:\"site-tagline/editor-rtl.min.css\";i:446;s:23:\"site-tagline/editor.css\";i:447;s:27:\"site-tagline/editor.min.css\";i:448;s:26:\"site-tagline/style-rtl.css\";i:449;s:30:\"site-tagline/style-rtl.min.css\";i:450;s:22:\"site-tagline/style.css\";i:451;s:26:\"site-tagline/style.min.css\";i:452;s:25:\"site-title/editor-rtl.css\";i:453;s:29:\"site-title/editor-rtl.min.css\";i:454;s:21:\"site-title/editor.css\";i:455;s:25:\"site-title/editor.min.css\";i:456;s:24:\"site-title/style-rtl.css\";i:457;s:28:\"site-title/style-rtl.min.css\";i:458;s:20:\"site-title/style.css\";i:459;s:24:\"site-title/style.min.css\";i:460;s:26:\"social-link/editor-rtl.css\";i:461;s:30:\"social-link/editor-rtl.min.css\";i:462;s:22:\"social-link/editor.css\";i:463;s:26:\"social-link/editor.min.css\";i:464;s:27:\"social-links/editor-rtl.css\";i:465;s:31:\"social-links/editor-rtl.min.css\";i:466;s:23:\"social-links/editor.css\";i:467;s:27:\"social-links/editor.min.css\";i:468;s:26:\"social-links/style-rtl.css\";i:469;s:30:\"social-links/style-rtl.min.css\";i:470;s:22:\"social-links/style.css\";i:471;s:26:\"social-links/style.min.css\";i:472;s:21:\"spacer/editor-rtl.css\";i:473;s:25:\"spacer/editor-rtl.min.css\";i:474;s:17:\"spacer/editor.css\";i:475;s:21:\"spacer/editor.min.css\";i:476;s:20:\"spacer/style-rtl.css\";i:477;s:24:\"spacer/style-rtl.min.css\";i:478;s:16:\"spacer/style.css\";i:479;s:20:\"spacer/style.min.css\";i:480;s:20:\"table/editor-rtl.css\";i:481;s:24:\"table/editor-rtl.min.css\";i:482;s:16:\"table/editor.css\";i:483;s:20:\"table/editor.min.css\";i:484;s:19:\"table/style-rtl.css\";i:485;s:23:\"table/style-rtl.min.css\";i:486;s:15:\"table/style.css\";i:487;s:19:\"table/style.min.css\";i:488;s:19:\"table/theme-rtl.css\";i:489;s:23:\"table/theme-rtl.min.css\";i:490;s:15:\"table/theme.css\";i:491;s:19:\"table/theme.min.css\";i:492;s:24:\"tag-cloud/editor-rtl.css\";i:493;s:28:\"tag-cloud/editor-rtl.min.css\";i:494;s:20:\"tag-cloud/editor.css\";i:495;s:24:\"tag-cloud/editor.min.css\";i:496;s:23:\"tag-cloud/style-rtl.css\";i:497;s:27:\"tag-cloud/style-rtl.min.css\";i:498;s:19:\"tag-cloud/style.css\";i:499;s:23:\"tag-cloud/style.min.css\";i:500;s:28:\"template-part/editor-rtl.css\";i:501;s:32:\"template-part/editor-rtl.min.css\";i:502;s:24:\"template-part/editor.css\";i:503;s:28:\"template-part/editor.min.css\";i:504;s:27:\"template-part/theme-rtl.css\";i:505;s:31:\"template-part/theme-rtl.min.css\";i:506;s:23:\"template-part/theme.css\";i:507;s:27:\"template-part/theme.min.css\";i:508;s:30:\"term-description/style-rtl.css\";i:509;s:34:\"term-description/style-rtl.min.css\";i:510;s:26:\"term-description/style.css\";i:511;s:30:\"term-description/style.min.css\";i:512;s:27:\"text-columns/editor-rtl.css\";i:513;s:31:\"text-columns/editor-rtl.min.css\";i:514;s:23:\"text-columns/editor.css\";i:515;s:27:\"text-columns/editor.min.css\";i:516;s:26:\"text-columns/style-rtl.css\";i:517;s:30:\"text-columns/style-rtl.min.css\";i:518;s:22:\"text-columns/style.css\";i:519;s:26:\"text-columns/style.min.css\";i:520;s:19:\"verse/style-rtl.css\";i:521;s:23:\"verse/style-rtl.min.css\";i:522;s:15:\"verse/style.css\";i:523;s:19:\"verse/style.min.css\";i:524;s:20:\"video/editor-rtl.css\";i:525;s:24:\"video/editor-rtl.min.css\";i:526;s:16:\"video/editor.css\";i:527;s:20:\"video/editor.min.css\";i:528;s:19:\"video/style-rtl.css\";i:529;s:23:\"video/style-rtl.min.css\";i:530;s:15:\"video/style.css\";i:531;s:19:\"video/style.min.css\";i:532;s:19:\"video/theme-rtl.css\";i:533;s:23:\"video/theme-rtl.min.css\";i:534;s:15:\"video/theme.css\";i:535;s:19:\"video/theme.min.css\";}}", "on");
INSERT INTO `inter_options` VALUES("126", "recovery_keys", "a:0:{}", "off");
INSERT INTO `inter_options` VALUES("127", "theme_mods_twentytwentyfive", "a:4:{s:18:\"custom_css_post_id\";i:-1;s:16:\"sidebars_widgets\";a:2:{s:4:\"time\";i:1758652799;s:4:\"data\";a:3:{s:19:\"wp_inactive_widgets\";a:0:{}s:9:\"sidebar-1\";a:3:{i:0;s:7:\"block-2\";i:1;s:7:\"block-3\";i:2;s:7:\"block-4\";}s:9:\"sidebar-2\";a:2:{i:0;s:7:\"block-5\";i:1;s:7:\"block-6\";}}}s:19:\"wp_classic_sidebars\";a:0:{}s:18:\"nav_menu_locations\";a:0:{}}", "off");
INSERT INTO `inter_options` VALUES("128", "_transient_wp_styles_for_blocks", "a:2:{s:4:\"hash\";s:32:\"444af94dc2012062cbac8071b799bdd1\";s:6:\"blocks\";a:63:{s:11:\"core/button\";s:0:\"\";s:14:\"core/site-logo\";s:0:\"\";s:18:\"core/post-template\";s:0:\"\";s:12:\"core/columns\";s:0:\"\";s:14:\"core/pullquote\";s:347:\":root :where(.wp-block-pullquote){border-radius: var(--wp--preset--spacing--20);font-family: var(--wp--preset--font-family--heading);font-size: var(--wp--preset--font-size--x-large);font-style: italic;font-weight: 400;letter-spacing: 0em;line-height: 1.5;padding-top: var(--wp--preset--spacing--40);padding-bottom: var(--wp--preset--spacing--40);}\";s:32:\"c48738dcb285a3f6ab83acff204fc486\";s:157:\":root :where(.wp-block-pullquote cite){font-family: var(--wp--preset--font-family--body);font-size: var(--wp--preset--font-size--medium);font-style: normal;}\";s:11:\"core/avatar\";s:56:\":root :where(.wp-block-avatar img){border-radius: 90px;}\";s:12:\"core/buttons\";s:673:\":root :where(.wp-block-buttons-is-layout-flow) > :first-child{margin-block-start: 0;}:root :where(.wp-block-buttons-is-layout-flow) > :last-child{margin-block-end: 0;}:root :where(.wp-block-buttons-is-layout-flow) > *{margin-block-start: 0.7rem;margin-block-end: 0;}:root :where(.wp-block-buttons-is-layout-constrained) > :first-child{margin-block-start: 0;}:root :where(.wp-block-buttons-is-layout-constrained) > :last-child{margin-block-end: 0;}:root :where(.wp-block-buttons-is-layout-constrained) > *{margin-block-start: 0.7rem;margin-block-end: 0;}:root :where(.wp-block-buttons-is-layout-flex){gap: 0.7rem;}:root :where(.wp-block-buttons-is-layout-grid){gap: 0.7rem;}\";s:13:\"core/calendar\";s:456:\":root :where(.wp-block-calendar table, .wp-block-calendar th){color: var(--wp--preset--color--contrast);}:root :where(.wp-block-calendar.wp-block-calendar table:where(:not(.has-text-color)) th){background-color:var(--wp--preset--color--contrast-2);color:var(--wp--preset--color--base);border-color:var(--wp--preset--color--contrast-2)}:root :where(.wp-block-calendar table:where(:not(.has-text-color)) td){border-color:var(--wp--preset--color--contrast-2)}\";s:15:\"core/categories\";s:191:\":root :where(.wp-block-categories){padding-right: 0px;padding-left: 0px;}:root :where(.wp-block-categories){list-style-type:none;}:root :where(.wp-block-categories li){margin-bottom: 0.5rem;}\";s:9:\"core/code\";s:567:\":root :where(.wp-block-code){background-color: var(--wp--preset--color--base-2);border-radius: var(--wp--preset--spacing--20);border-color: var(--wp--preset--color--contrast);color: var(--wp--preset--color--contrast-2);font-size: var(--wp--preset--font-size--medium);font-style: normal;font-weight: 400;line-height: 1.6;padding-top: calc(var(--wp--preset--spacing--30) + 0.75rem);padding-right: calc(var(--wp--preset--spacing--30) + 0.75rem);padding-bottom: calc(var(--wp--preset--spacing--30) + 0.75rem);padding-left: calc(var(--wp--preset--spacing--30) + 0.75rem);}\";s:24:\"core/comment-author-name\";s:170:\":root :where(.wp-block-comment-author-name){color: var(--wp--preset--color--contrast);font-size: var(--wp--preset--font-size--small);font-style: normal;font-weight: 600;}\";s:32:\"c0002c260f8238c4212f3e4c369fc4f7\";s:143:\":root :where(.wp-block-comment-author-name a:where(:not(.wp-element-button))){color: var(--wp--preset--color--contrast);text-decoration: none;}\";s:32:\"1e7c38b45537b325dbbbaec17a301676\";s:112:\":root :where(.wp-block-comment-author-name a:where(:not(.wp-element-button)):hover){text-decoration: underline;}\";s:20:\"core/comment-content\";s:177:\":root :where(.wp-block-comment-content){font-size: var(--wp--preset--font-size--small);margin-top: var(--wp--preset--spacing--20);margin-bottom: var(--wp--preset--spacing--20);}\";s:17:\"core/comment-date\";s:164:\":root :where(.wp-block-comment-date){color: var(--wp--preset--color--contrast-2);font-size: var(--wp--preset--font-size--small);margin-top: 0px;margin-bottom: 0px;}\";s:32:\"c83ca7b3e52884c70f7830c54f99b318\";s:138:\":root :where(.wp-block-comment-date a:where(:not(.wp-element-button))){color: var(--wp--preset--color--contrast-2);text-decoration: none;}\";s:32:\"7a05169cd0e6c7a5390492b955f8fd3d\";s:105:\":root :where(.wp-block-comment-date a:where(:not(.wp-element-button)):hover){text-decoration: underline;}\";s:22:\"core/comment-edit-link\";s:90:\":root :where(.wp-block-comment-edit-link){font-size: var(--wp--preset--font-size--small);}\";s:32:\"41d70710612536a90e368c12bcb0efea\";s:143:\":root :where(.wp-block-comment-edit-link a:where(:not(.wp-element-button))){color: var(--wp--preset--color--contrast-2);text-decoration: none;}\";s:32:\"9c12982bf0f274860d94c3aa18230c84\";s:110:\":root :where(.wp-block-comment-edit-link a:where(:not(.wp-element-button)):hover){text-decoration: underline;}\";s:23:\"core/comment-reply-link\";s:91:\":root :where(.wp-block-comment-reply-link){font-size: var(--wp--preset--font-size--small);}\";s:32:\"13c96340dbf37700add1f4c5cae19f3e\";s:144:\":root :where(.wp-block-comment-reply-link a:where(:not(.wp-element-button))){color: var(--wp--preset--color--contrast-2);text-decoration: none;}\";s:32:\"f8339fa97df92f99a6b4eac7a6597226\";s:111:\":root :where(.wp-block-comment-reply-link a:where(:not(.wp-element-button)):hover){text-decoration: underline;}\";s:23:\"core/post-comments-form\";s:109:\":root :where(.wp-block-post-comments-form textarea, .wp-block-post-comments-form input){border-radius:.33rem}\";s:24:\"core/comments-pagination\";s:92:\":root :where(.wp-block-comments-pagination){font-size: var(--wp--preset--font-size--small);}\";s:29:\"core/comments-pagination-next\";s:97:\":root :where(.wp-block-comments-pagination-next){font-size: var(--wp--preset--font-size--small);}\";s:32:\"core/comments-pagination-numbers\";s:100:\":root :where(.wp-block-comments-pagination-numbers){font-size: var(--wp--preset--font-size--small);}\";s:33:\"core/comments-pagination-previous\";s:101:\":root :where(.wp-block-comments-pagination-previous){font-size: var(--wp--preset--font-size--small);}\";s:14:\"core/footnotes\";s:82:\":root :where(.wp-block-footnotes){font-size: var(--wp--preset--font-size--small);}\";s:12:\"core/gallery\";s:79:\":root :where(.wp-block-gallery){margin-bottom: var(--wp--preset--spacing--50);}\";s:10:\"core/image\";s:0:\"\";s:9:\"core/list\";s:75:\":root :where(.wp-block-list){padding-left: var(--wp--preset--spacing--10);}\";s:13:\"core/loginout\";s:114:\":root :where(.wp-block-loginout input){border-radius:.33rem;padding:calc(0.667em + 2px);border:1px solid #949494;}\";s:15:\"core/navigation\";s:53:\":root :where(.wp-block-navigation){font-weight: 500;}\";s:32:\"25289a01850f5a0264ddb79a9a3baf3d\";s:92:\":root :where(.wp-block-navigation a:where(:not(.wp-element-button))){text-decoration: none;}\";s:32:\"026c04da08398d655a95047f1f235d97\";s:103:\":root :where(.wp-block-navigation a:where(:not(.wp-element-button)):hover){text-decoration: underline;}\";s:16:\"core/post-author\";s:84:\":root :where(.wp-block-post-author){font-size: var(--wp--preset--font-size--small);}\";s:21:\"core/post-author-name\";s:89:\":root :where(.wp-block-post-author-name){font-size: var(--wp--preset--font-size--small);}\";s:32:\"5e6daa05ce887f9195642ee978692d48\";s:98:\":root :where(.wp-block-post-author-name a:where(:not(.wp-element-button))){text-decoration: none;}\";s:32:\"9a762eac1c7e11f5da88ab6368f7855f\";s:109:\":root :where(.wp-block-post-author-name a:where(:not(.wp-element-button)):hover){text-decoration: underline;}\";s:14:\"core/post-date\";s:126:\":root :where(.wp-block-post-date){color: var(--wp--preset--color--contrast-2);font-size: var(--wp--preset--font-size--small);}\";s:32:\"ac0d4e00f5ec22d14451759983e5bd43\";s:135:\":root :where(.wp-block-post-date a:where(:not(.wp-element-button))){color: var(--wp--preset--color--contrast-2);text-decoration: none;}\";s:32:\"0ae6ffd1b886044c2da62d75d05ab13d\";s:102:\":root :where(.wp-block-post-date a:where(:not(.wp-element-button)):hover){text-decoration: underline;}\";s:17:\"core/post-excerpt\";s:55:\":root :where(.wp-block-post-excerpt){line-height: 1.6;}\";s:24:\"core/post-featured-image\";s:228:\":root :where(.wp-block-post-featured-image img, .wp-block-post-featured-image .block-editor-media-placeholder, .wp-block-post-featured-image .wp-block-post-featured-image__overlay){border-radius: var(--wp--preset--spacing--20);}\";s:15:\"core/post-terms\";s:192:\":root :where(.wp-block-post-terms){font-size: var(--wp--preset--font-size--small);}:root :where(.wp-block-post-terms .wp-block-post-terms__prefix){color: var(--wp--preset--color--contrast-2);}\";s:32:\"b7c958776cf894ff147e343b0c9ddf57\";s:92:\":root :where(.wp-block-post-terms a:where(:not(.wp-element-button))){text-decoration: none;}\";s:32:\"eb904b88c81440705e2673cf9a778b66\";s:103:\":root :where(.wp-block-post-terms a:where(:not(.wp-element-button)):hover){text-decoration: underline;}\";s:15:\"core/post-title\";s:0:\"\";s:32:\"bb496d3fcd9be3502ce57ff8281e5687\";s:92:\":root :where(.wp-block-post-title a:where(:not(.wp-element-button))){text-decoration: none;}\";s:32:\"12380ab98fdc81351bb32a39bbfc9249\";s:103:\":root :where(.wp-block-post-title a:where(:not(.wp-element-button)):hover){text-decoration: underline;}\";s:16:\"core/query-title\";s:61:\":root :where(.wp-block-query-title span){font-style: italic;}\";s:21:\"core/query-no-results\";s:86:\":root :where(.wp-block-query-no-results){padding-top: var(--wp--preset--spacing--30);}\";s:10:\"core/quote\";s:1316:\":root :where(.wp-block-quote){background-color: var(--wp--preset--color--base-2);border-radius: var(--wp--preset--spacing--20);font-family: var(--wp--preset--font-family--heading);font-size: var(--wp--preset--font-size--large);font-style: italic;line-height: 1.3;padding-top: calc(var(--wp--preset--spacing--30) + 0.75rem);padding-right: calc(var(--wp--preset--spacing--30) + 0.75rem);padding-bottom: calc(var(--wp--preset--spacing--30) + 0.75rem);padding-left: calc(var(--wp--preset--spacing--30) + 0.75rem);}:root :where(.wp-block-quote :where(p)){margin-block-start:0;margin-block-end:calc(var(--wp--preset--spacing--10) + 0.5rem);}:root :where(.wp-block-quote :where(:last-child)){margin-block-end:0;}:root :where(.wp-block-quote.has-text-align-right.is-style-plain, .rtl .is-style-plain.wp-block-quote:not(.has-text-align-center):not(.has-text-align-left)){border-width: 0 2px 0 0;padding-left:calc(var(--wp--preset--spacing--20) + 0.5rem);padding-right:calc(var(--wp--preset--spacing--20) + 0.5rem);}:root :where(.wp-block-quote.has-text-align-left.is-style-plain, body:not(.rtl) .is-style-plain.wp-block-quote:not(.has-text-align-center):not(.has-text-align-right)){border-width: 0 0 0 2px;padding-left:calc(var(--wp--preset--spacing--20) + 0.5rem);padding-right:calc(var(--wp--preset--spacing--20) + 0.5rem)}\";s:32:\"1de7a22e22013106efc5be82788cb6c0\";s:152:\":root :where(.wp-block-quote cite){font-family: var(--wp--preset--font-family--body);font-size: var(--wp--preset--font-size--small);font-style: normal;}\";s:11:\"core/search\";s:264:\":root :where(.wp-block-search .wp-block-search__label, .wp-block-search .wp-block-search__input, .wp-block-search .wp-block-search__button){font-size: var(--wp--preset--font-size--small);}:root :where(.wp-block-search .wp-block-search__input){border-radius:.33rem}\";s:32:\"14fa6a3d0cfbde171cbc0fb04aa8a6cf\";s:114:\":root :where(.wp-block-search .wp-element-button,.wp-block-search  .wp-block-button__link){border-radius: .33rem;}\";s:14:\"core/separator\";s:327:\":root :where(.wp-block-separator){border-color: currentColor;border-width: 0 0 1px 0;border-style: solid;color: var(--wp--preset--color--contrast);}:root :where(.wp-block-separator){}:root :where(.wp-block-separator:not(.is-style-wide):not(.is-style-dots):not(.alignwide):not(.alignfull)){width: var(--wp--preset--spacing--60)}\";s:17:\"core/site-tagline\";s:129:\":root :where(.wp-block-site-tagline){color: var(--wp--preset--color--contrast-2);font-size: var(--wp--preset--font-size--small);}\";s:15:\"core/site-title\";s:194:\":root :where(.wp-block-site-title){font-family: var(--wp--preset--font-family--body);font-size: clamp(0.875rem, 0.875rem + ((1vw - 0.2rem) * 0.542), 1.2rem);font-style: normal;font-weight: 600;}\";s:32:\"f513d889cf971b13995cc3fffed2f39b\";s:92:\":root :where(.wp-block-site-title a:where(:not(.wp-element-button))){text-decoration: none;}\";s:32:\"22c37a317cc0ebd50155b5ad78564f37\";s:98:\":root :where(.wp-block-site-title a:where(:not(.wp-element-button)):hover){text-decoration: none;}\";}}", "on");
INSERT INTO `inter_options` VALUES("141", "can_compress_scripts", "1", "on");
INSERT INTO `inter_options` VALUES("160", "finished_updating_comment_type", "1", "auto");
INSERT INTO `inter_options` VALUES("162", "current_theme", "Intermitent site", "auto");
INSERT INTO `inter_options` VALUES("163", "theme_mods_intertheme", "a:4:{i:0;b:0;s:19:\"wp_classic_sidebars\";a:0:{}s:18:\"nav_menu_locations\";a:0:{}s:16:\"sidebars_widgets\";a:2:{s:4:\"time\";i:1758652795;s:4:\"data\";a:1:{s:19:\"wp_inactive_widgets\";a:5:{i:0;s:7:\"block-2\";i:1;s:7:\"block-3\";i:2;s:7:\"block-4\";i:3;s:7:\"block-5\";i:4;s:7:\"block-6\";}}}}", "off");
INSERT INTO `inter_options` VALUES("164", "theme_switched", "", "auto");
INSERT INTO `inter_options` VALUES("173", "theme_mods_inter-theme", "a:5:{i:0;b:0;s:19:\"wp_classic_sidebars\";a:0:{}s:18:\"nav_menu_locations\";a:0:{}s:18:\"custom_css_post_id\";i:-1;s:16:\"sidebars_widgets\";a:2:{s:4:\"time\";i:1759770319;s:4:\"data\";a:1:{s:19:\"wp_inactive_widgets\";a:5:{i:0;s:7:\"block-2\";i:1;s:7:\"block-3\";i:2;s:7:\"block-4\";i:3;s:7:\"block-5\";i:4;s:7:\"block-6\";}}}}", "on");
INSERT INTO `inter_options` VALUES("180", "theme_mods_twentytwentyfour", "a:5:{i:0;b:0;s:19:\"wp_classic_sidebars\";a:0:{}s:18:\"nav_menu_locations\";a:0:{}s:18:\"custom_css_post_id\";i:-1;s:16:\"sidebars_widgets\";a:2:{s:4:\"time\";i:1759770612;s:4:\"data\";a:1:{s:19:\"wp_inactive_widgets\";a:5:{i:0;s:7:\"block-2\";i:1;s:7:\"block-3\";i:2;s:7:\"block-4\";i:3;s:7:\"block-5\";i:4;s:7:\"block-6\";}}}}", "off");
INSERT INTO `inter_options` VALUES("188", "_transient_health-check-site-status-result", "{\"good\":16,\"recommended\":7,\"critical\":0}", "on");
INSERT INTO `inter_options` VALUES("313", "auto_core_update_notified", "a:4:{s:4:\"type\";s:7:\"success\";s:5:\"email\";s:26:\"ambre.palanque@hotmail.com\";s:7:\"version\";s:5:\"6.8.3\";s:9:\"timestamp\";i:1759590028;}", "off");
INSERT INTO `inter_options` VALUES("338", "recovery_mode_email_last_sent", "1759591753", "auto");
INSERT INTO `inter_options` VALUES("341", "_site_transient_wp_plugin_dependencies_plugin_data", "a:0:{}", "off");
INSERT INTO `inter_options` VALUES("342", "recently_activated", "a:1:{s:29:\"wp-mail-smtp/wp_mail_smtp.php\";i:1760985584;}", "off");
INSERT INTO `inter_options` VALUES("357", "site_logo", "18", "auto");
INSERT INTO `inter_options` VALUES("358", "wp_calendar_block_has_published_posts", "", "auto");
INSERT INTO `inter_options` VALUES("535", "fs_active_plugins", "O:8:\"stdClass\":3:{s:7:\"plugins\";a:1:{s:52:\"hide-admin-bar-based-on-user-roles/includes/freemius\";O:8:\"stdClass\":4:{s:7:\"version\";s:6:\"2.12.0\";s:4:\"type\";s:6:\"plugin\";s:9:\"timestamp\";i:1759784938;s:11:\"plugin_path\";s:73:\"hide-admin-bar-based-on-user-roles/hide-admin-bar-based-on-user-roles.php\";}}s:7:\"abspath\";s:54:\"/Applications/MAMP/htdocs/localsites/intermitent_site/\";s:6:\"newest\";O:8:\"stdClass\":5:{s:11:\"plugin_path\";s:73:\"hide-admin-bar-based-on-user-roles/hide-admin-bar-based-on-user-roles.php\";s:8:\"sdk_path\";s:52:\"hide-admin-bar-based-on-user-roles/includes/freemius\";s:7:\"version\";s:6:\"2.12.0\";s:13:\"in_activation\";b:0;s:9:\"timestamp\";i:1759784938;}}", "auto");
INSERT INTO `inter_options` VALUES("536", "fs_debug_mode", "", "auto");
INSERT INTO `inter_options` VALUES("537", "fs_accounts", "a:8:{s:21:\"id_slug_type_path_map\";a:1:{i:18739;a:3:{s:4:\"slug\";s:34:\"hide-admin-bar-based-on-user-roles\";s:4:\"type\";s:6:\"plugin\";s:4:\"path\";s:73:\"hide-admin-bar-based-on-user-roles/hide-admin-bar-based-on-user-roles.php\";}}s:11:\"plugin_data\";a:1:{s:34:\"hide-admin-bar-based-on-user-roles\";a:17:{s:19:\"last_load_timestamp\";i:1761316581;s:16:\"plugin_main_file\";O:8:\"stdClass\":1:{s:4:\"path\";s:73:\"hide-admin-bar-based-on-user-roles/hide-admin-bar-based-on-user-roles.php\";}s:20:\"is_network_activated\";b:0;s:17:\"install_timestamp\";i:1759784938;s:17:\"was_plugin_loaded\";b:1;s:21:\"is_plugin_new_install\";b:1;s:16:\"sdk_last_version\";N;s:11:\"sdk_version\";s:6:\"2.12.0\";s:16:\"sdk_upgrade_mode\";b:1;s:18:\"sdk_downgrade_mode\";b:0;s:19:\"plugin_last_version\";N;s:14:\"plugin_version\";s:5:\"6.0.4\";s:19:\"plugin_upgrade_mode\";b:1;s:21:\"plugin_downgrade_mode\";b:0;s:17:\"connectivity_test\";a:6:{s:12:\"is_connected\";N;s:4:\"host\";s:14:\"localhost:8888\";s:9:\"server_ip\";s:3:\"::1\";s:9:\"is_active\";b:1;s:9:\"timestamp\";i:1759784938;s:7:\"version\";s:5:\"6.0.4\";}s:15:\"prev_is_premium\";b:0;s:21:\"is_pending_activation\";b:1;}}s:13:\"file_slug_map\";a:1:{s:73:\"hide-admin-bar-based-on-user-roles/hide-admin-bar-based-on-user-roles.php\";s:34:\"hide-admin-bar-based-on-user-roles\";}s:7:\"plugins\";a:1:{s:34:\"hide-admin-bar-based-on-user-roles\";O:9:\"FS_Plugin\":24:{s:2:\"id\";s:5:\"18739\";s:7:\"updated\";N;s:7:\"created\";N;s:22:\"\0FS_Entity\0_is_updated\";b:0;s:10:\"public_key\";s:32:\"pk_86e4f935219abb51f4bba4983e178\";s:10:\"secret_key\";N;s:16:\"parent_plugin_id\";N;s:5:\"title\";s:34:\"Hide Admin Bar Based on User Roles\";s:4:\"slug\";s:34:\"hide-admin-bar-based-on-user-roles\";s:12:\"premium_slug\";s:38:\"hide-admin-bar-based-on-user-roles-pro\";s:4:\"type\";s:6:\"plugin\";s:20:\"affiliate_moderation\";s:8:\"selected\";s:19:\"is_wp_org_compliant\";b:1;s:22:\"premium_releases_count\";N;s:4:\"file\";s:73:\"hide-admin-bar-based-on-user-roles/hide-admin-bar-based-on-user-roles.php\";s:7:\"version\";s:5:\"6.0.4\";s:11:\"auto_update\";N;s:4:\"info\";N;s:10:\"is_premium\";b:0;s:14:\"premium_suffix\";s:3:\"Pro\";s:7:\"is_live\";b:1;s:9:\"bundle_id\";N;s:17:\"bundle_public_key\";N;s:17:\"opt_in_moderation\";N;}}s:12:\"gc_timestamp\";a:0:{}s:10:\"theme_data\";a:0:{}s:9:\"unique_id\";s:32:\"56212cf92a69e5f7a5ecdb9c61703630\";s:13:\"admin_notices\";a:1:{s:34:\"hide-admin-bar-based-on-user-roles\";a:1:{s:18:\"activation_pending\";a:10:{s:7:\"message\";s:215:\"You should receive a confirmation email for <b>Hide Admin Bar Based on User Roles</b> to your mailbox at <b>ambre.palanque@hotmail.com</b>. Please make sure you click the button in that email to complete the opt-in.\";s:5:\"title\";s:7:\"Thanks!\";s:4:\"type\";s:7:\"success\";s:6:\"sticky\";b:1;s:2:\"id\";s:18:\"activation_pending\";s:10:\"manager_id\";s:34:\"hide-admin-bar-based-on-user-roles\";s:6:\"plugin\";s:34:\"Hide Admin Bar Based on User Roles\";s:10:\"wp_user_id\";N;s:11:\"dismissible\";b:1;s:4:\"data\";a:0:{}}}}}", "auto");
INSERT INTO `inter_options` VALUES("538", "fs_api_cache", "a:1:{s:31:\"get:/v1/plugins/18739/info.json\";O:8:\"stdClass\":3:{s:6:\"result\";O:8:\"stdClass\":14:{s:9:\"plugin_id\";s:5:\"18739\";s:3:\"url\";N;s:11:\"description\";N;s:17:\"short_description\";N;s:10:\"banner_url\";N;s:15:\"card_banner_url\";N;s:15:\"selling_point_0\";N;s:15:\"selling_point_1\";N;s:15:\"selling_point_2\";N;s:11:\"screenshots\";N;s:2:\"id\";s:4:\"4976\";s:7:\"created\";s:19:\"2025-04-18 08:04:37\";s:7:\"updated\";N;s:4:\"icon\";s:100:\"https://s3-us-west-2.amazonaws.com/freemius/plugins/18739/icons/73ff8deb21a51bb78bbc87732fcf26d2.png\";}s:7:\"created\";i:1759784938;s:9:\"timestamp\";i:1760389738;}}", "off");
INSERT INTO `inter_options` VALUES("541", "hab_settings", "a:4:{s:17:\"hab_disableforall\";s:2:\"no\";s:13:\"hab_userRoles\";a:1:{i:0;s:10:\"subscriber\";}s:16:\"hab_capabilities\";s:0:\"\";s:23:\"hab_disableforallGuests\";s:2:\"no\";}", "auto");
INSERT INTO `inter_options` VALUES("542", "hab_reset_key", "514356805", "auto");
INSERT INTO `inter_options` VALUES("545", "hab_plugin_install_date", "1759784941", "auto");
INSERT INTO `inter_options` VALUES("632", "category_children", "a:0:{}", "auto");
INSERT INTO `inter_options` VALUES("638", "sport_children", "a:1:{i:6;a:2:{i:0;i:7;i:1;i:8;}}", "auto");
INSERT INTO `inter_options` VALUES("814", "new_admin_email", "ambre.palanque@hotmail.com", "auto");
INSERT INTO `inter_options` VALUES("1209", "permis_children", "a:2:{i:67;a:11:{i:0;i:40;i:1;i:41;i:2;i:42;i:3;i:43;i:4;i:45;i:5;i:46;i:6;i:47;i:7;i:48;i:8;i:49;i:9;i:50;i:10;i:51;}i:66;a:8:{i:0;i:53;i:1;i:54;i:2;i:55;i:3;i:56;i:4;i:57;i:5;i:58;i:6;i:59;i:7;i:60;}}", "auto");
INSERT INTO `inter_options` VALUES("1637", "region_children", "a:0:{}", "auto");
INSERT INTO `inter_options` VALUES("1654", "action_scheduler_hybrid_store_demarkation", "81", "auto");
INSERT INTO `inter_options` VALUES("1655", "schema-ActionScheduler_StoreSchema", "7.0.1760984579", "auto");
INSERT INTO `inter_options` VALUES("1656", "schema-ActionScheduler_LoggerSchema", "3.0.1760984579", "auto");
INSERT INTO `inter_options` VALUES("1657", "wp_mail_smtp_initial_version", "4.6.0", "off");
INSERT INTO `inter_options` VALUES("1658", "wp_mail_smtp_version", "4.6.0", "off");
INSERT INTO `inter_options` VALUES("1659", "wp_mail_smtp", "a:3:{s:4:\"mail\";a:6:{s:10:\"from_email\";s:26:\"ambre.palanque@hotmail.com\";s:9:\"from_name\";s:0:\"\";s:6:\"mailer\";s:10:\"sendinblue\";s:11:\"return_path\";b:0;s:16:\"from_email_force\";b:1;s:15:\"from_name_force\";b:0;}s:4:\"smtp\";a:2:{s:7:\"autotls\";b:1;s:4:\"auth\";b:1;}s:7:\"general\";a:1:{s:29:\"summary_report_email_disabled\";b:0;}}", "off");
INSERT INTO `inter_options` VALUES("1660", "wp_mail_smtp_activated_time", "1760984579", "off");
INSERT INTO `inter_options` VALUES("1661", "wp_mail_smtp_activated", "a:1:{s:4:\"lite\";i:1760984579;}", "auto");
INSERT INTO `inter_options` VALUES("1666", "action_scheduler_lock_async-request-runner", "68f681e5b75875.72811268|1760985633", "no");
INSERT INTO `inter_options` VALUES("1670", "wp_mail_smtp_migration_version", "5", "on");
INSERT INTO `inter_options` VALUES("1671", "wp_mail_smtp_debug_events_db_version", "1", "on");
INSERT INTO `inter_options` VALUES("1672", "wp_mail_smtp_activation_prevent_redirect", "1", "auto");
INSERT INTO `inter_options` VALUES("1673", "wp_mail_smtp_setup_wizard_stats", "a:3:{s:13:\"launched_time\";i:1760985491;s:14:\"completed_time\";i:0;s:14:\"was_successful\";b:0;}", "off");
INSERT INTO `inter_options` VALUES("1676", "as_has_wp_comment_logs", "no", "on");
INSERT INTO `inter_options` VALUES("1679", "wp_mail_smtp_review_notice", "a:2:{s:4:\"time\";i:1760984653;s:9:\"dismissed\";b:0;}", "auto");
INSERT INTO `inter_options` VALUES("1681", "wp_mail_smtp_notifications", "a:4:{s:6:\"update\";i:1760984722;s:4:\"feed\";a:0:{}s:6:\"events\";a:0:{}s:9:\"dismissed\";a:0:{}}", "auto");
INSERT INTO `inter_options` VALUES("1819", "_site_transient_timeout_browser_df4bf04f9bf7b6af09e3e94179733770", "1761671437", "off");
INSERT INTO `inter_options` VALUES("1820", "_site_transient_browser_df4bf04f9bf7b6af09e3e94179733770", "a:10:{s:4:\"name\";s:6:\"Chrome\";s:7:\"version\";s:9:\"139.0.0.0\";s:8:\"platform\";s:9:\"Macintosh\";s:10:\"update_url\";s:29:\"https://www.google.com/chrome\";s:7:\"img_src\";s:43:\"http://s.w.org/images/browsers/chrome.png?1\";s:11:\"img_src_ssl\";s:44:\"https://s.w.org/images/browsers/chrome.png?1\";s:15:\"current_version\";s:2:\"18\";s:7:\"upgrade\";b:0;s:8:\"insecure\";b:0;s:6:\"mobile\";b:0;}", "off");
INSERT INTO `inter_options` VALUES("1920", "bsr_data", "a:8:{s:13:\"select_tables\";a:1:{i:0;s:28:\"inter_actionscheduler_claims\";}s:16:\"case_insensitive\";s:3:\"off\";s:13:\"replace_guids\";s:3:\"off\";s:7:\"dry_run\";s:2:\"on\";s:10:\"search_for\";s:5:\"local\";s:12:\"replace_with\";s:0:\"\";s:15:\"completed_pages\";i:1;s:11:\"total_pages\";i:1;}", "auto");
INSERT INTO `inter_options` VALUES("1926", "_site_transient_update_core", "O:8:\"stdClass\":4:{s:7:\"updates\";a:1:{i:0;O:8:\"stdClass\":10:{s:8:\"response\";s:6:\"latest\";s:8:\"download\";s:65:\"https://downloads.wordpress.org/release/fr_FR/wordpress-6.8.3.zip\";s:6:\"locale\";s:5:\"fr_FR\";s:8:\"packages\";O:8:\"stdClass\":5:{s:4:\"full\";s:65:\"https://downloads.wordpress.org/release/fr_FR/wordpress-6.8.3.zip\";s:10:\"no_content\";s:0:\"\";s:11:\"new_bundled\";s:0:\"\";s:7:\"partial\";s:0:\"\";s:8:\"rollback\";s:0:\"\";}s:7:\"current\";s:5:\"6.8.3\";s:7:\"version\";s:5:\"6.8.3\";s:11:\"php_version\";s:6:\"7.2.24\";s:13:\"mysql_version\";s:5:\"5.5.5\";s:11:\"new_bundled\";s:3:\"6.7\";s:15:\"partial_version\";s:0:\"\";}}s:12:\"last_checked\";i:1761314624;s:15:\"version_checked\";s:5:\"6.8.3\";s:12:\"translations\";a:0:{}}", "off");
INSERT INTO `inter_options` VALUES("1928", "_site_transient_update_themes", "O:8:\"stdClass\":5:{s:12:\"last_checked\";i:1761314624;s:7:\"checked\";a:4:{s:11:\"inter-theme\";s:5:\"0.1.0\";s:16:\"twentytwentyfive\";s:3:\"1.3\";s:16:\"twentytwentyfour\";s:3:\"1.3\";s:17:\"twentytwentythree\";s:3:\"1.6\";}s:8:\"response\";a:0:{}s:9:\"no_update\";a:3:{s:16:\"twentytwentyfive\";a:6:{s:5:\"theme\";s:16:\"twentytwentyfive\";s:11:\"new_version\";s:3:\"1.3\";s:3:\"url\";s:46:\"https://wordpress.org/themes/twentytwentyfive/\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/theme/twentytwentyfive.1.3.zip\";s:8:\"requires\";s:3:\"6.7\";s:12:\"requires_php\";s:3:\"7.2\";}s:16:\"twentytwentyfour\";a:6:{s:5:\"theme\";s:16:\"twentytwentyfour\";s:11:\"new_version\";s:3:\"1.3\";s:3:\"url\";s:46:\"https://wordpress.org/themes/twentytwentyfour/\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/theme/twentytwentyfour.1.3.zip\";s:8:\"requires\";s:3:\"6.4\";s:12:\"requires_php\";s:3:\"7.0\";}s:17:\"twentytwentythree\";a:6:{s:5:\"theme\";s:17:\"twentytwentythree\";s:11:\"new_version\";s:3:\"1.6\";s:3:\"url\";s:47:\"https://wordpress.org/themes/twentytwentythree/\";s:7:\"package\";s:63:\"https://downloads.wordpress.org/theme/twentytwentythree.1.6.zip\";s:8:\"requires\";s:3:\"6.1\";s:12:\"requires_php\";s:3:\"5.6\";}}s:12:\"translations\";a:0:{}}", "off");
INSERT INTO `inter_options` VALUES("1929", "duplicator_version_plugin", "1.5.14", "auto");
INSERT INTO `inter_options` VALUES("1931", "duplicator_install_info", "a:3:{s:7:\"version\";s:6:\"1.5.14\";s:4:\"time\";i:1761080200;s:10:\"updateTime\";i:1761080200;}", "off");
INSERT INTO `inter_options` VALUES("1932", "duplicator_uninstall_package", "1", "auto");
INSERT INTO `inter_options` VALUES("1933", "duplicator_uninstall_settings", "1", "auto");
INSERT INTO `inter_options` VALUES("1934", "duplicator_settings", "a:20:{s:7:\"version\";s:6:\"1.5.14\";s:18:\"uninstall_settings\";b:1;s:15:\"uninstall_files\";b:1;s:13:\"package_debug\";b:0;s:23:\"email_summary_frequency\";s:6:\"weekly\";s:9:\"amNotices\";b:1;s:17:\"package_mysqldump\";b:1;s:22:\"package_mysqldump_path\";s:0:\"\";s:24:\"package_phpdump_qrylimit\";s:3:\"100\";s:17:\"package_zip_flush\";b:0;s:19:\"installer_name_mode\";s:6:\"simple\";s:16:\"storage_position\";s:6:\"wpcont\";s:20:\"storage_htaccess_off\";b:0;s:18:\"archive_build_mode\";i:2;s:17:\"skip_archive_scan\";b:0;s:21:\"unhook_third_party_js\";b:0;s:22:\"unhook_third_party_css\";b:0;s:17:\"active_package_id\";i:2;s:14:\"usage_tracking\";b:1;i:0;b:0;}", "auto");
INSERT INTO `inter_options` VALUES("1935", "duplicator_plugin_data_stats", "{\n    \"lastSendTime\": 0,\n    \"identifier\": \"gOxUBn8uc-79C24cWWsqMvGv.woByrj2X&Zy0UEDSNOy\",\n    \"plugin\": \"dup-lite\",\n    \"pluginStatus\": \"active\",\n    \"buildCount\": 1,\n    \"buildLastDate\": 1761080237,\n    \"buildFailedCount\": 0,\n    \"buildFailedLastDate\": 0,\n    \"siteSizeMB\": 118.3,\n    \"siteNumFiles\": 5337,\n    \"siteDbSizeMB\": 3.14,\n    \"siteDbNumTables\": 19\n}", "auto");
INSERT INTO `inter_options` VALUES("1936", "duplicator_notifications", "a:4:{s:6:\"update\";i:1761314625;s:4:\"feed\";a:0:{}s:6:\"events\";a:0:{}s:9:\"dismissed\";a:0:{}}", "auto");
INSERT INTO `inter_options` VALUES("1937", "duplicator_ui_view_state", "a:6:{s:22:\"dup-pack-storage-panel\";s:1:\"1\";s:29:\"dup-package-dtl-general-panel\";s:1:\"0\";s:29:\"dup-package-dtl-storage-panel\";s:1:\"0\";s:29:\"dup-package-dtl-archive-panel\";s:1:\"0\";s:22:\"dup-pack-archive-panel\";s:1:\"1\";s:24:\"dup-pack-installer-panel\";s:1:\"1\";}", "auto");
INSERT INTO `inter_options` VALUES("1938", "duplicator_package_active", "O:11:\"DUP_Package\":23:{s:7:\"Created\";s:19:\"2025-10-24 19:06:41\";s:7:\"Version\";s:6:\"1.5.14\";s:9:\"VersionWP\";s:5:\"6.8.3\";s:9:\"VersionDB\";s:6:\"8.0.40\";s:10:\"VersionPHP\";s:6:\"8.3.14\";s:9:\"VersionOS\";s:6:\"Darwin\";s:2:\"ID\";N;s:4:\"Name\";s:22:\"20251021_focusantilles\";s:4:\"Hash\";s:35:\"ec99491b3b9410b72304_20251024190641\";s:8:\"NameHash\";s:58:\"20251021_focusantilles_ec99491b3b9410b72304_20251024190641\";s:4:\"Type\";i:0;s:5:\"Notes\";s:0:\"\";s:8:\"ScanFile\";s:68:\"20251021_focusantilles_ec99491b3b9410b72304_20251024190641_scan.json\";s:10:\"TimerStart\";i:-1;s:7:\"Runtime\";N;s:7:\"ExeSize\";N;s:7:\"ZipSize\";N;s:6:\"Status\";i:0;s:6:\"WPUser\";N;s:7:\"Archive\";O:11:\"DUP_Archive\":26:{s:10:\"FilterDirs\";s:0:\"\";s:11:\"FilterFiles\";s:0:\"\";s:10:\"FilterExts\";s:0:\"\";s:13:\"FilterDirsAll\";a:0:{}s:14:\"FilterFilesAll\";a:0:{}s:13:\"FilterExtsAll\";a:0:{}s:8:\"FilterOn\";i:0;s:12:\"ExportOnlyDB\";i:0;s:4:\"File\";N;s:6:\"Format\";s:3:\"ZIP\";s:7:\"PackDir\";s:53:\"/Applications/MAMP/htdocs/localsites/intermitent_site\";s:4:\"Size\";i:0;s:4:\"Dirs\";a:0:{}s:9:\"dirsCount\";i:644;s:5:\"Files\";a:0:{}s:10:\"filesCount\";i:4693;s:10:\"FilterInfo\";O:23:\"DUP_Archive_Filter_Info\":8:{s:4:\"Dirs\";O:34:\"DUP_Archive_Filter_Scope_Directory\":6:{s:4:\"Core\";a:0:{}s:6:\"Global\";a:0:{}s:8:\"Instance\";a:0:{}s:7:\"Warning\";a:0:{}s:10:\"Unreadable\";a:0:{}s:10:\"AddonSites\";a:0:{}}s:5:\"Files\";O:29:\"DUP_Archive_Filter_Scope_File\":7:{s:4:\"Core\";a:0:{}s:6:\"Global\";a:0:{}s:8:\"Instance\";a:0:{}s:7:\"Warning\";a:0:{}s:10:\"Unreadable\";a:0:{}s:10:\"AddonSites\";a:0:{}s:4:\"Size\";a:0:{}}s:4:\"Exts\";O:29:\"DUP_Archive_Filter_Scope_Base\":3:{s:4:\"Core\";a:0:{}s:6:\"Global\";a:0:{}s:8:\"Instance\";a:0:{}}s:9:\"UDirCount\";i:0;s:10:\"UFileCount\";i:0;s:9:\"UExtCount\";i:0;s:8:\"TreeSize\";a:0:{}s:11:\"TreeWarning\";a:0:{}}s:14:\"RecursiveLinks\";a:0:{}s:10:\"file_count\";i:-1;s:10:\"\0*\0Package\";O:11:\"DUP_Package\":23:{s:7:\"Created\";s:19:\"2025-10-24 19:06:41\";s:7:\"Version\";s:6:\"1.5.14\";s:9:\"VersionWP\";s:5:\"6.8.3\";s:9:\"VersionDB\";s:6:\"8.0.40\";s:10:\"VersionPHP\";s:6:\"8.3.14\";s:9:\"VersionOS\";s:6:\"Darwin\";s:2:\"ID\";N;s:4:\"Name\";s:22:\"20251021_focusantilles\";s:4:\"Hash\";s:35:\"ec99491b3b9410b72304_20251024190641\";s:8:\"NameHash\";s:58:\"20251021_focusantilles_ec99491b3b9410b72304_20251024190641\";s:4:\"Type\";i:0;s:5:\"Notes\";s:0:\"\";s:8:\"ScanFile\";N;s:10:\"TimerStart\";i:-1;s:7:\"Runtime\";N;s:7:\"ExeSize\";N;s:7:\"ZipSize\";N;s:6:\"Status\";i:0;s:6:\"WPUser\";N;s:7:\"Archive\";r:21;s:9:\"Installer\";O:13:\"DUP_Installer\":15:{s:4:\"File\";N;s:4:\"Size\";i:0;s:10:\"OptsDBHost\";s:0:\"\";s:10:\"OptsDBPort\";s:0:\"\";s:10:\"OptsDBName\";s:0:\"\";s:10:\"OptsDBUser\";s:0:\"\";s:13:\"OptsDBCharset\";s:0:\"\";s:15:\"OptsDBCollation\";s:0:\"\";s:12:\"OptsSecureOn\";i:0;s:14:\"OptsSecurePass\";s:0:\"\";s:13:\"numFilesAdded\";i:0;s:12:\"numDirsAdded\";i:0;s:10:\"\0*\0Package\";r:65;s:17:\"\0*\0origFileManger\";N;s:32:\"\0DUP_Installer\0configTransformer\";O:44:\"Duplicator\\Libs\\WpConfig\\WPConfigTransformer\":3:{s:17:\"\0*\0wp_config_path\";s:67:\"/Applications/MAMP/htdocs/localsites/intermitent_site/wp-config.php\";s:16:\"\0*\0wp_config_src\";N;s:13:\"\0*\0wp_configs\";a:0:{}}}s:8:\"Database\";O:12:\"DUP_Database\":15:{s:4:\"Type\";s:5:\"MySQL\";s:4:\"Size\";N;s:4:\"File\";N;s:4:\"Path\";N;s:12:\"FilterTables\";s:0:\"\";s:8:\"FilterOn\";i:0;s:4:\"Name\";N;s:10:\"Compatible\";s:0:\"\";s:8:\"Comments\";s:19:\"Source distribution\";s:19:\"sameNameTableExists\";N;s:4:\"info\";O:16:\"DUP_DatabaseInfo\":23:{s:9:\"buildMode\";s:3:\"PHP\";s:11:\"charSetList\";a:0:{}s:13:\"collationList\";a:0:{}s:10:\"engineList\";a:0:{}s:17:\"isTablesUpperCase\";b:0;s:15:\"isNameUpperCase\";b:0;s:4:\"name\";s:0:\"\";s:15:\"tablesBaseCount\";i:0;s:16:\"tablesFinalCount\";i:0;s:20:\"muFilteredTableCount\";i:0;s:14:\"tablesRowCount\";i:0;s:16:\"tablesSizeOnDisk\";i:0;s:10:\"tablesList\";a:0:{}s:19:\"lowerCaseTableNames\";i:0;s:8:\"dbEngine\";s:0:\"\";s:7:\"version\";i:0;s:14:\"versionComment\";i:0;s:9:\"viewCount\";i:0;s:9:\"procCount\";i:0;s:9:\"funcCount\";i:0;s:11:\"triggerList\";a:0:{}s:33:\"\0DUP_DatabaseInfo\0intFieldsStruct\";a:0:{}s:42:\"\0DUP_DatabaseInfo\0indexProcessedSchemaSize\";a:0:{}}s:10:\"\0*\0Package\";r:65;s:24:\"\0DUP_Database\0tempDbPath\";N;s:23:\"\0DUP_Database\0EOFMarker\";s:0:\"\";s:26:\"\0DUP_Database\0networkFlush\";b:0;}s:13:\"BuildProgress\";O:18:\"DUP_Build_Progress\":12:{s:17:\"thread_start_time\";N;s:11:\"initialized\";b:0;s:15:\"installer_built\";b:0;s:15:\"archive_started\";b:0;s:20:\"archive_has_database\";b:0;s:13:\"archive_built\";b:0;s:21:\"database_script_built\";b:0;s:6:\"failed\";b:0;s:7:\"retries\";i:0;s:14:\"build_failures\";a:0:{}s:19:\"validation_failures\";a:0:{}s:27:\"\0DUP_Build_Progress\0package\";r:65;}}s:29:\"\0DUP_Archive\0tmpFilterDirsAll\";a:0:{}s:24:\"\0DUP_Archive\0wpCorePaths\";a:3:{i:0;s:62:\"/Applications/MAMP/htdocs/localsites/intermitent_site/wp-admin\";i:1;s:65:\"/Applications/MAMP/htdocs/localsites/intermitent_site/wp-includes\";i:2;s:74:\"/Applications/MAMP/htdocs/localsites/intermitent_site/wp-content/languages\";}s:29:\"\0DUP_Archive\0wpCoreExactPaths\";a:7:{i:0;s:53:\"/Applications/MAMP/htdocs/localsites/intermitent_site\";i:1;s:53:\"/Applications/MAMP/htdocs/localsites/intermitent_site\";i:2;s:64:\"/Applications/MAMP/htdocs/localsites/intermitent_site/wp-content\";i:3;s:72:\"/Applications/MAMP/htdocs/localsites/intermitent_site/wp-content/uploads\";i:4;s:72:\"/Applications/MAMP/htdocs/localsites/intermitent_site/wp-content/plugins\";i:5;s:75:\"/Applications/MAMP/htdocs/localsites/intermitent_site/wp-content/mu-plugins\";i:6;s:71:\"/Applications/MAMP/htdocs/localsites/intermitent_site/wp-content/themes\";}s:31:\"\0DUP_Archive\0relativeFiltersDir\";a:2:{i:0;s:85:\"/Applications/MAMP/htdocs/localsites/intermitent_site/wp-content/backups-dup-lite/tmp\";i:1;s:15:\"backups-dup-pro\";}s:24:\"\0DUP_Archive\0listFileObj\";N;s:23:\"\0DUP_Archive\0listDirObj\";N;}s:9:\"Installer\";r:86;s:8:\"Database\";r:105;s:13:\"BuildProgress\";r:144;}", "auto");
INSERT INTO `inter_options` VALUES("1939", "duplicator_email_summary_info", "{\"CL_-=_-=\":\"Duplicator\\\\Utils\\\\Email\\\\EmailSummary\",\"manualPackageIds\":[1],\"failedPackageIds\":[]}", "auto");
INSERT INTO `inter_options` VALUES("1970", "metier_children", "a:13:{i:9;a:7:{i:0;i:10;i:1;i:11;i:2;i:12;i:3;i:13;i:4;i:14;i:5;i:15;i:6;i:16;}i:17;a:6:{i:0;i:18;i:1;i:19;i:2;i:20;i:3;i:21;i:4;i:22;i:5;i:23;}i:24;a:11:{i:0;i:25;i:1;i:26;i:2;i:27;i:3;i:28;i:4;i:29;i:5;i:30;i:6;i:31;i:7;i:32;i:8;i:33;i:9;i:34;i:10;i:72;}i:35;a:4:{i:0;i:36;i:1;i:37;i:2;i:38;i:3;i:39;}i:68;a:3:{i:0;i:69;i:1;i:70;i:2;i:71;}i:73;a:4:{i:0;i:74;i:1;i:75;i:2;i:76;i:3;i:77;}i:78;a:9:{i:0;i:79;i:1;i:80;i:2;i:81;i:3;i:82;i:4;i:83;i:5;i:84;i:6;i:85;i:7;i:86;i:8;i:87;}i:88;a:4:{i:0;i:89;i:1;i:90;i:2;i:91;i:3;i:92;}i:93;a:4:{i:0;i:94;i:1;i:95;i:2;i:96;i:3;i:97;}i:98;a:4:{i:0;i:99;i:1;i:100;i:2;i:101;i:3;i:102;}i:103;a:10:{i:0;i:104;i:1;i:105;i:2;i:106;i:3;i:107;i:4;i:108;i:5;i:109;i:6;i:110;i:7;i:111;i:8;i:112;i:9;i:113;}i:114;a:5:{i:0;i:115;i:1;i:116;i:2;i:117;i:3;i:118;i:4;i:119;}i:120;a:5:{i:0;i:121;i:1;i:122;i:2;i:123;i:3;i:124;i:4;i:125;}}", "auto");
INSERT INTO `inter_options` VALUES("2030", "_site_transient_timeout_php_check_02188af51d4a5a03791426b00985b4f3", "1761833391", "off");
INSERT INTO `inter_options` VALUES("2031", "_site_transient_php_check_02188af51d4a5a03791426b00985b4f3", "a:5:{s:19:\"recommended_version\";s:3:\"8.3\";s:15:\"minimum_version\";s:6:\"7.2.24\";s:12:\"is_supported\";b:1;s:9:\"is_secure\";b:1;s:13:\"is_acceptable\";b:1;}", "off");
INSERT INTO `inter_options` VALUES("2091", "_site_transient_update_plugins", "O:8:\"stdClass\":5:{s:12:\"last_checked\";i:1761314625;s:8:\"response\";a:1:{s:19:\"akismet/akismet.php\";O:8:\"stdClass\":13:{s:2:\"id\";s:21:\"w.org/plugins/akismet\";s:4:\"slug\";s:7:\"akismet\";s:6:\"plugin\";s:19:\"akismet/akismet.php\";s:11:\"new_version\";s:3:\"5.5\";s:3:\"url\";s:38:\"https://wordpress.org/plugins/akismet/\";s:7:\"package\";s:54:\"https://downloads.wordpress.org/plugin/akismet.5.5.zip\";s:5:\"icons\";a:2:{s:2:\"2x\";s:60:\"https://ps.w.org/akismet/assets/icon-256x256.png?rev=2818463\";s:2:\"1x\";s:60:\"https://ps.w.org/akismet/assets/icon-128x128.png?rev=2818463\";}s:7:\"banners\";a:2:{s:2:\"2x\";s:63:\"https://ps.w.org/akismet/assets/banner-1544x500.png?rev=2900731\";s:2:\"1x\";s:62:\"https://ps.w.org/akismet/assets/banner-772x250.png?rev=2900731\";}s:11:\"banners_rtl\";a:0:{}s:8:\"requires\";s:3:\"5.8\";s:6:\"tested\";s:5:\"6.8.3\";s:12:\"requires_php\";s:3:\"7.2\";s:16:\"requires_plugins\";a:0:{}}}s:12:\"translations\";a:0:{}s:9:\"no_update\";a:3:{s:47:\"better-search-replace/better-search-replace.php\";O:8:\"stdClass\":10:{s:2:\"id\";s:35:\"w.org/plugins/better-search-replace\";s:4:\"slug\";s:21:\"better-search-replace\";s:6:\"plugin\";s:47:\"better-search-replace/better-search-replace.php\";s:11:\"new_version\";s:6:\"1.4.10\";s:3:\"url\";s:52:\"https://wordpress.org/plugins/better-search-replace/\";s:7:\"package\";s:71:\"https://downloads.wordpress.org/plugin/better-search-replace.1.4.10.zip\";s:5:\"icons\";a:2:{s:2:\"2x\";s:74:\"https://ps.w.org/better-search-replace/assets/icon-256x256.png?rev=2706527\";s:2:\"1x\";s:74:\"https://ps.w.org/better-search-replace/assets/icon-128x128.png?rev=2706527\";}s:7:\"banners\";a:2:{s:2:\"2x\";s:77:\"https://ps.w.org/better-search-replace/assets/banner-1544x500.png?rev=2706527\";s:2:\"1x\";s:76:\"https://ps.w.org/better-search-replace/assets/banner-772x250.jpg?rev=2706527\";}s:11:\"banners_rtl\";a:0:{}s:8:\"requires\";s:5:\"3.0.1\";}s:25:\"duplicator/duplicator.php\";O:8:\"stdClass\":10:{s:2:\"id\";s:24:\"w.org/plugins/duplicator\";s:4:\"slug\";s:10:\"duplicator\";s:6:\"plugin\";s:25:\"duplicator/duplicator.php\";s:11:\"new_version\";s:6:\"1.5.14\";s:3:\"url\";s:41:\"https://wordpress.org/plugins/duplicator/\";s:7:\"package\";s:60:\"https://downloads.wordpress.org/plugin/duplicator.1.5.14.zip\";s:5:\"icons\";a:2:{s:2:\"2x\";s:63:\"https://ps.w.org/duplicator/assets/icon-256x256.png?rev=2906985\";s:2:\"1x\";s:63:\"https://ps.w.org/duplicator/assets/icon-128x128.png?rev=2906985\";}s:7:\"banners\";a:2:{s:2:\"2x\";s:66:\"https://ps.w.org/duplicator/assets/banner-1544x500.png?rev=2906985\";s:2:\"1x\";s:65:\"https://ps.w.org/duplicator/assets/banner-772x250.png?rev=2906985\";}s:11:\"banners_rtl\";a:0:{}s:8:\"requires\";s:3:\"5.3\";}s:73:\"hide-admin-bar-based-on-user-roles/hide-admin-bar-based-on-user-roles.php\";O:8:\"stdClass\":10:{s:2:\"id\";s:48:\"w.org/plugins/hide-admin-bar-based-on-user-roles\";s:4:\"slug\";s:34:\"hide-admin-bar-based-on-user-roles\";s:6:\"plugin\";s:73:\"hide-admin-bar-based-on-user-roles/hide-admin-bar-based-on-user-roles.php\";s:11:\"new_version\";s:5:\"6.0.4\";s:3:\"url\";s:65:\"https://wordpress.org/plugins/hide-admin-bar-based-on-user-roles/\";s:7:\"package\";s:83:\"https://downloads.wordpress.org/plugin/hide-admin-bar-based-on-user-roles.6.0.4.zip\";s:5:\"icons\";a:2:{s:2:\"1x\";s:79:\"https://ps.w.org/hide-admin-bar-based-on-user-roles/assets/icon.svg?rev=3305958\";s:3:\"svg\";s:79:\"https://ps.w.org/hide-admin-bar-based-on-user-roles/assets/icon.svg?rev=3305958\";}s:7:\"banners\";a:2:{s:2:\"2x\";s:90:\"https://ps.w.org/hide-admin-bar-based-on-user-roles/assets/banner-1544x500.png?rev=3305158\";s:2:\"1x\";s:89:\"https://ps.w.org/hide-admin-bar-based-on-user-roles/assets/banner-772x250.png?rev=3305158\";}s:11:\"banners_rtl\";a:2:{s:2:\"2x\";s:94:\"https://ps.w.org/hide-admin-bar-based-on-user-roles/assets/banner-1544x500-rtl.png?rev=3305158\";s:2:\"1x\";s:93:\"https://ps.w.org/hide-admin-bar-based-on-user-roles/assets/banner-772x250-rtl.png?rev=3305158\";}s:8:\"requires\";s:3:\"5.5\";}}s:7:\"checked\";a:4:{s:19:\"akismet/akismet.php\";s:3:\"5.4\";s:47:\"better-search-replace/better-search-replace.php\";s:6:\"1.4.10\";s:25:\"duplicator/duplicator.php\";s:6:\"1.5.14\";s:73:\"hide-admin-bar-based-on-user-roles/hide-admin-bar-based-on-user-roles.php\";s:5:\"6.0.4\";}}", "off");
INSERT INTO `inter_options` VALUES("2146", "_site_transient_timeout_theme_roots", "1761334474", "off");
INSERT INTO `inter_options` VALUES("2147", "_site_transient_theme_roots", "a:4:{s:11:\"inter-theme\";s:7:\"/themes\";s:16:\"twentytwentyfive\";s:7:\"/themes\";s:16:\"twentytwentyfour\";s:7:\"/themes\";s:17:\"twentytwentythree\";s:7:\"/themes\";}", "off");
INSERT INTO `inter_options` VALUES("2148", "_site_transient_timeout_wp_theme_files_patterns-bb3f9e6f69bda41294bb87fc365ad183", "1761334474", "off");
INSERT INTO `inter_options` VALUES("2149", "_site_transient_wp_theme_files_patterns-bb3f9e6f69bda41294bb87fc365ad183", "a:2:{s:7:\"version\";s:5:\"0.1.0\";s:8:\"patterns\";a:0:{}}", "off");
INSERT INTO `inter_options` VALUES("2150", "_site_transient_timeout_wp_theme_files_patterns-9d1922d99d1ef3b38edf6e64dc8be813", "1761334474", "off");
INSERT INTO `inter_options` VALUES("2151", "_site_transient_wp_theme_files_patterns-9d1922d99d1ef3b38edf6e64dc8be813", "a:2:{s:7:\"version\";s:3:\"1.3\";s:8:\"patterns\";a:57:{s:15:\"banner-hero.php\";a:5:{s:5:\"title\";s:4:\"Hero\";s:4:\"slug\";s:28:\"twentytwentyfour/banner-hero\";s:11:\"description\";s:69:\"A hero section with a title, a paragraph, a CTA button, and an image.\";s:13:\"viewportWidth\";i:1400;s:10:\"categories\";a:3:{i:0;s:6:\"banner\";i:1;s:14:\"call-to-action\";i:2;s:8:\"featured\";}}s:30:\"banner-project-description.php\";a:5:{s:5:\"title\";s:19:\"Project description\";s:4:\"slug\";s:43:\"twentytwentyfour/banner-project-description\";s:11:\"description\";s:64:\"Project description section with title, paragraph, and an image.\";s:13:\"viewportWidth\";i:1400;s:10:\"categories\";a:4:{i:0;s:8:\"featured\";i:1;s:6:\"banner\";i:2;s:5:\"about\";i:3;s:9:\"portfolio\";}}s:30:\"cta-content-image-on-right.php\";a:5:{s:5:\"title\";s:34:\"Call to action with image on right\";s:4:\"slug\";s:43:\"twentytwentyfour/cta-content-image-on-right\";s:11:\"description\";s:76:\"A title, paragraph, two CTA buttons, and an image for a general CTA section.\";s:13:\"viewportWidth\";i:1400;s:10:\"categories\";a:2:{i:0;s:14:\"call-to-action\";i:1;s:6:\"banner\";}}s:15:\"cta-pricing.php\";a:5:{s:5:\"title\";s:7:\"Pricing\";s:4:\"slug\";s:28:\"twentytwentyfour/cta-pricing\";s:11:\"description\";s:69:\"A pricing section with a title, a paragraph and three pricing levels.\";s:13:\"viewportWidth\";i:1400;s:10:\"categories\";a:2:{i:0;s:14:\"call-to-action\";i:1;s:8:\"services\";}}s:12:\"cta-rsvp.php\";a:5:{s:5:\"title\";s:4:\"RSVP\";s:4:\"slug\";s:25:\"twentytwentyfour/cta-rsvp\";s:11:\"description\";s:63:\"A large RSVP heading sideways, a description, and a CTA button.\";s:13:\"viewportWidth\";i:1100;s:10:\"categories\";a:2:{i:0;s:14:\"call-to-action\";i:1;s:8:\"featured\";}}s:27:\"cta-services-image-left.php\";a:5:{s:5:\"title\";s:42:\"Services call to action with image on left\";s:4:\"slug\";s:40:\"twentytwentyfour/cta-services-image-left\";s:11:\"description\";s:65:\"An image, title, paragraph and a CTA button to describe services.\";s:13:\"viewportWidth\";i:1400;s:10:\"categories\";a:4:{i:0;s:14:\"call-to-action\";i:1;s:6:\"banner\";i:2;s:8:\"featured\";i:3;s:8:\"services\";}}s:26:\"cta-subscribe-centered.php\";a:5:{s:5:\"title\";s:23:\"Centered call to action\";s:4:\"slug\";s:39:\"twentytwentyfour/cta-subscribe-centered\";s:11:\"description\";s:67:\"Subscribers CTA section with a title, a paragraph and a CTA button.\";s:10:\"categories\";a:1:{i:0;s:14:\"call-to-action\";}s:8:\"keywords\";a:3:{i:0;s:10:\"newsletter\";i:1;s:9:\"subscribe\";i:2;s:6:\"button\";}}s:28:\"footer-centered-logo-nav.php\";a:5:{s:5:\"title\";s:40:\"Footer with centered logo and navigation\";s:4:\"slug\";s:41:\"twentytwentyfour/footer-centered-logo-nav\";s:11:\"description\";s:73:\"A footer section with a centered logo, navigation, and WordPress credits.\";s:10:\"categories\";a:1:{i:0;s:6:\"footer\";}s:10:\"blockTypes\";a:1:{i:0;s:25:\"core/template-part/footer\";}}s:25:\"footer-colophon-3-col.php\";a:5:{s:5:\"title\";s:31:\"Footer with colophon, 3 columns\";s:4:\"slug\";s:38:\"twentytwentyfour/footer-colophon-3-col\";s:11:\"description\";s:47:\"A footer section with a colophon and 3 columns.\";s:10:\"categories\";a:1:{i:0;s:6:\"footer\";}s:10:\"blockTypes\";a:1:{i:0;s:25:\"core/template-part/footer\";}}s:10:\"footer.php\";a:5:{s:5:\"title\";s:31:\"Footer with colophon, 4 columns\";s:4:\"slug\";s:23:\"twentytwentyfour/footer\";s:11:\"description\";s:47:\"A footer section with a colophon and 4 columns.\";s:10:\"categories\";a:1:{i:0;s:6:\"footer\";}s:10:\"blockTypes\";a:1:{i:0;s:25:\"core/template-part/footer\";}}s:29:\"gallery-full-screen-image.php\";a:4:{s:5:\"title\";s:17:\"Full screen image\";s:4:\"slug\";s:42:\"twentytwentyfour/gallery-full-screen-image\";s:11:\"description\";s:51:\"A cover image section that covers the entire width.\";s:10:\"categories\";a:2:{i:0;s:7:\"gallery\";i:1;s:9:\"portfolio\";}}s:36:\"gallery-offset-images-grid-2-col.php\";a:6:{s:5:\"title\";s:25:\"Offset gallery, 2 columns\";s:4:\"slug\";s:49:\"twentytwentyfour/gallery-offset-images-grid-2-col\";s:11:\"description\";s:51:\"A gallery section with 2 columns and offset images.\";s:13:\"viewportWidth\";i:1400;s:10:\"categories\";a:2:{i:0;s:7:\"gallery\";i:1;s:9:\"portfolio\";}s:8:\"keywords\";a:5:{i:0;s:7:\"project\";i:1;s:6:\"images\";i:2;s:5:\"media\";i:3;s:7:\"masonry\";i:4;s:7:\"columns\";}}s:36:\"gallery-offset-images-grid-3-col.php\";a:6:{s:5:\"title\";s:25:\"Offset gallery, 3 columns\";s:4:\"slug\";s:49:\"twentytwentyfour/gallery-offset-images-grid-3-col\";s:11:\"description\";s:51:\"A gallery section with 3 columns and offset images.\";s:13:\"viewportWidth\";i:1400;s:10:\"categories\";a:2:{i:0;s:7:\"gallery\";i:1;s:9:\"portfolio\";}s:8:\"keywords\";a:5:{i:0;s:7:\"project\";i:1;s:6:\"images\";i:2;s:5:\"media\";i:3;s:7:\"masonry\";i:4;s:7:\"columns\";}}s:36:\"gallery-offset-images-grid-4-col.php\";a:6:{s:5:\"title\";s:25:\"Offset gallery, 4 columns\";s:4:\"slug\";s:49:\"twentytwentyfour/gallery-offset-images-grid-4-col\";s:11:\"description\";s:51:\"A gallery section with 4 columns and offset images.\";s:13:\"viewportWidth\";i:1400;s:10:\"categories\";a:3:{i:0;s:7:\"gallery\";i:1;s:8:\"featured\";i:2;s:9:\"portfolio\";}s:8:\"keywords\";a:5:{i:0;s:7:\"project\";i:1;s:6:\"images\";i:2;s:5:\"media\";i:3;s:7:\"masonry\";i:4;s:7:\"columns\";}}s:26:\"gallery-project-layout.php\";a:5:{s:5:\"title\";s:14:\"Project layout\";s:4:\"slug\";s:39:\"twentytwentyfour/gallery-project-layout\";s:11:\"description\";s:54:\"A gallery section with a project layout with 2 images.\";s:13:\"viewportWidth\";i:1600;s:10:\"categories\";a:3:{i:0;s:7:\"gallery\";i:1;s:8:\"featured\";i:2;s:9:\"portfolio\";}}s:14:\"hidden-404.php\";a:4:{s:5:\"title\";s:3:\"404\";s:4:\"slug\";s:27:\"twentytwentyfour/hidden-404\";s:11:\"description\";s:0:\"\";s:8:\"inserter\";b:0;}s:19:\"hidden-comments.php\";a:4:{s:5:\"title\";s:8:\"Comments\";s:4:\"slug\";s:32:\"twentytwentyfour/hidden-comments\";s:11:\"description\";s:0:\"\";s:8:\"inserter\";b:0;}s:21:\"hidden-no-results.php\";a:4:{s:5:\"title\";s:10:\"No results\";s:4:\"slug\";s:34:\"twentytwentyfour/hidden-no-results\";s:11:\"description\";s:0:\"\";s:8:\"inserter\";b:0;}s:25:\"hidden-portfolio-hero.php\";a:4:{s:5:\"title\";s:14:\"Portfolio hero\";s:4:\"slug\";s:38:\"twentytwentyfour/hidden-portfolio-hero\";s:11:\"description\";s:0:\"\";s:8:\"inserter\";b:0;}s:20:\"hidden-post-meta.php\";a:4:{s:5:\"title\";s:9:\"Post meta\";s:4:\"slug\";s:33:\"twentytwentyfour/hidden-post-meta\";s:11:\"description\";s:0:\"\";s:8:\"inserter\";b:0;}s:26:\"hidden-post-navigation.php\";a:4:{s:5:\"title\";s:15:\"Post navigation\";s:4:\"slug\";s:39:\"twentytwentyfour/hidden-post-navigation\";s:11:\"description\";s:0:\"\";s:8:\"inserter\";b:0;}s:24:\"hidden-posts-heading.php\";a:5:{s:5:\"title\";s:13:\"Posts heading\";s:4:\"slug\";s:37:\"twentytwentyfour/hidden-posts-heading\";s:11:\"description\";s:0:\"\";s:8:\"inserter\";b:0;s:10:\"categories\";a:1:{i:0;s:6:\"hidden\";}}s:17:\"hidden-search.php\";a:4:{s:5:\"title\";s:6:\"Search\";s:4:\"slug\";s:30:\"twentytwentyfour/hidden-search\";s:11:\"description\";s:0:\"\";s:8:\"inserter\";b:0;}s:18:\"hidden-sidebar.php\";a:4:{s:5:\"title\";s:7:\"Sidebar\";s:4:\"slug\";s:31:\"twentytwentyfour/hidden-sidebar\";s:11:\"description\";s:0:\"\";s:8:\"inserter\";b:0;}s:23:\"page-about-business.php\";a:8:{s:5:\"title\";s:5:\"About\";s:4:\"slug\";s:36:\"twentytwentyfour/page-about-business\";s:11:\"description\";s:147:\"A business about page with a hero section, a text section, a services section, a team section, a clients section, a FAQ section, and a CTA section.\";s:13:\"viewportWidth\";i:1400;s:10:\"categories\";a:1:{i:0;s:21:\"twentytwentyfour_page\";}s:8:\"keywords\";a:1:{i:0;s:7:\"starter\";}s:10:\"blockTypes\";a:1:{i:0;s:17:\"core/post-content\";}s:9:\"postTypes\";a:2:{i:0;s:4:\"page\";i:1;s:11:\"wp_template\";}}s:22:\"page-home-blogging.php\";a:7:{s:5:\"title\";s:13:\"Blogging home\";s:4:\"slug\";s:35:\"twentytwentyfour/page-home-blogging\";s:11:\"description\";s:92:\"A blogging home page with a hero section, a text section, a blog section, and a CTA section.\";s:13:\"viewportWidth\";i:1400;s:10:\"categories\";a:1:{i:0;s:21:\"twentytwentyfour_page\";}s:8:\"keywords\";a:2:{i:0;s:4:\"page\";i:1;s:7:\"starter\";}s:9:\"postTypes\";a:2:{i:0;s:4:\"page\";i:1;s:11:\"wp_template\";}}s:22:\"page-home-business.php\";a:8:{s:5:\"title\";s:13:\"Business home\";s:4:\"slug\";s:35:\"twentytwentyfour/page-home-business\";s:11:\"description\";s:146:\"A business home page with a hero section, a text section, a services section, a team section, a clients section, a FAQ section, and a CTA section.\";s:13:\"viewportWidth\";i:1400;s:10:\"categories\";a:1:{i:0;s:21:\"twentytwentyfour_page\";}s:8:\"keywords\";a:1:{i:0;s:7:\"starter\";}s:10:\"blockTypes\";a:1:{i:0;s:17:\"core/post-content\";}s:9:\"postTypes\";a:2:{i:0;s:4:\"page\";i:1;s:11:\"wp_template\";}}s:31:\"page-home-portfolio-gallery.php\";a:8:{s:5:\"title\";s:28:\"Portfolio home image gallery\";s:4:\"slug\";s:34:\"twentytwentyfour/page-home-gallery\";s:11:\"description\";s:46:\"A portfolio home page that features a gallery.\";s:13:\"viewportWidth\";i:1400;s:10:\"categories\";a:1:{i:0;s:21:\"twentytwentyfour_page\";}s:8:\"keywords\";a:1:{i:0;s:7:\"starter\";}s:10:\"blockTypes\";a:1:{i:0;s:17:\"core/post-content\";}s:9:\"postTypes\";a:2:{i:0;s:4:\"page\";i:1;s:11:\"wp_template\";}}s:23:\"page-home-portfolio.php\";a:8:{s:5:\"title\";s:40:\"Portfolio home with post featured images\";s:4:\"slug\";s:36:\"twentytwentyfour/page-home-portfolio\";s:11:\"description\";s:94:\"A portfolio home page with a description and a 4-column post section with only feature images.\";s:13:\"viewportWidth\";i:1400;s:10:\"categories\";a:1:{i:0;s:21:\"twentytwentyfour_page\";}s:8:\"keywords\";a:1:{i:0;s:7:\"starter\";}s:10:\"blockTypes\";a:1:{i:0;s:17:\"core/post-content\";}s:9:\"postTypes\";a:2:{i:0;s:4:\"page\";i:1;s:11:\"wp_template\";}}s:27:\"page-newsletter-landing.php\";a:8:{s:5:\"title\";s:18:\"Newsletter landing\";s:4:\"slug\";s:40:\"twentytwentyfour/page-newsletter-landing\";s:11:\"description\";s:62:\"A block with a newsletter subscription CTA for a landing page.\";s:13:\"viewportWidth\";i:1100;s:10:\"categories\";a:3:{i:0;s:14:\"call-to-action\";i:1;s:21:\"twentytwentyfour_page\";i:2;s:8:\"featured\";}s:8:\"keywords\";a:1:{i:0;s:7:\"starter\";}s:10:\"blockTypes\";a:1:{i:0;s:17:\"core/post-content\";}s:9:\"postTypes\";a:2:{i:0;s:4:\"page\";i:1;s:11:\"wp_template\";}}s:27:\"page-portfolio-overview.php\";a:8:{s:5:\"title\";s:26:\"Portfolio project overview\";s:4:\"slug\";s:40:\"twentytwentyfour/page-portfolio-overview\";s:11:\"description\";s:138:\"A full portfolio page with a section for project description, project details, a full screen image, and a gallery section with two images.\";s:13:\"viewportWidth\";i:1400;s:10:\"categories\";a:2:{i:0;s:21:\"twentytwentyfour_page\";i:1;s:8:\"featured\";}s:8:\"keywords\";a:1:{i:0;s:7:\"starter\";}s:10:\"blockTypes\";a:1:{i:0;s:17:\"core/post-content\";}s:9:\"postTypes\";a:2:{i:0;s:4:\"page\";i:1;s:11:\"wp_template\";}}s:21:\"page-rsvp-landing.php\";a:8:{s:5:\"title\";s:12:\"RSVP landing\";s:4:\"slug\";s:34:\"twentytwentyfour/page-rsvp-landing\";s:11:\"description\";s:63:\"A large RSVP heading sideways, a description, and a CTA button.\";s:13:\"viewportWidth\";i:1100;s:10:\"categories\";a:1:{i:0;s:21:\"twentytwentyfour_page\";}s:8:\"keywords\";a:1:{i:0;s:7:\"starter\";}s:10:\"blockTypes\";a:1:{i:0;s:17:\"core/post-content\";}s:9:\"postTypes\";a:2:{i:0;s:4:\"page\";i:1;s:11:\"wp_template\";}}s:15:\"posts-1-col.php\";a:5:{s:5:\"title\";s:23:\"List of posts, 1 column\";s:4:\"slug\";s:28:\"twentytwentyfour/posts-1-col\";s:11:\"description\";s:26:\"A list of posts, 1 column.\";s:10:\"categories\";a:1:{i:0;s:5:\"query\";}s:10:\"blockTypes\";a:1:{i:0;s:10:\"core/query\";}}s:15:\"posts-3-col.php\";a:5:{s:5:\"title\";s:24:\"List of posts, 3 columns\";s:4:\"slug\";s:28:\"twentytwentyfour/posts-3-col\";s:11:\"description\";s:27:\"A list of posts, 3 columns.\";s:10:\"categories\";a:1:{i:0;s:5:\"query\";}s:10:\"blockTypes\";a:1:{i:0;s:10:\"core/query\";}}s:20:\"posts-grid-2-col.php\";a:5:{s:5:\"title\";s:49:\"Grid of posts featuring the first post, 2 columns\";s:4:\"slug\";s:33:\"twentytwentyfour/posts-grid-2-col\";s:11:\"description\";s:52:\"A grid of posts featuring the first post, 2 columns.\";s:10:\"categories\";a:1:{i:0;s:5:\"query\";}s:10:\"blockTypes\";a:1:{i:0;s:10:\"core/query\";}}s:27:\"posts-images-only-3-col.php\";a:5:{s:5:\"title\";s:42:\"Posts with featured images only, 3 columns\";s:4:\"slug\";s:40:\"twentytwentyfour/posts-images-only-3-col\";s:11:\"description\";s:53:\"A list of posts with featured images only, 3 columns.\";s:10:\"categories\";a:1:{i:0;s:5:\"query\";}s:10:\"blockTypes\";a:1:{i:0;s:10:\"core/query\";}}s:34:\"posts-images-only-offset-4-col.php\";a:4:{s:5:\"title\";s:49:\"Offset posts with featured images only, 4 columns\";s:4:\"slug\";s:47:\"twentytwentyfour/posts-images-only-offset-4-col\";s:11:\"description\";s:53:\"A list of posts with featured images only, 4 columns.\";s:10:\"categories\";a:1:{i:0;s:5:\"posts\";}}s:14:\"posts-list.php\";a:5:{s:5:\"title\";s:38:\"List of posts without images, 1 column\";s:4:\"slug\";s:27:\"twentytwentyfour/posts-list\";s:11:\"description\";s:41:\"A list of posts without images, 1 column.\";s:10:\"categories\";a:2:{i:0;s:5:\"query\";i:1;s:5:\"posts\";}s:10:\"blockTypes\";a:1:{i:0;s:10:\"core/query\";}}s:14:\"team-4-col.php\";a:5:{s:5:\"title\";s:23:\"Team members, 4 columns\";s:4:\"slug\";s:27:\"twentytwentyfour/team-4-col\";s:11:\"description\";s:76:\"A team section, with a heading, a paragraph, and 4 columns for team members.\";s:13:\"viewportWidth\";i:1400;s:10:\"categories\";a:2:{i:0;s:4:\"team\";i:1;s:5:\"about\";}}s:29:\"template-archive-blogging.php\";a:6:{s:5:\"title\";s:25:\"Blogging archive template\";s:4:\"slug\";s:42:\"twentytwentyfour/template-archive-blogging\";s:11:\"description\";s:0:\"\";s:13:\"viewportWidth\";i:1400;s:8:\"inserter\";b:0;s:13:\"templateTypes\";a:5:{i:0;s:7:\"archive\";i:1;s:8:\"category\";i:2;s:3:\"tag\";i:3;s:6:\"author\";i:4;s:4:\"date\";}}s:30:\"template-archive-portfolio.php\";a:6:{s:5:\"title\";s:26:\"Portfolio archive template\";s:4:\"slug\";s:43:\"twentytwentyfour/template-archive-portfolio\";s:11:\"description\";s:0:\"\";s:13:\"viewportWidth\";i:1400;s:8:\"inserter\";b:0;s:13:\"templateTypes\";a:1:{i:0;s:7:\"archive\";}}s:26:\"template-home-blogging.php\";a:6:{s:5:\"title\";s:22:\"Blogging home template\";s:4:\"slug\";s:39:\"twentytwentyfour/template-home-blogging\";s:11:\"description\";s:0:\"\";s:13:\"viewportWidth\";i:1400;s:8:\"inserter\";b:0;s:13:\"templateTypes\";a:3:{i:0;s:10:\"front-page\";i:1;s:5:\"index\";i:2;s:4:\"home\";}}s:26:\"template-home-business.php\";a:6:{s:5:\"title\";s:22:\"Business home template\";s:4:\"slug\";s:39:\"twentytwentyfour/template-home-business\";s:11:\"description\";s:0:\"\";s:13:\"viewportWidth\";i:1400;s:8:\"inserter\";b:0;s:13:\"templateTypes\";a:2:{i:0;s:10:\"front-page\";i:1;s:4:\"home\";}}s:27:\"template-home-portfolio.php\";a:6:{s:5:\"title\";s:49:\"Portfolio home template with post featured images\";s:4:\"slug\";s:40:\"twentytwentyfour/template-home-portfolio\";s:11:\"description\";s:0:\"\";s:13:\"viewportWidth\";i:1400;s:8:\"inserter\";b:0;s:13:\"templateTypes\";a:2:{i:0;s:10:\"front-page\";i:1;s:4:\"home\";}}s:27:\"template-index-blogging.php\";a:6:{s:5:\"title\";s:23:\"Blogging index template\";s:4:\"slug\";s:40:\"twentytwentyfour/template-index-blogging\";s:11:\"description\";s:0:\"\";s:13:\"viewportWidth\";i:1400;s:8:\"inserter\";b:0;s:13:\"templateTypes\";a:2:{i:0;s:5:\"index\";i:1;s:4:\"home\";}}s:28:\"template-index-portfolio.php\";a:6:{s:5:\"title\";s:24:\"Portfolio index template\";s:4:\"slug\";s:41:\"twentytwentyfour/template-index-portfolio\";s:11:\"description\";s:0:\"\";s:13:\"viewportWidth\";i:1400;s:8:\"inserter\";b:0;s:13:\"templateTypes\";a:1:{i:0;s:5:\"index\";}}s:28:\"template-search-blogging.php\";a:6:{s:5:\"title\";s:24:\"Blogging search template\";s:4:\"slug\";s:41:\"twentytwentyfour/template-search-blogging\";s:11:\"description\";s:0:\"\";s:13:\"viewportWidth\";i:1400;s:8:\"inserter\";b:0;s:13:\"templateTypes\";a:1:{i:0;s:6:\"search\";}}s:29:\"template-search-portfolio.php\";a:6:{s:5:\"title\";s:25:\"Portfolio search template\";s:4:\"slug\";s:42:\"twentytwentyfour/template-search-portfolio\";s:11:\"description\";s:0:\"\";s:13:\"viewportWidth\";i:1400;s:8:\"inserter\";b:0;s:13:\"templateTypes\";a:1:{i:0;s:6:\"search\";}}s:29:\"template-single-portfolio.php\";a:6:{s:5:\"title\";s:30:\"Portfolio single post template\";s:4:\"slug\";s:42:\"twentytwentyfour/template-single-portfolio\";s:11:\"description\";s:0:\"\";s:13:\"viewportWidth\";i:1400;s:8:\"inserter\";b:0;s:13:\"templateTypes\";a:2:{i:0;s:5:\"posts\";i:1;s:6:\"single\";}}s:24:\"testimonial-centered.php\";a:6:{s:5:\"title\";s:20:\"Centered testimonial\";s:4:\"slug\";s:37:\"twentytwentyfour/testimonial-centered\";s:11:\"description\";s:67:\"A centered testimonial section with an avatar, name, and job title.\";s:13:\"viewportWidth\";i:1300;s:10:\"categories\";a:2:{i:0;s:12:\"testimonials\";i:1;s:4:\"text\";}s:8:\"keywords\";a:3:{i:0;s:5:\"quote\";i:1;s:6:\"review\";i:2;s:5:\"about\";}}s:27:\"text-alternating-images.php\";a:5:{s:5:\"title\";s:28:\"Text with alternating images\";s:4:\"slug\";s:40:\"twentytwentyfour/text-alternating-images\";s:11:\"description\";s:92:\"A text section, then a two-column section with text in one column and an image in the other.\";s:13:\"viewportWidth\";i:1400;s:10:\"categories\";a:2:{i:0;s:4:\"text\";i:1;s:5:\"about\";}}s:33:\"text-centered-statement-small.php\";a:6:{s:5:\"title\";s:25:\"Centered statement, small\";s:4:\"slug\";s:46:\"twentytwentyfour/text-centered-statement-small\";s:11:\"description\";s:54:\"A centered italic text statement with compact padding.\";s:13:\"viewportWidth\";i:1200;s:10:\"categories\";a:2:{i:0;s:4:\"text\";i:1;s:5:\"about\";}s:8:\"keywords\";a:2:{i:0;s:7:\"mission\";i:1;s:12:\"introduction\";}}s:27:\"text-centered-statement.php\";a:6:{s:5:\"title\";s:18:\"Centered statement\";s:4:\"slug\";s:40:\"twentytwentyfour/text-centered-statement\";s:11:\"description\";s:70:\"A centered text statement with a large amount of padding on all sides.\";s:13:\"viewportWidth\";i:1400;s:10:\"categories\";a:3:{i:0;s:4:\"text\";i:1;s:5:\"about\";i:2;s:8:\"featured\";}s:8:\"keywords\";a:2:{i:0;s:7:\"mission\";i:1;s:12:\"introduction\";}}s:12:\"text-faq.php\";a:6:{s:5:\"title\";s:3:\"FAQ\";s:4:\"slug\";s:25:\"twentytwentyfour/text-faq\";s:11:\"description\";s:76:\"A FAQ section with a large FAQ heading and a group of questions and answers.\";s:13:\"viewportWidth\";i:1400;s:10:\"categories\";a:3:{i:0;s:4:\"text\";i:1;s:5:\"about\";i:2;s:8:\"featured\";}s:8:\"keywords\";a:4:{i:0;s:3:\"faq\";i:1;s:5:\"about\";i:2;s:10:\"frequently\";i:3;s:5:\"asked\";}}s:27:\"text-feature-grid-3-col.php\";a:5:{s:5:\"title\";s:23:\"Feature grid, 3 columns\";s:4:\"slug\";s:40:\"twentytwentyfour/text-feature-grid-3-col\";s:11:\"description\";s:62:\"A feature grid of 2 rows and 3 columns with headings and text.\";s:13:\"viewportWidth\";i:1400;s:10:\"categories\";a:2:{i:0;s:4:\"text\";i:1;s:5:\"about\";}}s:24:\"text-project-details.php\";a:5:{s:5:\"title\";s:15:\"Project details\";s:4:\"slug\";s:37:\"twentytwentyfour/text-project-details\";s:11:\"description\";s:40:\"A text-only section for project details.\";s:13:\"viewportWidth\";i:1400;s:10:\"categories\";a:2:{i:0;s:4:\"text\";i:1;s:9:\"portfolio\";}}s:31:\"text-title-left-image-right.php\";a:5:{s:5:\"title\";s:49:\"Title text and button on left with image on right\";s:4:\"slug\";s:44:\"twentytwentyfour/text-title-left-image-right\";s:11:\"description\";s:77:\"A title, a paragraph and a CTA button on the left with an image on the right.\";s:13:\"viewportWidth\";i:1400;s:10:\"categories\";a:3:{i:0;s:6:\"banner\";i:1;s:5:\"about\";i:2;s:8:\"featured\";}}}}", "off");
INSERT INTO `inter_options` VALUES("2152", "_site_transient_timeout_fs_garbage_collection", "1761419081", "off");
INSERT INTO `inter_options` VALUES("2153", "_site_transient_fs_garbage_collection", "1", "off");
INSERT INTO `inter_options` VALUES("2154", "_site_transient_timeout_available_translations", "1761343481", "off");
INSERT INTO `inter_options` VALUES("2155", "_site_transient_available_translations", "a:131:{s:2:\"af\";a:8:{s:8:\"language\";s:2:\"af\";s:7:\"version\";s:8:\"5.8-beta\";s:7:\"updated\";s:19:\"2021-05-13 15:59:22\";s:12:\"english_name\";s:9:\"Afrikaans\";s:11:\"native_name\";s:9:\"Afrikaans\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/5.8-beta/af.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"af\";i:2;s:3:\"afr\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:10:\"Gaan voort\";}}s:2:\"am\";a:8:{s:8:\"language\";s:2:\"am\";s:7:\"version\";s:6:\"6.0.11\";s:7:\"updated\";s:19:\"2022-09-29 20:43:49\";s:12:\"english_name\";s:7:\"Amharic\";s:11:\"native_name\";s:12:\"አማርኛ\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/6.0.11/am.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"am\";i:2;s:3:\"amh\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"ቀጥል\";}}s:3:\"arg\";a:8:{s:8:\"language\";s:3:\"arg\";s:7:\"version\";s:8:\"6.2-beta\";s:7:\"updated\";s:19:\"2022-09-22 16:46:56\";s:12:\"english_name\";s:9:\"Aragonese\";s:11:\"native_name\";s:9:\"Aragonés\";s:7:\"package\";s:65:\"https://downloads.wordpress.org/translation/core/6.2-beta/arg.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"an\";i:2;s:3:\"arg\";i:3;s:3:\"arg\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Continar\";}}s:2:\"ar\";a:8:{s:8:\"language\";s:2:\"ar\";s:7:\"version\";s:5:\"6.4.7\";s:7:\"updated\";s:19:\"2024-02-13 12:49:38\";s:12:\"english_name\";s:6:\"Arabic\";s:11:\"native_name\";s:14:\"العربية\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/6.4.7/ar.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"ar\";i:2;s:3:\"ara\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:12:\"متابعة\";}}s:3:\"ary\";a:8:{s:8:\"language\";s:3:\"ary\";s:7:\"version\";s:6:\"4.8.27\";s:7:\"updated\";s:19:\"2017-01-26 15:42:35\";s:12:\"english_name\";s:15:\"Moroccan Arabic\";s:11:\"native_name\";s:31:\"العربية المغربية\";s:7:\"package\";s:63:\"https://downloads.wordpress.org/translation/core/4.8.27/ary.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"ar\";i:3;s:3:\"ary\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:16:\"المتابعة\";}}s:2:\"as\";a:8:{s:8:\"language\";s:2:\"as\";s:7:\"version\";s:5:\"6.8.3\";s:7:\"updated\";s:19:\"2025-07-10 08:09:09\";s:12:\"english_name\";s:8:\"Assamese\";s:11:\"native_name\";s:21:\"অসমীয়া\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/6.8.3/as.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"as\";i:2;s:3:\"asm\";i:3;s:3:\"asm\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Continue\";}}s:3:\"azb\";a:8:{s:8:\"language\";s:3:\"azb\";s:7:\"version\";s:5:\"6.4.7\";s:7:\"updated\";s:19:\"2024-01-19 08:58:31\";s:12:\"english_name\";s:17:\"South Azerbaijani\";s:11:\"native_name\";s:29:\"گؤنئی آذربایجان\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/6.4.7/azb.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"az\";i:3;s:3:\"azb\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Continue\";}}s:2:\"az\";a:8:{s:8:\"language\";s:2:\"az\";s:7:\"version\";s:5:\"4.7.2\";s:7:\"updated\";s:19:\"2016-11-06 00:09:27\";s:12:\"english_name\";s:11:\"Azerbaijani\";s:11:\"native_name\";s:16:\"Azərbaycan dili\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/4.7.2/az.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"az\";i:2;s:3:\"aze\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:5:\"Davam\";}}s:3:\"bel\";a:8:{s:8:\"language\";s:3:\"bel\";s:7:\"version\";s:6:\"4.9.28\";s:7:\"updated\";s:19:\"2024-12-26 00:37:42\";s:12:\"english_name\";s:10:\"Belarusian\";s:11:\"native_name\";s:29:\"Беларуская мова\";s:7:\"package\";s:63:\"https://downloads.wordpress.org/translation/core/4.9.28/bel.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"be\";i:2;s:3:\"bel\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:20:\"Працягнуць\";}}s:5:\"bg_BG\";a:8:{s:8:\"language\";s:5:\"bg_BG\";s:7:\"version\";s:5:\"6.8.3\";s:7:\"updated\";s:19:\"2025-06-26 09:35:39\";s:12:\"english_name\";s:9:\"Bulgarian\";s:11:\"native_name\";s:18:\"Български\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.8.3/bg_BG.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"bg\";i:2;s:3:\"bul\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:12:\"Напред\";}}s:5:\"bn_BD\";a:8:{s:8:\"language\";s:5:\"bn_BD\";s:7:\"version\";s:5:\"6.8.3\";s:7:\"updated\";s:19:\"2025-10-20 04:59:05\";s:12:\"english_name\";s:20:\"Bengali (Bangladesh)\";s:11:\"native_name\";s:15:\"বাংলা\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.8.3/bn_BD.zip\";s:3:\"iso\";a:1:{i:1;s:2:\"bn\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:28:\"চালিয়ে যান\";}}s:2:\"bo\";a:8:{s:8:\"language\";s:2:\"bo\";s:7:\"version\";s:8:\"5.8-beta\";s:7:\"updated\";s:19:\"2020-10-30 03:24:38\";s:12:\"english_name\";s:7:\"Tibetan\";s:11:\"native_name\";s:21:\"བོད་ཡིག\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/5.8-beta/bo.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"bo\";i:2;s:3:\"tib\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:33:\"མུ་མཐུད་དུ།\";}}s:5:\"bs_BA\";a:8:{s:8:\"language\";s:5:\"bs_BA\";s:7:\"version\";s:5:\"6.2.8\";s:7:\"updated\";s:19:\"2023-02-22 20:45:53\";s:12:\"english_name\";s:7:\"Bosnian\";s:11:\"native_name\";s:8:\"Bosanski\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.2.8/bs_BA.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"bs\";i:2;s:3:\"bos\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:7:\"Nastavi\";}}s:2:\"ca\";a:8:{s:8:\"language\";s:2:\"ca\";s:7:\"version\";s:5:\"6.8.3\";s:7:\"updated\";s:19:\"2025-10-24 11:48:01\";s:12:\"english_name\";s:7:\"Catalan\";s:11:\"native_name\";s:7:\"Català\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/6.8.3/ca.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"ca\";i:2;s:3:\"cat\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Continua\";}}s:3:\"ceb\";a:8:{s:8:\"language\";s:3:\"ceb\";s:7:\"version\";s:5:\"4.7.2\";s:7:\"updated\";s:19:\"2016-03-02 17:25:51\";s:12:\"english_name\";s:7:\"Cebuano\";s:11:\"native_name\";s:7:\"Cebuano\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/4.7.2/ceb.zip\";s:3:\"iso\";a:2:{i:2;s:3:\"ceb\";i:3;s:3:\"ceb\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:7:\"Padayun\";}}s:5:\"cs_CZ\";a:8:{s:8:\"language\";s:5:\"cs_CZ\";s:7:\"version\";s:5:\"6.8.3\";s:7:\"updated\";s:19:\"2025-09-09 08:25:54\";s:12:\"english_name\";s:5:\"Czech\";s:11:\"native_name\";s:9:\"Čeština\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.8.3/cs_CZ.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"cs\";i:2;s:3:\"ces\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:11:\"Pokračovat\";}}s:2:\"cy\";a:8:{s:8:\"language\";s:2:\"cy\";s:7:\"version\";s:5:\"6.8.3\";s:7:\"updated\";s:19:\"2025-10-05 08:42:11\";s:12:\"english_name\";s:5:\"Welsh\";s:11:\"native_name\";s:7:\"Cymraeg\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/6.8.3/cy.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"cy\";i:2;s:3:\"cym\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:6:\"Parhau\";}}s:5:\"da_DK\";a:8:{s:8:\"language\";s:5:\"da_DK\";s:7:\"version\";s:5:\"6.8.3\";s:7:\"updated\";s:19:\"2025-10-23 11:26:14\";s:12:\"english_name\";s:6:\"Danish\";s:11:\"native_name\";s:5:\"Dansk\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.8.3/da_DK.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"da\";i:2;s:3:\"dan\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Fortsæt\";}}s:5:\"de_CH\";a:8:{s:8:\"language\";s:5:\"de_CH\";s:7:\"version\";s:5:\"6.8.3\";s:7:\"updated\";s:19:\"2025-07-28 10:25:03\";s:12:\"english_name\";s:20:\"German (Switzerland)\";s:11:\"native_name\";s:17:\"Deutsch (Schweiz)\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.8.3/de_CH.zip\";s:3:\"iso\";a:1:{i:1;s:2:\"de\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:6:\"Weiter\";}}s:5:\"de_DE\";a:8:{s:8:\"language\";s:5:\"de_DE\";s:7:\"version\";s:5:\"6.8.3\";s:7:\"updated\";s:19:\"2025-10-23 02:15:27\";s:12:\"english_name\";s:6:\"German\";s:11:\"native_name\";s:7:\"Deutsch\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.8.3/de_DE.zip\";s:3:\"iso\";a:1:{i:1;s:2:\"de\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:6:\"Weiter\";}}s:12:\"de_DE_formal\";a:8:{s:8:\"language\";s:12:\"de_DE_formal\";s:7:\"version\";s:5:\"6.8.3\";s:7:\"updated\";s:19:\"2025-10-23 02:14:40\";s:12:\"english_name\";s:15:\"German (Formal)\";s:11:\"native_name\";s:13:\"Deutsch (Sie)\";s:7:\"package\";s:71:\"https://downloads.wordpress.org/translation/core/6.8.3/de_DE_formal.zip\";s:3:\"iso\";a:1:{i:1;s:2:\"de\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:6:\"Weiter\";}}s:5:\"de_AT\";a:8:{s:8:\"language\";s:5:\"de_AT\";s:7:\"version\";s:5:\"6.8.3\";s:7:\"updated\";s:19:\"2025-10-23 12:02:03\";s:12:\"english_name\";s:16:\"German (Austria)\";s:11:\"native_name\";s:21:\"Deutsch (Österreich)\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.8.3/de_AT.zip\";s:3:\"iso\";a:1:{i:1;s:2:\"de\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:6:\"Weiter\";}}s:14:\"de_CH_informal\";a:8:{s:8:\"language\";s:14:\"de_CH_informal\";s:7:\"version\";s:5:\"6.8.3\";s:7:\"updated\";s:19:\"2025-07-28 10:25:24\";s:12:\"english_name\";s:30:\"German (Switzerland, Informal)\";s:11:\"native_name\";s:21:\"Deutsch (Schweiz, Du)\";s:7:\"package\";s:73:\"https://downloads.wordpress.org/translation/core/6.8.3/de_CH_informal.zip\";s:3:\"iso\";a:1:{i:1;s:2:\"de\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:6:\"Weiter\";}}s:3:\"dsb\";a:8:{s:8:\"language\";s:3:\"dsb\";s:7:\"version\";s:5:\"6.2.8\";s:7:\"updated\";s:19:\"2022-07-16 12:13:09\";s:12:\"english_name\";s:13:\"Lower Sorbian\";s:11:\"native_name\";s:16:\"Dolnoserbšćina\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/6.2.8/dsb.zip\";s:3:\"iso\";a:2:{i:2;s:3:\"dsb\";i:3;s:3:\"dsb\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:5:\"Dalej\";}}s:3:\"dzo\";a:8:{s:8:\"language\";s:3:\"dzo\";s:7:\"version\";s:5:\"4.7.2\";s:7:\"updated\";s:19:\"2016-06-29 08:59:03\";s:12:\"english_name\";s:8:\"Dzongkha\";s:11:\"native_name\";s:18:\"རྫོང་ཁ\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/4.7.2/dzo.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"dz\";i:2;s:3:\"dzo\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Continue\";}}s:2:\"el\";a:8:{s:8:\"language\";s:2:\"el\";s:7:\"version\";s:5:\"6.8.3\";s:7:\"updated\";s:19:\"2025-10-22 13:46:55\";s:12:\"english_name\";s:5:\"Greek\";s:11:\"native_name\";s:16:\"Ελληνικά\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/6.8.3/el.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"el\";i:2;s:3:\"ell\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:16:\"Συνέχεια\";}}s:5:\"en_ZA\";a:8:{s:8:\"language\";s:5:\"en_ZA\";s:7:\"version\";s:5:\"6.8.3\";s:7:\"updated\";s:19:\"2025-07-29 13:22:09\";s:12:\"english_name\";s:22:\"English (South Africa)\";s:11:\"native_name\";s:22:\"English (South Africa)\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.8.3/en_ZA.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"en\";i:2;s:3:\"eng\";i:3;s:3:\"eng\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Continue\";}}s:5:\"en_AU\";a:8:{s:8:\"language\";s:5:\"en_AU\";s:7:\"version\";s:5:\"6.8.3\";s:7:\"updated\";s:19:\"2025-08-19 23:02:24\";s:12:\"english_name\";s:19:\"English (Australia)\";s:11:\"native_name\";s:19:\"English (Australia)\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.8.3/en_AU.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"en\";i:2;s:3:\"eng\";i:3;s:3:\"eng\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Continue\";}}s:5:\"en_NZ\";a:8:{s:8:\"language\";s:5:\"en_NZ\";s:7:\"version\";s:5:\"6.8.3\";s:7:\"updated\";s:19:\"2025-05-22 11:56:25\";s:12:\"english_name\";s:21:\"English (New Zealand)\";s:11:\"native_name\";s:21:\"English (New Zealand)\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.8.3/en_NZ.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"en\";i:2;s:3:\"eng\";i:3;s:3:\"eng\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Continue\";}}s:5:\"en_GB\";a:8:{s:8:\"language\";s:5:\"en_GB\";s:7:\"version\";s:5:\"6.8.3\";s:7:\"updated\";s:19:\"2025-10-08 12:55:00\";s:12:\"english_name\";s:12:\"English (UK)\";s:11:\"native_name\";s:12:\"English (UK)\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.8.3/en_GB.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"en\";i:2;s:3:\"eng\";i:3;s:3:\"eng\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Continue\";}}s:5:\"en_CA\";a:8:{s:8:\"language\";s:5:\"en_CA\";s:7:\"version\";s:5:\"6.8.3\";s:7:\"updated\";s:19:\"2025-10-21 17:41:39\";s:12:\"english_name\";s:16:\"English (Canada)\";s:11:\"native_name\";s:16:\"English (Canada)\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.8.3/en_CA.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"en\";i:2;s:3:\"eng\";i:3;s:3:\"eng\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Continue\";}}s:2:\"eo\";a:8:{s:8:\"language\";s:2:\"eo\";s:7:\"version\";s:5:\"6.8.3\";s:7:\"updated\";s:19:\"2025-08-19 08:40:47\";s:12:\"english_name\";s:9:\"Esperanto\";s:11:\"native_name\";s:9:\"Esperanto\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/6.8.3/eo.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"eo\";i:2;s:3:\"epo\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Daŭrigi\";}}s:5:\"es_PE\";a:8:{s:8:\"language\";s:5:\"es_PE\";s:7:\"version\";s:5:\"6.8.3\";s:7:\"updated\";s:19:\"2024-10-16 21:04:12\";s:12:\"english_name\";s:14:\"Spanish (Peru)\";s:11:\"native_name\";s:17:\"Español de Perú\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.8.3/es_PE.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"es\";i:2;s:3:\"spa\";i:3;s:3:\"spa\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuar\";}}s:5:\"es_CL\";a:8:{s:8:\"language\";s:5:\"es_CL\";s:7:\"version\";s:5:\"6.8.3\";s:7:\"updated\";s:19:\"2025-10-02 21:15:15\";s:12:\"english_name\";s:15:\"Spanish (Chile)\";s:11:\"native_name\";s:17:\"Español de Chile\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.8.3/es_CL.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"es\";i:2;s:3:\"spa\";i:3;s:3:\"spa\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuar\";}}s:5:\"es_AR\";a:8:{s:8:\"language\";s:5:\"es_AR\";s:7:\"version\";s:5:\"6.8.3\";s:7:\"updated\";s:19:\"2025-10-08 01:26:01\";s:12:\"english_name\";s:19:\"Spanish (Argentina)\";s:11:\"native_name\";s:21:\"Español de Argentina\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.8.3/es_AR.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"es\";i:2;s:3:\"spa\";i:3;s:3:\"spa\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuar\";}}s:5:\"es_CO\";a:8:{s:8:\"language\";s:5:\"es_CO\";s:7:\"version\";s:5:\"6.8.3\";s:7:\"updated\";s:19:\"2025-10-09 03:23:24\";s:12:\"english_name\";s:18:\"Spanish (Colombia)\";s:11:\"native_name\";s:20:\"Español de Colombia\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.8.3/es_CO.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"es\";i:2;s:3:\"spa\";i:3;s:3:\"spa\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuar\";}}s:5:\"es_ES\";a:8:{s:8:\"language\";s:5:\"es_ES\";s:7:\"version\";s:5:\"6.8.3\";s:7:\"updated\";s:19:\"2025-10-24 16:10:21\";s:12:\"english_name\";s:15:\"Spanish (Spain)\";s:11:\"native_name\";s:8:\"Español\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.8.3/es_ES.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"es\";i:2;s:3:\"spa\";i:3;s:3:\"spa\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuar\";}}s:5:\"es_VE\";a:8:{s:8:\"language\";s:5:\"es_VE\";s:7:\"version\";s:5:\"6.4.7\";s:7:\"updated\";s:19:\"2023-10-16 16:00:04\";s:12:\"english_name\";s:19:\"Spanish (Venezuela)\";s:11:\"native_name\";s:21:\"Español de Venezuela\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.4.7/es_VE.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"es\";i:2;s:3:\"spa\";i:3;s:3:\"spa\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuar\";}}s:5:\"es_EC\";a:8:{s:8:\"language\";s:5:\"es_EC\";s:7:\"version\";s:5:\"6.2.8\";s:7:\"updated\";s:19:\"2023-04-21 13:32:10\";s:12:\"english_name\";s:17:\"Spanish (Ecuador)\";s:11:\"native_name\";s:19:\"Español de Ecuador\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.2.8/es_EC.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"es\";i:2;s:3:\"spa\";i:3;s:3:\"spa\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuar\";}}s:5:\"es_DO\";a:8:{s:8:\"language\";s:5:\"es_DO\";s:7:\"version\";s:6:\"5.8.12\";s:7:\"updated\";s:19:\"2021-10-08 14:32:50\";s:12:\"english_name\";s:28:\"Spanish (Dominican Republic)\";s:11:\"native_name\";s:33:\"Español de República Dominicana\";s:7:\"package\";s:65:\"https://downloads.wordpress.org/translation/core/5.8.12/es_DO.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"es\";i:2;s:3:\"spa\";i:3;s:3:\"spa\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuar\";}}s:5:\"es_UY\";a:8:{s:8:\"language\";s:5:\"es_UY\";s:7:\"version\";s:8:\"5.8-beta\";s:7:\"updated\";s:19:\"2021-03-31 18:33:26\";s:12:\"english_name\";s:17:\"Spanish (Uruguay)\";s:11:\"native_name\";s:19:\"Español de Uruguay\";s:7:\"package\";s:67:\"https://downloads.wordpress.org/translation/core/5.8-beta/es_UY.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"es\";i:2;s:3:\"spa\";i:3;s:3:\"spa\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuar\";}}s:5:\"es_PR\";a:8:{s:8:\"language\";s:5:\"es_PR\";s:7:\"version\";s:6:\"5.4.18\";s:7:\"updated\";s:19:\"2020-04-29 15:36:59\";s:12:\"english_name\";s:21:\"Spanish (Puerto Rico)\";s:11:\"native_name\";s:23:\"Español de Puerto Rico\";s:7:\"package\";s:65:\"https://downloads.wordpress.org/translation/core/5.4.18/es_PR.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"es\";i:2;s:3:\"spa\";i:3;s:3:\"spa\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuar\";}}s:5:\"es_GT\";a:8:{s:8:\"language\";s:5:\"es_GT\";s:7:\"version\";s:6:\"5.2.23\";s:7:\"updated\";s:19:\"2019-03-02 06:35:01\";s:12:\"english_name\";s:19:\"Spanish (Guatemala)\";s:11:\"native_name\";s:21:\"Español de Guatemala\";s:7:\"package\";s:65:\"https://downloads.wordpress.org/translation/core/5.2.23/es_GT.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"es\";i:2;s:3:\"spa\";i:3;s:3:\"spa\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuar\";}}s:5:\"es_MX\";a:8:{s:8:\"language\";s:5:\"es_MX\";s:7:\"version\";s:5:\"6.8.3\";s:7:\"updated\";s:19:\"2025-09-30 21:17:40\";s:12:\"english_name\";s:16:\"Spanish (Mexico)\";s:11:\"native_name\";s:19:\"Español de México\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.8.3/es_MX.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"es\";i:2;s:3:\"spa\";i:3;s:3:\"spa\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuar\";}}s:5:\"es_CR\";a:8:{s:8:\"language\";s:5:\"es_CR\";s:7:\"version\";s:5:\"6.8.3\";s:7:\"updated\";s:19:\"2025-10-01 22:54:47\";s:12:\"english_name\";s:20:\"Spanish (Costa Rica)\";s:11:\"native_name\";s:22:\"Español de Costa Rica\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.8.3/es_CR.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"es\";i:2;s:3:\"spa\";i:3;s:3:\"spa\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuar\";}}s:2:\"et\";a:8:{s:8:\"language\";s:2:\"et\";s:7:\"version\";s:5:\"6.5.5\";s:7:\"updated\";s:19:\"2024-06-06 09:50:37\";s:12:\"english_name\";s:8:\"Estonian\";s:11:\"native_name\";s:5:\"Eesti\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/6.5.5/et.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"et\";i:2;s:3:\"est\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:6:\"Jätka\";}}s:2:\"eu\";a:8:{s:8:\"language\";s:2:\"eu\";s:7:\"version\";s:5:\"6.8.3\";s:7:\"updated\";s:19:\"2025-07-05 12:26:55\";s:12:\"english_name\";s:6:\"Basque\";s:11:\"native_name\";s:7:\"Euskara\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/6.8.3/eu.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"eu\";i:2;s:3:\"eus\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Jarraitu\";}}s:5:\"fa_AF\";a:8:{s:8:\"language\";s:5:\"fa_AF\";s:7:\"version\";s:5:\"6.8.3\";s:7:\"updated\";s:19:\"2025-02-14 17:29:08\";s:12:\"english_name\";s:21:\"Persian (Afghanistan)\";s:11:\"native_name\";s:31:\"(فارسی (افغانستان\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.8.3/fa_AF.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"fa\";i:2;s:3:\"fas\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:10:\"ادامه\";}}s:5:\"fa_IR\";a:8:{s:8:\"language\";s:5:\"fa_IR\";s:7:\"version\";s:5:\"6.8.3\";s:7:\"updated\";s:19:\"2025-10-02 18:18:37\";s:12:\"english_name\";s:7:\"Persian\";s:11:\"native_name\";s:10:\"فارسی\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.8.3/fa_IR.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"fa\";i:2;s:3:\"fas\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:10:\"ادامه\";}}s:2:\"fi\";a:8:{s:8:\"language\";s:2:\"fi\";s:7:\"version\";s:5:\"6.8.3\";s:7:\"updated\";s:19:\"2025-10-01 04:49:09\";s:12:\"english_name\";s:7:\"Finnish\";s:11:\"native_name\";s:5:\"Suomi\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/6.8.3/fi.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"fi\";i:2;s:3:\"fin\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:5:\"Jatka\";}}s:5:\"fr_CA\";a:8:{s:8:\"language\";s:5:\"fr_CA\";s:7:\"version\";s:5:\"6.8.3\";s:7:\"updated\";s:19:\"2025-09-25 05:20:17\";s:12:\"english_name\";s:15:\"French (Canada)\";s:11:\"native_name\";s:19:\"Français du Canada\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.8.3/fr_CA.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"fr\";i:2;s:3:\"fra\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuer\";}}s:5:\"fr_BE\";a:8:{s:8:\"language\";s:5:\"fr_BE\";s:7:\"version\";s:5:\"6.5.7\";s:7:\"updated\";s:19:\"2024-02-01 23:56:53\";s:12:\"english_name\";s:16:\"French (Belgium)\";s:11:\"native_name\";s:21:\"Français de Belgique\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.5.7/fr_BE.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"fr\";i:2;s:3:\"fra\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuer\";}}s:5:\"fr_FR\";a:8:{s:8:\"language\";s:5:\"fr_FR\";s:7:\"version\";s:5:\"6.8.3\";s:7:\"updated\";s:19:\"2025-10-01 15:38:59\";s:12:\"english_name\";s:15:\"French (France)\";s:11:\"native_name\";s:9:\"Français\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.8.3/fr_FR.zip\";s:3:\"iso\";a:1:{i:1;s:2:\"fr\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuer\";}}s:3:\"fur\";a:8:{s:8:\"language\";s:3:\"fur\";s:7:\"version\";s:6:\"4.8.27\";s:7:\"updated\";s:19:\"2023-04-30 13:56:46\";s:12:\"english_name\";s:8:\"Friulian\";s:11:\"native_name\";s:8:\"Friulian\";s:7:\"package\";s:63:\"https://downloads.wordpress.org/translation/core/4.8.27/fur.zip\";s:3:\"iso\";a:2:{i:2;s:3:\"fur\";i:3;s:3:\"fur\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Continue\";}}s:2:\"fy\";a:8:{s:8:\"language\";s:2:\"fy\";s:7:\"version\";s:5:\"6.2.8\";s:7:\"updated\";s:19:\"2025-10-21 16:35:04\";s:12:\"english_name\";s:7:\"Frisian\";s:11:\"native_name\";s:5:\"Frysk\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/6.2.8/fy.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"fy\";i:2;s:3:\"fry\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Trochgean\";}}s:2:\"gd\";a:8:{s:8:\"language\";s:2:\"gd\";s:7:\"version\";s:5:\"4.7.2\";s:7:\"updated\";s:19:\"2016-08-23 17:41:37\";s:12:\"english_name\";s:15:\"Scottish Gaelic\";s:11:\"native_name\";s:9:\"Gàidhlig\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/4.7.2/gd.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"gd\";i:2;s:3:\"gla\";i:3;s:3:\"gla\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:15:\"Lean air adhart\";}}s:5:\"gl_ES\";a:8:{s:8:\"language\";s:5:\"gl_ES\";s:7:\"version\";s:5:\"6.8.3\";s:7:\"updated\";s:19:\"2025-10-02 21:35:41\";s:12:\"english_name\";s:8:\"Galician\";s:11:\"native_name\";s:6:\"Galego\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.8.3/gl_ES.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"gl\";i:2;s:3:\"glg\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuar\";}}s:2:\"gu\";a:8:{s:8:\"language\";s:2:\"gu\";s:7:\"version\";s:5:\"6.8.3\";s:7:\"updated\";s:19:\"2025-08-29 04:27:18\";s:12:\"english_name\";s:8:\"Gujarati\";s:11:\"native_name\";s:21:\"ગુજરાતી\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/6.8.3/gu.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"gu\";i:2;s:3:\"guj\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:25:\"ચાલુ રાખો\";}}s:3:\"haz\";a:8:{s:8:\"language\";s:3:\"haz\";s:7:\"version\";s:6:\"4.4.34\";s:7:\"updated\";s:19:\"2015-12-05 00:59:09\";s:12:\"english_name\";s:8:\"Hazaragi\";s:11:\"native_name\";s:15:\"هزاره گی\";s:7:\"package\";s:63:\"https://downloads.wordpress.org/translation/core/4.4.34/haz.zip\";s:3:\"iso\";a:1:{i:3;s:3:\"haz\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:10:\"ادامه\";}}s:5:\"he_IL\";a:8:{s:8:\"language\";s:5:\"he_IL\";s:7:\"version\";s:5:\"6.2.8\";s:7:\"updated\";s:19:\"2024-05-04 18:39:24\";s:12:\"english_name\";s:6:\"Hebrew\";s:11:\"native_name\";s:16:\"עִבְרִית\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.2.8/he_IL.zip\";s:3:\"iso\";a:1:{i:1;s:2:\"he\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"המשך\";}}s:5:\"hi_IN\";a:8:{s:8:\"language\";s:5:\"hi_IN\";s:7:\"version\";s:5:\"6.4.7\";s:7:\"updated\";s:19:\"2025-02-06 05:17:11\";s:12:\"english_name\";s:5:\"Hindi\";s:11:\"native_name\";s:18:\"हिन्दी\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.4.7/hi_IN.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"hi\";i:2;s:3:\"hin\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:25:\"जारी रखें\";}}s:2:\"hr\";a:8:{s:8:\"language\";s:2:\"hr\";s:7:\"version\";s:5:\"6.8.3\";s:7:\"updated\";s:19:\"2025-10-18 08:52:05\";s:12:\"english_name\";s:8:\"Croatian\";s:11:\"native_name\";s:8:\"Hrvatski\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/6.8.3/hr.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"hr\";i:2;s:3:\"hrv\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:7:\"Nastavi\";}}s:3:\"hsb\";a:8:{s:8:\"language\";s:3:\"hsb\";s:7:\"version\";s:5:\"6.2.8\";s:7:\"updated\";s:19:\"2023-02-22 17:37:32\";s:12:\"english_name\";s:13:\"Upper Sorbian\";s:11:\"native_name\";s:17:\"Hornjoserbšćina\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/6.2.8/hsb.zip\";s:3:\"iso\";a:2:{i:2;s:3:\"hsb\";i:3;s:3:\"hsb\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:4:\"Dale\";}}s:5:\"hu_HU\";a:8:{s:8:\"language\";s:5:\"hu_HU\";s:7:\"version\";s:5:\"6.8.3\";s:7:\"updated\";s:19:\"2025-10-18 06:36:37\";s:12:\"english_name\";s:9:\"Hungarian\";s:11:\"native_name\";s:6:\"Magyar\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.8.3/hu_HU.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"hu\";i:2;s:3:\"hun\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:10:\"Folytatás\";}}s:2:\"hy\";a:8:{s:8:\"language\";s:2:\"hy\";s:7:\"version\";s:5:\"4.7.2\";s:7:\"updated\";s:19:\"2016-12-03 16:21:10\";s:12:\"english_name\";s:8:\"Armenian\";s:11:\"native_name\";s:14:\"Հայերեն\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/4.7.2/hy.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"hy\";i:2;s:3:\"hye\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:20:\"Շարունակել\";}}s:5:\"id_ID\";a:8:{s:8:\"language\";s:5:\"id_ID\";s:7:\"version\";s:5:\"6.8.3\";s:7:\"updated\";s:19:\"2025-10-23 03:46:40\";s:12:\"english_name\";s:10:\"Indonesian\";s:11:\"native_name\";s:16:\"Bahasa Indonesia\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.8.3/id_ID.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"id\";i:2;s:3:\"ind\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Lanjutkan\";}}s:5:\"is_IS\";a:8:{s:8:\"language\";s:5:\"is_IS\";s:7:\"version\";s:6:\"4.9.28\";s:7:\"updated\";s:19:\"2018-12-11 10:40:02\";s:12:\"english_name\";s:9:\"Icelandic\";s:11:\"native_name\";s:9:\"Íslenska\";s:7:\"package\";s:65:\"https://downloads.wordpress.org/translation/core/4.9.28/is_IS.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"is\";i:2;s:3:\"isl\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:6:\"Áfram\";}}s:5:\"it_IT\";a:8:{s:8:\"language\";s:5:\"it_IT\";s:7:\"version\";s:5:\"6.8.3\";s:7:\"updated\";s:19:\"2025-10-14 17:47:58\";s:12:\"english_name\";s:7:\"Italian\";s:11:\"native_name\";s:8:\"Italiano\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.8.3/it_IT.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"it\";i:2;s:3:\"ita\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Continua\";}}s:2:\"ja\";a:8:{s:8:\"language\";s:2:\"ja\";s:7:\"version\";s:5:\"6.8.3\";s:7:\"updated\";s:19:\"2025-10-03 12:44:05\";s:12:\"english_name\";s:8:\"Japanese\";s:11:\"native_name\";s:9:\"日本語\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/6.8.3/ja.zip\";s:3:\"iso\";a:1:{i:1;s:2:\"ja\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:6:\"次へ\";}}s:5:\"jv_ID\";a:8:{s:8:\"language\";s:5:\"jv_ID\";s:7:\"version\";s:6:\"4.9.28\";s:7:\"updated\";s:19:\"2019-02-16 23:58:56\";s:12:\"english_name\";s:8:\"Javanese\";s:11:\"native_name\";s:9:\"Basa Jawa\";s:7:\"package\";s:65:\"https://downloads.wordpress.org/translation/core/4.9.28/jv_ID.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"jv\";i:2;s:3:\"jav\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Nerusaké\";}}s:5:\"ka_GE\";a:8:{s:8:\"language\";s:5:\"ka_GE\";s:7:\"version\";s:5:\"6.8.3\";s:7:\"updated\";s:19:\"2025-04-14 08:02:58\";s:12:\"english_name\";s:8:\"Georgian\";s:11:\"native_name\";s:21:\"ქართული\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.8.3/ka_GE.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"ka\";i:2;s:3:\"kat\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:30:\"გაგრძელება\";}}s:3:\"kab\";a:8:{s:8:\"language\";s:3:\"kab\";s:7:\"version\";s:5:\"6.2.8\";s:7:\"updated\";s:19:\"2023-07-05 11:40:39\";s:12:\"english_name\";s:6:\"Kabyle\";s:11:\"native_name\";s:9:\"Taqbaylit\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/6.2.8/kab.zip\";s:3:\"iso\";a:2:{i:2;s:3:\"kab\";i:3;s:3:\"kab\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:6:\"Kemmel\";}}s:2:\"kk\";a:8:{s:8:\"language\";s:2:\"kk\";s:7:\"version\";s:5:\"6.8.3\";s:7:\"updated\";s:19:\"2024-07-18 02:49:24\";s:12:\"english_name\";s:6:\"Kazakh\";s:11:\"native_name\";s:19:\"Қазақ тілі\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/6.8.3/kk.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"kk\";i:2;s:3:\"kaz\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:20:\"Жалғастыру\";}}s:2:\"km\";a:8:{s:8:\"language\";s:2:\"km\";s:7:\"version\";s:6:\"5.2.23\";s:7:\"updated\";s:19:\"2019-06-10 16:18:28\";s:12:\"english_name\";s:5:\"Khmer\";s:11:\"native_name\";s:27:\"ភាសាខ្មែរ\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/5.2.23/km.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"km\";i:2;s:3:\"khm\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:12:\"បន្ត\";}}s:2:\"kn\";a:8:{s:8:\"language\";s:2:\"kn\";s:7:\"version\";s:5:\"6.8.3\";s:7:\"updated\";s:19:\"2025-07-22 16:17:50\";s:12:\"english_name\";s:7:\"Kannada\";s:11:\"native_name\";s:15:\"ಕನ್ನಡ\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/6.8.3/kn.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"kn\";i:2;s:3:\"kan\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:30:\"ಮುಂದುವರಿಸು\";}}s:5:\"ko_KR\";a:8:{s:8:\"language\";s:5:\"ko_KR\";s:7:\"version\";s:5:\"6.8.3\";s:7:\"updated\";s:19:\"2025-10-01 23:59:20\";s:12:\"english_name\";s:6:\"Korean\";s:11:\"native_name\";s:9:\"한국어\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.8.3/ko_KR.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"ko\";i:2;s:3:\"kor\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:6:\"계속\";}}s:3:\"ckb\";a:8:{s:8:\"language\";s:3:\"ckb\";s:7:\"version\";s:5:\"6.8.3\";s:7:\"updated\";s:19:\"2025-10-16 22:21:09\";s:12:\"english_name\";s:16:\"Kurdish (Sorani)\";s:11:\"native_name\";s:13:\"كوردی‎\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/6.8.3/ckb.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"ku\";i:3;s:3:\"ckb\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:30:\"به‌رده‌وام به‌\";}}s:3:\"kir\";a:8:{s:8:\"language\";s:3:\"kir\";s:7:\"version\";s:5:\"6.8.3\";s:7:\"updated\";s:19:\"2025-10-15 12:39:47\";s:12:\"english_name\";s:6:\"Kyrgyz\";s:11:\"native_name\";s:16:\"Кыргызча\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/6.8.3/kir.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"ky\";i:2;s:3:\"kir\";i:3;s:3:\"kir\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:14:\"Улантуу\";}}s:2:\"lo\";a:8:{s:8:\"language\";s:2:\"lo\";s:7:\"version\";s:5:\"4.7.2\";s:7:\"updated\";s:19:\"2016-11-12 09:59:23\";s:12:\"english_name\";s:3:\"Lao\";s:11:\"native_name\";s:21:\"ພາສາລາວ\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/4.7.2/lo.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"lo\";i:2;s:3:\"lao\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:18:\"ຕໍ່​ໄປ\";}}s:5:\"lt_LT\";a:8:{s:8:\"language\";s:5:\"lt_LT\";s:7:\"version\";s:5:\"6.8.3\";s:7:\"updated\";s:19:\"2025-09-27 20:51:17\";s:12:\"english_name\";s:10:\"Lithuanian\";s:11:\"native_name\";s:15:\"Lietuvių kalba\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.8.3/lt_LT.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"lt\";i:2;s:3:\"lit\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:6:\"Tęsti\";}}s:2:\"lv\";a:8:{s:8:\"language\";s:2:\"lv\";s:7:\"version\";s:5:\"6.8.3\";s:7:\"updated\";s:19:\"2025-07-15 19:11:43\";s:12:\"english_name\";s:7:\"Latvian\";s:11:\"native_name\";s:16:\"Latviešu valoda\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/6.8.3/lv.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"lv\";i:2;s:3:\"lav\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Turpināt\";}}s:5:\"mk_MK\";a:8:{s:8:\"language\";s:5:\"mk_MK\";s:7:\"version\";s:6:\"6.0.11\";s:7:\"updated\";s:19:\"2022-10-01 09:23:52\";s:12:\"english_name\";s:10:\"Macedonian\";s:11:\"native_name\";s:31:\"Македонски јазик\";s:7:\"package\";s:65:\"https://downloads.wordpress.org/translation/core/6.0.11/mk_MK.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"mk\";i:2;s:3:\"mkd\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:16:\"Продолжи\";}}s:5:\"ml_IN\";a:8:{s:8:\"language\";s:5:\"ml_IN\";s:7:\"version\";s:5:\"6.8.3\";s:7:\"updated\";s:19:\"2025-10-23 17:56:50\";s:12:\"english_name\";s:9:\"Malayalam\";s:11:\"native_name\";s:18:\"മലയാളം\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.8.3/ml_IN.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"ml\";i:2;s:3:\"mal\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:18:\"തുടരുക\";}}s:2:\"mn\";a:8:{s:8:\"language\";s:2:\"mn\";s:7:\"version\";s:5:\"6.5.7\";s:7:\"updated\";s:19:\"2024-06-20 17:22:06\";s:12:\"english_name\";s:9:\"Mongolian\";s:11:\"native_name\";s:12:\"Монгол\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/6.5.7/mn.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"mn\";i:2;s:3:\"mon\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Continue\";}}s:2:\"mr\";a:8:{s:8:\"language\";s:2:\"mr\";s:7:\"version\";s:5:\"6.8.3\";s:7:\"updated\";s:19:\"2025-08-26 17:30:52\";s:12:\"english_name\";s:7:\"Marathi\";s:11:\"native_name\";s:15:\"मराठी\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/6.8.3/mr.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"mr\";i:2;s:3:\"mar\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:25:\"सुरु ठेवा\";}}s:5:\"ms_MY\";a:8:{s:8:\"language\";s:5:\"ms_MY\";s:7:\"version\";s:6:\"5.5.17\";s:7:\"updated\";s:19:\"2022-03-11 13:52:22\";s:12:\"english_name\";s:5:\"Malay\";s:11:\"native_name\";s:13:\"Bahasa Melayu\";s:7:\"package\";s:65:\"https://downloads.wordpress.org/translation/core/5.5.17/ms_MY.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"ms\";i:2;s:3:\"msa\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Teruskan\";}}s:5:\"my_MM\";a:8:{s:8:\"language\";s:5:\"my_MM\";s:7:\"version\";s:6:\"4.2.39\";s:7:\"updated\";s:19:\"2017-12-26 11:57:10\";s:12:\"english_name\";s:17:\"Myanmar (Burmese)\";s:11:\"native_name\";s:15:\"ဗမာစာ\";s:7:\"package\";s:65:\"https://downloads.wordpress.org/translation/core/4.2.39/my_MM.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"my\";i:2;s:3:\"mya\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:54:\"ဆက်လက်လုပ်ဆောင်ပါ။\";}}s:5:\"nb_NO\";a:8:{s:8:\"language\";s:5:\"nb_NO\";s:7:\"version\";s:5:\"6.8.3\";s:7:\"updated\";s:19:\"2025-10-09 19:23:11\";s:12:\"english_name\";s:19:\"Norwegian (Bokmål)\";s:11:\"native_name\";s:13:\"Norsk bokmål\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.8.3/nb_NO.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"nb\";i:2;s:3:\"nob\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Fortsett\";}}s:5:\"ne_NP\";a:8:{s:8:\"language\";s:5:\"ne_NP\";s:7:\"version\";s:5:\"6.8.3\";s:7:\"updated\";s:19:\"2025-10-14 15:29:10\";s:12:\"english_name\";s:6:\"Nepali\";s:11:\"native_name\";s:18:\"नेपाली\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.8.3/ne_NP.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"ne\";i:2;s:3:\"nep\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:43:\"जारी राख्नुहोस्\";}}s:12:\"nl_NL_formal\";a:8:{s:8:\"language\";s:12:\"nl_NL_formal\";s:7:\"version\";s:5:\"6.8.3\";s:7:\"updated\";s:19:\"2025-09-30 21:41:15\";s:12:\"english_name\";s:14:\"Dutch (Formal)\";s:11:\"native_name\";s:20:\"Nederlands (Formeel)\";s:7:\"package\";s:71:\"https://downloads.wordpress.org/translation/core/6.8.3/nl_NL_formal.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"nl\";i:2;s:3:\"nld\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Doorgaan\";}}s:5:\"nl_NL\";a:8:{s:8:\"language\";s:5:\"nl_NL\";s:7:\"version\";s:5:\"6.8.3\";s:7:\"updated\";s:19:\"2025-10-15 13:45:15\";s:12:\"english_name\";s:5:\"Dutch\";s:11:\"native_name\";s:10:\"Nederlands\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.8.3/nl_NL.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"nl\";i:2;s:3:\"nld\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Doorgaan\";}}s:5:\"nl_BE\";a:8:{s:8:\"language\";s:5:\"nl_BE\";s:7:\"version\";s:5:\"6.8.3\";s:7:\"updated\";s:19:\"2025-10-01 07:26:29\";s:12:\"english_name\";s:15:\"Dutch (Belgium)\";s:11:\"native_name\";s:20:\"Nederlands (België)\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.8.3/nl_BE.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"nl\";i:2;s:3:\"nld\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Doorgaan\";}}s:5:\"nn_NO\";a:8:{s:8:\"language\";s:5:\"nn_NO\";s:7:\"version\";s:8:\"5.8-beta\";s:7:\"updated\";s:19:\"2021-03-18 10:59:16\";s:12:\"english_name\";s:19:\"Norwegian (Nynorsk)\";s:11:\"native_name\";s:13:\"Norsk nynorsk\";s:7:\"package\";s:67:\"https://downloads.wordpress.org/translation/core/5.8-beta/nn_NO.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"nn\";i:2;s:3:\"nno\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Hald fram\";}}s:3:\"oci\";a:8:{s:8:\"language\";s:3:\"oci\";s:7:\"version\";s:6:\"4.8.27\";s:7:\"updated\";s:19:\"2017-08-25 10:03:08\";s:12:\"english_name\";s:7:\"Occitan\";s:11:\"native_name\";s:7:\"Occitan\";s:7:\"package\";s:63:\"https://downloads.wordpress.org/translation/core/4.8.27/oci.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"oc\";i:2;s:3:\"oci\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Contunhar\";}}s:5:\"pa_IN\";a:8:{s:8:\"language\";s:5:\"pa_IN\";s:7:\"version\";s:5:\"4.7.2\";s:7:\"updated\";s:19:\"2017-01-16 05:19:43\";s:12:\"english_name\";s:15:\"Panjabi (India)\";s:11:\"native_name\";s:18:\"ਪੰਜਾਬੀ\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.7.2/pa_IN.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"pa\";i:2;s:3:\"pan\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:25:\"ਜਾਰੀ ਰੱਖੋ\";}}s:5:\"pl_PL\";a:8:{s:8:\"language\";s:5:\"pl_PL\";s:7:\"version\";s:5:\"6.8.3\";s:7:\"updated\";s:19:\"2025-10-03 22:11:25\";s:12:\"english_name\";s:6:\"Polish\";s:11:\"native_name\";s:6:\"Polski\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.8.3/pl_PL.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"pl\";i:2;s:3:\"pol\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Kontynuuj\";}}s:2:\"ps\";a:8:{s:8:\"language\";s:2:\"ps\";s:7:\"version\";s:6:\"4.3.35\";s:7:\"updated\";s:19:\"2015-12-02 21:41:29\";s:12:\"english_name\";s:6:\"Pashto\";s:11:\"native_name\";s:8:\"پښتو\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/4.3.35/ps.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"ps\";i:2;s:3:\"pus\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:19:\"دوام ورکړه\";}}s:5:\"pt_BR\";a:8:{s:8:\"language\";s:5:\"pt_BR\";s:7:\"version\";s:5:\"6.8.3\";s:7:\"updated\";s:19:\"2025-08-30 11:47:36\";s:12:\"english_name\";s:19:\"Portuguese (Brazil)\";s:11:\"native_name\";s:20:\"Português do Brasil\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.8.3/pt_BR.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"pt\";i:2;s:3:\"por\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuar\";}}s:5:\"pt_PT\";a:8:{s:8:\"language\";s:5:\"pt_PT\";s:7:\"version\";s:5:\"6.8.3\";s:7:\"updated\";s:19:\"2025-10-10 08:00:47\";s:12:\"english_name\";s:21:\"Portuguese (Portugal)\";s:11:\"native_name\";s:10:\"Português\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.8.3/pt_PT.zip\";s:3:\"iso\";a:1:{i:1;s:2:\"pt\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuar\";}}s:10:\"pt_PT_ao90\";a:8:{s:8:\"language\";s:10:\"pt_PT_ao90\";s:7:\"version\";s:5:\"6.8.3\";s:7:\"updated\";s:19:\"2025-10-10 08:01:51\";s:12:\"english_name\";s:27:\"Portuguese (Portugal, AO90)\";s:11:\"native_name\";s:17:\"Português (AO90)\";s:7:\"package\";s:69:\"https://downloads.wordpress.org/translation/core/6.8.3/pt_PT_ao90.zip\";s:3:\"iso\";a:1:{i:1;s:2:\"pt\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuar\";}}s:5:\"pt_AO\";a:8:{s:8:\"language\";s:5:\"pt_AO\";s:7:\"version\";s:5:\"6.4.7\";s:7:\"updated\";s:19:\"2023-08-21 12:15:00\";s:12:\"english_name\";s:19:\"Portuguese (Angola)\";s:11:\"native_name\";s:20:\"Português de Angola\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.4.7/pt_AO.zip\";s:3:\"iso\";a:1:{i:1;s:2:\"pt\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuar\";}}s:3:\"rhg\";a:8:{s:8:\"language\";s:3:\"rhg\";s:7:\"version\";s:5:\"4.7.2\";s:7:\"updated\";s:19:\"2016-03-16 13:03:18\";s:12:\"english_name\";s:8:\"Rohingya\";s:11:\"native_name\";s:8:\"Ruáinga\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/4.7.2/rhg.zip\";s:3:\"iso\";a:1:{i:3;s:3:\"rhg\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Continue\";}}s:5:\"ro_RO\";a:8:{s:8:\"language\";s:5:\"ro_RO\";s:7:\"version\";s:5:\"6.8.3\";s:7:\"updated\";s:19:\"2025-10-11 16:31:54\";s:12:\"english_name\";s:8:\"Romanian\";s:11:\"native_name\";s:8:\"Română\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.8.3/ro_RO.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"ro\";i:2;s:3:\"ron\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuă\";}}s:5:\"ru_RU\";a:8:{s:8:\"language\";s:5:\"ru_RU\";s:7:\"version\";s:5:\"6.8.3\";s:7:\"updated\";s:19:\"2025-09-30 19:16:19\";s:12:\"english_name\";s:7:\"Russian\";s:11:\"native_name\";s:14:\"Русский\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.8.3/ru_RU.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"ru\";i:2;s:3:\"rus\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:20:\"Продолжить\";}}s:3:\"sah\";a:8:{s:8:\"language\";s:3:\"sah\";s:7:\"version\";s:5:\"4.7.2\";s:7:\"updated\";s:19:\"2017-01-21 02:06:41\";s:12:\"english_name\";s:5:\"Sakha\";s:11:\"native_name\";s:14:\"Сахалыы\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/4.7.2/sah.zip\";s:3:\"iso\";a:2:{i:2;s:3:\"sah\";i:3;s:3:\"sah\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:12:\"Салҕаа\";}}s:3:\"snd\";a:8:{s:8:\"language\";s:3:\"snd\";s:7:\"version\";s:6:\"5.4.18\";s:7:\"updated\";s:19:\"2020-07-07 01:53:37\";s:12:\"english_name\";s:6:\"Sindhi\";s:11:\"native_name\";s:8:\"سنڌي\";s:7:\"package\";s:63:\"https://downloads.wordpress.org/translation/core/5.4.18/snd.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"sd\";i:2;s:3:\"snd\";i:3;s:3:\"snd\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:15:\"اڳتي هلو\";}}s:5:\"si_LK\";a:8:{s:8:\"language\";s:5:\"si_LK\";s:7:\"version\";s:5:\"4.7.2\";s:7:\"updated\";s:19:\"2016-11-12 06:00:52\";s:12:\"english_name\";s:7:\"Sinhala\";s:11:\"native_name\";s:15:\"සිංහල\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.7.2/si_LK.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"si\";i:2;s:3:\"sin\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:44:\"දිගටම කරගෙන යන්න\";}}s:5:\"sk_SK\";a:8:{s:8:\"language\";s:5:\"sk_SK\";s:7:\"version\";s:5:\"6.8.3\";s:7:\"updated\";s:19:\"2025-10-13 06:23:32\";s:12:\"english_name\";s:6:\"Slovak\";s:11:\"native_name\";s:11:\"Slovenčina\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.8.3/sk_SK.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"sk\";i:2;s:3:\"slk\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:12:\"Pokračovať\";}}s:3:\"skr\";a:8:{s:8:\"language\";s:3:\"skr\";s:7:\"version\";s:5:\"6.8.3\";s:7:\"updated\";s:19:\"2025-04-24 16:58:02\";s:12:\"english_name\";s:7:\"Saraiki\";s:11:\"native_name\";s:14:\"سرائیکی\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/6.8.3/skr.zip\";s:3:\"iso\";a:1:{i:3;s:3:\"skr\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:17:\"جاری رکھو\";}}s:5:\"sl_SI\";a:8:{s:8:\"language\";s:5:\"sl_SI\";s:7:\"version\";s:5:\"6.8.3\";s:7:\"updated\";s:19:\"2025-08-14 09:44:53\";s:12:\"english_name\";s:9:\"Slovenian\";s:11:\"native_name\";s:13:\"Slovenščina\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.8.3/sl_SI.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"sl\";i:2;s:3:\"slv\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Nadaljuj\";}}s:2:\"sq\";a:8:{s:8:\"language\";s:2:\"sq\";s:7:\"version\";s:5:\"6.8.3\";s:7:\"updated\";s:19:\"2025-04-18 09:38:51\";s:12:\"english_name\";s:8:\"Albanian\";s:11:\"native_name\";s:5:\"Shqip\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/6.8.3/sq.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"sq\";i:2;s:3:\"sqi\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:6:\"Vazhdo\";}}s:5:\"sr_RS\";a:8:{s:8:\"language\";s:5:\"sr_RS\";s:7:\"version\";s:5:\"6.8.3\";s:7:\"updated\";s:19:\"2025-10-23 11:49:16\";s:12:\"english_name\";s:7:\"Serbian\";s:11:\"native_name\";s:23:\"Српски језик\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.8.3/sr_RS.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"sr\";i:2;s:3:\"srp\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:14:\"Настави\";}}s:5:\"sv_SE\";a:8:{s:8:\"language\";s:5:\"sv_SE\";s:7:\"version\";s:5:\"6.8.3\";s:7:\"updated\";s:19:\"2025-10-15 10:44:57\";s:12:\"english_name\";s:7:\"Swedish\";s:11:\"native_name\";s:7:\"Svenska\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.8.3/sv_SE.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"sv\";i:2;s:3:\"swe\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Fortsätt\";}}s:2:\"sw\";a:8:{s:8:\"language\";s:2:\"sw\";s:7:\"version\";s:5:\"6.8.3\";s:7:\"updated\";s:19:\"2025-06-28 12:50:48\";s:12:\"english_name\";s:7:\"Swahili\";s:11:\"native_name\";s:9:\"Kiswahili\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/6.8.3/sw.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"sw\";i:2;s:3:\"swa\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:7:\"Endelea\";}}s:3:\"szl\";a:8:{s:8:\"language\";s:3:\"szl\";s:7:\"version\";s:5:\"4.7.2\";s:7:\"updated\";s:19:\"2016-09-24 19:58:14\";s:12:\"english_name\";s:8:\"Silesian\";s:11:\"native_name\";s:17:\"Ślōnskŏ gŏdka\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/4.7.2/szl.zip\";s:3:\"iso\";a:1:{i:3;s:3:\"szl\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:13:\"Kōntynuować\";}}s:5:\"ta_IN\";a:8:{s:8:\"language\";s:5:\"ta_IN\";s:7:\"version\";s:5:\"4.7.2\";s:7:\"updated\";s:19:\"2017-01-27 03:22:47\";s:12:\"english_name\";s:5:\"Tamil\";s:11:\"native_name\";s:15:\"தமிழ்\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.7.2/ta_IN.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"ta\";i:2;s:3:\"tam\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:24:\"தொடரவும்\";}}s:5:\"ta_LK\";a:8:{s:8:\"language\";s:5:\"ta_LK\";s:7:\"version\";s:6:\"4.2.39\";s:7:\"updated\";s:19:\"2015-12-03 01:07:44\";s:12:\"english_name\";s:17:\"Tamil (Sri Lanka)\";s:11:\"native_name\";s:15:\"தமிழ்\";s:7:\"package\";s:65:\"https://downloads.wordpress.org/translation/core/4.2.39/ta_LK.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"ta\";i:2;s:3:\"tam\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:18:\"தொடர்க\";}}s:2:\"te\";a:8:{s:8:\"language\";s:2:\"te\";s:7:\"version\";s:5:\"4.7.2\";s:7:\"updated\";s:19:\"2017-01-26 15:47:39\";s:12:\"english_name\";s:6:\"Telugu\";s:11:\"native_name\";s:18:\"తెలుగు\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/4.7.2/te.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"te\";i:2;s:3:\"tel\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:30:\"కొనసాగించు\";}}s:2:\"th\";a:8:{s:8:\"language\";s:2:\"th\";s:7:\"version\";s:6:\"5.8.12\";s:7:\"updated\";s:19:\"2022-06-08 04:30:30\";s:12:\"english_name\";s:4:\"Thai\";s:11:\"native_name\";s:9:\"ไทย\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/5.8.12/th.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"th\";i:2;s:3:\"tha\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:15:\"ต่อไป\";}}s:2:\"tl\";a:8:{s:8:\"language\";s:2:\"tl\";s:7:\"version\";s:5:\"6.8.3\";s:7:\"updated\";s:19:\"2025-10-10 17:38:55\";s:12:\"english_name\";s:7:\"Tagalog\";s:11:\"native_name\";s:7:\"Tagalog\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/6.8.3/tl.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"tl\";i:2;s:3:\"tgl\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:10:\"Magpatuloy\";}}s:5:\"tr_TR\";a:8:{s:8:\"language\";s:5:\"tr_TR\";s:7:\"version\";s:5:\"6.8.3\";s:7:\"updated\";s:19:\"2025-10-23 11:58:31\";s:12:\"english_name\";s:7:\"Turkish\";s:11:\"native_name\";s:8:\"Türkçe\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.8.3/tr_TR.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"tr\";i:2;s:3:\"tur\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:5:\"Devam\";}}s:5:\"tt_RU\";a:8:{s:8:\"language\";s:5:\"tt_RU\";s:7:\"version\";s:5:\"4.7.2\";s:7:\"updated\";s:19:\"2016-11-20 20:20:50\";s:12:\"english_name\";s:5:\"Tatar\";s:11:\"native_name\";s:19:\"Татар теле\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.7.2/tt_RU.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"tt\";i:2;s:3:\"tat\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:17:\"дәвам итү\";}}s:3:\"tah\";a:8:{s:8:\"language\";s:3:\"tah\";s:7:\"version\";s:5:\"4.7.2\";s:7:\"updated\";s:19:\"2016-03-06 18:39:39\";s:12:\"english_name\";s:8:\"Tahitian\";s:11:\"native_name\";s:10:\"Reo Tahiti\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/4.7.2/tah.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"ty\";i:2;s:3:\"tah\";i:3;s:3:\"tah\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Continue\";}}s:5:\"ug_CN\";a:8:{s:8:\"language\";s:5:\"ug_CN\";s:7:\"version\";s:5:\"6.8.3\";s:7:\"updated\";s:19:\"2025-10-10 20:06:35\";s:12:\"english_name\";s:6:\"Uighur\";s:11:\"native_name\";s:16:\"ئۇيغۇرچە\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.8.3/ug_CN.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"ug\";i:2;s:3:\"uig\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:26:\"داۋاملاشتۇرۇش\";}}s:2:\"uk\";a:8:{s:8:\"language\";s:2:\"uk\";s:7:\"version\";s:3:\"6.8\";s:7:\"updated\";s:19:\"2025-04-18 21:10:00\";s:12:\"english_name\";s:9:\"Ukrainian\";s:11:\"native_name\";s:20:\"Українська\";s:7:\"package\";s:59:\"https://downloads.wordpress.org/translation/core/6.8/uk.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"uk\";i:2;s:3:\"ukr\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:20:\"Продовжити\";}}s:2:\"ur\";a:8:{s:8:\"language\";s:2:\"ur\";s:7:\"version\";s:6:\"5.4.18\";s:7:\"updated\";s:19:\"2020-04-09 11:17:33\";s:12:\"english_name\";s:4:\"Urdu\";s:11:\"native_name\";s:8:\"اردو\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/5.4.18/ur.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"ur\";i:2;s:3:\"urd\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:19:\"جاری رکھیں\";}}s:5:\"uz_UZ\";a:8:{s:8:\"language\";s:5:\"uz_UZ\";s:7:\"version\";s:8:\"5.8-beta\";s:7:\"updated\";s:19:\"2021-02-28 12:02:22\";s:12:\"english_name\";s:5:\"Uzbek\";s:11:\"native_name\";s:11:\"O‘zbekcha\";s:7:\"package\";s:67:\"https://downloads.wordpress.org/translation/core/5.8-beta/uz_UZ.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"uz\";i:2;s:3:\"uzb\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:11:\"Davom etish\";}}s:2:\"vi\";a:8:{s:8:\"language\";s:2:\"vi\";s:7:\"version\";s:5:\"6.8.3\";s:7:\"updated\";s:19:\"2025-09-01 09:12:13\";s:12:\"english_name\";s:10:\"Vietnamese\";s:11:\"native_name\";s:14:\"Tiếng Việt\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/6.8.3/vi.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"vi\";i:2;s:3:\"vie\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:12:\"Tiếp tục\";}}s:5:\"zh_CN\";a:8:{s:8:\"language\";s:5:\"zh_CN\";s:7:\"version\";s:5:\"6.8.3\";s:7:\"updated\";s:19:\"2025-07-29 06:55:14\";s:12:\"english_name\";s:15:\"Chinese (China)\";s:11:\"native_name\";s:12:\"简体中文\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.8.3/zh_CN.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"zh\";i:2;s:3:\"zho\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:6:\"继续\";}}s:5:\"zh_HK\";a:8:{s:8:\"language\";s:5:\"zh_HK\";s:7:\"version\";s:5:\"6.2.8\";s:7:\"updated\";s:19:\"2022-07-15 15:25:03\";s:12:\"english_name\";s:19:\"Chinese (Hong Kong)\";s:11:\"native_name\";s:12:\"香港中文\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.2.8/zh_HK.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"zh\";i:2;s:3:\"zho\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:6:\"繼續\";}}s:5:\"zh_TW\";a:8:{s:8:\"language\";s:5:\"zh_TW\";s:7:\"version\";s:5:\"6.8.3\";s:7:\"updated\";s:19:\"2025-10-01 08:48:55\";s:12:\"english_name\";s:16:\"Chinese (Taiwan)\";s:11:\"native_name\";s:12:\"繁體中文\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.8.3/zh_TW.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"zh\";i:2;s:3:\"zho\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:6:\"繼續\";}}}", "off");
INSERT INTO `inter_options` VALUES("2156", "_site_transient_timeout_community-events-d41d8cd98f00b204e9800998ecf8427e", "1761375896", "off");
INSERT INTO `inter_options` VALUES("2157", "_site_transient_community-events-d41d8cd98f00b204e9800998ecf8427e", "a:4:{s:9:\"sandboxed\";b:0;s:5:\"error\";N;s:8:\"location\";a:1:{s:2:\"ip\";b:0;}s:6:\"events\";a:0:{}}", "off");
INSERT INTO `inter_options` VALUES("2158", "_transient_timeout_feed_0d2db5fea5a8633b56992c916819b198", "1761375897", "off");
INSERT INTO `inter_options` VALUES("2159", "_transient_feed_0d2db5fea5a8633b56992c916819b198", "a:6:{s:5:\"child\";a:1:{s:0:\"\";a:1:{s:3:\"rss\";a:1:{i:0;a:6:{s:4:\"data\";s:3:\"\n\n\n\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:7:\"version\";s:3:\"2.0\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:0:\"\";a:1:{s:7:\"channel\";a:1:{i:0;a:6:{s:4:\"data\";s:52:\"\n	\n	\n	\n	\n	\n	\n	\n	\n	\n\n \n	\n		\n		\n		\n		\n		\n		\n		\n		\n		\n	\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:4:{s:0:\"\";a:8:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:32:\"Blog – WordPress.org Français\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:24:\"https://fr.wordpress.org\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:0:\"\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:13:\"lastBuildDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Fri, 11 Jul 2025 09:26:12 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"language\";a:1:{i:0;a:5:{s:4:\"data\";s:5:\"fr-FR\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:9:\"generator\";a:1:{i:0;a:5:{s:4:\"data\";s:40:\"https://wordpress.org/?v=6.9-beta1-61058\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:5:\"image\";a:1:{i:0;a:6:{s:4:\"data\";s:11:\"\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:0:\"\";a:5:{s:3:\"url\";a:1:{i:0;a:5:{s:4:\"data\";s:29:\"https://s.w.org/favicon.ico?2\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:32:\"Blog – WordPress.org Français\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:24:\"https://fr.wordpress.org\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:5:\"width\";a:1:{i:0;a:5:{s:4:\"data\";s:2:\"32\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:6:\"height\";a:1:{i:0;a:5:{s:4:\"data\";s:2:\"32\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}}s:4:\"item\";a:10:{i:0;a:6:{s:4:\"data\";s:57:\"\n		\n		\n		\n		\n		\n				\n		\n\n					\n										\n					\n		\n		\n			\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:4:{s:0:\"\";a:6:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:80:\"Arrêt des mises à jour de sécurité pour les versions 4.1 à 4.6 de WordPress\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:112:\"https://fr.wordpress.org/2025/07/11/arret-des-mises-a-jour-de-securite-pour-les-versions-4-1-a-4-6-de-wordpress/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Fri, 11 Jul 2025 09:26:12 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:1:{i:0;a:5:{s:4:\"data\";s:9:\"Securité\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:32:\"https://fr.wordpress.org/?p=3375\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:346:\"À compter de mi-juillet 2025, l&#8217;équipe de sécurité de WordPress ne fournira plus de mises à jour de sécurité pour les versions 4.1 à 4.6 de WordPress. Ces versions ont été initialement publiées il y a plus de neuf ans et plus de 99 % des installations WordPress utilisent une version plus récente. La probabilité que [&#8230;]\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:9:\"Jb Audras\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:1368:\"\n<p>À compter de mi-juillet 2025, l&rsquo;équipe de sécurité de WordPress ne fournira plus de mises à jour de sécurité pour les versions 4.1 à 4.6 de WordPress.</p>\n\n\n\n<p>Ces versions ont été initialement publiées il y a plus de neuf ans et plus de 99 % des installations WordPress utilisent une version plus récente. La probabilité que cela affecte votre site est très faible.</p>\n\n\n\n<p>Pour vérifier que votre version de WordPress est à jour, connectez-vous au tableau de bord de votre site. Si votre version n&rsquo;est pas à jour, vous devriez voir un message proposant sa mise à jour. La version que vous utilisez est indiquée dans le widget « D&rsquo;un coup d&rsquo;œil » présent sur le tableau de bord.</p>\n\n\n\n<p>Pour rappel, <strong>la seule version de WordPress activement maintenue est la version majeure la plus récente</strong>. Les correctifs de sécurité ne sont portés vers les anciennes branches que par « courtoisie », les anciennes versions ne faisant pas l&rsquo;objet de corrections autres que de sécurité.</p>\n\n\n\n<p>Le blog « <bdo lang=\"en\" dir=\"ltr\">Make WordPress Security</bdo> » fournit plus de détails sur la <a href=\"https://make.wordpress.org/security/2025/06/18/security-updates-will-cease-for-wordpress-versions-4-1-through-4-6/\">procédure de fin de support de ces versions (en anglais)</a>.</p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:30:\"com-wordpress:feed-additions:1\";a:1:{s:7:\"post-id\";a:1:{i:0;a:5:{s:4:\"data\";s:4:\"3375\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:1;a:6:{s:4:\"data\";s:57:\"\n		\n		\n		\n		\n		\n				\n		\n\n					\n										\n					\n		\n		\n			\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:4:{s:0:\"\";a:6:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:52:\"Rendez-vous à Bâle pour le WordCamp Europe 2025 !\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:84:\"https://fr.wordpress.org/2025/04/28/rendez-vous-a-bale-pour-le-wordcamp-europe-2025/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Mon, 28 Apr 2025 08:39:02 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:1:{i:0;a:5:{s:4:\"data\";s:11:\"Évènement\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:32:\"https://fr.wordpress.org/?p=3362\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:364:\"Le WordCamp Europe 2025 se tiendra du 5 au 7 juin dans la magnifique ville de Bâle, en Suisse. Il réunira les passionné·e·s de WordPress et du logiciel libre, des développeuses et développeurs et des professionnels de notre écosystème provenant de tout le continent et même du monde entier ! Venez découvrir de nouvelles perspectives, engagez [&#8230;]\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:9:\"Jb Audras\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:6355:\"\n<figure class=\"wp-block-image size-large\"><a href=\"https://fr.wordpress.org/files/2025/04/wceu2025-Featured-Image.jpg\"><img fetchpriority=\"high\" decoding=\"async\" width=\"1024\" height=\"538\" src=\"https://fr.wordpress.org/files/2025/04/wceu2025-Featured-Image-1024x538.jpg\" alt=\"\" class=\"wp-image-3363\" srcset=\"https://fr.wordpress.org/files/2025/04/wceu2025-Featured-Image-1024x538.jpg 1024w, https://fr.wordpress.org/files/2025/04/wceu2025-Featured-Image-300x158.jpg 300w, https://fr.wordpress.org/files/2025/04/wceu2025-Featured-Image-768x403.jpg 768w, https://fr.wordpress.org/files/2025/04/wceu2025-Featured-Image-1536x806.jpg 1536w, https://fr.wordpress.org/files/2025/04/wceu2025-Featured-Image.jpg 1800w\" sizes=\"(max-width: 1024px) 100vw, 1024px\" /></a></figure>\n\n\n\n<p>Le WordCamp Europe 2025 se tiendra du 5 au 7 juin dans la magnifique ville de Bâle, en Suisse. Il réunira les passionné·e·s de WordPress et du logiciel libre, des développeuses et développeurs et des professionnels de notre écosystème provenant de tout le continent et même du monde entier !</p>\n\n\n\n<p>Venez découvrir de nouvelles perspectives, engagez des conversations avec les membres de la communauté WordPress, les entreprises et acteurs économiques innovants de notre écosystème au cours de trois jours de conférences, de réseautage et de contribution à WordPress.</p>\n\n\n\n<div class=\"wp-block-group has-off-white-background-color has-background is-layout-constrained wp-container-core-group-is-layout-8503c47b wp-block-group-is-layout-constrained\">\n<div style=\"height:50px\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n\n\n\n<p class=\"has-text-align-center has-large-font-size\"><img src=\"https://s.w.org/images/core/emoji/16.0.1/72x72/1f39f.png\" alt=\"🎟\" class=\"wp-smiley\" style=\"height: 1em; max-height: 1em;\" /> <strong>Les places sont limitées : réservez la vôtre dès aujourd&rsquo;hui !</strong></p>\n\n\n\n<div style=\"height:25px\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n\n\n\n<div class=\"wp-block-buttons is-content-justification-center is-layout-flex wp-container-core-buttons-is-layout-a89b3969 wp-block-buttons-is-layout-flex\">\n<div class=\"wp-block-button\"><a class=\"wp-block-button__link has-text-align-center wp-element-button\" href=\"https://europe.wordcamp.org/2025/tickets/\">Réservez votre place (en anglais)</a></div>\n</div>\n\n\n\n<div style=\"height:50px\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n</div>\n\n\n\n<h2 class=\"wp-block-heading\">Conférences et tables rondes</h2>\n\n\n\n<p>Cet évènement qui se tiendra les 6 et 7 juin 2025 proposera une <a href=\"https://europe.wordcamp.org/2025/schedule/\">série de conférences (en anglais)</a> qui porteront notamment sur des états des lieux de la stratégie des entreprise de l&rsquo;écosystème WordPress, le développement des nouvelles fonctionnalités du CMS, la défense du logiciel libre, l&rsquo;accessibilité, et bien plus encore.</p>\n\n\n\n<p>Pour celles et ceux qui souhaitent perfectionner leurs compétences, les présentations aborderont en profondeur des sujets tels que le SEO pour WordPress, l&rsquo;optimisation des performances, ou encore la conception et la production de sites assistée par l&rsquo;IA.</p>\n\n\n\n<h2 class=\"wp-block-heading\">Séance de questions-réponses avec la direction du projet WordPress</h2>\n\n\n\n<p>Vous pourrez retrouver Mary Hubbard, directrice exécutive du projet WordPress, et Matt Mullenweg, co-fondateur de WordPress le 7 juin pour discuter de WordPress et de sa communauté.</p>\n\n\n\n<h2 class=\"wp-block-heading\">Découvrez Bâle</h2>\n\n\n\n<p>Bâle est la troisième plus grande ville de Suisse. Elle est <a href=\"https://europe.wordcamp.org/2025/location/\">remplie de monuments historiques et culturels à découvrir (en anglais)</a>. Vous pouvez vous déplacer à Bâle et en faire l&rsquo;expérience par vous-même grâce à votre «&nbsp;<bdo lang=\"en\" dir=\"ltr\">BaselCard</bdo>&nbsp;», qui vous permet de monter dans tous les transports en commun de la ville. L&rsquo;équipe d&rsquo;organisation du WordCamp vous recommande fortement d’en profiter pour vous promener le long du Rhin&nbsp;!</p>\n\n\n\n<p><img src=\"https://s.w.org/images/core/emoji/16.0.1/72x72/1f6cf.png\" alt=\"🛏\" class=\"wp-smiley\" style=\"height: 1em; max-height: 1em;\" /><a href=\"https://europe.wordcamp.org/2025/location/accommodation/\"> Trouver des logements à Bâle (en anglais)<br></a><img src=\"https://s.w.org/images/core/emoji/16.0.1/72x72/1f68c.png\" alt=\"🚌\" class=\"wp-smiley\" style=\"height: 1em; max-height: 1em;\" /><a href=\"https://europe.wordcamp.org/2025/location/getting-around-in-basel/\"> En savoir plus sur la « <bdo lang=\"en\" dir=\"ltr\">BaselCard</bdo> » (en anglais)</a><br><img src=\"https://s.w.org/images/core/emoji/16.0.1/72x72/1f4c5.png\" alt=\"📅\" class=\"wp-smiley\" style=\"height: 1em; max-height: 1em;\" /> <strong>Organisez votre WordCamp Europe !</strong> Découvrez le <a href=\"https://europe.wordcamp.org/2025/schedule/\">programme complet (en anglais)</a> et organisez votre séjour à Bâle !<br><img src=\"https://s.w.org/images/core/emoji/16.0.1/72x72/1f39f.png\" alt=\"🎟\" class=\"wp-smiley\" style=\"height: 1em; max-height: 1em;\" /> <strong>Assurez-vous de réserver votre <a href=\"https://europe.wordcamp.org/2025/tickets/\">ticket pour le WordCamp Europe 2025</a></strong> si vous ne l&rsquo;avez pas déjà fait !</p>\n\n\n\n<p>Suivez l&rsquo;actualité du WordCamp Europe sur <a href=\"https://bsky.app/profile/wordpress.org\">Bluesky</a>, <a href=\"https://instagram.com/wordpress/\">Instagram</a>, <a href=\"https://www.facebook.com/WordPress\">Facebook</a>, <a href=\"https://www.linkedin.com/company/wordpress/\">LinkedIn</a>, <a href=\"https://www.threads.net/@wordpress\">Threads</a>, <a href=\"https://mastodon.world/@wordpress\">Mastodon</a>  et <a href=\"https://twitter.com/WordPress\">X/Twitter</a> pour avoir des nouvelles en temps réel&nbsp;!</p>\n\n\n\n<p>N&rsquo;hésitez pas à relayer le message sur vos réseaux sociaux favoris : que vous soyez là le jour-J à Bâle ou que vous nous suiviez en ligne, partagez vos expériences avec les mots-dièse #WCEU et #WordPress sur tous les réseaux sociaux !</p>\n\n\n\n<p>Rendez-vous à Bâle pour le WordCamp Europe 2025&nbsp;! <img src=\"https://s.w.org/images/core/emoji/16.0.1/72x72/1f1e8-1f1ed.png\" alt=\"🇨🇭\" class=\"wp-smiley\" style=\"height: 1em; max-height: 1em;\" /></p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:30:\"com-wordpress:feed-additions:1\";a:1:{s:7:\"post-id\";a:1:{i:0;a:5:{s:4:\"data\";s:4:\"3362\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:2;a:6:{s:4:\"data\";s:57:\"\n		\n		\n		\n		\n		\n				\n		\n\n					\n										\n					\n		\n		\n			\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:4:{s:0:\"\";a:6:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:27:\"WordPress 6.8 « Cecil »\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:56:\"https://fr.wordpress.org/2025/04/15/wordpress-6-8-cecil/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Tue, 15 Apr 2025 17:02:09 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Nouvelles versions de WordPress\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:32:\"https://fr.wordpress.org/?p=3335\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:390:\"Chaque version de WordPress célèbre un ou une artiste ayant posé son empreinte sur le monde de la musique. WordPress 6.8 «&#160;Cecil&#160;» rend hommage au légendaire pianiste et pionnier du jazz Cecil Taylor. De formation classique mais résolument anticonformiste, Cecil Taylor a ré-imaginé le piano comme un instrument de percussion, superposant les sons, explorant la [&#8230;]\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:9:\"Jb Audras\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:80522:\"\n<figure class=\"wp-block-image size-large\"><a href=\"https://fr.wordpress.org/files/2025/04/WordPress-6-8-Cecil.png\"><img decoding=\"async\" width=\"1024\" height=\"535\" src=\"https://fr.wordpress.org/files/2025/04/WordPress-6-8-Cecil-1024x535.png\" alt=\"\" class=\"wp-image-3338\" srcset=\"https://fr.wordpress.org/files/2025/04/WordPress-6-8-Cecil-1024x535.png 1024w, https://fr.wordpress.org/files/2025/04/WordPress-6-8-Cecil-300x157.png 300w, https://fr.wordpress.org/files/2025/04/WordPress-6-8-Cecil-768x401.png 768w, https://fr.wordpress.org/files/2025/04/WordPress-6-8-Cecil-1536x803.png 1536w, https://fr.wordpress.org/files/2025/04/WordPress-6-8-Cecil.png 2048w\" sizes=\"(max-width: 1024px) 100vw, 1024px\" /></a></figure>\n\n\n\n<p>Chaque version de WordPress célèbre un ou une artiste ayant posé son empreinte sur le monde de la musique. WordPress 6.8 «&nbsp;Cecil&nbsp;» rend hommage au légendaire pianiste et pionnier du jazz Cecil Taylor.</p>\n\n\n\n<p>De formation classique mais résolument anticonformiste, Cecil Taylor a ré-imaginé le piano comme un instrument de percussion, superposant les sons, explorant la polyphonie et associant différents rythmes pour créer un son à la fois chaotique et précis. Sa musique a été révolutionnaire, formant de l&rsquo;ordre dans le désordre et de l&rsquo;harmonie dans la dissonance.</p>\n\n\n\n<p>Cet esprit anime WordPress 6.8. Adoptez ses nouvelles fonctionnalités audacieuses avec la même curiosité et la même expérimentation qui ont défini la création musicale de Cecil.</p>\n\n\n\n<h2 class=\"wp-block-heading\">Bienvenue sur WordPress&nbsp;6.8&nbsp;!</h2>\n\n\n\n<p>WordPress 6.8 peaufine et optimise les outils que vous utilisez au quotidien, ce qui rend votre site plus rapide, plus sécurisé et plus facile à gérer. Le guide de styles propose désormais une mise en page structurée et fonctionne avec les thèmes classiques, vous offrant ainsi un meilleur contrôle sur les styles globaux. Le chargement spéculatif accélère la navigation en préchargeant les liens avant même que les internautes n&rsquo;y accèdent, tandis que le hachage <code>bcrypt</code> renforce automatiquement la sécurité des mots de passe. En coulisses, les optimisations de la base de données améliorent les performances, et un nouveau système d&rsquo;alerte de sécurité permet de prévenir les vulnérabilités avant qu&rsquo;elles ne deviennent problématiques.</p>\n\n\n\n<div class=\"wp-block-buttons is-layout-flex wp-block-buttons-is-layout-flex\">\n<div class=\"wp-block-button\"><a class=\"wp-block-button__link wp-element-button\" href=\"https://fr.wordpress.org/latest-fr_FR.zip\">Télécharger WordPress 6.8 «&nbsp;Cecil&nbsp;» en français (ZIP – 20 Mo)</a></div>\n</div>\n\n\n\n<h2 class=\"wp-block-heading\">Une version peaufinée à la perfection</h2>\n\n\n\n<p>WordPress 6.8 améliore et affine les outils que vous utilisez tous les jours, rendant votre site plus rapide, plus sûr et plus facile à gérer.</p>\n\n\n\n<p>Le guide de styles a maintenant une mise en page structurée et fonctionne désormais avec les thèmes classiques, ce qui vous apporte plus de contrôle sur les styles globaux de votre site.</p>\n\n\n\n<p>Le chargement spéculatif accélère la navigation en préchargeant les liens avant que les internautes ne naviguent vers ceux-ci, tandis que le hachage via bcrypt renforce automatiquement la sécurité des mots de passe.</p>\n\n\n\n<p>Parallèlement, des optimisations de la base de données améliorent les performances, et un nouveau système d’avertissement de sécurité aide à prévenir les vulnérabilités avant qu’elles ne deviennent un problème.</p>\n\n\n\n<h3 class=\"wp-block-heading\">Le guide de style fait peau neuve et s’enrichit de quelques nouvelles fonctionnalités</h3>\n\n\n\n<p>Le guide de styles présente une nouvelle mise en page structurée et des libellés plus clairs, pour faciliter encore plus la modification des couleurs, de la typographie et de presque tous les styles de votre site, en un seul endroit.</p>\n\n\n\n<figure class=\"wp-block-image size-medium\"><a href=\"https://fr.wordpress.org/files/2025/04/feature-01.png\"><img decoding=\"async\" width=\"300\" height=\"300\" src=\"https://fr.wordpress.org/files/2025/04/feature-01-300x300.png\" alt=\"\" class=\"wp-image-3339\" srcset=\"https://fr.wordpress.org/files/2025/04/feature-01-300x300.png 300w, https://fr.wordpress.org/files/2025/04/feature-01-150x150.png 150w, https://fr.wordpress.org/files/2025/04/feature-01-768x768.png 768w, https://fr.wordpress.org/files/2025/04/feature-01.png 900w\" sizes=\"(max-width: 300px) 100vw, 300px\" /></a></figure>\n\n\n\n<h3 class=\"wp-block-heading\">Amélioration de l’éditeur</h3>\n\n\n\n<p>Visualisez plus facilement vos options dans les vues de données et excluez les publications épinglées de la boucle de requête. De plus, l’éditeur propose de nombreuses améliorations qui simplifient la création de contenu.</p>\n\n\n\n<figure class=\"wp-block-image size-medium\"><a href=\"https://fr.wordpress.org/files/2025/04/feature-02.png\"><img loading=\"lazy\" decoding=\"async\" width=\"300\" height=\"300\" src=\"https://fr.wordpress.org/files/2025/04/feature-02-300x300.png\" alt=\"\" class=\"wp-image-3340\" srcset=\"https://fr.wordpress.org/files/2025/04/feature-02-300x300.png 300w, https://fr.wordpress.org/files/2025/04/feature-02-150x150.png 150w, https://fr.wordpress.org/files/2025/04/feature-02-768x768.png 768w, https://fr.wordpress.org/files/2025/04/feature-02.png 900w\" sizes=\"auto, (max-width: 300px) 100vw, 300px\" /></a></figure>\n\n\n\n<h3 class=\"wp-block-heading\">Chargement quasi instantané des pages, grâce au chargement spéculatif</h3>\n\n\n\n<p>Dans WordPress 6.8, les pages se chargent plus rapidement que jamais. Lorsque vous ou tout internaute survolez ou cliquez sur un lien, WordPress peut précharger la page suivante pour une expérience plus fluide et quasi instantanée. Le système équilibre vitesse et efficacité, et vous pouvez contrôler son fonctionnement avec une extension ou votre propre code. Cette fonctionnalité fonctionne uniquement dans les navigateurs modernes&nbsp;; les anciens l’ignoreront simplement sans aucun impact.</p>\n\n\n\n<figure class=\"wp-block-image size-medium\"><a href=\"https://fr.wordpress.org/files/2025/04/feature-03.png\"><img loading=\"lazy\" decoding=\"async\" width=\"300\" height=\"300\" src=\"https://fr.wordpress.org/files/2025/04/feature-03-300x300.png\" alt=\"\" class=\"wp-image-3341\" srcset=\"https://fr.wordpress.org/files/2025/04/feature-03-300x300.png 300w, https://fr.wordpress.org/files/2025/04/feature-03-150x150.png 150w, https://fr.wordpress.org/files/2025/04/feature-03-768x768.png 768w, https://fr.wordpress.org/files/2025/04/feature-03.png 900w\" sizes=\"auto, (max-width: 300px) 100vw, 300px\" /></a></figure>\n\n\n\n<h3 class=\"wp-block-heading\">Sécurité renforcée des mots de passe avec bcrypt</h3>\n\n\n\n<p>Les mots de passe sont désormais plus difficiles à déchiffrer grâce au hachage bcrypt, qui nécessite beaucoup plus de puissance de calcul pour être cassé. Cela renforce la sécurité globale, tout comme d‘autres améliorations de chiffrement dans WordPress. Vous n’avez rien à faire&nbsp;: tout se met à jour automatiquement.</p>\n\n\n\n<figure class=\"wp-block-image size-medium\"><a href=\"https://fr.wordpress.org/files/2025/04/feature-04.png\"><img loading=\"lazy\" decoding=\"async\" width=\"300\" height=\"300\" src=\"https://fr.wordpress.org/files/2025/04/feature-04-300x300.png\" alt=\"\" class=\"wp-image-3342\" srcset=\"https://fr.wordpress.org/files/2025/04/feature-04-300x300.png 300w, https://fr.wordpress.org/files/2025/04/feature-04-150x150.png 150w, https://fr.wordpress.org/files/2025/04/feature-04-768x768.png 768w, https://fr.wordpress.org/files/2025/04/feature-04.png 900w\" sizes=\"auto, (max-width: 300px) 100vw, 300px\" /></a></figure>\n\n\n\n<h3 class=\"wp-block-heading\">Améliorations de l’accessibilité</h3>\n\n\n\n<p>Plus de 100 correctifs et améliorations en matière d’accessibilité touchent un large champ de l’expérience WordPress. Cette version inclut des correctifs pour chaque thème natif, des améliorations de la gestion des menus de navigation, de l’outil de personnalisation, et un étiquetage simplifié. L’éditeur de blocs bénéficie de plus de 70 améliorations concernant les blocs, les vues de données, et l’expérience globale des utilisateurs et utilisatrices.</p>\n\n\n\n<h3 class=\"wp-block-heading\">Allégement de la base de données</h3>\n\n\n\n<p>Le travail se poursuit sur l‘optimisation de la génération des clés de cache dans la classe&nbsp;<code>WP_Query</code>. L‘objectif est, comme toujours, d‘améliorer les performances de votre site, dans ce cas en réduisant davantage la charge de votre base de données. Cela est particulièrement utile si vous avez beaucoup de trafic.</p>\n\n\n\n<h3 class=\"wp-block-heading\">Améliorations des performances</h3>\n\n\n\n<p>WordPress&nbsp;6.8 propose de nombreuses corrections et améliorations de performances pour accélérer l’ensemble de votre site, de l’administration aux temps de chargement ressentis par les personnes qui visitent votre site. Au-delà du chargement spéculatif désormais intégré nativement, WordPress&nbsp;6.8 accorde une attention particulière à l’éditeur de blocs, à l’enregistrement des types de blocs et à la mise en cache des requêtes. N’attendez jamais plus de 50&nbsp;millisecondes entre chaque interaction. Dans WordPress&nbsp;6.8, l’API de gestion de l’interactivité constitue un premier pas vers cet objectif.</p>\n\n\n\n<h2 class=\"wp-block-heading\">En savoir plus sur WordPress 6.8</h2>\n\n\n\n<p>Pour une vision complète de toutes les nouvelles fonctionnalités et améliorations de WordPress 6.8, vous pouvez <a href=\"https://wordpress.org/download/releases/6-8/\">consulter le site de démonstration des fonctionnalités (en anglais)</a>.</p>\n\n\n\n<p><a href=\"https://learn.wordpress.org/\"><em><bdo lang=\"en\" dir=\"ltr\">Learn WordPress</bdo></em></a>&nbsp;est une ressource gratuite pour les personnes qui utilisent WordPress, qu’elles soient débutantes ou expérimentées.&nbsp;<em><bdo lang=\"en\" dir=\"ltr\">Learn</bdo></em>&nbsp;contient des vidéos pratiques sur l’utilisation de diverses fonctionnalités de WordPress, des&nbsp;évènements interactifs&nbsp;pour explorer des sujets en profondeur, et des plans de cours pour approfondir des domaines spécifiques de WordPress.</p>\n\n\n\n<h4 class=\"wp-block-heading\">Notes de version de WordPress 6.8</h4>\n\n\n\n<p><a href=\"https://wordpress.org/support/wordpress-version/version-6-8/\">Lisez les notes de version de WordPress 6.8</a> pour obtenir des informations sur l’installation, les améliorations, les problèmes corrigés, les contributeurs et contributrices de la version, les ressources d’apprentissage et la liste des modifications apportées aux fichiers.</p>\n\n\n\n<h4 class=\"wp-block-heading\">Guide technique de WordPress 6.8 en français</h4>\n\n\n\n<p><a href=\"https://fr.wordpress.org/2024/10/28/guide-des-changements-techniques-de-wordpress-6-7/\">Explorez le guide des changements techniques de WordPress 6.8</a>. Découvrez les changements de cette version avec les notes détaillées des développeurs et développeuses qui vous permettent de construire votre site avec WordPress.</p>\n\n\n\n<h2 class=\"wp-block-heading\">L’équipe de direction de WordPress&nbsp;6.8</h2>\n\n\n\n<p>Voici l’équipe qui a coordonné le développement et la sortie de cette nouvelle version de WordPress&nbsp;:</p>\n\n\n\n<ul class=\"wp-block-list\">\n<li>Direction générale :&nbsp;<a href=\"https://profiles.wordpress.org/matt/\">Matt Mullenweg</a></li>\n\n\n\n<li>Coordination de la version :&nbsp;<a href=\"https://profiles.wordpress.org/jeffpaul/\">Jeffrey Paul</a>&nbsp;and&nbsp;<a href=\"https://profiles.wordpress.org/michelleames/\">Michelle Frechette</a></li>\n\n\n\n<li>Direction technique :&nbsp;<a href=\"https://profiles.wordpress.org/joemcgill/\">Joe McGill</a>,&nbsp;<a href=\"https://profiles.wordpress.org/desrosj/\">Jonathan Desrosiers</a>, and&nbsp;<a href=\"https://profiles.wordpress.org/mamaduka/\">George Mamadashvili</a></li>\n\n\n\n<li>Gestion de projet :&nbsp;<a href=\"https://profiles.wordpress.org/audrasjb/\">Jb Audras</a></li>\n\n\n\n<li>Direction artistique :&nbsp;<a href=\"https://profiles.wordpress.org/karmatosed/\">Tammie Lister</a></li>\n\n\n\n<li>Responsable des performances :&nbsp;<a href=\"https://profiles.wordpress.org/flixos90/\">Felix Arntz</a></li>\n\n\n\n<li>Direction des tests :&nbsp;<a href=\"https://profiles.wordpress.org/krupajnanda/\">Krupa Nanda</a></li>\n</ul>\n\n\n\n<h2 class=\"wp-block-heading\">Merci aux contributeurs et contributrices</h2>\n\n\n\n<p>WordPress 6.8 n’aurait pas pu sortir sans la contribution passionnée de plus de&nbsp;<strong>900 personnes provenant de près de 70 pays différents</strong>.</p>\n\n\n\n<p>Un remerciement tout spécial pour les plus de 250 personnes qui ont contribué au cœur de WordPress pour la première fois avec WP&nbsp;6.8 <img src=\"https://s.w.org/images/core/emoji/16.0.1/72x72/2665.png\" alt=\"♥\" class=\"wp-smiley\" style=\"height: 1em; max-height: 1em;\" /></p>\n\n\n\n<div class=\"wp-block-group alignwide is-style-default is-content-justification-left is-nowrap is-layout-flex wp-container-core-group-is-layout-fc9f69e7 wp-block-group-is-layout-flex\">\n<p class=\"has-dark-blueberry-color has-lemon-3-background-color has-text-color has-background has-link-color has-extra-small-font-size wp-elements-70a077000b3aff2481eb0decd1e70b5e\"><a href=\"https://profiles.wordpress.org/jorbin/\">Aaron Jorbin</a> · <a href=\"https://profiles.wordpress.org/aaronrobertshaw/\">Aaron Robertshaw</a> · <a href=\"https://profiles.wordpress.org/thehercules/\">Aashish Sharma</a> · <a href=\"https://profiles.wordpress.org/webcommsat/\">Abha Thakor</a> · <a href=\"https://profiles.wordpress.org/hiabhaykulkarni/\">Abhay Kulkarni</a> · <a href=\"https://profiles.wordpress.org/abhi3315/\">abhi3315</a> · <a href=\"https://profiles.wordpress.org/adakaleh/\">AdaKaleh</a> · <a href=\"https://profiles.wordpress.org/adamsilverstein/\">Adam Silverstein</a> · <a href=\"https://profiles.wordpress.org/zieladam/\">Adam Zieliński</a> · <a href=\"https://profiles.wordpress.org/adhun/\">Adhun Anand</a> · <a href=\"https://profiles.wordpress.org/adityab98/\">Aditya Bansode</a> · <a href=\"https://profiles.wordpress.org/stromhalm/\">Adrian Jagusch</a> · <a href=\"https://profiles.wordpress.org/aduth/\">aduth</a> · <a href=\"https://profiles.wordpress.org/hemant-ahir/\">Ahir Hemant</a> · <a href=\"https://profiles.wordpress.org/ahmarzaidi/\">Ahmar Zaidi</a> · <a href=\"https://profiles.wordpress.org/chaion07/\">Ahmed Kabir Chaion</a> · <a href=\"https://profiles.wordpress.org/engahmeds3ed/\">Ahmed Saeed</a> · <a href=\"https://profiles.wordpress.org/ahsankhan316/\">Ahsan Khan</a> · <a href=\"https://profiles.wordpress.org/aishwarryapande/\">Aishwarrya Pande</a> · <a href=\"https://profiles.wordpress.org/ajayghaghretiya1/\">Ajay Ghaghretiya</a> · <a href=\"https://profiles.wordpress.org/ajmaurya/\">Ajay Maurya</a> · <a href=\"https://profiles.wordpress.org/ajitbohra/\">Ajit Bohra</a> · <a href=\"https://profiles.wordpress.org/akanshusingh/\">Akanshu Singh</a> · <a href=\"https://profiles.wordpress.org/wildworks/\">Aki Hamano</a> · <a href=\"https://profiles.wordpress.org/atachibana/\">Akira Tachibana</a> · <a href=\"https://profiles.wordpress.org/aks30498/\">aks30498</a> · <a href=\"https://profiles.wordpress.org/akshat2802/\">Akshat Kakkad</a> · <a href=\"https://profiles.wordpress.org/akshaydhere/\">Akshay Dhere</a> · <a href=\"https://profiles.wordpress.org/aljullu/\">Albert Juhé Lluveras</a> · <a href=\"https://profiles.wordpress.org/ralessio/\">Alessio</a> · <a href=\"https://profiles.wordpress.org/xknown/\">Alex Concha</a> · <a href=\"https://profiles.wordpress.org/alexflorisca/\">Alex Florisca</a> · <a href=\"https://profiles.wordpress.org/ajlende/\">Alex Lende</a> · <a href=\"https://profiles.wordpress.org/alexstine/\">Alex Stine</a> · <a href=\"https://profiles.wordpress.org/albigdd/\">Alexander Bigga</a> · <a href=\"https://profiles.wordpress.org/alexandrebuffet/\">Alexandre Buffet</a> · <a href=\"https://profiles.wordpress.org/alexus450/\">Alexei Samarschi</a> · <a href=\"https://profiles.wordpress.org/alexschmitz/\">alexschmitz</a> · <a href=\"https://profiles.wordpress.org/alireyad/\">Ali Akbar Reyad</a> · <a href=\"https://profiles.wordpress.org/firewatch/\">allilevine</a> · <a href=\"https://profiles.wordpress.org/alpipego/\">alpipego</a> · <a href=\"https://profiles.wordpress.org/mrfoxtalbot/\">Alvaro Gómez</a> · <a href=\"https://profiles.wordpress.org/akrocks/\">Amaan Khan</a> · <a href=\"https://profiles.wordpress.org/alh0319/\">Amber Hinds</a> · <a href=\"https://profiles.wordpress.org/amimulihsanmahdi/\">Amimul Ihsan</a> · <a href=\"https://profiles.wordpress.org/amin7/\">Amin</a> · <a href=\"https://profiles.wordpress.org/amitbhosale/\">Amit Bhosale</a> · <a href=\"https://profiles.wordpress.org/amitraj2203/\">Amit Raj</a> · <a href=\"https://profiles.wordpress.org/ammarmassoud/\">Ammar Mohamed Fath Allah Abd-Elaaty Massoud</a> · <a href=\"https://profiles.wordpress.org/amolebonde/\">amolebonde</a> · <a href=\"https://profiles.wordpress.org/anandraj346/\">Anand Raj</a> · <a href=\"https://profiles.wordpress.org/anlino/\">Anders Norén</a> · <a href=\"https://profiles.wordpress.org/afercia/\">Andrea Fercia</a> · <a href=\"https://profiles.wordpress.org/awetz583/\">Andrea Roenning</a> · <a href=\"https://profiles.wordpress.org/bowedk/\">Andreas Pedersen</a> · <a href=\"https://profiles.wordpress.org/andraganescu/\">Andrei Draganescu</a> · <a href=\"https://profiles.wordpress.org/euthelup/\">Andrei Lupu</a> · <a href=\"https://profiles.wordpress.org/nacin/\">Andrew Nacin</a> · <a href=\"https://profiles.wordpress.org/azaozz/\">Andrew Ozz</a> · <a href=\"https://profiles.wordpress.org/andrewserong/\">Andrew Serong</a> · <a href=\"https://profiles.wordpress.org/andrewssanya/\">Andrew Ssanya</a> · <a href=\"https://profiles.wordpress.org/rarst/\">Andrey “Rarst” Savchenko</a> · <a href=\"https://profiles.wordpress.org/oandregal/\">André Maneiro</a> · <a href=\"https://profiles.wordpress.org/afragen/\">Andy Fragen</a> · <a href=\"https://profiles.wordpress.org/rilwis/\">Anh Tran</a> · <a href=\"https://profiles.wordpress.org/wpgurudev/\">Ankit Gade</a> · <a href=\"https://profiles.wordpress.org/ankit-k-gupta/\">Ankit K Gupta</a> · <a href=\"https://profiles.wordpress.org/ankitkumarshah/\">Ankit Kumar Shah</a> · <a href=\"https://profiles.wordpress.org/ankitmaru/\">Ankit Panchal</a> · <a href=\"https://profiles.wordpress.org/ankitpatel1578/\">Ankit Patel</a> · <a href=\"https://profiles.wordpress.org/anmolverma404/\">Anmol Verma</a> · <a href=\"https://profiles.wordpress.org/annchichi/\">annchichi</a> · <a href=\"https://profiles.wordpress.org/annebovelett/\">Anne-Mieke Bovelett</a> · <a href=\"https://profiles.wordpress.org/annezazu/\">annezazu</a> · <a href=\"https://profiles.wordpress.org/antpb/\">Anthony Burchell</a> · <a href=\"https://profiles.wordpress.org/ahortin/\">Anthony Hortin</a> · <a href=\"https://profiles.wordpress.org/antonvlasenko/\">Anton Vlasenko</a> · <a href=\"https://profiles.wordpress.org/anujrathore24/\">Anuj Singh</a> · <a href=\"https://profiles.wordpress.org/anveshika/\">Anveshika Srivastava</a> · <a href=\"https://profiles.wordpress.org/aristath/\">Ari Stathopoulos</a> · <a href=\"https://profiles.wordpress.org/arielmaidana/\">Ariel Maidana</a> · <a href=\"https://profiles.wordpress.org/arnaudbroes/\">arnaudbroes</a> · <a href=\"https://profiles.wordpress.org/arnoutblueshell/\">arnoutblueshell</a> · <a href=\"https://profiles.wordpress.org/artemiosans/\">Artemio Morales</a> · <a href=\"https://profiles.wordpress.org/mohonchandra/\">Asish Chandra Mohon</a> · <a href=\"https://profiles.wordpress.org/auareyou/\">Au</a> · <a href=\"https://profiles.wordpress.org/autotutorial/\">autotutorial</a> · <a href=\"https://profiles.wordpress.org/ayeshrajans/\">Ayesh Karunaratne</a> · <a href=\"https://profiles.wordpress.org/beryldlg/\">Béryl de La Grandière</a> · <a href=\"https://profiles.wordpress.org/neo2k23/\">BackuPs</a> · <a href=\"https://profiles.wordpress.org/balub/\">Balu B</a> · <a href=\"https://profiles.wordpress.org/barry/\">Barry</a> · <a href=\"https://profiles.wordpress.org/beafialho/\">Beatriz Fialho</a> · <a href=\"https://profiles.wordpress.org/benharri/\">ben</a> · <a href=\"https://profiles.wordpress.org/scruffian/\">Ben Dwyer</a> · <a href=\"https://profiles.wordpress.org/bsutcliffe/\">Ben Sutcliffe</a> · <a href=\"https://profiles.wordpress.org/benazeer/\">Benazeer</a> · <a href=\"https://profiles.wordpress.org/benniledl/\">Benedikt Ledl</a> · <a href=\"https://profiles.wordpress.org/benjamin_zekavica/\">Benjamin Zekavica</a> · <a href=\"https://profiles.wordpress.org/benoitchantre/\">Benoit Chantre</a> · <a href=\"https://profiles.wordpress.org/bernhard-reiter/\">bernhard-reiter</a> · <a href=\"https://profiles.wordpress.org/berislavgrgicak/\">Bero</a> · <a href=\"https://profiles.wordpress.org/bgermann/\">bgermann</a> · <a href=\"https://profiles.wordpress.org/albatross10/\">Bhavik Kalpesh</a> · <a href=\"https://profiles.wordpress.org/bijit027/\">Bijit Deb</a> · <a href=\"https://profiles.wordpress.org/birgire/\">Birgir Erlendsson (birgire)</a> · <a href=\"https://profiles.wordpress.org/bph/\">Birgit Pauli-Haack</a> · <a href=\"https://profiles.wordpress.org/rainynewt/\">Bishal Shrestha</a> · <a href=\"https://profiles.wordpress.org/bjornw/\">BjornW</a> · <a href=\"https://profiles.wordpress.org/bluantinoo/\">bluantinoo</a> · <a href=\"https://profiles.wordpress.org/bogdanungureanu/\">BogdanUngureanu</a> · <a href=\"https://profiles.wordpress.org/bor0/\">Boro Sitnikovski</a> · <a href=\"https://profiles.wordpress.org/veryard/\">Brad</a> · <a href=\"https://profiles.wordpress.org/bjorsch/\">Brad Jorsch</a> · <a href=\"https://profiles.wordpress.org/bradleyt/\">Bradley Taylor</a> · <a href=\"https://profiles.wordpress.org/bhubbard/\">Brandon Hubbard</a> · <a href=\"https://profiles.wordpress.org/bpayton/\">Brandon Payton</a> · <a href=\"https://profiles.wordpress.org/brettsmason/\">brettsmason</a> · <a href=\"https://profiles.wordpress.org/brevilo/\">brevilo</a> · <a href=\"https://profiles.wordpress.org/ironprogrammer/\">Brian Alexander</a> · <a href=\"https://profiles.wordpress.org/bacoords/\">Brian Coords</a> · <a href=\"https://profiles.wordpress.org/masteradhoc/\">Brian Haas</a> · <a href=\"https://profiles.wordpress.org/bronsonquick/\">Bronson Quick</a> · <a href=\"https://profiles.wordpress.org/bschneidewind/\">Bryan Schneidewind</a> · <a href=\"https://profiles.wordpress.org/burakkaptan/\">burak</a> · <a href=\"https://profiles.wordpress.org/burnuser/\">burnuser</a> · <a href=\"https://profiles.wordpress.org/snicco/\">Calvin Alkan</a> · <a href=\"https://profiles.wordpress.org/calvinalkan/\">Calvin Alkan</a> · <a href=\"https://profiles.wordpress.org/cbravobernal/\">Carlos Bravo</a> · <a href=\"https://profiles.wordpress.org/poena/\">Carolina Nymark</a> · <a href=\"https://profiles.wordpress.org/cbirdsong/\">cbirdsong</a> · <a href=\"https://profiles.wordpress.org/cgastrell/\">cgastrell</a> · <a href=\"https://profiles.wordpress.org/charleslf/\">charleslf</a> · <a href=\"https://profiles.wordpress.org/mel_cha/\">chiilog (Chiaki Okamoto)</a> · <a href=\"https://profiles.wordpress.org/chintanmachhi207/\">chintanmachhi207</a> · <a href=\"https://profiles.wordpress.org/chrico/\">ChriCo</a> · <a href=\"https://profiles.wordpress.org/chriscct7/\">chriscct7</a> · <a href=\"https://profiles.wordpress.org/chrisdotdotdot/\">chrisdotdotdot</a> · <a href=\"https://profiles.wordpress.org/apermo/\">Christoph Daum</a> · <a href=\"https://profiles.wordpress.org/claimableperch/\">claimableperch</a> · <a href=\"https://profiles.wordpress.org/claudiulodro/\">Claudiu Lodromanean</a> · <a href=\"https://profiles.wordpress.org/codebymikey/\">codebymikey</a> · <a href=\"https://profiles.wordpress.org/codersantosh/\">codersantosh</a> · <a href=\"https://profiles.wordpress.org/costdev/\">Colin Stewart</a> · <a href=\"https://profiles.wordpress.org/colind/\">ColinD</a> · <a href=\"https://profiles.wordpress.org/colinleroy/\">colinleroy</a> · <a href=\"https://profiles.wordpress.org/coreyw/\">Corey Worrell</a> · <a href=\"https://profiles.wordpress.org/courane01/\">Courtney Robertson</a> · <a href=\"https://profiles.wordpress.org/cbusquets1989/\">Cris Busquets</a> · <a href=\"https://profiles.wordpress.org/mitogh/\">Crisoforo Gaspar</a> · <a href=\"https://profiles.wordpress.org/ctienshi/\">ctienshi</a> · <a href=\"https://profiles.wordpress.org/cweiske/\">cweiske</a> · <a href=\"https://profiles.wordpress.org/didierjm/\">cybeardjm</a> · <a href=\"https://profiles.wordpress.org/coquardcyr/\">Cyrille</a> · <a href=\"https://profiles.wordpress.org/css31/\">Cyrille Sanson</a> · <a href=\"https://profiles.wordpress.org/daedalon/\">Daedalon</a> · <a href=\"https://profiles.wordpress.org/acketon/\">Dakota Chichester</a> · <a href=\"https://profiles.wordpress.org/dalleyne/\">Damien Alleyne</a> · <a href=\"https://profiles.wordpress.org/colorful-tones/\">Damon Cook</a> · <a href=\"https://profiles.wordpress.org/dpknauss/\">Dan Knauss</a> · <a href=\"https://profiles.wordpress.org/danht/\">danht</a> · <a href=\"https://profiles.wordpress.org/daniguardiola/\">Dani Guardiola</a> · <a href=\"https://profiles.wordpress.org/danielbachhuber/\">Daniel Bachhuber</a> · <a href=\"https://profiles.wordpress.org/danielpost/\">Daniel Post</a> · <a href=\"https://profiles.wordpress.org/talldanwp/\">Daniel Richards</a> · <a href=\"https://profiles.wordpress.org/mte90/\">Daniele Scasciafratte</a> · <a href=\"https://profiles.wordpress.org/danielpataki/\">danielpataki</a> · <a href=\"https://profiles.wordpress.org/danielvann/\">danielvann</a> · <a href=\"https://profiles.wordpress.org/darerodz/\">darerodz</a> · <a href=\"https://profiles.wordpress.org/dhewercorus/\">Darren Hewer</a> · <a href=\"https://profiles.wordpress.org/davelo/\">Dave Loodts</a> · <a href=\"https://profiles.wordpress.org/davilera/\">David Aguilera</a> · <a href=\"https://profiles.wordpress.org/darnado/\">David Arnado</a> · <a href=\"https://profiles.wordpress.org/davidbaumwald/\">David Baumwald</a> · <a href=\"https://profiles.wordpress.org/davidbinda/\">David Biňovec</a> · <a href=\"https://profiles.wordpress.org/davidabowman/\">David Bowman</a> · <a href=\"https://profiles.wordpress.org/dpcalhoun/\">David Calhoun</a> · <a href=\"https://profiles.wordpress.org/dafargier/\">David FARGIER</a> · <a href=\"https://profiles.wordpress.org/dlh/\">David Herrera</a> · <a href=\"https://profiles.wordpress.org/david-innes/\">David Innes</a> · <a href=\"https://profiles.wordpress.org/justlevine/\">David Levine</a> · <a href=\"https://profiles.wordpress.org/daviedr/\">David Rozando</a> · <a href=\"https://profiles.wordpress.org/dshanske/\">David Shanske</a> · <a href=\"https://profiles.wordpress.org/get_dave/\">David Smith</a> · <a href=\"https://profiles.wordpress.org/daymobrew/\">daymobrew</a> · <a href=\"https://profiles.wordpress.org/deadduck169/\">deadduck169</a> · <a href=\"https://profiles.wordpress.org/dsas/\">Dean Sas</a> · <a href=\"https://profiles.wordpress.org/dkarfa/\">Debabrata Karfa</a> · <a href=\"https://profiles.wordpress.org/debarghyabanerjee/\">DEBARGHYA BANERJEE</a> · <a href=\"https://profiles.wordpress.org/deeppatel8950/\">Deep Patel</a> · <a href=\"https://profiles.wordpress.org/deepakrohilla/\">Deepak Rohilla</a> · <a href=\"https://profiles.wordpress.org/realloc/\">Dennis Ploetner</a> · <a href=\"https://profiles.wordpress.org/dmsnell/\">Dennis Snell</a> · <a href=\"https://profiles.wordpress.org/densinakum/\">Densi Nakum</a> · <a href=\"https://profiles.wordpress.org/designsimply/\">designsimply</a> · <a href=\"https://profiles.wordpress.org/devansh2002/\">Devansh Chaudhary</a> · <a href=\"https://profiles.wordpress.org/dhananjaykuber/\">Dhananjay Kuber</a> · <a href=\"https://profiles.wordpress.org/dharm1025/\">Dharmesh Patel</a> · <a href=\"https://profiles.wordpress.org/dhavalkapadane/\">Dhaval Kapadane</a> · <a href=\"https://profiles.wordpress.org/dheeraj2995/\">Dheeraj Bhosale</a> · <a href=\"https://profiles.wordpress.org/dhrumilk/\">Dhrumil Kumbhani</a> · <a href=\"https://profiles.wordpress.org/dhruvang21/\">Dhruvang21</a> · <a href=\"https://profiles.wordpress.org/dhruvishah2203/\">Dhruvi Shah</a> · <a href=\"https://profiles.wordpress.org/dhruvik18/\">Dhruvik Malaviya</a> · <a href=\"https://profiles.wordpress.org/dilipom13/\">dilip</a> · <a href=\"https://profiles.wordpress.org/dilipbheda/\">Dilip Bheda</a> · <a href=\"https://profiles.wordpress.org/diliphingarajiya/\">Dilip Hingarajiya</a> · <a href=\"https://profiles.wordpress.org/dilip2615/\">Dilip Modhavadiya</a> · <a href=\"https://profiles.wordpress.org/dingguodong/\">DingGuodong</a> · <a href=\"https://profiles.wordpress.org/dd32/\">Dion Hulse</a> · <a href=\"https://profiles.wordpress.org/divyeshk71/\">Divyesh_kakrecha</a> · <a href=\"https://profiles.wordpress.org/djcowan/\">dj.cowan</a> · <a href=\"https://profiles.wordpress.org/mediaformat/\">Django</a> · <a href=\"https://profiles.wordpress.org/dnnsjsk/\">dnnsjsk</a> · <a href=\"https://profiles.wordpress.org/doekenorg/\">Doeke Norg</a> · <a href=\"https://profiles.wordpress.org/dogee/\">dogee</a> · <a href=\"https://profiles.wordpress.org/domenicdenicola/\">domenicdenicola</a> · <a href=\"https://profiles.wordpress.org/ocean90/\">Dominik Schilling</a> · <a href=\"https://profiles.wordpress.org/donalirl/\">donalirl</a> · <a href=\"https://profiles.wordpress.org/dooperweb/\">dooperweb</a> · <a href=\"https://profiles.wordpress.org/dougwollison/\">Doug Wollison</a> · <a href=\"https://profiles.wordpress.org/dretzlaff/\">dretzlaff</a> · <a href=\"https://profiles.wordpress.org/drewapicture/\">Drew Jaynes</a> · <a href=\"https://profiles.wordpress.org/drivingralle/\">Drivingralle</a> · <a href=\"https://profiles.wordpress.org/dwainm/\">Dwain Maralack</a> · <a href=\"https://profiles.wordpress.org/earthman100/\">Earthman Media</a> · <a href=\"https://profiles.wordpress.org/eclev91/\">eclev91</a> · <a href=\"https://profiles.wordpress.org/eddystile/\">Eddy</a> · <a href=\"https://profiles.wordpress.org/cais/\">Edward Caissie</a> · <a href=\"https://profiles.wordpress.org/eceleste/\">efc</a> · <a href=\"https://profiles.wordpress.org/talksina/\">Elena Brescacin</a> · <a href=\"https://profiles.wordpress.org/elizaan36/\">elizaan36</a> · <a href=\"https://profiles.wordpress.org/ellatrix/\">Ella van&nbsp;Durpe</a> · <a href=\"https://profiles.wordpress.org/codex-m/\">Emerson Maningo</a> · <a href=\"https://profiles.wordpress.org/emlebrun/\">Emilie LEBRUN</a> · <a href=\"https://profiles.wordpress.org/eatse/\">Emmanuel Atsé</a> · <a href=\"https://profiles.wordpress.org/lopo/\">Enrico Battocchi</a> · <a href=\"https://profiles.wordpress.org/ericdye/\">Eric Dye</a> · <a href=\"https://profiles.wordpress.org/ethitter/\">Erick Hitter</a> · <a href=\"https://profiles.wordpress.org/codekraft/\">Erik</a> · <a href=\"https://profiles.wordpress.org/kebbet/\">Erik</a> · <a href=\"https://profiles.wordpress.org/im3dabasia1/\">Eshaan Dabasiya</a> · <a href=\"https://profiles.wordpress.org/estelaris/\">Estela Rueda</a> · <a href=\"https://profiles.wordpress.org/eherman24/\">Evan Herman</a> · <a href=\"https://profiles.wordpress.org/etobiesen/\">Even Tobiesen</a> · <a href=\"https://profiles.wordpress.org/fabiankaegy/\">Fabian Kägy</a> · <a href=\"https://profiles.wordpress.org/gaambo/\">Fabian Todt</a> · <a href=\"https://profiles.wordpress.org/faisalahammad/\">Faisal Ahammad</a> · <a href=\"https://profiles.wordpress.org/faisal03/\">Faisal Alvi</a> · <a href=\"https://profiles.wordpress.org/fazyshah/\">Faizan Nabi</a> · <a href=\"https://profiles.wordpress.org/flixos90/\">Felix Arntz</a> · <a href=\"https://profiles.wordpress.org/ffffelix/\">Felix Renicks</a> · <a href=\"https://profiles.wordpress.org/finntown/\">finntown</a> · <a href=\"https://profiles.wordpress.org/firoz2456/\">Firoz Sabaliya</a> · <a href=\"https://profiles.wordpress.org/francina/\">Francesca Marano</a> · <a href=\"https://profiles.wordpress.org/franciscabusas22/\">Francis Cabusas</a> · <a href=\"https://profiles.wordpress.org/fcoveram/\">Francisco</a> · <a href=\"https://profiles.wordpress.org/frankbiganski/\">Frank B.</a> · <a href=\"https://profiles.wordpress.org/frank-klein/\">Frank Klein</a> · <a href=\"https://profiles.wordpress.org/franz00/\">Fransisca H</a> · <a href=\"https://profiles.wordpress.org/frkly/\">frkly</a> · <a href=\"https://profiles.wordpress.org/fushar/\">fushar</a> · <a href=\"https://profiles.wordpress.org/fxbenard/\">fxbenard</a> · <a href=\"https://profiles.wordpress.org/gaellebesson/\">gaellebesson</a> · <a href=\"https://profiles.wordpress.org/gajendrasingh/\">Gajendra Singh</a> · <a href=\"https://profiles.wordpress.org/galibh/\">Galib Hayder</a> · <a href=\"https://profiles.wordpress.org/ecgan/\">Gan Eng Chin</a> · <a href=\"https://profiles.wordpress.org/garrett-eclipse/\">Garrett Hyder</a> · <a href=\"https://profiles.wordpress.org/garyj/\">Gary Jones</a> · <a href=\"https://profiles.wordpress.org/pento/\">Gary Pendergast</a> · <a href=\"https://profiles.wordpress.org/soulseekah/\">Gennady Kovshenin</a> · <a href=\"https://profiles.wordpress.org/mamaduka/\">George Mamadashvili</a> · <a href=\"https://profiles.wordpress.org/geriux/\">Gerardo Pacheco</a> · <a href=\"https://profiles.wordpress.org/ghinamt/\">ghinamt</a> · <a href=\"https://profiles.wordpress.org/girishpanchal/\">Girish Panchal</a> · <a href=\"https://profiles.wordpress.org/giuriani/\">giuriani</a> · <a href=\"https://profiles.wordpress.org/glendaviesnz/\">Glen Davies</a> · <a href=\"https://profiles.wordpress.org/glynnquelch/\">Glynn Quelch</a> · <a href=\"https://profiles.wordpress.org/ingeniumed/\">Gopal Krishnan</a> · <a href=\"https://profiles.wordpress.org/grantmkin/\">Grant M. Kinney</a> · <a href=\"https://profiles.wordpress.org/gziolo/\">Greg Ziółkowski</a> · <a href=\"https://profiles.wordpress.org/gregbenz/\">gregbenz</a> · <a href=\"https://profiles.wordpress.org/grgarside/\">grgarside</a> · <a href=\"https://profiles.wordpress.org/guido07111975/\">Guido</a> · <a href=\"https://profiles.wordpress.org/guillaumeturpin/\">Guillaume TURPIN</a> · <a href=\"https://profiles.wordpress.org/gulamdastgir04/\">Gulamdastgir Momin</a> · <a href=\"https://profiles.wordpress.org/priethor/\">Héctor Prieto</a> · <a href=\"https://profiles.wordpress.org/gencmedya/\">Halil Kaya</a> · <a href=\"https://profiles.wordpress.org/yahaly/\">Halyna Yampolska</a> · <a href=\"https://profiles.wordpress.org/hameem1102/\">Hameem Mahdad Kader</a> · <a href=\"https://profiles.wordpress.org/hanneslsm/\">Hannes Leismann</a> · <a href=\"https://profiles.wordpress.org/hage/\">Hans-Gerd Gerhards</a> · <a href=\"https://profiles.wordpress.org/hareesh-pillai/\">Hareesh S</a> · <a href=\"https://profiles.wordpress.org/harrym/\">harrym</a> · <a href=\"https://profiles.wordpress.org/harshalkadu/\">Harshal Kadu</a> · <a href=\"https://profiles.wordpress.org/hazdiego/\">Haz</a> · <a href=\"https://profiles.wordpress.org/hekuranredev/\">hekuranredev</a> · <a href=\"https://profiles.wordpress.org/helen/\">Helen Hou-Sandi</a> · <a href=\"https://profiles.wordpress.org/hdkothari81/\">Hemant Kothari</a> · <a href=\"https://profiles.wordpress.org/iamarinoh/\">Henrique Iamarino</a> · <a href=\"https://profiles.wordpress.org/henrywright/\">Henry Wright</a> · <a href=\"https://profiles.wordpress.org/rvouill/\">Herve THOMAS</a> · <a href=\"https://profiles.wordpress.org/hideishi/\">hideishi</a> · <a href=\"https://profiles.wordpress.org/kurudrive/\">Hidekazu Ishikawa</a> · <a href=\"https://profiles.wordpress.org/hilayt24/\">Hilay Trivedi</a> · <a href=\"https://profiles.wordpress.org/panchalhimani711/\">Himani Panchal</a> · <a href=\"https://profiles.wordpress.org/abcd95/\">Himanshu Pathak</a> · <a href=\"https://profiles.wordpress.org/hbhalodia/\">Hit Bhalodia</a> · <a href=\"https://profiles.wordpress.org/hiteshhuptechweb/\">Hitesh Dhokai</a> · <a href=\"https://profiles.wordpress.org/hovhanneshovakimyan/\">Hovhannes Hovakimyan</a> · <a href=\"https://profiles.wordpress.org/hueitan/\">hueitan</a> · <a href=\"https://profiles.wordpress.org/humanify/\">humanify</a> · <a href=\"https://profiles.wordpress.org/hussain896/\">hussain896</a> · <a href=\"https://profiles.wordpress.org/huubl/\">huubl</a> · <a href=\"https://profiles.wordpress.org/huzaifaalmesbah/\">Huzaifa Al Mesbah</a> · <a href=\"https://profiles.wordpress.org/iandunn/\">Ian Dunn</a> · <a href=\"https://profiles.wordpress.org/ilovecats7/\">ilovecats7</a> · <a href=\"https://profiles.wordpress.org/imranhasanraaz/\">Imran</a> · <a href=\"https://profiles.wordpress.org/imranh920/\">Imran Hossain (a11n)</a> · <a href=\"https://profiles.wordpress.org/indirabiswas27/\">Indira Biswas</a> · <a href=\"https://profiles.wordpress.org/indithemes/\">indithemes</a> · <a href=\"https://profiles.wordpress.org/isabel_brison/\">Isabel Brison</a> · <a href=\"https://profiles.wordpress.org/iseulde/\">iseulde</a> · <a href=\"https://profiles.wordpress.org/isuke01/\">Isu</a> · <a href=\"https://profiles.wordpress.org/ivankristianto/\">Ivan Kristianto</a> · <a href=\"https://profiles.wordpress.org/moxie/\">Jack</a> · <a href=\"https://profiles.wordpress.org/jagirbahesh/\">Jagir Bahesh</a> · <a href=\"https://profiles.wordpress.org/jainil07/\">Jainil Shah</a> · <a href=\"https://profiles.wordpress.org/whyisjake/\">Jake Spurlock</a> · <a href=\"https://profiles.wordpress.org/jameskoster/\">James Koster</a> · <a href=\"https://profiles.wordpress.org/jhmonroe/\">James Monroe</a> · <a href=\"https://profiles.wordpress.org/jopdop30/\">James Payne</a> · <a href=\"https://profiles.wordpress.org/imaginarymedia/\">James Robinson</a> · <a href=\"https://profiles.wordpress.org/q0rban/\">James Sansbury</a> · <a href=\"https://profiles.wordpress.org/jamieblomerus/\">Jamie Blomerus</a> · <a href=\"https://profiles.wordpress.org/jammycakes/\">jammycakes</a> · <a href=\"https://profiles.wordpress.org/lysyjan87/\">Jan Lysý</a> · <a href=\"https://profiles.wordpress.org/janak007/\">janak Kaneriya</a> · <a href=\"https://profiles.wordpress.org/janusdev/\">janusdev</a> · <a href=\"https://profiles.wordpress.org/jsnajdr/\">Jarda Snajdr</a> · <a href=\"https://profiles.wordpress.org/jarekmorawski/\">jarekmorawski</a> · <a href=\"https://profiles.wordpress.org/boogah/\">Jason Cosper</a> · <a href=\"https://profiles.wordpress.org/madtownlems/\">Jason LeMahieu (MadtownLems)</a> · <a href=\"https://profiles.wordpress.org/jasonsa19/\">Jason Sauerwald</a> · <a href=\"https://profiles.wordpress.org/javiercasares/\">Javier Casares</a> · <a href=\"https://profiles.wordpress.org/shovan_jaya/\">Jayaram</a> · <a href=\"https://profiles.wordpress.org/jdahir0789/\">JD Ahir</a> · <a href=\"https://profiles.wordpress.org/jdnd/\">jdnd</a> · <a href=\"https://profiles.wordpress.org/audrasjb/\">Jean-Baptiste Audras</a> · <a href=\"https://profiles.wordpress.org/krokodok/\">Jeff Chi</a> · <a href=\"https://profiles.wordpress.org/maverick3x6/\">Jeff Golenski</a> · <a href=\"https://profiles.wordpress.org/jffng/\">Jeff Ong</a> · <a href=\"https://profiles.wordpress.org/jeffpaul/\">Jeff Paul</a> · <a href=\"https://profiles.wordpress.org/jeflopodev/\">jeflopo</a> · <a href=\"https://profiles.wordpress.org/jdy68/\">Jenny Dupuy</a> · <a href=\"https://profiles.wordpress.org/jepperask/\">jepperask</a> · <a href=\"https://profiles.wordpress.org/jeremyfelt/\">Jeremy Felt</a> · <a href=\"https://profiles.wordpress.org/jeremy80/\">jeremy80</a> · <a href=\"https://profiles.wordpress.org/jeremyroman/\">jeremyroman</a> · <a href=\"https://profiles.wordpress.org/jeryj/\">jeryj</a> · <a href=\"https://profiles.wordpress.org/jessedyck/\">jessedyck</a> · <a href=\"https://profiles.wordpress.org/luminuu/\">Jessica Lyschik</a> · <a href=\"https://profiles.wordpress.org/jigar-bhanushali/\">Jigar Bhanushali</a> · <a href=\"https://profiles.wordpress.org/jigar9998/\">Jigar Panchal</a> · <a href=\"https://profiles.wordpress.org/jnweaver/\">jnweaver</a> · <a href=\"https://profiles.wordpress.org/jartes/\">Joan Artes</a> · <a href=\"https://profiles.wordpress.org/jodamo5/\">jodamo5</a> · <a href=\"https://profiles.wordpress.org/joedolson/\">Joe Dolson</a> · <a href=\"https://profiles.wordpress.org/joehoyle/\">Joe Hoyle</a> · <a href=\"https://profiles.wordpress.org/joemcgill/\">Joe McGill</a> · <a href=\"https://profiles.wordpress.org/joecsmalley/\">joecsmalley</a> · <a href=\"https://profiles.wordpress.org/joen/\">Joen Asmussen</a> · <a href=\"https://profiles.wordpress.org/timse201/\">Johannes Jülg</a> · <a href=\"https://profiles.wordpress.org/johnbillion/\">John Blackbourn</a> · <a href=\"https://profiles.wordpress.org/johnjamesjacoby/\">John James Jacoby</a> · <a href=\"https://profiles.wordpress.org/johnregan3/\">John Regan</a> · <a href=\"https://profiles.wordpress.org/arrcorona/\">Jomar Jay</a> · <a href=\"https://profiles.wordpress.org/jomonthomaslobo1/\">Jomon Thomas Lobo</a> · <a href=\"https://profiles.wordpress.org/jonsurrell/\">Jon Surrell</a> · <a href=\"https://profiles.wordpress.org/psykro/\">Jonathan Bossenger</a> · <a href=\"https://profiles.wordpress.org/desrosj/\">Jonathan Desrosiers</a> · <a href=\"https://profiles.wordpress.org/jongycastillo/\">Jong</a> · <a href=\"https://profiles.wordpress.org/n2erjo00/\">Joni Erkkilä</a> · <a href=\"https://profiles.wordpress.org/spacedmonkey/\">Jonny Harris</a> · <a href=\"https://profiles.wordpress.org/jonnyauk/\">jonnyauk</a> · <a href=\"https://profiles.wordpress.org/joomskys/\">joomskys</a> · <a href=\"https://profiles.wordpress.org/joostdevalk/\">Joost de Valk</a> · <a href=\"https://profiles.wordpress.org/jordesign/\">jordesign</a> · <a href=\"https://profiles.wordpress.org/jorgefilipecosta/\">Jorge Costa</a> · <a href=\"https://profiles.wordpress.org/josvelasco/\">Jos Velasco</a> · <a href=\"https://profiles.wordpress.org/josevarghese/\">Jose Varghese</a> · <a href=\"https://profiles.wordpress.org/blogitsolutions/\">Josef Seidl</a> · <a href=\"https://profiles.wordpress.org/josephscott/\">Joseph Scott</a> · <a href=\"https://profiles.wordpress.org/joshuawold/\">Joshua Wold</a> · <a href=\"https://profiles.wordpress.org/jottevanger/\">jottevanger</a> · <a href=\"https://profiles.wordpress.org/jokanane/\">Jouni Kananen</a> · <a href=\"https://profiles.wordpress.org/joyously/\">Joy</a> · <a href=\"https://profiles.wordpress.org/juanfra/\">Juan Aldasoro</a> · <a href=\"https://profiles.wordpress.org/juanbuis/\">juanbuis</a> · <a href=\"https://profiles.wordpress.org/juanmaguitar/\">JuanMa Garrido</a> · <a href=\"https://profiles.wordpress.org/juanwp22/\">juanwp22</a> · <a href=\"https://profiles.wordpress.org/jules-colle/\">Jules Colle</a> · <a href=\"https://profiles.wordpress.org/julianmar/\">julianmar</a> · <a href=\"https://profiles.wordpress.org/juliemoynat/\">Julie Moynat</a> · <a href=\"https://profiles.wordpress.org/jrf/\">Juliette Reinders Folmer</a> · <a href=\"https://profiles.wordpress.org/juliobox/\">Julio Potier</a> · <a href=\"https://profiles.wordpress.org/greenshady/\">Justin Tadlock</a> · <a href=\"https://profiles.wordpress.org/juzar/\">Juzar</a> · <a href=\"https://profiles.wordpress.org/kadamwhite/\">K. Adam White</a> · <a href=\"https://profiles.wordpress.org/kafleg/\">KafleG</a> · <a href=\"https://profiles.wordpress.org/kevin940726/\">Kai Hao</a> · <a href=\"https://profiles.wordpress.org/kaitohm/\">Kaito Hanamori</a> · <a href=\"https://profiles.wordpress.org/ikamal/\">Kamal Hosen</a> · <a href=\"https://profiles.wordpress.org/kapasias/\">KAP ASIAs</a> · <a href=\"https://profiles.wordpress.org/kapilpaul/\">Kapil Paul</a> · <a href=\"https://profiles.wordpress.org/karlgroves/\">karlgroves</a> · <a href=\"https://profiles.wordpress.org/karolmanijak/\">Karol Manijak</a> · <a href=\"https://profiles.wordpress.org/karthickmurugan/\">Karthick Murugan</a> · <a href=\"https://profiles.wordpress.org/thekt12/\">Karthik Thayyil</a> · <a href=\"https://profiles.wordpress.org/karthikeya01/\">Karthikeya Bethu</a> · <a href=\"https://profiles.wordpress.org/kasparsd/\">Kaspars</a> · <a href=\"https://profiles.wordpress.org/zoonini/\">Kathryn Presner</a> · <a href=\"https://profiles.wordpress.org/kausaralm/\">Kausar Alam</a> · <a href=\"https://profiles.wordpress.org/keithdevon/\">keithdevon</a> · <a href=\"https://profiles.wordpress.org/kel-dc/\">Kel Santiago-Pilarski</a> · <a href=\"https://profiles.wordpress.org/ryelle/\">Kelly Choyce-Dwan</a> · <a href=\"https://profiles.wordpress.org/tinypixel/\">Kelly Mears</a> · <a href=\"https://profiles.wordpress.org/keoshi/\">keoshi</a> · <a href=\"https://profiles.wordpress.org/ketanniruke/\">Ketan Niruke</a> · <a href=\"https://profiles.wordpress.org/patelketan/\">Ketan Patel</a> · <a href=\"https://profiles.wordpress.org/kevinlearynet/\">Kevinleary.net</a> · <a href=\"https://profiles.wordpress.org/kharisblank/\">Kharis Sulistiyono</a> · <a href=\"https://profiles.wordpress.org/kirasong/\">Kira Schroder</a> · <a href=\"https://profiles.wordpress.org/kjroelke/\">KJ Roelke</a> · <a href=\"https://profiles.wordpress.org/kkmuffme/\">kkmuffme</a> · <a href=\"https://profiles.wordpress.org/knutsp/\">Knut Sparhell</a> · <a href=\"https://profiles.wordpress.org/kohheepeace/\">kohheepeace</a> · <a href=\"https://profiles.wordpress.org/kmgalanakis/\">Konstantinos Galanakis</a> · <a href=\"https://profiles.wordpress.org/xkon/\">Konstantinos Xenos</a> · <a href=\"https://profiles.wordpress.org/kristastevens/\">kristastevens</a> · <a href=\"https://profiles.wordpress.org/krupajnanda/\">Krupa Nanda</a> · <a href=\"https://profiles.wordpress.org/krupaly2k/\">Krupal Lakhia</a> · <a href=\"https://profiles.wordpress.org/laurelfulford/\">laurelfulford</a> · <a href=\"https://profiles.wordpress.org/wplmillet/\">Laurent MILLET</a> · <a href=\"https://profiles.wordpress.org/lakshmananphp/\">Lax Mariappan</a> · <a href=\"https://profiles.wordpress.org/laxman-prajapati/\">Laxman Prajapati</a> · <a href=\"https://profiles.wordpress.org/lcarevic/\">lcarevic</a> · <a href=\"https://profiles.wordpress.org/leecollings/\">Lee</a> · <a href=\"https://profiles.wordpress.org/leewillis77/\">Lee Willis</a> · <a href=\"https://profiles.wordpress.org/leedxw/\">leedxw</a> · <a href=\"https://profiles.wordpress.org/0mirka00/\">Lena Morita</a> · <a href=\"https://profiles.wordpress.org/lenasterg/\">lenasterg</a> · <a href=\"https://profiles.wordpress.org/leszeks/\">leszeks</a> · <a href=\"https://profiles.wordpress.org/leup/\">leup</a> · <a href=\"https://profiles.wordpress.org/levskipg/\">levskipg</a> · <a href=\"https://profiles.wordpress.org/lgladdy/\">Liam Gladdy</a> · <a href=\"https://profiles.wordpress.org/louislaugesen/\">Louis</a> · <a href=\"https://profiles.wordpress.org/louwie17/\">Lourens</a> · <a href=\"https://profiles.wordpress.org/lovesoni1999/\">Love Soni</a> · <a href=\"https://profiles.wordpress.org/thelovekesh/\">Lovekesh Kumar</a> · <a href=\"https://profiles.wordpress.org/lovewpmu/\">lovewpmu</a> · <a href=\"https://profiles.wordpress.org/lovor/\">Lovro Hrust</a> · <a href=\"https://profiles.wordpress.org/dreadlox/\">Lox</a> · <a href=\"https://profiles.wordpress.org/ltrihan/\">ltrihan</a> · <a href=\"https://profiles.wordpress.org/gigitux/\">Luigi Teschio</a> · <a href=\"https://profiles.wordpress.org/zaguiini/\">Luis Felipe Zaguini</a> · <a href=\"https://profiles.wordpress.org/luisherranz/\">luisherranz</a> · <a href=\"https://profiles.wordpress.org/wpfed/\">Lukasz</a> · <a href=\"https://profiles.wordpress.org/lukecavanagh/\">Luke Cavanagh</a> · <a href=\"https://profiles.wordpress.org/gadelhas/\">Mário Santos</a> · <a href=\"https://profiles.wordpress.org/maciejmackowiak/\">maciejmackowiak</a> · <a href=\"https://profiles.wordpress.org/madhudollu/\">Madhu Dollu</a> · <a href=\"https://profiles.wordpress.org/madpeter/\">madpeter</a> · <a href=\"https://profiles.wordpress.org/magdarogier/\">Magda Rogier</a> · <a href=\"https://profiles.wordpress.org/onemaggie/\">Maggie Cabrera</a> · <a href=\"https://profiles.wordpress.org/mp518/\">Mahesh Prajapati</a> · <a href=\"https://profiles.wordpress.org/mai21/\">Mai</a> · <a href=\"https://profiles.wordpress.org/maikelraow/\">maikelraow</a> · <a href=\"https://profiles.wordpress.org/travel_girl/\">Maja Benke</a> · <a href=\"https://profiles.wordpress.org/mkrndmane/\">Makarand G. Mane</a> · <a href=\"https://profiles.wordpress.org/tomdxw/\">mallorydxw-old</a> · <a href=\"https://profiles.wordpress.org/manfcarlo/\">manfcarlo</a> · <a href=\"https://profiles.wordpress.org/manojmaharrshi/\">Manoj Maharrshi</a> · <a href=\"https://profiles.wordpress.org/manzoorwanijk/\">Manzoor Wani (a11n)</a> · <a href=\"https://profiles.wordpress.org/mdxfr/\">Marc</a> · <a href=\"https://profiles.wordpress.org/fullofcaffeine/\">Marcelo de Moraes Serpa</a> · <a href=\"https://profiles.wordpress.org/marchalyoan/\">marchalyoan</a> · <a href=\"https://profiles.wordpress.org/afmarchetti/\">Marchetti Design</a> · <a href=\"https://profiles.wordpress.org/mciampini/\">Marco Ciampini</a> · <a href=\"https://profiles.wordpress.org/mariayohana/\">Maria Yohana</a> · <a href=\"https://profiles.wordpress.org/marian1/\">marian1</a> · <a href=\"https://profiles.wordpress.org/nuryko/\">Marianna</a> · <a href=\"https://profiles.wordpress.org/plari/\">Marie</a> · <a href=\"https://profiles.wordpress.org/tyxla/\">Marin Atanasov</a> · <a href=\"https://profiles.wordpress.org/marineevain/\">Marine EVAIN</a> · <a href=\"https://profiles.wordpress.org/nofearinc/\">Mario Peshev</a> · <a href=\"https://profiles.wordpress.org/santosguillamot/\">Mario Santos</a> · <a href=\"https://profiles.wordpress.org/clorith/\">Marius L. J.</a> · <a href=\"https://profiles.wordpress.org/markhowellsmead/\">Mark Howells-Mead</a> · <a href=\"https://profiles.wordpress.org/mapk/\">Mark Uraine</a> · <a href=\"https://profiles.wordpress.org/mark-k/\">Mark-k</a> · <a href=\"https://profiles.wordpress.org/martinkrcho/\">martin.krcho</a> · <a href=\"https://profiles.wordpress.org/marybaum/\">Mary Baum</a> · <a href=\"https://profiles.wordpress.org/immasud/\">Masud Rana</a> · <a href=\"https://profiles.wordpress.org/paapst/\">Mathieu Paapst</a> · <a href=\"https://profiles.wordpress.org/mmaattiiaass/\">Matias Benedetto</a> · <a href=\"https://profiles.wordpress.org/matveb/\">Matias Ventura</a> · <a href=\"https://profiles.wordpress.org/iammattthomas/\">Matt (Thomas) Miklic</a> · <a href=\"https://profiles.wordpress.org/matt/\">Matt Mullenweg</a> · <a href=\"https://profiles.wordpress.org/mattyrob/\">Matt Robinson</a> · <a href=\"https://profiles.wordpress.org/mattwest/\">Matt West</a> · <a href=\"https://profiles.wordpress.org/kinggmobb/\">Matthew</a> · <a href=\"https://profiles.wordpress.org/mboynes/\">Matthew Boynes</a> · <a href=\"https://profiles.wordpress.org/mattryanwalker/\">mattryanwalker</a> · <a href=\"https://profiles.wordpress.org/azouamauriac/\">Mauriac AZOUA</a> · <a href=\"https://profiles.wordpress.org/maximemeganck/\">Maxime Meganck</a> · <a href=\"https://profiles.wordpress.org/maximebj/\">maximebj</a> · <a href=\"https://profiles.wordpress.org/mayanktripathi32/\">Mayank Tripathi</a> · <a href=\"https://profiles.wordpress.org/mayur8991/\">Mayur Prajapati</a> · <a href=\"https://profiles.wordpress.org/faithcoder/\">Md Abdullah Al Arif</a> · <a href=\"https://profiles.wordpress.org/hmbashar/\">Md Abul Bashar</a> · <a href=\"https://profiles.wordpress.org/itsmhrahman/\">Md Hafijur Rahman</a> · <a href=\"https://profiles.wordpress.org/kawsar007/\">MD Kawsar Chowdhury</a> · <a href=\"https://profiles.wordpress.org/mehdi01/\">Md Mahdi Hasan</a> · <a href=\"https://profiles.wordpress.org/mdibrahimk48/\">Md. Ibrahim Khalil</a> · <a href=\"https://profiles.wordpress.org/najmulsaju/\">Md. Najmul Islam</a> · <a href=\"https://profiles.wordpress.org/mehedi_csit/\">Md.Mehedi Hasan</a> · <a href=\"https://profiles.wordpress.org/mdviralsampat/\">mdviralsampat</a> · <a href=\"https://profiles.wordpress.org/megane9988/\">megane9988</a> · <a href=\"https://profiles.wordpress.org/leeseoftbc/\">MelissaH</a> · <a href=\"https://profiles.wordpress.org/metropolis_john/\">metropolis_john</a> · <a href=\"https://profiles.wordpress.org/mdawaffe/\">Michael Adams (mdawaffe)</a> · <a href=\"https://profiles.wordpress.org/mburridge/\">Michael Burridge</a> · <a href=\"https://profiles.wordpress.org/websiteredev/\">Michael Willman</a> · <a href=\"https://profiles.wordpress.org/czapla/\">Michal Czaplinski</a> · <a href=\"https://profiles.wordpress.org/michelleames/\">Michelle Frechette</a> · <a href=\"https://profiles.wordpress.org/micromadness/\">micromadness</a> · <a href=\"https://profiles.wordpress.org/mcsf/\">Miguel Fonseca</a> · <a href=\"https://profiles.wordpress.org/mmtr86/\">Miguel Torres</a> · <a href=\"https://profiles.wordpress.org/mijotj/\">Mijo T J</a> · <a href=\"https://profiles.wordpress.org/simison/\">Mikael Korpela</a> · <a href=\"https://profiles.wordpress.org/mbijon/\">Mike Bijon</a> · <a href=\"https://profiles.wordpress.org/ritterml/\">Mike Ritter</a> · <a href=\"https://profiles.wordpress.org/mikinc860/\">Mikin Chauhan</a> · <a href=\"https://profiles.wordpress.org/milana_cap/\">Milana Cap</a> · <a href=\"https://profiles.wordpress.org/milindmore22/\">Milind More</a> · <a href=\"https://profiles.wordpress.org/mimitips/\">mimi</a> · <a href=\"https://profiles.wordpress.org/369work/\">miroku</a> · <a href=\"https://profiles.wordpress.org/presstoke/\">Mitchell Austin</a> · <a href=\"https://profiles.wordpress.org/modi2918/\">Modi Sahil</a> · <a href=\"https://profiles.wordpress.org/antwortzeit/\">modulbuero</a> · <a href=\"https://profiles.wordpress.org/aboelfotoh/\">Mohamed Aboelfotoh Mohamed</a> · <a href=\"https://profiles.wordpress.org/mohitdadhich10/\">Mohit Dadhich</a> · <a href=\"https://profiles.wordpress.org/mojorob/\">mojorob</a> · <a href=\"https://profiles.wordpress.org/jucaduca/\">Morais Junior</a> · <a href=\"https://profiles.wordpress.org/mosescursor/\">Moses Cursor Ssebunya</a> · <a href=\"https://profiles.wordpress.org/mosne/\">Mosne / Paolo Tesei</a> · <a href=\"https://profiles.wordpress.org/mr660/\">mr660</a> · <a href=\"https://profiles.wordpress.org/mreishus/\">mreishus</a> · <a href=\"https://profiles.wordpress.org/mrwweb/\">mrwweb</a> · <a href=\"https://profiles.wordpress.org/mtdkei/\">mt</a> · <a href=\"https://profiles.wordpress.org/muddassirnasim/\">Muddassir Rahman Nasim</a> · <a href=\"https://profiles.wordpress.org/devmuhib/\">Muhibul Haque</a> · <a href=\"https://profiles.wordpress.org/mujuonly/\">mujuonly</a> · <a href=\"https://profiles.wordpress.org/mukesh27/\">Mukesh Panchal</a> · <a href=\"https://profiles.wordpress.org/mukulsingh27/\">Mukul Singh</a> · <a href=\"https://profiles.wordpress.org/my1xt/\">My1</a> · <a href=\"https://profiles.wordpress.org/n8finch/\">n8finch</a> · <a href=\"https://profiles.wordpress.org/assassinateur/\">Nadir Seghir</a> · <a href=\"https://profiles.wordpress.org/nandow/\">nandow</a> · <a href=\"https://profiles.wordpress.org/nanisamireddy/\">NANI SAMIREDDY</a> · <a href=\"https://profiles.wordpress.org/narenin/\">Narendra Sishodiya</a> · <a href=\"https://profiles.wordpress.org/nareshbheda/\">Naresh Bheda</a> · <a href=\"https://profiles.wordpress.org/nataliat2004/\">Natalia T</a> · <a href=\"https://profiles.wordpress.org/nathanatmoz/\">Nathan Johnson</a> · <a href=\"https://profiles.wordpress.org/navneet/\">navneet</a> · <a href=\"https://profiles.wordpress.org/navi161/\">Navneet Kaur</a> · <a href=\"https://profiles.wordpress.org/nhrrob/\">Nazmul Hasan Robin</a> · <a href=\"https://profiles.wordpress.org/greatislander/\">Ned Zimmerman</a> · <a href=\"https://profiles.wordpress.org/neotrope/\">neotrope</a> · <a href=\"https://profiles.wordpress.org/mcqueen22/\">NerQuiles</a> · <a href=\"https://profiles.wordpress.org/krstarica/\">net</a> · <a href=\"https://profiles.wordpress.org/ndiego/\">Nick Diego</a> · <a href=\"https://profiles.wordpress.org/nickgalvez/\">nickgalvez</a> · <a href=\"https://profiles.wordpress.org/undefinedfr/\">Nicolas RIVIERE</a> · <a href=\"https://profiles.wordpress.org/nicolasleroy/\">nicolasleroy</a> · <a href=\"https://profiles.wordpress.org/nidhidhandhukiya/\">nidhidhandhukiya</a> · <a href=\"https://profiles.wordpress.org/ntsekouras/\">Nik Tsekouras</a> · <a href=\"https://profiles.wordpress.org/smushytaco/\">Nikan Radan</a> · <a href=\"https://profiles.wordpress.org/nikitasolanki1812/\">Nikita Solanki</a> · <a href=\"https://profiles.wordpress.org/nikunj8866/\">Nikunj Hatkar</a> · <a href=\"https://profiles.wordpress.org/snilesh/\">Nilesh Shiragave</a> · <a href=\"https://profiles.wordpress.org/nirajgirixd/\">Niraj Giri</a> · <a href=\"https://profiles.wordpress.org/nithins53/\">Nithin SreeRaj</a> · <a href=\"https://profiles.wordpress.org/mrtortai/\">Noam Eppel</a> · <a href=\"https://profiles.wordpress.org/noruzzaman/\">Noruzzaman</a> · <a href=\"https://profiles.wordpress.org/nosilver4u/\">nosilver4u</a> · <a href=\"https://profiles.wordpress.org/oceantober/\">oceantober</a> · <a href=\"https://profiles.wordpress.org/finalwebsites/\">Olaf Lederer</a> · <a href=\"https://profiles.wordpress.org/oglekler/\">Olga Gleckler</a> · <a href=\"https://profiles.wordpress.org/domainsupport/\">Oliver Campion</a> · <a href=\"https://profiles.wordpress.org/jbkkd/\">Omer Korner</a> · <a href=\"https://profiles.wordpress.org/arzola/\">Oscar Arzola</a> · <a href=\"https://profiles.wordpress.org/groenroos/\">Oskari Groenroos</a> · <a href=\"https://profiles.wordpress.org/othernoel/\">othernoel</a> · <a href=\"https://profiles.wordpress.org/ov3rfly/\">Ov3rfly</a> · <a href=\"https://profiles.wordpress.org/paaljoachim/\">Paal Joachim Romdahl</a> · <a href=\"https://profiles.wordpress.org/pampfelimetten/\">pampfelimetten</a> · <a href=\"https://profiles.wordpress.org/parinpanjari/\">Parin Panjari</a> · <a href=\"https://profiles.wordpress.org/dparthj/\">Parth Dodiya</a> · <a href=\"https://profiles.wordpress.org/parthvataliya/\">Parth vataliya</a> · <a href=\"https://profiles.wordpress.org/swissspidy/\">Pascal Birchler</a> · <a href=\"https://profiles.wordpress.org/casiepa/\">Pascal Casier</a> · <a href=\"https://profiles.wordpress.org/pateljaymin/\">Patel Jaymin</a> · <a href=\"https://profiles.wordpress.org/lumiblog/\">Patrick Lumumba</a> · <a href=\"https://profiles.wordpress.org/eartboard/\">Paul</a> · <a href=\"https://profiles.wordpress.org/pbearne/\">Paul Bearne</a> · <a href=\"https://profiles.wordpress.org/pbiron/\">Paul Biron</a> · <a href=\"https://profiles.wordpress.org/bbpaule/\">Paul English</a> · <a href=\"https://profiles.wordpress.org/paulkevan/\">Paul Kevan</a> · <a href=\"https://profiles.wordpress.org/paullb/\">paullb</a> · <a href=\"https://profiles.wordpress.org/psrpinto/\">Paulo Pinto</a> · <a href=\"https://profiles.wordpress.org/paulopmt1/\">Paulo Trentin</a> · <a href=\"https://profiles.wordpress.org/pavanpatil1/\">Pavan Patil</a> · <a href=\"https://profiles.wordpress.org/creadordev/\">Pawan Kumar</a> · <a href=\"https://profiles.wordpress.org/pedromendonca/\">Pedro Mendonça</a> · <a href=\"https://profiles.wordpress.org/provenself/\">Peter Rubin</a> · <a href=\"https://profiles.wordpress.org/westi/\">Peter Westwood</a> · <a href=\"https://profiles.wordpress.org/peterwilsoncc/\">Peter Wilson</a> · <a href=\"https://profiles.wordpress.org/peter8nss/\">peter8nss</a> · <a href=\"https://profiles.wordpress.org/peterdavehello/\">peterdavehello</a> · <a href=\"https://profiles.wordpress.org/petitphp/\">petitphp</a> · <a href=\"https://profiles.wordpress.org/philliproth/\">philliproth</a> · <a href=\"https://profiles.wordpress.org/philwebs/\">philwebs</a> · <a href=\"https://profiles.wordpress.org/pitamdey/\">Pitam Dey</a> · <a href=\"https://profiles.wordpress.org/pixlpirate/\">pixlpirate</a> · <a href=\"https://profiles.wordpress.org/podpirate/\">podpirate</a> · <a href=\"https://profiles.wordpress.org/poojabhimani/\">Pooja Bhimani</a> · <a href=\"https://profiles.wordpress.org/pooja1210/\">Pooja Killekar (Muchandikar)</a> · <a href=\"https://profiles.wordpress.org/pooja9712/\">pooja9712</a> · <a href=\"https://profiles.wordpress.org/praful2111/\">Praful Patel</a> · <a href=\"https://profiles.wordpress.org/prasadkarmalkar/\">Prasad Karmalkar</a> · <a href=\"https://profiles.wordpress.org/prashant/\">prashant</a> · <a href=\"https://profiles.wordpress.org/pmbaldha/\">Prashant Baldha</a> · <a href=\"https://profiles.wordpress.org/contactprashantpp/\">Prashant Patil</a> · <a href=\"https://profiles.wordpress.org/prathamesh24/\">Prathamesh Shirke</a> · <a href=\"https://profiles.wordpress.org/prathameshbhagat1511/\">prathameshbhagat1511</a> · <a href=\"https://profiles.wordpress.org/pkbhatt/\">Pratik Bhatt</a> · <a href=\"https://profiles.wordpress.org/pratikgandhi/\">Pratik Gandhi</a> · <a href=\"https://profiles.wordpress.org/pratiklondhe/\">Pratik Londhe</a> · <a href=\"https://profiles.wordpress.org/presskopp/\">Presskopp</a> · <a href=\"https://profiles.wordpress.org/priyank9033/\">Priyank</a> · <a href=\"https://profiles.wordpress.org/pushpenderindia/\">Pushpender Singh</a> · <a href=\"https://profiles.wordpress.org/itsjonq/\">Q</a> · <a href=\"https://profiles.wordpress.org/qhaensler/\">qhaensler</a> · <a href=\"https://profiles.wordpress.org/rfischmann/\">Rafael Fischmann</a> · <a href=\"https://profiles.wordpress.org/rahulsprajapati/\">Rahul Prajapati</a> · <a href=\"https://profiles.wordpress.org/imrraaj/\">Raj Patel</a> · <a href=\"https://profiles.wordpress.org/rajat1192/\">Rajat Patel</a> · <a href=\"https://profiles.wordpress.org/raj198/\">Rajendra Patel</a> · <a href=\"https://profiles.wordpress.org/rajendrapatilraj/\">Rajendra Patil</a> · <a href=\"https://profiles.wordpress.org/rkradadiya/\">Rajesh Radadiya</a> · <a href=\"https://profiles.wordpress.org/rajeshrathodwp/\">Rajesh Rathod</a> · <a href=\"https://profiles.wordpress.org/rajinsharwar/\">Rajin Sharwar</a> · <a href=\"https://profiles.wordpress.org/rahmohn/\">Ramon Ahnert</a> · <a href=\"https://profiles.wordpress.org/rcorrales/\">Ramon Corrales</a> · <a href=\"https://profiles.wordpress.org/ramonopoly/\">Ramon James</a> · <a href=\"https://profiles.wordpress.org/ravigadhiyawp/\">Ravi Gadhiya</a> · <a href=\"https://profiles.wordpress.org/redkite/\">redkite</a> · <a href=\"https://profiles.wordpress.org/rehanali/\">Rehan Ali</a> · <a href=\"https://profiles.wordpress.org/rejaulalomkhan/\">Rejaul Alom Khan</a> · <a href=\"https://profiles.wordpress.org/rembem/\">Remco</a> · <a href=\"https://profiles.wordpress.org/renathoc/\">Renatho</a> · <a href=\"https://profiles.wordpress.org/ooraiser69/\">Renz Jay Sanchez</a> · <a href=\"https://profiles.wordpress.org/youknowriad/\">Riad Benguella</a> · <a href=\"https://profiles.wordpress.org/richtabor/\">Rich Tabor</a> · <a href=\"https://profiles.wordpress.org/riddhidave/\">Riddhi Dave</a> · <a href=\"https://profiles.wordpress.org/rinkalpagdar/\">Rinkal Pagdar</a> · <a href=\"https://profiles.wordpress.org/rishavdutta/\">Rishav Dutta</a> · <a href=\"https://profiles.wordpress.org/rcreators/\">Rishi Mehta</a> · <a href=\"https://profiles.wordpress.org/rishishah/\">Rishi Shah</a> · <a href=\"https://profiles.wordpress.org/rishit30g/\">Rishit Gupta</a> · <a href=\"https://profiles.wordpress.org/rkyburz/\">rkyburz</a> · <a href=\"https://profiles.wordpress.org/noisysocks/\">Robert Anderson</a> · <a href=\"https://profiles.wordpress.org/miqrogroove/\">Robert Chapin</a> · <a href=\"https://profiles.wordpress.org/robertghetau/\">Robert Ghetau</a> · <a href=\"https://profiles.wordpress.org/harmr/\">Robert Seyfriedsberger</a> · <a href=\"https://profiles.wordpress.org/robertstaddon/\">robertstaddon</a> · <a href=\"https://profiles.wordpress.org/robinmartijn/\">Robin Martijn</a> · <a href=\"https://profiles.wordpress.org/kreppar/\">Rodrigo Arias</a> · <a href=\"https://profiles.wordpress.org/rodrigosprimo/\">Rodrigo Primo</a> · <a href=\"https://profiles.wordpress.org/rogierlankhorst/\">Rogier Lankhorst</a> · <a href=\"https://profiles.wordpress.org/geekofshire/\">Rohan Jha</a> · <a href=\"https://profiles.wordpress.org/rohitmathur7/\">rohitmathur7</a> · <a href=\"https://profiles.wordpress.org/rohjay/\">rohjay</a> · <a href=\"https://profiles.wordpress.org/room34/\">room34</a> · <a href=\"https://profiles.wordpress.org/rotemg/\">Rotem Gelbart</a> · <a href=\"https://profiles.wordpress.org/lev0/\">Roy Orbitson</a> · <a href=\"https://profiles.wordpress.org/roytanck/\">Roy Tanck</a> · <a href=\"https://profiles.wordpress.org/roybellingan/\">roybellingan</a> · <a href=\"https://profiles.wordpress.org/rseigel/\">rseigel</a> · <a href=\"https://profiles.wordpress.org/ruchirj/\">Ruchir Goswami</a> · <a href=\"https://profiles.wordpress.org/rudrakshigupta/\">Rudrakshi Gupta</a> · <a href=\"https://profiles.wordpress.org/rupesh5438/\">Rupesh Patil</a> · <a href=\"https://profiles.wordpress.org/rupw/\">rupw</a> · <a href=\"https://profiles.wordpress.org/ruturajraval2305/\">Ruturaj Raval</a> · <a href=\"https://profiles.wordpress.org/rvoigt/\">rvoigt</a> · <a href=\"https://profiles.wordpress.org/bookdude13/\">Ryan Fredlund</a> · <a href=\"https://profiles.wordpress.org/ryanhellyer/\">Ryan Hellyer</a> · <a href=\"https://profiles.wordpress.org/rmccue/\">Ryan McCue</a> · <a href=\"https://profiles.wordpress.org/welcher/\">Ryan Welcher</a> · <a href=\"https://profiles.wordpress.org/looswebstudio/\">Ryo</a> · <a href=\"https://profiles.wordpress.org/sppramodh/\">S P Pramodh</a> · <a href=\"https://profiles.wordpress.org/sebastienserre/\">Sébastien SERRE</a> · <a href=\"https://profiles.wordpress.org/sergiomdgomes/\">Sérgio Gomes</a> · <a href=\"https://profiles.wordpress.org/soean/\">Sören Wünsch</a> · <a href=\"https://profiles.wordpress.org/sabbir1991/\">Sabbir Ahmed</a> · <a href=\"https://profiles.wordpress.org/sabrineg/\">sabrineg</a> · <a href=\"https://profiles.wordpress.org/isaeedam/\">Saeed Piri</a> · <a href=\"https://profiles.wordpress.org/sagarlakhani/\">Sagar Lakhani</a> · <a href=\"https://profiles.wordpress.org/sagarprajapati/\">Sagar Prajapati</a> · <a href=\"https://profiles.wordpress.org/mi5t4n/\">Sagar Tamang</a> · <a href=\"https://profiles.wordpress.org/sailpete/\">sailpete</a> · <a href=\"https://profiles.wordpress.org/sainathpoojary/\">Sainath Poojary</a> · <a href=\"https://profiles.wordpress.org/sallyruchman/\">sally</a> · <a href=\"https://profiles.wordpress.org/samiamnot/\">samiamnot</a> · <a href=\"https://profiles.wordpress.org/viralsampat/\">Sampat Viral</a> · <a href=\"https://profiles.wordpress.org/ranafge/\">Samsul Islam Rana</a> · <a href=\"https://profiles.wordpress.org/otto42/\">Samuel Wood (Otto)</a> · <a href=\"https://profiles.wordpress.org/codexdemon/\">Sanyogg Shelar</a> · <a href=\"https://profiles.wordpress.org/mikachan/\">Sarah Norris</a> · <a href=\"https://profiles.wordpress.org/sarathar/\">Sarath AR</a> · <a href=\"https://profiles.wordpress.org/sarthaknagoshe2002/\">Sarthak Nagoshe</a> · <a href=\"https://profiles.wordpress.org/sathyapulse/\">Sathiya Venkatesan</a> · <a href=\"https://profiles.wordpress.org/sfougnier/\">Saul Fougnier</a> · <a href=\"https://profiles.wordpress.org/saurabhdhariwal/\">saurabh.dhariwal</a> · <a href=\"https://profiles.wordpress.org/saxonafletcher/\">Saxon Fletcher</a> · <a href=\"https://profiles.wordpress.org/infosatech/\">Sayan Datta</a> · <a href=\"https://profiles.wordpress.org/sayedulsayem/\">Sayedul Sayem</a> · <a href=\"https://profiles.wordpress.org/sbathompson/\">sbathompson</a> · <a href=\"https://profiles.wordpress.org/paragoninitiativeenterprises/\">Scott Arciszewski</a> · <a href=\"https://profiles.wordpress.org/scribu/\">scribu</a> · <a href=\"https://profiles.wordpress.org/sean212/\">Sean Fisher</a> · <a href=\"https://profiles.wordpress.org/seanlanglands/\">seanlanglands</a> · <a href=\"https://profiles.wordpress.org/sebastianpisula/\">Sebastian Pisula</a> · <a href=\"https://profiles.wordpress.org/seifradwane/\">Seif Radwane</a> · <a href=\"https://profiles.wordpress.org/sergeybiryukov/\">Sergey Biryukov</a> · <a href=\"https://profiles.wordpress.org/sergiogutierrez/\">sergiogutierrez</a> · <a href=\"https://profiles.wordpress.org/smrubenstein/\">Seth Rubenstein</a> · <a href=\"https://profiles.wordpress.org/shadialaghbari/\">Shadi G شادي جـ</a> · <a href=\"https://profiles.wordpress.org/shailu25/\">Shail Mehta</a> · <a href=\"https://profiles.wordpress.org/sh4lin/\">Shalin Shah</a> · <a href=\"https://profiles.wordpress.org/shanemuir/\">Shane Muirhead</a> · <a href=\"https://profiles.wordpress.org/spdft/\">Shoe</a> · <a href=\"https://profiles.wordpress.org/shraddhagore/\">Shraddha Gore</a> · <a href=\"https://profiles.wordpress.org/shreyashd21/\">shreyashd21</a> · <a href=\"https://profiles.wordpress.org/shub07/\">Shubham Kumar Bansal</a> · <a href=\"https://profiles.wordpress.org/iamshubhamsp/\">Shubham Patil</a> · <a href=\"https://profiles.wordpress.org/shulard/\">shulard</a> · <a href=\"https://profiles.wordpress.org/shyamkariya/\">Shyam Kariya</a> · <a href=\"https://profiles.wordpress.org/nomnom99/\">Siddharth Thevaril</a> · <a href=\"https://profiles.wordpress.org/siliconforks/\">siliconforks</a> · <a href=\"https://profiles.wordpress.org/simo_m/\">Simone Maranzana</a> · <a href=\"https://profiles.wordpress.org/sirlouen/\">SirLouen</a> · <a href=\"https://profiles.wordpress.org/sjefen6/\">sjefen6</a> · <a href=\"https://profiles.wordpress.org/slaffik/\">Slava Abakumov</a> · <a href=\"https://profiles.wordpress.org/mslavco/\">Slavco Mihajloski</a> · <a href=\"https://profiles.wordpress.org/smerriman/\">smerriman</a> · <a href=\"https://profiles.wordpress.org/snehapatil02/\">Sneha Patil</a> · <a href=\"https://profiles.wordpress.org/sourabhjain/\">Sourabh Jain</a> · <a href=\"https://profiles.wordpress.org/sourav08/\">Sourav Pahwa</a> · <a href=\"https://profiles.wordpress.org/soyebsalar/\">soyeb salar</a> · <a href=\"https://profiles.wordpress.org/spencerfinnell/\">Spencer Finnell</a> · <a href=\"https://profiles.wordpress.org/spenserhale/\">Spenser Hale</a> · <a href=\"https://profiles.wordpress.org/spmultidots/\">spmultidots</a> · <a href=\"https://profiles.wordpress.org/spncr/\">spncr</a> · <a href=\"https://profiles.wordpress.org/srikat/\">Sridhar Katakam</a> · <a href=\"https://profiles.wordpress.org/stefahn/\">Stefan Seidner-Britting</a> · <a href=\"https://profiles.wordpress.org/ryokuhi/\">Stefano Minoia</a> · <a href=\"https://profiles.wordpress.org/stein2nd/\">stein2nd</a> · <a href=\"https://profiles.wordpress.org/sabernhardt/\">Stephen Bernhardt</a> · <a href=\"https://profiles.wordpress.org/netweb/\">Stephen Edgar</a> · <a href=\"https://profiles.wordpress.org/dufresnesteven/\">Steve Dufresne</a> · <a href=\"https://profiles.wordpress.org/stimul/\">stimul</a> · <a href=\"https://profiles.wordpress.org/strarsis/\">strarsis</a> · <a href=\"https://profiles.wordpress.org/stuartmcalpine/\">Stuart McAlpine</a> · <a href=\"https://profiles.wordpress.org/subodhrajpopat/\">Subodh Rajpopat</a> · <a href=\"https://profiles.wordpress.org/subrataemfluence/\">Subrata Sarkar</a> · <a href=\"https://profiles.wordpress.org/sketchboy/\">SUHAS SUTAR</a> · <a href=\"https://profiles.wordpress.org/sukhendu2002/\">Sukhendu Sekhar Guria</a> · <a href=\"https://profiles.wordpress.org/sumitbagthariya16/\">Sumit Bagthariya</a> · <a href=\"https://profiles.wordpress.org/sumitsingh/\">Sumit Singh</a> · <a href=\"https://profiles.wordpress.org/csesumonpro/\">Sumon Sarker</a> · <a href=\"https://profiles.wordpress.org/sunil25393/\">SunilPrajapati</a> · <a href=\"https://profiles.wordpress.org/surajswalstar/\">Suraj Sutar</a> · <a href=\"https://profiles.wordpress.org/swalkinshaw/\">swalkinshaw</a> · <a href=\"https://profiles.wordpress.org/cybr/\">Sybre Waaijer</a> · <a href=\"https://profiles.wordpress.org/synchro/\">Synchro</a> · <a href=\"https://profiles.wordpress.org/tschwarz-1/\">t.schwarz</a> · <a href=\"https://profiles.wordpress.org/tacoverdo/\">Taco Verdonschot</a> · <a href=\"https://profiles.wordpress.org/gonom9/\">Taegon Kim</a> · <a href=\"https://profiles.wordpress.org/iamtakashi/\">Takashi Irie</a> · <a href=\"https://profiles.wordpress.org/inc2734/\">Takashi Kitajima</a> · <a href=\"https://profiles.wordpress.org/takayukister/\">Takayuki Miyoshi</a> · <a href=\"https://profiles.wordpress.org/takuword/\">takuword</a> · <a href=\"https://profiles.wordpress.org/karmatosed/\">Tammie Lister</a> · <a href=\"https://profiles.wordpress.org/devtanbir/\">Tanbir Ahmod</a> · <a href=\"https://profiles.wordpress.org/voboghure/\">Tapan Kumer Das</a> · <a href=\"https://profiles.wordpress.org/th23/\">th23</a> · <a href=\"https://profiles.wordpress.org/thakordarshil/\">Thakor Darshil</a> · <a href=\"https://profiles.wordpress.org/thelmachido/\">thelmachido a11n</a> · <a href=\"https://profiles.wordpress.org/thomaswm/\">thomaswm</a> · <a href=\"https://profiles.wordpress.org/thrijith/\">Thrijith Thankachan</a> · <a href=\"https://profiles.wordpress.org/tiagogoncalves/\">tiago</a> · <a href=\"https://profiles.wordpress.org/tigriweb/\">TigriWeb</a> · <a href=\"https://profiles.wordpress.org/tillkruess/\">Till Krüss</a> · <a href=\"https://profiles.wordpress.org/tb1909/\">Tim Brathärig</a> · <a href=\"https://profiles.wordpress.org/dontfeedthecode/\">Tim Sheehan</a> · <a href=\"https://profiles.wordpress.org/timwhitlock/\">Tim W</a> · <a href=\"https://profiles.wordpress.org/sippis/\">Timi Wahalahti</a> · <a href=\"https://profiles.wordpress.org/spaceshipone/\">Timothée Brosille</a> · <a href=\"https://profiles.wordpress.org/timothyblynjacobs/\">Timothy Jacobs</a> · <a href=\"https://profiles.wordpress.org/tkama/\">Timur Kamaev</a> · <a href=\"https://profiles.wordpress.org/tirth03/\">Tirth Doshi</a> · <a href=\"https://profiles.wordpress.org/tjarrett/\">TJarrett</a> · <a href=\"https://profiles.wordpress.org/tobiasbg/\">Tobias Bäthge</a> · <a href=\"https://profiles.wordpress.org/tobifjellner/\">tobifjellner (Tor-Bjorn “Tobi” Fjellner)</a> · <a href=\"https://profiles.wordpress.org/tgsrvrs/\">Tom Gugel</a> · <a href=\"https://profiles.wordpress.org/tommusrhodus/\">Tom Rhodes</a> · <a href=\"https://profiles.wordpress.org/shimotomoki/\">Tomoki Shimomura</a> · <a href=\"https://profiles.wordpress.org/skithund/\">Toni Viemerö</a> · <a href=\"https://profiles.wordpress.org/hellofromtonya/\">Tonya Mork</a> · <a href=\"https://profiles.wordpress.org/toro_unit/\">Toro_Unit (Hiroshi Urabe)</a> · <a href=\"https://profiles.wordpress.org/zodiac1978/\">Torsten Landsiedel</a> · <a href=\"https://profiles.wordpress.org/tropicalista/\">tropicalista</a> · <a href=\"https://profiles.wordpress.org/areziaal/\">Troy Chaplin</a> · <a href=\"https://profiles.wordpress.org/truptikanzariya/\">Trupti Kanzariya</a> · <a href=\"https://profiles.wordpress.org/trushaamin/\">Trusha</a> · <a href=\"https://profiles.wordpress.org/tunetheweb/\">tunetheweb</a> · <a href=\"https://profiles.wordpress.org/dinhtungdu/\">Tung Du</a> · <a href=\"https://profiles.wordpress.org/tusharaddweb/\">Tushar Patel</a> · <a href=\"https://profiles.wordpress.org/tyb/\">Ty</a> · <a href=\"https://profiles.wordpress.org/tysonlmao/\">tysonlmao</a> · <a href=\"https://profiles.wordpress.org/ugyensupport/\">Ugyen Dorji</a> · <a href=\"https://profiles.wordpress.org/umeshsinghin/\">Umesh Singh</a> · <a href=\"https://profiles.wordpress.org/unsalkorkmaz/\">Unsal Korkmaz</a> · <a href=\"https://profiles.wordpress.org/up1512001/\">up1512001</a> · <a href=\"https://profiles.wordpress.org/upadalavipul/\">upadalavipul</a> · <a href=\"https://profiles.wordpress.org/utrenkner/\">utrenkner</a> · <a href=\"https://profiles.wordpress.org/eboxnet/\">Vagelis</a> · <a href=\"https://profiles.wordpress.org/vaibhavsweb/\">Vaibhav Singh Web</a> · <a href=\"https://profiles.wordpress.org/vaibhav2527/\">Vaibhav Tukaram Nawale</a> · <a href=\"https://profiles.wordpress.org/twvania/\">Vania</a> · <a href=\"https://profiles.wordpress.org/okvee/\">vee</a> · <a href=\"https://profiles.wordpress.org/vevas/\">Vegard S.</a> · <a href=\"https://profiles.wordpress.org/vgnavada/\">vgnavada</a> · <a href=\"https://profiles.wordpress.org/vcanales/\">Vicente Canales</a> · <a href=\"https://profiles.wordpress.org/fylgjur/\">Victoria – a11n</a> · <a href=\"https://profiles.wordpress.org/gvgvgvijayan/\">Vijayan</a> · <a href=\"https://profiles.wordpress.org/vijaysinh9094/\">Vijaysinh Zala</a> · <a href=\"https://profiles.wordpress.org/szepeviktor/\">Viktor Szépe</a> · <a href=\"https://profiles.wordpress.org/vineet2003/\">Vinit</a> · <a href=\"https://profiles.wordpress.org/vipulgupta003/\">Vipul Gupta</a> · <a href=\"https://profiles.wordpress.org/vipulpatil/\">Vipul Patil</a> · <a href=\"https://profiles.wordpress.org/virgildia/\">Virgildia</a> · <a href=\"https://profiles.wordpress.org/virgar/\">Virginie Garnier</a> · <a href=\"https://profiles.wordpress.org/virginienacci/\">virginienacci</a> · <a href=\"https://profiles.wordpress.org/vishy-moghan/\">Vishy Moghan</a> · <a href=\"https://profiles.wordpress.org/vivekawsm/\">vivekawsm</a> · <a href=\"https://profiles.wordpress.org/vrishabhsk/\">Vrishabh Jasani</a> · <a href=\"https://profiles.wordpress.org/vykesmac/\">vykesmac</a> · <a href=\"https://profiles.wordpress.org/wadowad/\">wadowad</a> · <a href=\"https://profiles.wordpress.org/pctevree/\">Web-Pepper</a> · <a href=\"https://profiles.wordpress.org/webmandesign/\">WebMan Design | Oliver Juhas</a> · <a href=\"https://profiles.wordpress.org/west7/\">Wes Theron</a> · <a href=\"https://profiles.wordpress.org/westonruter/\">Weston Ruter</a> · <a href=\"https://profiles.wordpress.org/whaze/\">whaze</a> · <a href=\"https://profiles.wordpress.org/skorasaurus/\">Will Skora</a> · <a href=\"https://profiles.wordpress.org/williampatton/\">williampatton</a> · <a href=\"https://profiles.wordpress.org/wongjn/\">wongjn</a> · <a href=\"https://profiles.wordpress.org/worldweb/\">World Web Technology</a> · <a href=\"https://profiles.wordpress.org/wpgerd/\">wpgerd</a> · <a href=\"https://profiles.wordpress.org/wwdes/\">wwdes</a> · <a href=\"https://profiles.wordpress.org/xate/\">xate</a> · <a href=\"https://profiles.wordpress.org/xavilc/\">xavilc</a> · <a href=\"https://profiles.wordpress.org/xpurichan/\">xpurichan</a> · <a href=\"https://profiles.wordpress.org/yahil/\">Yahil Madakiya</a> · <a href=\"https://profiles.wordpress.org/yaniiliev/\">Yani</a> · <a href=\"https://profiles.wordpress.org/yashrocz/\">Yash Kukreja</a> · <a href=\"https://profiles.wordpress.org/yellowafterlife/\">yellowafterlife</a> · <a href=\"https://profiles.wordpress.org/yogeshbhutkar/\">Yogesh Bhutkar</a> · <a href=\"https://profiles.wordpress.org/fierevere/\">Yui</a> · <a href=\"https://profiles.wordpress.org/yuliyan/\">Yuliyan Slavchev</a> · <a href=\"https://profiles.wordpress.org/omaeyusuke/\">yuu</a> · <a href=\"https://profiles.wordpress.org/zaoyao/\">zaoyao</a> · <a href=\"https://profiles.wordpress.org/zargarov/\">Zargarov</a> · <a href=\"https://profiles.wordpress.org/zebulan/\">Zebulan Stanphill</a> · <a href=\"https://profiles.wordpress.org/zeelthakkar/\">zeelthakkar</a> · <a href=\"https://profiles.wordpress.org/zunaid321/\">Zunaid Amin</a> · <a href=\"https://profiles.wordpress.org/haozi/\">耗子</a></p>\n</div>\n\n\n\n<h3 class=\"wp-block-heading\">Merci aux personnes ayant contribué à traduire WordPress&nbsp;6.8 en français</h3>\n\n\n\n<p>WordPress est un projet international et la version 6.8 est déjà complètement disponible dans plus de 40 langues différentes.</p>\n\n\n\n<p>Nous souhaitons remercier ici les personnes ayant participé à la traduction de WordPress&nbsp;6.8 en français&nbsp;:</p>\n\n\n\n<p><a href=\"https://profiles.wordpress.org/fxbenard\">FX Benard</a>, <a href=\"https://profiles.wordpress.org/jdy68\">Jenny Dupuy</a>, <a href=\"https://profiles.wordpress.org/audrasjb\">Jb Audras</a>, <a href=\"https://profiles.wordpress.org/beryldlg\">Béryl de La Grandière</a>,&nbsp;<a href=\"https://profiles.wordpress.org/clementpolito\">Clément Polito</a>,&nbsp;<a href=\"https://profiles.wordpress.org/karine-wendling\">karine wendling</a>,&nbsp;<a href=\"https://profiles.wordpress.org/marineevain\">Marine EVAIN</a>,&nbsp;<a href=\"https://profiles.wordpress.org/mumuu000\">mumuu000</a>,&nbsp;<a href=\"https://profiles.wordpress.org/pasglop\">pasglop</a>,&nbsp;<a href=\"https://profiles.wordpress.org/rodrigoq\">rodrigoq</a>,&nbsp;<a href=\"https://profiles.wordpress.org/sebastienserre\">Sébastien SERRE</a>,&nbsp;<a href=\"https://profiles.wordpress.org/spaceshipone\">Timothée Brosille</a>,&nbsp;<a href=\"https://profiles.wordpress.org/translationsbyautomattic\">Translations by Automattic</a>, et&nbsp;<a href=\"https://profiles.wordpress.org/wptranslationsorg\">WP-Translations</a>.</p>\n\n\n\n<hr class=\"wp-block-separator has-alpha-channel-opacity\" />\n\n\n\n<p class=\"has-small-font-size\">Article rédigé par <a href=\"https://profiles.wordpress.org/audrasjb/\">Jb Audras</a>. Merci à <a href=\'https://profiles.wordpress.org/jdy68/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>jdy68</a> et <a href=\'https://profiles.wordpress.org/nlegagneur/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>nlegagneur</a> pour leur relecture.</p>\n\n\n\n<p><br></p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:30:\"com-wordpress:feed-additions:1\";a:1:{s:7:\"post-id\";a:1:{i:0;a:5:{s:4:\"data\";s:4:\"3335\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:3;a:6:{s:4:\"data\";s:60:\"\n		\n		\n		\n		\n		\n				\n		\n		\n\n					\n										\n					\n		\n		\n			\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:4:{s:0:\"\";a:6:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:50:\"Guide des changements techniques de WordPress 6.8\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:86:\"https://fr.wordpress.org/2025/03/28/guide-des-changements-techniques-de-wordpress-6-8/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Fri, 28 Mar 2025 07:53:21 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:2:{i:0;a:5:{s:4:\"data\";s:5:\"Guide\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:1;a:5:{s:4:\"data\";s:31:\"Nouvelles versions de WordPress\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:32:\"https://fr.wordpress.org/?p=3310\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:100:\"Découvrez les changements techniques qui arrivent le 15 avril 2025 avec la version 6.8 de WordPress\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:9:\"Jb Audras\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:35090:\"\n<figure class=\"wp-block-image alignfull size-full\"><a href=\"https://fr.wordpress.org/files/2025/03/wordpress-6-8-guide-changements-techniques.png\"><img loading=\"lazy\" decoding=\"async\" width=\"2156\" height=\"1084\" src=\"https://fr.wordpress.org/files/2025/03/wordpress-6-8-guide-changements-techniques.png\" alt=\"\" class=\"wp-image-3312\" srcset=\"https://fr.wordpress.org/files/2025/03/wordpress-6-8-guide-changements-techniques.png 2156w, https://fr.wordpress.org/files/2025/03/wordpress-6-8-guide-changements-techniques-300x151.png 300w, https://fr.wordpress.org/files/2025/03/wordpress-6-8-guide-changements-techniques-1024x515.png 1024w, https://fr.wordpress.org/files/2025/03/wordpress-6-8-guide-changements-techniques-768x386.png 768w, https://fr.wordpress.org/files/2025/03/wordpress-6-8-guide-changements-techniques-1536x772.png 1536w, https://fr.wordpress.org/files/2025/03/wordpress-6-8-guide-changements-techniques-2048x1030.png 2048w\" sizes=\"auto, (max-width: 2156px) 100vw, 2156px\" /></a></figure>\n\n\n\n<div class=\"wp-block-group has-small-font-size is-content-justification-right is-nowrap is-layout-flex wp-container-core-group-is-layout-b315634e wp-block-group-is-layout-flex\">\n<p>Temps de lecture estimé&nbsp;:&nbsp;</p>\n\n\n<div class=\"wp-block-post-time-to-read\">7 minutes</div></div>\n\n\n\n<p>WordPress 6.8 comprend la résolution de plus de&nbsp;<a href=\"https://core.trac.wordpress.org/query?status=closed&amp;milestone=6.8&amp;col=id&amp;col=summary&amp;col=status&amp;col=milestone&amp;col=owner&amp;col=type&amp;col=priority&amp;order=priority\">300 tickets sur Trac</a>, dont&nbsp;<a href=\"https://core.trac.wordpress.org/query?status=closed&amp;type=enhancement&amp;type=feature+request&amp;milestone=6.8&amp;col=id&amp;col=summary&amp;col=type&amp;col=status&amp;col=milestone&amp;col=owner&amp;col=priority&amp;order=priority\">104 améliorations et nouvelles fonctionnalités</a>,&nbsp;<a href=\"https://core.trac.wordpress.org/query?status=closed&amp;type=defect+(bug)&amp;milestone=6.8&amp;col=id&amp;col=summary&amp;col=type&amp;col=status&amp;col=milestone&amp;col=owner&amp;col=priority&amp;order=priority\">plus de 170 corrections de bogues</a>. Cette version comprend&nbsp;<a href=\"https://core.trac.wordpress.org/query?status=closed&amp;focuses=~performance&amp;milestone=6.8&amp;col=id&amp;col=summary&amp;col=status&amp;col=milestone&amp;col=owner&amp;col=type&amp;col=priority&amp;order=priority\">23 tickets focalisés sur les performances</a>,&nbsp;<a href=\"https://core.trac.wordpress.org/query?status=closed&amp;focuses=~accessibility&amp;milestone=6.8&amp;col=id&amp;col=summary&amp;col=status&amp;col=milestone&amp;col=owner&amp;col=type&amp;col=priority&amp;order=priority\">34 sur l’accessibilité</a>&nbsp;et&nbsp;<a href=\"https://core.trac.wordpress.org/query?status=closed&amp;focuses=~coding-standards&amp;milestone=6.8&amp;col=id&amp;col=summary&amp;col=status&amp;col=milestone&amp;col=owner&amp;col=type&amp;col=priority&amp;order=priority\">16 sur la modernisation du code et la conformité aux standards de code</a>. Les modifications de la version 6.8 concernent&nbsp;<a href=\"https://core.trac.wordpress.org/query?status=closed&amp;milestone=6.8&amp;group=component&amp;max=9999&amp;col=id&amp;col=summary&amp;col=status&amp;col=milestone&amp;col=owner&amp;col=type&amp;col=priority&amp;order=priority\">43 composants du cœur du CMS</a>.</p>\n\n\n\n<p>Cette version comprend aussi&nbsp;<a href=\"https://github.com/WordPress/gutenberg/issues?q=label%3A%22%5BType%5D%20Enhancement%22%20AND%20state%3Aclosed%20AND%20milestone%3A%22Gutenberg%2019.4%22%20OR%20label%3A%22%5BType%5D%20Enhancement%22%20AND%20state%3Aclosed%20AND%20milestone%3A%22Gutenberg%2019.5%22%20OR%20label%3A%22%5BType%5D%20Enhancement%22%20AND%20state%3Aclosed%20AND%20milestone%3A%22Gutenberg%2019.6%22%20OR%20label%3A%22%5BType%5D%20Enhancement%22%20AND%20state%3Aclosed%20AND%20milestone%3A%22Gutenberg%2019.7%22%20OR%20label%3A%22%5BType%5D%20Enhancement%22%20AND%20state%3Aclosed%20AND%20milestone%3A%22Gutenberg%2019.8%22%20OR%20label%3A%22%5BType%5D%20Enhancement%22%20AND%20state%3Aclosed%20AND%20milestone%3A%22Gutenberg%2019.9%22%20OR%20label%3A%22%5BType%5D%20Enhancement%22%20AND%20state%3Aclosed%20AND%20milestone%3A%22Gutenberg%2020.0%22%20OR%20label%3A%22%5BType%5D%20Enhancement%22%20AND%20state%3Aclosed%20AND%20milestone%3A%22Gutenberg%2020.1%22%20OR%20label%3A%22%5BType%5D%20Enhancement%22%20AND%20state%3Aclosed%20AND%20milestone%3A%22Gutenberg%2020.2%22%20OR%20label%3A%22%5BType%5D%20Enhancement%22%20AND%20state%3Aclosed%20AND%20milestone%3A%22Gutenberg%2020.3%22%20OR%20label%3A%22%5BType%5D%20Enhancement%22%20AND%20state%3Aclosed%20AND%20milestone%3A%22Gutenberg%2020.4%22%20\">387 améliorations</a>,&nbsp;<a href=\"https://github.com/WordPress/gutenberg/issues?q=label%3A%22%5BType%5D%20Bug%22%20AND%20state%3Aclosed%20AND%20milestone%3A%22Gutenberg%2019.4%22%20OR%20label%3A%22%5BType%5D%20Bug%22%20AND%20state%3Aclosed%20AND%20milestone%3A%22Gutenberg%2019.5%22%20OR%20label%3A%22%5BType%5D%20Bug%22%20AND%20state%3Aclosed%20AND%20milestone%3A%22Gutenberg%2019.6%22%20OR%20label%3A%22%5BType%5D%20Bug%22%20AND%20state%3Aclosed%20AND%20milestone%3A%22Gutenberg%2019.7%22%20OR%20label%3A%22%5BType%5D%20Bug%22%20AND%20state%3Aclosed%20AND%20milestone%3A%22Gutenberg%2019.8%22%20OR%20label%3A%22%5BType%5D%20Bug%22%20AND%20state%3Aclosed%20AND%20milestone%3A%22Gutenberg%2019.9%22%20OR%20label%3A%22%5BType%5D%20Bug%22%20AND%20state%3Aclosed%20AND%20milestone%3A%22Gutenberg%2020.0%22%20OR%20label%3A%22%5BType%5D%20Bug%22%20AND%20state%3Aclosed%20AND%20milestone%3A%22Gutenberg%2020.1%22%20OR%20label%3A%22%5BType%5D%20Bug%22%20AND%20state%3Aclosed%20AND%20milestone%3A%22Gutenberg%2020.2%22%20OR%20label%3A%22%5BType%5D%20Bug%22%20AND%20state%3Aclosed%20AND%20milestone%3A%22Gutenberg%2020.3%22%20OR%20label%3A%22%5BType%5D%20Bug%22%20AND%20state%3Aclosed%20AND%20milestone%3A%22Gutenberg%2020.4%22%20\">525 corrections de bogues</a>&nbsp;et&nbsp;<a href=\"https://github.com/WordPress/gutenberg/issues?q=label%3A%22%5BFocus%5D%20Accessibility%20(a11y)%22%20AND%20state%3Aclosed%20AND%20milestone%3A%22Gutenberg%2019.4%22%20OR%20label%3A%22%5BFocus%5D%20Accessibility%20(a11y)%22%20AND%20state%3Aclosed%20AND%20milestone%3A%22Gutenberg%2019.5%22%20OR%20label%3A%22%5BFocus%5D%20Accessibility%20(a11y)%22%20AND%20state%3Aclosed%20AND%20milestone%3A%22Gutenberg%2019.6%22%20OR%20label%3A%22%5BFocus%5D%20Accessibility%20(a11y)%22%20AND%20state%3Aclosed%20AND%20milestone%3A%22Gutenberg%2019.7%22%20OR%20label%3A%22%5BFocus%5D%20Accessibility%20(a11y)%22%20AND%20state%3Aclosed%20AND%20milestone%3A%22Gutenberg%2019.8%22%20OR%20label%3A%22%5BFocus%5D%20Accessibility%20(a11y)%22%20AND%20state%3Aclosed%20AND%20milestone%3A%22Gutenberg%2019.9%22%20OR%20label%3A%22%5BFocus%5D%20Accessibility%20(a11y)%22%20AND%20state%3Aclosed%20AND%20milestone%3A%22Gutenberg%2020.0%22%20OR%20label%3A%22%5BFocus%5D%20Accessibility%20(a11y)%22%20AND%20state%3Aclosed%20AND%20milestone%3A%22Gutenberg%2020.1%22%20OR%20label%3A%22%5BFocus%5D%20Accessibility%20(a11y)%22%20AND%20state%3Aclosed%20AND%20milestone%3A%22Gutenberg%2020.2%22%20OR%20label%3A%22%5BFocus%5D%20Accessibility%20(a11y)%22%20AND%20state%3Aclosed%20AND%20milestone%3A%22Gutenberg%2020.3%22%20OR%20label%3A%22%5BFocus%5D%20Accessibility%20(a11y)%22%20AND%20state%3Aclosed%20AND%20milestone%3A%22Gutenberg%2020.4%22%20\">70 améliorations d’accessibilité</a>&nbsp;sur l’éditeur (projet Gutenberg).</p>\n\n\n\n<p class=\"is-style-serif has-charcoal-0-color has-text-color has-background has-link-color wp-elements-37003aee4fdc33a177f14a048ba187af\" style=\"background:linear-gradient(135deg,rgb(242,255,240) 0%,rgb(255,252,223) 50%,rgb(255,211,218) 100%)\">Ce guide décrit les principaux changements techniques qui arrivent sur WordPress&nbsp;6.8, dont la sortie est prévue le 15 avril 2025.</p>\n\n\n\n<p>Tous les liens de cet article pointent vers des notes de développement rédigées en anglais. L’objectif est de fournir un panorama général des changements techniques apportés par cette version, en français, puis de diriger les personnes qui souhaitent en savoir plus vers les notes de développement en anglais.</p>\n\n\n\n<p class=\"has-pomegrade-1-color has-text-color has-link-color wp-elements-25a8d26d528a99d7724a8a001a372b5a\"><a href=\"https://make.wordpress.org/core/6-8/\">En savoir plus sur la feuille de route et le calendrier de sortie de WP&nbsp;6.8</a></p>\n\n\n\n<h2 class=\"wp-block-heading\">Changements concernant l’éditeur et le projet Gutenberg</h2>\n\n\n\n<p>Une vaste gamme d&rsquo;améliorations concerne les performances, l&rsquo;expérience de développement et l’interface d&rsquo;édition générale. Cette version introduit de nouveaux outils comme le filtre <code>should_load_block_assets_on_demand</code> pour optimiser le chargement des ressources, un système d&rsquo;avertissement utilisable lorsque vous employez <code>useSelect</code>, et un système d&rsquo;enregistrement des blocs plus efficace. Elle contient aussi une mise à jour des outils de design disponibles pour chaque bloc, affine les composants de l&rsquo;interface et propose une série de changements divers qui améliorent la cohérence et l&rsquo;extensibilité de l&rsquo;éditeur. Ces changements contribuent à un flux de travail de développement plus fluide et à un environnement d&rsquo;édition plus adaptatif.</p>\n\n\n\n<h3 class=\"wp-block-heading\">Performances et chargement des ressources</h3>\n\n\n\n<p>De nouveaux outils aident les développeuses et les développeurs à créer des expériences d&rsquo;utilisation des blocs plus performantes. Un avertissement dans le crochet <code>useSelect</code> alerte lorsque les sélecteurs sont définis en ligne, un problème courant qui peut entraîner un recalcul du rendu inutile. Le filtre <code>should_load_block_assets_on_demand</code> offre un contrôle précis sur le fait que les ressources de bloc soient mises en file d&rsquo;attente globalement ou uniquement en cas de besoin, ce qui permet de réduire le CSS et le JavaScript inutilisés sur l&rsquo;interface <em>front</em>. Tous ces changements favorisent des flux de travail de développement plus efficaces et optimisés.</p>\n\n\n\n<figure class=\"wp-block-embed is-type-wp-embed is-provider-make-wordpress-core wp-block-embed-make-wordpress-core\"><div class=\"wp-block-embed__wrapper\">\n<blockquote class=\"wp-embedded-content\" data-secret=\"fhFlkFOCIl\"><a href=\"https://make.wordpress.org/core/2025/03/12/data-a-helpful-performance-warning-for-developers-in-the-useselect-hook/\">Data: A helpful performance warning for developers in the &#8216;useSelect&#8217; hook</a></blockquote><iframe loading=\"lazy\" class=\"wp-embedded-content\" sandbox=\"allow-scripts\" security=\"restricted\"  title=\"&#8220;Data: A helpful performance warning for developers in the &#8216;useSelect&#8217; hook&#8221; &#8212; Make WordPress Core\" src=\"https://make.wordpress.org/core/2025/03/12/data-a-helpful-performance-warning-for-developers-in-the-useselect-hook/embed/#?secret=450zF7Nret#?secret=fhFlkFOCIl\" data-secret=\"fhFlkFOCIl\" width=\"500\" height=\"282\" frameborder=\"0\" marginwidth=\"0\" marginheight=\"0\" scrolling=\"no\"></iframe>\n</div></figure>\n\n\n\n<figure class=\"wp-block-embed is-type-wp-embed is-provider-make-wordpress-core wp-block-embed-make-wordpress-core\"><div class=\"wp-block-embed__wrapper\">\n<blockquote class=\"wp-embedded-content\" data-secret=\"hB2FZegD7B\"><a href=\"https://make.wordpress.org/core/2025/03/24/new-filter-should_load_block_assets_on_demand-in-6-8/\">New filter should_load_block_assets_on_demand in 6.8</a></blockquote><iframe loading=\"lazy\" class=\"wp-embedded-content\" sandbox=\"allow-scripts\" security=\"restricted\"  title=\"&#8220;New filter &lt;code&gt;should_load_block_assets_on_demand&lt;/code&gt; in 6.8&#8221; &#8212; Make WordPress Core\" src=\"https://make.wordpress.org/core/2025/03/24/new-filter-should_load_block_assets_on_demand-in-6-8/embed/#?secret=YjASEVzB2H#?secret=hB2FZegD7B\" data-secret=\"hB2FZegD7B\" width=\"500\" height=\"282\" frameborder=\"0\" marginwidth=\"0\" marginheight=\"0\" scrolling=\"no\"></iframe>\n</div></figure>\n\n\n\n<h3 class=\"wp-block-heading\" id=\"block-and-design-tool-registration\">Gestion des blocs et outils de personnalisation disponibles pour chaque bloc</h3>\n\n\n\n<p>Les améliorations apportées à l&rsquo;enregistrement des blocs et à la visibilité des outils de conception simplifient le développement pour l&rsquo;éditeur de blocs. Une approche plus efficace de l&rsquo;enregistrement des types de blocs réduit la surcharge liée au chargement des métadonnées des blocs, en particulier dans les environnements comportant de nombreux blocs personnalisés. En complément, nous avons sorti une nouvelle version de la liste des outils de personnalisation disponibles pour chaque bloc afin d’indiquer&nbsp;<strong>pour chaque outil de personnalisation les blocs qui le prennent en charge</strong>, offrant ainsi aux développeur·euses une vision plus claire des options disponibles.</p>\n\n\n\n<figure class=\"wp-block-embed is-type-wp-embed is-provider-make-wordpress-core wp-block-embed-make-wordpress-core\"><div class=\"wp-block-embed__wrapper\">\n<blockquote class=\"wp-embedded-content\" data-secret=\"a3N8ljSVe9\"><a href=\"https://make.wordpress.org/core/2025/03/13/more-efficient-block-type-registration-in-6-8/\">More efficient block type registration in 6.8</a></blockquote><iframe loading=\"lazy\" class=\"wp-embedded-content\" sandbox=\"allow-scripts\" security=\"restricted\"  title=\"&#8220;More efficient block type registration in 6.8&#8221; &#8212; Make WordPress Core\" src=\"https://make.wordpress.org/core/2025/03/13/more-efficient-block-type-registration-in-6-8/embed/#?secret=QzNxSOMj2W#?secret=a3N8ljSVe9\" data-secret=\"a3N8ljSVe9\" width=\"500\" height=\"282\" frameborder=\"0\" marginwidth=\"0\" marginheight=\"0\" scrolling=\"no\"></iframe>\n</div></figure>\n\n\n\n<figure class=\"wp-block-embed is-type-wp-embed is-provider-make-wordpress-core wp-block-embed-make-wordpress-core\"><div class=\"wp-block-embed__wrapper\">\n<blockquote class=\"wp-embedded-content\" data-secret=\"DOAiQNo1bl\"><a href=\"https://make.wordpress.org/core/2025/03/12/roster-of-design-tools-per-block-wordpress-6-8-edition/\">Roster of design tools per block (WordPress 6.8 edition)</a></blockquote><iframe loading=\"lazy\" class=\"wp-embedded-content\" sandbox=\"allow-scripts\" security=\"restricted\"  title=\"&#8220;Roster of design tools per block (WordPress 6.8 edition)&#8221; &#8212; Make WordPress Core\" src=\"https://make.wordpress.org/core/2025/03/12/roster-of-design-tools-per-block-wordpress-6-8-edition/embed/#?secret=dsWOhWCruy#?secret=DOAiQNo1bl\" data-secret=\"DOAiQNo1bl\" width=\"500\" height=\"282\" frameborder=\"0\" marginwidth=\"0\" marginheight=\"0\" scrolling=\"no\"></iframe>\n</div></figure>\n\n\n\n<h3 class=\"wp-block-heading\" id=\"editor-ui-and-component-updates\">Interface de l’éditeur et mise à jour des composants</h3>\n\n\n\n<p>Des modifications apportées à l&rsquo;interface de l&rsquo;éditeur améliorent la cohérence, la convivialité et l&rsquo;ergonomie des différents éléments qui le composent. Les mises à jour des composants d&rsquo;interface d&rsquo;utilisation de base, tels que les boutons et les principes de mise en page, alignent le style et les comportements sur la base du nouveau système de design de WordPress. D&rsquo;autres changements concernent une meilleure cohérence du balisage dans le bloc Navigation, une prévisualisation de contenu améliorée pour le bloc Groupe et une meilleure accessibilité pour les éléments d&rsquo;interface. Ces modifications contribuent à une expérience d&rsquo;édition plus soignée et prévisible.</p>\n\n\n\n<figure class=\"wp-block-embed is-type-wp-embed is-provider-make-wordpress-core wp-block-embed-make-wordpress-core\"><div class=\"wp-block-embed__wrapper\">\n<blockquote class=\"wp-embedded-content\" data-secret=\"hCtw3Sfz1F\"><a href=\"https://make.wordpress.org/core/2025/03/25/updates-to-user-interface-components-in-wordpress-6-8/\">Updates to user-interface components in WordPress 6.8</a></blockquote><iframe loading=\"lazy\" class=\"wp-embedded-content\" sandbox=\"allow-scripts\" security=\"restricted\"  title=\"&#8220;Updates to user-interface components in WordPress 6.8&#8221; &#8212; Make WordPress Core\" src=\"https://make.wordpress.org/core/2025/03/25/updates-to-user-interface-components-in-wordpress-6-8/embed/#?secret=wgcNFOWlm3#?secret=hCtw3Sfz1F\" data-secret=\"hCtw3Sfz1F\" width=\"500\" height=\"282\" frameborder=\"0\" marginwidth=\"0\" marginheight=\"0\" scrolling=\"no\"></iframe>\n</div></figure>\n\n\n\n<figure class=\"wp-block-embed is-type-wp-embed is-provider-make-wordpress-core wp-block-embed-make-wordpress-core\"><div class=\"wp-block-embed__wrapper\">\n<blockquote class=\"wp-embedded-content\" data-secret=\"KihoQxj7Gw\"><a href=\"https://make.wordpress.org/core/2025/03/25/miscellaneous-block-editor-changes-in-wordpress-6-8/\">Miscellaneous Block Editor Changes in WordPress 6.8</a></blockquote><iframe loading=\"lazy\" class=\"wp-embedded-content\" sandbox=\"allow-scripts\" security=\"restricted\"  title=\"&#8220;Miscellaneous Block Editor Changes in WordPress 6.8&#8221; &#8212; Make WordPress Core\" src=\"https://make.wordpress.org/core/2025/03/25/miscellaneous-block-editor-changes-in-wordpress-6-8/embed/#?secret=H0oRlXN4zs#?secret=KihoQxj7Gw\" data-secret=\"KihoQxj7Gw\" width=\"500\" height=\"282\" frameborder=\"0\" marginwidth=\"0\" marginheight=\"0\" scrolling=\"no\"></iframe>\n</div></figure>\n\n\n\n<h2 class=\"wp-block-heading\" id=\"accessibility\">Accessibilité</h2>\n\n\n\n<p>Un large éventail d&rsquo;améliorations de l&rsquo;accessibilité de WordPress arrive avec la version&nbsp;6.8&nbsp;: amélioration de la navigation, de la clarté du balisage et de la prise en charge des lecteurs d&rsquo;écran dans l&rsquo;ensemble de l&rsquo;éditeur de blocs&nbsp;; amélioration de la classe <code>.screen-reader-text</code> qui offre désormais un comportement de focus plus cohérent entre les composants&nbsp;; tandis que des dizaines d&rsquo;autres améliorations concernent les structures de menu, les libellés des blocs, les infobulles et la sémantique de l&rsquo;interface. Ces changements créent une expérience d’utilisation plus inclusive et rapprochent WordPress des meilleures pratiques en matière d&rsquo;accessibilité.</p>\n\n\n\n<figure class=\"wp-block-embed is-type-wp-embed is-provider-make-wordpress-core wp-block-embed-make-wordpress-core\"><div class=\"wp-block-embed__wrapper\">\n<blockquote class=\"wp-embedded-content\" data-secret=\"lLtdPQgH11\"><a href=\"https://make.wordpress.org/core/2025/03/25/accessibility-improvements-in-wordpress-6-8/\">Accessibility Improvements in WordPress 6.8</a></blockquote><iframe loading=\"lazy\" class=\"wp-embedded-content\" sandbox=\"allow-scripts\" security=\"restricted\"  title=\"&#8220;Accessibility Improvements in WordPress 6.8&#8221; &#8212; Make WordPress Core\" src=\"https://make.wordpress.org/core/2025/03/25/accessibility-improvements-in-wordpress-6-8/embed/#?secret=ByVi2u33L9#?secret=lLtdPQgH11\" data-secret=\"lLtdPQgH11\" width=\"500\" height=\"282\" frameborder=\"0\" marginwidth=\"0\" marginheight=\"0\" scrolling=\"no\"></iframe>\n</div></figure>\n\n\n\n<figure class=\"wp-block-embed is-type-wp-embed is-provider-make-wordpress-core wp-block-embed-make-wordpress-core\"><div class=\"wp-block-embed__wrapper\">\n<blockquote class=\"wp-embedded-content\" data-secret=\"MY8vUHKQ6W\"><a href=\"https://make.wordpress.org/core/2025/03/20/changes-to-the-screen-reader-text-class-in-wordpress-6-8/\">Changes to the .screen-reader-text class in WordPress 6.8</a></blockquote><iframe loading=\"lazy\" class=\"wp-embedded-content\" sandbox=\"allow-scripts\" security=\"restricted\"  title=\"&#8220;Changes to the .screen-reader-text class in WordPress 6.8&#8221; &#8212; Make WordPress Core\" src=\"https://make.wordpress.org/core/2025/03/20/changes-to-the-screen-reader-text-class-in-wordpress-6-8/embed/#?secret=ip8giZeKP4#?secret=MY8vUHKQ6W\" data-secret=\"MY8vUHKQ6W\" width=\"500\" height=\"282\" frameborder=\"0\" marginwidth=\"0\" marginheight=\"0\" scrolling=\"no\"></iframe>\n</div></figure>\n\n\n\n<h2 class=\"wp-block-heading\" id=\"internationalization\">Internationalisation</h2>\n\n\n\n<p>Plusieurs améliorations ont été apportées aux outils et à l&rsquo;infrastructure d&rsquo;internationalisation afin d&rsquo;améliorer l&rsquo;expérience de traduction et de localisation. Les mises à jour comprennent l&rsquo;arrivée de nouvelles fonctions de traduction, des corrections de cohérence et une meilleure prise en charge des formes plurielles, ce qui facilite la création d&rsquo;extensions, de thèmes et d&rsquo;interfaces entièrement traduisibles.</p>\n\n\n\n<figure class=\"wp-block-embed is-type-wp-embed is-provider-make-wordpress-core wp-block-embed-make-wordpress-core\"><div class=\"wp-block-embed__wrapper\">\n<blockquote class=\"wp-embedded-content\" data-secret=\"NqvcibLyGF\"><a href=\"https://make.wordpress.org/core/2025/03/12/i18n-improvements-6-8/\">Internationalization improvements in 6.8</a></blockquote><iframe loading=\"lazy\" class=\"wp-embedded-content\" sandbox=\"allow-scripts\" security=\"restricted\"  title=\"&#8220;Internationalization improvements in 6.8&#8221; &#8212; Make WordPress Core\" src=\"https://make.wordpress.org/core/2025/03/12/i18n-improvements-6-8/embed/#?secret=NBUGYYmhDo#?secret=NqvcibLyGF\" data-secret=\"NqvcibLyGF\" width=\"500\" height=\"282\" frameborder=\"0\" marginwidth=\"0\" marginheight=\"0\" scrolling=\"no\"></iframe>\n</div></figure>\n\n\n\n<h2 class=\"wp-block-heading\" id=\"performance\">Performances</h2>\n\n\n\n<p>De nouveaux outils et des conseils aident les développeurs et développeuses à créer des interfaces plus rapides. La fonctionnalité de chargement spéculatif utilise l&rsquo;API <code>Speculation Rules</code> pour précharger ou pré-afficher les cibles des liens de navigation, améliorant ainsi la performance perçue par les utilisateurs finaux lors du clic sur un lien. De plus, des modifications de l&rsquo;API <code>Interactivity</code> permettront d&rsquo;écrire du code <em>front-end</em> plus efficace et plus évolutif.</p>\n\n\n\n<figure class=\"wp-block-embed is-type-wp-embed is-provider-make-wordpress-core wp-block-embed-make-wordpress-core\"><div class=\"wp-block-embed__wrapper\">\n<blockquote class=\"wp-embedded-content\" data-secret=\"HRsy4J27Eb\"><a href=\"https://make.wordpress.org/core/2025/03/06/speculative-loading-in-6-8/\">Speculative Loading in 6.8</a></blockquote><iframe loading=\"lazy\" class=\"wp-embedded-content\" sandbox=\"allow-scripts\" security=\"restricted\"  title=\"&#8220;Speculative Loading in 6.8&#8221; &#8212; Make WordPress Core\" src=\"https://make.wordpress.org/core/2025/03/06/speculative-loading-in-6-8/embed/#?secret=d8v7ZXJwkZ#?secret=HRsy4J27Eb\" data-secret=\"HRsy4J27Eb\" width=\"500\" height=\"282\" frameborder=\"0\" marginwidth=\"0\" marginheight=\"0\" scrolling=\"no\"></iframe>\n</div></figure>\n\n\n\n<figure class=\"wp-block-embed is-type-wp-embed is-provider-make-wordpress-core wp-block-embed-make-wordpress-core\"><div class=\"wp-block-embed__wrapper\">\n<blockquote class=\"wp-embedded-content\" data-secret=\"49PtIbJHVl\"><a href=\"https://make.wordpress.org/core/2025/03/24/interactivity-api-best-practices-in-6-8/\">Interactivity API best practices in 6.8</a></blockquote><iframe loading=\"lazy\" class=\"wp-embedded-content\" sandbox=\"allow-scripts\" security=\"restricted\"  title=\"&#8220;Interactivity API best practices in 6.8&#8221; &#8212; Make WordPress Core\" src=\"https://make.wordpress.org/core/2025/03/24/interactivity-api-best-practices-in-6-8/embed/#?secret=CslBN8jmlU#?secret=49PtIbJHVl\" data-secret=\"49PtIbJHVl\" width=\"500\" height=\"282\" frameborder=\"0\" marginwidth=\"0\" marginheight=\"0\" scrolling=\"no\"></iframe>\n</div></figure>\n\n\n\n<h2 class=\"wp-block-heading\" id=\"rest-api\">API REST</h2>\n\n\n\n<p>Les améliorations apportées à l&rsquo;API REST étendent sa flexibilité et son utilité pour les applications WordPress <em>headless</em> et découplées. Un nouveau filtre, <code>rest_menu_read_access</code>, permet aux développeur·euses de contrôler l&rsquo;accès public aux menus de navigation, aux éléments de menu et aux emplacements de menu via l&rsquo;API REST. Ce changement permet un contrôle plus précis des données de menu exposées via l&rsquo;API, ce qui permet de prendre en charge une gamme plus large de cas d&rsquo;utilisation.</p>\n\n\n\n<figure class=\"wp-block-embed is-type-wp-embed is-provider-make-wordpress-core wp-block-embed-make-wordpress-core\"><div class=\"wp-block-embed__wrapper\">\n<blockquote class=\"wp-embedded-content\" data-secret=\"eCrEpoAbgB\"><a href=\"https://make.wordpress.org/core/2025/03/27/new-rest-api-filter-for-exposing-menus-publicly-in-wordpress-6-8/\">New REST API Filter for Exposing Menus Publicly in WordPress 6.8</a></blockquote><iframe loading=\"lazy\" class=\"wp-embedded-content\" sandbox=\"allow-scripts\" security=\"restricted\"  title=\"&#8220;New REST API Filter for Exposing Menus Publicly in WordPress 6.8&#8221; &#8212; Make WordPress Core\" src=\"https://make.wordpress.org/core/2025/03/27/new-rest-api-filter-for-exposing-menus-publicly-in-wordpress-6-8/embed/#?secret=TmRv4OhCL7#?secret=eCrEpoAbgB\" data-secret=\"eCrEpoAbgB\" width=\"500\" height=\"282\" frameborder=\"0\" marginwidth=\"0\" marginheight=\"0\" scrolling=\"no\"></iframe>\n</div></figure>\n\n\n\n<h2 class=\"wp-block-heading\" id=\"security\">Sécurité</h2>\n\n\n\n<p>La sécurité des mots de passe a été renforcée grâce à l&rsquo;introduction de <code>bcrypt</code> comme nouvel algorithme de hachage par défaut. Ce changement modernise le stockage des mots de passe de WordPress, offrant une meilleure résistance aux attaques par force brute et s&rsquo;alignant sur les meilleures pratiques actuelles de l&rsquo;industrie. Les mots de passe existants restent valides et seront re-hachés avec <code>bcrypt</code> lors de la prochaine connexion réussie de l&rsquo;utilisateur·ice.</p>\n\n\n\n<figure class=\"wp-block-embed is-type-wp-embed is-provider-make-wordpress-core wp-block-embed-make-wordpress-core\"><div class=\"wp-block-embed__wrapper\">\n<blockquote class=\"wp-embedded-content\" data-secret=\"qVqP1W6BMg\"><a href=\"https://make.wordpress.org/core/2025/02/17/wordpress-6-8-will-use-bcrypt-for-password-hashing/\">WordPress 6.8 will use bcrypt for password hashing</a></blockquote><iframe loading=\"lazy\" class=\"wp-embedded-content\" sandbox=\"allow-scripts\" security=\"restricted\"  title=\"&#8220;WordPress 6.8 will use bcrypt for password hashing&#8221; &#8212; Make WordPress Core\" src=\"https://make.wordpress.org/core/2025/02/17/wordpress-6-8-will-use-bcrypt-for-password-hashing/embed/#?secret=avMfXAbxDn#?secret=qVqP1W6BMg\" data-secret=\"qVqP1W6BMg\" width=\"500\" height=\"282\" frameborder=\"0\" marginwidth=\"0\" marginheight=\"0\" scrolling=\"no\"></iframe>\n</div></figure>\n\n\n\n<h2 class=\"wp-block-heading\" id=\"miscellaneous-developer-changes\">Autres changements techniques</h2>\n\n\n\n<p>Un ensemble de modifications plus petites améliore la cohérence, l&rsquo;extensibilité et l&rsquo;expérience de développement générale. Ces changements couvrent divers domaines du cœur WordPress, notamment la gestion des médias, le rendu de certains codes courts (<em>shortcodes</em>), l&rsquo;enregistrement des types de publications, la gestion des thèmes. Bien qu&rsquo;individuellement mineures, ces modifications reflètent les efforts continus pour moderniser notre CMS.</p>\n\n\n\n<figure class=\"wp-block-embed is-type-wp-embed is-provider-make-wordpress-core wp-block-embed-make-wordpress-core\"><div class=\"wp-block-embed__wrapper\">\n<blockquote class=\"wp-embedded-content\" data-secret=\"6yMViHGi0o\"><a href=\"https://make.wordpress.org/core/2025/03/25/miscellaneous-developer-changes-in-wordpress-6-8/\">Miscellaneous developer changes in WordPress 6.8</a></blockquote><iframe loading=\"lazy\" class=\"wp-embedded-content\" sandbox=\"allow-scripts\" security=\"restricted\"  title=\"&#8220;Miscellaneous developer changes in WordPress 6.8&#8221; &#8212; Make WordPress Core\" src=\"https://make.wordpress.org/core/2025/03/25/miscellaneous-developer-changes-in-wordpress-6-8/embed/#?secret=8nTjG46eRo#?secret=6yMViHGi0o\" data-secret=\"6yMViHGi0o\" width=\"500\" height=\"282\" frameborder=\"0\" marginwidth=\"0\" marginheight=\"0\" scrolling=\"no\"></iframe>\n</div></figure>\n\n\n\n<h2 class=\"wp-block-heading\" id=\"but-wait-there-is-more\">Attendez, ce n’est pas fini&nbsp;!</h2>\n\n\n\n<p>WordPress 6.8 offre encore bien davantage&nbsp;!&nbsp;Plus de&nbsp;<a href=\"https://core.trac.wordpress.org/query?status=closed&amp;type=defect+(bug)&amp;milestone=6.8&amp;group=component&amp;col=id&amp;col=summary&amp;col=type&amp;col=owner&amp;col=priority&amp;col=component&amp;col=version&amp;order=priority\">170 bogues</a>,&nbsp;<a href=\"https://core.trac.wordpress.org/query?status=closed&amp;type=enhancement&amp;type=feature+request&amp;milestone=6.8&amp;group=component&amp;col=id&amp;col=summary&amp;col=type&amp;col=owner&amp;col=priority&amp;col=component&amp;col=version&amp;order=priority\">104 améliorations et nouvelles fonctionnalités</a>, et&nbsp;<a href=\"https://core.trac.wordpress.org/query?status=closed&amp;type=task+(blessed)&amp;milestone=6.8&amp;group=component&amp;col=id&amp;col=summary&amp;col=type&amp;col=owner&amp;col=priority&amp;col=component&amp;col=version&amp;order=priority\">21 tâches diverses</a>&nbsp;ont été&nbsp;<a href=\"https://core.trac.wordpress.org/query?status=closed&amp;milestone=6.8&amp;group=component&amp;col=id&amp;col=summary&amp;col=owner&amp;col=type&amp;col=priority&amp;col=component&amp;col=version&amp;order=priority\">clôturés dans WordPress 6.8</a>.&nbsp; Cette version va par exemple permettre d&rsquo;afficher les nouveaux emojis de la version 15.1 de la bibliothèque Twemoji pour les internautes qui ne peuvent pas les afficher nativement dans leur navigateur (exemple de nouvel emoji&nbsp;: <img src=\"https://s.w.org/images/core/emoji/16.0.1/72x72/1f426-200d-1f525.png\" alt=\"🐦‍🔥\" class=\"wp-smiley\" style=\"height: 1em; max-height: 1em;\" />).</p>\n\n\n\n<p>Voici quelques modifications notables&nbsp;:</p>\n\n\n\n<ul class=\"wp-block-list\">\n<li>Remplacement des chaînes « Add New {Item} » par « Add {Item} » partout sur l&rsquo;administration (<a href=\"https://core.trac.wordpress.org/ticket/61219\">ticket #61219</a>)</li>\n\n\n\n<li>Amélioration des chaînes traduisibles sur le thème Twenty Twenty-Five (<a href=\"https://core.trac.wordpress.org/ticket/62482\">ticket #62482</a>)</li>\n\n\n\n<li>Thèmes natifs&nbsp;: amélioration de l&rsquo;accessibilité du lien du titre du site (<a href=\"https://core.trac.wordpress.org/ticket/62895\">ticket #62895</a>)</li>\n\n\n\n<li>Gestion des dates&nbsp;: les réglages des dates obtiennent deux nouvelles options, <code>j.n.Y</code> et <code>d.m.Y</code> (<a href=\"https://core.trac.wordpress.org/ticket/55685\">#55685</a>)</li>\n\n\n\n<li>Contenus embarqués&nbsp;: ajout de Canva en tant que fournisseur oEmbed (<a href=\"https://core.trac.wordpress.org/ticket/58840\">ticket #58840</a>)</li>\n\n\n\n<li>API des métadonnées&nbsp;: renommage de l’action <code>setted_transient</code>&nbsp;en&nbsp;<code>set_transient</code>&nbsp;(<a href=\"https://core.trac.wordpress.org/ticket/62849\">ticket #62849</a>)</li>\n\n\n\n<li>API REST&nbsp;: gestion des barres obliques de fin de chaînes dans&nbsp;<code>rest_preload_api_request</code>&nbsp;(<a href=\"https://core.trac.wordpress.org/ticket/57048\">ticket #57048</a>)</li>\n\n\n\n<li>Sécurité&nbsp;: assurance explicite du caractère requis du module PHP&nbsp;<code>hash</code>&nbsp;et ajout de vérifications des prérequis lors de l&rsquo;installation et de la mise à jour (<a href=\"https://core.trac.wordpress.org/ticket/56017\">ticket #56017</a>)</li>\n\n\n\n<li>Mises à jour&nbsp;: suppression d&rsquo;une vérification inutile lors de la vérification des mises à jour lorsque la donnée est à jour (<a href=\"https://core.trac.wordpress.org/ticket/44118\">ticket #44118</a>)</li>\n\n\n\n<li>Widgets&nbsp;: ajout de la prise en charge des types de publications dans la fonction&nbsp;<code>get_calendar()</code>. Ces modifications introduisent également un nouveau filtre&nbsp;<code>get_calendar_args</code> (<a href=\"https://core.trac.wordpress.org/ticket/34093\">ticket #34093</a>)</li>\n</ul>\n\n\n\n<h2 class=\"wp-block-heading\" id=\"other-updates\">Nouvelles fonctions, crochets, filtres, classes et méthodes</h2>\n\n\n\n<p>Pour obtenir la liste de toutes les nouvelles fonctions, crochets, filtres, classes et méthodes, vous pourrez vous rendre – une fois que WP 6.8 sera sortie – sur cette page&nbsp;: <a href=\"https://developer.wordpress.org/reference/since/6.8.0/\">https://developer.wordpress.org/reference/since/6.8.0/</a>.</p>\n\n\n\n<div class=\"wp-block-group alignfull is-style-serif has-charcoal-0-color has-text-color has-background has-link-color wp-elements-b65007937b1cf3a6c667456985c6a68f is-layout-constrained wp-block-group-is-layout-constrained\" style=\"background:linear-gradient(135deg,rgb(242,255,240) 0%,rgb(255,252,223) 50%,rgb(255,211,218) 100%);padding-top:1em;padding-bottom:1em\">\n<p class=\"is-style-serif has-black-color has-text-color has-link-color wp-elements-acf16339b7757858691a26a725321228\">Que vous développiez des thèmes ou des extensions, pensez à <strong>tester et retester votre code</strong> pour vous assurer de sa compatibilité avec ces changements.<br><br>Vous pouvez utiliser&nbsp;<a href=\"https://fr.wordpress.org/plugins/wordpress-beta-tester/\" target=\"_blank\" rel=\"noreferrer noopener\">l’extension «&nbsp;<em><bdo lang=\"en\" dir=\"ltr\">Beta Tester</bdo></em>&nbsp;»</a>&nbsp;sur un site de test pour vérifier la compatibilité de vos développements avec la <a href=\"https://wordpress.org/news/2024/10/wordpress-6-7-release-candidate-1/\">version <em><bdo lang=\"en\" dir=\"ltr\">release candidate</bdo></em>&nbsp;de WordPress 6.8</a>.&nbsp;<br>Vous pouvez aussi tester cette nouvelle version directement dans votre navigateur en utilisant <em><a href=\"https://playground.wordpress.net/?php=8.0&amp;wp=beta&amp;networking=no&amp;language=&amp;multisite=no&amp;random=y4q1rn88xn\"><bdo lang=\"en\" dir=\"ltr\">WordPress Playground</bdo></a></em>.<br><br>Nous comptons sur vous pour vérifier que votre code fonctionne correctement avec le cœur du CMS, pour le bien des millions d’utilisateurs et utilisatrices de WordPress&nbsp;<img src=\"https://s.w.org/images/core/emoji/16.0.1/72x72/2665.png\" alt=\"♥\" class=\"wp-smiley\" style=\"height: 1em; max-height: 1em;\" /></p>\n</div>\n\n\n\n<p class=\"has-small-font-size\">Ce guide a été traduit et réadapté à partir du&nbsp;<a href=\"https://make.wordpress.org/core/2025/03/28/wordpress-6-8-field-guide/\">Field Guide&nbsp;de WP 6.8 (en anglais)</a>&nbsp;par&nbsp;<a href=\"https://profiles.wordpress.org/audrasjb/\">Jb Audras</a>.<br>Merci <a href=\'https://profiles.wordpress.org/clementpolito/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>clementpolito</a>, <a href=\'https://profiles.wordpress.org/rainbowgeek/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>rainbowgeek</a>, <a href=\'https://profiles.wordpress.org/reskatorfr/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>reskatorfr</a>, <a href=\'https://profiles.wordpress.org/jdy68/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>jdy68</a> pour leur relecture.</p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:30:\"com-wordpress:feed-additions:1\";a:1:{s:7:\"post-id\";a:1:{i:0;a:5:{s:4:\"data\";s:4:\"3310\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:4;a:6:{s:4:\"data\";s:57:\"\n		\n		\n		\n		\n		\n				\n		\n\n					\n										\n					\n		\n		\n			\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:4:{s:0:\"\";a:6:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:29:\"WordPress 6.7 « Rollins »\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:58:\"https://fr.wordpress.org/2024/11/12/wordpress-6-7-rollins/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Tue, 12 Nov 2024 23:14:42 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Nouvelles versions de WordPress\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:32:\"https://fr.wordpress.org/?p=3255\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:385:\"Chaque version de WordPress célèbre un ou une artiste ayant posé son empreinte sur le monde la musique. WordPress 6.7 «&#160;Rollins&#160;» rend hommage au saxophoniste de jazz Sonny Rollins. Connu comme l’un des plus grands improvisateurs du jazz, Rollins a influencé des générations de musiciens avec sa technique, son esprit d&#8217;innovation et son approche de [&#8230;]\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:9:\"Jb Audras\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:69268:\"\n<figure class=\"wp-block-image size-large\"><img decoding=\"async\" src=\"https://wordpress.org/news/files/2024/11/Release-Edition-Featured-Image-1024x535.png\" alt=\"\" class=\"wp-image-18085\" /></figure>\n\n\n\n<p>Chaque version de WordPress célèbre un ou une artiste ayant posé son empreinte sur le monde la musique. WordPress 6.7 «&nbsp;Rollins&nbsp;» rend hommage au saxophoniste de jazz Sonny Rollins. Connu comme l’un des plus grands improvisateurs du jazz, Rollins a influencé des générations de musiciens avec sa technique, son esprit d&rsquo;innovation et son approche de l&rsquo;expression musicale.</p>\n\n\n\n<h2 class=\"wp-block-heading\">Bienvenue sur WordPress&nbsp;6.7&nbsp;!</h2>\n\n\n\n<p>WordPress 6.7 introduit le nouveau thème <bdo lang=\"en\" dir=\"ltr\"><em>Twenty Twenty-Five</em></bdo>, qui offre une flexibilité de conception ultime pour tous les sites et blogs. Vous pourrez gérer la typographie de votre site comme jamais auparavant. Les nouvelles fonctionnalités de zoom arrière vous permettront de concevoir votre site avec une vue macroscopique pour prendre du recul sur les détails de votre projet.</p>\n\n\n\n<div class=\"wp-block-buttons is-layout-flex wp-block-buttons-is-layout-flex\">\n<div class=\"wp-block-button\"><a class=\"wp-block-button__link wp-element-button\" href=\"https://fr.wordpress.org/latest-fr_FR.zip\" target=\"_blank\" rel=\"noreferrer noopener\">Télécharger WordPress 6.7 «&nbsp;Rollins&nbsp;» en français (ZIP – 19,1 Mo)</a></div>\n</div>\n\n\n\n<h2 class=\"wp-block-heading\">Présentation du nouveau thème <bdo lang=\"en\" dir=\"ltr\">Twenty Twenty-Five</bdo></h2>\n\n\n\n<blockquote class=\"wp-block-quote is-layout-flow wp-block-quote-is-layout-flow\">\n<p>Une infinité de possibilités sans complexité</p>\n</blockquote>\n\n\n\n<p><bdo lang=\"en\" dir=\"ltr\">Twenty Twenty-Five</bdo> est un thème polyvalent, axé sur le design, qui vous permet de créer des sites époustouflants en toute simplicité. Personnalisez votre esthétisme grâce à un éventail d‘options de style, de compositions de blocs et de palettes de couleurs. Réduit à l‘essentiel, c‘est un thème qui peut vraiment évoluer avec vous.</p>\n\n\n\n<figure class=\"wp-block-image size-large\"><img decoding=\"async\" src=\"https://s.w.org/images/core/6.7/feature-tt5-2.webp\" alt=\"\" style=\"object-fit:cover\" /></figure>\n\n\n\n<h3 class=\"wp-block-heading\">Obtenez une vue d’ensemble en dézoomant</h3>\n\n\n\n<blockquote class=\"wp-block-quote is-layout-flow wp-block-quote-is-layout-flow\">\n<p>Explorez votre contenu sous un nouvel angle</p>\n</blockquote>\n\n\n\n<p>Modifiez et organisez des sections entières de votre contenu comme jamais auparavant. Une vue plus large de votre site vous permet d‘ajouter, de modifier, de mélanger ou de supprimer des compositions à votre guise. Laissez s‘exprimer l‘architecte qui est en vous.</p>\n\n\n\n<figure class=\"wp-block-image size-large\"><img decoding=\"async\" src=\"https://s.w.org/images/core/6.7/feature-zoom-2.webp\" alt=\"\" /></figure>\n\n\n\n<h3 class=\"wp-block-heading\">Connectez des blocs et des champs personnalisés sans souci (et sans coder)</h3>\n\n\n\n<blockquote class=\"wp-block-quote is-layout-flow wp-block-quote-is-layout-flow\">\n<p>Une manière simplifiée de créer du contenu dynamique</p>\n</blockquote>\n\n\n\n<p>Cette fonctionnalité introduit une nouvelle interface pour connecter des blocs à des champs personnalisés. Cela vous donne le contrôle d’éléments dynamiques directement dans l’éditeur. Vous pouvez relier des blocs à des champs en quelques clics, ce qui améliore la flexibilité et l’efficacité de ces actions. Vos clients vont adorer ça.</p>\n\n\n\n<figure class=\"wp-block-image size-large\"><img decoding=\"async\" src=\"https://s.w.org/images/core/6.7/feature-block-bindings-2.webp\" alt=\"\" /></figure>\n\n\n\n<h3 class=\"wp-block-heading\">Laissez s’exprimer votre passion pour la typographie</h3>\n\n\n\n<blockquote class=\"wp-block-quote is-layout-flow wp-block-quote-is-layout-flow\">\n<p>Nouvelle section de styles, nouvelles possibilités</p>\n</blockquote>\n\n\n\n<p>Créez, modifiez, retirez et appliquez des préréglages de taille de police avec le dernier apport à l’interface des Styles. Surchargez le thème par défaut ou créez votre propre taille de police personnalisée, avec une typographie dynamique pour un redimensionnement responsive des polices. Prenez soin des détails&nbsp;!</p>\n\n\n\n<figure class=\"wp-block-image size-large\"><img decoding=\"async\" src=\"https://s.w.org/images/core/6.7/feature-font-presets-2.png\" alt=\"\" /></figure>\n\n\n\n<h3 class=\"wp-block-heading\">Améliorations des performances</h3>\n\n\n\n<p>WordPress 6.7 propose d’importantes mises à jour en matière de performances, notamment un chargement plus rapide des compositions, des aperçus optimisés pour le composant des vues de données, une meilleure prise en charge de PHP 8 et plus, la suppression du code obsolète, des tailles automatiques pour les images en chargement différé, ainsi qu’un traitement plus efficace des balises dans l’API HTML.</p>\n\n\n\n<h3 class=\"wp-block-heading\">Améliorations de l’accessibilité</h3>\n\n\n\n<p>Plus de 65 correctifs et améliorations d’accessibilité focalisées sur les aspects fondamentaux de l’expérience de WordPress, de l’amélioration des composants d’interface d’administration à la navigation clavier dans l’éditeur, en passant par des niveaux de titres plus accessibles dans les écrans de connexion et de meilleurs libellés.</p>\n\n\n\n<h2 class=\"wp-block-heading\">En savoir plus sur WordPress 6.7</h2>\n\n\n\n<p><a href=\"https://learn.wordpress.org/\"><em>Learn WordPress</em></a>&nbsp;est une ressource gratuite pour les personnes qui utilisent WordPress, qu’elles soient débutantes ou expérimentées.&nbsp;<em>Learn</em>&nbsp;contient des vidéos pratiques sur l’utilisation de diverses fonctionnalités de WordPress, des&nbsp;<a href=\"https://learn.wordpress.org/online-workshops/\">évènements interactifs</a>&nbsp;pour explorer des sujets en profondeur, et des plans de cours pour approfondir des domaines spécifiques de WordPress.</p>\n\n\n\n<p>Lisez les <a href=\"https://wordpress.org/support/wordpress-version/version-6-7/\">notes de version de WordPress 6.7</a> pour obtenir des informations sur l’installation, les améliorations, les problèmes corrigés, les contributeurs et contributrices de la version, les ressources d’apprentissage et la liste des modifications apportées aux fichiers.</p>\n\n\n\n<p>Explorez le <a href=\"https://fr.wordpress.org/2024/10/28/guide-des-changements-techniques-de-wordpress-6-7/\">guide des changements techniques de WordPress 6.7</a>. Découvrez les changements de cette version avec les notes détaillées des développeurs et développeuses qui vous permettent de construire votre site avec WordPress.</p>\n\n\n\n<h2 class=\"wp-block-heading\">L’équipe de direction de WordPress&nbsp;6.7</h2>\n\n\n\n<p>Voici l’équipe qui a coordonné le développement et la sortie de cette nouvelle version de WordPress&nbsp;:</p>\n\n\n\n<ul class=\"wp-block-list\">\n<li>Direction générale&nbsp;: <a href=\"https://profiles.wordpress.org/matt/\">Matt Mullenweg</a></li>\n\n\n\n<li>Coordination de la version&nbsp;: <a href=\"https://profiles.wordpress.org/davidbaumwald/\">David Baumwald</a></li>\n\n\n\n<li>Direction technique&nbsp;cœur&nbsp;: <a href=\"https://profiles.wordpress.org/peterwilsoncc/\">Peter Wilson</a>,&nbsp;<a href=\"https://profiles.wordpress.org/kirasong/\">Kira Schroder</a></li>\n\n\n\n<li>Direction technique côté Gutenberg&nbsp;: <a href=\"https://profiles.wordpress.org/get_dave/\">David Smith</a>,&nbsp;<a href=\"https://profiles.wordpress.org/kevin940726/\">Kai Hao</a>,&nbsp;<a href=\"https://profiles.wordpress.org/noisysocks/\">Robert Anderson</a></li>\n\n\n\n<li>Gestion de projet côté cœur&nbsp;: <a href=\"https://profiles.wordpress.org/stoyangeorgiev/\">Stoyan Georgiev</a>, <a href=\"https://profiles.wordpress.org/chaion07/\">Ahmed Kabir Chaion</a></li>\n\n\n\n<li>Gestion de projet côté Gutenberg&nbsp;: <a href=\"https://profiles.wordpress.org/ndiego/\">Nick Diego</a>,&nbsp;<a href=\"https://wordpress.org/support/users/colorful-tones/\">Damon Cook</a></li>\n\n\n\n<li>Direction de la documentation&nbsp;: <a href=\"https://profiles.wordpress.org/fabiankaegy/\">Fabian Kägy</a>,&nbsp;<a href=\"https://profiles.wordpress.org/faguni22/\">Mumtahina Faguni</a></li>\n\n\n\n<li>Direction des tests&nbsp;: <a href=\"https://profiles.wordpress.org/ankit-k-gupta/\">Ankit K. Gupta</a></li>\n\n\n\n<li>Direction artistique&nbsp;: <a href=\"https://profiles.wordpress.org/joen/\">Joen Asmussen</a></li>\n\n\n\n<li>Direction des performances&nbsp;: <a href=\"https://profiles.wordpress.org/adamsilverstein/\"></a><a href=\"https://profiles.wordpress.org/mukesh27/\">Mukesh Panchal</a></li>\n\n\n\n<li>Direction du design du nouveau thème&nbsp;:&nbsp;<a href=\"https://profiles.wordpress.org/beafialho/\">Beatriz Fialho</a></li>\n\n\n\n<li>Direction du développement du nouveau thème&nbsp;:&nbsp;<a href=\"https://profiles.wordpress.org/poena/\">Carolina Nymark</a>,&nbsp;<a href=\"https://profiles.wordpress.org/juanfra/\">Juan Aldasoro</a></li>\n</ul>\n\n\n\n<h2 class=\"wp-block-heading\">Merci aux contributeurs et contributrices</h2>\n\n\n\n<p>WordPress 6.7 n’aurait pas pu sortir sans la contribution passionnée de plus de&nbsp;<strong>780 personnes provenant de tous les pays du monde</strong>.</p>\n\n\n\n<p>Un remerciement tout spécial pour les plus de 230 personnes qui ont contribué au cœur de WordPress pour la première fois avec WP&nbsp;6.7 <img src=\"https://s.w.org/images/core/emoji/16.0.1/72x72/2665.png\" alt=\"♥\" class=\"wp-smiley\" style=\"height: 1em; max-height: 1em;\" /></p>\n\n\n\n<p class=\"is-style-wporg-props-long alignfull is-style-short-text has-lemon-3-background-color has-background\" style=\"font-size:12px\"><a href=\"https://profiles.wordpress.org/benniledl/\">!Benni</a> · <a href=\"https://profiles.wordpress.org/75thtrombone/\">75thtrombone</a> · <a href=\"https://profiles.wordpress.org/jorbin/\">Aaron Jorbin</a> · <a href=\"https://profiles.wordpress.org/aaronrobertshaw/\">Aaron Robertshaw</a> · <a href=\"https://profiles.wordpress.org/aware/\">Aaron Ware</a> · <a href=\"https://profiles.wordpress.org/aatanasov/\">aatanasov</a> · <a href=\"https://profiles.wordpress.org/webcommsat/\">Abha Thakor</a> · <a href=\"https://profiles.wordpress.org/abhi3315/\">abhi3315</a> · <a href=\"https://profiles.wordpress.org/fitehal/\">Abhishek Deshpande</a> · <a href=\"https://profiles.wordpress.org/ababir/\">Abir</a> · <a href=\"https://profiles.wordpress.org/acafourek/\">acafourek</a> · <a href=\"https://profiles.wordpress.org/adamkheckler/\">Adam Heckler</a> · <a href=\"https://profiles.wordpress.org/adamsilverstein/\">Adam Silverstein</a> · <a href=\"https://profiles.wordpress.org/adamwood/\">Adam Wood</a> · <a href=\"https://profiles.wordpress.org/zieladam/\">Adam Zieliński</a> · <a href=\"https://profiles.wordpress.org/adarshposimyth/\">Adarsh Akshat</a> · <a href=\"https://profiles.wordpress.org/adrian2k7/\">Adrian</a> · <a href=\"https://profiles.wordpress.org/aduth/\">aduth</a> · <a href=\"https://profiles.wordpress.org/ah72king/\">ah72king</a> · <a href=\"https://profiles.wordpress.org/ahmarzaidi/\">Ahmar Zaidi</a> · <a href=\"https://profiles.wordpress.org/chaion07/\">Ahmed Kabir Chaion</a> · <a href=\"https://profiles.wordpress.org/engahmeds3ed/\">Ahmed Saeed</a> · <a href=\"https://profiles.wordpress.org/ajitbohra/\">Ajit Bohra</a> · <a href=\"https://profiles.wordpress.org/akashdhawade/\">Akash Dhawade</a> · <a href=\"https://profiles.wordpress.org/wildworks/\">Aki Hamano</a> · <a href=\"https://profiles.wordpress.org/atachibana/\">Akira Tachibana</a> · <a href=\"https://profiles.wordpress.org/akshat2802/\">Akshat Kakkad</a> · <a href=\"https://profiles.wordpress.org/alaminfirdows/\">Al-Amin Firdows</a> · <a href=\"https://profiles.wordpress.org/alanfuller/\">Alan Fuller</a> · <a href=\"https://profiles.wordpress.org/aljullu/\">Albert Juhé Lluveras</a> · <a href=\"https://profiles.wordpress.org/alessandrotesoro/\">Alessandro Tesoro</a> · <a href=\"https://profiles.wordpress.org/ralessio/\">Alessio</a> · <a href=\"https://profiles.wordpress.org/xknown/\">Alex Concha</a> · <a href=\"https://profiles.wordpress.org/ajlende/\">Alex Lende</a> · <a href=\"https://profiles.wordpress.org/alexstine/\">Alex Stine</a> · <a href=\"https://profiles.wordpress.org/alex27/\">alex27</a> · <a href=\"https://profiles.wordpress.org/digitalex11/\">Alexander Frank</a> · <a href=\"https://profiles.wordpress.org/alexandrebuffet/\">Alexandre Buffet</a> · <a href=\"https://profiles.wordpress.org/harlet7/\">Alexandru Horeanu</a> · <a href=\"https://profiles.wordpress.org/alexcu21/\">alexcu21</a> · <a href=\"https://profiles.wordpress.org/ali7ali/\">Ali Ali</a> · <a href=\"https://profiles.wordpress.org/aliaghdam/\">aliaghdam</a> · <a href=\"https://profiles.wordpress.org/firewatch/\">allilevine</a> · <a href=\"https://profiles.wordpress.org/mrfoxtalbot/\">Alvaro Gómez</a> · <a href=\"https://profiles.wordpress.org/alvitazwar052/\">Alvi Tazwar</a> · <a href=\"https://profiles.wordpress.org/amincharoliya/\">Amin Charoliya</a> · <a href=\"https://profiles.wordpress.org/amirthepiper/\">Amir Abbas</a> · <a href=\"https://profiles.wordpress.org/amitraj2203/\">Amit Raj</a> · <a href=\"https://profiles.wordpress.org/amjadr360/\">Amjad Ali</a> · <a href=\"https://profiles.wordpress.org/anthakkar08/\">Anand Thakkar</a> · <a href=\"https://profiles.wordpress.org/afercia/\">Andrea Fercia</a> · <a href=\"https://profiles.wordpress.org/awetz583/\">Andrea Roenning</a> · <a href=\"https://profiles.wordpress.org/andraganescu/\">Andrei Draganescu</a> · <a href=\"https://profiles.wordpress.org/euthelup/\">Andrei Lupu</a> · <a href=\"https://profiles.wordpress.org/andreiglingeanu/\">andreiglingeanu</a> · <a href=\"https://profiles.wordpress.org/andrewhayward/\">Andrew Hayward</a> · <a href=\"https://profiles.wordpress.org/azaozz/\">Andrew Ozz</a> · <a href=\"https://profiles.wordpress.org/andrewserong/\">Andrew Serong</a> · <a href=\"https://profiles.wordpress.org/rarst/\">Andrey “Rarst” Savchenko</a> · <a href=\"https://profiles.wordpress.org/oandregal/\">André Maneiro</a> · <a href=\"https://profiles.wordpress.org/afragen/\">Andy Fragen</a> · <a href=\"https://profiles.wordpress.org/la-geek/\">Angelika Reisiger</a> · <a href=\"https://profiles.wordpress.org/aniketpatel/\">Aniket Patel</a> · <a href=\"https://profiles.wordpress.org/ankit-k-gupta/\">Ankit K Gupta</a> · <a href=\"https://profiles.wordpress.org/ankit k gupta/\">Ankit K. Gupta</a> · <a href=\"https://profiles.wordpress.org/ankitkumarshah/\">Ankit Kumar Shah</a> · <a href=\"https://profiles.wordpress.org/the-ank/\">Ankur Vishwakarma</a> · <a href=\"https://profiles.wordpress.org/annezazu/\">Anne McCarthy</a> · <a href=\"https://profiles.wordpress.org/antpb/\">Anthony Burchell</a> · <a href=\"https://profiles.wordpress.org/ahortin/\">Anthony Hortin</a> · <a href=\"https://profiles.wordpress.org/ant1busted/\">Antoine</a> · <a href=\"https://profiles.wordpress.org/antonvlasenko/\">Anton Vlasenko</a> · <a href=\"https://profiles.wordpress.org/antoniosejas/\">Antonio Sejas</a> · <a href=\"https://profiles.wordpress.org/apmeyer/\">apmeyer</a> · <a href=\"https://profiles.wordpress.org/aristath/\">Ari Stathopoulos</a> · <a href=\"https://profiles.wordpress.org/perezcarreno/\">Armando J. Perez Carreno</a> · <a href=\"https://profiles.wordpress.org/armandsdz/\">Armands</a> · <a href=\"https://profiles.wordpress.org/arnaudbroes/\">arnaudbroes</a> · <a href=\"https://profiles.wordpress.org/ambrosiawt/\">Art Smith</a> · <a href=\"https://profiles.wordpress.org/artemiosans/\">Artemio Morales</a> · <a href=\"https://profiles.wordpress.org/arthur791004/\">Arthur Chu</a> · <a href=\"https://profiles.wordpress.org/arypneta/\">arypneta</a> · <a href=\"https://profiles.wordpress.org/asafm7/\">asafm7</a> · <a href=\"https://profiles.wordpress.org/aslamdoctor/\">Aslam Doctor</a> · <a href=\"https://profiles.wordpress.org/nmutua/\">Autumn</a> · <a href=\"https://profiles.wordpress.org/ayeshrajans/\">Ayesh Karunaratne</a> · <a href=\"https://profiles.wordpress.org/bjerke-johannessen/\">Bård Bjerke Johannessen</a> · <a href=\"https://profiles.wordpress.org/beryldlg/\">Béryl de La Grandière</a> · <a href=\"https://profiles.wordpress.org/balub/\">Balu B</a> · <a href=\"https://profiles.wordpress.org/barryceelen/\">Barry Ceelen</a> · <a href=\"https://profiles.wordpress.org/bartkalisz/\">Bart Kalisz</a> · <a href=\"https://profiles.wordpress.org/beafialho/\">Beatriz Fialho</a> · <a href=\"https://profiles.wordpress.org/scruffian/\">Ben Dwyer</a> · <a href=\"https://profiles.wordpress.org/rainbowgeek/\">Benjamin Denis</a> · <a href=\"https://profiles.wordpress.org/benjamin_zekavica/\">Benjamin Zekavica</a> · <a href=\"https://profiles.wordpress.org/benoitchantre/\">Benoit Chantre</a> · <a href=\"https://profiles.wordpress.org/kau-boy/\">Bernhard Kau</a> · <a href=\"https://profiles.wordpress.org/bernhard reiter/\">Bernhard Reiter</a> · <a href=\"https://profiles.wordpress.org/neoxx/\">Bernhard Riedl</a> · <a href=\"https://profiles.wordpress.org/bernhard-reiter/\">bernhard-reiter</a> · <a href=\"https://profiles.wordpress.org/berubenic/\">berubenic</a> · <a href=\"https://profiles.wordpress.org/bhaveshdesai13/\">Bhavesh</a> · <a href=\"https://profiles.wordpress.org/bijit027/\">bijit027</a> · <a href=\"https://profiles.wordpress.org/bph/\">Birgit Pauli-Haack</a> · <a href=\"https://profiles.wordpress.org/blindmikey/\">blindmikey</a> · <a href=\"https://profiles.wordpress.org/bobbyleenoblestudios/\">bobbyleenoblestudios</a> · <a href=\"https://profiles.wordpress.org/bogdannikolic/\">Bogdan Nikolic</a> · <a href=\"https://profiles.wordpress.org/veryard/\">Brad</a> · <a href=\"https://profiles.wordpress.org/bradley2083/\">brad hogan</a> · <a href=\"https://profiles.wordpress.org/bjorsch/\">Brad Jorsch</a> · <a href=\"https://profiles.wordpress.org/kraftbj/\">Brandon Kraft</a> · <a href=\"https://profiles.wordpress.org/brentjettgmailcom/\">Brent Jett</a> · <a href=\"https://profiles.wordpress.org/brettshumaker/\">Brett Shumaker</a> · <a href=\"https://profiles.wordpress.org/ironprogrammer/\">Brian Alexander</a> · <a href=\"https://profiles.wordpress.org/bacoords/\">Brian Coords</a> · <a href=\"https://profiles.wordpress.org/bgardner/\">Brian Gardner</a> · <a href=\"https://profiles.wordpress.org/bgosnell/\">Brian Gosnell</a> · <a href=\"https://profiles.wordpress.org/brianhenryie/\">Brian Henry</a> · <a href=\"https://profiles.wordpress.org/bridgetwes/\">bridgetwes</a> · <a href=\"https://profiles.wordpress.org/brobken/\">brobken</a> · <a href=\"https://profiles.wordpress.org/freibergergarcia/\">Bruno Freiberger Garcia</a> · <a href=\"https://profiles.wordpress.org/cambabutonono/\">Cambabutonono</a> · <a href=\"https://profiles.wordpress.org/cbravobernal/\">Carlos Bravo</a> · <a href=\"https://profiles.wordpress.org/carlosgprim/\">Carlos G. P.</a> · <a href=\"https://profiles.wordpress.org/poena/\">Carolina Nymark</a> · <a href=\"https://profiles.wordpress.org/carstenbach/\">Carsten Bach</a> · <a href=\"https://profiles.wordpress.org/cbirdsong/\">cbirdsong</a> · <a href=\"https://profiles.wordpress.org/mchirag2002/\">Chirag Mathur</a> · <a href=\"https://profiles.wordpress.org/chrico/\">ChriCo</a> · <a href=\"https://profiles.wordpress.org/jazzs3quence/\">Chris Reynolds</a> · <a href=\"https://profiles.wordpress.org/eclare/\">Chris Trynkiewicz (Sukces Strony)</a> · <a href=\"https://profiles.wordpress.org/apermo/\">Christoph Daum</a> · <a href=\"https://profiles.wordpress.org/cfinke/\">Christopher Finke</a> · <a href=\"https://profiles.wordpress.org/ckanitz/\">Christopher Kanitz</a> · <a href=\"https://profiles.wordpress.org/nyiriland/\">Christy Nyiri</a> · <a href=\"https://profiles.wordpress.org/butterflymedia/\">Ciprian</a> · <a href=\"https://profiles.wordpress.org/codersantosh/\">codersantosh</a> · <a href=\"https://profiles.wordpress.org/costdev/\">Colin Stewart</a> · <a href=\"https://profiles.wordpress.org/coreyw/\">Corey Worrell</a> · <a href=\"https://profiles.wordpress.org/courane01/\">Courtney Robertson</a> · <a href=\"https://profiles.wordpress.org/craynor/\">craynor</a> · <a href=\"https://profiles.wordpress.org/creativethemeshq/\">creativethemeshq</a> · <a href=\"https://profiles.wordpress.org/cwhitmore/\">Cullen Whitmore</a> · <a href=\"https://profiles.wordpress.org/cu121/\">Cupid Chakma</a> · <a href=\"https://profiles.wordpress.org/cweiske/\">cweiske</a> · <a href=\"https://profiles.wordpress.org/coquardcyr/\">Cyrille</a> · <a href=\"https://profiles.wordpress.org/da5f656f/\">da5f656f</a> · <a href=\"https://profiles.wordpress.org/xendo/\">Dademaru</a> · <a href=\"https://profiles.wordpress.org/daleharrison/\">daleharrison</a> · <a href=\"https://profiles.wordpress.org/colorful-tones/\">Damon Cook</a> · <a href=\"https://profiles.wordpress.org/colorful tones/\">Damon Cook</a> · <a href=\"https://profiles.wordpress.org/daniguardiola/\">Dani Guardiola</a> · <a href=\"https://profiles.wordpress.org/talldanwp/\">Daniel Richards</a> · <a href=\"https://profiles.wordpress.org/mte90/\">Daniele Scasciafratte</a> · <a href=\"https://profiles.wordpress.org/itsdanny/\">Danny</a> · <a href=\"https://profiles.wordpress.org/dannyreaktiv/\">dannyreaktiv</a> · <a href=\"https://profiles.wordpress.org/darerodz/\">darerodz</a> · <a href=\"https://profiles.wordpress.org/d-signed/\">Dareth NHANG</a> · <a href=\"https://profiles.wordpress.org/nerrad/\">Darren Ethier (nerrad)</a> · <a href=\"https://profiles.wordpress.org/darshitrajyaguru97/\">Darshit Rajyaguru</a> · <a href=\"https://profiles.wordpress.org/daveagp/\">daveagp</a> · <a href=\"https://profiles.wordpress.org/fac3less/\">David</a> · <a href=\"https://profiles.wordpress.org/dballari/\">David Ballarin Prunera</a> · <a href=\"https://profiles.wordpress.org/davidbaumwald/\">David Baumwald</a> · <a href=\"https://profiles.wordpress.org/davidbinda/\">David Biňovec</a> · <a href=\"https://profiles.wordpress.org/davidabowman/\">David Bowman</a> · <a href=\"https://profiles.wordpress.org/davidhbrown/\">David Brown</a> · <a href=\"https://profiles.wordpress.org/dpcalhoun/\">David Calhoun</a> · <a href=\"https://profiles.wordpress.org/davidgodleman10up/\">David Godleman</a> · <a href=\"https://profiles.wordpress.org/dhenriet/\">David Henriet</a> · <a href=\"https://profiles.wordpress.org/dlh/\">David Herrera</a> · <a href=\"https://profiles.wordpress.org/justlevine/\">David Levine</a> · <a href=\"https://profiles.wordpress.org/daviedr/\">David Rozando</a> · <a href=\"https://profiles.wordpress.org/dshanske/\">David Shanske</a> · <a href=\"https://profiles.wordpress.org/get_dave/\">David Smith</a> · <a href=\"https://profiles.wordpress.org/ddewan/\">ddewan</a> · <a href=\"https://profiles.wordpress.org/dsas/\">Dean Sas</a> · <a href=\"https://profiles.wordpress.org/debarghyabanerjee/\">DEBARGHYA BANERJEE</a> · <a href=\"https://profiles.wordpress.org/deepakrohilla/\">Deepak Rohilla</a> · <a href=\"https://profiles.wordpress.org/deepakvijayan/\">Deepak Vijayan</a> · <a href=\"https://profiles.wordpress.org/dekadinious/\">Dekadinious</a> · <a href=\"https://profiles.wordpress.org/dmsnell/\">Dennis Snell</a> · <a href=\"https://profiles.wordpress.org/dsmart/\">Derek Smart</a> · <a href=\"https://profiles.wordpress.org/deryck/\">Deryck</a> · <a href=\"https://profiles.wordpress.org/designsimply/\">designsimply</a> · <a href=\"https://profiles.wordpress.org/devansh2002/\">Devansh Chaudhary</a> · <a href=\"https://profiles.wordpress.org/devspace/\">devspace</a> · <a href=\"https://profiles.wordpress.org/dhananjaykuber/\">Dhananjay Kuber</a> · <a href=\"https://profiles.wordpress.org/dharm1025/\">Dharmesh Patel</a> · <a href=\"https://profiles.wordpress.org/dhrumilk/\">Dhrumil Kumbhani</a> · <a href=\"https://profiles.wordpress.org/dhruval04/\">Dhruval Shah</a> · <a href=\"https://profiles.wordpress.org/dhruvang21/\">Dhruvang21</a> · <a href=\"https://profiles.wordpress.org/dilipbheda/\">Dilip Bheda</a> · <a href=\"https://profiles.wordpress.org/dilip2615/\">Dilip Modhavadiya</a> · <a href=\"https://profiles.wordpress.org/dd32/\">Dion Hulse</a> · <a href=\"https://profiles.wordpress.org/divibanks/\">Divi Banks</a> · <a href=\"https://profiles.wordpress.org/djcowan/\">dj.cowan</a> · <a href=\"https://profiles.wordpress.org/djennez/\">djennez</a> · <a href=\"https://profiles.wordpress.org/cyberorca/\">Doni Kuntoro</a> · <a href=\"https://profiles.wordpress.org/dorzki/\">Dor Zuberi</a> · <a href=\"https://profiles.wordpress.org/drewapicture/\">Drew Jaynes</a> · <a href=\"https://profiles.wordpress.org/drivingralle/\">Drivingralle</a> · <a href=\"https://profiles.wordpress.org/drzraf/\">drzraf</a> · <a href=\"https://profiles.wordpress.org/elrae/\">Earle Davies</a> · <a href=\"https://profiles.wordpress.org/eballeste/\">eballeste</a> · <a href=\"https://profiles.wordpress.org/eclev91/\">eclev91</a> · <a href=\"https://profiles.wordpress.org/beckej/\">Ed Beck</a> · <a href=\"https://profiles.wordpress.org/ejnwebmaster/\">ejnwebmaster</a> · <a href=\"https://profiles.wordpress.org/elfu98/\">elfu98</a> · <a href=\"https://profiles.wordpress.org/eliorivero/\">Elio Rivero</a> · <a href=\"https://profiles.wordpress.org/ellatrix/\">Ella van&nbsp;Durpe</a> · <a href=\"https://profiles.wordpress.org/erichmond/\">Elliott Richmond</a> · <a href=\"https://profiles.wordpress.org/eatse/\">Emmanue ATSÉ</a> · <a href=\"https://profiles.wordpress.org/manooweb/\">Emmanuel Hesry</a> · <a href=\"https://profiles.wordpress.org/emmanuel78/\">emmanuel78</a> · <a href=\"https://profiles.wordpress.org/lopo/\">Enrico Battocchi</a> · <a href=\"https://profiles.wordpress.org/nrqsnchz/\">Enrique Sánchez</a> · <a href=\"https://profiles.wordpress.org/ericdye/\">Eric Dye</a> · <a href=\"https://profiles.wordpress.org/kebbet/\">Erik</a> · <a href=\"https://profiles.wordpress.org/erikiva/\">erikiva</a> · <a href=\"https://profiles.wordpress.org/erikyo/\">erikyo</a> · <a href=\"https://profiles.wordpress.org/eherman24/\">Evan Herman</a> · <a href=\"https://profiles.wordpress.org/circlecube/\">Evan Mullins</a> · <a href=\"https://profiles.wordpress.org/fabiankaegy/\">Fabian Kägy</a> · <a href=\"https://profiles.wordpress.org/fabiorubioglio/\">Fabio Rubioglio</a> · <a href=\"https://profiles.wordpress.org/fahimmurshed/\">FahimMurshed</a> · <a href=\"https://profiles.wordpress.org/faisalahammad/\">Faisal Ahammad</a> · <a href=\"https://profiles.wordpress.org/faisal03/\">Faisal Alvi</a> · <a href=\"https://profiles.wordpress.org/fazyshah/\">Faizan Nabi</a> · <a href=\"https://profiles.wordpress.org/iamfarhan09/\">Farhan Ahmed</a> · <a href=\"https://profiles.wordpress.org/fayyazfayzi/\">Fayyaz</a> · <a href=\"https://profiles.wordpress.org/flixos90/\">Felix Arntz</a> · <a href=\"https://profiles.wordpress.org/ffffelix/\">Felix Renicks</a> · <a href=\"https://profiles.wordpress.org/fjorgemota/\">Fernando Jorge Mota (a11n)</a> · <a href=\"https://profiles.wordpress.org/firoz2456/\">Firoz Sabaliya</a> · <a href=\"https://profiles.wordpress.org/fcoveram/\">Francisco</a> · <a href=\"https://profiles.wordpress.org/franz00/\">Fransisca H</a> · <a href=\"https://profiles.wordpress.org/fullworks/\">fullworks</a> · <a href=\"https://profiles.wordpress.org/gwallace87/\">Gale Wallace</a> · <a href=\"https://profiles.wordpress.org/gansbrest/\">gansbrest</a> · <a href=\"https://profiles.wordpress.org/garethelwell/\">Gareth Elwell</a> · <a href=\"https://profiles.wordpress.org/garrett-eclipse/\">Garrett Hyder</a> · <a href=\"https://profiles.wordpress.org/pento/\">Gary Pendergast</a> · <a href=\"https://profiles.wordpress.org/gauravtiwari/\">Gaurav Tiwari</a> · <a href=\"https://profiles.wordpress.org/gauravsingh7/\">gauravsingh7</a> · <a href=\"https://profiles.wordpress.org/georgwordpress/\">Georg</a> · <a href=\"https://profiles.wordpress.org/mamaduka/\">George Mamadashvili</a> · <a href=\"https://profiles.wordpress.org/geriux/\">Gerardo Pacheco</a> · <a href=\"https://profiles.wordpress.org/germanfrelo/\">Germán Freixinós</a> · <a href=\"https://profiles.wordpress.org/gmariani405/\">gmariani405</a> · <a href=\"https://profiles.wordpress.org/graemef/\">GraemeF</a> · <a href=\"https://profiles.wordpress.org/grantmkin/\">Grant M. Kinney</a> · <a href=\"https://profiles.wordpress.org/greentreefrog/\">greentreefrog</a> · <a href=\"https://profiles.wordpress.org/greenworld/\">GreenWorld</a> · <a href=\"https://profiles.wordpress.org/gziolo/\">Greg Ziółkowski</a> · <a href=\"https://profiles.wordpress.org/wido/\">Guido Scialfa</a> · <a href=\"https://profiles.wordpress.org/gyurmey/\">Gyurmey</a> · <a href=\"https://profiles.wordpress.org/priethor/\">Héctor Prieto</a> · <a href=\"https://profiles.wordpress.org/halilesen/\">Halil ESEN</a> · <a href=\"https://profiles.wordpress.org/hanneslsm/\">hanneslsm</a> · <a href=\"https://profiles.wordpress.org/hage/\">Hans-Gerd Gerhards</a> · <a href=\"https://profiles.wordpress.org/hardipparmar/\">Hardip Parmar</a> · <a href=\"https://profiles.wordpress.org/hareesh-pillai/\">Hareesh S</a> · <a href=\"https://profiles.wordpress.org/plaidharper/\">Harper Holsinger</a> · <a href=\"https://profiles.wordpress.org/harshgajipara/\">Harsh Gajipara</a> · <a href=\"https://profiles.wordpress.org/harshvaishnav/\">harshvaishnav</a> · <a href=\"https://profiles.wordpress.org/hazdiego/\">Haz</a> · <a href=\"https://profiles.wordpress.org/hectorjarquin/\">hectorjarquin</a> · <a href=\"https://profiles.wordpress.org/hedgefield/\">hedgefield</a> · <a href=\"https://profiles.wordpress.org/helen/\">Helen Hou-Sandi</a> · <a href=\"https://profiles.wordpress.org/iamarinoh/\">Henrique Iamarino</a> · <a href=\"https://profiles.wordpress.org/abcd95/\">Himanshu Pathak</a> · <a href=\"https://profiles.wordpress.org/hirschferkel/\">hirschferkel</a> · <a href=\"https://profiles.wordpress.org/hbhalodia/\">Hit Bhalodia</a> · <a href=\"https://profiles.wordpress.org/h71/\">Hossein</a> · <a href=\"https://profiles.wordpress.org/htmgarcia/\">htmgarcia</a> · <a href=\"https://profiles.wordpress.org/huubl/\">huubl</a> · <a href=\"https://profiles.wordpress.org/huzaifaalmesbah/\">Huzaifa Al Mesbah</a> · <a href=\"https://profiles.wordpress.org/kardi420/\">Ibrahim</a> · <a href=\"https://profiles.wordpress.org/ibrahimriaz/\">Ibrahim Riaz</a> · <a href=\"https://profiles.wordpress.org/imranh920/\">Imran Hossain (a11n)</a> · <a href=\"https://profiles.wordpress.org/isabel_brison/\">Isabel Brison</a> · <a href=\"https://profiles.wordpress.org/itpathsolutions/\">IT Path Solutions</a> · <a href=\"https://profiles.wordpress.org/itapress/\">itapress</a> · <a href=\"https://profiles.wordpress.org/ivanottinger/\">Ivan Ottinger</a> · <a href=\"https://profiles.wordpress.org/jpstevens/\">Jack Stevens</a> · <a href=\"https://profiles.wordpress.org/jacobcassidy/\">Jacob Cassidy</a> · <a href=\"https://profiles.wordpress.org/smithjw1/\">Jacob Smith</a> · <a href=\"https://profiles.wordpress.org/jagirbahesh/\">jagirbahesh</a> · <a href=\"https://profiles.wordpress.org/jainil07/\">Jainil Shah</a> · <a href=\"https://profiles.wordpress.org/jtgreyd/\">Jakob Trost</a> · <a href=\"https://profiles.wordpress.org/jameskoster/\">James Koster</a> · <a href=\"https://profiles.wordpress.org/jamesosborne/\">James Osborne</a> · <a href=\"https://profiles.wordpress.org/jamesros161/\">James Rosado</a> · <a href=\"https://profiles.wordpress.org/jwgoedert/\">James Wesley Goedert</a> · <a href=\"https://profiles.wordpress.org/janpfeil/\">Jan Pfeil</a> · <a href=\"https://profiles.wordpress.org/janak007/\">janak Kaneriya</a> · <a href=\"https://profiles.wordpress.org/jsnajdr/\">Jarda Snajdr</a> · <a href=\"https://profiles.wordpress.org/jarekmorawski/\">jarekmorawski</a> · <a href=\"https://profiles.wordpress.org/ipajen/\">Jarko Piironen</a> · <a href=\"https://profiles.wordpress.org/jasonbahl/\">Jason Bahl</a> · <a href=\"https://profiles.wordpress.org/madtownlems/\">Jason LeMahieu (MadtownLems)</a> · <a href=\"https://profiles.wordpress.org/javad2000/\">javad2000</a> · <a href=\"https://profiles.wordpress.org/javiarce/\">Javier Arce</a> · <a href=\"https://profiles.wordpress.org/jawadwp/\">Jawad Malik</a> · <a href=\"https://profiles.wordpress.org/topdownjimmy/\">Jay</a> · <a href=\"https://profiles.wordpress.org/jayadevankbh/\">Jayadevan k</a> · <a href=\"https://profiles.wordpress.org/drjosh07/\">jbrya029</a> · <a href=\"https://profiles.wordpress.org/jdahir0789/\">JD Ahir</a> · <a href=\"https://profiles.wordpress.org/audrasjb/\">Jean-Baptiste Audras</a> · <a href=\"https://profiles.wordpress.org/krokodok/\">Jeff Chi</a> · <a href=\"https://profiles.wordpress.org/jffng/\">Jeff Ong</a> · <a href=\"https://profiles.wordpress.org/cheffheid/\">Jeffrey de Wit</a> · <a href=\"https://profiles.wordpress.org/jeffpaul/\">Jeffrey Paul</a> · <a href=\"https://profiles.wordpress.org/jenilk/\">Jenil Kanani</a> · <a href=\"https://profiles.wordpress.org/jennifarhat/\">Jennifer Farhat</a> · <a href=\"https://profiles.wordpress.org/jdy68/\">Jenny Dupuy</a> · <a href=\"https://profiles.wordpress.org/jeremyfelt/\">Jeremy Felt</a> · <a href=\"https://profiles.wordpress.org/jeherve/\">Jeremy Herve</a> · <a href=\"https://profiles.wordpress.org/jeryj/\">Jerry Jones</a> · <a href=\"https://profiles.wordpress.org/skobe/\">Jesko Bendmann</a> · <a href=\"https://profiles.wordpress.org/luminuu/\">Jessica Lyschik</a> · <a href=\"https://profiles.wordpress.org/jetaldobariya1/\">jetaldobariya1</a> · <a href=\"https://profiles.wordpress.org/jigar9998/\">Jigar Panchal</a> · <a href=\"https://profiles.wordpress.org/jimmyh61/\">jimmyh61</a> · <a href=\"https://profiles.wordpress.org/joedolson/\">Joe Dolson</a> · <a href=\"https://profiles.wordpress.org/joehoyle/\">Joe Hoyle</a> · <a href=\"https://profiles.wordpress.org/joemcgill/\">Joe McGill</a> · <a href=\"https://profiles.wordpress.org/joen/\">Joen Asmussen</a> · <a href=\"https://profiles.wordpress.org/johnbillion/\">John Blackbourn</a> · <a href=\"https://profiles.wordpress.org/johnillo/\">John Espiritu</a> · <a href=\"https://profiles.wordpress.org/johnny5/\">John Godley</a> · <a href=\"https://profiles.wordpress.org/johnjamesjacoby/\">John James Jacoby</a> · <a href=\"https://profiles.wordpress.org/johnregan3/\">John Regan</a> · <a href=\"https://profiles.wordpress.org/lwangaman/\">JohnRDOrazio</a> · <a href=\"https://profiles.wordpress.org/jonsurrell/\">Jon Surrell</a> · <a href=\"https://profiles.wordpress.org/elbsegler/\">Jonas</a> · <a href=\"https://profiles.wordpress.org/psykro/\">Jonathan Bossenger</a> · <a href=\"https://profiles.wordpress.org/desrosj/\">Jonathan Desrosiers</a> · <a href=\"https://profiles.wordpress.org/spacedmonkey/\">Jonny Harris</a> · <a href=\"https://profiles.wordpress.org/jonnywatersbb/\">Jonny Waters</a> · <a href=\"https://profiles.wordpress.org/jordesign/\">jordesign</a> · <a href=\"https://profiles.wordpress.org/jorgefilipecosta/\">Jorge Costa</a> · <a href=\"https://profiles.wordpress.org/josklever/\">Jos Klever</a> · <a href=\"https://profiles.wordpress.org/josevarghese/\">Jose Varghese</a> · <a href=\"https://profiles.wordpress.org/chanthaboune/\">Josepha</a> · <a href=\"https://profiles.wordpress.org/verygoode/\">Joshua Goode</a> · <a href=\"https://profiles.wordpress.org/jossnaz/\">Jossnaz</a> · <a href=\"https://profiles.wordpress.org/juanfra/\">Juan Aldasoro</a> · <a href=\"https://profiles.wordpress.org/juanmaguitar/\">JuanMa Garrido</a> · <a href=\"https://profiles.wordpress.org/julianoe/\">julianoe</a> · <a href=\"https://profiles.wordpress.org/juliemoynat/\">Julie Moynat</a> · <a href=\"https://profiles.wordpress.org/jrf/\">Juliette Reinders Folmer</a> · <a href=\"https://profiles.wordpress.org/junedsabaliya/\">Juned Sabaliya</a> · <a href=\"https://profiles.wordpress.org/greenshady/\">Justin Tadlock</a> · <a href=\"https://profiles.wordpress.org/kadamwhite/\">K. Adam White</a> · <a href=\"https://profiles.wordpress.org/kaavyaiyer/\">Kaavya Iyer (woo-hc)</a> · <a href=\"https://profiles.wordpress.org/arkenon/\">Kadim Gültekin</a> · <a href=\"https://profiles.wordpress.org/kafleg/\">KafleG</a> · <a href=\"https://profiles.wordpress.org/kevin940726/\">Kai Hao</a> · <a href=\"https://profiles.wordpress.org/kajalgohel/\">Kajal Gohel</a> · <a href=\"https://profiles.wordpress.org/ikamal/\">Kamal Hosen</a> · <a href=\"https://profiles.wordpress.org/kamran8176/\">Kamran Hussen</a> · <a href=\"https://profiles.wordpress.org/karan4word/\">Karan Gupta</a> · <a href=\"https://profiles.wordpress.org/karolmanijak/\">Karol Manijak</a> · <a href=\"https://profiles.wordpress.org/thekt12/\">Karthik Thayyil</a> · <a href=\"https://profiles.wordpress.org/kartikmehta/\">Kartik Mehta</a> · <a href=\"https://profiles.wordpress.org/kartik-suthar/\">Kartik Suthar</a> · <a href=\"https://profiles.wordpress.org/kbrownkd/\">kbrownkd (a11n)</a> · <a href=\"https://profiles.wordpress.org/keffr3n/\">Keffr3n</a> · <a href=\"https://profiles.wordpress.org/kel-dc/\">Kel Santiago-Pilarski</a> · <a href=\"https://profiles.wordpress.org/kellenmace/\">Kellen Mace</a> · <a href=\"https://profiles.wordpress.org/ryelle/\">Kelly Choyce-Dwan</a> · <a href=\"https://profiles.wordpress.org/keoshi/\">keoshi</a> · <a href=\"https://profiles.wordpress.org/kevinb/\">Kevin Behrens</a> · <a href=\"https://profiles.wordpress.org/ktaron/\">Kevin Taron</a> · <a href=\"https://profiles.wordpress.org/kevinswalsh/\">kevinswalsh</a> · <a href=\"https://profiles.wordpress.org/khokansardar/\">Khokan Sardar</a> · <a href=\"https://profiles.wordpress.org/kirasong/\">Kira Schroder</a> · <a href=\"https://profiles.wordpress.org/kishanjasani/\">Kishan Jasani</a> · <a href=\"https://profiles.wordpress.org/kisquian/\">kisquian</a> · <a href=\"https://profiles.wordpress.org/kjellr/\">Kjell Reigstad</a> · <a href=\"https://profiles.wordpress.org/kkmuffme/\">kkmuffme</a> · <a href=\"https://profiles.wordpress.org/knutsp/\">Knut Sparhell</a> · <a href=\"https://profiles.wordpress.org/kowsar89/\">Kowsar Hossain</a> · <a href=\"https://profiles.wordpress.org/kracked888/\">kracked888</a> · <a href=\"https://profiles.wordpress.org/krishneup/\">Krishna Neupane</a> · <a href=\"https://profiles.wordpress.org/kristastevens/\">kristastevens</a> · <a href=\"https://profiles.wordpress.org/krupajnanda/\">Krupa Nanda</a> · <a href=\"https://profiles.wordpress.org/krupalpanchal/\">Krupal Panchal</a> · <a href=\"https://profiles.wordpress.org/kmadhak/\">Kunal Madhak</a> · <a href=\"https://profiles.wordpress.org/gohelkunjan/\">Kunjan Gohel</a> · <a href=\"https://profiles.wordpress.org/kurtpayne/\">Kurt Payne</a> · <a href=\"https://profiles.wordpress.org/kushang78/\">Kushang Tailor</a> · <a href=\"https://profiles.wordpress.org/mlaetitia/\">Lae</a> · <a href=\"https://profiles.wordpress.org/notlaura/\">Lara Schenck</a> · <a href=\"https://profiles.wordpress.org/lastsplash/\">lastsplash (a11n)</a> · <a href=\"https://profiles.wordpress.org/newyorkerlaura/\">Laura Byrne</a> · <a href=\"https://profiles.wordpress.org/laurelfulford/\">laurelfulford</a> · <a href=\"https://profiles.wordpress.org/oncecoupled/\">Lauren</a> · <a href=\"https://profiles.wordpress.org/laranz/\">Lawrence Joe</a> · <a href=\"https://profiles.wordpress.org/leemon/\">leemon</a> · <a href=\"https://profiles.wordpress.org/0mirka00/\">Lena Morita</a> · <a href=\"https://profiles.wordpress.org/lgladdy/\">Liam Gladdy</a> · <a href=\"https://profiles.wordpress.org/lifelightweb/\">lifelightweb</a> · <a href=\"https://profiles.wordpress.org/rudlinkon/\">Linkon Miyan</a> · <a href=\"https://profiles.wordpress.org/linsoftware/\">Linnea Huxford</a> · <a href=\"https://profiles.wordpress.org/liviopv/\">liviopv</a> · <a href=\"https://profiles.wordpress.org/louiswol94/\">Louis Wolmarans</a> · <a href=\"https://profiles.wordpress.org/louwie17/\">Lourens</a> · <a href=\"https://profiles.wordpress.org/lovesoni1999/\">Love Soni</a> · <a href=\"https://profiles.wordpress.org/crixu/\">Lucas</a> · <a href=\"https://profiles.wordpress.org/gigitux/\">Luigi Teschio</a> · <a href=\"https://profiles.wordpress.org/zaguiini/\">Luis Felipe Zaguini</a> · <a href=\"https://profiles.wordpress.org/luisherranz/\">luisherranz</a> · <a href=\"https://profiles.wordpress.org/lukasbesch/\">lukasbesch</a> · <a href=\"https://profiles.wordpress.org/lukecarbis/\">Luke Carbis</a> · <a href=\"https://profiles.wordpress.org/madhudollu/\">Madhu Dollu</a> · <a href=\"https://profiles.wordpress.org/madpeter/\">madpeter</a> · <a href=\"https://profiles.wordpress.org/onemaggie/\">Maggie Cabrera</a> · <a href=\"https://profiles.wordpress.org/nadimcse/\">Mahmudul Haque Nadim</a> · <a href=\"https://profiles.wordpress.org/mai21/\">Mai</a> · <a href=\"https://profiles.wordpress.org/mkrndmane/\">Makarand G. Mane</a> · <a href=\"https://profiles.wordpress.org/manbo/\">manbo</a> · <a href=\"https://profiles.wordpress.org/maneshtimilsina/\">Manesh Timilsina</a> · <a href=\"https://profiles.wordpress.org/targz-1/\">Manuel Schmalstieg</a> · <a href=\"https://profiles.wordpress.org/manzoorwanijk/\">Manzoor Wani (a11n)</a> · <a href=\"https://profiles.wordpress.org/marianguas/\">María Anguas</a> · <a href=\"https://profiles.wordpress.org/mdxfr/\">Marc</a> · <a href=\"https://profiles.wordpress.org/marc4/\">Marc Armengou</a> · <a href=\"https://profiles.wordpress.org/mardroid/\">Marcel Tannich</a> · <a href=\"https://profiles.wordpress.org/fullofcaffeine/\">Marcelo de Moraes Serpa</a> · <a href=\"https://profiles.wordpress.org/iworks/\">Marcin Pietrzak</a> · <a href=\"https://profiles.wordpress.org/mciampini/\">Marco Ciampini</a> · <a href=\"https://profiles.wordpress.org/pereirinha/\">Marco Pereirinha</a> · <a href=\"https://profiles.wordpress.org/marcwieland95/\">marcwieland95</a> · <a href=\"https://profiles.wordpress.org/igreenie/\">Marek Železný</a> · <a href=\"https://profiles.wordpress.org/margolisj/\">margolisj</a> · <a href=\"https://profiles.wordpress.org/mariayohana/\">Maria Yohana</a> · <a href=\"https://profiles.wordpress.org/plari/\">Marie</a> · <a href=\"https://profiles.wordpress.org/tyxla/\">Marin Atanasov</a> · <a href=\"https://profiles.wordpress.org/santosguillamot/\">Mario Santos</a> · <a href=\"https://profiles.wordpress.org/clorith/\">Marius L. J.</a> · <a href=\"https://profiles.wordpress.org/marius84/\">mariushosting</a> · <a href=\"https://profiles.wordpress.org/markhowellsmead/\">Mark Howells-Mead</a> · <a href=\"https://profiles.wordpress.org/markparnell/\">Mark Parnell</a> · <a href=\"https://profiles.wordpress.org/mark-k/\">Mark-k</a> · <a href=\"https://profiles.wordpress.org/mhkuu/\">Martijn van der Klis</a> · <a href=\"https://profiles.wordpress.org/martinkrcho/\">martin.krcho</a> · <a href=\"https://profiles.wordpress.org/marybaum/\">marybaum</a> · <a href=\"https://profiles.wordpress.org/mat_/\">mat_</a> · <a href=\"https://profiles.wordpress.org/mmaattiiaass/\">Matias Benedetto</a> · <a href=\"https://profiles.wordpress.org/matveb/\">Matias Ventura</a> · <a href=\"https://profiles.wordpress.org/matt/\">Matt Mullenweg</a> · <a href=\"https://profiles.wordpress.org/mattyrob/\">Matt Robinson</a> · <a href=\"https://profiles.wordpress.org/mattormeeple/\">Matt Sherman</a> · <a href=\"https://profiles.wordpress.org/matteoenna/\">Matteo Enna</a> · <a href=\"https://profiles.wordpress.org/mboynes/\">Matthew Boynes</a> · <a href=\"https://profiles.wordpress.org/lonelyvegan/\">Matthew Riley MacPherson</a> · <a href=\"https://profiles.wordpress.org/kittmedia/\">Matthias Kittsteiner</a> · <a href=\"https://profiles.wordpress.org/mattraines/\">mattraines</a> · <a href=\"https://profiles.wordpress.org/maurodf/\">maurodf</a> · <a href=\"https://profiles.wordpress.org/mayanktripathi32/\">Mayank Tripathi</a> · <a href=\"https://profiles.wordpress.org/mayur8991/\">Mayur Prajapati</a> · <a href=\"https://profiles.wordpress.org/mcrisp1972/\">mcrisp1972</a> · <a href=\"https://profiles.wordpress.org/hmbashar/\">Md Abul Bashar</a> · <a href=\"https://profiles.wordpress.org/mhshohel/\">Md Hossain Shohel</a> · <a href=\"https://profiles.wordpress.org/istiaqhossain/\">Md. Istiaq Hossain</a> · <a href=\"https://profiles.wordpress.org/mdviralsampat/\">mdviralsampat</a> · <a href=\"https://profiles.wordpress.org/megane9988/\">megane9988</a> · <a href=\"https://profiles.wordpress.org/iammehedi1/\">Mehedi Hassan</a> · <a href=\"https://profiles.wordpress.org/mehulkaklotar/\">Mehul Kaklotar</a> · <a href=\"https://profiles.wordpress.org/melchoyce/\">Mel Choyce-Dwan</a> · <a href=\"https://profiles.wordpress.org/meteorlxy/\">meteorlxy</a> · <a href=\"https://profiles.wordpress.org/mfgmicha/\">Micha Krapp</a> · <a href=\"https://profiles.wordpress.org/tw2113/\">Michael Beckwith</a> · <a href=\"https://profiles.wordpress.org/michaelbourne/\">Michael Bourne</a> · <a href=\"https://profiles.wordpress.org/hrkhal/\">Michael James Ilett</a> · <a href=\"https://profiles.wordpress.org/michaelpick/\">michaelpick</a> · <a href=\"https://profiles.wordpress.org/michaelwp85/\">michaelwp85</a> · <a href=\"https://profiles.wordpress.org/czapla/\">Michal Czaplinski</a> · <a href=\"https://profiles.wordpress.org/mielbu/\">Michelle Bulloch</a> · <a href=\"https://profiles.wordpress.org/miguelaxcar/\">Miguel Axcar</a> · <a href=\"https://profiles.wordpress.org/mcsf/\">Miguel Fonseca</a> · <a href=\"https://profiles.wordpress.org/migueluy/\">Miguel Lezama</a> · <a href=\"https://profiles.wordpress.org/simison/\">Mikael Korpela</a> · <a href=\"https://profiles.wordpress.org/mmcalister/\">Mike McAlister</a> · <a href=\"https://profiles.wordpress.org/ritterml/\">Mike Ritter</a> · <a href=\"https://profiles.wordpress.org/mikeb8s/\">mikeb8s</a> · <a href=\"https://profiles.wordpress.org/mikeybinns/\">Mikey Binns</a> · <a href=\"https://profiles.wordpress.org/milamj/\">milamj</a> · <a href=\"https://profiles.wordpress.org/milana_cap/\">Milana Cap</a> · <a href=\"https://profiles.wordpress.org/presstoke/\">Mitchell Austin</a> · <a href=\"https://profiles.wordpress.org/mklusak/\">mklusak</a> · <a href=\"https://profiles.wordpress.org/mleathem/\">mleathem</a> · <a href=\"https://profiles.wordpress.org/mlf20/\">mlf20</a> · <a href=\"https://profiles.wordpress.org/mobarak/\">Mobarak Ali</a> · <a href=\"https://profiles.wordpress.org/mohitdadhich10/\">Mohit Dadhich</a> · <a href=\"https://profiles.wordpress.org/morganestes/\">Morgan Estes</a> · <a href=\"https://profiles.wordpress.org/mosne/\">Mosne / Paolo Tesei</a> · <a href=\"https://profiles.wordpress.org/mossy2100/\">mossy2100</a> · <a href=\"https://profiles.wordpress.org/mreishus/\">mreishus</a> · <a href=\"https://profiles.wordpress.org/devmuhib/\">Muhibul Haque</a> · <a href=\"https://profiles.wordpress.org/mujuonly/\">mujuonly</a> · <a href=\"https://profiles.wordpress.org/mukesh27/\">Mukesh Panchal</a> · <a href=\"https://profiles.wordpress.org/faguni22/\">Mumtahina Faguni</a> · <a href=\"https://profiles.wordpress.org/assassinateur/\">Nadir Seghir a11n</a> · <a href=\"https://profiles.wordpress.org/naeemhaque/\">Naeem Haque</a> · <a href=\"https://profiles.wordpress.org/nagpai/\">Nagesh Pai</a> · <a href=\"https://profiles.wordpress.org/narenin/\">Narendra Sishodiya</a> · <a href=\"https://profiles.wordpress.org/nareshbheda/\">Naresh Bheda</a> · <a href=\"https://profiles.wordpress.org/n8finch/\">Nate Finch</a> · <a href=\"https://profiles.wordpress.org/nateinaction/\">Nate Gay</a> · <a href=\"https://profiles.wordpress.org/nhrrob/\">Nazmul Hasan Robin</a> · <a href=\"https://profiles.wordpress.org/nebojsajurcic/\">Nebojša Jurčić</a> · <a href=\"https://profiles.wordpress.org/nek285/\">nek285</a> · <a href=\"https://profiles.wordpress.org/nendeb55/\">nendeb</a> · <a href=\"https://profiles.wordpress.org/neo2k23/\">neo2k23</a> · <a href=\"https://profiles.wordpress.org/neotrope/\">neotrope</a> · <a href=\"https://profiles.wordpress.org/eidolonnight/\">Nicholas Garofalo</a> · <a href=\"https://profiles.wordpress.org/nickbohle/\">Nick Bohle</a> · <a href=\"https://profiles.wordpress.org/ndiego/\">Nick Diego</a> · <a href=\"https://profiles.wordpress.org/celloexpressions/\">Nick Halsey</a> · <a href=\"https://profiles.wordpress.org/nick_thegeek/\">Nick the Geek</a> · <a href=\"https://profiles.wordpress.org/nicolefurlan/\">Nicole Furlan</a> · <a href=\"https://profiles.wordpress.org/nidhidhandhukiya/\">nidhidhandhukiya</a> · <a href=\"https://profiles.wordpress.org/nihar007/\">Nihar Ranjan Das</a> · <a href=\"https://profiles.wordpress.org/ntsekouras/\">Nik Tsekouras</a> · <a href=\"https://profiles.wordpress.org/nikitasolanki1812/\">Nikita Solanki</a> · <a href=\"https://profiles.wordpress.org/nirajgirixd/\">Niraj Giri</a> · <a href=\"https://profiles.wordpress.org/niravsherasiya7707/\">Nirav Sherasiya</a> · <a href=\"https://profiles.wordpress.org/nithi22/\">Nithin John</a> · <a href=\"https://profiles.wordpress.org/nithins53/\">Nithin SreeRaj</a> · <a href=\"https://profiles.wordpress.org/noahtallen/\">Noah Allen</a> · <a href=\"https://profiles.wordpress.org/noruzzaman/\">Noruzzaman</a> · <a href=\"https://profiles.wordpress.org/nurielmeni/\">nurielmeni</a> · <a href=\"https://profiles.wordpress.org/obliviousharmony/\">obliviousharmony</a> · <a href=\"https://profiles.wordpress.org/finalwebsites/\">Olaf Lederer</a> · <a href=\"https://profiles.wordpress.org/oglekler/\">Olga Gleckler</a> · <a href=\"https://profiles.wordpress.org/domainsupport/\">Oliver Campion</a> · <a href=\"https://profiles.wordpress.org/olivierlafleur/\">Olivier Lafleur</a> · <a href=\"https://profiles.wordpress.org/alshakero/\">Omar Alshaker</a> · <a href=\"https://profiles.wordpress.org/oscarhugopaz/\">Oscar Hugo Paz</a> · <a href=\"https://profiles.wordpress.org/prestonwordsworth/\">p15h</a> · <a href=\"https://profiles.wordpress.org/paaljoachim/\">Paal Joachim Romdahl</a> · <a href=\"https://profiles.wordpress.org/otakupahp/\">Pablo Hernández</a> · <a href=\"https://profiles.wordpress.org/pablohoneyhoney/\">Pablo Honey</a> · <a href=\"https://profiles.wordpress.org/pamprn/\">Pamela Ribeiro</a> · <a href=\"https://profiles.wordpress.org/pander/\">pander</a> · <a href=\"https://profiles.wordpress.org/pls78/\">Paolo L. Scala</a> · <a href=\"https://profiles.wordpress.org/paragoninitiativeenterprises/\">Paragon Initiative Enterprises</a> · <a href=\"https://profiles.wordpress.org/parinpanjari/\">Parin Panjari</a> · <a href=\"https://profiles.wordpress.org/parthvataliya/\">Parth vataliya</a> · <a href=\"https://profiles.wordpress.org/swissspidy/\">Pascal Birchler</a> · <a href=\"https://profiles.wordpress.org/obrienlabs/\">Pat O’Brien</a> · <a href=\"https://profiles.wordpress.org/patricia70/\">Patricia BT</a> · <a href=\"https://profiles.wordpress.org/lumiblog/\">Patrick Lumumba</a> · <a href=\"https://profiles.wordpress.org/pbearne/\">Paul Bearne</a> · <a href=\"https://profiles.wordpress.org/pbiron/\">Paul Biron</a> · <a href=\"https://profiles.wordpress.org/paulkevan/\">Paul Kevan</a> · <a href=\"https://profiles.wordpress.org/paulschreiber/\">Paul Schreiber</a> · <a href=\"https://profiles.wordpress.org/paulwilde/\">Paul Wilde</a> · <a href=\"https://profiles.wordpress.org/paulcline/\">paulcline</a> · <a href=\"https://profiles.wordpress.org/paulopmt1/\">Paulo Trentin</a> · <a href=\"https://profiles.wordpress.org/pavanpatil1/\">Pavan Patil</a> · <a href=\"https://profiles.wordpress.org/pcarvalho/\">pcarvalho</a> · <a href=\"https://profiles.wordpress.org/pedromendonca/\">Pedro Mendonça</a> · <a href=\"https://profiles.wordpress.org/perryrylance/\">perryrylance</a> · <a href=\"https://profiles.wordpress.org/provenself/\">Peter Rubin</a> · <a href=\"https://profiles.wordpress.org/peterwilsoncc/\">Peter Wilson</a> · <a href=\"https://profiles.wordpress.org/petitphp/\">petitphp</a> · <a href=\"https://profiles.wordpress.org/pevogam/\">pevogam</a> · <a href=\"https://profiles.wordpress.org/mr2p/\">Phi Phan</a> · <a href=\"https://profiles.wordpress.org/johnstonphilip/\">Phil Johnston</a> · <a href=\"https://profiles.wordpress.org/tyrannous/\">Philipp Bammes</a> · <a href=\"https://profiles.wordpress.org/philwebs/\">philwebs</a> · <a href=\"https://profiles.wordpress.org/nekojonez/\">Pieterjan Deneys</a> · <a href=\"https://profiles.wordpress.org/boniu91/\">Piotrek Boniu</a> · <a href=\"https://profiles.wordpress.org/pitamdey/\">Pitam Dey</a> · <a href=\"https://profiles.wordpress.org/pgeorgiev/\">Plamen Georgiev</a> · <a href=\"https://profiles.wordpress.org/pooja1210/\">Pooja N Muchandikar</a> · <a href=\"https://profiles.wordpress.org/pooja9712/\">pooja9712</a> · <a href=\"https://profiles.wordpress.org/porg/\">porg</a> · <a href=\"https://profiles.wordpress.org/ppolo99/\">ppolo99</a> · <a href=\"https://profiles.wordpress.org/praful2111/\">Praful Patel</a> · <a href=\"https://profiles.wordpress.org/pranitdugad/\">Pranit Dugad</a> · <a href=\"https://profiles.wordpress.org/pratikkry/\">Pratik Kumar</a> · <a href=\"https://profiles.wordpress.org/presskopp/\">Presskopp</a> · <a href=\"https://profiles.wordpress.org/prettyboymp/\">prettyboymp</a> · <a href=\"https://profiles.wordpress.org/prionkor/\">prionkor</a> · <a href=\"https://profiles.wordpress.org/pwtyler/\">pwtyler</a> · <a href=\"https://profiles.wordpress.org/rachelbaker/\">Rachel Baker</a> · <a href=\"https://profiles.wordpress.org/spanglishwebs/\">Rachel Winspear</a> · <a href=\"https://profiles.wordpress.org/rfischmann/\">Rafael Fischmann</a> · <a href=\"https://profiles.wordpress.org/rafaelgalani/\">Rafael Gallani</a> · <a href=\"https://profiles.wordpress.org/rafiq91/\">Rafiqul Islam</a> · <a href=\"https://profiles.wordpress.org/rahmatgumilar/\">Rahmat Gumilar</a> · <a href=\"https://profiles.wordpress.org/rahulharpal/\">rahulharpal</a> · <a href=\"https://profiles.wordpress.org/imrraaj/\">Raj Patel</a> · <a href=\"https://profiles.wordpress.org/rajinsharwar/\">Rajin Sharwar</a> · <a href=\"https://profiles.wordpress.org/shashwatahalder01/\">rajkumar shashwata halder</a> · <a href=\"https://profiles.wordpress.org/rahmohn/\">Ramon Ahnert</a> · <a href=\"https://profiles.wordpress.org/rcorrales/\">Ramon Corrales</a> · <a href=\"https://profiles.wordpress.org/ramon-fincken/\">ramon fincken</a> · <a href=\"https://profiles.wordpress.org/ramonopoly/\">Ramon James</a> · <a href=\"https://profiles.wordpress.org/ramswarup/\">Ramswarup Rathod</a> · <a href=\"https://profiles.wordpress.org/xyulex/\">Raul Martinez</a> · <a href=\"https://profiles.wordpress.org/rcneil/\">rcneil</a> · <a href=\"https://profiles.wordpress.org/realthemes/\">realthemes</a> · <a href=\"https://profiles.wordpress.org/rejaulalomkhan/\">Rejaul Alom Khan</a> · <a href=\"https://profiles.wordpress.org/renathoc/\">Renatho (a11n)</a> · <a href=\"https://profiles.wordpress.org/reputeinfosystems/\">reputeinfosystems</a> · <a href=\"https://profiles.wordpress.org/retrofox/\">retrofox</a> · <a href=\"https://profiles.wordpress.org/youknowriad/\">Riad Benguella</a> · <a href=\"https://profiles.wordpress.org/richtabor/\">Rich Tabor</a> · <a href=\"https://profiles.wordpress.org/rhellewellgmailcom/\">Rick Hellewell</a> · <a href=\"https://profiles.wordpress.org/riddhipatel/\">Riddhi Patel</a> · <a href=\"https://profiles.wordpress.org/rcreators/\">Rishi Mehta</a> · <a href=\"https://profiles.wordpress.org/rishishah/\">Rishi Shah</a> · <a href=\"https://profiles.wordpress.org/rishit30g/\">Rishit Gupta</a> · <a href=\"https://profiles.wordpress.org/rithik56/\">rithik56</a> · <a href=\"https://profiles.wordpress.org/noisysocks/\">Robert Anderson</a> · <a href=\"https://profiles.wordpress.org/robert-biswas/\">Robert Biswas</a> · <a href=\"https://profiles.wordpress.org/robertghetau/\">Robert Ghetau</a> · <a href=\"https://profiles.wordpress.org/rocketworks/\">rocket.works – Dominik Friedrich</a> · <a href=\"https://profiles.wordpress.org/rodelgc/\">Rodel Calasagsag a11n</a> · <a href=\"https://profiles.wordpress.org/rghedin/\">Rodrigo</a> · <a href=\"https://profiles.wordpress.org/rodrigosprimo/\">Rodrigo Primo</a> · <a href=\"https://profiles.wordpress.org/geekofshire/\">Rohan Jha</a> · <a href=\"https://profiles.wordpress.org/rohitmathur7/\">rohitmathur7</a> · <a href=\"https://profiles.wordpress.org/costasovo/\">Rostislav Wolný</a> · <a href=\"https://profiles.wordpress.org/roytanck/\">Roy Tanck</a> · <a href=\"https://profiles.wordpress.org/roygbyte/\">roygbyte</a> · <a href=\"https://profiles.wordpress.org/royho/\">royho</a> · <a href=\"https://profiles.wordpress.org/rpf5573/\">rpf5573</a> · <a href=\"https://profiles.wordpress.org/rslee/\">rslee</a> · <a href=\"https://profiles.wordpress.org/ruchirj/\">Ruchir Goswami</a> · <a href=\"https://profiles.wordpress.org/rayhatron/\">Rufaro Madamombe</a> · <a href=\"https://profiles.wordpress.org/ryan/\">Ryan Boren</a> · <a href=\"https://profiles.wordpress.org/rleeson/\">Ryan Leeson</a> · <a href=\"https://profiles.wordpress.org/ryancurban/\">Ryan Urban</a> · <a href=\"https://profiles.wordpress.org/welcher/\">Ryan Welcher</a> · <a href=\"https://profiles.wordpress.org/sppramodh/\">S P Pramodh</a> · <a href=\"https://profiles.wordpress.org/sebastienserre/\">Sébastien SERRE</a> · <a href=\"https://profiles.wordpress.org/sergiomdgomes/\">Sérgio Gomes</a> · <a href=\"https://profiles.wordpress.org/soean/\">Sören Wünsch</a> · <a href=\"https://profiles.wordpress.org/sadmansh/\">sadmansh</a> · <a href=\"https://profiles.wordpress.org/isaeedam/\">Saeed Piri</a> · <a href=\"https://profiles.wordpress.org/mi5t4n/\">Sagar Tamang</a> · <a href=\"https://profiles.wordpress.org/sahiladit/\">sahiladit</a> · <a href=\"https://profiles.wordpress.org/sainathpoojary/\">Sainath Poojary</a> · <a href=\"https://profiles.wordpress.org/sakibmd/\">Sakib Mohammed</a> · <a href=\"https://profiles.wordpress.org/samtoohey93/\">Sam Toohey</a> · <a href=\"https://profiles.wordpress.org/samiamnot/\">samiamnot</a> · <a href=\"https://profiles.wordpress.org/viralsampat/\">Sampat Viral</a> · <a href=\"https://profiles.wordpress.org/samuelsidler/\">Samuel Sidler</a> · <a href=\"https://profiles.wordpress.org/samuelsilvapt/\">Samuel Silva</a> · <a href=\"https://profiles.wordpress.org/sannevndrmeulen/\">Sanne van der Meulen</a> · <a href=\"https://profiles.wordpress.org/mikachan/\">Sarah Norris</a> · <a href=\"https://profiles.wordpress.org/sarahricker/\">sarahricker</a> · <a href=\"https://profiles.wordpress.org/sarthaknagoshe2002/\">Sarthak Nagoshe</a> · <a href=\"https://profiles.wordpress.org/sathyapulse/\">Sathiya Venkatesan</a> · <a href=\"https://profiles.wordpress.org/satishprajapati/\">Satish Prajapati</a> · <a href=\"https://profiles.wordpress.org/sfougnier/\">Saul Fougnier</a> · <a href=\"https://profiles.wordpress.org/sauliusv/\">Saulius Vikerta</a> · <a href=\"https://profiles.wordpress.org/saxonafletcher/\">Saxon Fletcher</a> · <a href=\"https://profiles.wordpress.org/sayedulsayem/\">Sayedul Sayem</a> · <a href=\"https://profiles.wordpress.org/scholdstrom/\">scholdstrom</a> · <a href=\"https://profiles.wordpress.org/swb1192/\">Scott Buscemi</a> · <a href=\"https://profiles.wordpress.org/sc0ttkclark/\">Scott Kingsley Clark</a> · <a href=\"https://profiles.wordpress.org/coffee2code/\">Scott Reilly</a> · <a href=\"https://profiles.wordpress.org/wonderboymusic/\">Scott Taylor</a> · <a href=\"https://profiles.wordpress.org/scottculverhouse/\">scottculverhouse</a> · <a href=\"https://profiles.wordpress.org/seanavers/\">seanavers</a> · <a href=\"https://profiles.wordpress.org/seifradwane/\">Seif Radwane</a> · <a href=\"https://profiles.wordpress.org/kuuuzya/\">Sergey</a> · <a href=\"https://profiles.wordpress.org/sergeybiryukov/\">Sergey Biryukov</a> · <a href=\"https://profiles.wordpress.org/zahardoc/\">Serhiy Zakharchenko</a> · <a href=\"https://profiles.wordpress.org/smrubenstein/\">Seth Rubenstein</a> · <a href=\"https://profiles.wordpress.org/shailu25/\">Shail Mehta</a> · <a href=\"https://profiles.wordpress.org/sh4lin/\">Shalin Shah</a> · <a href=\"https://profiles.wordpress.org/sharonaustin/\">Sharon Austin</a> · <a href=\"https://profiles.wordpress.org/sheulyshila/\">sheulyshila</a> · <a href=\"https://profiles.wordpress.org/spdft/\">Shoe</a> · <a href=\"https://profiles.wordpress.org/showravhasan/\">Showrav Hasan</a> · <a href=\"https://profiles.wordpress.org/shreya0204/\">Shreya Agarwal</a> · <a href=\"https://profiles.wordpress.org/silaskoehler/\">Silas Köhler</a> · <a href=\"https://profiles.wordpress.org/siliconforks/\">siliconforks</a> · <a href=\"https://profiles.wordpress.org/simo_m/\">Simone Maranzana</a> · <a href=\"https://profiles.wordpress.org/siobhyb/\">Siobhan</a> · <a href=\"https://profiles.wordpress.org/smerriman/\">smerriman</a> · <a href=\"https://profiles.wordpress.org/snehapatil02/\">Sneha Patil</a> · <a href=\"https://profiles.wordpress.org/sophiegy/\">Sophie – a11n</a> · <a href=\"https://profiles.wordpress.org/souptik/\">Souptik Datta</a> · <a href=\"https://profiles.wordpress.org/sourabhjain/\">Sourabh Jain</a> · <a href=\"https://profiles.wordpress.org/sourav08/\">Sourav Pahwa</a> · <a href=\"https://profiles.wordpress.org/staurand/\">staurand</a> · <a href=\"https://profiles.wordpress.org/ryokuhi/\">Stefano Minoia</a> · <a href=\"https://profiles.wordpress.org/stein2nd/\">stein2nd</a> · <a href=\"https://profiles.wordpress.org/sabernhardt/\">Stephen Bernhardt</a> · <a href=\"https://profiles.wordpress.org/stevenlinx/\">Steven Lin</a> · <a href=\"https://profiles.wordpress.org/thompsonsj/\">Steven Thompson</a> · <a href=\"https://profiles.wordpress.org/stoyangeorgiev/\">Stoyan Georgiev</a> · <a href=\"https://profiles.wordpress.org/styleshit/\">styleshit</a> · <a href=\"https://profiles.wordpress.org/sudipatel007/\">Sudip Dadhaniya</a> · <a href=\"https://profiles.wordpress.org/sumitbagthariya16/\">Sumit Bagthariya</a> · <a href=\"https://profiles.wordpress.org/sumitsingh/\">Sumit Singh</a> · <a href=\"https://profiles.wordpress.org/sunil25393/\">Sunil Prajapati</a> · <a href=\"https://profiles.wordpress.org/quadthemes/\">Sunny</a> · <a href=\"https://profiles.wordpress.org/superchlorine/\">superchlorine</a> · <a href=\"https://profiles.wordpress.org/cybr/\">Sybre Waaijer</a> · <a href=\"https://profiles.wordpress.org/jannathsyeda/\">Syeda Fahima Jannath</a> · <a href=\"https://profiles.wordpress.org/takahashi_fumiki/\">Takahashi Fumiki</a> · <a href=\"https://profiles.wordpress.org/iamtakashi/\">Takashi Irie</a> · <a href=\"https://profiles.wordpress.org/karmatosed/\">Tammie Lister</a> · <a href=\"https://profiles.wordpress.org/devtanbir/\">Tanbir Ahmod</a> · <a href=\"https://profiles.wordpress.org/tanvirul/\">Tanvirul Haque</a> · <a href=\"https://profiles.wordpress.org/voboghure/\">Tapan Kumer Das</a> · <a href=\"https://profiles.wordpress.org/taylorgorman/\">Taylor Gorman</a> · <a href=\"https://profiles.wordpress.org/tdrayson/\">tdrayson</a> · <a href=\"https://profiles.wordpress.org/iamjaydip/\">thejaydip</a> · <a href=\"https://profiles.wordpress.org/thelmachido/\">thelmachido a11n</a> · <a href=\"https://profiles.wordpress.org/themes-1/\">them.es</a> · <a href=\"https://profiles.wordpress.org/kraftner/\">Thomas Kräftner</a> · <a href=\"https://profiles.wordpress.org/thrijith/\">Thrijith Thankachan</a> · <a href=\"https://profiles.wordpress.org/sippis/\">Timi Wahalahti</a> · <a href=\"https://profiles.wordpress.org/timothyblynjacobs/\">Timothy Jacobs</a> · <a href=\"https://profiles.wordpress.org/tirth03/\">Tirth Doshi</a> · <a href=\"https://profiles.wordpress.org/tmanoilov/\">tmanoilov</a> · <a href=\"https://profiles.wordpress.org/toastercookie/\">toastercookie</a> · <a href=\"https://profiles.wordpress.org/tobiasbg/\">TobiasBg</a> · <a href=\"https://profiles.wordpress.org/tobifjellner/\">tobifjellner (Tor-Bjorn “Tobi” Fjellner)</a> · <a href=\"https://profiles.wordpress.org/tomjcafferkey/\">Tom Cafferkey</a> · <a href=\"https://profiles.wordpress.org/thomasdevisser/\">Tom de Visser</a> · <a href=\"https://profiles.wordpress.org/tjnowell/\">Tom J Nowell</a> · <a href=\"https://profiles.wordpress.org/tomhine/\">tomhine</a> · <a href=\"https://profiles.wordpress.org/tomllobet/\">tomllobet</a> · <a href=\"https://profiles.wordpress.org/hellofromtonya/\">Tonya Mork</a> · <a href=\"https://profiles.wordpress.org/toro_unit/\">Toro_Unit (Hiroshi Urabe)</a> · <a href=\"https://profiles.wordpress.org/zodiac1978/\">Torsten Landsiedel</a> · <a href=\"https://profiles.wordpress.org/tropicalista/\">tropicalista</a> · <a href=\"https://profiles.wordpress.org/areziaal/\">Troy Chaplin</a> · <a href=\"https://profiles.wordpress.org/truptikanzariya/\">Trupti Kanzariya</a> · <a href=\"https://profiles.wordpress.org/tunetheweb/\">tunetheweb</a> · <a href=\"https://profiles.wordpress.org/twstokes/\">twstokes</a> · <a href=\"https://profiles.wordpress.org/ugyensupport/\">Ugyen Dorji</a> · <a href=\"https://profiles.wordpress.org/umesh84/\">Umesh Gupta</a> · <a href=\"https://profiles.wordpress.org/umeshsinghin/\">Umesh Singh</a> · <a href=\"https://profiles.wordpress.org/up1512001/\">up1512001</a> · <a href=\"https://profiles.wordpress.org/ukdrahul/\">Uttam Kumar Dash</a> · <a href=\"https://profiles.wordpress.org/valer1e/\">valer1e</a> · <a href=\"https://profiles.wordpress.org/vertisoft/\">vertisoft</a> · <a href=\"https://profiles.wordpress.org/vcanales/\">Vicente Canales</a> · <a href=\"https://profiles.wordpress.org/vijaysinh9094/\">Vijaysinh Zala</a> · <a href=\"https://profiles.wordpress.org/szepeviktor/\">Viktor Szépe</a> · <a href=\"https://profiles.wordpress.org/vineet2003/\">Vinit</a> · <a href=\"https://profiles.wordpress.org/ghorivipul97/\">Vipul Ghori</a> · <a href=\"https://profiles.wordpress.org/vipulgupta003/\">Vipul Gupta</a> · <a href=\"https://profiles.wordpress.org/vipulpatil/\">vipulpatil</a> · <a href=\"https://profiles.wordpress.org/vrajadas/\">Vraja Das</a> · <a href=\"https://profiles.wordpress.org/vrishabhsk/\">vrishabhsk</a> · <a href=\"https://profiles.wordpress.org/wbdv/\">wbdv</a> · <a href=\"https://profiles.wordpress.org/webmandesign/\">WebMan Design | Oliver Juhas</a> · <a href=\"https://profiles.wordpress.org/webwurm/\">webwurm</a> · <a href=\"https://profiles.wordpress.org/wesrapyd/\">wesrapyd</a> · <a href=\"https://profiles.wordpress.org/westonruter/\">Weston Ruter</a> · <a href=\"https://profiles.wordpress.org/skorasaurus/\">Will Skora</a> · <a href=\"https://profiles.wordpress.org/williamalexander/\">William Alexander</a> · <a href=\"https://profiles.wordpress.org/williampatton/\">williampatton</a> · <a href=\"https://profiles.wordpress.org/wongjn/\">wongjn</a> · <a href=\"https://profiles.wordpress.org/wpeople/\">WPeople</a> · <a href=\"https://profiles.wordpress.org/wpsoul/\">wpsoul</a> · <a href=\"https://profiles.wordpress.org/wzieba/\">wzieba</a> · <a href=\"https://profiles.wordpress.org/xipasduarte/\">xipasduarte</a> · <a href=\"https://profiles.wordpress.org/yaniiliev/\">Yani</a> · <a href=\"https://profiles.wordpress.org/collet/\">Yann</a> · <a href=\"https://profiles.wordpress.org/yguyon/\">Yannis Guyon</a> · <a href=\"https://profiles.wordpress.org/yogeshbhutkar/\">Yogesh Bhutkar</a> · <a href=\"https://profiles.wordpress.org/ytfeldrawkcab/\">ytfeLdrawkcaB</a> · <a href=\"https://profiles.wordpress.org/fierevere/\">Yui</a> · <a href=\"https://profiles.wordpress.org/yukinobu/\">Yukinobu Asakawa</a> · <a href=\"https://profiles.wordpress.org/yuvrajsinh2211/\">Yuvrajsinh Sisodiya</a> · <a href=\"https://profiles.wordpress.org/zackkrida/\">Zack Krida</a> · <a href=\"https://profiles.wordpress.org/zeelthakkar/\">zeelthakkar</a> · <a href=\"https://profiles.wordpress.org/zitaruksergij/\">zitaruksergij</a> · <a href=\"https://profiles.wordpress.org/zunaid321/\">Zunaid Amin</a></p>\n\n\n\n<h2 class=\"wp-block-heading\">Merci aux personnes ayant contribué à traduire WordPress&nbsp;6.7 en français</h2>\n\n\n\n<p>WordPress est un projet international et la version 6.7 est déjà complètement disponible dans plus de 40 langues différentes.</p>\n\n\n\n<p>Nous souhaitons remercier ici les personnes ayant participé à la traduction de WordPress&nbsp;6.7 en français&nbsp;:</p>\n\n\n\n<p><a href=\"https://profiles.wordpress.org/jdy68\">Jenny Dupuy</a>, <a href=\"https://profiles.wordpress.org/audrasjb\">Jb Audras</a>, <a href=\"https://profiles.wordpress.org/fxbenard\">fxbenard</a>, <a href=\"https://profiles.wordpress.org/xibe\">Xavier Borderie</a>, <a href=\"https://profiles.wordpress.org/amebref\">amebref</a>, <a href=\"https://profiles.wordpress.org/beryldlg\">Béryl de La Grandière</a>, <a href=\"https://profiles.wordpress.org/chris-kns\">chris-kns</a>, <a href=\"https://profiles.wordpress.org/clementpolito\">Clément Polito</a>, <a href=\"https://profiles.wordpress.org/dfi42\">dfi42</a>, <a href=\"https://profiles.wordpress.org/eddystile\">Eddy</a>, <a href=\"https://profiles.wordpress.org/emlebrun\">Emilie LEBRUN</a>, <a href=\"https://profiles.wordpress.org/florientinneo\">Florient DELAFOY</a>, <a href=\"https://profiles.wordpress.org/karine-wendling\">karine wendling</a>, <a href=\"https://profiles.wordpress.org/laeti972\">Laetitia de Perthuis</a>, <a href=\"https://profiles.wordpress.org/wplmillet\">Laurent MILLET</a>, <a href=\"https://profiles.wordpress.org/marineevain\">Marine EVAIN</a>, <a href=\"https://profiles.wordpress.org/lymx\">Maxime LEROY</a>, <a href=\"https://profiles.wordpress.org/firestar300\">Milan Ricoul</a>, <a href=\"https://profiles.wordpress.org/momo-fr\">momo-fr</a>, <a href=\"https://profiles.wordpress.org/pasglop\">pasglop</a>, <a href=\"https://profiles.wordpress.org/phoenix13\">phoenix13</a>, <a href=\"https://profiles.wordpress.org/pierrelannoy\">Pierre Lannoy</a>, <a href=\"https://profiles.wordpress.org/sebastienserre\">Sébastien SERRE</a>, et <a href=\"https://profiles.wordpress.org/spaceshipone\">Timothée Brosille</a>.</p>\n\n\n\n<hr class=\"wp-block-separator has-alpha-channel-opacity\" />\n\n\n\n<p class=\"has-small-font-size\">Article traduit par <a href=\"https://profiles.wordpress.org/audrasjb/\">Jb Audras</a>. Merci à <a href=\"https://profiles.wordpress.org/laboiteare/\">Renaud Pacouil</a> pour sa relecture.</p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:30:\"com-wordpress:feed-additions:1\";a:1:{s:7:\"post-id\";a:1:{i:0;a:5:{s:4:\"data\";s:4:\"3255\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:5;a:6:{s:4:\"data\";s:60:\"\n		\n		\n		\n		\n		\n				\n		\n		\n\n					\n										\n					\n		\n		\n			\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:4:{s:0:\"\";a:6:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:50:\"Guide des changements techniques de WordPress 6.7\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:86:\"https://fr.wordpress.org/2024/10/28/guide-des-changements-techniques-de-wordpress-6-7/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Mon, 28 Oct 2024 10:49:15 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:2:{i:0;a:5:{s:4:\"data\";s:5:\"Guide\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:1;a:5:{s:4:\"data\";s:31:\"Nouvelles versions de WordPress\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:32:\"https://fr.wordpress.org/?p=3243\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:436:\"WordPress 6.7 comprend la résolution de plus de&#160;300 tickets sur Trac, dont&#160;87 améliorations et nouvelles fonctionnalités, plus de 200 corrections de bogues. cette version comprend&#160;23 tickets focalisés sur les performances,&#160;21 sur l’accessibilité et&#160;12 sur la modernisation du code et la conformité aux standards de code. Les modifications de 6.7 s’étalent sur&#160;38 composants du cœur du [&#8230;]\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:9:\"Jb Audras\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:28154:\"\n<figure class=\"wp-block-image alignfull size-large is-style-serif wp-elements-f590cfee42cfa860d05ec74ddea8b4ef\" style=\"background:linear-gradient(135deg,rgb(7,125,194) 0%,rgb(134,54,209) 100%)\"><a href=\"https://fr.wordpress.org/files/2024/10/wp-6-7-changements-techniques.png\"><img loading=\"lazy\" decoding=\"async\" width=\"1024\" height=\"515\" src=\"https://fr.wordpress.org/files/2024/10/wp-6-7-changements-techniques-1024x515.png\" alt=\"\" class=\"wp-image-3244\" srcset=\"https://fr.wordpress.org/files/2024/10/wp-6-7-changements-techniques-1024x515.png 1024w, https://fr.wordpress.org/files/2024/10/wp-6-7-changements-techniques-300x151.png 300w, https://fr.wordpress.org/files/2024/10/wp-6-7-changements-techniques-768x386.png 768w, https://fr.wordpress.org/files/2024/10/wp-6-7-changements-techniques-1536x772.png 1536w, https://fr.wordpress.org/files/2024/10/wp-6-7-changements-techniques-2048x1029.png 2048w\" sizes=\"auto, (max-width: 1024px) 100vw, 1024px\" /></a></figure>\n\n\n\n<p>WordPress 6.7 comprend la résolution de plus de&nbsp;<a href=\"https://core.trac.wordpress.org/query?status=closed&amp;milestone=6.7&amp;col=id&amp;col=summary&amp;col=status&amp;col=owner&amp;col=type&amp;col=priority&amp;col=milestone&amp;order=priority\">300 tickets sur Trac</a>, dont&nbsp;<a href=\"https://core.trac.wordpress.org/query?status=closed&amp;type=enhancement&amp;type=feature+request&amp;milestone=6.7&amp;col=id&amp;col=summary&amp;col=type&amp;col=status&amp;col=milestone&amp;col=owner&amp;col=priority&amp;order=priority\">87 améliorations et nouvelles fonctionnalités</a>, <a href=\"https://core.trac.wordpress.org/query?status=closed&amp;type=defect+(bug)&amp;milestone=6.7&amp;col=id&amp;col=summary&amp;col=type&amp;col=status&amp;col=milestone&amp;col=owner&amp;col=priority&amp;order=priority\">plus de 200 corrections de bogues</a>. cette version comprend&nbsp;<a href=\"https://core.trac.wordpress.org/query?status=closed&amp;focuses=~performance&amp;milestone=6.7&amp;col=id&amp;col=summary&amp;col=type&amp;col=status&amp;col=milestone&amp;col=owner&amp;col=priority&amp;order=priority\">23 tickets focalisés sur les performances</a>,&nbsp;<a href=\"https://core.trac.wordpress.org/query?status=closed&amp;focuses=~accessibility&amp;milestone=6.7&amp;col=id&amp;col=summary&amp;col=status&amp;col=milestone&amp;col=owner&amp;col=type&amp;col=priority&amp;order=priority\">21 sur l’accessibilité</a> et&nbsp;<a href=\"https://core.trac.wordpress.org/query?status=closed&amp;focuses=~coding-standards&amp;milestone=6.7&amp;col=id&amp;col=summary&amp;col=status&amp;col=milestone&amp;col=owner&amp;col=type&amp;col=priority&amp;order=priority\">12 sur la modernisation du code et la conformité aux standards de code</a>. Les modifications de 6.7 s’étalent sur&nbsp;<a href=\"https://core.trac.wordpress.org/query?status=closed&amp;milestone=6.7&amp;group=component&amp;max=9999&amp;col=id&amp;col=summary&amp;col=status&amp;col=milestone&amp;col=owner&amp;col=type&amp;col=priority&amp;order=priority\">38 composants du cœur du CMS</a>.</p>\n\n\n\n<p>Cette version comprend aussi <a href=\"https://github.com/WordPress/gutenberg/issues?q=label%3A%22%5BType%5D%20Enhancement%22%20AND%20state%3Aclosed%20AND%20milestone%3A%22Gutenberg%2018.6%22%20OR%20label%3A%22%5BType%5D%20Enhancement%22%20AND%20state%3Aclosed%20AND%20milestone%3A%22Gutenberg%2018.7%22%20OR%20label%3A%22%5BType%5D%20Enhancement%22%20AND%20state%3Aclosed%20AND%20milestone%3A%22Gutenberg%2018.8%22%20OR%20label%3A%22%5BType%5D%20Enhancement%22%20AND%20state%3Aclosed%20AND%20milestone%3A%22Gutenberg%2018.9%22%20OR%20label%3A%22%5BType%5D%20Enhancement%22%20AND%20state%3Aclosed%20AND%20milestone%3A%22Gutenberg%2019.0%22%20OR%20label%3A%22%5BType%5D%20Enhancement%22%20AND%20state%3Aclosed%20AND%20milestone%3A%22Gutenberg%2019.1%22%20OR%20label%3A%22%5BType%5D%20Enhancement%22%20AND%20state%3Aclosed%20AND%20milestone%3A%22Gutenberg%2019.2%22%20OR%20label%3A%22%5BType%5D%20Enhancement%22%20AND%20state%3Aclosed%20AND%20milestone%3A%22Gutenberg%2019.3%22%20\">445 améliorations</a>,&nbsp;<a href=\"https://github.com/WordPress/gutenberg/issues?q=label%3A%22%5BType%5D%20Bug%22%20AND%20state%3Aclosed%20AND%20milestone%3A%22Gutenberg%2018.6%22%20OR%20label%3A%22%5BType%5D%20Bug%22%20AND%20state%3Aclosed%20AND%20milestone%3A%22Gutenberg%2018.7%22%20OR%20label%3A%22%5BType%5D%20Bug%22%20AND%20state%3Aclosed%20AND%20milestone%3A%22Gutenberg%2018.8%22%20OR%20label%3A%22%5BType%5D%20Bug%22%20AND%20state%3Aclosed%20AND%20milestone%3A%22Gutenberg%2018.9%22%20OR%20label%3A%22%5BType%5D%20Bug%22%20AND%20state%3Aclosed%20AND%20milestone%3A%22Gutenberg%2019.0%22%20OR%20label%3A%22%5BType%5D%20Bug%22%20AND%20state%3Aclosed%20AND%20milestone%3A%22Gutenberg%2019.1%22%20OR%20label%3A%22%5BType%5D%20Bug%22%20AND%20state%3Aclosed%20AND%20milestone%3A%22Gutenberg%2019.2%22%20OR%20label%3A%22%5BType%5D%20Bug%22%20AND%20state%3Aclosed%20AND%20milestone%3A%22Gutenberg%2019.3%22%20\">464 corrections de bogues</a> et&nbsp;<a href=\"https://github.com/WordPress/gutenberg/issues?q=label%3A%22%5BFocus%5D%20Accessibility%20(a11y)%22%20AND%20state%3Aclosed%20AND%20milestone%3A%22Gutenberg%2018.6%22%20OR%20label%3A%22%5BFocus%5D%20Accessibility%20(a11y)%22%20AND%20state%3Aclosed%20AND%20milestone%3A%22Gutenberg%2018.7%22%20OR%20label%3A%22%5BFocus%5D%20Accessibility%20(a11y)%22%20AND%20state%3Aclosed%20AND%20milestone%3A%22Gutenberg%2018.8%22%20OR%20label%3A%22%5BFocus%5D%20Accessibility%20(a11y)%22%20AND%20state%3Aclosed%20AND%20milestone%3A%22Gutenberg%2018.9%22%20OR%20label%3A%22%5BFocus%5D%20Accessibility%20(a11y)%22%20AND%20state%3Aclosed%20AND%20milestone%3A%22Gutenberg%2019.0%22%20OR%20label%3A%22%5BFocus%5D%20Accessibility%20(a11y)%22%20AND%20state%3Aclosed%20AND%20milestone%3A%22Gutenberg%2019.1%22%20OR%20label%3A%22%5BFocus%5D%20Accessibility%20(a11y)%22%20AND%20state%3Aclosed%20AND%20milestone%3A%22Gutenberg%2019.2%22%20OR%20label%3A%22%5BFocus%5D%20Accessibility%20(a11y)%22%20AND%20state%3Aclosed%20AND%20milestone%3A%22Gutenberg%2019.3%22%20\">55 améliorations d’accessibilité</a>&nbsp;sur l’éditeur (projet Gutenberg).</p>\n\n\n\n<p class=\"is-style-serif has-white-color has-text-color has-background has-link-color wp-elements-ca39a6cbb68f24eb2fca5cc30331b23f\" style=\"background:linear-gradient(135deg,rgb(7,125,194) 0%,rgb(134,54,209) 100%)\">Ce guide décrit les principaux changements techniques que vous trouverez sur WordPress&nbsp;6.7, dont la sortie est prévue le 12 novembre 2024.</p>\n\n\n\n<p>Tous les liens de cet article pointent vers des notes de développement rédigées en anglais. L’objectif est de fournir un panorama général des changements techniques apportés par cette version, en français, puis de diriger les personnes qui souhaitent en savoir plus vers les notes de développement en anglais.</p>\n\n\n\n<p><a href=\"https://make.wordpress.org/core/6-7/\">Pour en savoir plus sur la feuille de route et le calendrier de sortie de WP&nbsp;6.7, consultez cette page.</a></p>\n\n\n\n<hr class=\"wp-block-separator has-alpha-channel-opacity\" />\n\n\n\n<h2 class=\"wp-block-heading\" id=\"Block-Editor\">Changements concernant l’éditeur et le projet Gutenberg</h2>\n\n\n\n<p>WordPress 6.7 implémente 8 versions de Gutenberg &#8211; <a href=\"https://make.wordpress.org/core/2024/06/20/whats-new-in-gutenberg-18-6/\">18.6</a>,&nbsp;<a href=\"https://make.wordpress.org/core/2024/07/04/whats-new-in-gutenberg-18-7-03-july/\">18.7</a>,&nbsp;<a href=\"https://make.wordpress.org/core/2024/07/17/whats-new-in-gutenberg-18-8-17-july/\">18.8</a>,&nbsp;<a href=\"https://make.wordpress.org/core/2024/07/31/whats-new-in-gutenberg-18-9-31-july/#:~:text=In%20a%20recurring%20effort%20to,Links%2C%20and%20Term%20Description%20blocks.\">18.9</a>,&nbsp;<a href=\"https://make.wordpress.org/core/2024/08/14/whats-new-in-gutenberg-19-0-14-august/\">19.0</a>,&nbsp;<a href=\"https://make.wordpress.org/core/2024/08/28/whats-new-in-gutenberg-19-1-28-august/\">19.1</a>,&nbsp;<a href=\"https://make.wordpress.org/core/2024/09/12/what-is-new-in-gutenberg-19-2-11-september/\">19.2</a> et&nbsp;<a href=\"https://make.wordpress.org/core/2024/09/25/whats-new-in-gutenberg-19-3-25-september/\">19.3</a>.</p>\n\n\n\n<h3 class=\"wp-block-heading\">Changements techniques</h3>\n\n\n\n<figure class=\"wp-block-embed is-type-wp-embed is-provider-make-wordpress-core wp-block-embed-make-wordpress-core\"><div class=\"wp-block-embed__wrapper\">\n<blockquote class=\"wp-embedded-content\" data-secret=\"UyWJ3kHEmz\"><a href=\"https://make.wordpress.org/core/2024/10/18/post-editor-iframing-with-meta-boxes-in-wordpress-6-7/\">Post Editor iframing with meta boxes in WordPress 6.7</a></blockquote><iframe loading=\"lazy\" class=\"wp-embedded-content\" sandbox=\"allow-scripts\" security=\"restricted\"  title=\"&#8220;Post Editor iframing with meta boxes in WordPress 6.7&#8221; &#8212; Make WordPress Core\" src=\"https://make.wordpress.org/core/2024/10/18/post-editor-iframing-with-meta-boxes-in-wordpress-6-7/embed/#?secret=tSMGBJfYjQ#?secret=UyWJ3kHEmz\" data-secret=\"UyWJ3kHEmz\" width=\"500\" height=\"282\" frameborder=\"0\" marginwidth=\"0\" marginheight=\"0\" scrolling=\"no\"></iframe>\n</div></figure>\n\n\n\n<figure class=\"wp-block-embed is-type-wp-embed is-provider-make-wordpress-core wp-block-embed-make-wordpress-core\"><div class=\"wp-block-embed__wrapper\">\n<blockquote class=\"wp-embedded-content\" data-secret=\"jF8mPpPXlS\"><a href=\"https://make.wordpress.org/core/2024/10/21/block-bindings-improvements-to-the-editor-experience-in-6-7/\">Block Bindings: Improvements to the Editor Experience in 6.7</a></blockquote><iframe loading=\"lazy\" class=\"wp-embedded-content\" sandbox=\"allow-scripts\" security=\"restricted\"  title=\"&#8220;Block Bindings: Improvements to the Editor Experience in 6.7&#8221; &#8212; Make WordPress Core\" src=\"https://make.wordpress.org/core/2024/10/21/block-bindings-improvements-to-the-editor-experience-in-6-7/embed/#?secret=LyXnzsvvCL#?secret=jF8mPpPXlS\" data-secret=\"jF8mPpPXlS\" width=\"500\" height=\"282\" frameborder=\"0\" marginwidth=\"0\" marginheight=\"0\" scrolling=\"no\"></iframe>\n</div></figure>\n\n\n\n<figure class=\"wp-block-embed is-type-wp-embed is-provider-make-wordpress-core wp-block-embed-make-wordpress-core\"><div class=\"wp-block-embed__wrapper\">\n<blockquote class=\"wp-embedded-content\" data-secret=\"G8lRmWqAor\"><a href=\"https://make.wordpress.org/core/2024/10/21/updates-to-block-hooks-in-wordpress-6-7/\">Updates to Block Hooks in WordPress 6.7</a></blockquote><iframe loading=\"lazy\" class=\"wp-embedded-content\" sandbox=\"allow-scripts\" security=\"restricted\"  title=\"&#8220;Updates to Block Hooks in WordPress 6.7&#8221; &#8212; Make WordPress Core\" src=\"https://make.wordpress.org/core/2024/10/21/updates-to-block-hooks-in-wordpress-6-7/embed/#?secret=J4XDYs3pSJ#?secret=G8lRmWqAor\" data-secret=\"G8lRmWqAor\" width=\"500\" height=\"282\" frameborder=\"0\" marginwidth=\"0\" marginheight=\"0\" scrolling=\"no\"></iframe>\n</div></figure>\n\n\n\n<figure class=\"wp-block-embed is-type-wp-embed is-provider-make-wordpress-core wp-block-embed-make-wordpress-core\"><div class=\"wp-block-embed__wrapper\">\n<blockquote class=\"wp-embedded-content\" data-secret=\"h00792iEep\"><a href=\"https://make.wordpress.org/core/2024/10/18/editor-components-updates-in-wordpress-6-7/\">Updates to user-interface components in WordPress 6.7</a></blockquote><iframe loading=\"lazy\" class=\"wp-embedded-content\" sandbox=\"allow-scripts\" security=\"restricted\"  title=\"&#8220;Updates to user-interface components in WordPress 6.7&#8221; &#8212; Make WordPress Core\" src=\"https://make.wordpress.org/core/2024/10/18/editor-components-updates-in-wordpress-6-7/embed/#?secret=TCajqUjanO#?secret=h00792iEep\" data-secret=\"h00792iEep\" width=\"500\" height=\"282\" frameborder=\"0\" marginwidth=\"0\" marginheight=\"0\" scrolling=\"no\"></iframe>\n</div></figure>\n\n\n\n<h3 class=\"wp-block-heading\" id=\"react\">Changements concernant les outils de design dans l’éditeur</h3>\n\n\n\n<p>Nous avons poursuivi l’effort de consolidation des outils de design et plusieurs blocs prennent désormais en charge davantage de fonctionnalités de mise en page et de mise en forme.</p>\n\n\n\n<figure class=\"wp-block-embed is-type-wp-embed is-provider-make-wordpress-core wp-block-embed-make-wordpress-core\"><div class=\"wp-block-embed__wrapper\">\n<blockquote class=\"wp-embedded-content\" data-secret=\"obfs4hTFIv\"><a href=\"https://make.wordpress.org/core/2024/10/17/roster-of-design-tools-per-block-wordpress-6-6-edition-2/\">Roster of design tools per block (WordPress 6.7 edition)</a></blockquote><iframe loading=\"lazy\" class=\"wp-embedded-content\" sandbox=\"allow-scripts\" security=\"restricted\"  title=\"&#8220;Roster of design tools per block (WordPress 6.7 edition)&#8221; &#8212; Make WordPress Core\" src=\"https://make.wordpress.org/core/2024/10/17/roster-of-design-tools-per-block-wordpress-6-6-edition-2/embed/#?secret=3D3EUMW9w6#?secret=obfs4hTFIv\" data-secret=\"obfs4hTFIv\" width=\"500\" height=\"282\" frameborder=\"0\" marginwidth=\"0\" marginheight=\"0\" scrolling=\"no\"></iframe>\n</div></figure>\n\n\n\n<p></p>\n\n\n\n<h3 class=\"wp-block-heading\" id=\"miscellaneous-block-editor-changes\">Autres modifications concernant l’éditeur</h3>\n\n\n\n<p>D&rsquo;autres modifications diverses ont été listées dans des notes de développement dédiées&nbsp;:</p>\n\n\n\n<figure class=\"wp-block-embed is-type-wp-embed is-provider-make-wordpress-core wp-block-embed-make-wordpress-core\"><div class=\"wp-block-embed__wrapper\">\n<blockquote class=\"wp-embedded-content\" data-secret=\"Mh1YE1VTiU\"><a href=\"https://make.wordpress.org/core/2024/10/18/extending-the-preview-dropdown-menu-in-wordpress-6-7/\">Extending the Preview Dropdown Menu in WordPress 6.7</a></blockquote><iframe loading=\"lazy\" class=\"wp-embedded-content\" sandbox=\"allow-scripts\" security=\"restricted\"  title=\"&#8220;Extending the Preview Dropdown Menu in WordPress 6.7&#8221; &#8212; Make WordPress Core\" src=\"https://make.wordpress.org/core/2024/10/18/extending-the-preview-dropdown-menu-in-wordpress-6-7/embed/#?secret=ViTZEpwoUq#?secret=Mh1YE1VTiU\" data-secret=\"Mh1YE1VTiU\" width=\"500\" height=\"282\" frameborder=\"0\" marginwidth=\"0\" marginheight=\"0\" scrolling=\"no\"></iframe>\n</div></figure>\n\n\n\n<figure class=\"wp-block-embed is-type-wp-embed is-provider-make-wordpress-core wp-block-embed-make-wordpress-core\"><div class=\"wp-block-embed__wrapper\">\n<blockquote class=\"wp-embedded-content\" data-secret=\"5T9ubgS9pA\"><a href=\"https://make.wordpress.org/core/2024/10/20/miscellaneous-block-editor-changes-in-wordpress-6-7/\">Miscellaneous Block Editor Changes in WordPress 6.7</a></blockquote><iframe loading=\"lazy\" class=\"wp-embedded-content\" sandbox=\"allow-scripts\" security=\"restricted\"  title=\"&#8220;Miscellaneous Block Editor Changes in WordPress 6.7&#8221; &#8212; Make WordPress Core\" src=\"https://make.wordpress.org/core/2024/10/20/miscellaneous-block-editor-changes-in-wordpress-6-7/embed/#?secret=45jLTa4za3#?secret=5T9ubgS9pA\" data-secret=\"5T9ubgS9pA\" width=\"500\" height=\"282\" frameborder=\"0\" marginwidth=\"0\" marginheight=\"0\" scrolling=\"no\"></iframe>\n</div></figure>\n\n\n\n<h2 class=\"wp-block-heading\">API de gestion des interactions et modules de script</h2>\n\n\n\n<p>WordPress 6.7 comprend des mises à jour de l’API <code>Interactivity</code>, comme par exemple une nouvelle façon d’interagir avec les changements d’état côté serveur dans la navigation côté client. Les mises à jour des modules <code>Script</code>s comprennent des améliorations du chargement des scripts existants en tant que dépendances.</p>\n\n\n\n<figure class=\"wp-block-embed is-type-wp-embed is-provider-make-wordpress-core wp-block-embed-make-wordpress-core\"><div class=\"wp-block-embed__wrapper\">\n<blockquote class=\"wp-embedded-content\" data-secret=\"N7suow7aP5\"><a href=\"https://make.wordpress.org/core/2024/10/15/subscribe-to-changes-in-the-interactivity-api-state-and-context-on-client-side-navigation-in-6-7/\">Subscribe to changes in the Interactivity API state and context on client-side navigation in 6.7</a></blockquote><iframe loading=\"lazy\" class=\"wp-embedded-content\" sandbox=\"allow-scripts\" security=\"restricted\"  title=\"&#8220;Subscribe to changes in the Interactivity API state and context on client-side navigation in 6.7&#8221; &#8212; Make WordPress Core\" src=\"https://make.wordpress.org/core/2024/10/15/subscribe-to-changes-in-the-interactivity-api-state-and-context-on-client-side-navigation-in-6-7/embed/#?secret=XXyFFljgkB#?secret=N7suow7aP5\" data-secret=\"N7suow7aP5\" width=\"500\" height=\"282\" frameborder=\"0\" marginwidth=\"0\" marginheight=\"0\" scrolling=\"no\"></iframe>\n</div></figure>\n\n\n\n<figure class=\"wp-block-embed is-type-wp-embed is-provider-make-wordpress-core wp-block-embed-make-wordpress-core\"><div class=\"wp-block-embed__wrapper\">\n<blockquote class=\"wp-embedded-content\" data-secret=\"64ynOvr7Ew\"><a href=\"https://make.wordpress.org/core/2024/10/14/updates-to-script-modules-in-6-7/\">Updates to Script Modules in 6.7</a></blockquote><iframe loading=\"lazy\" class=\"wp-embedded-content\" sandbox=\"allow-scripts\" security=\"restricted\"  title=\"&#8220;Updates to Script Modules in 6.7&#8221; &#8212; Make WordPress Core\" src=\"https://make.wordpress.org/core/2024/10/14/updates-to-script-modules-in-6-7/embed/#?secret=6Cxd5rFVoy#?secret=64ynOvr7Ew\" data-secret=\"64ynOvr7Ew\" width=\"500\" height=\"282\" frameborder=\"0\" marginwidth=\"0\" marginheight=\"0\" scrolling=\"no\"></iframe>\n</div></figure>\n\n\n\n<h2 class=\"wp-block-heading\" id=\"html-api\">API HTML</h2>\n\n\n\n<p>WordPress 6.7 comprend plusieurs mises à jour de l&rsquo;API <code>HTML</code>. Plusieurs fonctionnalités majeures sont sorties ainsi qu&rsquo;un amélioration conséquente de l&rsquo;utilisabilité du processeur HTML.</p>\n\n\n\n<figure class=\"wp-block-embed is-type-wp-embed is-provider-make-wordpress-core wp-block-embed-make-wordpress-core\"><div class=\"wp-block-embed__wrapper\">\n<blockquote class=\"wp-embedded-content\" data-secret=\"kbJtxPGfqW\"><a href=\"https://make.wordpress.org/core/2024/10/17/updates-to-the-html-api-in-6-7/\">Updates to the HTML API in 6.7</a></blockquote><iframe loading=\"lazy\" class=\"wp-embedded-content\" sandbox=\"allow-scripts\" security=\"restricted\"  title=\"&#8220;Updates to the HTML API in 6.7&#8221; &#8212; Make WordPress Core\" src=\"https://make.wordpress.org/core/2024/10/17/updates-to-the-html-api-in-6-7/embed/#?secret=34UZ0w1coA#?secret=kbJtxPGfqW\" data-secret=\"kbJtxPGfqW\" width=\"500\" height=\"282\" frameborder=\"0\" marginwidth=\"0\" marginheight=\"0\" scrolling=\"no\"></iframe>\n</div></figure>\n\n\n\n<h2 class=\"wp-block-heading\" id=\"i18n\">Internationalisation</h2>\n\n\n\n<p><a href=\"https://core.trac.wordpress.org/query?component=I18N&amp;milestone=6.7&amp;col=id&amp;col=summary&amp;col=milestone&amp;col=owner&amp;col=type&amp;col=status&amp;col=priority&amp;order=priority\">Diverses améliorations de l&rsquo;internationalisation</a> sont disponibles avec WordPress 6.7&nbsp;:</p>\n\n\n\n<figure class=\"wp-block-embed is-type-wp-embed is-provider-make-wordpress-core wp-block-embed-make-wordpress-core\"><div class=\"wp-block-embed__wrapper\">\n<blockquote class=\"wp-embedded-content\" data-secret=\"hQXSqWJGem\"><a href=\"https://make.wordpress.org/core/2024/10/21/i18n-improvements-6-7/\">Internationalization improvements in 6.7</a></blockquote><iframe loading=\"lazy\" class=\"wp-embedded-content\" sandbox=\"allow-scripts\" security=\"restricted\"  title=\"&#8220;Internationalization improvements in 6.7&#8221; &#8212; Make WordPress Core\" src=\"https://make.wordpress.org/core/2024/10/21/i18n-improvements-6-7/embed/#?secret=eFPqVd4tTO#?secret=hQXSqWJGem\" data-secret=\"hQXSqWJGem\" width=\"500\" height=\"282\" frameborder=\"0\" marginwidth=\"0\" marginheight=\"0\" scrolling=\"no\"></iframe>\n</div></figure>\n\n\n\n<h2 class=\"wp-block-heading\" id=\"performance\">Performances</h2>\n\n\n\n<p>WordPress 6.7 apporte aussi plusieurs améliorations focalisées sur les performances, telles qu&rsquo;une nouvelle façon de déclarer les blocs utilisant des fichiers PHP générés pour contrecarrer les goulots d&rsquo;étranglement liés au chargement et au parcours des fichiers JSON.</p>\n\n\n\n<figure class=\"wp-block-embed is-type-wp-embed is-provider-make-wordpress-core wp-block-embed-make-wordpress-core\"><div class=\"wp-block-embed__wrapper\">\n<blockquote class=\"wp-embedded-content\" data-secret=\"8oQC5S3C02\"><a href=\"https://make.wordpress.org/core/2024/10/17/new-block-type-registration-apis-to-improve-performance-in-wordpress-6-7/\">New block type registration APIs to improve performance in WordPress 6.7</a></blockquote><iframe loading=\"lazy\" class=\"wp-embedded-content\" sandbox=\"allow-scripts\" security=\"restricted\"  title=\"&#8220;New block type registration APIs to improve performance in WordPress 6.7&#8221; &#8212; Make WordPress Core\" src=\"https://make.wordpress.org/core/2024/10/17/new-block-type-registration-apis-to-improve-performance-in-wordpress-6-7/embed/#?secret=XzjPRUchA9#?secret=8oQC5S3C02\" data-secret=\"8oQC5S3C02\" width=\"500\" height=\"282\" frameborder=\"0\" marginwidth=\"0\" marginheight=\"0\" scrolling=\"no\"></iframe>\n</div></figure>\n\n\n\n<figure class=\"wp-block-embed is-type-wp-embed is-provider-make-wordpress-core wp-block-embed-make-wordpress-core\"><div class=\"wp-block-embed__wrapper\">\n<blockquote class=\"wp-embedded-content\" data-secret=\"7r05WrUm18\"><a href=\"https://make.wordpress.org/core/2024/10/18/auto-sizes-for-lazy-loaded-images-in-wordpress-6-7/\">Auto Sizes for Lazy Loaded Images in WordPress 6.7</a></blockquote><iframe loading=\"lazy\" class=\"wp-embedded-content\" sandbox=\"allow-scripts\" security=\"restricted\"  title=\"&#8220;Auto Sizes for Lazy Loaded Images in WordPress 6.7&#8221; &#8212; Make WordPress Core\" src=\"https://make.wordpress.org/core/2024/10/18/auto-sizes-for-lazy-loaded-images-in-wordpress-6-7/embed/#?secret=wpQMBPVn0N#?secret=7r05WrUm18\" data-secret=\"7r05WrUm18\" width=\"500\" height=\"282\" frameborder=\"0\" marginwidth=\"0\" marginheight=\"0\" scrolling=\"no\"></iframe>\n</div></figure>\n\n\n\n<h2 class=\"wp-block-heading\" id=\"miscellaneous-developer-changes\">Autres changements techniques</h2>\n\n\n\n<figure class=\"wp-block-embed is-type-wp-embed is-provider-make-wordpress-core wp-block-embed-make-wordpress-core\"><div class=\"wp-block-embed__wrapper\">\n<blockquote class=\"wp-embedded-content\" data-secret=\"fmwVz6LB0l\"><a href=\"https://make.wordpress.org/core/2024/10/20/new-plugin-template-registration-api-in-wordpress-6-7/\">New Plugin Template Registration API in WordPress 6.7</a></blockquote><iframe loading=\"lazy\" class=\"wp-embedded-content\" sandbox=\"allow-scripts\" security=\"restricted\"  title=\"&#8220;New Plugin Template Registration API in WordPress 6.7&#8221; &#8212; Make WordPress Core\" src=\"https://make.wordpress.org/core/2024/10/20/new-plugin-template-registration-api-in-wordpress-6-7/embed/#?secret=rHnFsEBoL1#?secret=fmwVz6LB0l\" data-secret=\"fmwVz6LB0l\" width=\"500\" height=\"282\" frameborder=\"0\" marginwidth=\"0\" marginheight=\"0\" scrolling=\"no\"></iframe>\n</div></figure>\n\n\n\n<figure class=\"wp-block-embed is-type-wp-embed is-provider-make-wordpress-core wp-block-embed-make-wordpress-core\"><div class=\"wp-block-embed__wrapper\">\n<blockquote class=\"wp-embedded-content\" data-secret=\"zeZlu13TM1\"><a href=\"https://make.wordpress.org/core/2024/08/15/automatic-conversion-of-heic-images-to-jpeg-in-wordpress-6-7/\">Automatic conversion of HEIC images to JPEG in WordPress 6.7</a></blockquote><iframe loading=\"lazy\" class=\"wp-embedded-content\" sandbox=\"allow-scripts\" security=\"restricted\"  title=\"&#8220;Automatic conversion of HEIC images to JPEG in WordPress 6.7&#8221; &#8212; Make WordPress Core\" src=\"https://make.wordpress.org/core/2024/08/15/automatic-conversion-of-heic-images-to-jpeg-in-wordpress-6-7/embed/#?secret=9ECwfO9e5P#?secret=zeZlu13TM1\" data-secret=\"zeZlu13TM1\" width=\"500\" height=\"282\" frameborder=\"0\" marginwidth=\"0\" marginheight=\"0\" scrolling=\"no\"></iframe>\n</div></figure>\n\n\n\n<h2 class=\"wp-block-heading\" id=\"other-updates\">Nouvelles fonctions, crochets, filtres, classes et méthodes</h2>\n\n\n\n<p>Pour obtenir la liste de toutes les nouvelles fonctions, crochets, filtres, classes et méthodes, vous pourrez vous rendre – une fois que WP 6.7 sera sortie – sur cette page&nbsp;: <a href=\"https://developer.wordpress.org/reference/since/6.7.0/\">https://developer.wordpress.org/reference/since/6.7.0/</a>.</p>\n\n\n\n<div class=\"wp-block-group alignfull is-layout-flow wp-block-group-is-layout-flow\">\n<p class=\"is-style-serif has-white-color has-text-color has-background has-link-color wp-elements-87f312e26bd4a386f9cdeec66ae58d52\" style=\"background:linear-gradient(135deg,rgb(7,125,194) 0%,rgb(134,54,209) 100%)\">Que vous développiez des thèmes ou des extensions, pensez à tester et retester votre code pour vous assurer de sa compatibilité avec ces changements.<br><br>Vous pouvez utiliser <a href=\"https://fr.wordpress.org/plugins/wordpress-beta-tester/\" target=\"_blank\" rel=\"noreferrer noopener\">l’extension « <em><bdo lang=\"en\" dir=\"ltr\">Beta Tester</bdo></em> »</a> sur un site de test pour vérifier la compatibilité de vos développements avec la <a href=\"https://wordpress.org/news/2024/10/wordpress-6-7-release-candidate-1/\">version <em><bdo lang=\"en\" dir=\"ltr\">release candidate</bdo></em> de WordPress 6.7</a>. <br>Vous pouvez aussi tester cette nouvelle version directement dans votre navigateur en utilisant <em><a href=\"https://playground.wordpress.net/#%7B%20%22preferredVersions%22:%20%7B%20%22php%22:%20%228.0%22,%20%22wp%22:%20%22beta%22%20%7D,%20%22features%22:%20%7B%20%22networking%22:%20true%20%7D,%20%22steps%22:%20[%20%7B%20%22step%22:%20%22login%22,%20%22username%22:%20%22admin%22,%20%22password%22:%20%22password%22%20%7D,%20%7B%20%22step%22:%20%22importFile%22,%20%22file%22:%20%7B%20%22resource%22:%20%22url%22,%20%22url%22:%20%22https://raw.githubusercontent.com/wpaccessibility/a11y-theme-unit-test/master/a11y-theme-unit-test-data.xml%22%20%7D%20%7D,%20%7B%20%22step%22:%20%22importFile%22,%20%22file%22:%20%7B%20%22resource%22:%20%22url%22,%20%22url%22:%20%22https://raw.githubusercontent.com/WordPress/theme-test-data/master/themeunittestdata.wordpress.xml%22%20%7D%20%7D,%20%7B%20%22step%22:%20%22installPlugin%22,%20%22pluginZipFile%22:%20%7B%20%22resource%22:%20%22wordpress.org/plugins%22,%20%22slug%22:%20%22query-monitor%22%20%7D,%20%22options%22:%20%7B%20%22activate%22:%20false%20%7D,%20%22progress%22:%20%7B%20%22weight%22:%202%20%7D%20%7D,%20%7B%20%22step%22:%20%22installPlugin%22,%20%22pluginZipFile%22:%20%7B%20%22resource%22:%20%22wordpress.org/plugins%22,%20%22slug%22:%20%22create-block-theme%22%20%7D,%20%22progress%22:%20%7B%20%22weight%22:%202%20%7D%20%7D,%20%7B%20%22step%22:%20%22installPlugin%22,%20%22pluginZipFile%22:%20%7B%20%22resource%22:%20%22wordpress.org/plugins%22,%20%22slug%22:%20%22debug-bar%22%20%7D,%20%22progress%22:%20%7B%20%22weight%22:%202%20%7D%20%7D,%20%7B%20%22step%22:%20%22installPlugin%22,%20%22pluginZipFile%22:%20%7B%20%22resource%22:%20%22wordpress.org/plugins%22,%20%22slug%22:%20%22health-check%22%20%7D,%20%22progress%22:%20%7B%20%22weight%22:%202%20%7D%20%7D,%20%7B%20%22step%22:%20%22installPlugin%22,%20%22pluginZipFile%22:%20%7B%20%22resource%22:%20%22wordpress.org/plugins%22,%20%22slug%22:%20%22test-reports%22%20%7D,%20%22progress%22:%20%7B%20%22weight%22:%202%20%7D%20%7D,%20%7B%20%22step%22:%20%22installPlugin%22,%20%22pluginZipFile%22:%20%7B%20%22resource%22:%20%22wordpress.org/plugins%22,%20%22slug%22:%20%22user-switching%22%20%7D,%20%22progress%22:%20%7B%20%22weight%22:%202%20%7D%20%7D%20]%20%7D\"><bdo lang=\"en\" dir=\"ltr\">WordPress Playground</bdo></a></em>.<br><br>Nous comptons sur vous pour vérifier que votre code fonctionne correctement avec le cœur du CMS, pour le bien des millions d’utilisateurs et utilisatrices de WordPress <img src=\"https://s.w.org/images/core/emoji/16.0.1/72x72/2665.png\" alt=\"♥\" class=\"wp-smiley\" style=\"height: 1em; max-height: 1em;\" /></p>\n</div>\n\n\n\n<p class=\"has-small-font-size\">Ce guide a été traduit et réadapté à partir du <a href=\"https://make.wordpress.org/core/2024/10/23/wordpress-6-7-field-guide/\">Field Guide de WP 6.7 (en anglais)</a> par <a href=\"https://profiles.wordpress.org/audrasjb/\">Jb Audras</a>.<br>Merci à <a href=\"https://profiles.wordpress.org/fxbenard/\">FX Benard</a> et <a href=\"https://profiles.wordpress.org/beryldlg/\">Béryl de La Grandière</a> pour leur relecture.</p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:30:\"com-wordpress:feed-additions:1\";a:1:{s:7:\"post-id\";a:1:{i:0;a:5:{s:4:\"data\";s:4:\"3243\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:6;a:6:{s:4:\"data\";s:66:\"\n		\n		\n		\n		\n		\n				\n		\n		\n		\n		\n\n					\n										\n					\n		\n		\n			\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:4:{s:0:\"\";a:6:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:63:\"Nouveau programme de mentorat pour la contribution à WordPress\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:99:\"https://fr.wordpress.org/2024/08/21/nouveau-programme-de-mentorat-pour-la-contribution-a-wordpress/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Wed, 21 Aug 2024 09:34:36 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:4:{i:0;a:5:{s:4:\"data\";s:10:\"Contribuer\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:1;a:5:{s:4:\"data\";s:13:\"Documentation\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:2;a:5:{s:4:\"data\";s:10:\"Traduction\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:3;a:5:{s:4:\"data\";s:18:\"mentorship program\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:32:\"https://fr.wordpress.org/?p=3204\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:389:\"Le 7 octobre 2024, un nouveau programme de mentorat pour la contribution à WordPress ou « WordPress Contributor Mentorship » va débuter pour une durée de 6 semaines, il s’achèvera donc avec la sortie de la version 6.7 mi-novembre. Mais c’est quoi exactement ce programme&#160;? Il s’agit du troisième programme organisé par l’équipe Community afin de faciliter [&#8230;]\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:11:\"Jenny Dupuy\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:6506:\"\n<p>Le 7 octobre 2024, un nouveau programme de mentorat pour la contribution à WordPress ou « WordPress Contributor Mentorship » va débuter pour une durée de 6 semaines, il s’achèvera donc avec la sortie de la version 6.7 mi-novembre.</p>\n\n\n\n<h2 class=\"wp-block-heading\">Mais c’est quoi exactement ce programme&nbsp;?</h2>\n\n\n\n<p>Il s’agit du troisième programme organisé par l’équipe <a href=\"https://make.wordpress.org/community/\">Community</a> afin de faciliter l’intégration de nouvelles personnes aux <a href=\"https://make.wordpress.org/\">diverses équipe de contribution</a>.</p>\n\n\n\n<p>Ce programme met en place de petites équipes avec un mentor et des mentoré·e·s qui travaillent ensemble sur un projet proposé par le mentor lors de sa candidature.</p>\n\n\n\n<p>Les organisateurs répartissent donc les contributeurs/contributrices selon les souhaits qu&rsquo;ils/elles ont définis lors de leur candidature.</p>\n\n\n\n<p>Tout au long du programme, le/la mentor prend en charge l&rsquo;équipe de mentoré·e·s pour avancer le projet qu&rsquo;il/elle a proposé, et quelques réunions en visio sont proposées par les organisateurs.</p>\n\n\n\n<p>Si vous souhaitez débuter la contribution à WordPress mais ne savez pas comment, ni par où commencer, alors ce programme est parfait pour vous en tant que mentoré·e.&nbsp; Vous serez guidé·e tout au long du programme par des mentors et pourrez ainsi obtenir toutes les informations nécessaires à une contribution efficace.<br>Et si vous contribuez déjà et souhaitez transmettre vos connaissances à d’autres personnes alors participez au programme en tant que mentor ! Ce sera l’occasion d’accueillir de nouvelles personnes dans vos équipes respectives.</p>\n\n\n\n<p>Cette cohorte est synchronisée avec la sortie de la version 6.7 afin de permettre aux participants, qui rejoignent l’équipe Core ou celle du développement du thème Twenty Twenty-Five, de contribuer spécifiquement à cette version de WordPress. Mais, la contribution à WordPress ne se résumant pas à son code, vous avez aussi l’opportunité de rejoindre des équipes de contribution non liées au code telles que Communauté (organisation d’évènements et encadrement des équipes), Design, Documentation, Formation, etc.</p>\n\n\n\n<h2 class=\"wp-block-heading\">Qui peut candidater ?</h2>\n\n\n\n<ul class=\"wp-block-list\">\n<li>Pour les mentoré·e·s : toute personne souhaitant débuter la contribution à WordPress, ou encore contribuer à d’autres équipes que celle(s) où il/elle contribue déjà.</li>\n\n\n\n<li>Pour les mentors : toute personne ayant déjà un peu d’expérience dans la contribution WordPress.</li>\n</ul>\n\n\n\n<h2 class=\"wp-block-heading\">Comment rejoindre le programme ?</h2>\n\n\n\n<p>Pour rejoindre le programme, il faut remplir un petit formulaire :</p>\n\n\n\n<div class=\"wp-block-buttons is-layout-flex wp-block-buttons-is-layout-flex\">\n<div class=\"wp-block-button\"><a class=\"wp-block-button__link wp-element-button\" href=\"https://docs.google.com/forms/d/e/1FAIpQLSd6faivlMZzyiq1sx_78fvnw7-JOshZMZcIO6BTp-B7TuM2ww/viewform\" target=\"_blank\" rel=\"noreferrer noopener\">Candidater en tant que mentoré·e</a></div>\n\n\n\n<div class=\"wp-block-button\"><a class=\"wp-block-button__link wp-element-button\" href=\"https://docs.google.com/forms/d/e/1FAIpQLSfDzRRrIDJcQcVF0m3I16-RfwrjmXBHboxCC5Rx0OHatK_EBQ/viewform\" target=\"_blank\" rel=\"noreferrer noopener\">Candidater en tant que mentor</a></div>\n</div>\n\n\n\n<p>Mais <strong>attention date limite des candidatures</strong> : </p>\n\n\n\n<p class=\"has-text-align-center has-light-grey-2-color has-vivid-red-background-color has-text-color has-background has-link-color wp-elements-18846e5805f4ed69ba3dc19961036bd1\" style=\"margin-top:var(--wp--preset--spacing--10);margin-right:var(--wp--preset--spacing--10);margin-bottom:var(--wp--preset--spacing--10);margin-left:var(--wp--preset--spacing--10);padding-top:var(--wp--preset--spacing--10);padding-right:var(--wp--preset--spacing--10);padding-bottom:var(--wp--preset--spacing--10);padding-left:var(--wp--preset--spacing--10)\">le 26 août 2024</p>\n\n\n\n<p>Vous serez ensuite recontacté·e.</p>\n\n\n\n<h2 class=\"wp-block-heading\">Contribuer dans votre langue</h2>\n\n\n\n<p>Ce 3<sup>e</sup> programme propose une nouveauté : selon le projet auquel vous participerez, vous aurez peut être l’opportunité de contribuer en français, puisque des équipes par locale vont être constituées.</p>\n\n\n\n<h2 class=\"wp-block-heading\">Plus d&rsquo;informations</h2>\n\n\n\n<p>Retrouvez plus d&rsquo;informations sur le programme dans cet article (en anglais) :</p>\n\n\n\n<figure class=\"wp-block-embed aligncenter is-type-wp-embed is-provider-wordpress-org-project wp-block-embed-wordpress-org-project\"><div class=\"wp-block-embed__wrapper\">\n<blockquote class=\"wp-embedded-content\" data-secret=\"TOusFk6YKX\"><a href=\"https://make.wordpress.org/project/2024/08/16/wordpress-contributor-mentorship-program-cohort-3-2024-q4-call-for-mentees-mentors/\">WordPress Contributor Mentorship Program Cohort #3 (2024 Q4): Call for Mentees &amp; Mentors</a></blockquote><iframe loading=\"lazy\" class=\"wp-embedded-content\" sandbox=\"allow-scripts\" security=\"restricted\"  title=\"&#8220;WordPress Contributor Mentorship Program Cohort #3 (2024 Q4): Call for Mentees &amp; Mentors&#8221; &#8212; WordPress.org Project\" src=\"https://make.wordpress.org/project/2024/08/16/wordpress-contributor-mentorship-program-cohort-3-2024-q4-call-for-mentees-mentors/embed/#?secret=93CdKWMRfW#?secret=TOusFk6YKX\" data-secret=\"TOusFk6YKX\" width=\"500\" height=\"282\" frameborder=\"0\" marginwidth=\"0\" marginheight=\"0\" scrolling=\"no\"></iframe>\n</div></figure>\n\n\n\n<p class=\"has-text-align-center has-light-grey-2-color has-purple-2-background-color has-text-color has-background has-link-color has-extra-large-font-size wp-elements-ce3e97f8976a3a3f44d47b605fc66a4f\" style=\"margin-top:var(--wp--preset--spacing--30);margin-right:var(--wp--preset--spacing--30);margin-bottom:var(--wp--preset--spacing--30);margin-left:var(--wp--preset--spacing--30);padding-top:var(--wp--preset--spacing--30);padding-right:var(--wp--preset--spacing--30);padding-bottom:var(--wp--preset--spacing--30);padding-left:var(--wp--preset--spacing--30)\">On compte sur vous pour vous inscrire nombreux et nombreuses à ce programme !<br>Si vous n’avez jamais contribué c’est l’occasion rêvée de commencer, si vous contribuez déjà et souhaitez rejoindre de nouvelles équipes ce programme est fait pour vous !</p>\n\n\n\n<p></p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:30:\"com-wordpress:feed-additions:1\";a:1:{s:7:\"post-id\";a:1:{i:0;a:5:{s:4:\"data\";s:4:\"3204\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:7;a:6:{s:4:\"data\";s:57:\"\n		\n		\n		\n		\n		\n				\n		\n\n					\n										\n					\n		\n		\n			\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:4:{s:0:\"\";a:6:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:28:\"WordPress 6.6 « Dorsey »\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:57:\"https://fr.wordpress.org/2024/07/16/wordpress-6-6-dorsey/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Tue, 16 Jul 2024 17:40:31 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Nouvelles versions de WordPress\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:32:\"https://fr.wordpress.org/?p=3181\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:408:\"Nous avons le plaisir de vous présenter WordPress&#160;6.6 «&#160;Dorsey&#160;», version nommée en l&#8217;honneur du légendaire leader de big band américain Tommy Dorsey. Reconnu pour son timbre de trombone et pour ses compositions, la musique de Dorsey envoûte son audience grâce à sa profondeur émotionnelle et son énergie. Écoutez la musique du Dorsey’s Big Band tandis que vous [&#8230;]\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:9:\"Jb Audras\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:68957:\"\n<figure class=\"wp-block-image size-large\"><a href=\"https://fr.wordpress.org/files/2024/07/dorsey.png\"><img loading=\"lazy\" decoding=\"async\" width=\"1024\" height=\"680\" src=\"https://fr.wordpress.org/files/2024/07/dorsey-1024x680.png\" alt=\"\" class=\"wp-image-3199\" srcset=\"https://fr.wordpress.org/files/2024/07/dorsey-1024x680.png 1024w, https://fr.wordpress.org/files/2024/07/dorsey-300x199.png 300w, https://fr.wordpress.org/files/2024/07/dorsey-768x510.png 768w, https://fr.wordpress.org/files/2024/07/dorsey-1536x1021.png 1536w, https://fr.wordpress.org/files/2024/07/dorsey-2048x1361.png 2048w\" sizes=\"auto, (max-width: 1024px) 100vw, 1024px\" /></a></figure>\n\n\n\n<p>Nous avons le plaisir de vous présenter WordPress&nbsp;6.6 «&nbsp;Dorsey&nbsp;», version nommée en l&rsquo;honneur du légendaire <bdo lang=\"en\" dir=\"ltr\">leader</bdo> de <bdo lang=\"en\" dir=\"ltr\">big band</bdo> américain Tommy Dorsey. Reconnu pour son timbre de trombone et pour ses compositions, la musique de Dorsey envoûte son audience grâce à sa profondeur émotionnelle et son énergie.</p>\n\n\n\n<p>Écoutez la musique du <a href=\"https://open.spotify.com/playlist/37i9dQZF1DZ06evO2TT3Ge?si=d9872e46371c4ed7\" target=\"_blank\" rel=\"noreferrer noopener\"><bdo lang=\"en\" dir=\"ltr\">Dorsey’s Big Band</bdo></a> tandis que vous découvrirez les nouvelles fonctionnalités et les améliorations de WordPress 6.6.</p>\n\n\n\n<h2 class=\"wp-block-heading\">Bienvenue à 6.6&nbsp;!</h2>\n\n\n\n<p>WordPress 6.6 répond à la promesse d’un web meilleur en ajoutant de nouveaux outils pour améliorer le quotidien des créateurs de contenus, des sites les plus complexes aux sites «&nbsp;<bdo lang=\"en\" dir=\"ltr\">one page</bdo>&nbsp;». Sans jamais mettre de côté la sécurité, la stabilité ou les performances, WordPress 6.6 apporte de nouveaux outils et améliore les flux de rédaction déjà en place.</p>\n\n\n\n<p>Une nouvelle fonctionnalité de restauration pour les mises à jour automatiques des extensions vous offre quant à elle sécurité, flexibilité et sérénité.</p>\n\n\n\n<div class=\"wp-block-buttons is-layout-flex wp-block-buttons-is-layout-flex\">\n<div class=\"wp-block-button\"><a class=\"wp-block-button__link wp-element-button\" href=\"https://fr.wordpress.org/download/\">Téléchargez WordPress 6.6 «&nbsp;Dorsey&nbsp;»</a></div>\n</div>\n\n\n\n<h3 class=\"wp-block-heading\">Palettes de couleurs et ensembles de polices</h3>\n\n\n\n<div class=\"wp-block-columns is-layout-flex wp-container-core-columns-is-layout-28f84493 wp-block-columns-is-layout-flex\">\n<div class=\"wp-block-column is-layout-flow wp-block-column-is-layout-flow\" style=\"flex-basis:33.33%\">\n<figure class=\"wp-block-image size-large\"><img decoding=\"async\" src=\"https://s.w.org/images/core/6.6/color-palettes.webp\" alt=\"\" /></figure>\n</div>\n\n\n\n<div class=\"wp-block-column is-vertically-aligned-center is-layout-flow wp-block-column-is-layout-flow\" style=\"flex-basis:66.66%\">\n<p><strong>Ajout de davantage d’options de conception aux thèmes basés sur des blocs.</strong>&nbsp;Les auteur·ices de thèmes basés sur les blocs peuvent créer un nombre illimité de palettes de couleurs ou de polices personnalisées pour offrir des options graphiques plus spécifiques au sein du même thème. Ces palettes offrent des possibilités graphiques plus harmonisées, permettant une personnalisation sans modifier le style global du site, au-delà des paramètres de couleur ou de typographie.</p>\n</div>\n</div>\n\n\n\n<h3 class=\"wp-block-heading\">Aperçu rapide des pages</h3>\n\n\n\n<div class=\"wp-block-columns is-layout-flex wp-container-core-columns-is-layout-28f84493 wp-block-columns-is-layout-flex\">\n<div class=\"wp-block-column is-layout-flow wp-block-column-is-layout-flow\" style=\"flex-basis:33.33%\">\n<figure class=\"wp-block-image size-large\"><img decoding=\"async\" src=\"https://s.w.org/images/core/6.6/page-previews.webp\" alt=\"\" /></figure>\n</div>\n\n\n\n<div class=\"wp-block-column is-vertically-aligned-center is-layout-flow wp-block-column-is-layout-flow\" style=\"flex-basis:66.66%\">\n<p><strong>Simplifiez votre flux de travail avec une nouvelle mise en page conçue pour les pages.</strong>&nbsp;Découvrez toutes vos pages et un aperçu de n’importe quelle page sélectionnée avant de la modifier via une nouvelle mise en page dans l’éditeur de site.</p>\n</div>\n</div>\n\n\n\n<h3 class=\"wp-block-heading\">Retour en arrière pour les mises à jour automatiques d’extensions</h3>\n\n\n\n<div class=\"wp-block-columns is-layout-flex wp-container-core-columns-is-layout-28f84493 wp-block-columns-is-layout-flex\">\n<div class=\"wp-block-column is-layout-flow wp-block-column-is-layout-flow\" style=\"flex-basis:33.33%\">\n<figure class=\"wp-block-image size-large\"><img decoding=\"async\" src=\"https://s.w.org/images/core/6.6/feature-rollbacks.webp\" alt=\"\" /></figure>\n</div>\n\n\n\n<div class=\"wp-block-column is-vertically-aligned-center is-layout-flow wp-block-column-is-layout-flow\" style=\"flex-basis:66.66%\">\n<p><strong>Mettez à jour vos extensions en toute tranquillité.</strong>&nbsp;Bénéficiez de la facilité des mises à jour automatiques des extensions avec la possibilité de restauration en cas de problème, améliorant ainsi la sécurité de votre site tout en minimisant les risques d’indisponibilité potentielle de celui-ci.</p>\n</div>\n</div>\n\n\n\n<h3 class=\"wp-block-heading\">Surcharges</h3>\n\n\n\n<div class=\"wp-block-columns is-layout-flex wp-container-core-columns-is-layout-28f84493 wp-block-columns-is-layout-flex\">\n<div class=\"wp-block-column is-layout-flow wp-block-column-is-layout-flow\" style=\"flex-basis:33.33%\">\n<figure class=\"wp-block-image size-large\"><img decoding=\"async\" src=\"https://s.w.org/images/core/6.6/overrides.webp\" alt=\"\" /></figure>\n</div>\n\n\n\n<div class=\"wp-block-column is-vertically-aligned-center is-layout-flow wp-block-column-is-layout-flow\" style=\"flex-basis:66.66%\">\n<p><strong>Ajout de la possibilité de personnaliser les contenus dans les compositions synchronisées.</strong>&nbsp;Autoriser la personnalisation des éléments de contenu spécifiques dans chaque apparition d’une composition synchronisée tout en conservant un style uniformisé pour toutes les apparitions, simplifiant ainsi les futures mises à jour. Actuellement, vous pouvez définir des surcharges pour les blocs Titre, Paragraphe, Bouton et Image.</p>\n</div>\n</div>\n\n\n\n<h3 class=\"wp-block-heading\">Améliorations des performances</h3>\n\n\n\n<p>WordPress 6.6 comprend des mises à jour importantes comme le retrait d&rsquo;appels redondants vers <code>WP_Theme_JSON</code>, la désactivation du chargement automatique pour les options les plus volumétriques, la suppression de dépendances inutiles, le chargement différé des contenus embarqués, la nouvelle directive <code>data-wp-on-async</code> et une réduction de 33 % du chargement des modèles dans l&rsquo;éditeur.</p>\n\n\n\n<h3 class=\"wp-block-heading\">Améliorations de l’accessibilité</h3>\n\n\n\n<p>Plus de 55 correctifs d’accessibilité et améliorations se concentrent sur des aspects fondamentaux de l’expérience WordPress, en particulier le composant de vue de données qui alimente la nouvelle expérience de modification de site et des domaines comme l’outil d’insertion qui fournit un moyen-clé d’interagir avec les blocs et les compositions.</p>\n\n\n\n<h3 class=\"wp-block-heading\">Et bien plus encore</h3>\n\n\n\n<p>Pour une vision complète de toutes les nouvelles fonctionnalités et améliorations de WordPress 6.6, vous pouvez consulter le site de démonstration des fonctionnalités.</p>\n\n\n\n<p><a href=\"https://fr.wordpress.org/download/releases/6-6/\">Découvrez toutes les nouveautés</a></p>\n\n\n\n<h3 class=\"wp-block-heading\">En savoir plus sur WordPress 6.6</h3>\n\n\n\n<p><a href=\"https://learn.wordpress.org/\"><em>Learn WordPress</em></a>&nbsp;est une ressource gratuite pour les personnes qui utilisent WordPress, qu’elles soient débutantes ou expérimentées.&nbsp;<em>Learn</em>&nbsp;contient des vidéos pratiques sur l’utilisation de diverses fonctionnalités de WordPress, des&nbsp;<a href=\"https://learn.wordpress.org/online-workshops/\">évènements interactifs</a>&nbsp;pour explorer des sujets en profondeur, et des plans de cours pour approfondir des domaines spécifiques de WordPress.</p>\n\n\n\n<p>Explorez le&nbsp;<a href=\"https://fr.wordpress.org/2024/06/27/guide-des-changements-techniques-de-wordpress-6-6/\">Guide des changements techniques de WordPress 6.6</a>. Découvrez les changements de cette version avec les notes détaillées des développeurs et développeuses qui vous aident à construire avec WordPress.</p>\n\n\n\n<p><a href=\"https://wordpress.org/support/wordpress-version/version-6-6/\">Lisez les notes de version de WordPress 6.6</a>&nbsp;pour obtenir des informations sur l’installation, les améliorations, les problèmes corrigés, les contributeurs et contributrices de la version, les ressources d’apprentissage et la liste des modifications apportées aux fichiers.</p>\n\n\n\n<h2 class=\"wp-block-heading\">L’équipe de direction de WordPress&nbsp;6.6</h2>\n\n\n\n<p>Voici l’équipe qui a coordonné le développement et la sortie de cette nouvelle version de WordPress&nbsp;:</p>\n\n\n\n<ul class=\"wp-block-list\">\n<li>Direction générale&nbsp;:&nbsp;<a href=\"https://profiles.wordpress.org/matt/\">Matt Mullenweg</a></li>\n\n\n\n<li>Coordination générale&nbsp;:&nbsp;<a href=\"https://profiles.wordpress.org/meher/\">Meher Bala</a></li>\n\n\n\n<li>Direction technique côté Cœur&nbsp;:&nbsp;<a href=\"https://profiles.wordpress.org/audrasjb/\">Jb Audras</a></li>\n\n\n\n<li>Direction technique côté Gutenberg&nbsp;:&nbsp;<a href=\"https://profiles.wordpress.org/ellatrix/\">Ella van Durpe</a>,&nbsp;<a href=\"https://profiles.wordpress.org/vcanales/\">Vicente Canales</a></li>\n\n\n\n<li>Gestion de projet technique côté Cœur&nbsp;:&nbsp;<a href=\"https://profiles.wordpress.org/oglekler/\">Olga Gleckler</a>,&nbsp;<a href=\"https://profiles.wordpress.org/nhrrob/\">Nazmul Hasan Robin</a></li>\n\n\n\n<li>Gestion de projet technique côté Gutenberg&nbsp;:&nbsp;<a href=\"https://profiles.wordpress.org/fabiankaegy/\">Fabian Kägy</a>,&nbsp;<a href=\"https://profiles.wordpress.org/colorful-tones/\">Damon Cook</a>&nbsp;</li>\n\n\n\n<li>Responsables de la documentation&nbsp;:&nbsp;<a href=\"https://profiles.wordpress.org/juanmaguitar/\">JuanMa Garrido</a>,&nbsp;<a href=\"https://profiles.wordpress.org/jdy68/\">Jenny Dupuy</a>,&nbsp;<a href=\"https://profiles.wordpress.org/josepmoran/\">Josep Morán</a></li>\n\n\n\n<li>Direction marketing et communication&nbsp;:&nbsp;<a href=\"https://profiles.wordpress.org/marybaum/\">Mary Baum</a></li>\n\n\n\n<li>Direction artistique : <a href=\"https://profiles.wordpress.org/richtabor/\">Rich Tabor</a></li>\n\n\n\n<li>Responsable des performances&nbsp;:&nbsp;<a href=\"https://profiles.wordpress.org/adamsilverstein/\">Adam Silverstein</a></li>\n\n\n\n<li>Responsables des tests&nbsp;:&nbsp;<a href=\"https://profiles.wordpress.org/oglekler/\">Olga Gleckler</a>,&nbsp;<a href=\"https://profiles.wordpress.org/lumiblog/\">Patrick Lumumba</a>&nbsp;et&nbsp;<a href=\"https://profiles.wordpress.org/vipuljnext/\">Vipul Ghori</a></li>\n\n\n\n<li>Responsable des thèmes natifs&nbsp;:&nbsp;<a href=\"https://profiles.wordpress.org/poena/\">Carolina Nymark</a></li>\n</ul>\n\n\n\n<h2 class=\"wp-block-heading\">Merci aux contributeurs et contributrices</h2>\n\n\n\n<p>WordPress 6.6 n’aurait pas pu sortir sans la contribution passionnée de plus de&nbsp;<strong>630 personnes provenant d’au moins 50 pays différents</strong>.</p>\n\n\n\n<p>Un remerciement tout spécial pour les plus de 150 personnes qui ont contribué au cœur de WordPress pour la première fois avec WP&nbsp;6.6 <img src=\"https://s.w.org/images/core/emoji/16.0.1/72x72/2665.png\" alt=\"♥\" class=\"wp-smiley\" style=\"height: 1em; max-height: 1em;\" /></p>\n\n\n\n<p style=\"font-size:10px\"><a href=\"https://profiles.wordpress.org/benniledl/\">!Benni</a> · <a href=\"https://profiles.wordpress.org/_ck_/\">_ck_</a> · <a href=\"https://profiles.wordpress.org/jorbin/\">Aaron Jorbin</a> · <a href=\"https://profiles.wordpress.org/aaronrobertshaw/\">Aaron Robertshaw</a> · <a href=\"https://profiles.wordpress.org/abmamun007/\">Abdullah Mamun</a> · <a href=\"https://profiles.wordpress.org/webcommsat/\">Abha Thakor</a> · <a href=\"https://profiles.wordpress.org/fitehal/\">Abhishek Deshpande</a> · <a href=\"https://profiles.wordpress.org/abletec/\">abletec</a> · <a href=\"https://profiles.wordpress.org/acosmin/\">acosmin</a> · <a href=\"https://profiles.wordpress.org/adampickering/\">Adam Pickering</a> · <a href=\"https://profiles.wordpress.org/adamsilverstein/\">Adam Silverstein</a> · <a href=\"https://profiles.wordpress.org/adarshposimyth/\">Adarsh Akshat</a> · <a href=\"https://profiles.wordpress.org/ajmcfadyen/\">admcfajn</a> · <a href=\"https://profiles.wordpress.org/adrianduffell/\">adrianduffell</a> · <a href=\"https://profiles.wordpress.org/chaion07/\">Ahmed Chaion</a> · <a href=\"https://profiles.wordpress.org/engahmeds3ed/\">Ahmed Saeed</a> · <a href=\"https://profiles.wordpress.org/ajithrn/\">Ajith R N</a> · <a href=\"https://profiles.wordpress.org/skyakash12/\">Akash Muchandikar</a> · <a href=\"https://profiles.wordpress.org/wildworks/\">Aki Hamano</a> · <a href=\"https://profiles.wordpress.org/atachibana/\">Akira Tachibana</a> · <a href=\"https://profiles.wordpress.org/akmelias/\">akmelias</a> · <a href=\"https://profiles.wordpress.org/wpfy/\">Akramul Hasan</a> · <a href=\"https://profiles.wordpress.org/akshayar/\">Akshaya Rane</a> · <a href=\"https://profiles.wordpress.org/schlessera/\">Alain Schlesser</a> · <a href=\"https://profiles.wordpress.org/alanfuller/\">Alan Fuller</a> · <a href=\"https://profiles.wordpress.org/ahoereth/\">Alex</a> · <a href=\"https://profiles.wordpress.org/xknown/\">Alex Concha</a> · <a href=\"https://profiles.wordpress.org/alexkingorg/\">Alex King</a> · <a href=\"https://profiles.wordpress.org/akirk/\">Alex Kirk</a> · <a href=\"https://profiles.wordpress.org/ajlende/\">Alex Lende</a> · <a href=\"https://profiles.wordpress.org/viper007bond/\">Alex Mills</a> · <a href=\"https://profiles.wordpress.org/alexstine/\">Alex Stine</a> · <a href=\"https://profiles.wordpress.org/alexandrebuffet/\">Alexandre Buffet</a> · <a href=\"https://profiles.wordpress.org/alexanderkoledov/\">AlexKole</a> · <a href=\"https://profiles.wordpress.org/alh0319/\">Amber Hinds</a> · <a href=\"https://profiles.wordpress.org/sabreuse/\">Amy Hendrix (sabreuse)</a> · <a href=\"https://profiles.wordpress.org/amykamala/\">Amy Kamala</a> · <a href=\"https://profiles.wordpress.org/anandau14/\">Anand Upadhyay</a> · <a href=\"https://profiles.wordpress.org/anlino/\">Anders Norén</a> · <a href=\"https://profiles.wordpress.org/afercia/\">Andrea Fercia</a> · <a href=\"https://profiles.wordpress.org/andraganescu/\">Andrei Draganescu</a> · <a href=\"https://profiles.wordpress.org/euthelup/\">Andrei Lupu</a> · <a href=\"https://profiles.wordpress.org/andrewhayward/\">Andrew Hayward</a> · <a href=\"https://profiles.wordpress.org/l1nuxjedi/\">Andrew Hutchings</a> · <a href=\"https://profiles.wordpress.org/nacin/\">Andrew Nacin</a> · <a href=\"https://profiles.wordpress.org/norcross/\">Andrew Norcross</a> · <a href=\"https://profiles.wordpress.org/azaozz/\">Andrew Ozz</a> · <a href=\"https://profiles.wordpress.org/andrewserong/\">Andrew Serong</a> · <a href=\"https://profiles.wordpress.org/andrewleap/\">andrewleap</a> · <a href=\"https://profiles.wordpress.org/andbalashov/\">Andrii Balashov</a> · <a href=\"https://profiles.wordpress.org/oandregal/\">André Maneiro</a> · <a href=\"https://profiles.wordpress.org/afragen/\">Andy Fragen</a> · <a href=\"https://profiles.wordpress.org/apeatling/\">Andy Peatling</a> · <a href=\"https://profiles.wordpress.org/aneeshd16/\">Aneesh Devasthale</a> · <a href=\"https://profiles.wordpress.org/ankit-k-gupta/\">Ankit K Gupta</a> · <a href=\"https://profiles.wordpress.org/ankitmaru/\">Ankit Panchal</a> · <a href=\"https://profiles.wordpress.org/annezazu/\">Anne McCarthy</a> · <a href=\"https://profiles.wordpress.org/antpb/\">Anthony Burchell</a> · <a href=\"https://profiles.wordpress.org/ant1busted/\">Antoine</a> · <a href=\"https://profiles.wordpress.org/antonlukin/\">Anton Lukin</a> · <a href=\"https://profiles.wordpress.org/atimmer/\">Anton Timmermans</a> · <a href=\"https://profiles.wordpress.org/antonvlasenko/\">Anton Vlasenko</a> · <a href=\"https://profiles.wordpress.org/lighthouse79/\">Antonella</a> · <a href=\"https://profiles.wordpress.org/colomet/\">Antonio D.</a> · <a href=\"https://profiles.wordpress.org/antonisme/\">Antonis Lilis</a> · <a href=\"https://profiles.wordpress.org/arena94/\">arena94</a> · <a href=\"https://profiles.wordpress.org/aristath/\">Ari Stathopoulos</a> · <a href=\"https://profiles.wordpress.org/passoniate/\">Arslan Kalwar</a> · <a href=\"https://profiles.wordpress.org/artemiosans/\">Artemio Morales</a> · <a href=\"https://profiles.wordpress.org/arthur791004/\">Arthur Chu</a> · <a href=\"https://profiles.wordpress.org/iamarunchaitanyajami/\">Arun Chaitanya Jami</a> · <a href=\"https://profiles.wordpress.org/dextorlobo/\">Arun Sharma</a> · <a href=\"https://profiles.wordpress.org/ideag/\">Arunas Liuiza</a> · <a href=\"https://profiles.wordpress.org/iamasadpolash/\">Asad Polash</a> · <a href=\"https://profiles.wordpress.org/ashfame/\">Ashish Kumar (Ashfame)</a> · <a href=\"https://profiles.wordpress.org/mohonchandra/\">Asish Chandra Mohon</a> · <a href=\"https://profiles.wordpress.org/aslamdoctor/\">Aslam Doctor</a> · <a href=\"https://profiles.wordpress.org/audunmb/\">audunmb</a> · <a href=\"https://profiles.wordpress.org/aurooba/\">Aurooba Ahmed</a> · <a href=\"https://profiles.wordpress.org/filosofo/\">Austin Matzko</a> · <a href=\"https://profiles.wordpress.org/axwax/\">axwax</a> · <a href=\"https://profiles.wordpress.org/ayeshrajans/\">Ayesh Karunaratne</a> · <a href=\"https://profiles.wordpress.org/beryldlg/\">Béryl de La Grandière</a> · <a href=\"https://profiles.wordpress.org/bahia0019/\">bahia0019</a> · <a href=\"https://profiles.wordpress.org/balub/\">Balu B</a> · <a href=\"https://profiles.wordpress.org/bangank36/\">bangank36</a> · <a href=\"https://profiles.wordpress.org/barry/\">Barry</a> · <a href=\"https://profiles.wordpress.org/barryhughes-1/\">Barry</a> · <a href=\"https://profiles.wordpress.org/bartkalisz/\">Bart Kalisz</a> · <a href=\"https://profiles.wordpress.org/bartkleinreesink/\">bartkleinreesink</a> · <a href=\"https://profiles.wordpress.org/beafialho/\">Beatriz Fialho</a> · <a href=\"https://profiles.wordpress.org/beaulebens/\">Beau Lebens</a> · <a href=\"https://profiles.wordpress.org/bedas/\">Beda</a> · <a href=\"https://profiles.wordpress.org/benharri/\">ben</a> · <a href=\"https://profiles.wordpress.org/scruffian/\">Ben Dwyer</a> · <a href=\"https://profiles.wordpress.org/ubernaut/\">Ben Hansen</a> · <a href=\"https://profiles.wordpress.org/husobj/\">Ben Huson</a> · <a href=\"https://profiles.wordpress.org/benlk/\">Ben Keith</a> · <a href=\"https://profiles.wordpress.org/blobaugh/\">Ben Lobaugh (blobaugh)</a> · <a href=\"https://profiles.wordpress.org/britner/\">Ben Ritner – Kadence WP</a> · <a href=\"https://profiles.wordpress.org/retlehs/\">Ben Word</a> · <a href=\"https://profiles.wordpress.org/benjamingosset/\">Benjamin Gosset</a> · <a href=\"https://profiles.wordpress.org/benjamin_zekavica/\">Benjamin Zekavica</a> · <a href=\"https://profiles.wordpress.org/benjaminknox/\">benjaminknox</a> · <a href=\"https://profiles.wordpress.org/benoitchantre/\">Benoit Chantre</a> · <a href=\"https://profiles.wordpress.org/benoitfouc/\">benoitfouc</a> · <a href=\"https://profiles.wordpress.org/bernhard reiter/\">Bernhard Reiter</a> · <a href=\"https://profiles.wordpress.org/bernhard-reiter/\">bernhard-reiter</a> · <a href=\"https://profiles.wordpress.org/billseymour/\">billseymour</a> · <a href=\"https://profiles.wordpress.org/bplv/\">Biplav</a> · <a href=\"https://profiles.wordpress.org/bph/\">Birgit Pauli-Haack</a> · <a href=\"https://profiles.wordpress.org/bobbingwide/\">bobbingwide</a> · <a href=\"https://profiles.wordpress.org/boonebgorges/\">Boone Gorges</a> · <a href=\"https://profiles.wordpress.org/born2webdesign/\">born2webdesign</a> · <a href=\"https://profiles.wordpress.org/bjorsch/\">Brad Jorsch</a> · <a href=\"https://profiles.wordpress.org/bradparbs/\">Brad Parbs</a> · <a href=\"https://profiles.wordpress.org/williamsba1/\">Brad Williams</a> · <a href=\"https://profiles.wordpress.org/kraftbj/\">Brandon Kraft</a> · <a href=\"https://profiles.wordpress.org/drrobotnik/\">Brandon Lavigne</a> · <a href=\"https://profiles.wordpress.org/ironprogrammer/\">Brian Alexander</a> · <a href=\"https://profiles.wordpress.org/bacoords/\">Brian Coords</a> · <a href=\"https://profiles.wordpress.org/fischfood/\">Brian Fischer</a> · <a href=\"https://profiles.wordpress.org/bgardner/\">Brian Gardner</a> · <a href=\"https://profiles.wordpress.org/masteradhoc/\">Brian Haas</a> · <a href=\"https://profiles.wordpress.org/brianhenryie/\">Brian Henry</a> · <a href=\"https://profiles.wordpress.org/brookemk/\">Brooke</a> · <a href=\"https://profiles.wordpress.org/burnuser/\">burnuser</a> · <a href=\"https://profiles.wordpress.org/icaleb/\">Caleb Burks</a> · <a href=\"https://profiles.wordpress.org/ecc/\">camya</a> · <a href=\"https://profiles.wordpress.org/karl94/\">Carlo Cannas</a> · <a href=\"https://profiles.wordpress.org/cbravobernal/\">Carlos Bravo</a> · <a href=\"https://profiles.wordpress.org/carlosgprim/\">Carlos G. P.</a> · <a href=\"https://profiles.wordpress.org/poena/\">Carolina Nymark</a> · <a href=\"https://profiles.wordpress.org/cbirdsong/\">cbirdsong</a> · <a href=\"https://profiles.wordpress.org/cenkdemir/\">cenkdemir</a> · <a href=\"https://profiles.wordpress.org/cfinnberg/\">cfinnberg</a> · <a href=\"https://profiles.wordpress.org/shireling/\">Chad Chadbourne</a> · <a href=\"https://profiles.wordpress.org/chasedsiedu/\">chased@si.edu</a> · <a href=\"https://profiles.wordpress.org/mel_cha/\">chiilog (Chiaki Okamoto)</a> · <a href=\"https://profiles.wordpress.org/chouby/\">Chouby</a> · <a href=\"https://profiles.wordpress.org/chrisdavidmiles/\">Chris David Miles</a> · <a href=\"https://profiles.wordpress.org/jazzs3quence/\">Chris Reynolds</a> · <a href=\"https://profiles.wordpress.org/chriscct7/\">chriscct7</a> · <a href=\"https://profiles.wordpress.org/itschristiandale/\">christian-dale</a> · <a href=\"https://profiles.wordpress.org/christopherplus/\">Christopher</a> · <a href=\"https://profiles.wordpress.org/chrystl/\">Chrystl</a> · <a href=\"https://profiles.wordpress.org/codepo8/\">codepo8</a> · <a href=\"https://profiles.wordpress.org/cdevroe/\">Colin Devroe</a> · <a href=\"https://profiles.wordpress.org/costdev/\">Colin Stewart</a> · <a href=\"https://profiles.wordpress.org/colind/\">ColinD</a> · <a href=\"https://profiles.wordpress.org/cookiesfordevo/\">CookiesForDevo</a> · <a href=\"https://profiles.wordpress.org/coreyw/\">Corey Worrell</a> · <a href=\"https://profiles.wordpress.org/courane01/\">Courtney Robertson</a> · <a href=\"https://profiles.wordpress.org/creativeslice/\">Creative Slice</a> · <a href=\"https://profiles.wordpress.org/crstauf/\">crstauf</a> · <a href=\"https://profiles.wordpress.org/cwhitmore/\">Cullen Whitmore</a> · <a href=\"https://profiles.wordpress.org/cu121/\">Cupid Chakma</a> · <a href=\"https://profiles.wordpress.org/cvorko/\">cvorko</a> · <a href=\"https://profiles.wordpress.org/didierjm/\">cybeardjm</a> · <a href=\"https://profiles.wordpress.org/cyberchicken/\">Cyberchicken</a> · <a href=\"https://profiles.wordpress.org/colorful-tones/\">Damon Cook</a> · <a href=\"https://profiles.wordpress.org/dansoschin/\">Dan Soschin</a> · <a href=\"https://profiles.wordpress.org/danielbachhuber/\">Daniel Bachhuber</a> · <a href=\"https://profiles.wordpress.org/mzaweb/\">Daniel Dvorkin</a> · <a href=\"https://profiles.wordpress.org/mapumba/\">Daniel Käfer</a> · <a href=\"https://profiles.wordpress.org/talldanwp/\">Daniel Richards</a> · <a href=\"https://profiles.wordpress.org/schutzsmith/\">Daniel Schutzsmith</a> · <a href=\"https://profiles.wordpress.org/danieldudzic/\">danieldudzic</a> · <a href=\"https://profiles.wordpress.org/mte90/\">Daniele Scasciafratte</a> · <a href=\"https://profiles.wordpress.org/danieltj/\">danieltj</a> · <a href=\"https://profiles.wordpress.org/nerrad/\">Darren Ethier (nerrad)</a> · <a href=\"https://profiles.wordpress.org/darshitrajyaguru97/\">Darshit Rajyaguru</a> · <a href=\"https://profiles.wordpress.org/darssen/\">darssen</a> · <a href=\"https://profiles.wordpress.org/davecpage/\">Dave Page</a> · <a href=\"https://profiles.wordpress.org/darerodz/\">David Arenas</a> · <a href=\"https://profiles.wordpress.org/dartiss/\">David Artiss</a> · <a href=\"https://profiles.wordpress.org/davidbaumwald/\">David Baumwald</a> · <a href=\"https://profiles.wordpress.org/davidbinda/\">David Biňovec</a> · <a href=\"https://profiles.wordpress.org/dpcalhoun/\">David Calhoun</a> · <a href=\"https://profiles.wordpress.org/dlh/\">David Herrera</a> · <a href=\"https://profiles.wordpress.org/justlevine/\">David Levine</a> · <a href=\"https://profiles.wordpress.org/dglingren/\">David Lingren</a> · <a href=\"https://profiles.wordpress.org/davidperez/\">David Perez</a> · <a href=\"https://profiles.wordpress.org/get_dave/\">David Smith</a> · <a href=\"https://profiles.wordpress.org/dsas/\">Dean Sas</a> · <a href=\"https://profiles.wordpress.org/denis-de-bernardy/\">Denis de Bernardy</a> · <a href=\"https://profiles.wordpress.org/dingo_d/\">Denis Žoljom</a> · <a href=\"https://profiles.wordpress.org/dionysous/\">Dennis Hipp</a> · <a href=\"https://profiles.wordpress.org/dmsnell/\">Dennis Snell</a> · <a href=\"https://profiles.wordpress.org/dennysdionigi/\">Dennys Dionigi</a> · <a href=\"https://profiles.wordpress.org/derekblank/\">Derek Blank</a> · <a href=\"https://profiles.wordpress.org/valendesigns/\">Derek Herman</a> · <a href=\"https://profiles.wordpress.org/derekspringer/\">Derek Springer</a> · <a href=\"https://profiles.wordpress.org/designsimply/\">designsimply</a> · <a href=\"https://profiles.wordpress.org/desrosjbot/\">Desrosj Bot</a> · <a href=\"https://profiles.wordpress.org/dernin/\">Devin Curtis</a> · <a href=\"https://profiles.wordpress.org/dlocc/\">Devin Walker</a> · <a href=\"https://profiles.wordpress.org/dharm1025/\">Dharmesh Patel</a> · <a href=\"https://profiles.wordpress.org/dhrumilk/\">Dhrumil Kumbhani</a> · <a href=\"https://profiles.wordpress.org/dhruvishah2203/\">Dhruvi Shah</a> · <a href=\"https://profiles.wordpress.org/dilipbheda/\">Dilip Bheda</a> · <a href=\"https://profiles.wordpress.org/dd32/\">Dion Hulse</a> · <a href=\"https://profiles.wordpress.org/ocean90/\">Dominik Schilling</a> · <a href=\"https://profiles.wordpress.org/dougal/\">Dougal Campbell</a> · <a href=\"https://profiles.wordpress.org/drewapicture/\">Drew Jaynes</a> · <a href=\"https://profiles.wordpress.org/lots0logs/\">Dustin Falgout</a> · <a href=\"https://profiles.wordpress.org/elrae/\">Earle Davies</a> · <a href=\"https://profiles.wordpress.org/ehtis/\">Ehtisham Siddiqui</a> · <a href=\"https://profiles.wordpress.org/ellatrix/\">Ella van&nbsp;Durpe</a> · <a href=\"https://profiles.wordpress.org/codex-m/\">Emerson Maningo</a> · <a href=\"https://profiles.wordpress.org/emirpprime/\">emirpprime</a> · <a href=\"https://profiles.wordpress.org/manooweb/\">Emmanuel Hesry</a> · <a href=\"https://profiles.wordpress.org/endymion00/\">Endymion00</a> · <a href=\"https://profiles.wordpress.org/lopo/\">Enrico Battocchi</a> · <a href=\"https://profiles.wordpress.org/enwikuna/\">Enwikuna</a> · <a href=\"https://profiles.wordpress.org/ericlewis/\">Eric Andrew Lewis</a> · <a href=\"https://profiles.wordpress.org/ethitter/\">Erick Hitter</a> · <a href=\"https://profiles.wordpress.org/kebbet/\">Erik</a> · <a href=\"https://profiles.wordpress.org/estelaris/\">Estela Rueda</a> · <a href=\"https://profiles.wordpress.org/evanltd/\">evanltd</a> · <a href=\"https://profiles.wordpress.org/fabiankaegy/\">Fabian Kägy</a> · <a href=\"https://profiles.wordpress.org/gaambo/\">Fabian Todt</a> · <a href=\"https://profiles.wordpress.org/fabiorubioglio/\">Fabio Rubioglio</a> · <a href=\"https://profiles.wordpress.org/faisalahammad/\">Faisal Ahammad</a> · <a href=\"https://profiles.wordpress.org/faisalahmed29/\">Faisal Ahmed</a> · <a href=\"https://profiles.wordpress.org/faisal03/\">Faisal Alvi</a> · <a href=\"https://profiles.wordpress.org/fanly/\">Fanly</a> · <a href=\"https://profiles.wordpress.org/feastdesignco/\">Feast Design Co.</a> · <a href=\"https://profiles.wordpress.org/felipeelia/\">Felipe Elia</a> · <a href=\"https://profiles.wordpress.org/flixos90/\">Felix Arntz</a> · <a href=\"https://profiles.wordpress.org/flhz/\">Florent Hernandez</a> · <a href=\"https://profiles.wordpress.org/fgiannar/\">Foteini Giannaropoulou (a11n)</a> · <a href=\"https://profiles.wordpress.org/francina/\">Francesca Marano</a> · <a href=\"https://profiles.wordpress.org/francescocarlucci/\">FrancescoCarlucci</a> · <a href=\"https://profiles.wordpress.org/fotodrachen/\">Frank Jäger</a> · <a href=\"https://profiles.wordpress.org/nexflaszlo/\">Frank Laszlo</a> · <a href=\"https://profiles.wordpress.org/wazeter/\">Frank Wazeter</a> · <a href=\"https://profiles.wordpress.org/fushar/\">fushar</a> · <a href=\"https://profiles.wordpress.org/gajendrasingh/\">Gajendra Singh</a> · <a href=\"https://profiles.wordpress.org/ecgan/\">Gan Eng Chin</a> · <a href=\"https://profiles.wordpress.org/garibiza/\">Garbiñe</a> · <a href=\"https://profiles.wordpress.org/pento/\">Gary Pendergast</a> · <a href=\"https://profiles.wordpress.org/gavande1/\">gavande1</a> · <a href=\"https://profiles.wordpress.org/soulseekah/\">Gennady Kovshenin</a> · <a href=\"https://profiles.wordpress.org/mamaduka/\">George Mamadashvili</a> · <a href=\"https://profiles.wordpress.org/georgestephanis/\">George Stephanis</a> · <a href=\"https://profiles.wordpress.org/gerardreches/\">Gerard Reches</a> · <a href=\"https://profiles.wordpress.org/geriux/\">Gerardo Pacheco</a> · <a href=\"https://profiles.wordpress.org/girishpanchal/\">Girish Panchal</a> · <a href=\"https://profiles.wordpress.org/giuseppemazzapica-1/\">Giuseppe Mazzapica</a> · <a href=\"https://profiles.wordpress.org/glendaviesnz/\">Glen Davies</a> · <a href=\"https://profiles.wordpress.org/goldenapples/\">goldenapples</a> · <a href=\"https://profiles.wordpress.org/grantmkin/\">Grant M. Kinney</a> · <a href=\"https://profiles.wordpress.org/gziolo/\">Greg Ziółkowski</a> · <a href=\"https://profiles.wordpress.org/gregbenz/\">gregbenz</a> · <a href=\"https://profiles.wordpress.org/wido/\">Guido Scialfa</a> · <a href=\"https://profiles.wordpress.org/poran766/\">H.M. Mushfiqur Rahman</a> · <a href=\"https://profiles.wordpress.org/hanneslsm/\">hanneslsm</a> · <a href=\"https://profiles.wordpress.org/hztyfoon/\">Hanzala Taifun</a> · <a href=\"https://profiles.wordpress.org/hardik2221/\">Hardik Raval</a> · <a href=\"https://profiles.wordpress.org/hareesh-pillai/\">Hareesh S</a> · <a href=\"https://profiles.wordpress.org/harshgajipara/\">Harsh Gajipara</a> · <a href=\"https://profiles.wordpress.org/harsh175/\">Harsh Patel</a> · <a href=\"https://profiles.wordpress.org/hasanuzzamanshamim/\">Hasanuzzaman Shamim</a> · <a href=\"https://profiles.wordpress.org/halounsbury/\">Heather Wilkins</a> · <a href=\"https://profiles.wordpress.org/muhme/\">Heiko Lübbe</a> · <a href=\"https://profiles.wordpress.org/helen/\">Helen Hou-Sandi</a> · <a href=\"https://profiles.wordpress.org/helgatheviking/\">HelgaTheViking</a> · <a href=\"https://profiles.wordpress.org/tejwanihemant/\">Hemant Tejwani</a> · <a href=\"https://profiles.wordpress.org/kurudrive/\">Hidekazu Ishikawa</a> · <a href=\"https://profiles.wordpress.org/panchalhimani711/\">Himani Panchal</a> · <a href=\"https://profiles.wordpress.org/hbhalodia/\">Hit Bhalodia</a> · <a href=\"https://profiles.wordpress.org/hiteshtalpada/\">Hitesh Talpada</a> · <a href=\"https://profiles.wordpress.org/h71/\">Hossein</a> · <a href=\"https://profiles.wordpress.org/howdy_mcgee/\">Howdy_McGee</a> · <a href=\"https://profiles.wordpress.org/hrrarya/\">Hridoy Mozumder</a> · <a href=\"https://profiles.wordpress.org/hrithikd/\">Hrithik Dalal</a> · <a href=\"https://profiles.wordpress.org/hlashbrooke/\">Hugh Lashbrooke</a> · <a href=\"https://profiles.wordpress.org/ganon/\">Hugo Chinchilla</a> · <a href=\"https://profiles.wordpress.org/hugod/\">hugod</a> · <a href=\"https://profiles.wordpress.org/huubl/\">huubl</a> · <a href=\"https://profiles.wordpress.org/huzaifaalmesbah/\">Huzaifa Al Mesbah</a> · <a href=\"https://profiles.wordpress.org/priethor/\">Héctor Prieto</a> · <a href=\"https://profiles.wordpress.org/ianbelanger/\">Ian Belanger</a> · <a href=\"https://profiles.wordpress.org/iandunn/\">Ian Dunn</a> · <a href=\"https://profiles.wordpress.org/idad5/\">idad5</a> · <a href=\"https://profiles.wordpress.org/igmoweb/\">Ignacio Cruz Moreno</a> · <a href=\"https://profiles.wordpress.org/ignatiusjeroe/\">ignatiusjeroe</a> · <a href=\"https://profiles.wordpress.org/shaampk1/\">Ihtisham Zahoor</a> · <a href=\"https://profiles.wordpress.org/fnpen/\">Ilya Zolotov</a> · <a href=\"https://profiles.wordpress.org/isabel_brison/\">Isabel Brison</a> · <a href=\"https://profiles.wordpress.org/iseulde/\">iseulde</a> · <a href=\"https://profiles.wordpress.org/itpathsolutions/\">IT Path Solutions</a> · <a href=\"https://profiles.wordpress.org/itecrs/\">itecrs</a> · <a href=\"https://profiles.wordpress.org/ivanzhuck/\">Ivan Zhuck</a> · <a href=\"https://profiles.wordpress.org/jacobcassidy/\">Jacob Cassidy</a> · <a href=\"https://profiles.wordpress.org/jadpm/\">jadpm</a> · <a href=\"https://profiles.wordpress.org/jamescollins/\">James Collins</a> · <a href=\"https://profiles.wordpress.org/macmanx/\">James Huff</a> · <a href=\"https://profiles.wordpress.org/jameskoster/\">James Koster</a> · <a href=\"https://profiles.wordpress.org/james roberts/\">James Roberts</a> · <a href=\"https://profiles.wordpress.org/jamieblomerus/\">Jamie Blomerus</a> · <a href=\"https://profiles.wordpress.org/perrelet/\">Jamie Perrelet</a> · <a href=\"https://profiles.wordpress.org/jane/\">jane</a> · <a href=\"https://profiles.wordpress.org/whiteshadow/\">Janis Elsts</a> · <a href=\"https://profiles.wordpress.org/jsandtro/\">jansan</a> · <a href=\"https://profiles.wordpress.org/janthiel/\">janthiel</a> · <a href=\"https://profiles.wordpress.org/japh/\">Japh</a> · <a href=\"https://profiles.wordpress.org/jsnajdr/\">Jarda Snajdr</a> · <a href=\"https://profiles.wordpress.org/jarednova/\">jarednova</a> · <a href=\"https://profiles.wordpress.org/jason_the_adams/\">Jason Adams</a> · <a href=\"https://profiles.wordpress.org/boogah/\">Jason Cosper</a> · <a href=\"https://profiles.wordpress.org/pbking/\">Jason Crist</a> · <a href=\"https://profiles.wordpress.org/coolmann/\">Jason Crouse</a> · <a href=\"https://profiles.wordpress.org/jsnjohnston/\">Jason Johnston</a> · <a href=\"https://profiles.wordpress.org/madtownlems/\">Jason LeMahieu (MadtownLems)</a> · <a href=\"https://profiles.wordpress.org/javiercasares/\">Javier Casares</a> · <a href=\"https://profiles.wordpress.org/jayadevankbh/\">Jayadevan k</a> · <a href=\"https://profiles.wordpress.org/jbobich/\">jbobich</a> · <a href=\"https://profiles.wordpress.org/audrasjb/\">Jean-Baptiste Audras</a> · <a href=\"https://profiles.wordpress.org/jffng/\">Jeff Ong</a> · <a href=\"https://profiles.wordpress.org/cheffheid/\">Jeffrey de Wit</a> · <a href=\"https://profiles.wordpress.org/jeffpaul/\">Jeffrey Paul</a> · <a href=\"https://profiles.wordpress.org/jdy68/\">Jenny Dupuy</a> · <a href=\"https://profiles.wordpress.org/jeremyfelt/\">Jeremy Felt</a> · <a href=\"https://profiles.wordpress.org/jeherve/\">Jeremy Herve</a> · <a href=\"https://profiles.wordpress.org/jeryj/\">jeryj</a> · <a href=\"https://profiles.wordpress.org/amieiro/\">Jesús Amieiro</a> · <a href=\"https://profiles.wordpress.org/luminuu/\">Jessica Lyschik</a> · <a href=\"https://profiles.wordpress.org/jghazally/\">jghazally</a> · <a href=\"https://profiles.wordpress.org/jipmoors/\">Jip Moors</a> · <a href=\"https://profiles.wordpress.org/jivygraphics/\">jivygraphics</a> · <a href=\"https://profiles.wordpress.org/jltallon/\">jltallon</a> · <a href=\"https://profiles.wordpress.org/joanrodas/\">Joan</a> · <a href=\"https://profiles.wordpress.org/morehawes/\">Joe</a> · <a href=\"https://profiles.wordpress.org/joedolson/\">Joe Dolson</a> · <a href=\"https://profiles.wordpress.org/joehoyle/\">Joe Hoyle</a> · <a href=\"https://profiles.wordpress.org/joemcgill/\">Joe McGill</a> · <a href=\"https://profiles.wordpress.org/joelcj91/\">Joel James</a> · <a href=\"https://profiles.wordpress.org/joen/\">Joen Asmussen</a> · <a href=\"https://profiles.wordpress.org/johnbillion/\">John Blackbourn</a> · <a href=\"https://profiles.wordpress.org/johnjamesjacoby/\">John James Jacoby</a> · <a href=\"https://profiles.wordpress.org/johnciacia/\">johnciacia</a> · <a href=\"https://profiles.wordpress.org/jb510/\">Jon Brown</a> · <a href=\"https://profiles.wordpress.org/duck_/\">Jon Cave</a> · <a href=\"https://profiles.wordpress.org/jonsurrell/\">Jon Surrell</a> · <a href=\"https://profiles.wordpress.org/psykro/\">Jonathan Bossenger</a> · <a href=\"https://profiles.wordpress.org/jbrinley/\">Jonathan Brinley</a> · <a href=\"https://profiles.wordpress.org/desrosj/\">Jonathan Desrosiers</a> · <a href=\"https://profiles.wordpress.org/spacedmonkey/\">Jonny Harris</a> · <a href=\"https://profiles.wordpress.org/joppuyo/\">joppuyo</a> · <a href=\"https://profiles.wordpress.org/jordesign/\">jordesign</a> · <a href=\"https://profiles.wordpress.org/jorgefilipecosta/\">Jorge Costa</a> · <a href=\"https://profiles.wordpress.org/jorgevilchez/\">Jorge Vilchez</a> · <a href=\"https://profiles.wordpress.org/jornp/\">jornp</a> · <a href=\"https://profiles.wordpress.org/joefusco/\">Joseph Fusco</a> · <a href=\"https://profiles.wordpress.org/chanthaboune/\">Josepha</a> · <a href=\"https://profiles.wordpress.org/joshcanhelp/\">joshcanhelp</a> · <a href=\"https://profiles.wordpress.org/verygoode/\">Joshua Goode</a> · <a href=\"https://profiles.wordpress.org/joshuatf/\">joshuatf</a> · <a href=\"https://profiles.wordpress.org/joyously/\">Joy</a> · <a href=\"https://profiles.wordpress.org/jrtashjian/\">JR Tashjian</a> · <a href=\"https://profiles.wordpress.org/jsmoriss/\">JS Morisset</a> · <a href=\"https://profiles.wordpress.org/juanfra/\">Juan Aldasoro</a> · <a href=\"https://profiles.wordpress.org/juanmaguitar/\">JuanMa Garrido</a> · <a href=\"https://profiles.wordpress.org/juhise/\">Juhi Saxena</a> · <a href=\"https://profiles.wordpress.org/jrf/\">Juliette Reinders Folmer</a> · <a href=\"https://profiles.wordpress.org/greenshady/\">Justin Tadlock</a> · <a href=\"https://profiles.wordpress.org/ashikur698/\">K M Ashikur Rahman</a> · <a href=\"https://profiles.wordpress.org/kadamwhite/\">K. Adam White</a> · <a href=\"https://profiles.wordpress.org/kafleg/\">KafleG</a> · <a href=\"https://profiles.wordpress.org/kevin940726/\">Kai Hao</a> · <a href=\"https://profiles.wordpress.org/bosskhj/\">Kamrul Hasan</a> · <a href=\"https://profiles.wordpress.org/karinclimber/\">Kari Anderson</a> · <a href=\"https://profiles.wordpress.org/karlijnbk/\">Karlijn Bok</a> · <a href=\"https://profiles.wordpress.org/karolmanijak/\">Karol Manijak</a> · <a href=\"https://profiles.wordpress.org/thekt12/\">Karthik Thayyil</a> · <a href=\"https://profiles.wordpress.org/tadamarketing/\">Katka</a> · <a href=\"https://profiles.wordpress.org/kawsaralameven/\">kawsaralameven</a> · <a href=\"https://profiles.wordpress.org/ryelle/\">Kelly Choyce-Dwan</a> · <a href=\"https://profiles.wordpress.org/kbat82/\">Kevin Batdorf</a> · <a href=\"https://profiles.wordpress.org/kevincoleman/\">Kevin Coleman</a> · <a href=\"https://profiles.wordpress.org/kevinwhoffman/\">Kevin Hoffman</a> · <a href=\"https://profiles.wordpress.org/ktaron/\">Kevin Taron</a> · <a href=\"https://profiles.wordpress.org/kharisblank/\">Kharis Sulistiyono</a> · <a href=\"https://profiles.wordpress.org/khokansardar/\">Khokan Sardar</a> · <a href=\"https://profiles.wordpress.org/kirasong/\">Kira Schroder</a> · <a href=\"https://profiles.wordpress.org/kishanjasani/\">Kishan Jasani</a> · <a href=\"https://profiles.wordpress.org/kitchin/\">kitchin</a> · <a href=\"https://profiles.wordpress.org/kjellr/\">Kjell Reigstad</a> · <a href=\"https://profiles.wordpress.org/kkmuffme/\">kkmuffme</a> · <a href=\"https://profiles.wordpress.org/knutsp/\">Knut Sparhell</a> · <a href=\"https://profiles.wordpress.org/koen12344/\">Koen Reus</a> · <a href=\"https://profiles.wordpress.org/koesper/\">Koesper</a> · <a href=\"https://profiles.wordpress.org/obenland/\">Konstantin Obenland</a> · <a href=\"https://profiles.wordpress.org/krupajnanda/\">Krupa Nanda</a> · <a href=\"https://profiles.wordpress.org/krupalpanchal/\">Krupal Panchal</a> · <a href=\"https://profiles.wordpress.org/kurtpayne/\">Kurt Payne</a> · <a href=\"https://profiles.wordpress.org/kushang78/\">Kushang Tailor</a> · <a href=\"https://profiles.wordpress.org/kdowns/\">Kylen Downs</a> · <a href=\"https://profiles.wordpress.org/laumindproductscomau/\">lau@mindproducts.com.au</a> · <a href=\"https://profiles.wordpress.org/lada7042/\">Laura Adamonis</a> · <a href=\"https://profiles.wordpress.org/laurlittle/\">Lauren Stein</a> · <a href=\"https://profiles.wordpress.org/wplmillet/\">Laurent MILLET</a> · <a href=\"https://profiles.wordpress.org/lakshmananphp/\">Lax Mariappan</a> · <a href=\"https://profiles.wordpress.org/0mirka00/\">Lena Morita</a> · <a href=\"https://profiles.wordpress.org/munizleo/\">Leo Muniz</a> · <a href=\"https://profiles.wordpress.org/leonnugraha/\">Leonardus Nugraha</a> · <a href=\"https://profiles.wordpress.org/lgladdy/\">Liam Gladdy</a> · <a href=\"https://profiles.wordpress.org/liammcarthur/\">LiamMcArthur</a> · <a href=\"https://profiles.wordpress.org/rudlinkon/\">Linkon Miyan</a> · <a href=\"https://profiles.wordpress.org/liviopv/\">liviopv</a> · <a href=\"https://profiles.wordpress.org/lkraav/\">lkraav</a> · <a href=\"https://profiles.wordpress.org/logikal16/\">logikal16</a> · <a href=\"https://profiles.wordpress.org/louiswol94/\">Louis Wolmarans</a> · <a href=\"https://profiles.wordpress.org/thelovekesh/\">Lovekesh Kumar</a> · <a href=\"https://profiles.wordpress.org/luboslives/\">luboslives</a> · <a href=\"https://profiles.wordpress.org/lucasbustamante/\">lucasbustamante</a> · <a href=\"https://profiles.wordpress.org/zaguiini/\">Luis Felipe Zaguini</a> · <a href=\"https://profiles.wordpress.org/luisherranz/\">Luis Herranz</a> · <a href=\"https://profiles.wordpress.org/lpawlik/\">Lukas Pawlik</a> · <a href=\"https://profiles.wordpress.org/wpfed/\">Lukasz</a> · <a href=\"https://profiles.wordpress.org/lukefiretoss/\">Luke Cavanagh</a> · <a href=\"https://profiles.wordpress.org/maartenbelmans/\">Maarten</a> · <a href=\"https://profiles.wordpress.org/madhudollu/\">Madhu Dollu</a> · <a href=\"https://profiles.wordpress.org/mrdollu/\">Madhu Dollu</a> · <a href=\"https://profiles.wordpress.org/onemaggie/\">Maggie Cabrera</a> · <a href=\"https://profiles.wordpress.org/mhimon/\">Mahbub Hasan Imon</a> · <a href=\"https://profiles.wordpress.org/mahnewr/\">mahnewr</a> · <a href=\"https://profiles.wordpress.org/maahrokh/\">Mahrokh</a> · <a href=\"https://profiles.wordpress.org/malae/\">Malae</a> · <a href=\"https://profiles.wordpress.org/manfcarlo/\">manfcarlo</a> · <a href=\"https://profiles.wordpress.org/manyourisms/\">manyourisms</a> · <a href=\"https://profiles.wordpress.org/marc_j/\">Marc_J</a> · <a href=\"https://profiles.wordpress.org/fullofcaffeine/\">Marcelo de Moraes Serpa</a> · <a href=\"https://profiles.wordpress.org/mciampini/\">Marco Ciampini</a> · <a href=\"https://profiles.wordpress.org/marcoevich/\">Marcoevich</a> · <a href=\"https://profiles.wordpress.org/margolisj/\">margolisj</a> · <a href=\"https://profiles.wordpress.org/chaton666/\">Marie Comet</a> · <a href=\"https://profiles.wordpress.org/tyxla/\">Marin Atanasov</a> · <a href=\"https://profiles.wordpress.org/santosguillamot/\">Mario Santos</a> · <a href=\"https://profiles.wordpress.org/clorith/\">Marius L. J.</a> · <a href=\"https://profiles.wordpress.org/markhowellsmead/\">Mark Howells-Mead</a> · <a href=\"https://profiles.wordpress.org/markjaquith/\">Mark Jaquith</a> · <a href=\"https://profiles.wordpress.org/markoheijnen/\">Marko Heijnen</a> · <a href=\"https://profiles.wordpress.org/markoserb/\">Marko Ivanovic</a> · <a href=\"https://profiles.wordpress.org/flootr/\">Markus</a> · <a href=\"https://profiles.wordpress.org/martinkrcho/\">martin.krcho</a> · <a href=\"https://profiles.wordpress.org/marybaum/\">Mary Baum</a> · <a href=\"https://profiles.wordpress.org/mathewemoore/\">mathewemoore</a> · <a href=\"https://profiles.wordpress.org/mmaattiiaass/\">Matias Benedetto</a> · <a href=\"https://profiles.wordpress.org/matveb/\">Matias Ventura</a> · <a href=\"https://profiles.wordpress.org/matiasrecondo77/\">matiasrecondo77</a> · <a href=\"https://profiles.wordpress.org/webdevmattcrom/\">Matt Cromwell</a> · <a href=\"https://profiles.wordpress.org/matt/\">Matt Mullenweg</a> · <a href=\"https://profiles.wordpress.org/matteoenna/\">Matteo Enna</a> · <a href=\"https://profiles.wordpress.org/cadic/\">Max Lyuchin</a> · <a href=\"https://profiles.wordpress.org/maxpertici/\">Maxime Pertici</a> · <a href=\"https://profiles.wordpress.org/mayur8991/\">Mayur Prajapati</a> · <a href=\"https://profiles.wordpress.org/hmbashar/\">Md Abul Bashar</a> · <a href=\"https://profiles.wordpress.org/mhshohel/\">Md Hossain Shohel</a> · <a href=\"https://profiles.wordpress.org/hrshahin/\">Md HR Shahin</a> · <a href=\"https://profiles.wordpress.org/devsahadat/\">Md Sahadat Husain</a> · <a href=\"https://profiles.wordpress.org/megphillips91/\">Meg Phillips</a> · <a href=\"https://profiles.wordpress.org/megane9988/\">megane9988</a> · <a href=\"https://profiles.wordpress.org/meher/\">Meher Bala</a> · <a href=\"https://profiles.wordpress.org/melchoyce/\">Mel Choyce-Dwan</a> · <a href=\"https://profiles.wordpress.org/melcarthus/\">melcarthus</a> · <a href=\"https://profiles.wordpress.org/meta4/\">meta4</a> · <a href=\"https://profiles.wordpress.org/metropolis_john/\">metropolis_john</a> · <a href=\"https://profiles.wordpress.org/254volkan/\">mevolkan</a> · <a href=\"https://profiles.wordpress.org/wpscholar/\">Micah Wood</a> · <a href=\"https://profiles.wordpress.org/mshowes/\">Michael Showes</a> · <a href=\"https://profiles.wordpress.org/czapla/\">Michal Czaplinski</a> · <a href=\"https://profiles.wordpress.org/michalooki/\">Michalooki</a> · <a href=\"https://profiles.wordpress.org/mcsf/\">Miguel Fonseca</a> · <a href=\"https://profiles.wordpress.org/miguelsansegundo/\">miguelsansegundo</a> · <a href=\"https://profiles.wordpress.org/miikkamakela/\">Miikka</a> · <a href=\"https://profiles.wordpress.org/mbijon/\">Mike Bijon</a> · <a href=\"https://profiles.wordpress.org/mikejolley/\">Mike Jolley (a11n)</a> · <a href=\"https://profiles.wordpress.org/mikeschinkel/\">Mike Schinkel</a> · <a href=\"https://profiles.wordpress.org/mikeschroder/\">Mike Schroder</a> · <a href=\"https://profiles.wordpress.org/mikinc860/\">Mikin Chauhan</a> · <a href=\"https://profiles.wordpress.org/gonzomir/\">Milen Petrinski – Gonzo</a> · <a href=\"https://profiles.wordpress.org/mimitips/\">mimi</a> · <a href=\"https://profiles.wordpress.org/illuminea/\">Miriam Schwab</a> · <a href=\"https://profiles.wordpress.org/mkismy/\">mkismy</a> · <a href=\"https://profiles.wordpress.org/mnydigital/\">mnydigital</a> · <a href=\"https://profiles.wordpress.org/batmoo/\">Mohammad Jangda</a> · <a href=\"https://profiles.wordpress.org/boemedia/\">Monique Dubbelman</a> · <a href=\"https://profiles.wordpress.org/monzuralam/\">Monzur Alam</a> · <a href=\"https://profiles.wordpress.org/man4toman/\">Morteza Geransayeh</a> · <a href=\"https://profiles.wordpress.org/mreishus/\">mreishus</a> · <a href=\"https://profiles.wordpress.org/mrwweb/\">mrwweb</a> · <a href=\"https://profiles.wordpress.org/seusmaniqbal/\">Muhammad Usman Iqbal</a> · <a href=\"https://profiles.wordpress.org/devmuhib/\">Muhibul Haque</a> · <a href=\"https://profiles.wordpress.org/mujuonly/\">mujuonly</a> · <a href=\"https://profiles.wordpress.org/mukesh27/\">Mukesh Panchal</a> · <a href=\"https://profiles.wordpress.org/faguni22/\">Mumtahina Faguni</a> · <a href=\"https://profiles.wordpress.org/tanjimtc71/\">Musarrat Anjum Chowdhury</a> · <a href=\"https://profiles.wordpress.org/nahidkhanseo/\">Nahid Khan</a> · <a href=\"https://profiles.wordpress.org/naoki0h/\">Naoki Ohashi</a> · <a href=\"https://profiles.wordpress.org/narenin/\">Narendra Sishodiya</a> · <a href=\"https://profiles.wordpress.org/nareshbheda/\">Naresh Bheda</a> · <a href=\"https://profiles.wordpress.org/nateallen/\">Nate Allen</a> · <a href=\"https://profiles.wordpress.org/navjotjsingh/\">Navjot Singh</a> · <a href=\"https://profiles.wordpress.org/nhrrob/\">Nazmul Hasan Robin</a> · <a href=\"https://profiles.wordpress.org/neffff/\">neffff</a> · <a href=\"https://profiles.wordpress.org/neilorangepeel/\">Neil Hainsworth</a> · <a href=\"https://profiles.wordpress.org/nendeb55/\">nendeb</a> · <a href=\"https://profiles.wordpress.org/nerdpressteam/\">NerdPress</a> · <a href=\"https://profiles.wordpress.org/ndiego/\">Nick Diego</a> · <a href=\"https://profiles.wordpress.org/celloexpressions/\">Nick Halsey</a> · <a href=\"https://profiles.wordpress.org/sessioncookiemonster/\">Nick Martianov</a> · <a href=\"https://profiles.wordpress.org/nickpagz/\">nickpagz</a> · <a href=\"https://profiles.wordpress.org/nico23/\">Nico</a> · <a href=\"https://profiles.wordpress.org/nicolefurlan/\">Nicole Furlan</a> · <a href=\"https://profiles.wordpress.org/bgnicolepaschen/\">Nicole Paschen Caylor</a> · <a href=\"https://profiles.wordpress.org/nidhidhandhukiya/\">nidhidhandhukiya</a> · <a href=\"https://profiles.wordpress.org/nielslange/\">Niels Lange</a> · <a href=\"https://profiles.wordpress.org/nihar007/\">Nihar Ranjan Das</a> · <a href=\"https://profiles.wordpress.org/ntsekouras/\">Nik Tsekouras</a> · <a href=\"https://profiles.wordpress.org/nko/\">Nikita</a> · <a href=\"https://profiles.wordpress.org/nikmeyer/\">nikmeyer</a> · <a href=\"https://profiles.wordpress.org/rabmalin/\">Nilambar Sharma</a> · <a href=\"https://profiles.wordpress.org/nilovelez/\">Nilo Velez</a> · <a href=\"https://profiles.wordpress.org/dhrupo/\">Niluthpal Purkayastha</a> · <a href=\"https://profiles.wordpress.org/niravsherasiya7707/\">Nirav Sherasiya</a> · <a href=\"https://profiles.wordpress.org/nithi22/\">Nithin John</a> · <a href=\"https://profiles.wordpress.org/nithins53/\">Nithin SreeRaj</a> · <a href=\"https://profiles.wordpress.org/noahtallen/\">Noah Allen</a> · <a href=\"https://profiles.wordpress.org/nosilver4u/\">nosilver4u</a> · <a href=\"https://profiles.wordpress.org/nvwd/\">Nowell VanHoesen</a> · <a href=\"https://profiles.wordpress.org/nudge/\">Nudge Themes</a> · <a href=\"https://profiles.wordpress.org/nwjames/\">nwjames</a> · <a href=\"https://profiles.wordpress.org/obliviousharmony/\">obliviousharmony</a> · <a href=\"https://profiles.wordpress.org/ockham/\">ockham</a> · <a href=\"https://profiles.wordpress.org/oguzkocer/\">oguzkocer</a> · <a href=\"https://profiles.wordpress.org/okat/\">okat</a> · <a href=\"https://profiles.wordpress.org/dargus/\">Old account</a> · <a href=\"https://profiles.wordpress.org/olegfuture/\">olegfuture</a> · <a href=\"https://profiles.wordpress.org/oglekler/\">Olga Gleckler</a> · <a href=\"https://profiles.wordpress.org/paaljoachim/\">Paal Joachim Romdahl</a> · <a href=\"https://profiles.wordpress.org/pablohoneyhoney/\">Pablo Honey</a> · <a href=\"https://profiles.wordpress.org/pacicio/\">Pacicio</a> · <a href=\"https://profiles.wordpress.org/pannelars/\">pannelars</a> · <a href=\"https://profiles.wordpress.org/partyfrikadelle/\">partyfrikadelle</a> · <a href=\"https://profiles.wordpress.org/swissspidy/\">Pascal Birchler</a> · <a href=\"https://profiles.wordpress.org/patricia70/\">Patricia BT</a> · <a href=\"https://profiles.wordpress.org/lumiblog/\">Patrick Lumumba</a> · <a href=\"https://profiles.wordpress.org/pbearne/\">Paul Bearne</a> · <a href=\"https://profiles.wordpress.org/pbiron/\">Paul Biron</a> · <a href=\"https://profiles.wordpress.org/pauldewouters/\">Paul de Wouters</a> · <a href=\"https://profiles.wordpress.org/paulkevan/\">Paul Kevan</a> · <a href=\"https://profiles.wordpress.org/djpaul/\">Paul Wong-Gibbs</a> · <a href=\"https://profiles.wordpress.org/pavelevap/\">pavelevap</a> · <a href=\"https://profiles.wordpress.org/pbaylies/\">Peter Baylies</a> · <a href=\"https://profiles.wordpress.org/provenself/\">Peter Rubin</a> · <a href=\"https://profiles.wordpress.org/westi/\">Peter Westwood</a> · <a href=\"https://profiles.wordpress.org/peterwilsoncc/\">Peter Wilson</a> · <a href=\"https://profiles.wordpress.org/petitphp/\">petitphp</a> · <a href=\"https://profiles.wordpress.org/tyrannous/\">Philipp Bammes</a> · <a href=\"https://profiles.wordpress.org/philipp15b/\">Philipp15b</a> · <a href=\"https://profiles.wordpress.org/phillsav/\">Phill</a> · <a href=\"https://profiles.wordpress.org/nekojonez/\">Pieterjan Deneys</a> · <a href=\"https://profiles.wordpress.org/mordauk/\">Pippin Williamson</a> · <a href=\"https://profiles.wordpress.org/pitamdey/\">Pitam Dey</a> · <a href=\"https://profiles.wordpress.org/pmeenan/\">pmeenan</a> · <a href=\"https://profiles.wordpress.org/webtechpooja/\">Pooja Derashri</a> · <a href=\"https://profiles.wordpress.org/pooja1210/\">Pooja N Muchandikar</a> · <a href=\"https://profiles.wordpress.org/pooja9712/\">pooja9712</a> · <a href=\"https://profiles.wordpress.org/pouicpouic/\">pouicpouic</a> · <a href=\"https://profiles.wordpress.org/pmbaldha/\">Prashant Baldha</a> · <a href=\"https://profiles.wordpress.org/pratikthink/\">Pratik Kumar</a> · <a href=\"https://profiles.wordpress.org/pratiklondhe/\">Pratik Londhe</a> · <a href=\"https://profiles.wordpress.org/freewebmentor/\">Prem Tiwari</a> · <a href=\"https://profiles.wordpress.org/presskopp/\">Presskopp</a> · <a href=\"https://profiles.wordpress.org/presstoke/\">presstoke</a> · <a href=\"https://profiles.wordpress.org/prionkor/\">prionkor</a> · <a href=\"https://profiles.wordpress.org/rafiq91/\">Rafiq</a> · <a href=\"https://profiles.wordpress.org/rajinsharwar/\">Rajin Sharwar</a> · <a href=\"https://profiles.wordpress.org/rahmohn/\">Ramon Ahnert</a> · <a href=\"https://profiles.wordpress.org/rcorrales/\">Ramon Corrales</a> · <a href=\"https://profiles.wordpress.org/ramonopoly/\">Ramon James</a> · <a href=\"https://profiles.wordpress.org/rashiguptaa/\">Rashi Gupta</a> · <a href=\"https://profiles.wordpress.org/ratneshsonar/\">Ratnesh Sonar</a> · <a href=\"https://profiles.wordpress.org/rawrly/\">rawrly</a> · <a href=\"https://profiles.wordpress.org/rcain/\">rcain</a> · <a href=\"https://profiles.wordpress.org/rebasaurus/\">rebasaurus</a> · <a href=\"https://profiles.wordpress.org/tabrisrp/\">Remy Perona</a> · <a href=\"https://profiles.wordpress.org/renathoc/\">Renatho (a11n)</a> · <a href=\"https://profiles.wordpress.org/renehermi/\">Rene Hermenau</a> · <a href=\"https://profiles.wordpress.org/retrofox/\">retrofox</a> · <a href=\"https://profiles.wordpress.org/youknowriad/\">Riad Benguella</a> · <a href=\"https://profiles.wordpress.org/rdcoll/\">Rich Collier</a> · <a href=\"https://profiles.wordpress.org/richtabor/\">Rich Tabor</a> · <a href=\"https://profiles.wordpress.org/rcreators/\">Rishi Mehta</a> · <a href=\"https://profiles.wordpress.org/rishishah/\">Rishi Shah</a> · <a href=\"https://profiles.wordpress.org/noisysocks/\">Robert Anderson</a> · <a href=\"https://profiles.wordpress.org/ravanh/\">Rolf Allard van Hagen</a> · <a href=\"https://profiles.wordpress.org/room34/\">room34</a> · <a href=\"https://profiles.wordpress.org/roytanck/\">Roy Tanck</a> · <a href=\"https://profiles.wordpress.org/ryan/\">Ryan Boren</a> · <a href=\"https://profiles.wordpress.org/rmccue/\">Ryan McCue</a> · <a href=\"https://profiles.wordpress.org/welcher/\">Ryan Welcher</a> · <a href=\"https://profiles.wordpress.org/pogidude/\">Ryann Micua</a> · <a href=\"https://profiles.wordpress.org/looswebstudio/\">Ryo</a> · <a href=\"https://profiles.wordpress.org/sereedmedia/\">Sé Reed</a> · <a href=\"https://profiles.wordpress.org/sebastienserre/\">Sébastien SERRE</a> · <a href=\"https://profiles.wordpress.org/soean/\">Sören Wünsch</a> · <a href=\"https://profiles.wordpress.org/sabbirshouvo/\">Sabbir Hasan</a> · <a href=\"https://profiles.wordpress.org/sachyya-sachet/\">Sachyya</a> · <a href=\"https://profiles.wordpress.org/sadizaman/\">Sadi Mohammad Zaman</a> · <a href=\"https://profiles.wordpress.org/sadpencil/\">sadpencil</a> · <a href=\"https://profiles.wordpress.org/introvertedbot/\">Sahil</a> · <a href=\"https://profiles.wordpress.org/tohincoderex/\">Saiduzzaman Tohin</a> · <a href=\"https://profiles.wordpress.org/sakibsnaz/\">Sakib MD Nazmush</a> · <a href=\"https://profiles.wordpress.org/salcode/\">Sal Ferrarello</a> · <a href=\"https://profiles.wordpress.org/xronn/\">Sam Berry</a> · <a href=\"https://profiles.wordpress.org/samba45/\">samba45</a> · <a href=\"https://profiles.wordpress.org/viralsampat/\">Sampat Viral</a> · <a href=\"https://profiles.wordpress.org/kim88/\">Samuel Rüegger</a> · <a href=\"https://profiles.wordpress.org/samuelsidler/\">Samuel Sidler</a> · <a href=\"https://profiles.wordpress.org/otto42/\">Samuel Wood (Otto)</a> · <a href=\"https://profiles.wordpress.org/sacerro/\">Santiago Cerro López</a> · <a href=\"https://profiles.wordpress.org/mikachan/\">Sarah Norris</a> · <a href=\"https://profiles.wordpress.org/sarathar/\">Sarath AR</a> · <a href=\"https://profiles.wordpress.org/satishprajapati/\">Satish Prajapati</a> · <a href=\"https://profiles.wordpress.org/hellosatya/\">Satyam Vishwakarma (Satya)</a> · <a href=\"https://profiles.wordpress.org/saxonafletcher/\">Saxon Fletcher</a> · <a href=\"https://profiles.wordpress.org/saxonfletcher/\">Saxon Fletcher</a> · <a href=\"https://profiles.wordpress.org/sayful/\">Sayful Islam</a> · <a href=\"https://profiles.wordpress.org/sc0ttkclark/\">Scott Kingsley Clark</a> · <a href=\"https://profiles.wordpress.org/coffee2code/\">Scott Reilly</a> · <a href=\"https://profiles.wordpress.org/wonderboymusic/\">Scott Taylor</a> · <a href=\"https://profiles.wordpress.org/scribu/\">scribu</a> · <a href=\"https://profiles.wordpress.org/sean212/\">Sean Fisher</a> · <a href=\"https://profiles.wordpress.org/sergeybiryukov/\">Sergey Biryukov</a> · <a href=\"https://profiles.wordpress.org/sgr33n/\">Sergio De Falco</a> · <a href=\"https://profiles.wordpress.org/smrubenstein/\">Seth Rubenstein</a> · <a href=\"https://profiles.wordpress.org/shahariaazam/\">Shaharia Azam</a> · <a href=\"https://profiles.wordpress.org/shailu25/\">Shail Mehta</a> · <a href=\"https://profiles.wordpress.org/shanef/\">ShaneF</a> · <a href=\"https://profiles.wordpress.org/cafenoirdesign/\">Shannon Smith</a> · <a href=\"https://profiles.wordpress.org/shaunandrews/\">shaunandrews</a> · <a href=\"https://profiles.wordpress.org/shooper/\">Shawn Hooper</a> · <a href=\"https://profiles.wordpress.org/shidouhikari/\">shidouhikari</a> · <a href=\"https://profiles.wordpress.org/shiponkarmakar/\">Shipon Karmakar</a> · <a href=\"https://profiles.wordpress.org/shreyash3087/\">Shreyash Srivastava</a> · <a href=\"https://profiles.wordpress.org/shubhamsedani/\">Shubham Sedani</a> · <a href=\"https://profiles.wordpress.org/rsiddharth/\">siddharth ravikumar</a> · <a href=\"https://profiles.wordpress.org/siobhyb/\">Siobhan</a> · <a href=\"https://profiles.wordpress.org/sirajummahdi/\">Sirajum Mahdi</a> · <a href=\"https://profiles.wordpress.org/sjregan/\">sjregan</a> · <a href=\"https://profiles.wordpress.org/virtality-marketing-solutions/\">SourceView</a> · <a href=\"https://profiles.wordpress.org/sruthi89/\">sruthi89</a> · <a href=\"https://profiles.wordpress.org/stacimc/\">stacimc</a> · <a href=\"https://profiles.wordpress.org/ryokuhi/\">Stefano Minoia</a> · <a href=\"https://profiles.wordpress.org/sabernhardt/\">Stephen Bernhardt</a> · <a href=\"https://profiles.wordpress.org/stephencronin/\">Stephen Cronin</a> · <a href=\"https://profiles.wordpress.org/netweb/\">Stephen Edgar</a> · <a href=\"https://profiles.wordpress.org/stephenh1988/\">Stephen Harris</a> · <a href=\"https://profiles.wordpress.org/stevejonesdev/\">Steve Jones</a> · <a href=\"https://profiles.wordpress.org/stevenlinx/\">Steven Lin</a> · <a href=\"https://profiles.wordpress.org/strarsis/\">strarsis</a> · <a href=\"https://profiles.wordpress.org/subrataemfluence/\">Subrata Sarkar</a> · <a href=\"https://profiles.wordpress.org/sumisubedi/\">Sumi Subedi</a> · <a href=\"https://profiles.wordpress.org/sumitbagthariya16/\">Sumit Bagthariya</a> · <a href=\"https://profiles.wordpress.org/sumitsingh/\">Sumit Singh</a> · <a href=\"https://profiles.wordpress.org/sunil25393/\">SunilPrajapati</a> · <a href=\"https://profiles.wordpress.org/svitlana41319/\">Svitlana Sukhoveiko</a> · <a href=\"https://profiles.wordpress.org/syamraj24/\">syamraj24</a> · <a href=\"https://profiles.wordpress.org/cybr/\">Sybre Waaijer</a> · <a href=\"https://profiles.wordpress.org/smub/\">Syed Balkhi</a> · <a href=\"https://profiles.wordpress.org/nuhel/\">Syed Nuhel</a> · <a href=\"https://profiles.wordpress.org/synchro/\">Synchro</a> · <a href=\"https://profiles.wordpress.org/iamtakashi/\">Takashi Irie</a> · <a href=\"https://profiles.wordpress.org/inc2734/\">Takashi Kitajima</a> · <a href=\"https://profiles.wordpress.org/karmatosed/\">Tammie Lister</a> · <a href=\"https://profiles.wordpress.org/voboghure/\">Tapan Kumer Das</a> · <a href=\"https://profiles.wordpress.org/sparklingrobots/\">Tara King</a> · <a href=\"https://profiles.wordpress.org/buley/\">Taylor</a> · <a href=\"https://profiles.wordpress.org/taylorde/\">Taylor Dewey</a> · <a href=\"https://profiles.wordpress.org/taylorgorman/\">Taylor Gorman</a> · <a href=\"https://profiles.wordpress.org/tazotodua/\">tazotodua</a> · <a href=\"https://profiles.wordpress.org/tykoted/\">Teddy Patriarca</a> · <a href=\"https://profiles.wordpress.org/tellyworth/\">Tellyworth</a> · <a href=\"https://profiles.wordpress.org/thakordarshil/\">Thakor Darshil</a> · <a href=\"https://profiles.wordpress.org/themes-1/\">them.es</a> · <a href=\"https://profiles.wordpress.org/thinkluke/\">thinkluke</a> · <a href=\"https://profiles.wordpress.org/griffinjt/\">Thomas Griffin</a> · <a href=\"https://profiles.wordpress.org/kraftner/\">Thomas Kräftner</a> · <a href=\"https://profiles.wordpress.org/threadi/\">threadi</a> · <a href=\"https://profiles.wordpress.org/tnolte/\">Tim Nolte</a> · <a href=\"https://profiles.wordpress.org/timbroddin/\">timbroddin</a> · <a href=\"https://profiles.wordpress.org/spaceshipone/\">Timothée Brosille</a> · <a href=\"https://profiles.wordpress.org/timothyblynjacobs/\">Timothy Jacobs</a> · <a href=\"https://profiles.wordpress.org/tmatsuur/\">tmatsuur</a> · <a href=\"https://profiles.wordpress.org/tobiasbg/\">TobiasBg</a> · <a href=\"https://profiles.wordpress.org/tobifjellner/\">tobifjellner (Tor-Bjorn Fjellner)</a> · <a href=\"https://profiles.wordpress.org/tomybyte/\">Tom</a> · <a href=\"https://profiles.wordpress.org/tomjcafferkey/\">Tom Cafferkey</a> · <a href=\"https://profiles.wordpress.org/hifidesign/\">Tom Finley</a> · <a href=\"https://profiles.wordpress.org/tjnowell/\">Tom J Nowell</a> · <a href=\"https://profiles.wordpress.org/tomluckies/\">tomluckies</a> · <a href=\"https://profiles.wordpress.org/shimotomoki/\">Tomoki Shimomura</a> · <a href=\"https://profiles.wordpress.org/tomsommer/\">tomsommer</a> · <a href=\"https://profiles.wordpress.org/tomxygen/\">tomxygen</a> · <a href=\"https://profiles.wordpress.org/skithund/\">Toni Viemerö</a> · <a href=\"https://profiles.wordpress.org/starbuck/\">Tony G</a> · <a href=\"https://profiles.wordpress.org/hellofromtonya/\">Tonya Mork</a> · <a href=\"https://profiles.wordpress.org/toro_unit/\">Toro_Unit (Hiroshi Urabe)</a> · <a href=\"https://profiles.wordpress.org/torres126/\">torres126</a> · <a href=\"https://profiles.wordpress.org/zodiac1978/\">Torsten Landsiedel</a> · <a href=\"https://profiles.wordpress.org/toru/\">Toru Miki</a> · <a href=\"https://profiles.wordpress.org/toscho/\">toscho</a> · <a href=\"https://profiles.wordpress.org/wpsmith/\">Travis Smith</a> · <a href=\"https://profiles.wordpress.org/tropicalista/\">tropicalista</a> · <a href=\"https://profiles.wordpress.org/truptikanzariya/\">Trupti Kanzariya</a> · <a href=\"https://profiles.wordpress.org/ugyensupport/\">Ugyen Dorji</a> · <a href=\"https://profiles.wordpress.org/up1512001/\">up1512001</a> · <a href=\"https://profiles.wordpress.org/upadalavipul/\">upadalavipul</a> · <a href=\"https://profiles.wordpress.org/utsav72640/\">Utsav tilava</a> · <a href=\"https://profiles.wordpress.org/ukdrahul/\">Uttam Kumar Dash</a> · <a href=\"https://profiles.wordpress.org/eboxnet/\">Vagelis</a> · <a href=\"https://profiles.wordpress.org/valerogarte/\">valerogarte</a> · <a href=\"https://profiles.wordpress.org/vcanales/\">Vicente Canales</a> · <a href=\"https://profiles.wordpress.org/gvgvgvijayan/\">Vijayan</a> · <a href=\"https://profiles.wordpress.org/vikram6/\">vikram6</a> · <a href=\"https://profiles.wordpress.org/viliamkopecky/\">viliamkopecky</a> · <a href=\"https://profiles.wordpress.org/vipuljnext/\">Vipul Ghori</a> · <a href=\"https://profiles.wordpress.org/vivekawsm/\">vivekawsm</a> · <a href=\"https://profiles.wordpress.org/vladimiraus/\">vladimiraus</a> · <a href=\"https://profiles.wordpress.org/vortfu/\">vortfu</a> · <a href=\"https://profiles.wordpress.org/vrajadas/\">Vraja Das</a> · <a href=\"https://profiles.wordpress.org/wasiur195/\">Wasiur Rahman</a> · <a href=\"https://profiles.wordpress.org/welaunchio/\">welaunchio</a> · <a href=\"https://profiles.wordpress.org/westonruter/\">Weston Ruter</a> · <a href=\"https://profiles.wordpress.org/whsajid/\">WHSajid</a> · <a href=\"https://profiles.wordpress.org/nestea29950/\">WilliamG</a> · <a href=\"https://profiles.wordpress.org/wpcorner/\">WP Corner</a> · <a href=\"https://profiles.wordpress.org/xlthlx/\">xlthlx</a> · <a href=\"https://profiles.wordpress.org/yansern/\">Yan Sern</a> · <a href=\"https://profiles.wordpress.org/yguyon/\">Yannis Guyon</a> · <a href=\"https://profiles.wordpress.org/fierevere/\">Yui</a> · <a href=\"https://profiles.wordpress.org/yuliyan/\">Yuliyan Slavchev</a> · <a href=\"https://profiles.wordpress.org/yuvrajsinh2211/\">Yuvrajsinh Sisodiya</a> · <a href=\"https://profiles.wordpress.org/tollmanz/\">Zack Tollman</a> · <a href=\"https://profiles.wordpress.org/zanematthew/\">Zane Matthew</a> · <a href=\"https://profiles.wordpress.org/zebaafiashama/\">Zeba Afia Shama</a> · <a href=\"https://profiles.wordpress.org/zieladam/\">zieladam</a> · <a href=\"https://profiles.wordpress.org/zunaid321/\">Zunaid Amin</a> · <a href=\"https://profiles.wordpress.org/chesio/\">Česlav Przywara</a></p>\n\n\n\n<h1 class=\"wp-block-heading\">Merci aux personnes ayant contribué à traduire WordPress 6.6 en français</h1>\n\n\n\n<p>WordPress est un projet international et la version 6.6 est déjà complètement disponible dans plus de 70 langues différentes.</p>\n\n\n\n<p>Nous souhaitons remercier ici les personnes ayant participé à la traduction de WordPress 6.6 en français :</p>\n\n\n\n<p><a href=\"https://profiles.wordpress.org/jdy68\">Jenny Dupuy</a>, <a href=\"https://profiles.wordpress.org/wolforg\">Didier Demory</a>, <a href=\"https://profiles.wordpress.org/fxbenard\">fxbenard</a>, <a href=\"https://profiles.wordpress.org/audrasjb\">Jb Audras</a>, <a href=\"https://profiles.wordpress.org/amebref\">amebref</a>, <a href=\"https://profiles.wordpress.org/beryldlg\">Béryl de La Grandière</a>, <a href=\"https://profiles.wordpress.org/bonaldi\">Bonaldi</a>, <a href=\"https://profiles.wordpress.org/chris-kns\">chris-kns</a>, <a href=\"https://profiles.wordpress.org/clementpolito\">Clément Polito</a>, <a href=\"https://profiles.wordpress.org/coralietixeront\">coralietixeront</a>, <a href=\"https://profiles.wordpress.org/eddystile\">Eddy</a>, <a href=\"https://profiles.wordpress.org/emlebrun\">Emilie LEBRUN</a>, <a href=\"https://profiles.wordpress.org/scoco\">Emilien M.</a>, <a href=\"https://profiles.wordpress.org/florientinneo\">Florient DELAFOY</a>, <a href=\"https://profiles.wordpress.org/gaeldenysiak\">Gael Denysiak</a>, <a href=\"https://profiles.wordpress.org/gaellebesson\">gaellebesson</a>, <a href=\"https://profiles.wordpress.org/karine-wendling\">karine wendling</a>, <a href=\"https://profiles.wordpress.org/laeti972\">laeti972</a>, <a href=\"https://profiles.wordpress.org/wplmillet\">Laurent MILLET</a>, <a href=\"https://profiles.wordpress.org/nuryko\">Marianna</a>, <a href=\"https://profiles.wordpress.org/marineevain\">Marine EVAIN</a>, <a href=\"https://profiles.wordpress.org/lymx\">Maxime LEROY</a>, <a href=\"https://profiles.wordpress.org/momo-fr\">momo-fr</a>, <a href=\"https://profiles.wordpress.org/nlangle\">Nicolas Langle</a>, <a href=\"https://profiles.wordpress.org/mrbalou06\">Pascal T</a>, <a href=\"https://profiles.wordpress.org/pierrelannoy\">Pierre Lannoy</a>, <a href=\"https://profiles.wordpress.org/nekojonez\">Pieterjan Deneys</a>, <a href=\"https://profiles.wordpress.org/larrach\">Rachel Peter</a>, <a href=\"https://profiles.wordpress.org/sebastienserre\">Sébastien SERRE</a>, <a href=\"https://profiles.wordpress.org/spaceshipone\">Timothée Brosille</a>, <a href=\"https://profiles.wordpress.org/valer1e\">Valérie Galassi</a>, <a href=\"https://profiles.wordpress.org/virgar\">Virginie Garnier</a>, et <a href=\"https://profiles.wordpress.org/whaze\">whaze</a>.</p>\n\n\n\n<p></p>\n\n\n\n<p></p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:30:\"com-wordpress:feed-additions:1\";a:1:{s:7:\"post-id\";a:1:{i:0;a:5:{s:4:\"data\";s:4:\"3181\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:8;a:6:{s:4:\"data\";s:57:\"\n		\n		\n		\n		\n		\n				\n		\n\n					\n										\n					\n		\n		\n			\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:4:{s:0:\"\";a:6:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:82:\"Comment contribuer aux « release parties » des nouvelles versions de WordPress\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:111:\"https://fr.wordpress.org/2024/07/15/comment-contribuer-aux-release-parties-des-nouvelles-versions-de-wordpress/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Mon, 15 Jul 2024 13:28:06 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:1:{i:0;a:5:{s:4:\"data\";s:10:\"Contribuer\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:32:\"https://fr.wordpress.org/?p=3159\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:383:\"Lors des phases de développement d’une nouvelle version de WordPress, il est possible d’aider à la livraison des versions bêta et release candidate de WP en participant aux « release parties », qui sont des événements planifiés à l’avance pour procéder à la construction d’une version bêta ou release candidate, ou d&#8217;une version finale, et à sa [&#8230;]\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:9:\"Jb Audras\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:7155:\"\n<p>Lors des phases de développement d’une nouvelle version de WordPress, il est possible d’aider à la livraison des versions bêta et <em><bdo lang=\"en\" dir=\"ltr\">release candidate</bdo></em> de WP en participant aux <em><bdo lang=\"en\" dir=\"ltr\">« release parties »</bdo></em>, qui sont des événements planifiés à l’avance pour procéder à la construction d’une version bêta ou release candidate, ou d&rsquo;une version finale, et à sa livraison au public.</p>\n\n\n\n<h2 class=\"wp-block-heading\">Prérequis</h2>\n\n\n\n<ul class=\"wp-block-list\">\n<li>Aucun niveau technique particulier n’est nécessaire à part savoir utiliser WordPress</li>\n\n\n\n<li>Avoir un site de test installé en local ou en ligne</li>\n\n\n\n<li>Installer l’extension <em><bdo lang=\"en\" dir=\"ltr\"><a href=\"https://fr.wordpress.org/plugins/wordpress-beta-tester/\">Beta Tester</a></bdo></em> et la paramétrer (dans <code>Outils &gt; Test Bêta</code>) de la façon suivante (ici nous sommes sur une installation en anglais, si vous êtes sur une installation en français, faites la correspondance des options)&nbsp;:</li>\n</ul>\n\n\n\n<figure class=\"wp-block-image size-large\"><a href=\"https://fr.wordpress.org/files/2024/07/reglages-beta-tester.png\"><img loading=\"lazy\" decoding=\"async\" width=\"1024\" height=\"427\" src=\"https://fr.wordpress.org/files/2024/07/reglages-beta-tester-1024x427.png\" alt=\"\" class=\"wp-image-3160\" srcset=\"https://fr.wordpress.org/files/2024/07/reglages-beta-tester-1024x427.png 1024w, https://fr.wordpress.org/files/2024/07/reglages-beta-tester-300x125.png 300w, https://fr.wordpress.org/files/2024/07/reglages-beta-tester-768x320.png 768w, https://fr.wordpress.org/files/2024/07/reglages-beta-tester-1536x641.png 1536w, https://fr.wordpress.org/files/2024/07/reglages-beta-tester-2048x854.png 2048w\" sizes=\"auto, (max-width: 1024px) 100vw, 1024px\" /></a></figure>\n\n\n\n<p><em><bdo lang=\"en\" dir=\"ltr\">Bleeding edge</bdo></em> : version en cours de développement. Cette version utilise le code en cours de développement (<em><bdo lang=\"en\" dir=\"ltr\">Bleeding edge nightlies</bdo></em>) qui peut parfois être instable. <em>Ne l’utilisez en production que si vous savez vraiment ce que vous faites</em>.</p>\n\n\n\n<p><em><bdo lang=\"en\" dir=\"ltr\">Bêta/RC only </bdo></em>: ceci concerne uniquement les versions bêta/RC du canal sélectionné.</p>\n\n\n\n<h2 class=\"wp-block-heading\">Déroulement de la <em><bdo lang=\"en\" dir=\"ltr\">release party</bdo></em></h2>\n\n\n\n<p>Les <em><bdo lang=\"en\" dir=\"ltr\">release parties</bdo></em> se déroulent entièrement sur le Slack <a href=\"http://Make.WordPress.org\">Make.WordPress.org</a>, sur le canal #core. Pour le rejoindre utilisez votre nom de compte WordPress.org, ici : <a href=\"https://make.wordpress.org/chat/\">https://make.wordpress.org/chat/</a>.</p>\n\n\n\n<p>Généralement, il y en a pour 30-40 minutes si c’est une version beta/RC.</p>\n\n\n\n<p>Normalement les <em><bdo lang=\"en\" dir=\"ltr\">release parties</bdo></em> commencent à peu près à l’heure, souvent en fin d’après midi. Voici le déroulement :</p>\n\n\n\n<ul class=\"wp-block-list\">\n<li>Message d’accueil de la personne qui dirige la <bdo lang=\"en\" dir=\"ltr\"><em>release party</em></bdo>, tout le monde fait coucou et ça permet de consigner le nombre de contributrices et contributeurs qui participent à la <em><bdo lang=\"en\" dir=\"ltr\">release</bdo></em></li>\n\n\n\n<li>Quelques<bdo lang=\"en\" dir=\"ltr\"> vérificatio</bdo>ns techniques entre le ou la <em><bdo lang=\"en\" dir=\"ltr\">lead</bdo></em>, la personne faisant office de <em><bdo lang=\"en\" dir=\"ltr\">committer</bdo></em> (qui va créer la version de WordPress concernée) et le contrôle de mission (<em><bdo lang=\"en\" dir=\"ltr\">mission control</bdo></em>, qui est chargé de construire le paquet ZIP de la version), ça peut prendre 10-15 minutes mais c’est souvent moins.</li>\n\n\n\n<li>Les checks de sécurité et les tests unitaires sont lancés par la personne chargée des <em><bdo lang=\"en\" dir=\"ltr\">commits</bdo></em> et le contrôle de mission</li>\n\n\n\n<li>Le ou la <em><bdo lang=\"en\" dir=\"ltr\">core committer</bdo></em> fait un premier <bdo lang=\"en\" dir=\"ltr\"><em>commit</em></bdo> de version</li>\n\n\n\n<li>Le contrôle de mission livre un premier ZIP de la version</li>\n\n\n\n<li>C’EST LÀ QUE VOUS INTERVENEZ ! Vous pouvez&nbsp;:\n<ul class=\"wp-block-list\">\n<li>(plus long) Récupérer le ZIP et l’installer en local</li>\n\n\n\n<li>(plus rapide mais plus technique) Installer la version via <em>WP-CLI</em></li>\n\n\n\n<li>(recommandé) Via Beta Tester :\n<ul class=\"wp-block-list\">\n<li>Aller sur une installation avec l’extension WP Beta Tester installée, paramétrée comme expliqué ci-dessus</li>\n\n\n\n<li>Normalement, au bout de quelques secondes après que le ZIP soit disponible, vous devriez voir un petit message sur l’écran d’accueil de l’admin indiquant qu’une nouvelle version est disponible pour test</li>\n\n\n\n<li>Pensez à noter le numéro de version de WP que vous aviez avant de mettre à jour !</li>\n\n\n\n<li>Cliquez sur le lien de mise à jour et installez la version</li>\n</ul>\n</li>\n</ul>\n</li>\n\n\n\n<li>Les choses que vous pouvez tester :\n<ul class=\"wp-block-list\">\n<li>Fonctionnement de quelques écrans de l’admin</li>\n\n\n\n<li>Bon fonctionnement de l’éditeur : insertion d’un bloc, enregistrement d’un article</li>\n\n\n\n<li>Bon fonctionnement de l’éditeur de site (navigation dans quelques écrans)</li>\n\n\n\n<li>Bon fonctionnement de quelques écrans du front</li>\n\n\n\n<li>Bon fonctionnement de l&rsquo;éditeur après installation d&rsquo;un thème classique</li>\n\n\n\n<li>Bon fonctionnement de l&rsquo;éditeur après installation de l&rsquo;extension <em><bdo lang=\"en\" dir=\"ltr\"><a href=\"https://fr.wordpress.org/plugins/classic-editor/\">Classic Editor</a></bdo></em></li>\n\n\n\n<li>Si vous disposez d&rsquo;une instance multisite, mentionnez-le</li>\n\n\n\n<li>Si vous avez les moyens de tester la mise à jour depuis une vieille version de WP (version 4.9 ou au dessus), c&rsquo;est très utile aussi. Mentionnez la version depuis laquelle vous avez fait la mise à jour</li>\n</ul>\n</li>\n\n\n\n<li>Une fois que vous avez testé, mettez un petit message dans le canal #core, en indiquant la version que vous aviez avant la <abbr title=\"Mise à jour\">MAJ</abbr> et la version vers laquelle vous avez mis à jour. Par exemple :</li>\n</ul>\n\n\n\n<figure class=\"wp-block-image size-full is-resized\"><a href=\"https://fr.wordpress.org/files/2024/07/Capture-decran-2024-03-05-a-10.42.10.png\"><img loading=\"lazy\" decoding=\"async\" width=\"706\" height=\"806\" src=\"https://fr.wordpress.org/files/2024/07/Capture-decran-2024-03-05-a-10.42.10.png\" alt=\"\" class=\"wp-image-3161\" style=\"width:400px\" srcset=\"https://fr.wordpress.org/files/2024/07/Capture-decran-2024-03-05-a-10.42.10.png 706w, https://fr.wordpress.org/files/2024/07/Capture-decran-2024-03-05-a-10.42.10-263x300.png 263w\" sizes=\"auto, (max-width: 706px) 100vw, 706px\" /></a></figure>\n\n\n\n<p>Vous pourrez ensuite suivre le reste de la <em><bdo lang=\"en\" dir=\"ltr\">release party</bdo></em> tranquillement.</p>\n\n\n\n<p>Et vous serez aussi crédité·es pour votre participation à cette version. Bravo&nbsp;!</p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:30:\"com-wordpress:feed-additions:1\";a:1:{s:7:\"post-id\";a:1:{i:0;a:5:{s:4:\"data\";s:4:\"3159\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:9;a:6:{s:4:\"data\";s:60:\"\n		\n		\n		\n		\n		\n				\n		\n		\n\n					\n										\n					\n		\n		\n			\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:4:{s:0:\"\";a:6:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:50:\"Guide des changements techniques de WordPress 6.6\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:86:\"https://fr.wordpress.org/2024/06/27/guide-des-changements-techniques-de-wordpress-6-6/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 27 Jun 2024 08:36:35 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:2:{i:0;a:5:{s:4:\"data\";s:5:\"Guide\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:1;a:5:{s:4:\"data\";s:31:\"Nouvelles versions de WordPress\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:32:\"https://fr.wordpress.org/?p=3125\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:140:\"Ce guide décrit les principaux changements techniques que vous trouverez sur WordPress 6.6, dont la sortie est prévue le 16 juillet 2024.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:9:\"Jb Audras\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:33232:\"\n<figure class=\"wp-block-image alignfull size-large\"><a href=\"https://fr.wordpress.org/files/2024/06/WP-66-guide-changements-techniques-min.png\"><img loading=\"lazy\" decoding=\"async\" width=\"1024\" height=\"548\" src=\"https://fr.wordpress.org/files/2024/06/WP-66-guide-changements-techniques-min-1024x548.png\" alt=\"\" class=\"wp-image-3134\" srcset=\"https://fr.wordpress.org/files/2024/06/WP-66-guide-changements-techniques-min-1024x548.png 1024w, https://fr.wordpress.org/files/2024/06/WP-66-guide-changements-techniques-min-300x160.png 300w, https://fr.wordpress.org/files/2024/06/WP-66-guide-changements-techniques-min-768x411.png 768w, https://fr.wordpress.org/files/2024/06/WP-66-guide-changements-techniques-min-1536x821.png 1536w, https://fr.wordpress.org/files/2024/06/WP-66-guide-changements-techniques-min-2048x1095.png 2048w\" sizes=\"auto, (max-width: 1024px) 100vw, 1024px\" /></a></figure>\n\n\n\n<p class=\"is-style-serif has-blueberry-4-background-color has-background\">Ce guide décrit les principaux changements techniques que vous trouverez sur WordPress&nbsp;6.6, dont la sortie est prévue le 16 juillet 2024.</p>\n\n\n\n<p>WordPress 6.6 comprend au minimum la résolution de <a href=\"https://core.trac.wordpress.org/query?resolution=fixed&amp;milestone=6.6&amp;group=component&amp;col=id&amp;col=summary&amp;col=type&amp;order=type\" target=\"_blank\" rel=\"noreferrer noopener\">299 tickets Trac</a>, dont <a href=\"https://core.trac.wordpress.org/query?status=closed&amp;type=enhancement&amp;type=feature+request&amp;milestone=6.6&amp;max=500&amp;col=id&amp;col=summary&amp;col=type&amp;col=status&amp;col=milestone&amp;col=owner&amp;col=priority&amp;order=priority\" target=\"_blank\" rel=\"noreferrer noopener\">108 améliorations et nouvelles fonctionnalités</a>, <a href=\"https://core.trac.wordpress.org/query?status=closed&amp;type=defect+(bug)&amp;milestone=6.5&amp;max=500&amp;col=id&amp;col=summary&amp;col=type&amp;col=status&amp;col=milestone&amp;col=owner&amp;col=priority&amp;order=priority\" target=\"_blank\" rel=\"noreferrer noopener\">171 résolutions de bogues</a> et <a href=\"https://core.trac.wordpress.org/query?status=closed&amp;type=task+(blessed)&amp;milestone=6.6&amp;max=500&amp;col=id&amp;col=summary&amp;col=type&amp;col=status&amp;col=milestone&amp;col=owner&amp;col=priority&amp;order=priority\" target=\"_blank\" rel=\"noreferrer noopener\">10 autres tâches de maintenance</a>. Pour cette version, <a href=\"https://core.trac.wordpress.org/query?status=closed&amp;focuses=~performance&amp;milestone=6.6&amp;group=component&amp;col=id&amp;col=summary&amp;col=status&amp;col=focuses&amp;col=owner&amp;col=type&amp;col=priority&amp;order=priority\" target=\"_blank\" rel=\"noreferrer noopener\">16 tickets étaient centrés sur les performances</a>, <a href=\"https://core.trac.wordpress.org/query?status=closed&amp;focuses=~accessibility&amp;milestone=6.6&amp;group=component&amp;col=id&amp;col=summary&amp;col=status&amp;col=focuses&amp;col=owner&amp;col=type&amp;col=priority&amp;order=priority\" target=\"_blank\" rel=\"noreferrer noopener\">24 sur l&rsquo;accessibilité</a> et <a href=\"https://core.trac.wordpress.org/query?status=closed&amp;focuses=~coding-standards&amp;milestone=6.6&amp;group=component&amp;col=id&amp;col=summary&amp;col=status&amp;col=focuses&amp;col=owner&amp;col=type&amp;col=priority&amp;order=priority\" target=\"_blank\" rel=\"noreferrer noopener\">15 tickets portaient sur la modernisation du code source de notre CMS</a>. Les modifications de WP&nbsp;6.6 concernent <a href=\"https://core.trac.wordpress.org/query?status=closed&amp;milestone=6.6&amp;group=component&amp;col=id&amp;col=summary&amp;col=status&amp;col=milestone&amp;col=owner&amp;col=type&amp;col=priority&amp;order=priority\">40 composants du code source de WordPress</a>.</p>\n\n\n\n<p>Cette version comprend aussi 392 améliorations, 462 corrections de bogues et 46 améliorations de l&rsquo;accessibilité de <a href=\"https://github.com/WordPress/gutenberg/commits/wp/6.6\">l&rsquo;éditeur de blocs</a> (Gutenberg).</p>\n\n\n\n<p>Tous les liens de cet article pointent vers des notes de développement rédigées en anglais. L’objectif est de fournir un panorama général des changements techniques apportés par cette version, en français, puis de diriger les personnes qui souhaitent en savoir plus vers les notes de développement en anglais.</p>\n\n\n\n<p>Pour en savoir plus sur la feuille de route et le calendrier de sortie de WP&nbsp;6.6, consultez cette page : <a href=\"https://make.wordpress.org/core/6-5/\">https://make.wordpress.org/core/6-5/</a></p>\n\n\n\n<hr class=\"wp-block-separator has-alpha-channel-opacity\" />\n\n\n\n<h2 class=\"wp-block-heading\" id=\"Block-Editor\">Changements concernant l’éditeur et le projet Gutenberg</h2>\n\n\n\n<p>WordPress 6.6 implémente 8 versions de Gutenberg &#8211; <a href=\"https://make.wordpress.org/core/2024/02/28/whats-new-in-gutenberg-17-8-28-february/\">17.8</a>, <a href=\"https://make.wordpress.org/core/2024/03/13/whats-new-in-gutenberg-17-9-13-march/\">17.9</a>, <a href=\"https://make.wordpress.org/core/2024/03/27/whats-new-in-gutenberg-18-0-27-march/\">18.0</a>, <a href=\"https://make.wordpress.org/core/2024/04/10/whats-new-in-gutenberg-18-1-10-april/\">18.1</a>, <a href=\"https://make.wordpress.org/core/2024/04/24/whats-new-in-gutenberg-18-2-24-april/\">18.2</a>, <a href=\"https://make.wordpress.org/core/2024/05/08/whats-new-in-gutenberg-18-3-8-may/\">18.3</a>, <a href=\"https://make.wordpress.org/core/2024/05/23/whats-new-in-gutenberg-18-4-22-may/\">18.4</a> et <a href=\"https://make.wordpress.org/core/2024/06/09/what-is-new-in-gutenberg-18-5-05-jun/\">18.5</a>. L&rsquo;éditeur de blocs reçoit ainsi de nombreuses améliorations liées à la bibliothèque React, à l’API <code>Block</code>, à la gestion des thèmes, et bien plus encore.</p>\n\n\n\n<h3 class=\"wp-block-heading\" id=\"react\">React</h3>\n\n\n\n<p>Une nouvelle version de React et la nouvelle <a href=\"https://legacy.reactjs.org/blog/2020/09/22/introducing-the-new-jsx-transform.html\">API JSX transform</a> font leur entrée dans WordPress&nbsp;6.6.</p>\n\n\n\n<figure class=\"wp-block-embed is-type-wp-embed is-provider-make-wordpress-core wp-block-embed-make-wordpress-core\"><div class=\"wp-block-embed__wrapper\">\n<blockquote class=\"wp-embedded-content\" data-secret=\"dWLxJUI3h0\"><a href=\"https://make.wordpress.org/core/2024/06/06/jsx-in-wordpress-6-6/\">JSX in WordPress 6.6</a></blockquote><iframe loading=\"lazy\" class=\"wp-embedded-content\" sandbox=\"allow-scripts\" security=\"restricted\"  title=\"&#8220;JSX in WordPress 6.6&#8221; &#8212; Make WordPress Core\" src=\"https://make.wordpress.org/core/2024/06/06/jsx-in-wordpress-6-6/embed/#?secret=XMglYBeDLC#?secret=dWLxJUI3h0\" data-secret=\"dWLxJUI3h0\" width=\"500\" height=\"282\" frameborder=\"0\" marginwidth=\"0\" marginheight=\"0\" scrolling=\"no\"></iframe>\n</div></figure>\n\n\n\n<figure class=\"wp-block-embed is-type-wp-embed is-provider-make-wordpress-core wp-block-embed-make-wordpress-core\"><div class=\"wp-block-embed__wrapper\">\n<blockquote class=\"wp-embedded-content\" data-secret=\"52Rfu8yAtE\"><a href=\"https://make.wordpress.org/core/2024/06/07/preparation-for-react-19-upgrade/\">Preparation for React 19 Upgrade</a></blockquote><iframe loading=\"lazy\" class=\"wp-embedded-content\" sandbox=\"allow-scripts\" security=\"restricted\"  title=\"&#8220;Preparation for React 19 Upgrade&#8221; &#8212; Make WordPress Core\" src=\"https://make.wordpress.org/core/2024/06/07/preparation-for-react-19-upgrade/embed/#?secret=YV2Zkzjfyy#?secret=52Rfu8yAtE\" data-secret=\"52Rfu8yAtE\" width=\"500\" height=\"282\" frameborder=\"0\" marginwidth=\"0\" marginheight=\"0\" scrolling=\"no\"></iframe>\n</div></figure>\n\n\n\n<h3 class=\"wp-block-heading\" id=\"block-api\">API <code>Block</code></h3>\n\n\n\n<p>Des changements arrivent sur l&rsquo;API <code>Block</code>&nbsp;:</p>\n\n\n\n<ul class=\"wp-block-list\">\n<li>Unification des API d&rsquo;extensibilité entre les éditeurs de publications et du site</li>\n\n\n\n<li>Amélioration de la propriété <code>isActive</code> sur les variations de blocs</li>\n\n\n\n<li>Améliorations de plusieurs blocs proposés par le cœur de WordPress</li>\n</ul>\n\n\n\n<figure class=\"wp-block-embed is-type-wp-embed is-provider-make-wordpress-core wp-block-embed-make-wordpress-core\"><div class=\"wp-block-embed__wrapper\">\n<blockquote class=\"wp-embedded-content\" data-secret=\"FC595uD9El\"><a href=\"https://make.wordpress.org/core/2024/06/18/editor-unified-extensibility-apis-in-6-6/\">Editor: Unified Extensibility APIs in 6.6</a></blockquote><iframe loading=\"lazy\" class=\"wp-embedded-content\" sandbox=\"allow-scripts\" security=\"restricted\"  title=\"&#8220;Editor: Unified Extensibility APIs in 6.6&#8221; &#8212; Make WordPress Core\" src=\"https://make.wordpress.org/core/2024/06/18/editor-unified-extensibility-apis-in-6-6/embed/#?secret=d9wcTgYeLu#?secret=FC595uD9El\" data-secret=\"FC595uD9El\" width=\"500\" height=\"282\" frameborder=\"0\" marginwidth=\"0\" marginheight=\"0\" scrolling=\"no\"></iframe>\n</div></figure>\n\n\n\n<figure class=\"wp-block-embed is-type-wp-embed is-provider-make-wordpress-core wp-block-embed-make-wordpress-core\"><div class=\"wp-block-embed__wrapper\">\n<blockquote class=\"wp-embedded-content\" data-secret=\"vsiCQ8RUpF\"><a href=\"https://make.wordpress.org/core/2024/06/18/improvements-to-active-block-variation-detection/\">Improvements to active block variation detection</a></blockquote><iframe loading=\"lazy\" class=\"wp-embedded-content\" sandbox=\"allow-scripts\" security=\"restricted\"  title=\"&#8220;Improvements to active block variation detection&#8221; &#8212; Make WordPress Core\" src=\"https://make.wordpress.org/core/2024/06/18/improvements-to-active-block-variation-detection/embed/#?secret=BlfgJ2v86t#?secret=vsiCQ8RUpF\" data-secret=\"vsiCQ8RUpF\" width=\"500\" height=\"282\" frameborder=\"0\" marginwidth=\"0\" marginheight=\"0\" scrolling=\"no\"></iframe>\n</div></figure>\n\n\n\n<figure class=\"wp-block-embed is-type-wp-embed is-provider-make-wordpress-core wp-block-embed-make-wordpress-core\"><div class=\"wp-block-embed__wrapper\">\n<blockquote class=\"wp-embedded-content\" data-secret=\"fcUHSrfEG8\"><a href=\"https://make.wordpress.org/core/2024/06/19/social-links-block-changes-in-wordpress-6-6/\">Social Links block changes in WordPress 6.6</a></blockquote><iframe loading=\"lazy\" class=\"wp-embedded-content\" sandbox=\"allow-scripts\" security=\"restricted\"  title=\"&#8220;Social Links block changes in WordPress 6.6&#8221; &#8212; Make WordPress Core\" src=\"https://make.wordpress.org/core/2024/06/19/social-links-block-changes-in-wordpress-6-6/embed/#?secret=KTnVlZwICZ#?secret=fcUHSrfEG8\" data-secret=\"fcUHSrfEG8\" width=\"500\" height=\"282\" frameborder=\"0\" marginwidth=\"0\" marginheight=\"0\" scrolling=\"no\"></iframe>\n</div></figure>\n\n\n\n<h3 class=\"wp-block-heading\" id=\"themes-6-6\">Thèmes</h3>\n\n\n\n<p>WordPress 6.6 introduit plusieurs mises à jour liées aux thèmes, comprenant&nbsp;:</p>\n\n\n\n<ul class=\"wp-block-list\">\n<li>Une nouvelle version 3 du <code>theme.json</code></li>\n\n\n\n<li>L&rsquo;uniformisation de la spécificité CSS appliquée aux styles du cœur de WP</li>\n\n\n\n<li>Introduction de la section «&nbsp;styles&nbsp;» pour améliorer l&rsquo;efficacité de la personnalisation des blocs et de leurs éléments internes</li>\n\n\n\n<li>Fonctionnalités additionnelles de la mise en page en grille dans les blocs</li>\n\n\n\n<li>Capacité de définir des images d&rsquo;arrière-plan pour l&rsquo;ensemble du site via le <code>theme.json</code> et via l’éditeur de site</li>\n</ul>\n\n\n\n<figure class=\"wp-block-embed is-type-wp-embed is-provider-make-wordpress-core wp-block-embed-make-wordpress-core\"><div class=\"wp-block-embed__wrapper\">\n<blockquote class=\"wp-embedded-content\" data-secret=\"3qkQI6VB3V\"><a href=\"https://make.wordpress.org/core/2024/06/19/theme-json-version-3/\">Theme.json version 3</a></blockquote><iframe loading=\"lazy\" class=\"wp-embedded-content\" sandbox=\"allow-scripts\" security=\"restricted\"  title=\"&#8220;Theme.json version 3&#8221; &#8212; Make WordPress Core\" src=\"https://make.wordpress.org/core/2024/06/19/theme-json-version-3/embed/#?secret=qFVVO9yctD#?secret=3qkQI6VB3V\" data-secret=\"3qkQI6VB3V\" width=\"500\" height=\"282\" frameborder=\"0\" marginwidth=\"0\" marginheight=\"0\" scrolling=\"no\"></iframe>\n</div></figure>\n\n\n\n<figure class=\"wp-block-embed is-type-wp-embed is-provider-make-wordpress-core wp-block-embed-make-wordpress-core\"><div class=\"wp-block-embed__wrapper\">\n<blockquote class=\"wp-embedded-content\" data-secret=\"WwNatJ4yuP\"><a href=\"https://make.wordpress.org/core/2024/06/24/section-styles/\">Section Styles</a></blockquote><iframe loading=\"lazy\" class=\"wp-embedded-content\" sandbox=\"allow-scripts\" security=\"restricted\"  title=\"&#8220;Section Styles&#8221; &#8212; Make WordPress Core\" src=\"https://make.wordpress.org/core/2024/06/24/section-styles/embed/#?secret=myss8Gv9Su#?secret=WwNatJ4yuP\" data-secret=\"WwNatJ4yuP\" width=\"500\" height=\"282\" frameborder=\"0\" marginwidth=\"0\" marginheight=\"0\" scrolling=\"no\"></iframe>\n</div></figure>\n\n\n\n<figure class=\"wp-block-embed is-type-wp-embed is-provider-make-wordpress-core wp-block-embed-make-wordpress-core\"><div class=\"wp-block-embed__wrapper\">\n<blockquote class=\"wp-embedded-content\" data-secret=\"5tYWFN7C0m\"><a href=\"https://make.wordpress.org/core/2024/06/21/wordpress-6-6-css-specificity/\">WordPress 6.6 CSS Specificity</a></blockquote><iframe loading=\"lazy\" class=\"wp-embedded-content\" sandbox=\"allow-scripts\" security=\"restricted\"  title=\"&#8220;WordPress 6.6 CSS Specificity&#8221; &#8212; Make WordPress Core\" src=\"https://make.wordpress.org/core/2024/06/21/wordpress-6-6-css-specificity/embed/#?secret=0Ak975GLQd#?secret=5tYWFN7C0m\" data-secret=\"5tYWFN7C0m\" width=\"500\" height=\"282\" frameborder=\"0\" marginwidth=\"0\" marginheight=\"0\" scrolling=\"no\"></iframe>\n</div></figure>\n\n\n\n<figure class=\"wp-block-embed is-type-wp-embed is-provider-make-wordpress-core wp-block-embed-make-wordpress-core\"><div class=\"wp-block-embed__wrapper\">\n<blockquote class=\"wp-embedded-content\" data-secret=\"g0n7RPlGmY\"><a href=\"https://make.wordpress.org/core/2024/06/18/grid-layout-type/\">Grid layout type</a></blockquote><iframe loading=\"lazy\" class=\"wp-embedded-content\" sandbox=\"allow-scripts\" security=\"restricted\"  title=\"&#8220;Grid layout type&#8221; &#8212; Make WordPress Core\" src=\"https://make.wordpress.org/core/2024/06/18/grid-layout-type/embed/#?secret=c59OLorfmE#?secret=g0n7RPlGmY\" data-secret=\"g0n7RPlGmY\" width=\"500\" height=\"282\" frameborder=\"0\" marginwidth=\"0\" marginheight=\"0\" scrolling=\"no\"></iframe>\n</div></figure>\n\n\n\n<figure class=\"wp-block-embed is-type-wp-embed is-provider-make-wordpress-core wp-block-embed-make-wordpress-core\"><div class=\"wp-block-embed__wrapper\">\n<blockquote class=\"wp-embedded-content\" data-secret=\"ZPfvPc14dl\"><a href=\"https://make.wordpress.org/core/2024/06/20/site-wide-background-images-in-wordpress-6-6/\">Site-wide background images in WordPress 6.6</a></blockquote><iframe loading=\"lazy\" class=\"wp-embedded-content\" sandbox=\"allow-scripts\" security=\"restricted\"  title=\"&#8220;Site-wide background images in WordPress 6.6&#8221; &#8212; Make WordPress Core\" src=\"https://make.wordpress.org/core/2024/06/20/site-wide-background-images-in-wordpress-6-6/embed/#?secret=GtFb16IOEz#?secret=ZPfvPc14dl\" data-secret=\"ZPfvPc14dl\" width=\"500\" height=\"282\" frameborder=\"0\" marginwidth=\"0\" marginheight=\"0\" scrolling=\"no\"></iframe>\n</div></figure>\n\n\n\n<h3 class=\"wp-block-heading\" id=\"miscellaneous-block-editor-changes\">Modifications diverses concernant l’éditeur</h3>\n\n\n\n<p>Plusieurs autres modifications de l’éditeur de bloc sont aussi incluses dans WordPress 6.6 :</p>\n\n\n\n<ul class=\"wp-block-list\">\n<li><a href=\"https://make.wordpress.org/core/2024/06/24/miscellaneous-editor-changes-in-wordpress-6-6/#Added-wp-block-list-class-to-the-list-block\">Ajout de la classe <code>wp-block-list</code>&nbsp;au bloc Liste</a></li>\n\n\n\n<li><a href=\"https://make.wordpress.org/core/2024/06/24/miscellaneous-editor-changes-in-wordpress-6-6/#New-Interactivity-API-directives\">Nouvelles directives pour l&rsquo;API <code>Interactivity</code></a></li>\n\n\n\n<li><a href=\"https://make.wordpress.org/core/2024/06/24/miscellaneous-editor-changes-in-wordpress-6-6/#Allow-view-access-of-the-template-REST-API-endpoint-to-anyone-with-the-edit_post-capability\">Ajout de l’accès en lecture au point de terminaison <code>template</code> de l’API REST à toute personne disposant de la permission <code>edit_post</code></a></li>\n\n\n\n<li><a href=\"https://make.wordpress.org/core/2024/06/24/miscellaneous-editor-changes-in-wordpress-6-6/#Unified-split-logic-for-writing-flow\">Unification de la logique de séparation dans le flux de rédaction</a></li>\n\n\n\n<li><a href=\"https://make.wordpress.org/core/2024/06/24/miscellaneous-editor-changes-in-wordpress-6-6/#BlockPopover-Component-is-now-public\">Le composant BlockPopover est maintenant public</a></li>\n\n\n\n<li><a href=\"https://make.wordpress.org/core/2024/06/24/miscellaneous-editor-changes-in-wordpress-6-6/#Add-filter-to-modify-the-list-of-post-content-block-types\">Ajout d&rsquo;un filtre pour modifier la liste des types de blocs de contenu</a></li>\n\n\n\n<li><a href=\"https://make.wordpress.org/core/2024/06/24/miscellaneous-editor-changes-in-wordpress-6-6/#Global-Styles-Filter-out-color-and-typography-variations\">Styles globaux&nbsp;: ajout de filtres pour les variations de couleur et de typographie</a></li>\n\n\n\n<li><a href=\"https://make.wordpress.org/core/2024/06/24/miscellaneous-editor-changes-in-wordpress-6-6/#Add-custom-Aspect-Ratio-presets-through-theme-json\">Ajout de pré-réglages de proportions gérables via le fichier&nbsp;<code>theme.json</code></a></li>\n\n\n\n<li><a href=\"https://make.wordpress.org/core/2024/06/24/miscellaneous-editor-changes-in-wordpress-6-6/#root-padding-style-updates\">Mise à jour des styles de marge interne racine via <code>:root</code></a></li>\n\n\n\n<li><a href=\"https://make.wordpress.org/core/2024/06/24/miscellaneous-editor-changes-in-wordpress-6-6/#Added-Text-alignment-block-support\">Ajout de la prise en charge de l&rsquo;alignement de texte des blocs</a></li>\n</ul>\n\n\n\n<figure class=\"wp-block-embed is-type-wp-embed is-provider-make-wordpress-core wp-block-embed-make-wordpress-core\"><div class=\"wp-block-embed__wrapper\">\n<blockquote class=\"wp-embedded-content\" data-secret=\"zwjsgiLBc3\"><a href=\"https://make.wordpress.org/core/2024/06/24/miscellaneous-editor-changes-in-wordpress-6-6/\">Miscellaneous Editor changes in WordPress 6.6</a></blockquote><iframe loading=\"lazy\" class=\"wp-embedded-content\" sandbox=\"allow-scripts\" security=\"restricted\"  title=\"&#8220;Miscellaneous Editor changes in WordPress 6.6&#8221; &#8212; Make WordPress Core\" src=\"https://make.wordpress.org/core/2024/06/24/miscellaneous-editor-changes-in-wordpress-6-6/embed/#?secret=ixOVYPSn2d#?secret=zwjsgiLBc3\" data-secret=\"zwjsgiLBc3\" width=\"500\" height=\"282\" frameborder=\"0\" marginwidth=\"0\" marginheight=\"0\" scrolling=\"no\"></iframe>\n</div></figure>\n\n\n\n<p>Un tableau des outils de conception supportés par chaque bloc sur WordPress&nbsp;6.6 a été publié en guise de référence.</p>\n\n\n\n<figure class=\"wp-block-embed is-type-wp-embed is-provider-make-wordpress-core wp-block-embed-make-wordpress-core\"><div class=\"wp-block-embed__wrapper\">\n<blockquote class=\"wp-embedded-content\" data-secret=\"dIjJDZTSGY\"><a href=\"https://make.wordpress.org/core/2024/06/20/roster-of-design-tools-per-block-wordpress-6-6-edition/\">Roster of design tools per block (WordPress 6.6 edition)</a></blockquote><iframe loading=\"lazy\" class=\"wp-embedded-content\" sandbox=\"allow-scripts\" security=\"restricted\"  title=\"&#8220;Roster of design tools per block (WordPress 6.6 edition)&#8221; &#8212; Make WordPress Core\" src=\"https://make.wordpress.org/core/2024/06/20/roster-of-design-tools-per-block-wordpress-6-6-edition/embed/#?secret=xV9lWVls3h#?secret=dIjJDZTSGY\" data-secret=\"dIjJDZTSGY\" width=\"500\" height=\"282\" frameborder=\"0\" marginwidth=\"0\" marginheight=\"0\" scrolling=\"no\"></iframe>\n</div></figure>\n\n\n\n<h2 class=\"wp-block-heading\" id=\"html-api\">API HTML</h2>\n\n\n\n<p>WordPress 6.6 comprend une version de maintenance de l&rsquo;API HTML. Cela inclut quelques nouvelles fonctionnalités et une amélioration majeure de l&rsquo;utilisabilité du processeur HTML. Cela poursuit les travaux d&rsquo;amélioration continue engagés depuis WP 6.5.</p>\n\n\n\n<p>Une nouvelle structure de données vient aussi avec la version 6.6&nbsp;: il s&rsquo;agit de l&rsquo;API&nbsp;<code>WP_Token_Map</code>.</p>\n\n\n\n<figure class=\"wp-block-embed is-type-wp-embed is-provider-make-wordpress-core wp-block-embed-make-wordpress-core\"><div class=\"wp-block-embed__wrapper\">\n<blockquote class=\"wp-embedded-content\" data-secret=\"wuD7UIc043\"><a href=\"https://make.wordpress.org/core/2024/06/24/updates-to-the-html-api-in-6-6/\">Updates to the HTML API in 6.6</a></blockquote><iframe loading=\"lazy\" class=\"wp-embedded-content\" sandbox=\"allow-scripts\" security=\"restricted\"  title=\"&#8220;Updates to the HTML API in 6.6&#8221; &#8212; Make WordPress Core\" src=\"https://make.wordpress.org/core/2024/06/24/updates-to-the-html-api-in-6-6/embed/#?secret=jA5d2tI5LY#?secret=wuD7UIc043\" data-secret=\"wuD7UIc043\" width=\"500\" height=\"282\" frameborder=\"0\" marginwidth=\"0\" marginheight=\"0\" scrolling=\"no\"></iframe>\n</div></figure>\n\n\n\n<figure class=\"wp-block-embed is-type-wp-embed is-provider-make-wordpress-core wp-block-embed-make-wordpress-core\"><div class=\"wp-block-embed__wrapper\">\n<blockquote class=\"wp-embedded-content\" data-secret=\"cLzvpODa71\"><a href=\"https://make.wordpress.org/core/2024/06/24/introducing-the-token-map/\">Introducing the Token Map</a></blockquote><iframe loading=\"lazy\" class=\"wp-embedded-content\" sandbox=\"allow-scripts\" security=\"restricted\"  title=\"&#8220;Introducing the Token Map&#8221; &#8212; Make WordPress Core\" src=\"https://make.wordpress.org/core/2024/06/24/introducing-the-token-map/embed/#?secret=96WcqwTl9C#?secret=cLzvpODa71\" data-secret=\"cLzvpODa71\" width=\"500\" height=\"282\" frameborder=\"0\" marginwidth=\"0\" marginheight=\"0\" scrolling=\"no\"></iframe>\n</div></figure>\n\n\n\n<h2 class=\"wp-block-heading\" id=\"options-api\">API <code>Options</code></h2>\n\n\n\n<p>Plusieurs modifications ont été faites sur l&rsquo;API <code>Options</code> pour prendre en charge une optimisation du comportement de chargement automatique et pour créer une façon d’appliquer les prochaines optimisations à venir.</p>\n\n\n\n<figure class=\"wp-block-embed is-type-wp-embed is-provider-make-wordpress-core wp-block-embed-make-wordpress-core\"><div class=\"wp-block-embed__wrapper\">\n<blockquote class=\"wp-embedded-content\" data-secret=\"sY4OPd8z50\"><a href=\"https://make.wordpress.org/core/2024/06/18/options-api-disabling-autoload-for-large-options/\">Options API: Disabling autoload for large options</a></blockquote><iframe loading=\"lazy\" class=\"wp-embedded-content\" sandbox=\"allow-scripts\" security=\"restricted\"  title=\"&#8220;Options API: Disabling autoload for large options&#8221; &#8212; Make WordPress Core\" src=\"https://make.wordpress.org/core/2024/06/18/options-api-disabling-autoload-for-large-options/embed/#?secret=Fd1Vmk80wn#?secret=sY4OPd8z50\" data-secret=\"sY4OPd8z50\" width=\"500\" height=\"282\" frameborder=\"0\" marginwidth=\"0\" marginheight=\"0\" scrolling=\"no\"></iframe>\n</div></figure>\n\n\n\n<h2 class=\"wp-block-heading\" id=\"i18n\">Internationalisation</h2>\n\n\n\n<p><a href=\"https://core.trac.wordpress.org/query?component=I18N&amp;milestone=6.5&amp;&amp;col=id&amp;col=summary&amp;col=milestone&amp;col=owner&amp;col=type&amp;col=status&amp;col=priority&amp;order=priority\">Plusieurs améliorations de l&rsquo;internationalisation</a> ont été intégrées dans WP&nbsp;6.6&nbsp;:</p>\n\n\n\n<ul class=\"wp-block-list\">\n<li><a href=\"https://make.wordpress.org/core/2024/06/24/i18n-improvements-6-6#Enhanced-support-for-only-using-PHP-translation-files\">Amélioration de la prise en charge des fichiers de traduction PHP</a></li>\n\n\n\n<li><a href=\"https://make.wordpress.org/core/2024/06/24/i18n-improvements-6-6#New-lang_dir_for_domain-filter\">Nouveau filtre&nbsp;<code>lang_dir_for_domain</code></a></li>\n\n\n\n<li><a href=\"https://make.wordpress.org/core/2024/06/24/i18n-improvements-6-6#Additional-context-for-the-load_translation_file-filter\">Ajout d&rsquo;un contexte pour le filtre <code>load_translation_file</code></a></li>\n</ul>\n\n\n\n<figure class=\"wp-block-embed is-type-wp-embed is-provider-make-wordpress-core wp-block-embed-make-wordpress-core\"><div class=\"wp-block-embed__wrapper\">\n<blockquote class=\"wp-embedded-content\" data-secret=\"MSrk50CwxF\"><a href=\"https://make.wordpress.org/core/2024/06/24/i18n-improvements-6-6/\">Internationalization improvements in 6.6</a></blockquote><iframe loading=\"lazy\" class=\"wp-embedded-content\" sandbox=\"allow-scripts\" security=\"restricted\"  title=\"&#8220;Internationalization improvements in 6.6&#8221; &#8212; Make WordPress Core\" src=\"https://make.wordpress.org/core/2024/06/24/i18n-improvements-6-6/embed/#?secret=3bBLcbcQOl#?secret=MSrk50CwxF\" data-secret=\"MSrk50CwxF\" width=\"500\" height=\"282\" frameborder=\"0\" marginwidth=\"0\" marginheight=\"0\" scrolling=\"no\"></iframe>\n</div></figure>\n\n\n\n<h2 class=\"wp-block-heading\" id=\"miscellaneous-developer-changes\">Autres changements techniques</h2>\n\n\n\n<ul class=\"wp-block-list\">\n<li><a href=\"https://make.wordpress.org/core/2024/06/25/miscellaneous-developer-changes-in-wordpress-6-6/#allowed-disabling-autosave-support-for-individual-post-types\">Désactivation de la sauvegarde automatique indépendamment pour chaque type de publication</a></li>\n\n\n\n<li><a href=\"https://make.wordpress.org/core/2024/06/25/miscellaneous-developer-changes-in-wordpress-6-6/#default-length-of-time-for-comment-author-cookies-has-changed\">Modification de la durée native de conservation des cookies de commentaires</a></li>\n\n\n\n<li><a href=\"https://make.wordpress.org/core/2024/06/25/miscellaneous-developer-changes-in-wordpress-6-6/#site-editor-patterns-on-classic-themes\">Prise en charge des compositions de l’éditeur de site dans les thèmes classiques</a></li>\n\n\n\n<li><a href=\"https://make.wordpress.org/core/2024/06/25/miscellaneous-developer-changes-in-wordpress-6-6/#fluid-typography\">Prise en charge des polices fluides</a></li>\n\n\n\n<li><a href=\"https://make.wordpress.org/core/2024/06/25/miscellaneous-developer-changes-in-wordpress-6-6/#jquery-ui-library-update\">Mise à jour de la bibliothèque jQuery UI</a></li>\n\n\n\n<li><a href=\"https://make.wordpress.org/core/2024/06/25/miscellaneous-developer-changes-in-wordpress-6-6/#new-array-arguments-for-wp-login-form\">Nouveaux paramètres pour la fonction for wp_login_form()</a></li>\n\n\n\n<li><a href=\"https://make.wordpress.org/core/2024/06/25/miscellaneous-developer-changes-in-wordpress-6-6/#custom-ports-for-multisite-site-addresses\">Ports personnalisés pour les adresses des sites d&rsquo;un multisite</a></li>\n\n\n\n<li><a href=\"https://make.wordpress.org/core/2024/06/25/miscellaneous-developer-changes-in-wordpress-6-6/#update-enabled-mime-types-for-new-multisite-installs\">Mise à jour des types MIME activés pour les nouvelles installations multisite</a></li>\n\n\n\n<li><a href=\"https://make.wordpress.org/core/2024/06/25/miscellaneous-developer-changes-in-wordpress-6-6/#obsolete-polyfills-dependencies-have-been-removed\">Suppression des dépendances polyfill obsolètes</a></li>\n\n\n\n<li><a href=\"https://make.wordpress.org/core/2024/06/25/miscellaneous-developer-changes-in-wordpress-6-6/#script-modules-can-now-be-used-in-the-wordpress-admin\">Les modules de Script peuvent maintenant être utilisés sur l&rsquo;administration</a></li>\n\n\n\n<li><a href=\"https://make.wordpress.org/core/2024/06/25/miscellaneous-developer-changes-in-wordpress-6-6/#search-has-a-much-later-priority\">Mise en place d&rsquo;une priorité moins importante sur le composant de recherche de la barre d&rsquo;administration</a></li>\n</ul>\n\n\n\n<figure class=\"wp-block-embed is-type-wp-embed is-provider-make-wordpress-core wp-block-embed-make-wordpress-core\"><div class=\"wp-block-embed__wrapper\">\n<blockquote class=\"wp-embedded-content\" data-secret=\"q0i57KuxlF\"><a href=\"https://make.wordpress.org/core/2024/06/25/miscellaneous-developer-changes-in-wordpress-6-6/\">Miscellaneous developer changes in WordPress 6.6</a></blockquote><iframe loading=\"lazy\" class=\"wp-embedded-content\" sandbox=\"allow-scripts\" security=\"restricted\"  title=\"&#8220;Miscellaneous developer changes in WordPress 6.6&#8221; &#8212; Make WordPress Core\" src=\"https://make.wordpress.org/core/2024/06/25/miscellaneous-developer-changes-in-wordpress-6-6/embed/#?secret=q70OxXcdsS#?secret=q0i57KuxlF\" data-secret=\"q0i57KuxlF\" width=\"500\" height=\"282\" frameborder=\"0\" marginwidth=\"0\" marginheight=\"0\" scrolling=\"no\"></iframe>\n</div></figure>\n\n\n\n<h2 class=\"wp-block-heading\" id=\"other-updates\">Nouvelles fonctions, crochets, filtres, classes et méthodes</h2>\n\n\n\n<p>Pour obtenir la liste de toutes les nouvelles fonctions, crochets, filtres, classes et méthodes, vous pourrez vous rendre – une fois que WP 6.6 sera sortie – sur cette page&nbsp;: <a href=\"https://developer.wordpress.org/reference/since/6.6.0/\">https://developer.wordpress.org/reference/since/6.6.0/</a>.</p>\n\n\n\n<div class=\"wp-block-group alignfull is-layout-flow wp-block-group-is-layout-flow\">\n<p class=\"is-style-serif has-white-color has-text-color has-background has-link-color wp-elements-9bd75783906267b91255ee59d7f76693\" style=\"background:linear-gradient(135deg,rgb(189,21,50) 0%,rgb(248,68,11) 100%)\">Que vous développiez des thèmes ou des extensions, pensez à tester et retester votre code pour vous assurer de sa compatibilité avec ces changements. Vous pouvez utiliser&nbsp;<a href=\"https://fr.wordpress.org/plugins/wordpress-beta-tester/\" target=\"_blank\" rel=\"noreferrer noopener\">l’extension «&nbsp;<em><bdo lang=\"en\" dir=\"ltr\">Beta Tester</bdo></em>&nbsp;»</a>&nbsp;sur un site de test pour vérifier la compatibilité de vos développements avec la <a href=\"https://wordpress.org/news/2024/06/wordpress-6-6-rc1/\">version <em><bdo lang=\"en\" dir=\"ltr\">release candidate</bdo></em>&nbsp;de WordPress 6.6</a>.&nbsp;<br>Vous pouvez aussi tester cette nouvelle version directement dans votre navigateur en utilisant <em><a href=\"https://playground.wordpress.net/#%7B%20%22preferredVersions%22:%20%7B%20%22php%22:%20%228.0%22,%20%22wp%22:%20%22beta%22%20%7D,%20%22features%22:%20%7B%20%22networking%22:%20true%20%7D,%20%22steps%22:%20[%20%7B%20%22step%22:%20%22login%22,%20%22username%22:%20%22admin%22,%20%22password%22:%20%22password%22%20%7D,%20%7B%20%22step%22:%20%22importFile%22,%20%22file%22:%20%7B%20%22resource%22:%20%22url%22,%20%22url%22:%20%22https://raw.githubusercontent.com/wpaccessibility/a11y-theme-unit-test/master/a11y-theme-unit-test-data.xml%22%20%7D%20%7D,%20%7B%20%22step%22:%20%22importFile%22,%20%22file%22:%20%7B%20%22resource%22:%20%22url%22,%20%22url%22:%20%22https://raw.githubusercontent.com/WordPress/theme-test-data/master/themeunittestdata.wordpress.xml%22%20%7D%20%7D,%20%7B%20%22step%22:%20%22installPlugin%22,%20%22pluginZipFile%22:%20%7B%20%22resource%22:%20%22wordpress.org/plugins%22,%20%22slug%22:%20%22query-monitor%22%20%7D,%20%22options%22:%20%7B%20%22activate%22:%20false%20%7D,%20%22progress%22:%20%7B%20%22weight%22:%202%20%7D%20%7D,%20%7B%20%22step%22:%20%22installPlugin%22,%20%22pluginZipFile%22:%20%7B%20%22resource%22:%20%22wordpress.org/plugins%22,%20%22slug%22:%20%22create-block-theme%22%20%7D,%20%22progress%22:%20%7B%20%22weight%22:%202%20%7D%20%7D,%20%7B%20%22step%22:%20%22installPlugin%22,%20%22pluginZipFile%22:%20%7B%20%22resource%22:%20%22wordpress.org/plugins%22,%20%22slug%22:%20%22debug-bar%22%20%7D,%20%22progress%22:%20%7B%20%22weight%22:%202%20%7D%20%7D,%20%7B%20%22step%22:%20%22installPlugin%22,%20%22pluginZipFile%22:%20%7B%20%22resource%22:%20%22wordpress.org/plugins%22,%20%22slug%22:%20%22health-check%22%20%7D,%20%22progress%22:%20%7B%20%22weight%22:%202%20%7D%20%7D,%20%7B%20%22step%22:%20%22installPlugin%22,%20%22pluginZipFile%22:%20%7B%20%22resource%22:%20%22wordpress.org/plugins%22,%20%22slug%22:%20%22test-reports%22%20%7D,%20%22progress%22:%20%7B%20%22weight%22:%202%20%7D%20%7D,%20%7B%20%22step%22:%20%22installPlugin%22,%20%22pluginZipFile%22:%20%7B%20%22resource%22:%20%22wordpress.org/plugins%22,%20%22slug%22:%20%22user-switching%22%20%7D,%20%22progress%22:%20%7B%20%22weight%22:%202%20%7D%20%7D%20]%20%7D\"><bdo lang=\"en\" dir=\"ltr\">WordPress Playground</bdo></a></em>.<br><br>Nous comptons sur vous pour vérifier que votre code fonctionne correctement avec le cœur du CMS, pour le bien des millions d’utilisateurs et utilisatrices de WordPress&nbsp;<img src=\"https://s.w.org/images/core/emoji/16.0.1/72x72/2665.png\" alt=\"♥\" class=\"wp-smiley\" style=\"height: 1em; max-height: 1em;\" /></p>\n</div>\n\n\n\n<p class=\"has-small-font-size\">Ce guide a été traduit et réadapté à partir du <a href=\"https://make.wordpress.org/core/2024/06/25/wordpress-6-6-field-guide/\"><em><bdo lang=\"en\" dir=\"ltr\">Field Guide</bdo></em> de WP 6.6</a> par <a href=\"https://profiles.wordpress.org/audrasjb/\">Jb Audras</a>.<br>Merci à <a href=\"https://profiles.wordpress.org/fxbenard/\">FX Bénard</a>, <a href=\"https://profiles.wordpress.org/beryldlg/\">Béryl</a>, <a href=\"https://profiles.wordpress.org/juliobox/\">Julio</a>, <a href=\"https://profiles.wordpress.org/jdy68\">Jenny</a>, <a href=\"https://profiles.wordpress.org/clementpolito/\">Clément</a> pour leur relecture.</p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:30:\"com-wordpress:feed-additions:1\";a:1:{s:7:\"post-id\";a:1:{i:0;a:5:{s:4:\"data\";s:4:\"3125\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}}}s:27:\"http://www.w3.org/2005/Atom\";a:1:{s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:0:\"\";s:7:\"attribs\";a:1:{s:0:\"\";a:3:{s:4:\"href\";s:35:\"https://fr.wordpress.org/news/feed/\";s:3:\"rel\";s:4:\"self\";s:4:\"type\";s:19:\"application/rss+xml\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:44:\"http://purl.org/rss/1.0/modules/syndication/\";a:2:{s:12:\"updatePeriod\";a:1:{i:0;a:5:{s:4:\"data\";s:9:\"\n	hourly	\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:15:\"updateFrequency\";a:1:{i:0;a:5:{s:4:\"data\";s:4:\"\n	1	\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:30:\"com-wordpress:feed-additions:1\";a:1:{s:4:\"site\";a:1:{i:0;a:5:{s:4:\"data\";s:8:\"13096031\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}}}}}}}}s:4:\"type\";i:128;s:7:\"headers\";O:48:\"WpOrg\\Requests\\Utility\\CaseInsensitiveDictionary\":1:{s:7:\"\0*\0data\";a:11:{s:6:\"server\";s:5:\"nginx\";s:4:\"date\";s:29:\"Fri, 24 Oct 2025 19:04:57 GMT\";s:12:\"content-type\";s:34:\"application/rss+xml; charset=UTF-8\";s:4:\"vary\";s:37:\"Accept-Encoding, accept, content-type\";s:6:\"x-olaf\";s:3:\"⛄\";s:13:\"last-modified\";s:29:\"Fri, 11 Jul 2025 09:26:12 GMT\";s:4:\"link\";s:61:\"<https://fr.wordpress.org/wp-json/>; rel=\"https://api.w.org/\"\";s:15:\"x-frame-options\";s:10:\"SAMEORIGIN\";s:16:\"content-encoding\";s:4:\"gzip\";s:7:\"alt-svc\";s:19:\"h3=\":443\"; ma=86400\";s:4:\"x-nc\";s:10:\"MISS ord 1\";}}s:5:\"build\";i:1727751020;s:21:\"cache_expiration_time\";i:1761375897;s:23:\"__cache_expiration_time\";i:1761375897;}", "off");
INSERT INTO `inter_options` VALUES("2160", "_transient_timeout_feed_mod_0d2db5fea5a8633b56992c916819b198", "1761375897", "off");
INSERT INTO `inter_options` VALUES("2161", "_transient_feed_mod_0d2db5fea5a8633b56992c916819b198", "1761332697", "off");
INSERT INTO `inter_options` VALUES("2162", "_transient_timeout_feed_b0b1001e5bc3fbacad8b49ec075d19a5", "1761375898", "off");
INSERT INTO `inter_options` VALUES("2163", "_transient_feed_b0b1001e5bc3fbacad8b49ec075d19a5", "a:6:{s:5:\"child\";a:1:{s:27:\"http://www.w3.org/2005/Atom\";a:1:{s:4:\"feed\";a:1:{i:0;a:6:{s:4:\"data\";s:126:\"\n    \n    \n    \n    \n    \n    \n\n        \n        \n        \n        \n        \n        \n        \n        \n        \n        \n    \";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:27:\"http://www.w3.org/2005/Atom\";a:7:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:16:\"Planet WordPress\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"subtitle\";a:1:{i:0;a:5:{s:4:\"data\";s:16:\"Planet WordPress\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:0:\"\";s:7:\"attribs\";a:1:{s:0:\"\";a:2:{s:4:\"href\";s:43:\"https://fluxplanet.wpfr.net/feed/wp-planet/\";s:3:\"rel\";s:4:\"self\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:2:\"id\";a:1:{i:0;a:5:{s:4:\"data\";s:28:\"https://fluxplanet.wpfr.net/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"updated\";a:1:{i:0;a:5:{s:4:\"data\";s:25:\"2025-10-24T19:04:28+00:00\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:9:\"generator\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"\n        WP RSS Aggregator\n    \";s:7:\"attribs\";a:1:{s:0:\"\";a:2:{s:3:\"uri\";s:27:\"https://wprssaggregator.com\";s:7:\"version\";s:7:\"4.23.13\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:5:\"entry\";a:10:{i:0;a:6:{s:4:\"data\";s:70:\"\n    \n    \n    \n    \n    \n    \n    \n            \n                \n    \";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:27:\"http://www.w3.org/2005/Atom\";a:9:{s:2:\"id\";a:1:{i:0;a:5:{s:4:\"data\";s:98:\"https://blog.o2switch.fr/site-wordpress-multilingue-installer-et-configurer-lextension-polylang-1/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:86:\"Site WordPress multilingue : Installer et configurer l’extension Polylang (Partie 1)\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:4:\"type\";s:4:\"html\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:0:\"\";s:7:\"attribs\";a:1:{s:0:\"\";a:2:{s:4:\"href\";s:98:\"https://blog.o2switch.fr/site-wordpress-multilingue-installer-et-configurer-lextension-polylang-1/\";s:3:\"rel\";s:9:\"alternate\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"updated\";a:1:{i:0;a:5:{s:4:\"data\";s:29:\"2025-10-22T06:30:00.000+00:00\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:9:\"published\";a:1:{i:0;a:5:{s:4:\"data\";s:29:\"2025-10-22T06:30:00.000+00:00\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"summary\";a:1:{i:0;a:5:{s:4:\"data\";s:205:\"AppInstaller et configurer Polylang sur WordPress pour créer un site multilingue. Langue par défaut, traduction des médias, structure d’URL, sélecteur de langue : le guide complet pour bien débuter.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"content\";a:1:{i:0;a:5:{s:4:\"data\";s:219:\"\n        AppInstaller et configurer Polylang sur WordPress pour créer un site multilingue. Langue par défaut, traduction des médias, structure d’URL, sélecteur de langue : le guide complet pour bien débuter.\n    \";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:4:\"type\";s:4:\"html\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:6:\"author\";a:1:{i:0;a:6:{s:4:\"data\";s:46:\"\n            \n                                \";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:27:\"http://www.w3.org/2005/Atom\";a:1:{s:4:\"name\";a:1:{i:0;a:5:{s:4:\"data\";s:16:\"Valérie Galassi\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}}s:6:\"source\";a:1:{i:0;a:6:{s:4:\"data\";s:67:\"\n                    \n                            \n                \";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:27:\"http://www.w3.org/2005/Atom\";a:2:{s:2:\"id\";a:1:{i:0;a:5:{s:4:\"data\";s:40:\"https://blog.o2switch.fr/wordpress/feed/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:8:\"O2switch\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}}}}}i:1;a:6:{s:4:\"data\";s:70:\"\n    \n    \n    \n    \n    \n    \n    \n            \n                \n    \";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:27:\"http://www.w3.org/2005/Atom\";a:9:{s:2:\"id\";a:1:{i:0;a:5:{s:4:\"data\";s:63:\"https://vincentdubroeucq.com/comprendre-les-hooks-de-wordpress/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:33:\"Comprendre les hooks de WordPress\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:4:\"type\";s:4:\"html\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:0:\"\";s:7:\"attribs\";a:1:{s:0:\"\";a:2:{s:4:\"href\";s:63:\"https://vincentdubroeucq.com/comprendre-les-hooks-de-wordpress/\";s:3:\"rel\";s:9:\"alternate\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"updated\";a:1:{i:0;a:5:{s:4:\"data\";s:29:\"2025-10-21T09:19:35.000+00:00\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:9:\"published\";a:1:{i:0;a:5:{s:4:\"data\";s:29:\"2025-10-21T09:19:35.000+00:00\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"summary\";a:1:{i:0;a:5:{s:4:\"data\";s:707:\"WordPress est un CMS qui est infiniment extensible et personnalisable. Il existe des milliers d’extensions qui permettent d’ajouter des fonctionnalités à votre site ou de modifier le comportement normal de WordPress. Tout cela est rendu possible par l’existence d’une API relativement simple contenue dans le cœur de WordPress depuis très longtemps : la plugin API. Dans cet article, on va redécouvrir et étudier la plugin API (les fameux hooks de WordPress) pour en comprendre le fonctionnement plus en détail. La plugin API : définition La plugin API ou (API des extensions) est simplement un ensemble de fonctions PHP qui permettent […]Lire la suite : Comprendre les hooks de WordPress\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"content\";a:1:{i:0;a:5:{s:4:\"data\";s:840:\"\n        WordPress est un CMS qui est infiniment extensible et personnalisable. Il existe des milliers d&#8217;extensions qui permettent d&#8217;ajouter des fonctionnalités à votre site ou de modifier le comportement normal de WordPress. Tout cela est rendu possible par l&#8217;existence d&#8217;une API relativement simple contenue dans le cœur de WordPress depuis très longtemps : la plugin API. Dans cet article, on va redécouvrir et étudier la plugin API (les fameux hooks de WordPress) pour en comprendre le fonctionnement plus en détail. La plugin API : définition La plugin API ou (API des extensions) est simplement un ensemble de fonctions PHP qui permettent [&#8230;]<br><strong>Lire la suite :</strong> <a href=\"https://vincentdubroeucq.com/comprendre-les-hooks-de-wordpress/\">Comprendre les hooks de WordPress</a>\n    \";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:4:\"type\";s:4:\"html\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:6:\"author\";a:1:{i:0;a:6:{s:4:\"data\";s:46:\"\n            \n                                \";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:27:\"http://www.w3.org/2005/Atom\";a:1:{s:4:\"name\";a:1:{i:0;a:5:{s:4:\"data\";s:7:\"Vincent\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}}s:6:\"source\";a:1:{i:0;a:6:{s:4:\"data\";s:67:\"\n                    \n                            \n                \";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:27:\"http://www.w3.org/2005/Atom\";a:2:{s:2:\"id\";a:1:{i:0;a:5:{s:4:\"data\";s:34:\"https://vincentdubroeucq.com/feed/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:17:\"Vincent Dubroeucq\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}}}}}i:2;a:6:{s:4:\"data\";s:70:\"\n    \n    \n    \n    \n    \n    \n    \n            \n                \n    \";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:27:\"http://www.w3.org/2005/Atom\";a:9:{s:2:\"id\";a:1:{i:0;a:5:{s:4:\"data\";s:50:\"https://wpmarmite.com/meilleurs-plugins-wordpress/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:50:\"Les 25 meilleurs plugins WordPress (édition 2025)\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:4:\"type\";s:4:\"html\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:0:\"\";s:7:\"attribs\";a:1:{s:0:\"\";a:2:{s:4:\"href\";s:50:\"https://wpmarmite.com/meilleurs-plugins-wordpress/\";s:3:\"rel\";s:9:\"alternate\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"updated\";a:1:{i:0;a:5:{s:4:\"data\";s:29:\"2025-10-16T07:00:00.000+00:00\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:9:\"published\";a:1:{i:0;a:5:{s:4:\"data\";s:29:\"2025-10-16T07:00:00.000+00:00\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"summary\";a:1:{i:0;a:5:{s:4:\"data\";s:388:\". Soit le nombre de plugins WordPress présents sur le répertoire officiel, au moment d’écrire ces lignes. Et je ne vous parle même pas de ceux présents sur des plateformes dédiées, comme Code Canyon ou des boutiques indépendantes. Ah ça,...\nLes 25 meilleurs plugins WordPress (édition 2025) est un article de WPMarmite, le blog qui vous aide à tirer le meilleur de WordPress.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"content\";a:1:{i:0;a:5:{s:4:\"data\";s:689:\"\n        <p><img width=\"1500\" height=\"830\" src=\"https://wpmarmite.com/wp-content/uploads/2018/09/plugins.jpg\" class=\"attachment-full size-full wp-post-image\" alt=\"plugins\" //></p>\n<p>. Soit le nombre de plugins WordPress présents sur le répertoire officiel, au moment d’écrire ces lignes. Et je ne vous parle même pas de ceux présents sur des plateformes dédiées, comme Code Canyon ou des boutiques indépendantes. Ah ça,...</p>\n<p><a href=\"https://wpmarmite.com/meilleurs-plugins-wordpress/\">Les 25 meilleurs plugins WordPress (édition 2025)</a> est un article de <a href=\"https://wpmarmite.com\">WPMarmite</a>, le blog qui vous aide à tirer le meilleur de WordPress.</p>\n\n    \";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:4:\"type\";s:4:\"html\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:6:\"author\";a:1:{i:0;a:6:{s:4:\"data\";s:46:\"\n            \n                                \";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:27:\"http://www.w3.org/2005/Atom\";a:1:{s:4:\"name\";a:1:{i:0;a:5:{s:4:\"data\";s:28:\"Thibaut &amp;#124; WPMarmite\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}}s:6:\"source\";a:1:{i:0;a:6:{s:4:\"data\";s:67:\"\n                    \n                            \n                \";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:27:\"http://www.w3.org/2005/Atom\";a:2:{s:2:\"id\";a:1:{i:0;a:5:{s:4:\"data\";s:29:\"http://feedpress.me/WPMarmite\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:10:\"WP Marmite\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}}}}}i:3;a:6:{s:4:\"data\";s:70:\"\n    \n    \n    \n    \n    \n    \n    \n            \n                \n    \";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:27:\"http://www.w3.org/2005/Atom\";a:9:{s:2:\"id\";a:1:{i:0;a:5:{s:4:\"data\";s:72:\"https://whodunit.consulting/mise-a-jour-inventaire-opquast-wordpress-v5/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:102:\"Mise à jour de l’inventaire des règles Opquast applicables à WordPress avec la V5 du réferentiel\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:4:\"type\";s:4:\"html\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:0:\"\";s:7:\"attribs\";a:1:{s:0:\"\";a:2:{s:4:\"href\";s:72:\"https://whodunit.consulting/mise-a-jour-inventaire-opquast-wordpress-v5/\";s:3:\"rel\";s:9:\"alternate\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"updated\";a:1:{i:0;a:5:{s:4:\"data\";s:29:\"2025-10-15T22:57:04.000+00:00\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:9:\"published\";a:1:{i:0;a:5:{s:4:\"data\";s:29:\"2025-10-15T22:57:04.000+00:00\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"summary\";a:1:{i:0;a:5:{s:4:\"data\";s:316:\"La V5 d\'Opquast est sortie en octobre 2025 ! Nous avons donc mis à jour notre outil d\'inventaire des règles qui s\'appliquent à votre projet WordPress.\nL’article Mise à jour de l’inventaire des règles Opquast applicables à WordPress avec la V5 du réferentiel est apparu en premier sur Whodunit Consulting.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"content\";a:1:{i:0;a:5:{s:4:\"data\";s:6560:\"\n        <figure aria-label=\"Whodunit Consulting &amp; Opquast : un inventaire des règles Opquast applicables à votre projet WordPresss\" class=\"wp-block-post-featured-image\"><img width=\"1600\" height=\"960\" src=\"https://whodunit.consulting/wp-content/uploads/2025/06/whodunit-consulting-inventaire-qualite-opquast-1.png\" class=\"attachment-post-thumbnail size-post-thumbnail wp-post-image\" alt=\"\" style=\"object-fit:cover\" //></figure>\n\n\n<p>Avec la sortie de la version 5 <sup data-fn=\"8d3f2960-9c54-4071-9871-cae390c8651d\" class=\"fn\"><a id=\"8d3f2960-9c54-4071-9871-cae390c8651d-link\" href=\"#8d3f2960-9c54-4071-9871-cae390c8651d\">1</a></sup> de la <bdo lang=\"en\" dir=\"ltr\">checklist</bdo> de règles d&rsquo;assurance qualité proposées par Opquast, nous avons mis à jour notre <a href=\"https://whodunit.consulting/mon-inventaire-de-regles-opquast/\">outil de création de l&rsquo;inventaire des règles s&rsquo;appliquant à votre projet WordPress</a>.</p>\n\n\n\n<p>En effet, Opquast a lancé le 2 octobre la nouvelle version de son référentiel. Et nous y avons d&rsquo;ailleurs contribué de façon significative :</p>\n\n\n\n<ul class=\"wp-block-list\">\n<li>En participant à l&rsquo;atelier dédié à cette V5 lors de l&rsquo;Opquast Day au printemps dernier <sup data-fn=\"0be2f041-034f-4a95-8aa9-c6901ad41f21\" class=\"fn\"><a href=\"#0be2f041-034f-4a95-8aa9-c6901ad41f21\" id=\"0be2f041-034f-4a95-8aa9-c6901ad41f21-link\">2</a></sup>. Nous y avions proposé l&rsquo;ajout de nouvelles règles mais avons aussi défendu une proposition de suppression de l&rsquo;ancienne règle 25 <sup data-fn=\"3258c36a-f70d-44f8-9ec3-667ce07f23a2\" class=\"fn\"><a href=\"#3258c36a-f70d-44f8-9ec3-667ce07f23a2\" id=\"3258c36a-f70d-44f8-9ec3-667ce07f23a2-link\">3</a></sup> qui stipulait que les liens externes qui ouvrent une nouvelle fenêtre ne doivent pas partager d&rsquo;information de contexte. Cela a été acté dans la V5.</li>\n\n\n\n<li>En participant à l&rsquo;appel à contribution lancé lors de la finalisation de la V5. Eddy et Jean-Baptiste se sont pliés au jeu et ont proposé de nombreuses formulations et reformulations, afin de participer à l&rsquo;aboutissement de ce travail.</li>\n</ul>\n\n\n\n<p>Bref, la version 5 des règles d&rsquo;assurance qualité Opquast sera valable jusqu&rsquo;en 2030. C&rsquo;est donc reparti pour 5 ans !</p>\n\n\n\n<h2 class=\"wp-block-heading\"><mark class=\"has-inline-color has-contrast-2-color\">Whodunit + Opquast</mark> : un partenariat précieux</h2>\n\n\n\n<p>Whodunit en tant que partenaire Opquast est <a href=\"https://whodunit.consulting/opquast-referentiel-assurance-qualite-web/\">toujours très engagé à promouvoir Opquast</a>.</p>\n\n\n\n<p>Outre le fait de faire systématiquement passer la certification aux membres de notre équipe, nous faisons la promotion d&rsquo;Opquast chez nos clients et les faisons systématiquement bénéficier du programme <bdo lang=\"en\" dir=\"ltr\"><em>Opquast Start</em></bdo> qui leur permet de tester leurs connaissances en qualité web.</p>\n\n\n\n<p>Nous intégrons aussi les règles d&rsquo;assurance qualité établies par Opquast au cœur de nos processus de conception et d&rsquo;audit de sites.</p>\n\n\n\n<h2 class=\"wp-block-heading\">La mise à jour de notre outil de génération d&rsquo;<mark class=\"has-inline-color has-contrast-2-color\">inventaire de règles Opquast applicables à votre projet WordPress</mark></h2>\n\n\n\n<p>Nous avons donc mis à jour notre outil qui est toujours disponible sur ce site. Il permet, en répondant à une quinzaine de questions simples sur les fonctionnalité de votre site, d&rsquo;établir une liste des règles Opquast qui s&rsquo;appliquent à votre projet de site WordPress.</p>\n\n\n\n<p>Qu&rsquo;il s&rsquo;agisse d&rsquo;un projet de refonte ou d&rsquo;un site existant que vous souhaitez auditer, cet utilitaire vous sera utile pour trier les règles qui s&rsquo;appliquent ou non à votre projet WordPress.</p>\n\n\n\n<p>En bonus, nous vous donnons dans la checklist obtenue toutes nos recommandations d&rsquo;implémentation des règles Opquast dans un environnement WordPress, avec des recos d&rsquo;extensions ou de paramétrage du CMS.</p>\n\n\n\n<p>Vous voulez essayer ? C&rsquo;est gratuit et aucune donnée personnelle ou liée à votre projet ne sera utilisée ou conservée.</p>\n\n\n\n<div class=\"wp-block-buttons is-content-justification-center is-layout-flex wp-container-core-buttons-is-layout-a89b3969 wp-block-buttons-is-layout-flex\">\n<div class=\"wp-block-button\"><a class=\"wp-block-button__link wp-element-button\" href=\"https://whodunit.consulting/mon-inventaire-de-regles-opquast/\">Mon inventaire de règles Opquast</a></div>\n</div>\n\n\n\n<hr class=\"wp-block-separator has-alpha-channel-opacity\" //>\n\n\n\n<h2 class=\"wp-block-heading has-small-font-size\">Notes et références</h2>\n\n\n<ol class=\"wp-block-footnotes\"><li id=\"8d3f2960-9c54-4071-9871-cae390c8651d\">Consulter <a href=\"https://www.opquast.com/publication-de-la-version-5-du-referentiel-opquast/\">l&rsquo;annonce de sortie d&rsquo;Opquast</a> V5 <a href=\"#8d3f2960-9c54-4071-9871-cae390c8651d-link\" aria-label=\"Aller à la note de bas de page 1\"><img src=\"https://s.w.org/images/core/emoji/16.0.1/72x72/21a9.png\" alt=\"↩\" class=\"wp-smiley\" style=\"height: 1em;max-height: 1em\" //>︎</a></li><li id=\"0be2f041-034f-4a95-8aa9-c6901ad41f21\">Consulter notre <a href=\"https://www.whodunit.fr/whodunit-opquast-day-2025/\">compte-rendu de l&rsquo;Opquast Day 2025 sur le blog de l&rsquo;agence Whodunit</a> <a href=\"#0be2f041-034f-4a95-8aa9-c6901ad41f21-link\" aria-label=\"Aller à la note de bas de page 2\"><img src=\"https://s.w.org/images/core/emoji/16.0.1/72x72/21a9.png\" alt=\"↩\" class=\"wp-smiley\" style=\"height: 1em;max-height: 1em\" //>︎</a></li><li id=\"3258c36a-f70d-44f8-9ec3-667ce07f23a2\">Voir la <a href=\"https://checklists.opquast.com/fr/assurance-qualite-web/les-liens-externes-qui-ouvrent-une-nouvelle-fenetre-ne-partagent-pas-dinformation-de-contexte\">version archivée de la règle Opquast n°25 de la version 4 du réferentiel Opquast</a> <a href=\"#3258c36a-f70d-44f8-9ec3-667ce07f23a2-link\" aria-label=\"Aller à la note de bas de page 3\"><img src=\"https://s.w.org/images/core/emoji/16.0.1/72x72/21a9.png\" alt=\"↩\" class=\"wp-smiley\" style=\"height: 1em;max-height: 1em\" //>︎</a></li></ol><p>L’article <a href=\"https://whodunit.consulting/mise-a-jour-inventaire-opquast-wordpress-v5/\">Mise à jour de l&rsquo;inventaire des règles Opquast applicables à WordPress avec la V5 du réferentiel</a> est apparu en premier sur <a href=\"https://whodunit.consulting\">Whodunit Consulting</a>.</p>\n\n    \";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:4:\"type\";s:4:\"html\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:6:\"author\";a:1:{i:0;a:6:{s:4:\"data\";s:46:\"\n            \n                                \";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:27:\"http://www.w3.org/2005/Atom\";a:1:{s:4:\"name\";a:1:{i:0;a:5:{s:4:\"data\";s:20:\"Jean-Baptiste Audras\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}}s:6:\"source\";a:1:{i:0;a:6:{s:4:\"data\";s:67:\"\n                    \n                            \n                \";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:27:\"http://www.w3.org/2005/Atom\";a:2:{s:2:\"id\";a:1:{i:0;a:5:{s:4:\"data\";s:52:\"https://whodunit.consulting/category/wordpress/feed/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:19:\"Whodunit Consulting\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}}}}}i:4;a:6:{s:4:\"data\";s:70:\"\n    \n    \n    \n    \n    \n    \n    \n            \n                \n    \";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:27:\"http://www.w3.org/2005/Atom\";a:9:{s:2:\"id\";a:1:{i:0;a:5:{s:4:\"data\";s:68:\"https://yesweblog.fr/generer-le-fichier-llms-txt-avec-rank-math-seo/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:48:\"Générer le fichier LLMS Txt avec Rank Math SEO\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:4:\"type\";s:4:\"html\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:0:\"\";s:7:\"attribs\";a:1:{s:0:\"\";a:2:{s:4:\"href\";s:68:\"https://yesweblog.fr/generer-le-fichier-llms-txt-avec-rank-math-seo/\";s:3:\"rel\";s:9:\"alternate\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"updated\";a:1:{i:0;a:5:{s:4:\"data\";s:29:\"2025-10-12T12:52:57.000+00:00\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:9:\"published\";a:1:{i:0;a:5:{s:4:\"data\";s:29:\"2025-10-12T12:52:57.000+00:00\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"summary\";a:1:{i:0;a:5:{s:4:\"data\";s:445:\"Nouvel Article\nCréer le fichier LLMS est possible en quelques clics avec le plugin Rank Math SEO. Alors si vous ne faîtes pas partie des utilisateurs du populaire plugin Yoast SEO, découvrez aujourd’hui comment générer votre fichier LLMS grâce à votre extension d’optimisation du référencement naturel qu’est Rank math. Créer et générer un fichier LLMS avec rank […]\n- Yes We Blog ! - Webmaster WordPress - Griselidis Gaillet\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"content\";a:1:{i:0;a:5:{s:4:\"data\";s:532:\"\n        <p>Nouvel Article</p>\n<p>Créer le fichier LLMS est possible en quelques clics avec le plugin Rank Math SEO. Alors si vous ne faîtes pas partie des utilisateurs du populaire plugin Yoast SEO, découvrez aujourd&#8217;hui comment générer votre fichier LLMS grâce à votre extension d&#8217;optimisation du référencement naturel qu&#8217;est Rank math. Créer et générer un fichier LLMS avec rank [&#8230;]</p>\n<p>- <a href=\"https://yesweblog.fr\">Yes We Blog ! - Webmaster WordPress - Griselidis Gaillet</a></p>\n\n    \";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:4:\"type\";s:4:\"html\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:6:\"author\";a:1:{i:0;a:6:{s:4:\"data\";s:46:\"\n            \n                                \";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:27:\"http://www.w3.org/2005/Atom\";a:1:{s:4:\"name\";a:1:{i:0;a:5:{s:4:\"data\";s:18:\"Griselidis Gaillet\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}}s:6:\"source\";a:1:{i:0;a:6:{s:4:\"data\";s:67:\"\n                    \n                            \n                \";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:27:\"http://www.w3.org/2005/Atom\";a:2:{s:2:\"id\";a:1:{i:0;a:5:{s:4:\"data\";s:45:\"https://yesweblog.fr/category/wordpress/feed/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:11:\"Yes we blog\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}}}}}i:5;a:6:{s:4:\"data\";s:70:\"\n    \n    \n    \n    \n    \n    \n    \n            \n                \n    \";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:27:\"http://www.w3.org/2005/Atom\";a:9:{s:2:\"id\";a:1:{i:0;a:5:{s:4:\"data\";s:86:\"https://beapi.fr/blog/developpement-dextensions-wordpress-methode-et-bonnes-pratiques/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:70:\"Développement d’extensions WordPress : méthode et bonnes pratiques\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:4:\"type\";s:4:\"html\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:0:\"\";s:7:\"attribs\";a:1:{s:0:\"\";a:2:{s:4:\"href\";s:86:\"https://beapi.fr/blog/developpement-dextensions-wordpress-methode-et-bonnes-pratiques/\";s:3:\"rel\";s:9:\"alternate\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"updated\";a:1:{i:0;a:5:{s:4:\"data\";s:29:\"2025-10-07T07:39:02.000+00:00\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:9:\"published\";a:1:{i:0;a:5:{s:4:\"data\";s:29:\"2025-10-07T07:39:02.000+00:00\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"summary\";a:1:{i:0;a:5:{s:4:\"data\";s:527:\"WordPress est réputé pour la richesse de son écosystème et sa capacité à s’adapter à de nombreux cas d’usage. Mais parfois, certaines fonctionnalités restent hors cadre : trop spécifiques, trop critiques, ou trop dépendantes d’une logique métier propre à l’organisation. C’est dans ces situations qu’intervient le développement d’extensions WordPress sur mesure. Concevoir une extension ne se […]\nThe post Développement d’extensions WordPress : méthode et bonnes pratiques appeared first on .\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"content\";a:1:{i:0;a:5:{s:4:\"data\";s:14324:\"\n        \n<p></p>\n\n\n\n<p>WordPress est réputé pour la richesse de son écosystème et sa capacité à s’adapter à de nombreux cas d’usage. Mais parfois, certaines fonctionnalités restent hors cadre : trop spécifiques, trop critiques, ou trop dépendantes d’une logique métier propre à l’organisation. C’est dans ces situations qu’intervient le développement d’<strong>extensions WordPress sur mesure</strong>.</p>\n\n\n\n<p>Concevoir une extension ne se résume pas à « ajouter une fonctionnalité » : il s’agit de créer un composant structuré, capable de s’intégrer dans un SI existant, de respecter les standards de sécurité et de performance, et de garantir sa durabilité dans le temps.</p>\n\n\n\n<p>Chez Be API, c’est un exercice qui fait partie de notre cœur de métier. Dans cet article, nous partageons notre méthode, nos bonnes pratiques et les points de vigilance clés pour réussir le développement d’une extension WordPress dans un contexte professionnel exigeant.</p>\n\n\n\n<h2 class=\"wp-block-heading\">Qu’est-ce qu’une extension WordPress ?</h2>\n\n\n\n<p>Une extension est une <strong>brique fonctionnelle autonome</strong>, qui vient enrichir ou modifier le comportement natif du CMS. WordPress repose sur ce principe fondamental : un noyau stable (le core), auquel on peut adjoindre des extensions pour répondre à des besoins spécifiques, sans toucher au cœur du système.</p>\n\n\n\n<p>Dans un environnement d’entreprise, une extension n’est pas qu’un ajout fonctionnel. Il s’agit d’un <strong>composant logiciel stratégique</strong>, qui doit :</p>\n\n\n\n<ul class=\"wp-block-list\">\n<li>s’intégrer proprement dans une architecture SI existante,</li>\n\n\n\n<li>respecter les contraintes de gouvernance, sécurité et interopérabilité,</li>\n\n\n\n<li>et garantir un haut niveau de maintenabilité dans le temps.</li>\n</ul>\n\n\n\n<p>Développée sur mesure, une extension peut prendre la forme d’un connecteur avec une brique applicative du SI (ERP, PIM, DAM, CRM…), d’un module éditorial avancé, ou encore d’un outil métier conçu pour optimiser les usages back-office.</p>\n\n\n\n<p>Elle doit être est pensée pour :</p>\n\n\n\n<ul class=\"wp-block-list\">\n<li>fonctionner dans des <strong>contextes complexes</strong> : multisites, multilingues, déploiements industrialisés,</li>\n\n\n\n<li><strong>minimiser les dettes techniques</strong>,</li>\n\n\n\n<li>faciliter l’intégration dans des workflows agiles ou DevOps (CI/CD, versioning, testing…),</li>\n\n\n\n<li>et permettre une <strong>exploitation durable</strong> par les équipes internes ou prestataires tiers.</li>\n</ul>\n\n\n\n<h3 class=\"wp-block-heading\">Des demandes fréquentes côté client ?</h3>\n\n\n\n<p>Nous développons régulièrement des extensions sur mesure pour répondre à des besoins métiers spécifiques. Voici les typologies d’extensions que nous rencontrons le plus régulièrement dans nos projets :</p>\n\n\n\n<ul class=\"wp-block-list\">\n<li><strong>Connecteurs</strong> entre WordPress et un ERP, CRM, PIM ou DAM</li>\n\n\n\n<li><strong>Synchronisation de contenus</strong> entre plusieurs sites dans une usine à sites (multisite)</li>\n\n\n\n<li><strong>Automatisation d’exports</strong> vers des plateformes partenaires ou des outils métiers</li>\n\n\n\n<li><strong>Génération dynamique de fiches produits</strong> ou de contenus depuis des flux externes</li>\n\n\n\n<li><strong>Outils internes</strong> pour simplifier la gestion éditoriale ou applicative : reporting, restrictions par rôles, workflows de validation, contrôle qualité, etc.</li>\n</ul>\n\n\n\n<p>Parmi nos travaux récents, on peut citer un <strong>moteur de synchronisation d’offres d’emploi</strong>, déployé notamment pour Kiloutou ou Covivio, afin de centraliser et automatiser la diffusion de postes depuis leur SI RH. Ou encore un <strong>workflow éditorial spécifique</strong> conçu pour BNPP CIB, permettant de mieux structurer et sécuriser la validation des contenus avant publication.</p>\n\n\n\n<h2 class=\"wp-block-heading\">Prérequis techniques pour développer une extension WordPress</h2>\n\n\n\n<p>Pour créer une extension WordPress solide et garantir un résultat fiable, maintenable et performant, il est indispensable de s’appuyer sur une <strong>connaissance approfondie de l’écosystème WordPress</strong>, et de ses bonnes pratiques.</p>\n\n\n\n<h3 class=\"wp-block-heading\">Ce que cela implique concrètement :</h3>\n\n\n\n<ul class=\"wp-block-list\">\n<li><strong>Maîtriser les fondamentaux</strong> du CMS : PHP, MySQL, bonnes pratiques d’organisation des fichiers et du code.</li>\n\n\n\n<li><strong>Comprendre le cœur de WordPress (le core)</strong> : son système de hooks (<code>actions</code> et <code>filters</code>), sa logique de chargement, son fonctionnement événementiel.</li>\n\n\n\n<li><strong>Exploiter les principales API</strong> de WordPress : REST API, Settings API, Options API, User Roles &amp; Capabilities, Transients, etc.</li>\n\n\n\n<li><strong>Anticiper les interactions avec les autres briques techniques</strong> : thèmes, autres plugins, back-office, éditeur Gutenberg, architecture multisite.</li>\n\n\n\n<li><strong>Respecter les standards de qualité</strong> : WordPress Coding Standards, code modulaire et documenté.</li>\n\n\n\n<li><strong>Penser sécurité et scalabilité dès la conception</strong> : gestion des permissions, nonces, échappement des données, séparation logique/front</li>\n\n\n\n<li><strong>Travailler dans un cadre précis</strong> : intégration continue (CI), versioning Git, tests automatisés (unitaires et fonctionnels), revue de code, monitoring post-déploiement.</li>\n</ul>\n\n\n\n<p>Ces compétences permettent de prévoir les risques, de garantir la qualité du code, et surtout d’assurer la pérennité de l’extension dans des contextes évolutifs.</p>\n\n\n\n<p>👉 <strong>C’est pourquoi faire appel à des experts WordPress</strong> n’est pas un luxe, mais une nécessité quand il s’agit de développer une extension sur mesure fiable, sécurisée et adaptée à vos usages.</p>\n\n\n\n<h2 class=\"wp-block-heading\">Notre méthodologie de développement d’extension WordPress</h2>\n\n\n\n<p>Développer des extensions WordPress, c’est notre cœur de métier. Nous en concevons, auditons et maintenons chaque semaine, dans des contextes très variés : multisites, dispositifs éditoriaux, SI interconnectés, etc.</p>\n\n\n\n<p>Notre démarche s’appuie sur une méthodologie structurée, qui vise à <strong>minimiser les risques, garantir la qualité, et fluidifier l’intégration dans les équipes et les processus existants</strong>.</p>\n\n\n\n<h3 class=\"wp-block-heading\">1. Cadrage fonctionnel</h3>\n\n\n\n<p>Tout commence par la compréhension du contexte client. Nous déterminons les objectifs métier, les utilisateurs concernés, les flux à automatiser ou à fiabiliser, les contraintes SI (interopérabilité, sécurité, hébergement, etc.)</p>\n\n\n\n<p>C’est une étape clé pour éviter les dérives fonctionnelles ou techniques.</p>\n\n\n\n<h3 class=\"wp-block-heading\">2. Spécifications</h3>\n\n\n\n<p>Nous formalisons ensuite les attendus sous forme de livrables clairs : structure de données, règles de gestion, droits d’accès, interfaces back-office, logique de traitement (imports, synchronisation, génération dynamique…)</p>\n\n\n\n<p>L’objectif : lever toutes les zones d’ombre en amont pour assurer un développement fluide.</p>\n\n\n\n<h3 class=\"wp-block-heading\">3. Architecture technique</h3>\n\n\n\n<p>Nous concevons l’extension comme un composant logiciel structuré :</p>\n\n\n\n<ul class=\"wp-block-list\">\n<li>organisation des fichiers</li>\n\n\n\n<li>découpage modulaire</li>\n\n\n\n<li>logique métier isolée</li>\n\n\n\n<li>points de configuration/documentation</li>\n\n\n\n<li>stratégie de test et de versionning</li>\n</ul>\n\n\n\n<p>Nous anticipons l’intégration continue, la compatibilité multisite, la scalabilité, et les besoins de maintenance à long terme.</p>\n\n\n\n<h3 class=\"wp-block-heading\">4. Développement</h3>\n\n\n\n<p>Le développement se fait par blocs fonctionnels, testables de façon indépendante. Nous appliquons :</p>\n\n\n\n<ul class=\"wp-block-list\">\n<li>les standards WordPress</li>\n\n\n\n<li>un contrôle strict des entrées/sorties</li>\n\n\n\n<li>des logs et des erreurs gérées proprement</li>\n\n\n\n<li>une documentation interne pour chaque développement</li>\n</ul>\n\n\n\n<h3 class=\"wp-block-heading\">5. Intégration et recette</h3>\n\n\n\n<p>L’extension est testée dans un environnement au plus proche du réel, dans les vraies conditions d’usage : Cette étape permet d’identifier les éventuels cas limites, et d’ajuster les derniers détails avant livraison.</p>\n\n\n\n<figure class=\"wp-block-pullquote\"><blockquote><p>On commence toujours les projets par les développements les plus complexes. Et on prévoit toujours le pire pour créer des extensions solides, résistantes aux erreurs d’interface, mais aussi aux défaillances éventuelles des autres services du SI.</p></blockquote></figure>\n\n\n\n<h2 class=\"wp-block-heading\">Bonnes pratiques : performance, sécurité et évolutivité</h2>\n\n\n\n<p>Une extension mal conçue, c’est une dette technique qui peut vous coûter cher. C’est pourquoi nous appliquons un ensemble de <strong>principes non négociables</strong>, pensés pour sécuriser les projets.</p>\n\n\n\n<h3 class=\"wp-block-heading\">Sécurité</h3>\n\n\n\n<p>Chaque donnée manipulée est échappée. Chaque action est protégée par des nonces. Chaque interaction utilisateur est contrôlée. On pense aux failles (XSS, CSRF, injection SQL), <strong>avant qu’elles n’arrivent</strong>.</p>\n\n\n\n<h3 class=\"wp-block-heading\">Performance</h3>\n\n\n\n<p>On ne surcharge jamais WordPress. Requêtes optimisées, chargement conditionnel, logique séparée du front : l’extension ne ralentit ni l’admin, ni les pages.</p>\n\n\n\n<h3 class=\"wp-block-heading\">Interopérabilité</h3>\n\n\n\n<p>Nos extensions doivent vivre dans un écosystème. Elles sont testées avec des extensions clés (Polylang, ACF, etc.) et pensées pour s’adapter à des infrastructures multisites, multilingues.</p>\n\n\n\n<h3 class=\"wp-block-heading\">Évolutivité</h3>\n\n\n\n<p>On anticipe les futurs besoins. On isole les logiques métier. On documente les points d’extension possibles. Vous pourrez faire évoluer l’outil dans 6 mois sans tout redévelopper.</p>\n\n\n\n<p>Ces pratiques permettent à vos projets de <strong>tenir dans le temps</strong>, même si les équipes changent ou si votre organisation évolue.</p>\n\n\n\n<h2 class=\"wp-block-heading\">FAQ</h2>\n\n\n\n<figure class=\"wp-block-table\"><table class=\"has-fixed-layout\"><tbody><tr><td><strong>Dans quels cas faut-il créer une extension sur mesure ?</strong><br>Quand vos besoins sortent du cadre standard. Si vous avez un SI spécifique à interfacer ou une logique de workflow complexe, une extension sur mesure sera souvent plus adaptée (et plus légère) qu’un assemblage de plugins tiers.</td></tr><tr><td><strong>Une extension peut-elle fonctionner sur un multisite ?</strong><br>Oui, à condition qu’elle soit conçue pour ça. Il faut penser à la gestion des rôles, à la séparation des contenus, aux spécificités réseau. C’est souvent le cas chez nos clients disposant d’usines à sites.</td></tr><tr><td><strong>Peut-on intégrer des exigences RGPD dès la création ?</strong><br>Absolument. On peut anonymiser certaines données, enregistrer les logs, gérer les consentements ou limiter les accès à certaines infos sensibles, directement dans l’extension.</td></tr><tr><td><strong>Est-ce que je peux faire évoluer l’extension plus tard ?</strong><br>Oui, si elle est bien pensée dès le départ. Chez Be API, on isole la logique métier pour faciliter les évolutions, sans tout redévelopper à chaque besoin.</td></tr><tr><td><strong>Est-ce que toutes les extensions développées sont publiées ?</strong><br>Non. Toutes les extensions que nous développons chez Be API ne sont pas destinées au répertoire WordPress. Certaines sont propriétaires, conçues pour répondre à des besoins internes ou confidentiels, souvent liés à un métier spécifique.<br>D’autres, comme <a href=\"https://www.wp-mediapapa.com/\">Mediapapa,</a> notre plugin de gestion avancée de la médiathèque WordPress, sont pensées pour un usage plus large, mais nécessitent un lancement structuré, avec un positionnement clair.</td></tr></tbody></table></figure>\n\n\n\n<h2 class=\"wp-block-heading\">Conclusion</h2>\n\n\n\n<p>Créer une extension WordPress est une décision structurante, qui engage à la fois votre écosystème technique et vos usages métiers. Pour être pérenne, l’extension doit être pensée comme une <strong>véritable brique logicielle</strong> : fiable, évolutive, interopérable et parfaitement intégrée à votre organisation.</p>\n\n\n\n<p>Cela exige à la fois une <strong>expertise technique avancée de WordPress et un</strong> <strong>niveau d’exigence élevé</strong> dans toutes les phases du projet : cadrage métier rigoureux, architecture maîtrisée, qualité de code, et anticipation des enjeux d’exploitation, de sécurité et de maintenance.</p>\n\n\n\n<div class=\"wp-block-group alignfull has-grey-100-light-gradient-background has-background is-layout-flow wp-container-core-group-is-layout-1 wp-block-group-is-layout-flow\" style=\"margin-top:var(--wp--preset--spacing--120);margin-bottom:var(--wp--preset--spacing--120)\">\n<h2 class=\"wp-block-heading has-text-align-center has-huge-font-size\" style=\"font-style:normal;font-weight:300\">Un<span class=\"has-italic-serif\"> besoin fonctionnel</span> spécifique&nbsp;?</h2>\n\n\n\n<h3 class=\"wp-block-heading has-text-align-center\">On vous aide à faire le tri entre les solutions du marché, les adaptations possibles ou un développement sur mesure. </h3>\n\n\n\n<div class=\"wp-block-buttons is-content-justification-center is-layout-flex wp-container-core-buttons-is-layout-1 wp-block-buttons-is-layout-flex\">\n<div class=\"wp-block-button\"><a class=\"wp-block-button__link wp-element-button\" href=\"https://beapi.fr/contact/\">Parlons-en !</a></div>\n</div>\n</div>\n<p>The post <a href=\"https://beapi.fr/blog/developpement-dextensions-wordpress-methode-et-bonnes-pratiques/\">Développement d’extensions WordPress : méthode et bonnes pratiques</a> appeared first on <a href=\"https://beapi.fr\"></a>.</p>\n\n    \";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:4:\"type\";s:4:\"html\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:6:\"author\";a:1:{i:0;a:6:{s:4:\"data\";s:46:\"\n            \n                                \";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:27:\"http://www.w3.org/2005/Atom\";a:1:{s:4:\"name\";a:1:{i:0;a:5:{s:4:\"data\";s:14:\"Alizée Ragoin\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}}s:6:\"source\";a:1:{i:0;a:6:{s:4:\"data\";s:67:\"\n                    \n                            \n                \";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:27:\"http://www.w3.org/2005/Atom\";a:2:{s:2:\"id\";a:1:{i:0;a:5:{s:4:\"data\";s:48:\"https://beapi.fr/blog/categories/wordpress/feed/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:5:\"BeAPI\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}}}}}i:6;a:6:{s:4:\"data\";s:70:\"\n    \n    \n    \n    \n    \n    \n    \n            \n                \n    \";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:27:\"http://www.w3.org/2005/Atom\";a:9:{s:2:\"id\";a:1:{i:0;a:5:{s:4:\"data\";s:71:\"https://kinsta.com/fr/blog/evoluer-sites-multiples-portfolio-wordpress/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:70:\"Faire évoluer les portfolios WordPress à plusieurs sites avec Kinsta\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:4:\"type\";s:4:\"html\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:0:\"\";s:7:\"attribs\";a:1:{s:0:\"\";a:2:{s:4:\"href\";s:71:\"https://kinsta.com/fr/blog/evoluer-sites-multiples-portfolio-wordpress/\";s:3:\"rel\";s:9:\"alternate\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"updated\";a:1:{i:0;a:5:{s:4:\"data\";s:29:\"2025-10-02T08:14:43.000+00:00\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:9:\"published\";a:1:{i:0;a:5:{s:4:\"data\";s:29:\"2025-10-02T08:14:43.000+00:00\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"summary\";a:1:{i:0;a:5:{s:4:\"data\";s:270:\"Jongler avec une poignée de sites WordPress est gérable. Mais lorsque le portfolio de votre agence compte des dizaines, voire des centaines de sites, le bon ...\nThe post Faire évoluer les portfolios WordPress à plusieurs sites avec Kinsta appeared first on Kinsta®.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"content\";a:1:{i:0;a:5:{s:4:\"data\";s:421:\"\n        <p>Jongler avec une poignée de sites WordPress est gérable. Mais lorsque le portfolio de votre agence compte des dizaines, voire des centaines de sites, le bon ...</p>\n<p>The post <a href=\"https://kinsta.com/fr/blog/evoluer-sites-multiples-portfolio-wordpress/\">Faire évoluer les portfolios WordPress à plusieurs sites avec Kinsta</a> appeared first on <a href=\"https://kinsta.com/fr\">Kinsta®</a>.</p>\n\n    \";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:4:\"type\";s:4:\"html\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:6:\"author\";a:1:{i:0;a:6:{s:4:\"data\";s:46:\"\n            \n                                \";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:27:\"http://www.w3.org/2005/Atom\";a:1:{s:4:\"name\";a:1:{i:0;a:5:{s:4:\"data\";s:15:\"Jeremy Holcombe\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}}s:6:\"source\";a:1:{i:0;a:6:{s:4:\"data\";s:67:\"\n                    \n                            \n                \";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:27:\"http://www.w3.org/2005/Atom\";a:2:{s:2:\"id\";a:1:{i:0;a:5:{s:4:\"data\";s:58:\"https://kinsta.com/fr/sujets/developpement-wordpress/feed/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:6:\"Kinsta\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}}}}}i:7;a:6:{s:4:\"data\";s:70:\"\n    \n    \n    \n    \n    \n    \n    \n            \n                \n    \";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:27:\"http://www.w3.org/2005/Atom\";a:9:{s:2:\"id\";a:1:{i:0;a:5:{s:4:\"data\";s:71:\"https://holdmywp.com/fil-dariane-multilingue-avec-slim-seo-et-polylang/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:52:\"Fil d’ariane multilingue avec Slim SEO et Polylang\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:4:\"type\";s:4:\"html\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:0:\"\";s:7:\"attribs\";a:1:{s:0:\"\";a:2:{s:4:\"href\";s:71:\"https://holdmywp.com/fil-dariane-multilingue-avec-slim-seo-et-polylang/\";s:3:\"rel\";s:9:\"alternate\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"updated\";a:1:{i:0;a:5:{s:4:\"data\";s:29:\"2025-09-26T10:49:18.000+00:00\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:9:\"published\";a:1:{i:0;a:5:{s:4:\"data\";s:29:\"2025-09-26T10:49:18.000+00:00\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"summary\";a:1:{i:0;a:5:{s:4:\"data\";s:133:\"Modifier le lien vers la page d\'accueil de la langue courante dans le fil d\'ariane généré par Slim SEO lorsqu\'on utilise Polylang.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"content\";a:1:{i:0;a:5:{s:4:\"data\";s:4617:\"\n        \n<p>J&rsquo;aime beaucoup l&rsquo;extension <a href=\"https://wordpress.org/plugins/slim-seo/\" target=\"_blank\" rel=\"noopener nofollow\" title=\"Slim SEO\">Slim SEO</a>, si tu <a href=\"https://holdmywp.com/checklist-extensions-wordpress/\" title=\"Des extensions de qualité  pour bien construire son site WordPress en 2025\">cherches une extension</a> pour tes besoins SEO simple à configurer, qui s&rsquo;intègre bien à WordPress sans surcharger ton tableau de bord et te noyer sous les publicités, fonce !</p>\n\n\n\n<p>J&rsquo;ai récemment publié mon site dans sa <a href=\"https://holdmywp.com/en/\" title=\"\">version anglophone</a> pour le rendre plus accessible et correspondre à mes besoins futurs. Mon fil d&rsquo;Ariane est géré avec Slim SEO et j&rsquo;ai rencontré un petit souci : <strong>le lien vers la page d&rsquo;accueil pointe toujours vers la racine du site</strong>, dans mon cas la version francophone. J&rsquo;utilise Polylang pour le multilingue, et malgré l&rsquo;<a href=\"https://docs.wpslimseo.com/slim-seo/integrations/polylang/\" target=\"_blank\" rel=\"noopener nofollow\" title=\"intégration de Slim SEO\">intégration de Slim SEO</a> je n&rsquo;ai pas l&rsquo;impression que le problème ait été adressé.</p>\n\n\n\n<div class=\"wp-block-buttons is-layout-flex wp-block-buttons-is-layout-flex\">\n<div class=\"wp-block-button\"><a class=\"wp-block-button__link wp-element-button\" href=\"#snippet\">Voir le code</a></div>\n</div>\n\n\n<h2 class=\"wp-block-heading\" id=\"modifier-le-lien-daccueil-du-fil-dariane-de-slim-seo-vers-la-page-daccueil-de-langue-la-courante-avec-poylang\">Modifier le lien d&rsquo;accueil du fil d&rsquo;ariane de Slim SEO vers la page d&rsquo;accueil de langue la courante avec Poylang</h2>\n\n\n<p>Comme je n&rsquo;ai pas trouvé de solution qui me convenait, voici la mienne pour modifier le lien vers la page d&rsquo;accueil.</p>\n\n\n<h3 class=\"wp-block-heading\" id=\"lidee\">L&rsquo;idée</h3>\n\n\n<ol class=\"wp-block-list\">\n<li><strong>Intercepter les liens du fil d’Ariane générés par Slim SEO</strong>, ça tombe bien, on a un hook.</li>\n\n\n\n<li><strong>Remplacer l’URL de la première entrée (la page d’accueil) par celle traduite dans la langue actuelle</strong>, si Polylang est actif.</li>\n\n\n\n<li><strong>Retourner les liens modifiés</strong> pour qu’ils soient affichés correctement dans la langue en cours.</li>\n</ol>\n\n\n<h3 class=\"wp-block-heading\" id=\"extrait-de-code\">Extrait de code</h3>\n\n<pre id=\"snippet\" class=\"wp-block-code\"><span><code class=\"hljs language-php\">\n<span class=\"hljs-comment\">/**\n * Modify Slim SEO breadcrumb links to support Polylang-translated front page URLs.\n *\n * Replaces the URL of the first breadcrumb link with the correct language-specific front page URL\n * using Polylang\'s `pll_get_post()` and `pll_current_language()`.\n *\n * <span class=\"hljs-doctag\">@param</span> array $links Array of breadcrumb links.\n * <span class=\"hljs-doctag\">@return</span> array Modified breadcrumb links with language-specific home URL.\n */</span>\n\nadd_filter(<span class=\"hljs-string\">\'slim_seo_breadcrumbs_links\'</span>, <span class=\"hljs-function\"><span class=\"hljs-keyword\">function</span><span class=\"hljs-params\">($links)</span> </span>{\n    <span class=\"hljs-keyword\">if</span> (<span class=\"hljs-keyword\">empty</span>($links)) {\n        <span class=\"hljs-keyword\">return</span> $links;\n    }\n\n    <span class=\"hljs-keyword\">if</span> (function_exists(<span class=\"hljs-string\">\'pll_current_language\'</span>)) {\n        $lang = pll_current_language();\n        $front_page_id = get_option(<span class=\"hljs-string\">\'page_on_front\'</span>);\n        $home_page_id = function_exists(<span class=\"hljs-string\">\'pll_get_post\'</span>) ? pll_get_post($front_page_id, $lang) : $front_page_id;\n\n        <span class=\"hljs-keyword\">if</span> ($home_page_id) {\n            $home_url = get_permalink($home_page_id);\n\n            $links&#091;<span class=\"hljs-number\">0</span>]&#091;<span class=\"hljs-string\">\'url\'</span>] = $home_url;\n        }\n    }\n\n    <span class=\"hljs-keyword\">return</span> $links;\n});\n</code></span></pre>\n\n\n<p>J’espère que cette publication t’aidera. Si tu as des questions, besoin de <a href=\"https://holdmywp.com/maintenance-wordpress/\">support</a> sur ton site WordPress, ou que tu veux apporter ta contribution pour améliorer l&rsquo;extrait de code, n’hésite pas à me <a href=\"https://holdmywp.com/contact/\">contacter</a> ou à laisser un petit commentaire !</p>\n\n\n\n<p class=\"nowrap\">&lt;(￣︶￣)&gt;</p>\n\n<p><a href=\"https://holdmywp.com/fil-dariane-multilingue-avec-slim-seo-et-polylang/\">Source</a></p>\n    \";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:4:\"type\";s:4:\"html\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:6:\"author\";a:1:{i:0;a:6:{s:4:\"data\";s:46:\"\n            \n                                \";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:27:\"http://www.w3.org/2005/Atom\";a:1:{s:4:\"name\";a:1:{i:0;a:5:{s:4:\"data\";s:15:\"Quentin Le Duff\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}}s:6:\"source\";a:1:{i:0;a:6:{s:4:\"data\";s:67:\"\n                    \n                            \n                \";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:27:\"http://www.w3.org/2005/Atom\";a:2:{s:2:\"id\";a:1:{i:0;a:5:{s:4:\"data\";s:40:\"https://holdmywp.com/tag/wordpress/feed/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:8:\"HoldMyWP\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}}}}}i:8;a:6:{s:4:\"data\";s:57:\"\n    \n    \n    \n    \n    \n    \n    \n                \n    \";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:27:\"http://www.w3.org/2005/Atom\";a:8:{s:2:\"id\";a:1:{i:0;a:5:{s:4:\"data\";s:47:\"https://www.seomix.fr/ancre-de-lien-definition/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:49:\"Ancre de Lien : Définition, Types et Impact SEO\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:4:\"type\";s:4:\"html\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:0:\"\";s:7:\"attribs\";a:1:{s:0:\"\";a:2:{s:4:\"href\";s:47:\"https://www.seomix.fr/ancre-de-lien-definition/\";s:3:\"rel\";s:9:\"alternate\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"updated\";a:1:{i:0;a:5:{s:4:\"data\";s:29:\"2025-06-26T05:34:28.000+00:00\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:9:\"published\";a:1:{i:0;a:5:{s:4:\"data\";s:29:\"2025-06-26T05:34:28.000+00:00\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"summary\";a:1:{i:0;a:5:{s:4:\"data\";s:667:\"Qu\'est-ce qu\'une ancre de lien ? Une ancre de lien en SEO est le texte cliquable et visible d\'un lien hypertexte, délimité par les balises HTML et . Ce texte descriptif indique aux utilisateurs et aux moteurs de recherche le contenu ou le sujet de la page de destination vers laquelle pointe le lien. Quelle est son importance en SEO ? L\'ancre de lien joue un rôle crucial en référencement naturel, car elle transmet des signaux contextuels aux algorithmes des moteurs de recherche, les aidant à comprendre la pertinence et la thématique de la page liée. Une ancre bien optimisée peut […]Lire la suite : Ancre de Lien : Définition, Types et Impact SEO\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"content\";a:1:{i:0;a:5:{s:4:\"data\";s:808:\"\n        Qu\'est-ce qu\'une ancre de lien&#160;? Une ancre de lien en SEO est le texte cliquable et visible d\'un lien hypertexte, délimité par les balises HTML &#060;a&#062; et &#060;/a&#062;. Ce texte descriptif indique aux utilisateurs et aux moteurs de recherche le contenu ou le sujet de la page de destination vers laquelle pointe le lien. Quelle est son importance en SEO&#160;? L\'ancre de lien joue un rôle crucial en référencement naturel, car elle transmet des signaux contextuels aux algorithmes des moteurs de recherche, les aidant à comprendre la pertinence et la thématique de la page liée. Une ancre bien optimisée peut [&#8230;]<br><strong>Lire la suite :</strong> <a href=\"https://www.seomix.fr/ancre-de-lien-definition/\">Ancre de Lien&#160;: Définition, Types et Impact SEO</a>\n    \";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:4:\"type\";s:4:\"html\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:6:\"source\";a:1:{i:0;a:6:{s:4:\"data\";s:67:\"\n                    \n                            \n                \";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:27:\"http://www.w3.org/2005/Atom\";a:2:{s:2:\"id\";a:1:{i:0;a:5:{s:4:\"data\";s:37:\"https://www.seomix.fr/wordpress/feed/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:6:\"SeoMix\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}}}}}i:9;a:6:{s:4:\"data\";s:70:\"\n    \n    \n    \n    \n    \n    \n    \n            \n                \n    \";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:27:\"http://www.w3.org/2005/Atom\";a:9:{s:2:\"id\";a:1:{i:0;a:5:{s:4:\"data\";s:93:\"https://wpfr.net/rejoignez-nous-sur-flickr-et-partagez-vos-souvenirs-avec-la-communaute-wpfr/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:79:\"Rejoignez-nous sur Flickr, et partagez vos souvenirs avec la communauté WPFR !\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:4:\"type\";s:4:\"html\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:0:\"\";s:7:\"attribs\";a:1:{s:0:\"\";a:2:{s:4:\"href\";s:93:\"https://wpfr.net/rejoignez-nous-sur-flickr-et-partagez-vos-souvenirs-avec-la-communaute-wpfr/\";s:3:\"rel\";s:9:\"alternate\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"updated\";a:1:{i:0;a:5:{s:4:\"data\";s:29:\"2025-06-24T06:25:00.000+00:00\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:9:\"published\";a:1:{i:0;a:5:{s:4:\"data\";s:29:\"2025-06-24T06:25:00.000+00:00\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"summary\";a:1:{i:0;a:5:{s:4:\"data\";s:144:\"Et si l’on prenait le temps de partager nos souvenirs avec l’ensemble de la communauté WordPress francophone ? À commencer par nos photos.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"content\";a:1:{i:0;a:5:{s:4:\"data\";s:6265:\"\n        <p><strong>Et si l’on prenait le temps de partager nos souvenirs avec l’ensemble de la communauté WordPress francophone ? À commencer par nos photos.</strong></p><p>Les évènements se suivent, et s’ils sont toujours vécus intensément par les bénévoles et les participants, ils laissent malheureusement assez peu de témoignages **dans notre communauté. Dommage, non ?</p><p>Pour remédier, en partie, à cela, l’Association WordPress Francophone (WPFR) a décidé de réactiver son vieux compte <strong>Flickr</strong> et d’en faire l’album photo de la communauté. Après un long temps pause – les derniers clichés partagés dataient des <a href=\"https://www.flickr.com/photos/wpfr/albums/72157707911635384\">WordCamp Bordeaux 2019</a> et <a href=\"https://www.flickr.com/photos/wpfr/albums/72177720307782299\">Paris 2023</a> – nous avons donc mis en ligne quelques photos des <a href=\"https://www.flickr.com/photos/wpfr/albums/72177720326656836\">Journées de Contribution de Rennes (2024)</a> et de <a href=\"https://www.flickr.com/photos/wpfr/albums/72177720326682139\">Toulouse (2025)</a>, ainsi que quelques images de <a href=\"https://wpfr.net/wpfr-revele-sa-nouvelle-identite-visuelle/\">notre nouvelle identité graphique</a> révélée en septembre dernier.</p><p class=\"has-pale-cyan-blue-background-color has-background\">Si vous êtes photographe d&rsquo;un meetup, WordCamp passé ou à venir ou d&rsquo;une Journée de Contribution, contactez-nous et nous vous aiderons à valoriser vos clichés pour une plus large diffusion !</p><p>Tout cela est consultable sur la page Flickr de l’association, à l’adresse : <a href=\"https://www.flickr.com/photos/wpfr/\">https://www.flickr.com/photos/wpfr/</a></p><p><strong>Mais ce n’est pas tout ! Parce que nous sommes un collectif, nous vous proposons également de participer à ce partage de souvenirs, <em>via</em> <a href=\"https://www.flickr.com/groups/commu_wpfr/\">un groupe Flickr dédié à la Communauté WordPress FR</a> !</strong> Un groupe dont vous pouvez déjà devenir membre et sur lequel vous pouvez, vous aussi, partager les photos des évènements – WordCamp, journées de contribution ou autres évènements – auxquels vous avez participé ! </p><ul class=\"wp-block-list\"><li>La démarche est simple : Il vous faut tout d’abord <strong>posséder un compte personnel sur Flickr</strong>. Si vous n’en avez pas déjà un, l’inscription à la plateforme ne prend que quelques instants. Tout se passe par ici : <a href=\"https://identity.flickr.com/sign-up\">https://identity.flickr.com/sign-up</a>.</li></ul><ul class=\"wp-block-list\"><li>Une fois votre compte créé, vous pouvez le personnaliser comme bon vous semble, et surtout <strong>y uploader vos dernières photos des évènements WordPress</strong>. Là encore, la manipulation est très simple : une icône en forme de Nuage est disponible dans la barre de navigation du site, en haut à droite de votre écran sur ordinateur. <strong>Cliquez simplement sur cette icône et suivez les instructions pour mettre vos photos en ligne.</strong> Veillez à les nommer et à les légender correctement, vous faciliterez ainsi leur consultation par le reste de la communauté.</li></ul><div class=\"wp-block-image\"><figure class=\"aligncenter size-full\"><img width=\"536\" height=\"104\" src=\"https://wpfr.net/wp-content/uploads/2025/06/WPFR_FlickrUpload.png\" alt=\"\" class=\"wp-image-2489719\" //></figure></div><div style=\"height:20px\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div><ul class=\"wp-block-list\"><li>Prochaine étape, <strong>rejoindre notre communauté sur Flickr</strong>. Tout est encore très simple : rendez-vous sur le groupe <strong>Communauté WordPress FR</strong> que nous avons créée, ici : <a href=\"https://www.flickr.com/groups/commu_wpfr/\">https://www.flickr.com/groups/commu_wpfr/</a>. Puis, cliquez sur le bouton <strong>Rejoindre</strong> situé juste à droite du nom du groupe. Rien de plus compliqué !</li></ul><div class=\"wp-block-image\"><figure class=\"aligncenter size-full\"><img width=\"937\" height=\"272\" src=\"https://wpfr.net/wp-content/uploads/2025/06/WPFR_FlickrJoin.png\" alt=\"\" class=\"wp-image-2489720\" //></figure></div><div style=\"height:20px\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div><ul class=\"wp-block-list\"><li>Il ne vous reste qu’à <strong>partager avec nous vos photos</strong> : Le bouton <strong>Ajouter une photo</strong> juste au-dessus de la galerie photo existante est là pour ça. Dans la fenêtre qui s’ouvre après avoir cliqué, vous pourrez sélectionner les photos issues de votre propre galerie que vous souhaitez partager avec nous.</li></ul><div class=\"wp-block-image\"><figure class=\"aligncenter size-large\"><img width=\"1024\" height=\"490\" src=\"https://wpfr.net/wp-content/uploads/2025/06/WPFR_FlickrAdd-1024x490.png\" alt=\"\" class=\"wp-image-2489721\" //></figure></div><div style=\"height:20px\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div><ul class=\"wp-block-list\"><li><strong>Voilà, c’est tout !</strong></li></ul><p>Si vous voulez en savoir plus sur l’utilisation des groupes Flickr, l’aide du site est très bien faite également, mais disponible uniquement en anglais :</p><ul class=\"wp-block-list\"><li><strong>Find and join de Flickr group</strong> : <a href=\"https://www.flickrhelp.com/hc/en-us/articles/4404064539540-Find-and-join-a-Flickr-group\">https://www.flickrhelp.com/hc/en-us/articles/4404064539540-Find-and-join-a-Flickr-group</a></li>\n\n<li><strong>Add or remove photos in Flickr groups </strong>: <a href=\"https://www.flickrhelp.com/hc/en-us/articles/4404069536532-Add-or-remove-photos-in-Flickr-groups\">https://www.flickrhelp.com/hc/en-us/articles/4404069536532-Add-or-remove-photos-in-Flickr-groups</a></li></ul><p>On attend vos photos et vos partages ! Et n’hésitez pas à nous prévenir, en nous faisant un coucou sur <a href=\"http://wordpressfr.slack.com\"><strong>le Slack communautaire public</strong></a> (canal <a href=\"https://wordpressfr.slack.com/archives/C29S9GN3A\"><strong>#wpfr</strong></a>) ou <a href=\"https://www.linkedin.com/company/assowpfr/\"><strong>la page LinkedIn</strong></a> de l’association quand vous aurez partagé vos plus beaux clichés.</p><p>À très vite !</p>\n    \";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:4:\"type\";s:4:\"html\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:6:\"author\";a:1:{i:0;a:6:{s:4:\"data\";s:46:\"\n            \n                                \";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:27:\"http://www.w3.org/2005/Atom\";a:1:{s:4:\"name\";a:1:{i:0;a:5:{s:4:\"data\";s:16:\"François Houste\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}}s:6:\"source\";a:1:{i:0;a:6:{s:4:\"data\";s:67:\"\n                    \n                            \n                \";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:27:\"http://www.w3.org/2005/Atom\";a:2:{s:2:\"id\";a:1:{i:0;a:5:{s:4:\"data\";s:33:\"https://wpfr.net/actualites/feed/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:4:\"WPFR\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}}}}}}}}}}}}s:4:\"type\";i:512;s:7:\"headers\";O:48:\"WpOrg\\Requests\\Utility\\CaseInsensitiveDictionary\":1:{s:7:\"\0*\0data\";a:11:{s:4:\"date\";s:29:\"Fri, 24 Oct 2025 19:04:58 GMT\";s:12:\"content-type\";s:20:\"application/atom+xml\";s:4:\"vary\";s:15:\"Accept-Encoding\";s:4:\"link\";s:64:\"<https://fluxplanet.wpfr.net/wp-json/>; rel=\"https://api.w.org/\"\";s:13:\"cache-control\";s:35:\"no-cache, no-store, must-revalidate\";s:6:\"pragma\";s:8:\"no-cache\";s:7:\"expires\";s:1:\"0\";s:13:\"last-modified\";s:29:\"Tue, 22 Jul 2025 21:51:07 GMT\";s:4:\"etag\";s:36:\"W/\"072268436a8b47633210153ceb845bac\"\";s:6:\"server\";s:22:\"o2switch-PowerBoost-v3\";s:16:\"content-encoding\";s:4:\"gzip\";}}s:5:\"build\";i:1727751020;s:21:\"cache_expiration_time\";i:1761375898;s:23:\"__cache_expiration_time\";i:1761375898;}", "off");
INSERT INTO `inter_options` VALUES("2164", "_transient_timeout_feed_mod_b0b1001e5bc3fbacad8b49ec075d19a5", "1761375898", "off");
INSERT INTO `inter_options` VALUES("2165", "_transient_feed_mod_b0b1001e5bc3fbacad8b49ec075d19a5", "1761332698", "off");
INSERT INTO `inter_options` VALUES("2166", "_transient_timeout_dash_v2_bd94b8f41e74bae2f4dc72e9bd8379af", "1761375898", "off");
INSERT INTO `inter_options` VALUES("2167", "_transient_dash_v2_bd94b8f41e74bae2f4dc72e9bd8379af", "<div class=\"rss-widget\"><ul><li><a class=\'rsswidget\' href=\'https://fr.wordpress.org/2025/07/11/arret-des-mises-a-jour-de-securite-pour-les-versions-4-1-a-4-6-de-wordpress/\'>Arrêt des mises à jour de sécurité pour les versions 4.1 à 4.6 de WordPress</a></li><li><a class=\'rsswidget\' href=\'https://fr.wordpress.org/2025/04/28/rendez-vous-a-bale-pour-le-wordcamp-europe-2025/\'>Rendez-vous à Bâle pour le WordCamp Europe 2025 !</a></li></ul></div><div class=\"rss-widget\"><ul><li><a class=\'rsswidget\' href=\'https://blog.o2switch.fr/site-wordpress-multilingue-installer-et-configurer-lextension-polylang-1/\'>Site WordPress multilingue : Installer et configurer l’extension Polylang (Partie 1)</a></li><li><a class=\'rsswidget\' href=\'https://vincentdubroeucq.com/comprendre-les-hooks-de-wordpress/\'>Comprendre les hooks de WordPress</a></li><li><a class=\'rsswidget\' href=\'https://wpmarmite.com/meilleurs-plugins-wordpress/\'>Les 25 meilleurs plugins WordPress (édition 2025)</a></li></ul></div>", "off");

/* INSERT TABLE DATA: inter_postmeta */
INSERT INTO `inter_postmeta` VALUES("1", "2", "_wp_page_template", "default");
INSERT INTO `inter_postmeta` VALUES("2", "3", "_wp_page_template", "pages/confidentiality.php");
INSERT INTO `inter_postmeta` VALUES("4", "2", "_edit_lock", "1758652863:1");
INSERT INTO `inter_postmeta` VALUES("5", "1", "_edit_lock", "1758652866:1");
INSERT INTO `inter_postmeta` VALUES("9", "14", "_edit_lock", "1759950307:1");
INSERT INTO `inter_postmeta` VALUES("10", "16", "_edit_lock", "1759592977:1");
INSERT INTO `inter_postmeta` VALUES("11", "16", "_wp_trash_meta_status", "publish");
INSERT INTO `inter_postmeta` VALUES("12", "16", "_wp_trash_meta_time", "1759593131");
INSERT INTO `inter_postmeta` VALUES("13", "16", "_wp_desired_post_slug", "mon-profil-2");
INSERT INTO `inter_postmeta` VALUES("14", "14", "_edit_last", "1");
INSERT INTO `inter_postmeta` VALUES("15", "14", "_wp_page_template", "pages/subscriber-profil.php");
INSERT INTO `inter_postmeta` VALUES("16", "18", "_wp_attached_file", "2025/10/check-box.png");
INSERT INTO `inter_postmeta` VALUES("17", "18", "_wp_attachment_metadata", "a:6:{s:5:\"width\";i:512;s:6:\"height\";i:512;s:4:\"file\";s:21:\"2025/10/check-box.png\";s:8:\"filesize\";i:8093;s:5:\"sizes\";a:2:{s:6:\"medium\";a:5:{s:4:\"file\";s:21:\"check-box-300x300.png\";s:5:\"width\";i:300;s:6:\"height\";i:300;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:4806;}s:9:\"thumbnail\";a:5:{s:4:\"file\";s:21:\"check-box-150x150.png\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:2036;}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `inter_postmeta` VALUES("19", "23", "_edit_lock", "1759770623:1");
INSERT INTO `inter_postmeta` VALUES("20", "27", "_edit_lock", "1759597262:1");
INSERT INTO `inter_postmeta` VALUES("21", "27", "_edit_last", "1");
INSERT INTO `inter_postmeta` VALUES("22", "27", "_wp_page_template", "pages/subscriber-login.php");
INSERT INTO `inter_postmeta` VALUES("23", "27", "_wp_trash_meta_status", "publish");
INSERT INTO `inter_postmeta` VALUES("24", "27", "_wp_trash_meta_time", "1759597450");
INSERT INTO `inter_postmeta` VALUES("25", "27", "_wp_desired_post_slug", "connexion");
INSERT INTO `inter_postmeta` VALUES("28", "34", "_edit_lock", "1759603381:1");
INSERT INTO `inter_postmeta` VALUES("29", "34", "_edit_last", "1");
INSERT INTO `inter_postmeta` VALUES("30", "34", "_wp_page_template", "pages/subscriber-login.php");
INSERT INTO `inter_postmeta` VALUES("31", "42", "origin", "theme");
INSERT INTO `inter_postmeta` VALUES("33", "48", "is_wp_suggestion", "");
INSERT INTO `inter_postmeta` VALUES("34", "23", "_wp_page_template", "pages/home.php");
INSERT INTO `inter_postmeta` VALUES("36", "51", "is_wp_suggestion", "");
INSERT INTO `inter_postmeta` VALUES("38", "55", "_wp_attached_file", "2025/10/pexels-kyleloftusstudios-3379934-scaled.jpg");
INSERT INTO `inter_postmeta` VALUES("39", "55", "_wp_attachment_metadata", "a:7:{s:5:\"width\";i:2560;s:6:\"height\";i:1706;s:4:\"file\";s:51:\"2025/10/pexels-kyleloftusstudios-3379934-scaled.jpg\";s:8:\"filesize\";i:153213;s:5:\"sizes\";a:6:{s:6:\"medium\";a:5:{s:4:\"file\";s:44:\"pexels-kyleloftusstudios-3379934-300x200.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:4963;}s:5:\"large\";a:5:{s:4:\"file\";s:45:\"pexels-kyleloftusstudios-3379934-1024x683.jpg\";s:5:\"width\";i:1024;s:6:\"height\";i:683;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:29632;}s:9:\"thumbnail\";a:5:{s:4:\"file\";s:44:\"pexels-kyleloftusstudios-3379934-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:3164;}s:12:\"medium_large\";a:5:{s:4:\"file\";s:44:\"pexels-kyleloftusstudios-3379934-768x512.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:512;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:18611;}s:9:\"1536x1536\";a:5:{s:4:\"file\";s:46:\"pexels-kyleloftusstudios-3379934-1536x1024.jpg\";s:5:\"width\";i:1536;s:6:\"height\";i:1024;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:58835;}s:9:\"2048x2048\";a:5:{s:4:\"file\";s:46:\"pexels-kyleloftusstudios-3379934-2048x1365.jpg\";s:5:\"width\";i:2048;s:6:\"height\";i:1365;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:100697;}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}s:14:\"original_image\";s:36:\"pexels-kyleloftusstudios-3379934.jpg\";}");
INSERT INTO `inter_postmeta` VALUES("40", "23", "_edit_last", "1");
INSERT INTO `inter_postmeta` VALUES("41", "57", "_edit_lock", "1759768722:1");
INSERT INTO `inter_postmeta` VALUES("42", "57", "_edit_last", "1");
INSERT INTO `inter_postmeta` VALUES("43", "57", "_wp_page_template", "pages/subscribe.php");
INSERT INTO `inter_postmeta` VALUES("44", "2", "_wp_trash_meta_status", "publish");
INSERT INTO `inter_postmeta` VALUES("45", "2", "_wp_trash_meta_time", "1759768932");
INSERT INTO `inter_postmeta` VALUES("46", "2", "_wp_desired_post_slug", "page-d-exemple");
INSERT INTO `inter_postmeta` VALUES("51", "63", "_edit_lock", "1759855270:1");
INSERT INTO `inter_postmeta` VALUES("52", "63", "_edit_last", "1");
INSERT INTO `inter_postmeta` VALUES("53", "63", "_wp_page_template", "pages/forget-password.php");
INSERT INTO `inter_postmeta` VALUES("54", "65", "_edit_lock", "1759864679:1");
INSERT INTO `inter_postmeta` VALUES("59", "65", "_wp_trash_meta_status", "publish");
INSERT INTO `inter_postmeta` VALUES("60", "65", "_wp_trash_meta_time", "1759871838");
INSERT INTO `inter_postmeta` VALUES("61", "65", "_wp_desired_post_slug", "test-test-test");
INSERT INTO `inter_postmeta` VALUES("62", "1", "_wp_trash_meta_status", "publish");
INSERT INTO `inter_postmeta` VALUES("63", "1", "_wp_trash_meta_time", "1759871839");
INSERT INTO `inter_postmeta` VALUES("64", "1", "_wp_desired_post_slug", "bonjour-tout-le-monde");
INSERT INTO `inter_postmeta` VALUES("65", "1", "_wp_trash_meta_comments_status", "a:1:{i:1;s:1:\"1\";}");
INSERT INTO `inter_postmeta` VALUES("69", "71", "_edit_lock", "1759872236:1");
INSERT INTO `inter_postmeta` VALUES("70", "71", "_edit_last", "1");
INSERT INTO `inter_postmeta` VALUES("71", "71", "_wp_page_template", "pages/departement.php");
INSERT INTO `inter_postmeta` VALUES("72", "71", "_wp_trash_meta_status", "publish");
INSERT INTO `inter_postmeta` VALUES("73", "71", "_wp_trash_meta_time", "1759872258");
INSERT INTO `inter_postmeta` VALUES("74", "71", "_wp_desired_post_slug", "metier");
INSERT INTO `inter_postmeta` VALUES("75", "74", "_edit_lock", "1759941654:1");
INSERT INTO `inter_postmeta` VALUES("76", "74", "_edit_last", "1");
INSERT INTO `inter_postmeta` VALUES("77", "74", "_wp_page_template", "pages/subscribe.php");
INSERT INTO `inter_postmeta` VALUES("78", "77", "_edit_lock", "1759950326:1");
INSERT INTO `inter_postmeta` VALUES("79", "77", "_edit_last", "1");
INSERT INTO `inter_postmeta` VALUES("80", "77", "_wp_page_template", "pages/subscriber-edit.php");
INSERT INTO `inter_postmeta` VALUES("81", "79", "_edit_lock", "1760972387:1");
INSERT INTO `inter_postmeta` VALUES("82", "79", "_edit_last", "1");
INSERT INTO `inter_postmeta` VALUES("83", "79", "_wp_page_template", "pages/mobile-bloque.php");
INSERT INTO `inter_postmeta` VALUES("84", "81", "_wp_attached_file", "2025/10/focus-antilles.png");
INSERT INTO `inter_postmeta` VALUES("85", "81", "_wp_attachment_metadata", "a:6:{s:5:\"width\";i:500;s:6:\"height\";i:500;s:4:\"file\";s:26:\"2025/10/focus-antilles.png\";s:8:\"filesize\";i:21680;s:5:\"sizes\";a:2:{s:6:\"medium\";a:5:{s:4:\"file\";s:26:\"focus-antilles-300x300.png\";s:5:\"width\";i:300;s:6:\"height\";i:300;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:15393;}s:9:\"thumbnail\";a:5:{s:4:\"file\";s:26:\"focus-antilles-150x150.png\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:6595;}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `inter_postmeta` VALUES("86", "82", "_wp_attached_file", "2025/10/cropped-focus-antilles.png");
INSERT INTO `inter_postmeta` VALUES("87", "82", "_wp_attachment_context", "site-icon");
INSERT INTO `inter_postmeta` VALUES("88", "82", "_wp_attachment_metadata", "a:6:{s:5:\"width\";i:512;s:6:\"height\";i:512;s:4:\"file\";s:34:\"2025/10/cropped-focus-antilles.png\";s:8:\"filesize\";i:32947;s:5:\"sizes\";a:6:{s:6:\"medium\";a:5:{s:4:\"file\";s:34:\"cropped-focus-antilles-300x300.png\";s:5:\"width\";i:300;s:6:\"height\";i:300;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:18116;}s:9:\"thumbnail\";a:5:{s:4:\"file\";s:34:\"cropped-focus-antilles-150x150.png\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:7222;}s:13:\"site_icon-270\";a:5:{s:4:\"file\";s:34:\"cropped-focus-antilles-270x270.png\";s:5:\"width\";i:270;s:6:\"height\";i:270;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:15730;}s:13:\"site_icon-192\";a:5:{s:4:\"file\";s:34:\"cropped-focus-antilles-192x192.png\";s:5:\"width\";i:192;s:6:\"height\";i:192;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:9939;}s:13:\"site_icon-180\";a:5:{s:4:\"file\";s:34:\"cropped-focus-antilles-180x180.png\";s:5:\"width\";i:180;s:6:\"height\";i:180;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:9229;}s:12:\"site_icon-32\";a:5:{s:4:\"file\";s:32:\"cropped-focus-antilles-32x32.png\";s:5:\"width\";i:32;s:6:\"height\";i:32;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:972;}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `inter_postmeta` VALUES("89", "83", "_wp_attached_file", "2025/10/2.png");
INSERT INTO `inter_postmeta` VALUES("90", "83", "_wp_attachment_metadata", "a:6:{s:5:\"width\";i:500;s:6:\"height\";i:500;s:4:\"file\";s:13:\"2025/10/2.png\";s:8:\"filesize\";i:21927;s:5:\"sizes\";a:2:{s:6:\"medium\";a:5:{s:4:\"file\";s:13:\"2-300x300.png\";s:5:\"width\";i:300;s:6:\"height\";i:300;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:15423;}s:9:\"thumbnail\";a:5:{s:4:\"file\";s:13:\"2-150x150.png\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:6659;}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `inter_postmeta` VALUES("91", "84", "_wp_attached_file", "2025/10/3.png");
INSERT INTO `inter_postmeta` VALUES("92", "84", "_wp_attachment_metadata", "a:6:{s:5:\"width\";i:500;s:6:\"height\";i:500;s:4:\"file\";s:13:\"2025/10/3.png\";s:8:\"filesize\";i:21064;s:5:\"sizes\";a:2:{s:6:\"medium\";a:5:{s:4:\"file\";s:13:\"3-300x300.png\";s:5:\"width\";i:300;s:6:\"height\";i:300;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:14399;}s:9:\"thumbnail\";a:5:{s:4:\"file\";s:13:\"3-150x150.png\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:6364;}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `inter_postmeta` VALUES("93", "85", "_wp_attached_file", "2025/10/4.png");
INSERT INTO `inter_postmeta` VALUES("94", "85", "_wp_attachment_metadata", "a:6:{s:5:\"width\";i:500;s:6:\"height\";i:500;s:4:\"file\";s:13:\"2025/10/4.png\";s:8:\"filesize\";i:20043;s:5:\"sizes\";a:2:{s:6:\"medium\";a:5:{s:4:\"file\";s:13:\"4-300x300.png\";s:5:\"width\";i:300;s:6:\"height\";i:300;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:13538;}s:9:\"thumbnail\";a:5:{s:4:\"file\";s:13:\"4-150x150.png\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:6041;}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `inter_postmeta` VALUES("95", "86", "_wp_attached_file", "2025/10/5.png");
INSERT INTO `inter_postmeta` VALUES("96", "86", "_wp_attachment_metadata", "a:6:{s:5:\"width\";i:500;s:6:\"height\";i:500;s:4:\"file\";s:13:\"2025/10/5.png\";s:8:\"filesize\";i:21075;s:5:\"sizes\";a:2:{s:6:\"medium\";a:5:{s:4:\"file\";s:13:\"5-300x300.png\";s:5:\"width\";i:300;s:6:\"height\";i:300;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:14225;}s:9:\"thumbnail\";a:5:{s:4:\"file\";s:13:\"5-150x150.png\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:6335;}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `inter_postmeta` VALUES("97", "87", "_wp_attached_file", "2025/10/focus-antilles-1.png");
INSERT INTO `inter_postmeta` VALUES("98", "87", "_wp_attachment_metadata", "a:6:{s:5:\"width\";i:500;s:6:\"height\";i:500;s:4:\"file\";s:28:\"2025/10/focus-antilles-1.png\";s:8:\"filesize\";i:21680;s:5:\"sizes\";a:2:{s:6:\"medium\";a:5:{s:4:\"file\";s:28:\"focus-antilles-1-300x300.png\";s:5:\"width\";i:300;s:6:\"height\";i:300;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:15393;}s:9:\"thumbnail\";a:5:{s:4:\"file\";s:28:\"focus-antilles-1-150x150.png\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:6595;}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `inter_postmeta` VALUES("99", "88", "_wp_attached_file", "2025/10/1.png");
INSERT INTO `inter_postmeta` VALUES("100", "88", "_wp_attachment_metadata", "a:6:{s:5:\"width\";i:500;s:6:\"height\";i:500;s:4:\"file\";s:13:\"2025/10/1.png\";s:8:\"filesize\";i:21680;s:5:\"sizes\";a:2:{s:6:\"medium\";a:5:{s:4:\"file\";s:13:\"1-300x300.png\";s:5:\"width\";i:300;s:6:\"height\";i:300;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:15393;}s:9:\"thumbnail\";a:5:{s:4:\"file\";s:13:\"1-150x150.png\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:6595;}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `inter_postmeta` VALUES("101", "89", "_wp_attached_file", "2025/10/2-1.png");
INSERT INTO `inter_postmeta` VALUES("102", "89", "_wp_attachment_metadata", "a:6:{s:5:\"width\";i:500;s:6:\"height\";i:500;s:4:\"file\";s:15:\"2025/10/2-1.png\";s:8:\"filesize\";i:16547;s:5:\"sizes\";a:2:{s:6:\"medium\";a:5:{s:4:\"file\";s:15:\"2-1-300x300.png\";s:5:\"width\";i:300;s:6:\"height\";i:300;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:11616;}s:9:\"thumbnail\";a:5:{s:4:\"file\";s:15:\"2-1-150x150.png\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:5215;}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `inter_postmeta` VALUES("103", "90", "_wp_attached_file", "2025/10/3-1.png");
INSERT INTO `inter_postmeta` VALUES("104", "90", "_wp_attachment_metadata", "a:6:{s:5:\"width\";i:500;s:6:\"height\";i:500;s:4:\"file\";s:15:\"2025/10/3-1.png\";s:8:\"filesize\";i:19253;s:5:\"sizes\";a:2:{s:6:\"medium\";a:5:{s:4:\"file\";s:15:\"3-1-300x300.png\";s:5:\"width\";i:300;s:6:\"height\";i:300;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:13654;}s:9:\"thumbnail\";a:5:{s:4:\"file\";s:15:\"3-1-150x150.png\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:5959;}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `inter_postmeta` VALUES("105", "91", "_wp_attached_file", "2025/10/4-1.png");
INSERT INTO `inter_postmeta` VALUES("106", "91", "_wp_attachment_metadata", "a:6:{s:5:\"width\";i:500;s:6:\"height\";i:500;s:4:\"file\";s:15:\"2025/10/4-1.png\";s:8:\"filesize\";i:17011;s:5:\"sizes\";a:2:{s:6:\"medium\";a:5:{s:4:\"file\";s:15:\"4-1-300x300.png\";s:5:\"width\";i:300;s:6:\"height\";i:300;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:11841;}s:9:\"thumbnail\";a:5:{s:4:\"file\";s:15:\"4-1-150x150.png\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:5291;}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `inter_postmeta` VALUES("107", "92", "_wp_attached_file", "2025/10/5-1.png");
INSERT INTO `inter_postmeta` VALUES("108", "92", "_wp_attachment_metadata", "a:6:{s:5:\"width\";i:500;s:6:\"height\";i:500;s:4:\"file\";s:15:\"2025/10/5-1.png\";s:8:\"filesize\";i:21927;s:5:\"sizes\";a:2:{s:6:\"medium\";a:5:{s:4:\"file\";s:15:\"5-1-300x300.png\";s:5:\"width\";i:300;s:6:\"height\";i:300;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:15423;}s:9:\"thumbnail\";a:5:{s:4:\"file\";s:15:\"5-1-150x150.png\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:6659;}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `inter_postmeta` VALUES("109", "93", "_wp_attached_file", "2025/10/6.png");
INSERT INTO `inter_postmeta` VALUES("110", "93", "_wp_attachment_metadata", "a:6:{s:5:\"width\";i:500;s:6:\"height\";i:500;s:4:\"file\";s:13:\"2025/10/6.png\";s:8:\"filesize\";i:20243;s:5:\"sizes\";a:2:{s:6:\"medium\";a:5:{s:4:\"file\";s:13:\"6-300x300.png\";s:5:\"width\";i:300;s:6:\"height\";i:300;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:14774;}s:9:\"thumbnail\";a:5:{s:4:\"file\";s:13:\"6-150x150.png\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:6426;}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `inter_postmeta` VALUES("111", "94", "_wp_attached_file", "2025/10/cropped-2-1.png");
INSERT INTO `inter_postmeta` VALUES("112", "94", "_wp_attachment_context", "site-icon");
INSERT INTO `inter_postmeta` VALUES("113", "94", "_wp_attachment_metadata", "a:6:{s:5:\"width\";i:512;s:6:\"height\";i:512;s:4:\"file\";s:23:\"2025/10/cropped-2-1.png\";s:8:\"filesize\";i:24201;s:5:\"sizes\";a:6:{s:6:\"medium\";a:5:{s:4:\"file\";s:23:\"cropped-2-1-300x300.png\";s:5:\"width\";i:300;s:6:\"height\";i:300;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:13493;}s:9:\"thumbnail\";a:5:{s:4:\"file\";s:23:\"cropped-2-1-150x150.png\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:5573;}s:13:\"site_icon-270\";a:5:{s:4:\"file\";s:23:\"cropped-2-1-270x270.png\";s:5:\"width\";i:270;s:6:\"height\";i:270;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:11650;}s:13:\"site_icon-192\";a:5:{s:4:\"file\";s:23:\"cropped-2-1-192x192.png\";s:5:\"width\";i:192;s:6:\"height\";i:192;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:7456;}s:13:\"site_icon-180\";a:5:{s:4:\"file\";s:23:\"cropped-2-1-180x180.png\";s:5:\"width\";i:180;s:6:\"height\";i:180;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:6919;}s:12:\"site_icon-32\";a:5:{s:4:\"file\";s:21:\"cropped-2-1-32x32.png\";s:5:\"width\";i:32;s:6:\"height\";i:32;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:1057;}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `inter_postmeta` VALUES("114", "96", "_wp_font_face_file", "fonnts.com-Roca_Two_Bold.ttf");
INSERT INTO `inter_postmeta` VALUES("115", "100", "_edit_lock", "1761066711:1");
INSERT INTO `inter_postmeta` VALUES("116", "102", "origin", "theme");
INSERT INTO `inter_postmeta` VALUES("117", "100", "_wp_trash_meta_status", "publish");
INSERT INTO `inter_postmeta` VALUES("118", "100", "_wp_trash_meta_time", "1761066736");
INSERT INTO `inter_postmeta` VALUES("119", "100", "_wp_desired_post_slug", "test");
INSERT INTO `inter_postmeta` VALUES("120", "3", "_edit_last", "1");
INSERT INTO `inter_postmeta` VALUES("121", "3", "_edit_lock", "1761153615:1");

/* INSERT TABLE DATA: inter_posts */
INSERT INTO `inter_posts` VALUES("1", "1", "2025-09-23 20:25:50", "2025-09-23 18:25:50", "<!-- wp:paragraph -->\n<p>Bienvenue sur WordPress. Ceci est votre premier article. Modifiez-le ou supprimez-le, puis commencez à écrire !</p>\n<!-- /wp:paragraph -->", "Bonjour tout le monde !", "", "trash", "open", "open", "", "bonjour-tout-le-monde__trashed", "", "", "2025-10-07 23:17:19", "2025-10-07 21:17:19", "", "0", "http://localhost:8888/intermitent_site/?p=1", "0", "post", "", "1");
INSERT INTO `inter_posts` VALUES("2", "1", "2025-09-23 20:25:50", "2025-09-23 18:25:50", "<!-- wp:paragraph -->\n<p>Ceci est une page d’exemple. C’est différent d’un article de blog parce qu’elle restera au même endroit et apparaîtra dans la navigation de votre site (dans la plupart des thèmes). La plupart des gens commencent par une page « À propos » qui les présente aux personnes visitant le site. Cela pourrait ressembler à quelque chose comme cela :</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:quote -->\n<blockquote class=\"wp-block-quote\"><p>Bonjour ! Je suis un mécanicien qui aspire à devenir acteur, et voici mon site. J’habite à Bordeaux, j’ai un super chien baptisé Russell, et j’aime la vodka (ainsi qu’être surpris par la pluie soudaine lors de longues balades sur la plage au coucher du soleil).</p></blockquote>\n<!-- /wp:quote -->\n\n<!-- wp:paragraph -->\n<p>…ou quelque chose comme cela :</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:quote -->\n<blockquote class=\"wp-block-quote\"><p>La société 123 Machin Truc a été créée en 1971, et n’a cessé de proposer au public des machins-trucs de qualité depuis lors. Située à Saint-Remy-en-Bouzemont-Saint-Genest-et-Isson, 123 Machin Truc emploie 2 000 personnes, et fabrique toutes sortes de bidules supers pour la communauté bouzemontoise.</p></blockquote>\n<!-- /wp:quote -->\n\n<!-- wp:paragraph -->\n<p>En tant que nouvel utilisateur ou utilisatrice de WordPress, vous devriez vous rendre sur <a href=\"http://localhost:8888/intermitent_site/wp-admin/\">votre tableau de bord</a> pour supprimer cette page et créer de nouvelles pages pour votre contenu. Amusez-vous bien !</p>\n<!-- /wp:paragraph -->", "Page d’exemple", "", "trash", "closed", "open", "", "page-d-exemple__trashed", "", "", "2025-10-06 18:42:12", "2025-10-06 16:42:12", "", "0", "http://localhost:8888/intermitent_site/?page_id=2", "0", "page", "", "0");
INSERT INTO `inter_posts` VALUES("3", "1", "2025-09-23 20:25:50", "2025-09-23 18:25:50", "<!-- wp:heading -->\n<h2 class=\"wp-block-heading\">Qui sommes-nous ?</h2>\n<!-- /wp:heading -->\n<!-- wp:paragraph -->\n<p><strong class=\"privacy-policy-tutorial\">Texte suggéré : </strong>L’adresse de notre site est : http://localhost:8888/intermitent_site.</p>\n<!-- /wp:paragraph -->\n<!-- wp:heading -->\n<h2 class=\"wp-block-heading\">Commentaires</h2>\n<!-- /wp:heading -->\n<!-- wp:paragraph -->\n<p><strong class=\"privacy-policy-tutorial\">Texte suggéré : </strong>Quand vous laissez un commentaire sur notre site, les données inscrites dans le formulaire de commentaire, ainsi que votre adresse IP et l’agent utilisateur de votre navigateur sont collectés pour nous aider à la détection des commentaires indésirables.</p>\n<!-- /wp:paragraph -->\n<!-- wp:paragraph -->\n<p>Une chaîne anonymisée créée à partir de votre adresse e-mail (également appelée hash) peut être envoyée au service Gravatar pour vérifier si vous utilisez ce dernier. Les clauses de confidentialité du service Gravatar sont disponibles ici : https://automattic.com/privacy/. Après validation de votre commentaire, votre photo de profil sera visible publiquement à coté de votre commentaire.</p>\n<!-- /wp:paragraph -->\n<!-- wp:heading -->\n<h2 class=\"wp-block-heading\">Médias</h2>\n<!-- /wp:heading -->\n<!-- wp:paragraph -->\n<p><strong class=\"privacy-policy-tutorial\">Texte suggéré : </strong>Si vous téléversez des images sur le site, nous vous conseillons d’éviter de téléverser des images contenant des données EXIF de coordonnées GPS. Les personnes visitant votre site peuvent télécharger et extraire des données de localisation depuis ces images.</p>\n<!-- /wp:paragraph -->\n<!-- wp:heading -->\n<h2 class=\"wp-block-heading\">Cookies</h2>\n<!-- /wp:heading -->\n<!-- wp:paragraph -->\n<p><strong class=\"privacy-policy-tutorial\">Texte suggéré : </strong>Si vous déposez un commentaire sur notre site, il vous sera proposé d’enregistrer votre nom, adresse e-mail et site dans des cookies. C’est uniquement pour votre confort afin de ne pas avoir à saisir ces informations si vous déposez un autre commentaire plus tard. Ces cookies expirent au bout d’un an.</p>\n<!-- /wp:paragraph -->\n<!-- wp:paragraph -->\n<p>Si vous vous rendez sur la page de connexion, un cookie temporaire sera créé afin de déterminer si votre navigateur accepte les cookies. Il ne contient pas de données personnelles et sera supprimé automatiquement à la fermeture de votre navigateur.</p>\n<!-- /wp:paragraph -->\n<!-- wp:paragraph -->\n<p>Lorsque vous vous connecterez, nous mettrons en place un certain nombre de cookies pour enregistrer vos informations de connexion et vos préférences d’écran. La durée de vie d’un cookie de connexion est de deux jours, celle d’un cookie d’option d’écran est d’un an. Si vous cochez « Se souvenir de moi », votre cookie de connexion sera conservé pendant deux semaines. Si vous vous déconnectez de votre compte, le cookie de connexion sera effacé.</p>\n<!-- /wp:paragraph -->\n<!-- wp:paragraph -->\n<p>En modifiant ou en publiant une publication, un cookie supplémentaire sera enregistré dans votre navigateur. Ce cookie ne comprend aucune donnée personnelle. Il indique simplement l’ID de la publication que vous venez de modifier. Il expire au bout d’un jour.</p>\n<!-- /wp:paragraph -->\n<!-- wp:heading -->\n<h2 class=\"wp-block-heading\">Contenu embarqué depuis d’autres sites</h2>\n<!-- /wp:heading -->\n<!-- wp:paragraph -->\n<p><strong class=\"privacy-policy-tutorial\">Texte suggéré : </strong>Les articles de ce site peuvent inclure des contenus intégrés (par exemple des vidéos, images, articles…). Le contenu intégré depuis d’autres sites se comporte de la même manière que si le visiteur se rendait sur cet autre site.</p>\n<!-- /wp:paragraph -->\n<!-- wp:paragraph -->\n<p>Ces sites web pourraient collecter des données sur vous, utiliser des cookies, embarquer des outils de suivis tiers, suivre vos interactions avec ces contenus embarqués si vous disposez d’un compte connecté sur leur site web.</p>\n<!-- /wp:paragraph -->\n<!-- wp:heading -->\n<h2 class=\"wp-block-heading\">Utilisation et transmission de vos données personnelles</h2>\n<!-- /wp:heading -->\n<!-- wp:paragraph -->\n<p><strong class=\"privacy-policy-tutorial\">Texte suggéré : </strong>Si vous demandez une réinitialisation de votre mot de passe, votre adresse IP sera incluse dans l’e-mail de réinitialisation.</p>\n<!-- /wp:paragraph -->\n<!-- wp:heading -->\n<h2 class=\"wp-block-heading\">Durées de stockage de vos données</h2>\n<!-- /wp:heading -->\n<!-- wp:paragraph -->\n<p><strong class=\"privacy-policy-tutorial\">Texte suggéré : </strong>Si vous laissez un commentaire, le commentaire et ses métadonnées sont conservés indéfiniment. Cela permet de reconnaître et approuver automatiquement les commentaires suivants au lieu de les laisser dans la file de modération.</p>\n<!-- /wp:paragraph -->\n<!-- wp:paragraph -->\n<p>Pour les comptes qui s’inscrivent sur notre site (le cas échéant), nous stockons également les données personnelles indiquées dans leur profil. Tous les comptes peuvent voir, modifier ou supprimer leurs informations personnelles à tout moment (à l’exception de leur identifiant). Les gestionnaires du site peuvent aussi voir et modifier ces informations.</p>\n<!-- /wp:paragraph -->\n<!-- wp:heading -->\n<h2 class=\"wp-block-heading\">Les droits que vous avez sur vos données</h2>\n<!-- /wp:heading -->\n<!-- wp:paragraph -->\n<p><strong class=\"privacy-policy-tutorial\">Texte suggéré : </strong>Si vous avez un compte ou si vous avez laissé des commentaires sur le site, vous pouvez demander à recevoir un fichier contenant toutes les données personnelles que nous possédons à votre sujet, incluant celles que vous nous avez fournies. Vous pouvez également demander la suppression des données personnelles vous concernant. Cela ne prend pas en compte les données stockées à des fins administratives, légales ou pour des raisons de sécurité.</p>\n<!-- /wp:paragraph -->\n<!-- wp:heading -->\n<h2 class=\"wp-block-heading\">Où vos données sont envoyées</h2>\n<!-- /wp:heading -->\n<!-- wp:paragraph -->\n<p><strong class=\"privacy-policy-tutorial\">Texte suggéré : </strong>Les commentaires des visiteurs peuvent être vérifiés à l’aide d’un service automatisé de détection des commentaires indésirables.</p>\n<!-- /wp:paragraph -->\n", "Politique de confidentialité", "", "publish", "closed", "closed", "", "politique-de-confidentialite", "", "", "2025-10-22 19:20:15", "2025-10-22 17:20:15", "", "0", "http://localhost:8888/intermitent_site/?page_id=3", "0", "page", "", "0");
INSERT INTO `inter_posts` VALUES("4", "0", "2025-09-23 20:25:50", "2025-09-23 18:25:50", "<!-- wp:navigation-link {\"label\":\"Connexion\",\"type\":\"page\",\"id\":34,\"url\":\"http://localhost:8888/intermitent_site/index.php/connexion/\",\"kind\":\"post-type\"} /-->\n\n<!-- wp:navigation-link {\"label\":\"Home\",\"type\":\"page\",\"id\":23,\"url\":\"http://localhost:8888/intermitent_site/index.php/home/\",\"kind\":\"post-type\"} /-->\n\n<!-- wp:navigation-link {\"label\":\"Mon profil\",\"type\":\"page\",\"id\":14,\"url\":\"http://localhost:8888/intermitent_site/index.php/mon-profil/\",\"kind\":\"post-type\"} /-->\n\n<!-- wp:navigation-link {\"label\":\"Page d’exemple\",\"type\":\"page\",\"id\":2,\"url\":\"http://localhost:8888/intermitent_site/index.php/page-d-exemple/\",\"kind\":\"post-type\"} /-->", "Navigation", "", "publish", "closed", "closed", "", "navigation", "", "", "2025-10-04 19:21:32", "2025-10-04 17:21:32", "", "0", "http://localhost:8888/intermitent_site/index.php/2025/09/23/navigation/", "0", "wp_navigation", "", "0");
INSERT INTO `inter_posts` VALUES("7", "1", "2025-09-23 20:26:45", "2025-09-23 18:26:45", "{\"version\": 3, \"isGlobalStylesUserThemeJSON\": true }", "Custom Styles", "", "publish", "closed", "closed", "", "wp-global-styles-twentytwentyfive", "", "", "2025-09-23 20:26:45", "2025-09-23 18:26:45", "", "0", "http://localhost:8888/intermitent_site/index.php/2025/09/23/wp-global-styles-twentytwentyfive/", "0", "wp_global_styles", "", "0");
INSERT INTO `inter_posts` VALUES("8", "1", "2025-09-23 20:41:04", "2025-09-23 18:41:04", "{\"styles\":[],\"settings\":{\"typography\":{\"fontFamilies\":{\"theme\":[{\"fontFace\":[{\"fontFamily\":\"Inter\",\"fontStretch\":\"normal\",\"fontStyle\":\"normal\",\"fontWeight\":\"300 900\",\"src\":[\"file:.\\/assets\\/fonts\\/inter\\/Inter-VariableFont_slnt,wght.woff2\"]}],\"fontFamily\":\"\\\"Inter\\\", sans-serif\",\"name\":\"Inter\",\"slug\":\"body\"},{\"fontFace\":[{\"fontFamily\":\"Cardo\",\"fontStyle\":\"normal\",\"fontWeight\":\"400\",\"src\":[\"file:.\\/assets\\/fonts\\/cardo\\/cardo_normal_400.woff2\"]},{\"fontFamily\":\"Cardo\",\"fontStyle\":\"italic\",\"fontWeight\":\"400\",\"src\":[\"file:.\\/assets\\/fonts\\/cardo\\/cardo_italic_400.woff2\"]},{\"fontFamily\":\"Cardo\",\"fontStyle\":\"normal\",\"fontWeight\":\"700\",\"src\":[\"file:.\\/assets\\/fonts\\/cardo\\/cardo_normal_700.woff2\"]}],\"fontFamily\":\"Cardo\",\"name\":\"Cardo\",\"slug\":\"heading\"},{\"fontFamily\":\"-apple-system, BlinkMacSystemFont, avenir next, avenir, segoe ui, helvetica neue, helvetica, Cantarell, Ubuntu, roboto, noto, arial, sans-serif\",\"name\":\"System Sans-serif\",\"slug\":\"system-sans-serif\"},{\"fontFamily\":\"Iowan Old Style, Apple Garamond, Baskerville, Times New Roman, Droid Serif, Times, Source Serif Pro, serif, Apple Color Emoji, Segoe UI Emoji, Segoe UI Symbol\",\"name\":\"System Serif\",\"slug\":\"system-serif\"}],\"custom\":[{\"id\":95,\"name\":\"Roca Two\",\"slug\":\"roca-two\",\"fontFamily\":\"\\\"Roca Two\\\"\",\"preview\":\"\",\"fontFace\":[{\"fontFamily\":\"\\\"Roca Two\\\"\",\"fontStyle\":\"normal\",\"fontWeight\":\"400\",\"src\":\"http:\\/\\/localhost:8888\\/intermitent_site\\/wp-content\\/uploads\\/fonts\\/fonnts.com-Roca_Two_Bold.ttf\"}],\"source\":\"custom\"}]}}},\"isGlobalStylesUserThemeJSON\":true,\"version\":3}", "Custom Styles", "", "publish", "closed", "closed", "", "wp-global-styles-inter-theme", "", "", "2025-10-21 19:10:31", "2025-10-21 17:10:31", "", "0", "http://localhost:8888/intermitent_site/index.php/2025/09/23/wp-global-styles-inter-theme/", "0", "wp_global_styles", "", "0");
INSERT INTO `inter_posts` VALUES("9", "1", "2025-09-23 20:43:24", "2025-09-23 18:43:24", "{\"version\": 3, \"isGlobalStylesUserThemeJSON\": true }", "Custom Styles", "", "publish", "closed", "closed", "", "wp-global-styles-twentytwentyfour", "", "", "2025-09-23 20:43:24", "2025-09-23 18:43:24", "", "0", "http://localhost:8888/intermitent_site/index.php/2025/09/23/wp-global-styles-twentytwentyfour/", "0", "wp_global_styles", "", "0");
INSERT INTO `inter_posts` VALUES("14", "1", "2025-10-04 17:51:34", "2025-10-04 15:51:34", "", "Profil", "", "publish", "closed", "closed", "", "profil", "", "", "2025-10-08 21:05:07", "2025-10-08 19:05:07", "", "0", "http://localhost:8888/intermitent_site/?page_id=14", "0", "page", "", "0");
INSERT INTO `inter_posts` VALUES("15", "1", "2025-10-04 17:51:34", "2025-10-04 15:51:34", "", "mon profil", "", "inherit", "closed", "closed", "", "14-revision-v1", "", "", "2025-10-04 17:51:34", "2025-10-04 15:51:34", "", "14", "http://localhost:8888/intermitent_site/?p=15", "0", "revision", "", "0");
INSERT INTO `inter_posts` VALUES("16", "1", "2025-10-04 17:52:00", "2025-10-04 15:52:00", "", "mon profil", "", "trash", "closed", "closed", "", "mon-profil-2__trashed", "", "", "2025-10-04 17:52:11", "2025-10-04 15:52:11", "", "0", "http://localhost:8888/intermitent_site/?page_id=16", "0", "page", "", "0");
INSERT INTO `inter_posts` VALUES("17", "1", "2025-10-04 17:52:00", "2025-10-04 15:52:00", "", "mon profil", "", "inherit", "closed", "closed", "", "16-revision-v1", "", "", "2025-10-04 17:52:00", "2025-10-04 15:52:00", "", "16", "http://localhost:8888/intermitent_site/?p=17", "0", "revision", "", "0");
INSERT INTO `inter_posts` VALUES("18", "1", "2025-10-04 18:01:00", "2025-10-04 16:01:00", "", "check-box", "", "inherit", "open", "closed", "", "check-box", "", "", "2025-10-04 18:01:00", "2025-10-04 16:01:00", "", "0", "http://localhost:8888/intermitent_site/wp-content/uploads/2025/10/check-box.png", "0", "attachment", "image/png", "0");
INSERT INTO `inter_posts` VALUES("19", "1", "2025-10-04 18:05:25", "2025-10-04 16:05:25", "<!-- wp:page-list /-->", "Navigation", "", "inherit", "closed", "closed", "", "4-revision-v1", "", "", "2025-10-04 18:05:25", "2025-10-04 16:05:25", "", "4", "http://localhost:8888/intermitent_site/?p=19", "0", "revision", "", "0");
INSERT INTO `inter_posts` VALUES("22", "1", "2025-10-04 18:13:32", "2025-10-04 16:13:32", "<!-- wp:group {\"metadata\":{\"categories\":[\"header\",\"wireframe\"],\"patternName\":\"core/text-only-header-with-tagline\",\"name\":\"Text-only header with tagline\"},\"align\":\"full\",\"style\":{\"spacing\":{\"padding\":{\"top\":\"var:preset|spacing|30\",\"right\":\"var:preset|spacing|30\",\"bottom\":\"var:preset|spacing|30\",\"left\":\"var:preset|spacing|30\"}}},\"layout\":{\"type\":\"constrained\"}} -->\n<div class=\"wp-block-group alignfull\" style=\"padding-top:var(--wp--preset--spacing--30);padding-right:var(--wp--preset--spacing--30);padding-bottom:var(--wp--preset--spacing--30);padding-left:var(--wp--preset--spacing--30)\"><!-- wp:group {\"align\":\"wide\",\"layout\":{\"type\":\"flex\",\"justifyContent\":\"right\"}} -->\n<div class=\"wp-block-group alignwide\"><!-- wp:buttons -->\n<div class=\"wp-block-buttons\"><!-- wp:button -->\n<div class=\"wp-block-button\"><a class=\"wp-block-button__link wp-element-button\" href=\"http://localhost:8888/intermitent_site/index.php/mon-profil/\">Mon espace</a></div>\n<!-- /wp:button --></div>\n<!-- /wp:buttons -->\n\n<!-- wp:shortcode /--></div>\n<!-- /wp:group --></div>\n<!-- /wp:group -->", "Header 2", "", "publish", "closed", "closed", "", "header-2", "", "", "2025-10-04 18:20:23", "2025-10-04 16:20:23", "", "0", "http://localhost:8888/intermitent_site/index.php/2025/10/04/header-2/", "0", "wp_block", "", "0");
INSERT INTO `inter_posts` VALUES("23", "1", "2025-10-04 18:14:20", "2025-10-04 16:14:20", "", "Home", "", "publish", "closed", "closed", "", "home", "", "", "2025-10-06 18:37:09", "2025-10-06 16:37:09", "", "0", "http://localhost:8888/intermitent_site/?page_id=23", "0", "page", "", "0");
INSERT INTO `inter_posts` VALUES("24", "1", "2025-10-04 18:14:20", "2025-10-04 16:14:20", "", "Home", "", "inherit", "closed", "closed", "", "23-revision-v1", "", "", "2025-10-04 18:14:20", "2025-10-04 16:14:20", "", "23", "http://localhost:8888/intermitent_site/?p=24", "0", "revision", "", "0");
INSERT INTO `inter_posts` VALUES("25", "1", "2025-10-04 18:20:23", "2025-10-04 16:20:23", "<!-- wp:group {\"metadata\":{\"categories\":[\"header\",\"wireframe\"],\"patternName\":\"core/text-only-header-with-tagline\",\"name\":\"Text-only header with tagline\"},\"align\":\"full\",\"style\":{\"spacing\":{\"padding\":{\"top\":\"var:preset|spacing|30\",\"right\":\"var:preset|spacing|30\",\"bottom\":\"var:preset|spacing|30\",\"left\":\"var:preset|spacing|30\"}}},\"layout\":{\"type\":\"constrained\"}} -->\n<div class=\"wp-block-group alignfull\" style=\"padding-top:var(--wp--preset--spacing--30);padding-right:var(--wp--preset--spacing--30);padding-bottom:var(--wp--preset--spacing--30);padding-left:var(--wp--preset--spacing--30)\"><!-- wp:group {\"align\":\"wide\",\"layout\":{\"type\":\"flex\",\"justifyContent\":\"right\"}} -->\n<div class=\"wp-block-group alignwide\"><!-- wp:buttons -->\n<div class=\"wp-block-buttons\"><!-- wp:button -->\n<div class=\"wp-block-button\"><a class=\"wp-block-button__link wp-element-button\" href=\"http://localhost:8888/intermitent_site/index.php/mon-profil/\">Mon espace</a></div>\n<!-- /wp:button --></div>\n<!-- /wp:buttons -->\n\n<!-- wp:shortcode /--></div>\n<!-- /wp:group --></div>\n<!-- /wp:group -->", "Header 2", "", "inherit", "closed", "closed", "", "22-revision-v1", "", "", "2025-10-04 18:20:23", "2025-10-04 16:20:23", "", "22", "http://localhost:8888/intermitent_site/?p=25", "0", "revision", "", "0");
INSERT INTO `inter_posts` VALUES("27", "1", "2025-10-04 18:22:10", "2025-10-04 16:22:10", "", "Connexion", "", "trash", "closed", "closed", "", "connexion__trashed", "", "", "2025-10-04 19:04:10", "2025-10-04 17:04:10", "", "0", "http://localhost:8888/intermitent_site/?page_id=27", "0", "page", "", "0");
INSERT INTO `inter_posts` VALUES("28", "1", "2025-10-04 18:22:10", "2025-10-04 16:22:10", "", "Connexion", "", "inherit", "closed", "closed", "", "27-revision-v1", "", "", "2025-10-04 18:22:10", "2025-10-04 16:22:10", "", "27", "http://localhost:8888/intermitent_site/?p=28", "0", "revision", "", "0");
INSERT INTO `inter_posts` VALUES("29", "1", "2025-10-04 18:31:40", "2025-10-04 16:31:40", "", "Mon profil", "", "inherit", "closed", "closed", "", "14-revision-v1", "", "", "2025-10-04 18:31:40", "2025-10-04 16:31:40", "", "14", "http://localhost:8888/intermitent_site/?p=29", "0", "revision", "", "0");
INSERT INTO `inter_posts` VALUES("34", "1", "2025-10-04 19:05:19", "2025-10-04 17:05:19", "", "Connexion", "", "publish", "closed", "closed", "", "connexion", "", "", "2025-10-04 19:10:21", "2025-10-04 17:10:21", "", "0", "http://localhost:8888/intermitent_site/?page_id=34", "0", "page", "", "0");
INSERT INTO `inter_posts` VALUES("35", "1", "2025-10-04 19:05:19", "2025-10-04 17:05:19", "", "Connexion", "", "inherit", "closed", "closed", "", "34-revision-v1", "", "", "2025-10-04 19:05:19", "2025-10-04 17:05:19", "", "34", "http://localhost:8888/intermitent_site/?p=35", "0", "revision", "", "0");
INSERT INTO `inter_posts` VALUES("38", "1", "2025-10-04 19:21:32", "2025-10-04 17:21:32", "<!-- wp:navigation-link {\"label\":\"Connexion\",\"type\":\"page\",\"id\":34,\"url\":\"http://localhost:8888/intermitent_site/index.php/connexion/\",\"kind\":\"post-type\"} /-->\n\n<!-- wp:navigation-link {\"label\":\"Home\",\"type\":\"page\",\"id\":23,\"url\":\"http://localhost:8888/intermitent_site/index.php/home/\",\"kind\":\"post-type\"} /-->\n\n<!-- wp:navigation-link {\"label\":\"Mon profil\",\"type\":\"page\",\"id\":14,\"url\":\"http://localhost:8888/intermitent_site/index.php/mon-profil/\",\"kind\":\"post-type\"} /-->\n\n<!-- wp:navigation-link {\"label\":\"Page d’exemple\",\"type\":\"page\",\"id\":2,\"url\":\"http://localhost:8888/intermitent_site/index.php/page-d-exemple/\",\"kind\":\"post-type\"} /-->", "Navigation", "", "inherit", "closed", "closed", "", "4-revision-v1", "", "", "2025-10-04 19:21:32", "2025-10-04 17:21:32", "", "4", "http://localhost:8888/intermitent_site/?p=38", "0", "revision", "", "0");
INSERT INTO `inter_posts` VALUES("42", "1", "2025-10-04 19:25:43", "2025-10-04 17:25:43", "<!-- wp:group {\"tagName\":\"main\",\"style\":{\"spacing\":{\"blockGap\":\"0\",\"margin\":{\"top\":\"0\"}}},\"layout\":{\"type\":\"default\"}} -->\n<main class=\"wp-block-group\" style=\"margin-top:0\"><!-- wp:group {\"align\":\"full\",\"style\":{\"spacing\":{\"padding\":{\"top\":\"var:preset|spacing|50\",\"bottom\":\"var:preset|spacing|50\",\"left\":\"var:preset|spacing|50\",\"right\":\"var:preset|spacing|50\"}}},\"layout\":{\"type\":\"constrained\",\"contentSize\":\"\",\"wideSize\":\"\"}} -->\n<div class=\"wp-block-group alignfull\" style=\"padding-top:var(--wp--preset--spacing--50);padding-right:var(--wp--preset--spacing--50);padding-bottom:var(--wp--preset--spacing--50);padding-left:var(--wp--preset--spacing--50)\"><!-- wp:group {\"style\":{\"spacing\":{\"blockGap\":\"0px\"}},\"layout\":{\"type\":\"constrained\",\"contentSize\":\"565px\"}} -->\n<div class=\"wp-block-group\"><!-- wp:heading {\"textAlign\":\"center\",\"level\":1,\"fontSize\":\"x-large\"} -->\n<h1 class=\"wp-block-heading has-text-align-center has-x-large-font-size\">Un engagement en faveur de l’innovation et de la durabilité</h1>\n<!-- /wp:heading -->\n\n<!-- wp:spacer {\"height\":\"1.25rem\"} -->\n<div style=\"height:1.25rem\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n<!-- /wp:spacer -->\n\n<!-- wp:paragraph {\"align\":\"center\"} -->\n<p class=\"has-text-align-center\">Études est un cabinet pionnier qui fusionne harmonieusement la créativité et la fonctionnalité pour redéfinir l’excellence architecturale.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:spacer {\"height\":\"1.25rem\"} -->\n<div style=\"height:1.25rem\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n<!-- /wp:spacer -->\n\n<!-- wp:buttons {\"layout\":{\"type\":\"flex\",\"justifyContent\":\"center\"}} -->\n<div class=\"wp-block-buttons\"><!-- wp:button -->\n<div class=\"wp-block-button\"><a class=\"wp-block-button__link wp-element-button\">À propos</a></div>\n<!-- /wp:button --></div>\n<!-- /wp:buttons --></div>\n<!-- /wp:group -->\n\n<!-- wp:spacer {\"height\":\"var:preset|spacing|30\",\"style\":{\"layout\":[]}} -->\n<div style=\"height:var(--wp--preset--spacing--30)\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n<!-- /wp:spacer -->\n\n<!-- wp:image {\"sizeSlug\":\"full\",\"linkDestination\":\"none\",\"align\":\"wide\",\"className\":\"is-style-rounded\"} -->\n<figure class=\"wp-block-image alignwide size-full is-style-rounded\"><img src=\"http://localhost:8888/intermitent_site/wp-content/themes/twentytwentyfour/assets/images/building-exterior.webp\" alt=\"Extérieur du bâtiment à Toronto, Canada\"/></figure>\n<!-- /wp:image --></div>\n<!-- /wp:group -->\n\n<!-- wp:group {\"align\":\"full\",\"style\":{\"spacing\":{\"margin\":{\"top\":\"0\",\"bottom\":\"0\"},\"padding\":{\"top\":\"var:preset|spacing|50\",\"bottom\":\"var:preset|spacing|50\",\"left\":\"var:preset|spacing|50\",\"right\":\"var:preset|spacing|50\"}}},\"backgroundColor\":\"base-2\",\"layout\":{\"type\":\"constrained\"}} -->\n<div class=\"wp-block-group alignfull has-base-2-background-color has-background\" style=\"margin-top:0;margin-bottom:0;padding-top:var(--wp--preset--spacing--50);padding-right:var(--wp--preset--spacing--50);padding-bottom:var(--wp--preset--spacing--50);padding-left:var(--wp--preset--spacing--50)\"><!-- wp:group {\"style\":{\"spacing\":{\"blockGap\":\"0px\"}},\"layout\":{\"type\":\"flex\",\"orientation\":\"vertical\",\"justifyContent\":\"center\"}} -->\n<div class=\"wp-block-group\"><!-- wp:heading {\"textAlign\":\"center\",\"className\":\"is-style-asterisk\"} -->\n<h2 class=\"wp-block-heading has-text-align-center is-style-asterisk\">Une passion pour la création d’espaces</h2>\n<!-- /wp:heading -->\n\n<!-- wp:spacer {\"height\":\"0px\",\"style\":{\"layout\":{\"flexSize\":\"1.25rem\",\"selfStretch\":\"fixed\"}}} -->\n<div style=\"height:0px\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n<!-- /wp:spacer -->\n\n<!-- wp:paragraph {\"align\":\"center\"} -->\n<p class=\"has-text-align-center\">Notre gamme complète de services professionnels s’adresse à une clientèle diversifiée, allant des propriétaires aux promotrices ou promoteurs commerciaux.</p>\n<!-- /wp:paragraph --></div>\n<!-- /wp:group -->\n\n<!-- wp:spacer {\"height\":\"var:preset|spacing|40\",\"style\":{\"spacing\":{\"margin\":{\"top\":\"0\",\"bottom\":\"0\"}}}} -->\n<div style=\"margin-top:0;margin-bottom:0;height:var(--wp--preset--spacing--40)\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n<!-- /wp:spacer -->\n\n<!-- wp:columns {\"align\":\"wide\",\"style\":{\"spacing\":{\"blockGap\":{\"top\":\"var:preset|spacing|30\",\"left\":\"var:preset|spacing|40\"}}}} -->\n<div class=\"wp-block-columns alignwide\"><!-- wp:column {\"style\":{\"spacing\":{\"blockGap\":\"var:preset|spacing|10\"}}} -->\n<div class=\"wp-block-column\"><!-- wp:heading {\"textAlign\":\"left\",\"level\":3,\"className\":\"is-style-asterisk\",\"style\":{\"typography\":{\"fontStyle\":\"normal\",\"fontWeight\":\"600\"}},\"fontSize\":\"medium\",\"fontFamily\":\"body\"} -->\n<h3 class=\"wp-block-heading has-text-align-left is-style-asterisk has-body-font-family has-medium-font-size\" style=\"font-style:normal;font-weight:600\">Rénovation et restauration</h3>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph {\"align\":\"left\"} -->\n<p class=\"has-text-align-left\">Découvrez la fusion de l’imagination et de l’expertise avec Études Architectural Solutions.</p>\n<!-- /wp:paragraph --></div>\n<!-- /wp:column -->\n\n<!-- wp:column {\"style\":{\"spacing\":{\"blockGap\":\"var:preset|spacing|10\"}}} -->\n<div class=\"wp-block-column\"><!-- wp:heading {\"textAlign\":\"left\",\"level\":3,\"className\":\"is-style-asterisk\",\"style\":{\"typography\":{\"fontStyle\":\"normal\",\"fontWeight\":\"600\"}},\"fontSize\":\"medium\",\"fontFamily\":\"body\"} -->\n<h3 class=\"wp-block-heading has-text-align-left is-style-asterisk has-body-font-family has-medium-font-size\" style=\"font-style:normal;font-weight:600\">Support continu</h3>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph {\"align\":\"left\"} -->\n<p class=\"has-text-align-left\">Découvrez la fusion de l’imagination et de l’expertise avec Études Architectural Solutions.</p>\n<!-- /wp:paragraph --></div>\n<!-- /wp:column -->\n\n<!-- wp:column {\"style\":{\"spacing\":{\"blockGap\":\"var:preset|spacing|10\"}}} -->\n<div class=\"wp-block-column\"><!-- wp:heading {\"textAlign\":\"left\",\"level\":3,\"className\":\"is-style-asterisk\",\"style\":{\"typography\":{\"fontStyle\":\"normal\",\"fontWeight\":\"600\"}},\"fontSize\":\"medium\",\"fontFamily\":\"body\"} -->\n<h3 class=\"wp-block-heading has-text-align-left is-style-asterisk has-body-font-family has-medium-font-size\" style=\"font-style:normal;font-weight:600\">Accès à l‘application</h3>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph {\"align\":\"left\"} -->\n<p class=\"has-text-align-left\">Découvrez la fusion de l’imagination et de l’expertise avec Études Architectural Solutions.</p>\n<!-- /wp:paragraph --></div>\n<!-- /wp:column --></div>\n<!-- /wp:columns -->\n\n<!-- wp:spacer {\"height\":\"var:preset|spacing|20\"} -->\n<div style=\"height:var(--wp--preset--spacing--20)\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n<!-- /wp:spacer -->\n\n<!-- wp:columns {\"align\":\"wide\",\"style\":{\"spacing\":{\"blockGap\":{\"top\":\"var:preset|spacing|30\",\"left\":\"var:preset|spacing|40\"}}}} -->\n<div class=\"wp-block-columns alignwide\"><!-- wp:column {\"style\":{\"spacing\":{\"blockGap\":\"var:preset|spacing|10\"}}} -->\n<div class=\"wp-block-column\"><!-- wp:heading {\"textAlign\":\"left\",\"level\":3,\"className\":\"is-style-asterisk\",\"style\":{\"typography\":{\"fontStyle\":\"normal\",\"fontWeight\":\"600\"}},\"fontSize\":\"medium\",\"fontFamily\":\"body\"} -->\n<h3 class=\"wp-block-heading has-text-align-left is-style-asterisk has-body-font-family has-medium-font-size\" style=\"font-style:normal;font-weight:600\">Conseil</h3>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph {\"align\":\"left\"} -->\n<p class=\"has-text-align-left\">Découvrez la fusion de l’imagination et de l’expertise avec Études Architectural Solutions.</p>\n<!-- /wp:paragraph --></div>\n<!-- /wp:column -->\n\n<!-- wp:column {\"style\":{\"spacing\":{\"blockGap\":\"var:preset|spacing|10\"}}} -->\n<div class=\"wp-block-column\"><!-- wp:heading {\"textAlign\":\"left\",\"level\":3,\"className\":\"is-style-asterisk\",\"style\":{\"typography\":{\"fontStyle\":\"normal\",\"fontWeight\":\"600\"}},\"fontSize\":\"medium\",\"fontFamily\":\"body\"} -->\n<h3 class=\"wp-block-heading has-text-align-left is-style-asterisk has-body-font-family has-medium-font-size\" style=\"font-style:normal;font-weight:600\">Gestion de projet</h3>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph {\"align\":\"left\"} -->\n<p class=\"has-text-align-left\">Découvrez la fusion de l’imagination et de l’expertise avec Études Architectural Solutions.</p>\n<!-- /wp:paragraph --></div>\n<!-- /wp:column -->\n\n<!-- wp:column {\"style\":{\"spacing\":{\"blockGap\":\"var:preset|spacing|10\"}}} -->\n<div class=\"wp-block-column\"><!-- wp:heading {\"textAlign\":\"left\",\"level\":3,\"className\":\"is-style-asterisk\",\"style\":{\"typography\":{\"fontStyle\":\"normal\",\"fontWeight\":\"600\"}},\"fontSize\":\"medium\",\"fontFamily\":\"body\"} -->\n<h3 class=\"wp-block-heading has-text-align-left is-style-asterisk has-body-font-family has-medium-font-size\" style=\"font-style:normal;font-weight:600\">Architectural Solutions</h3>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph {\"align\":\"left\"} -->\n<p class=\"has-text-align-left\">Vivez l’expérience de la fusion entre l’imagination et l’expertise avec Études Architectural Solutions.</p>\n<!-- /wp:paragraph --></div>\n<!-- /wp:column --></div>\n<!-- /wp:columns --></div>\n<!-- /wp:group -->\n\n<!-- wp:group {\"align\":\"full\",\"style\":{\"spacing\":{\"padding\":{\"top\":\"var:preset|spacing|50\",\"bottom\":\"var:preset|spacing|50\",\"left\":\"var:preset|spacing|50\",\"right\":\"var:preset|spacing|50\"},\"margin\":{\"top\":\"0\",\"bottom\":\"0\"}}},\"layout\":{\"type\":\"constrained\"}} -->\n<div class=\"wp-block-group alignfull\" style=\"margin-top:0;margin-bottom:0;padding-top:var(--wp--preset--spacing--50);padding-right:var(--wp--preset--spacing--50);padding-bottom:var(--wp--preset--spacing--50);padding-left:var(--wp--preset--spacing--50)\"><!-- wp:group {\"align\":\"wide\",\"style\":{\"spacing\":{\"blockGap\":\"0\"}},\"layout\":{\"type\":\"constrained\"}} -->\n<div class=\"wp-block-group alignwide\"><!-- wp:group {\"style\":{\"spacing\":{\"blockGap\":\"var:preset|spacing|10\"}},\"layout\":{\"type\":\"flex\",\"orientation\":\"vertical\",\"justifyContent\":\"center\"}} -->\n<div class=\"wp-block-group\"><!-- wp:heading {\"textAlign\":\"center\",\"className\":\"is-style-asterisk\"} -->\n<h2 class=\"wp-block-heading has-text-align-center is-style-asterisk\">Un tableau de ressources</h2>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph {\"align\":\"center\",\"style\":{\"layout\":{\"selfStretch\":\"fit\",\"flexSize\":null}}} -->\n<p class=\"has-text-align-center\">Notre suite complète de services professionnels s’adresse à une clientèle diversifiée, allant des propriétaires au développeurs commerciaux.</p>\n<!-- /wp:paragraph --></div>\n<!-- /wp:group -->\n\n<!-- wp:spacer {\"height\":\"var:preset|spacing|40\"} -->\n<div style=\"height:var(--wp--preset--spacing--40)\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n<!-- /wp:spacer -->\n\n<!-- wp:columns {\"align\":\"wide\",\"style\":{\"spacing\":{\"blockGap\":{\"top\":\"var:preset|spacing|50\",\"left\":\"var:preset|spacing|60\"}}}} -->\n<div class=\"wp-block-columns alignwide\"><!-- wp:column {\"verticalAlignment\":\"center\",\"width\":\"40%\"} -->\n<div class=\"wp-block-column is-vertically-aligned-center\" style=\"flex-basis:40%\"><!-- wp:heading {\"level\":3,\"className\":\"is-style-asterisk\"} -->\n<h3 class=\"wp-block-heading is-style-asterisk\">Application Études Architect</h3>\n<!-- /wp:heading -->\n\n<!-- wp:list {\"className\":\"is-style-checkmark-list\",\"style\":{\"typography\":{\"lineHeight\":\"1.75\"}}} -->\n<ul style=\"line-height:1.75\" class=\"wp-block-list is-style-checkmark-list\"><!-- wp:list-item -->\n<li>Collaborez avec d’autres architectes.</li>\n<!-- /wp:list-item -->\n\n<!-- wp:list-item -->\n<li>Présentez vos projets.</li>\n<!-- /wp:list-item -->\n\n<!-- wp:list-item -->\n<li>Découvrez le monde de l’architecture.</li>\n<!-- /wp:list-item --></ul>\n<!-- /wp:list --></div>\n<!-- /wp:column -->\n\n<!-- wp:column {\"width\":\"50%\"} -->\n<div class=\"wp-block-column\" style=\"flex-basis:50%\"><!-- wp:image {\"sizeSlug\":\"large\",\"linkDestination\":\"none\",\"className\":\"is-style-rounded\"} -->\n<figure class=\"wp-block-image size-large is-style-rounded\"><img src=\"http://localhost:8888/intermitent_site/wp-content/themes/twentytwentyfour/assets/images/tourist-and-building.webp\" alt=\"Touriste prenant une photo d’un bâtiment.\"/></figure>\n<!-- /wp:image --></div>\n<!-- /wp:column --></div>\n<!-- /wp:columns -->\n\n<!-- wp:spacer {\"height\":\"var:preset|spacing|40\"} -->\n<div style=\"height:var(--wp--preset--spacing--40)\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n<!-- /wp:spacer -->\n\n<!-- wp:columns {\"align\":\"wide\",\"style\":{\"spacing\":{\"blockGap\":{\"top\":\"var:preset|spacing|50\",\"left\":\"var:preset|spacing|60\"}}}} -->\n<div class=\"wp-block-columns alignwide\"><!-- wp:column {\"width\":\"50%\"} -->\n<div class=\"wp-block-column\" style=\"flex-basis:50%\"><!-- wp:image {\"sizeSlug\":\"large\",\"linkDestination\":\"none\",\"className\":\"is-style-rounded\"} -->\n<figure class=\"wp-block-image size-large is-style-rounded\"><img src=\"http://localhost:8888/intermitent_site/wp-content/themes/twentytwentyfour/assets/images/windows.webp\" alt=\"Les fenêtres d’un bâtiment à Nuremberg, Allemagne.\"/></figure>\n<!-- /wp:image --></div>\n<!-- /wp:column -->\n\n<!-- wp:column {\"verticalAlignment\":\"center\",\"width\":\"40%\"} -->\n<div class=\"wp-block-column is-vertically-aligned-center\" style=\"flex-basis:40%\"><!-- wp:heading {\"level\":3,\"className\":\"is-style-asterisk\"} -->\n<h3 class=\"wp-block-heading is-style-asterisk\">Newsletter Études</h3>\n<!-- /wp:heading -->\n\n<!-- wp:list {\"className\":\"is-style-checkmark-list\",\"style\":{\"typography\":{\"lineHeight\":\"1.75\"}}} -->\n<ul style=\"line-height:1.75\" class=\"wp-block-list is-style-checkmark-list\"><!-- wp:list-item -->\n<li>Un monde d’articles stimulants.</li>\n<!-- /wp:list-item -->\n\n<!-- wp:list-item -->\n<li>Études de cas qui célèbrent l’architecture.</li>\n<!-- /wp:list-item -->\n\n<!-- wp:list-item -->\n<li>Accès exclusif aux connaissances en design.</li>\n<!-- /wp:list-item --></ul>\n<!-- /wp:list --></div>\n<!-- /wp:column --></div>\n<!-- /wp:columns --></div>\n<!-- /wp:group --></div>\n<!-- /wp:group -->\n\n<!-- wp:group {\"metadata\":{\"name\":\"Testimonial\"},\"align\":\"full\",\"style\":{\"spacing\":{\"padding\":{\"top\":\"var:preset|spacing|60\",\"bottom\":\"var:preset|spacing|60\",\"left\":\"var:preset|spacing|60\",\"right\":\"var:preset|spacing|60\"},\"margin\":{\"top\":\"0\",\"bottom\":\"0\"}}},\"backgroundColor\":\"contrast\",\"textColor\":\"base\",\"layout\":{\"type\":\"constrained\",\"contentSize\":\"\"}} -->\n<div class=\"wp-block-group alignfull has-base-color has-contrast-background-color has-text-color has-background\" style=\"margin-top:0;margin-bottom:0;padding-top:var(--wp--preset--spacing--60);padding-right:var(--wp--preset--spacing--60);padding-bottom:var(--wp--preset--spacing--60);padding-left:var(--wp--preset--spacing--60)\"><!-- wp:group {\"layout\":{\"type\":\"constrained\"}} -->\n<div class=\"wp-block-group\"><!-- wp:paragraph {\"align\":\"center\",\"style\":{\"typography\":{\"lineHeight\":\"1.2\"}},\"textColor\":\"base\",\"fontSize\":\"x-large\",\"fontFamily\":\"heading\"} -->\n<p class=\"has-text-align-center has-base-color has-text-color has-heading-font-family has-x-large-font-size\" style=\"line-height:1.2\">\n			<em>«&nbsp;Études nous a fait gagner des milliers d’heures de travail et a révélé des perspectives auxquelles nous n’aurions jamais pensé possible.&nbsp;»</em>\n		</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:spacer {\"height\":\"var:preset|spacing|10\"} -->\n<div style=\"height:var(--wp--preset--spacing--10)\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n<!-- /wp:spacer -->\n\n<!-- wp:group {\"metadata\":{\"name\":\"Source du témoignage\"},\"style\":{\"spacing\":{\"blockGap\":\"0\"}},\"layout\":{\"type\":\"flex\",\"orientation\":\"vertical\",\"justifyContent\":\"center\",\"flexWrap\":\"nowrap\"}} -->\n<div class=\"wp-block-group\"><!-- wp:image {\"width\":\"60px\",\"aspectRatio\":\"1\",\"scale\":\"cover\",\"sizeSlug\":\"thumbnail\",\"linkDestination\":\"none\",\"align\":\"center\",\"style\":{\"border\":{\"radius\":\"100px\"}}} -->\n<figure class=\"wp-block-image aligncenter size-thumbnail is-resized has-custom-border\"><img alt=\"\" style=\"border-radius:100px;aspect-ratio:1;object-fit:cover;width:60px\"/></figure>\n<!-- /wp:image -->\n\n<!-- wp:paragraph {\"align\":\"center\",\"style\":{\"spacing\":{\"margin\":{\"top\":\"var:preset|spacing|10\",\"bottom\":\"0\"}}}} -->\n<p class=\"has-text-align-center\" style=\"margin-top:var(--wp--preset--spacing--10);margin-bottom:0\">Annie Steiner</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph {\"align\":\"center\",\"style\":{\"typography\":{\"fontStyle\":\"normal\",\"fontWeight\":\"300\"}},\"textColor\":\"contrast-3\",\"fontSize\":\"small\"} -->\n<p class=\"has-text-align-center has-contrast-3-color has-text-color has-small-font-size\" style=\"font-style:normal;font-weight:300\">PDG, Greenprint</p>\n<!-- /wp:paragraph --></div>\n<!-- /wp:group --></div>\n<!-- /wp:group --></div>\n<!-- /wp:group -->\n\n<!-- wp:group {\"align\":\"full\",\"style\":{\"spacing\":{\"padding\":{\"top\":\"var:preset|spacing|50\",\"bottom\":\"var:preset|spacing|50\",\"left\":\"var:preset|spacing|50\",\"right\":\"var:preset|spacing|50\"},\"margin\":{\"top\":\"0\",\"bottom\":\"0\"}}},\"layout\":{\"type\":\"constrained\"}} -->\n<div class=\"wp-block-group alignfull\" style=\"margin-top:0;margin-bottom:0;padding-top:var(--wp--preset--spacing--50);padding-right:var(--wp--preset--spacing--50);padding-bottom:var(--wp--preset--spacing--50);padding-left:var(--wp--preset--spacing--50)\"><!-- wp:heading {\"align\":\"wide\",\"style\":{\"typography\":{\"lineHeight\":\"1\"},\"spacing\":{\"margin\":{\"top\":\"0\",\"bottom\":\"var:preset|spacing|40\"}}},\"fontSize\":\"x-large\"} -->\n<h2 class=\"wp-block-heading alignwide has-x-large-font-size\" style=\"margin-top:0;margin-bottom:var(--wp--preset--spacing--40);line-height:1\">Regardez, lisez, écoutez</h2>\n<!-- /wp:heading -->\n\n<!-- wp:group {\"align\":\"wide\",\"layout\":{\"type\":\"constrained\"}} -->\n<div class=\"wp-block-group alignwide\"><!-- wp:query {\"queryId\":0,\"query\":{\"perPage\":10,\"pages\":0,\"offset\":0,\"postType\":\"post\",\"order\":\"desc\",\"orderBy\":\"date\",\"author\":\"\",\"search\":\"\",\"exclude\":[],\"sticky\":\"\",\"inherit\":true},\"align\":\"wide\",\"layout\":{\"type\":\"default\"}} -->\n<div class=\"wp-block-query alignwide\"><!-- wp:post-template -->\n<!-- wp:separator {\"className\":\"alignwide is-style-wide\",\"backgroundColor\":\"contrast-3\"} -->\n<hr class=\"wp-block-separator has-text-color has-contrast-3-color has-alpha-channel-opacity has-contrast-3-background-color has-background alignwide is-style-wide\"/>\n<!-- /wp:separator -->\n\n<!-- wp:columns {\"verticalAlignment\":\"center\",\"align\":\"wide\",\"style\":{\"spacing\":{\"margin\":{\"top\":\"var:preset|spacing|20\",\"bottom\":\"var:preset|spacing|20\"}}}} -->\n<div class=\"wp-block-columns alignwide are-vertically-aligned-center\" style=\"margin-top:var(--wp--preset--spacing--20);margin-bottom:var(--wp--preset--spacing--20)\"><!-- wp:column {\"verticalAlignment\":\"center\",\"width\":\"72%\"} -->\n<div class=\"wp-block-column is-vertically-aligned-center\" style=\"flex-basis:72%\"><!-- wp:post-title {\"isLink\":true,\"style\":{\"typography\":{\"lineHeight\":\"1.1\",\"fontSize\":\"1.5rem\"}}} /--></div>\n<!-- /wp:column -->\n\n<!-- wp:column {\"verticalAlignment\":\"center\",\"width\":\"28%\"} -->\n<div class=\"wp-block-column is-vertically-aligned-center\" style=\"flex-basis:28%\"><!-- wp:template-part {\"slug\":\"post-meta\",\"theme\":\"inter-theme\"} /--></div>\n<!-- /wp:column --></div>\n<!-- /wp:columns -->\n<!-- /wp:post-template -->\n\n<!-- wp:spacer {\"height\":\"var:preset|spacing|30\"} -->\n<div style=\"height:var(--wp--preset--spacing--30)\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n<!-- /wp:spacer -->\n\n<!-- wp:query-pagination {\"paginationArrow\":\"arrow\",\"layout\":{\"type\":\"flex\",\"justifyContent\":\"space-between\"}} -->\n<!-- wp:query-pagination-previous /-->\n\n<!-- wp:query-pagination-numbers /-->\n\n<!-- wp:query-pagination-next /-->\n<!-- /wp:query-pagination -->\n\n<!-- wp:query-no-results -->\n<!-- wp:paragraph -->\n<p>Aucune publication n’a été trouvée.</p>\n<!-- /wp:paragraph -->\n<!-- /wp:query-no-results --></div>\n<!-- /wp:query --></div>\n<!-- /wp:group --></div>\n<!-- /wp:group -->\n\n<!-- wp:group {\"align\":\"full\",\"style\":{\"spacing\":{\"padding\":{\"top\":\"var:preset|spacing|50\",\"bottom\":\"var:preset|spacing|50\",\"left\":\"var:preset|spacing|50\",\"right\":\"var:preset|spacing|50\"},\"margin\":{\"top\":\"0\",\"bottom\":\"0\"}}},\"layout\":{\"type\":\"constrained\"}} -->\n<div class=\"wp-block-group alignfull\" style=\"margin-top:0;margin-bottom:0;padding-top:var(--wp--preset--spacing--50);padding-right:var(--wp--preset--spacing--50);padding-bottom:var(--wp--preset--spacing--50);padding-left:var(--wp--preset--spacing--50)\"><!-- wp:group {\"align\":\"wide\",\"style\":{\"border\":{\"radius\":\"16px\"},\"spacing\":{\"padding\":{\"top\":\"var:preset|spacing|40\",\"bottom\":\"var:preset|spacing|40\",\"left\":\"var:preset|spacing|50\",\"right\":\"var:preset|spacing|50\"}}},\"backgroundColor\":\"base-2\",\"layout\":{\"type\":\"constrained\"}} -->\n<div class=\"wp-block-group alignwide has-base-2-background-color has-background\" style=\"border-radius:16px;padding-top:var(--wp--preset--spacing--40);padding-right:var(--wp--preset--spacing--50);padding-bottom:var(--wp--preset--spacing--40);padding-left:var(--wp--preset--spacing--50)\"><!-- wp:spacer {\"height\":\"var:preset|spacing|10\"} -->\n<div style=\"height:var(--wp--preset--spacing--10)\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n<!-- /wp:spacer -->\n\n<!-- wp:heading {\"textAlign\":\"center\",\"fontSize\":\"x-large\"} -->\n<h2 class=\"wp-block-heading has-text-align-center has-x-large-font-size\">Rejoignez plus de 900 abonnés/abonnées</h2>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph {\"align\":\"center\"} -->\n<p class=\"has-text-align-center\">Restez au courant de tout ce que vous devez savoir.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:buttons {\"layout\":{\"type\":\"flex\",\"justifyContent\":\"center\"}} -->\n<div class=\"wp-block-buttons\"><!-- wp:button -->\n<div class=\"wp-block-button\"><a class=\"wp-block-button__link wp-element-button\">S’inscrire</a></div>\n<!-- /wp:button --></div>\n<!-- /wp:buttons -->\n\n<!-- wp:spacer {\"height\":\"var:preset|spacing|10\"} -->\n<div style=\"height:var(--wp--preset--spacing--10)\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n<!-- /wp:spacer --></div>\n<!-- /wp:group --></div>\n<!-- /wp:group --></main>\n<!-- /wp:group -->\n\n<!-- wp:template-part {\"slug\":\"footer\",\"theme\":\"inter-theme\",\"tagName\":\"footer\",\"area\":\"footer\"} /-->", "Page d’accueil du blog", "Affiche les derniers articles sur la page définie comme étant votre page d’accueil du blog dans les réglages de lecture. S’il existe, le modèle de page d’accueil prend le pas sur ce modèle lorsque les articles sont affichés sur la page d’accueil.", "publish", "closed", "closed", "", "home", "", "", "2025-10-04 19:26:07", "2025-10-04 17:26:07", "", "0", "http://localhost:8888/intermitent_site/index.php/2025/10/04/home/", "0", "wp_template", "", "0");
INSERT INTO `inter_posts` VALUES("43", "1", "2025-10-04 19:26:07", "2025-10-04 17:26:07", "<!-- wp:group {\"tagName\":\"main\",\"style\":{\"spacing\":{\"blockGap\":\"0\",\"margin\":{\"top\":\"0\"}}},\"layout\":{\"type\":\"default\"}} -->\n<main class=\"wp-block-group\" style=\"margin-top:0\"><!-- wp:group {\"align\":\"full\",\"style\":{\"spacing\":{\"padding\":{\"top\":\"var:preset|spacing|50\",\"bottom\":\"var:preset|spacing|50\",\"left\":\"var:preset|spacing|50\",\"right\":\"var:preset|spacing|50\"}}},\"layout\":{\"type\":\"constrained\",\"contentSize\":\"\",\"wideSize\":\"\"}} -->\n<div class=\"wp-block-group alignfull\" style=\"padding-top:var(--wp--preset--spacing--50);padding-right:var(--wp--preset--spacing--50);padding-bottom:var(--wp--preset--spacing--50);padding-left:var(--wp--preset--spacing--50)\"><!-- wp:group {\"style\":{\"spacing\":{\"blockGap\":\"0px\"}},\"layout\":{\"type\":\"constrained\",\"contentSize\":\"565px\"}} -->\n<div class=\"wp-block-group\"><!-- wp:heading {\"textAlign\":\"center\",\"level\":1,\"fontSize\":\"x-large\"} -->\n<h1 class=\"wp-block-heading has-text-align-center has-x-large-font-size\">Un engagement en faveur de l’innovation et de la durabilité</h1>\n<!-- /wp:heading -->\n\n<!-- wp:spacer {\"height\":\"1.25rem\"} -->\n<div style=\"height:1.25rem\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n<!-- /wp:spacer -->\n\n<!-- wp:paragraph {\"align\":\"center\"} -->\n<p class=\"has-text-align-center\">Études est un cabinet pionnier qui fusionne harmonieusement la créativité et la fonctionnalité pour redéfinir l’excellence architecturale.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:spacer {\"height\":\"1.25rem\"} -->\n<div style=\"height:1.25rem\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n<!-- /wp:spacer -->\n\n<!-- wp:buttons {\"layout\":{\"type\":\"flex\",\"justifyContent\":\"center\"}} -->\n<div class=\"wp-block-buttons\"><!-- wp:button -->\n<div class=\"wp-block-button\"><a class=\"wp-block-button__link wp-element-button\">À propos</a></div>\n<!-- /wp:button --></div>\n<!-- /wp:buttons --></div>\n<!-- /wp:group -->\n\n<!-- wp:spacer {\"height\":\"var:preset|spacing|30\",\"style\":{\"layout\":[]}} -->\n<div style=\"height:var(--wp--preset--spacing--30)\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n<!-- /wp:spacer -->\n\n<!-- wp:image {\"sizeSlug\":\"full\",\"linkDestination\":\"none\",\"align\":\"wide\",\"className\":\"is-style-rounded\"} -->\n<figure class=\"wp-block-image alignwide size-full is-style-rounded\"><img src=\"http://localhost:8888/intermitent_site/wp-content/themes/twentytwentyfour/assets/images/building-exterior.webp\" alt=\"Extérieur du bâtiment à Toronto, Canada\"/></figure>\n<!-- /wp:image --></div>\n<!-- /wp:group -->\n\n<!-- wp:group {\"align\":\"full\",\"style\":{\"spacing\":{\"margin\":{\"top\":\"0\",\"bottom\":\"0\"},\"padding\":{\"top\":\"var:preset|spacing|50\",\"bottom\":\"var:preset|spacing|50\",\"left\":\"var:preset|spacing|50\",\"right\":\"var:preset|spacing|50\"}}},\"backgroundColor\":\"base-2\",\"layout\":{\"type\":\"constrained\"}} -->\n<div class=\"wp-block-group alignfull has-base-2-background-color has-background\" style=\"margin-top:0;margin-bottom:0;padding-top:var(--wp--preset--spacing--50);padding-right:var(--wp--preset--spacing--50);padding-bottom:var(--wp--preset--spacing--50);padding-left:var(--wp--preset--spacing--50)\"><!-- wp:group {\"style\":{\"spacing\":{\"blockGap\":\"0px\"}},\"layout\":{\"type\":\"flex\",\"orientation\":\"vertical\",\"justifyContent\":\"center\"}} -->\n<div class=\"wp-block-group\"><!-- wp:heading {\"textAlign\":\"center\",\"className\":\"is-style-asterisk\"} -->\n<h2 class=\"wp-block-heading has-text-align-center is-style-asterisk\">Une passion pour la création d’espaces</h2>\n<!-- /wp:heading -->\n\n<!-- wp:spacer {\"height\":\"0px\",\"style\":{\"layout\":{\"flexSize\":\"1.25rem\",\"selfStretch\":\"fixed\"}}} -->\n<div style=\"height:0px\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n<!-- /wp:spacer -->\n\n<!-- wp:paragraph {\"align\":\"center\"} -->\n<p class=\"has-text-align-center\">Notre gamme complète de services professionnels s’adresse à une clientèle diversifiée, allant des propriétaires aux promotrices ou promoteurs commerciaux.</p>\n<!-- /wp:paragraph --></div>\n<!-- /wp:group -->\n\n<!-- wp:spacer {\"height\":\"var:preset|spacing|40\",\"style\":{\"spacing\":{\"margin\":{\"top\":\"0\",\"bottom\":\"0\"}}}} -->\n<div style=\"margin-top:0;margin-bottom:0;height:var(--wp--preset--spacing--40)\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n<!-- /wp:spacer -->\n\n<!-- wp:columns {\"align\":\"wide\",\"style\":{\"spacing\":{\"blockGap\":{\"top\":\"var:preset|spacing|30\",\"left\":\"var:preset|spacing|40\"}}}} -->\n<div class=\"wp-block-columns alignwide\"><!-- wp:column {\"style\":{\"spacing\":{\"blockGap\":\"var:preset|spacing|10\"}}} -->\n<div class=\"wp-block-column\"><!-- wp:heading {\"textAlign\":\"left\",\"level\":3,\"className\":\"is-style-asterisk\",\"style\":{\"typography\":{\"fontStyle\":\"normal\",\"fontWeight\":\"600\"}},\"fontSize\":\"medium\",\"fontFamily\":\"body\"} -->\n<h3 class=\"wp-block-heading has-text-align-left is-style-asterisk has-body-font-family has-medium-font-size\" style=\"font-style:normal;font-weight:600\">Rénovation et restauration</h3>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph {\"align\":\"left\"} -->\n<p class=\"has-text-align-left\">Découvrez la fusion de l’imagination et de l’expertise avec Études Architectural Solutions.</p>\n<!-- /wp:paragraph --></div>\n<!-- /wp:column -->\n\n<!-- wp:column {\"style\":{\"spacing\":{\"blockGap\":\"var:preset|spacing|10\"}}} -->\n<div class=\"wp-block-column\"><!-- wp:heading {\"textAlign\":\"left\",\"level\":3,\"className\":\"is-style-asterisk\",\"style\":{\"typography\":{\"fontStyle\":\"normal\",\"fontWeight\":\"600\"}},\"fontSize\":\"medium\",\"fontFamily\":\"body\"} -->\n<h3 class=\"wp-block-heading has-text-align-left is-style-asterisk has-body-font-family has-medium-font-size\" style=\"font-style:normal;font-weight:600\">Support continu</h3>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph {\"align\":\"left\"} -->\n<p class=\"has-text-align-left\">Découvrez la fusion de l’imagination et de l’expertise avec Études Architectural Solutions.</p>\n<!-- /wp:paragraph --></div>\n<!-- /wp:column -->\n\n<!-- wp:column {\"style\":{\"spacing\":{\"blockGap\":\"var:preset|spacing|10\"}}} -->\n<div class=\"wp-block-column\"><!-- wp:heading {\"textAlign\":\"left\",\"level\":3,\"className\":\"is-style-asterisk\",\"style\":{\"typography\":{\"fontStyle\":\"normal\",\"fontWeight\":\"600\"}},\"fontSize\":\"medium\",\"fontFamily\":\"body\"} -->\n<h3 class=\"wp-block-heading has-text-align-left is-style-asterisk has-body-font-family has-medium-font-size\" style=\"font-style:normal;font-weight:600\">Accès à l‘application</h3>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph {\"align\":\"left\"} -->\n<p class=\"has-text-align-left\">Découvrez la fusion de l’imagination et de l’expertise avec Études Architectural Solutions.</p>\n<!-- /wp:paragraph --></div>\n<!-- /wp:column --></div>\n<!-- /wp:columns -->\n\n<!-- wp:spacer {\"height\":\"var:preset|spacing|20\"} -->\n<div style=\"height:var(--wp--preset--spacing--20)\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n<!-- /wp:spacer -->\n\n<!-- wp:columns {\"align\":\"wide\",\"style\":{\"spacing\":{\"blockGap\":{\"top\":\"var:preset|spacing|30\",\"left\":\"var:preset|spacing|40\"}}}} -->\n<div class=\"wp-block-columns alignwide\"><!-- wp:column {\"style\":{\"spacing\":{\"blockGap\":\"var:preset|spacing|10\"}}} -->\n<div class=\"wp-block-column\"><!-- wp:heading {\"textAlign\":\"left\",\"level\":3,\"className\":\"is-style-asterisk\",\"style\":{\"typography\":{\"fontStyle\":\"normal\",\"fontWeight\":\"600\"}},\"fontSize\":\"medium\",\"fontFamily\":\"body\"} -->\n<h3 class=\"wp-block-heading has-text-align-left is-style-asterisk has-body-font-family has-medium-font-size\" style=\"font-style:normal;font-weight:600\">Conseil</h3>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph {\"align\":\"left\"} -->\n<p class=\"has-text-align-left\">Découvrez la fusion de l’imagination et de l’expertise avec Études Architectural Solutions.</p>\n<!-- /wp:paragraph --></div>\n<!-- /wp:column -->\n\n<!-- wp:column {\"style\":{\"spacing\":{\"blockGap\":\"var:preset|spacing|10\"}}} -->\n<div class=\"wp-block-column\"><!-- wp:heading {\"textAlign\":\"left\",\"level\":3,\"className\":\"is-style-asterisk\",\"style\":{\"typography\":{\"fontStyle\":\"normal\",\"fontWeight\":\"600\"}},\"fontSize\":\"medium\",\"fontFamily\":\"body\"} -->\n<h3 class=\"wp-block-heading has-text-align-left is-style-asterisk has-body-font-family has-medium-font-size\" style=\"font-style:normal;font-weight:600\">Gestion de projet</h3>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph {\"align\":\"left\"} -->\n<p class=\"has-text-align-left\">Découvrez la fusion de l’imagination et de l’expertise avec Études Architectural Solutions.</p>\n<!-- /wp:paragraph --></div>\n<!-- /wp:column -->\n\n<!-- wp:column {\"style\":{\"spacing\":{\"blockGap\":\"var:preset|spacing|10\"}}} -->\n<div class=\"wp-block-column\"><!-- wp:heading {\"textAlign\":\"left\",\"level\":3,\"className\":\"is-style-asterisk\",\"style\":{\"typography\":{\"fontStyle\":\"normal\",\"fontWeight\":\"600\"}},\"fontSize\":\"medium\",\"fontFamily\":\"body\"} -->\n<h3 class=\"wp-block-heading has-text-align-left is-style-asterisk has-body-font-family has-medium-font-size\" style=\"font-style:normal;font-weight:600\">Architectural Solutions</h3>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph {\"align\":\"left\"} -->\n<p class=\"has-text-align-left\">Vivez l’expérience de la fusion entre l’imagination et l’expertise avec Études Architectural Solutions.</p>\n<!-- /wp:paragraph --></div>\n<!-- /wp:column --></div>\n<!-- /wp:columns --></div>\n<!-- /wp:group -->\n\n<!-- wp:group {\"align\":\"full\",\"style\":{\"spacing\":{\"padding\":{\"top\":\"var:preset|spacing|50\",\"bottom\":\"var:preset|spacing|50\",\"left\":\"var:preset|spacing|50\",\"right\":\"var:preset|spacing|50\"},\"margin\":{\"top\":\"0\",\"bottom\":\"0\"}}},\"layout\":{\"type\":\"constrained\"}} -->\n<div class=\"wp-block-group alignfull\" style=\"margin-top:0;margin-bottom:0;padding-top:var(--wp--preset--spacing--50);padding-right:var(--wp--preset--spacing--50);padding-bottom:var(--wp--preset--spacing--50);padding-left:var(--wp--preset--spacing--50)\"><!-- wp:group {\"align\":\"wide\",\"style\":{\"spacing\":{\"blockGap\":\"0\"}},\"layout\":{\"type\":\"constrained\"}} -->\n<div class=\"wp-block-group alignwide\"><!-- wp:group {\"style\":{\"spacing\":{\"blockGap\":\"var:preset|spacing|10\"}},\"layout\":{\"type\":\"flex\",\"orientation\":\"vertical\",\"justifyContent\":\"center\"}} -->\n<div class=\"wp-block-group\"><!-- wp:heading {\"textAlign\":\"center\",\"className\":\"is-style-asterisk\"} -->\n<h2 class=\"wp-block-heading has-text-align-center is-style-asterisk\">Un tableau de ressources</h2>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph {\"align\":\"center\",\"style\":{\"layout\":{\"selfStretch\":\"fit\",\"flexSize\":null}}} -->\n<p class=\"has-text-align-center\">Notre suite complète de services professionnels s’adresse à une clientèle diversifiée, allant des propriétaires au développeurs commerciaux.</p>\n<!-- /wp:paragraph --></div>\n<!-- /wp:group -->\n\n<!-- wp:spacer {\"height\":\"var:preset|spacing|40\"} -->\n<div style=\"height:var(--wp--preset--spacing--40)\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n<!-- /wp:spacer -->\n\n<!-- wp:columns {\"align\":\"wide\",\"style\":{\"spacing\":{\"blockGap\":{\"top\":\"var:preset|spacing|50\",\"left\":\"var:preset|spacing|60\"}}}} -->\n<div class=\"wp-block-columns alignwide\"><!-- wp:column {\"verticalAlignment\":\"center\",\"width\":\"40%\"} -->\n<div class=\"wp-block-column is-vertically-aligned-center\" style=\"flex-basis:40%\"><!-- wp:heading {\"level\":3,\"className\":\"is-style-asterisk\"} -->\n<h3 class=\"wp-block-heading is-style-asterisk\">Application Études Architect</h3>\n<!-- /wp:heading -->\n\n<!-- wp:list {\"className\":\"is-style-checkmark-list\",\"style\":{\"typography\":{\"lineHeight\":\"1.75\"}}} -->\n<ul style=\"line-height:1.75\" class=\"wp-block-list is-style-checkmark-list\"><!-- wp:list-item -->\n<li>Collaborez avec d’autres architectes.</li>\n<!-- /wp:list-item -->\n\n<!-- wp:list-item -->\n<li>Présentez vos projets.</li>\n<!-- /wp:list-item -->\n\n<!-- wp:list-item -->\n<li>Découvrez le monde de l’architecture.</li>\n<!-- /wp:list-item --></ul>\n<!-- /wp:list --></div>\n<!-- /wp:column -->\n\n<!-- wp:column {\"width\":\"50%\"} -->\n<div class=\"wp-block-column\" style=\"flex-basis:50%\"><!-- wp:image {\"sizeSlug\":\"large\",\"linkDestination\":\"none\",\"className\":\"is-style-rounded\"} -->\n<figure class=\"wp-block-image size-large is-style-rounded\"><img src=\"http://localhost:8888/intermitent_site/wp-content/themes/twentytwentyfour/assets/images/tourist-and-building.webp\" alt=\"Touriste prenant une photo d’un bâtiment.\"/></figure>\n<!-- /wp:image --></div>\n<!-- /wp:column --></div>\n<!-- /wp:columns -->\n\n<!-- wp:spacer {\"height\":\"var:preset|spacing|40\"} -->\n<div style=\"height:var(--wp--preset--spacing--40)\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n<!-- /wp:spacer -->\n\n<!-- wp:columns {\"align\":\"wide\",\"style\":{\"spacing\":{\"blockGap\":{\"top\":\"var:preset|spacing|50\",\"left\":\"var:preset|spacing|60\"}}}} -->\n<div class=\"wp-block-columns alignwide\"><!-- wp:column {\"width\":\"50%\"} -->\n<div class=\"wp-block-column\" style=\"flex-basis:50%\"><!-- wp:image {\"sizeSlug\":\"large\",\"linkDestination\":\"none\",\"className\":\"is-style-rounded\"} -->\n<figure class=\"wp-block-image size-large is-style-rounded\"><img src=\"http://localhost:8888/intermitent_site/wp-content/themes/twentytwentyfour/assets/images/windows.webp\" alt=\"Les fenêtres d’un bâtiment à Nuremberg, Allemagne.\"/></figure>\n<!-- /wp:image --></div>\n<!-- /wp:column -->\n\n<!-- wp:column {\"verticalAlignment\":\"center\",\"width\":\"40%\"} -->\n<div class=\"wp-block-column is-vertically-aligned-center\" style=\"flex-basis:40%\"><!-- wp:heading {\"level\":3,\"className\":\"is-style-asterisk\"} -->\n<h3 class=\"wp-block-heading is-style-asterisk\">Newsletter Études</h3>\n<!-- /wp:heading -->\n\n<!-- wp:list {\"className\":\"is-style-checkmark-list\",\"style\":{\"typography\":{\"lineHeight\":\"1.75\"}}} -->\n<ul style=\"line-height:1.75\" class=\"wp-block-list is-style-checkmark-list\"><!-- wp:list-item -->\n<li>Un monde d’articles stimulants.</li>\n<!-- /wp:list-item -->\n\n<!-- wp:list-item -->\n<li>Études de cas qui célèbrent l’architecture.</li>\n<!-- /wp:list-item -->\n\n<!-- wp:list-item -->\n<li>Accès exclusif aux connaissances en design.</li>\n<!-- /wp:list-item --></ul>\n<!-- /wp:list --></div>\n<!-- /wp:column --></div>\n<!-- /wp:columns --></div>\n<!-- /wp:group --></div>\n<!-- /wp:group -->\n\n<!-- wp:group {\"metadata\":{\"name\":\"Testimonial\"},\"align\":\"full\",\"style\":{\"spacing\":{\"padding\":{\"top\":\"var:preset|spacing|60\",\"bottom\":\"var:preset|spacing|60\",\"left\":\"var:preset|spacing|60\",\"right\":\"var:preset|spacing|60\"},\"margin\":{\"top\":\"0\",\"bottom\":\"0\"}}},\"backgroundColor\":\"contrast\",\"textColor\":\"base\",\"layout\":{\"type\":\"constrained\",\"contentSize\":\"\"}} -->\n<div class=\"wp-block-group alignfull has-base-color has-contrast-background-color has-text-color has-background\" style=\"margin-top:0;margin-bottom:0;padding-top:var(--wp--preset--spacing--60);padding-right:var(--wp--preset--spacing--60);padding-bottom:var(--wp--preset--spacing--60);padding-left:var(--wp--preset--spacing--60)\"><!-- wp:group {\"layout\":{\"type\":\"constrained\"}} -->\n<div class=\"wp-block-group\"><!-- wp:paragraph {\"align\":\"center\",\"style\":{\"typography\":{\"lineHeight\":\"1.2\"}},\"textColor\":\"base\",\"fontSize\":\"x-large\",\"fontFamily\":\"heading\"} -->\n<p class=\"has-text-align-center has-base-color has-text-color has-heading-font-family has-x-large-font-size\" style=\"line-height:1.2\">\n			<em>«&nbsp;Études nous a fait gagner des milliers d’heures de travail et a révélé des perspectives auxquelles nous n’aurions jamais pensé possible.&nbsp;»</em>\n		</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:spacer {\"height\":\"var:preset|spacing|10\"} -->\n<div style=\"height:var(--wp--preset--spacing--10)\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n<!-- /wp:spacer -->\n\n<!-- wp:group {\"metadata\":{\"name\":\"Source du témoignage\"},\"style\":{\"spacing\":{\"blockGap\":\"0\"}},\"layout\":{\"type\":\"flex\",\"orientation\":\"vertical\",\"justifyContent\":\"center\",\"flexWrap\":\"nowrap\"}} -->\n<div class=\"wp-block-group\"><!-- wp:image {\"width\":\"60px\",\"aspectRatio\":\"1\",\"scale\":\"cover\",\"sizeSlug\":\"thumbnail\",\"linkDestination\":\"none\",\"align\":\"center\",\"style\":{\"border\":{\"radius\":\"100px\"}}} -->\n<figure class=\"wp-block-image aligncenter size-thumbnail is-resized has-custom-border\"><img alt=\"\" style=\"border-radius:100px;aspect-ratio:1;object-fit:cover;width:60px\"/></figure>\n<!-- /wp:image -->\n\n<!-- wp:paragraph {\"align\":\"center\",\"style\":{\"spacing\":{\"margin\":{\"top\":\"var:preset|spacing|10\",\"bottom\":\"0\"}}}} -->\n<p class=\"has-text-align-center\" style=\"margin-top:var(--wp--preset--spacing--10);margin-bottom:0\">Annie Steiner</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph {\"align\":\"center\",\"style\":{\"typography\":{\"fontStyle\":\"normal\",\"fontWeight\":\"300\"}},\"textColor\":\"contrast-3\",\"fontSize\":\"small\"} -->\n<p class=\"has-text-align-center has-contrast-3-color has-text-color has-small-font-size\" style=\"font-style:normal;font-weight:300\">PDG, Greenprint</p>\n<!-- /wp:paragraph --></div>\n<!-- /wp:group --></div>\n<!-- /wp:group --></div>\n<!-- /wp:group -->\n\n<!-- wp:group {\"align\":\"full\",\"style\":{\"spacing\":{\"padding\":{\"top\":\"var:preset|spacing|50\",\"bottom\":\"var:preset|spacing|50\",\"left\":\"var:preset|spacing|50\",\"right\":\"var:preset|spacing|50\"},\"margin\":{\"top\":\"0\",\"bottom\":\"0\"}}},\"layout\":{\"type\":\"constrained\"}} -->\n<div class=\"wp-block-group alignfull\" style=\"margin-top:0;margin-bottom:0;padding-top:var(--wp--preset--spacing--50);padding-right:var(--wp--preset--spacing--50);padding-bottom:var(--wp--preset--spacing--50);padding-left:var(--wp--preset--spacing--50)\"><!-- wp:heading {\"align\":\"wide\",\"style\":{\"typography\":{\"lineHeight\":\"1\"},\"spacing\":{\"margin\":{\"top\":\"0\",\"bottom\":\"var:preset|spacing|40\"}}},\"fontSize\":\"x-large\"} -->\n<h2 class=\"wp-block-heading alignwide has-x-large-font-size\" style=\"margin-top:0;margin-bottom:var(--wp--preset--spacing--40);line-height:1\">Regardez, lisez, écoutez</h2>\n<!-- /wp:heading -->\n\n<!-- wp:group {\"align\":\"wide\",\"layout\":{\"type\":\"constrained\"}} -->\n<div class=\"wp-block-group alignwide\"><!-- wp:query {\"queryId\":0,\"query\":{\"perPage\":10,\"pages\":0,\"offset\":0,\"postType\":\"post\",\"order\":\"desc\",\"orderBy\":\"date\",\"author\":\"\",\"search\":\"\",\"exclude\":[],\"sticky\":\"\",\"inherit\":true},\"align\":\"wide\",\"layout\":{\"type\":\"default\"}} -->\n<div class=\"wp-block-query alignwide\"><!-- wp:post-template -->\n<!-- wp:separator {\"className\":\"alignwide is-style-wide\",\"backgroundColor\":\"contrast-3\"} -->\n<hr class=\"wp-block-separator has-text-color has-contrast-3-color has-alpha-channel-opacity has-contrast-3-background-color has-background alignwide is-style-wide\"/>\n<!-- /wp:separator -->\n\n<!-- wp:columns {\"verticalAlignment\":\"center\",\"align\":\"wide\",\"style\":{\"spacing\":{\"margin\":{\"top\":\"var:preset|spacing|20\",\"bottom\":\"var:preset|spacing|20\"}}}} -->\n<div class=\"wp-block-columns alignwide are-vertically-aligned-center\" style=\"margin-top:var(--wp--preset--spacing--20);margin-bottom:var(--wp--preset--spacing--20)\"><!-- wp:column {\"verticalAlignment\":\"center\",\"width\":\"72%\"} -->\n<div class=\"wp-block-column is-vertically-aligned-center\" style=\"flex-basis:72%\"><!-- wp:post-title {\"isLink\":true,\"style\":{\"typography\":{\"lineHeight\":\"1.1\",\"fontSize\":\"1.5rem\"}}} /--></div>\n<!-- /wp:column -->\n\n<!-- wp:column {\"verticalAlignment\":\"center\",\"width\":\"28%\"} -->\n<div class=\"wp-block-column is-vertically-aligned-center\" style=\"flex-basis:28%\"><!-- wp:template-part {\"slug\":\"post-meta\",\"theme\":\"inter-theme\"} /--></div>\n<!-- /wp:column --></div>\n<!-- /wp:columns -->\n<!-- /wp:post-template -->\n\n<!-- wp:spacer {\"height\":\"var:preset|spacing|30\"} -->\n<div style=\"height:var(--wp--preset--spacing--30)\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n<!-- /wp:spacer -->\n\n<!-- wp:query-pagination {\"paginationArrow\":\"arrow\",\"layout\":{\"type\":\"flex\",\"justifyContent\":\"space-between\"}} -->\n<!-- wp:query-pagination-previous /-->\n\n<!-- wp:query-pagination-numbers /-->\n\n<!-- wp:query-pagination-next /-->\n<!-- /wp:query-pagination -->\n\n<!-- wp:query-no-results -->\n<!-- wp:paragraph -->\n<p>Aucune publication n’a été trouvée.</p>\n<!-- /wp:paragraph -->\n<!-- /wp:query-no-results --></div>\n<!-- /wp:query --></div>\n<!-- /wp:group --></div>\n<!-- /wp:group -->\n\n<!-- wp:group {\"align\":\"full\",\"style\":{\"spacing\":{\"padding\":{\"top\":\"var:preset|spacing|50\",\"bottom\":\"var:preset|spacing|50\",\"left\":\"var:preset|spacing|50\",\"right\":\"var:preset|spacing|50\"},\"margin\":{\"top\":\"0\",\"bottom\":\"0\"}}},\"layout\":{\"type\":\"constrained\"}} -->\n<div class=\"wp-block-group alignfull\" style=\"margin-top:0;margin-bottom:0;padding-top:var(--wp--preset--spacing--50);padding-right:var(--wp--preset--spacing--50);padding-bottom:var(--wp--preset--spacing--50);padding-left:var(--wp--preset--spacing--50)\"><!-- wp:group {\"align\":\"wide\",\"style\":{\"border\":{\"radius\":\"16px\"},\"spacing\":{\"padding\":{\"top\":\"var:preset|spacing|40\",\"bottom\":\"var:preset|spacing|40\",\"left\":\"var:preset|spacing|50\",\"right\":\"var:preset|spacing|50\"}}},\"backgroundColor\":\"base-2\",\"layout\":{\"type\":\"constrained\"}} -->\n<div class=\"wp-block-group alignwide has-base-2-background-color has-background\" style=\"border-radius:16px;padding-top:var(--wp--preset--spacing--40);padding-right:var(--wp--preset--spacing--50);padding-bottom:var(--wp--preset--spacing--40);padding-left:var(--wp--preset--spacing--50)\"><!-- wp:spacer {\"height\":\"var:preset|spacing|10\"} -->\n<div style=\"height:var(--wp--preset--spacing--10)\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n<!-- /wp:spacer -->\n\n<!-- wp:heading {\"textAlign\":\"center\",\"fontSize\":\"x-large\"} -->\n<h2 class=\"wp-block-heading has-text-align-center has-x-large-font-size\">Rejoignez plus de 900 abonnés/abonnées</h2>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph {\"align\":\"center\"} -->\n<p class=\"has-text-align-center\">Restez au courant de tout ce que vous devez savoir.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:buttons {\"layout\":{\"type\":\"flex\",\"justifyContent\":\"center\"}} -->\n<div class=\"wp-block-buttons\"><!-- wp:button -->\n<div class=\"wp-block-button\"><a class=\"wp-block-button__link wp-element-button\">S’inscrire</a></div>\n<!-- /wp:button --></div>\n<!-- /wp:buttons -->\n\n<!-- wp:spacer {\"height\":\"var:preset|spacing|10\"} -->\n<div style=\"height:var(--wp--preset--spacing--10)\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n<!-- /wp:spacer --></div>\n<!-- /wp:group --></div>\n<!-- /wp:group --></main>\n<!-- /wp:group -->\n\n<!-- wp:template-part {\"slug\":\"footer\",\"theme\":\"inter-theme\",\"tagName\":\"footer\",\"area\":\"footer\"} /-->", "Page d’accueil du blog", "Affiche les derniers articles sur la page définie comme étant votre page d’accueil du blog dans les réglages de lecture. S’il existe, le modèle de page d’accueil prend le pas sur ce modèle lorsque les articles sont affichés sur la page d’accueil.", "inherit", "closed", "closed", "", "42-revision-v1", "", "", "2025-10-04 19:26:07", "2025-10-04 17:26:07", "", "42", "http://localhost:8888/intermitent_site/?p=43", "0", "revision", "", "0");
INSERT INTO `inter_posts` VALUES("44", "1", "2025-10-04 19:30:10", "2025-10-04 17:30:10", "<!-- wp:group {\"metadata\":{\"name\":\"Page d’atterrissage RSVP\",\"categories\":[\"twentytwentyfour_page\"],\"patternName\":\"twentytwentyfour/page-rsvp-landing\"},\"align\":\"full\",\"style\":{\"spacing\":{\"margin\":{\"top\":\"0\",\"bottom\":\"0\"},\"padding\":{\"top\":\"var:preset|spacing|50\",\"bottom\":\"var:preset|spacing|50\",\"left\":\"var:preset|spacing|50\",\"right\":\"var:preset|spacing|50\"}},\"dimensions\":{\"minHeight\":\"100vh\"}},\"backgroundColor\":\"accent-4\",\"layout\":{\"type\":\"flex\",\"orientation\":\"vertical\",\"verticalAlignment\":\"center\",\"justifyContent\":\"center\",\"flexWrap\":\"nowrap\"}} -->\n<div class=\"wp-block-group alignfull has-accent-4-background-color has-background\" style=\"min-height:100vh;margin-top:0;margin-bottom:0;padding-top:var(--wp--preset--spacing--50);padding-right:var(--wp--preset--spacing--50);padding-bottom:var(--wp--preset--spacing--50);padding-left:var(--wp--preset--spacing--50)\"><!-- wp:columns {\"verticalAlignment\":\"center\",\"align\":\"wide\",\"style\":{\"spacing\":{\"blockGap\":{\"top\":\"var:preset|spacing|50\",\"left\":\"var:preset|spacing|50\"}}}} -->\n<div class=\"wp-block-columns alignwide are-vertically-aligned-center\"><!-- wp:column {\"verticalAlignment\":\"center\",\"width\":\"40%\"} -->\n<div class=\"wp-block-column is-vertically-aligned-center\" style=\"flex-basis:40%\"><!-- wp:group {\"style\":{\"dimensions\":{\"minHeight\":\"100%\"},\"spacing\":{\"blockGap\":\"var:preset|spacing|50\",\"margin\":{\"top\":\"0\",\"bottom\":\"0\"},\"padding\":{\"right\":\"0\",\"left\":\"0\"}}},\"layout\":{\"type\":\"default\"}} -->\n<div class=\"wp-block-group\" style=\"min-height:100%;margin-top:0;margin-bottom:0;padding-right:0;padding-left:0\"><!-- wp:heading {\"textAlign\":\"right\",\"level\":1,\"style\":{\"typography\":{\"fontSize\":\"12rem\",\"writingMode\":\"vertical-rl\",\"lineHeight\":\"1\"},\"spacing\":{\"margin\":{\"right\":\"0\",\"left\":\"calc( var(\\u002d\\u002dwp\\u002d\\u002dpreset\\u002d\\u002dspacing\\u002d\\u002d20) * -1)\"}}}} -->\n<h1 class=\"wp-block-heading has-text-align-right\" style=\"margin-right:0;margin-left:calc( var(--wp--preset--spacing--20) * -1);font-size:12rem;line-height:1;writing-mode:vertical-rl\">RSVP</h1>\n<!-- /wp:heading -->\n\n<!-- wp:group {\"style\":{\"spacing\":{\"padding\":{\"right\":\"0\",\"left\":\"0\"}}},\"layout\":{\"type\":\"constrained\",\"contentSize\":\"300px\",\"justifyContent\":\"left\"}} -->\n<div class=\"wp-block-group\" style=\"padding-right:0;padding-left:0\"><!-- wp:paragraph {\"style\":{\"layout\":{\"selfStretch\":\"fixed\",\"flexSize\":\"50%\"}}} -->\n<p>Vivez la fusion de l’imagination et de l’expertise avec Études Arch Summit, février 2025.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:buttons -->\n<div class=\"wp-block-buttons\"><!-- wp:button -->\n<div class=\"wp-block-button\"><a class=\"wp-block-button__link wp-element-button\">Réservez votre place</a></div>\n<!-- /wp:button --></div>\n<!-- /wp:buttons --></div>\n<!-- /wp:group --></div>\n<!-- /wp:group --></div>\n<!-- /wp:column -->\n\n<!-- wp:column {\"verticalAlignment\":\"top\",\"width\":\"60%\"} -->\n<div class=\"wp-block-column is-vertically-aligned-top\" style=\"flex-basis:60%\"><!-- wp:image {\"aspectRatio\":\"3/4\",\"scale\":\"cover\",\"sizeSlug\":\"large\",\"linkDestination\":\"none\",\"className\":\"is-style-rounded\"} -->\n<figure class=\"wp-block-image size-large is-style-rounded\"><img src=\"http://localhost:8888/intermitent_site/wp-content/themes/twentytwentyfour/assets/images/green-staircase.webp\" alt=\"Escalier vert à l’Université Western, London, Canada\" style=\"aspect-ratio:3/4;object-fit:cover\"/></figure>\n<!-- /wp:image --></div>\n<!-- /wp:column --></div>\n<!-- /wp:columns --></div>\n<!-- /wp:group -->", "Home", "", "inherit", "closed", "closed", "", "23-revision-v1", "", "", "2025-10-04 19:30:10", "2025-10-04 17:30:10", "", "23", "http://localhost:8888/intermitent_site/?p=44", "0", "revision", "", "0");
INSERT INTO `inter_posts` VALUES("45", "1", "2025-10-04 19:30:24", "2025-10-04 17:30:24", "<!-- wp:group {\"metadata\":{\"name\":\"Page d’atterrissage RSVP\",\"categories\":[\"twentytwentyfour_page\"],\"patternName\":\"twentytwentyfour/page-rsvp-landing\"},\"align\":\"full\",\"style\":{\"spacing\":{\"margin\":{\"top\":\"0\",\"bottom\":\"0\"},\"padding\":{\"top\":\"var:preset|spacing|50\",\"bottom\":\"var:preset|spacing|50\",\"left\":\"var:preset|spacing|50\",\"right\":\"var:preset|spacing|50\"}},\"dimensions\":{\"minHeight\":\"100vh\"}},\"backgroundColor\":\"accent-4\",\"layout\":{\"type\":\"flex\",\"orientation\":\"vertical\",\"verticalAlignment\":\"center\",\"justifyContent\":\"center\",\"flexWrap\":\"nowrap\"}} -->\n<div class=\"wp-block-group alignfull has-accent-4-background-color has-background\" style=\"min-height:100vh;margin-top:0;margin-bottom:0;padding-top:var(--wp--preset--spacing--50);padding-right:var(--wp--preset--spacing--50);padding-bottom:var(--wp--preset--spacing--50);padding-left:var(--wp--preset--spacing--50)\"><!-- wp:columns {\"verticalAlignment\":\"center\",\"align\":\"wide\",\"style\":{\"spacing\":{\"blockGap\":{\"top\":\"var:preset|spacing|50\",\"left\":\"var:preset|spacing|50\"}}}} -->\n<div class=\"wp-block-columns alignwide are-vertically-aligned-center\"><!-- wp:column {\"verticalAlignment\":\"center\",\"width\":\"40%\"} -->\n<div class=\"wp-block-column is-vertically-aligned-center\" style=\"flex-basis:40%\"><!-- wp:group {\"style\":{\"dimensions\":{\"minHeight\":\"100%\"},\"spacing\":{\"blockGap\":\"var:preset|spacing|50\",\"margin\":{\"top\":\"0\",\"bottom\":\"0\"},\"padding\":{\"right\":\"0\",\"left\":\"0\"}}},\"layout\":{\"type\":\"default\"}} -->\n<div class=\"wp-block-group\" style=\"min-height:100%;margin-top:0;margin-bottom:0;padding-right:0;padding-left:0\"><!-- wp:heading {\"textAlign\":\"right\",\"level\":1,\"style\":{\"typography\":{\"fontSize\":\"12rem\",\"writingMode\":\"vertical-rl\",\"lineHeight\":\"1\"},\"spacing\":{\"margin\":{\"right\":\"0\",\"left\":\"calc( var(\\u002d\\u002dwp\\u002d\\u002dpreset\\u002d\\u002dspacing\\u002d\\u002d20) * -1)\"}}}} -->\n<h1 class=\"wp-block-heading has-text-align-right\" style=\"margin-right:0;margin-left:calc( var(--wp--preset--spacing--20) * -1);font-size:12rem;line-height:1;writing-mode:vertical-rl\">RSVP</h1>\n<!-- /wp:heading -->\n\n<!-- wp:group {\"style\":{\"spacing\":{\"padding\":{\"right\":\"0\",\"left\":\"0\"}}},\"layout\":{\"type\":\"constrained\",\"contentSize\":\"300px\",\"justifyContent\":\"left\"}} -->\n<div class=\"wp-block-group\" style=\"padding-right:0;padding-left:0\"><!-- wp:paragraph {\"style\":{\"layout\":{\"selfStretch\":\"fixed\",\"flexSize\":\"50%\"}}} -->\n<p>Vivez la fusion de l’imagination et de l’expertise avec Études Arch Summit, février 2025.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:buttons -->\n<div class=\"wp-block-buttons\"><!-- wp:button -->\n<div class=\"wp-block-button\"><a class=\"wp-block-button__link wp-element-button\">Réservez votre place</a></div>\n<!-- /wp:button --></div>\n<!-- /wp:buttons --></div>\n<!-- /wp:group --></div>\n<!-- /wp:group --></div>\n<!-- /wp:column -->\n\n<!-- wp:column {\"verticalAlignment\":\"top\",\"width\":\"60%\"} -->\n<div class=\"wp-block-column is-vertically-aligned-top\" style=\"flex-basis:60%\"><!-- wp:image {\"aspectRatio\":\"3/4\",\"scale\":\"cover\",\"sizeSlug\":\"large\",\"linkDestination\":\"none\",\"className\":\"is-style-rounded\"} -->\n<figure class=\"wp-block-image size-large is-style-rounded\"><img src=\"http://localhost:8888/intermitent_site/wp-content/themes/twentytwentyfour/assets/images/green-staircase.webp\" alt=\"Escalier vert à l’Université Western, London, Canada\" style=\"aspect-ratio:3/4;object-fit:cover\"/></figure>\n<!-- /wp:image --></div>\n<!-- /wp:column --></div>\n<!-- /wp:columns --></div>\n<!-- /wp:group -->", "", "", "inherit", "closed", "closed", "", "23-revision-v1", "", "", "2025-10-04 19:30:24", "2025-10-04 17:30:24", "", "23", "http://localhost:8888/intermitent_site/?p=45", "0", "revision", "", "0");
INSERT INTO `inter_posts` VALUES("46", "1", "2025-10-04 19:30:45", "2025-10-04 17:30:45", "", "Home", "", "inherit", "closed", "closed", "", "23-revision-v1", "", "", "2025-10-04 19:30:45", "2025-10-04 17:30:45", "", "23", "http://localhost:8888/intermitent_site/?p=46", "0", "revision", "", "0");
INSERT INTO `inter_posts` VALUES("48", "1", "2025-10-04 19:36:38", "2025-10-04 17:36:38", "<!-- wp:post-content {\"lock\":{\"move\":false,\"remove\":false},\"layout\":{\"type\":\"constrained\"}} /-->", "No header and footer", "", "publish", "closed", "closed", "", "wp-custom-template-no-header-and-footer", "", "", "2025-10-04 19:39:14", "2025-10-04 17:39:14", "", "0", "http://localhost:8888/intermitent_site/index.php/2025/10/04/wp-custom-template-no-header-and-footer/", "0", "wp_template", "", "0");
INSERT INTO `inter_posts` VALUES("49", "1", "2025-10-04 19:39:14", "2025-10-04 17:39:14", "<!-- wp:post-content {\"lock\":{\"move\":false,\"remove\":false},\"layout\":{\"type\":\"constrained\"}} /-->", "No header and footer", "", "inherit", "closed", "closed", "", "48-revision-v1", "", "", "2025-10-04 19:39:14", "2025-10-04 17:39:14", "", "48", "http://localhost:8888/intermitent_site/?p=49", "0", "revision", "", "0");
INSERT INTO `inter_posts` VALUES("51", "1", "2025-10-04 20:31:46", "2025-10-04 18:31:46", "<!-- wp:template-part {\"slug\":\"test-header\",\"theme\":\"inter-theme\",\"area\":\"header\"} /-->", "Template-Home", "", "publish", "closed", "closed", "", "wp-custom-template-template-home", "", "", "2025-10-04 20:32:20", "2025-10-04 18:32:20", "", "0", "http://localhost:8888/intermitent_site/index.php/2025/10/04/wp-custom-template-template-home/", "0", "wp_template", "", "0");
INSERT INTO `inter_posts` VALUES("52", "1", "2025-10-04 20:32:20", "2025-10-04 18:32:20", "<!-- wp:template-part {\"slug\":\"test-header\",\"theme\":\"inter-theme\",\"area\":\"header\"} /-->", "Template-Home", "", "inherit", "closed", "closed", "", "51-revision-v1", "", "", "2025-10-04 20:32:20", "2025-10-04 18:32:20", "", "51", "http://localhost:8888/intermitent_site/?p=52", "0", "revision", "", "0");
INSERT INTO `inter_posts` VALUES("55", "1", "2025-10-06 18:20:11", "2025-10-06 16:20:11", "", "pexels-kyleloftusstudios-3379934", "", "inherit", "open", "closed", "", "pexels-kyleloftusstudios-3379934", "", "", "2025-10-06 18:20:11", "2025-10-06 16:20:11", "", "0", "http://localhost:8888/intermitent_site/wp-content/uploads/2025/10/pexels-kyleloftusstudios-3379934.jpg", "0", "attachment", "image/jpeg", "0");
INSERT INTO `inter_posts` VALUES("57", "1", "2025-10-06 18:38:33", "2025-10-06 16:38:33", "", "Inscription", "", "publish", "closed", "closed", "", "inscription", "", "", "2025-10-06 18:38:42", "2025-10-06 16:38:42", "", "0", "http://localhost:8888/intermitent_site/?page_id=57", "0", "page", "", "0");
INSERT INTO `inter_posts` VALUES("58", "1", "2025-10-06 18:38:33", "2025-10-06 16:38:33", "", "Inscription", "", "inherit", "closed", "closed", "", "57-revision-v1", "", "", "2025-10-06 18:38:33", "2025-10-06 16:38:33", "", "57", "http://localhost:8888/intermitent_site/?p=58", "0", "revision", "", "0");
INSERT INTO `inter_posts` VALUES("59", "1", "2025-10-06 18:42:12", "2025-10-06 16:42:12", "<!-- wp:paragraph -->\n<p>Ceci est une page d’exemple. C’est différent d’un article de blog parce qu’elle restera au même endroit et apparaîtra dans la navigation de votre site (dans la plupart des thèmes). La plupart des gens commencent par une page « À propos » qui les présente aux personnes visitant le site. Cela pourrait ressembler à quelque chose comme cela :</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:quote -->\n<blockquote class=\"wp-block-quote\"><p>Bonjour ! Je suis un mécanicien qui aspire à devenir acteur, et voici mon site. J’habite à Bordeaux, j’ai un super chien baptisé Russell, et j’aime la vodka (ainsi qu’être surpris par la pluie soudaine lors de longues balades sur la plage au coucher du soleil).</p></blockquote>\n<!-- /wp:quote -->\n\n<!-- wp:paragraph -->\n<p>…ou quelque chose comme cela :</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:quote -->\n<blockquote class=\"wp-block-quote\"><p>La société 123 Machin Truc a été créée en 1971, et n’a cessé de proposer au public des machins-trucs de qualité depuis lors. Située à Saint-Remy-en-Bouzemont-Saint-Genest-et-Isson, 123 Machin Truc emploie 2 000 personnes, et fabrique toutes sortes de bidules supers pour la communauté bouzemontoise.</p></blockquote>\n<!-- /wp:quote -->\n\n<!-- wp:paragraph -->\n<p>En tant que nouvel utilisateur ou utilisatrice de WordPress, vous devriez vous rendre sur <a href=\"http://localhost:8888/intermitent_site/wp-admin/\">votre tableau de bord</a> pour supprimer cette page et créer de nouvelles pages pour votre contenu. Amusez-vous bien !</p>\n<!-- /wp:paragraph -->", "Page d’exemple", "", "inherit", "closed", "closed", "", "2-revision-v1", "", "", "2025-10-06 18:42:12", "2025-10-06 16:42:12", "", "2", "http://localhost:8888/intermitent_site/?p=59", "0", "revision", "", "0");
INSERT INTO `inter_posts` VALUES("63", "1", "2025-10-07 18:40:59", "2025-10-07 16:40:59", "", "Mot de passe oublié", "", "publish", "closed", "closed", "", "mot-de-passe-oublie", "", "", "2025-10-07 18:41:10", "2025-10-07 16:41:10", "", "0", "http://localhost:8888/intermitent_site/?page_id=63", "0", "page", "", "0");
INSERT INTO `inter_posts` VALUES("64", "1", "2025-10-07 18:40:59", "2025-10-07 16:40:59", "", "Mot de passe oublié", "", "inherit", "closed", "closed", "", "63-revision-v1", "", "", "2025-10-07 18:40:59", "2025-10-07 16:40:59", "", "63", "http://localhost:8888/intermitent_site/?p=64", "0", "revision", "", "0");
INSERT INTO `inter_posts` VALUES("65", "1", "2025-10-07 20:59:36", "2025-10-07 18:59:36", "", "TEST TEST test", "", "trash", "open", "open", "", "test-test-test__trashed", "", "", "2025-10-07 23:17:18", "2025-10-07 21:17:18", "", "0", "http://localhost:8888/intermitent_site/?p=65", "0", "post", "", "0");
INSERT INTO `inter_posts` VALUES("66", "1", "2025-10-07 20:59:36", "2025-10-07 18:59:36", "", "TEST TEST test", "", "inherit", "closed", "closed", "", "65-revision-v1", "", "", "2025-10-07 20:59:36", "2025-10-07 18:59:36", "", "65", "http://localhost:8888/intermitent_site/?p=66", "0", "revision", "", "0");
INSERT INTO `inter_posts` VALUES("67", "1", "2025-10-07 23:17:19", "2025-10-07 21:17:19", "<!-- wp:paragraph -->\n<p>Bienvenue sur WordPress. Ceci est votre premier article. Modifiez-le ou supprimez-le, puis commencez à écrire !</p>\n<!-- /wp:paragraph -->", "Bonjour tout le monde !", "", "inherit", "closed", "closed", "", "1-revision-v1", "", "", "2025-10-07 23:17:19", "2025-10-07 21:17:19", "", "1", "http://localhost:8888/intermitent_site/?p=67", "0", "revision", "", "0");
INSERT INTO `inter_posts` VALUES("71", "1", "2025-10-07 23:23:18", "2025-10-07 21:23:18", "", "Métier", "", "trash", "closed", "closed", "", "metier__trashed", "", "", "2025-10-07 23:24:18", "2025-10-07 21:24:18", "", "23", "http://localhost:8888/intermitent_site/?page_id=71", "0", "page", "", "0");
INSERT INTO `inter_posts` VALUES("72", "1", "2025-10-07 23:23:18", "2025-10-07 21:23:18", "", "Département", "", "inherit", "closed", "closed", "", "71-revision-v1", "", "", "2025-10-07 23:23:18", "2025-10-07 21:23:18", "", "71", "http://localhost:8888/intermitent_site/?p=72", "0", "revision", "", "0");
INSERT INTO `inter_posts` VALUES("73", "1", "2025-10-07 23:23:56", "2025-10-07 21:23:56", "", "Métier", "", "inherit", "closed", "closed", "", "71-revision-v1", "", "", "2025-10-07 23:23:56", "2025-10-07 21:23:56", "", "71", "http://localhost:8888/intermitent_site/?p=73", "0", "revision", "", "0");
INSERT INTO `inter_posts` VALUES("74", "1", "2025-10-08 18:40:41", "2025-10-08 16:40:41", "", "Subscribe", "", "publish", "closed", "closed", "", "subscribe", "", "", "2025-10-08 18:40:54", "2025-10-08 16:40:54", "", "0", "http://localhost:8888/intermitent_site/?page_id=74", "0", "page", "", "0");
INSERT INTO `inter_posts` VALUES("75", "1", "2025-10-08 18:40:41", "2025-10-08 16:40:41", "", "Subscribe", "", "inherit", "closed", "closed", "", "74-revision-v1", "", "", "2025-10-08 18:40:41", "2025-10-08 16:40:41", "", "74", "http://localhost:8888/intermitent_site/?p=75", "0", "revision", "", "0");
INSERT INTO `inter_posts` VALUES("76", "1", "2025-10-08 21:05:07", "2025-10-08 19:05:07", "", "Profil", "", "inherit", "closed", "closed", "", "14-revision-v1", "", "", "2025-10-08 21:05:07", "2025-10-08 19:05:07", "", "14", "http://localhost:8888/intermitent_site/?p=76", "0", "revision", "", "0");
INSERT INTO `inter_posts` VALUES("77", "1", "2025-10-08 21:05:18", "2025-10-08 19:05:18", "", "Edit profil", "", "publish", "closed", "closed", "", "edit-profil", "", "", "2025-10-08 21:05:26", "2025-10-08 19:05:26", "", "0", "http://localhost:8888/intermitent_site/?page_id=77", "0", "page", "", "0");
INSERT INTO `inter_posts` VALUES("78", "1", "2025-10-08 21:05:18", "2025-10-08 19:05:18", "", "Edit profil", "", "inherit", "closed", "closed", "", "77-revision-v1", "", "", "2025-10-08 21:05:18", "2025-10-08 19:05:18", "", "77", "http://localhost:8888/intermitent_site/?p=78", "0", "revision", "", "0");
INSERT INTO `inter_posts` VALUES("79", "1", "2025-10-20 16:59:36", "2025-10-20 14:59:36", "", "mobile bloque", "", "publish", "closed", "closed", "", "mobile-bloque", "", "", "2025-10-20 16:59:47", "2025-10-20 14:59:47", "", "0", "http://localhost:8888/intermitent_site/?page_id=79", "0", "page", "", "0");
INSERT INTO `inter_posts` VALUES("80", "1", "2025-10-20 16:59:36", "2025-10-20 14:59:36", "", "mobile bloque", "", "inherit", "closed", "closed", "", "79-revision-v1", "", "", "2025-10-20 16:59:36", "2025-10-20 14:59:36", "", "79", "http://localhost:8888/intermitent_site/?p=80", "0", "revision", "", "0");
INSERT INTO `inter_posts` VALUES("81", "1", "2025-10-21 18:38:33", "2025-10-21 16:38:33", "", "focus-antilles", "", "inherit", "open", "closed", "", "focus-antilles", "", "", "2025-10-21 18:38:33", "2025-10-21 16:38:33", "", "0", "http://localhost:8888/intermitent_site/wp-content/uploads/2025/10/focus-antilles.png", "0", "attachment", "image/png", "0");
INSERT INTO `inter_posts` VALUES("82", "1", "2025-10-21 18:38:37", "2025-10-21 16:38:37", "http://localhost:8888/intermitent_site/wp-content/uploads/2025/10/cropped-focus-antilles.png", "cropped-focus-antilles.png", "", "inherit", "open", "closed", "", "cropped-focus-antilles-png", "", "", "2025-10-21 18:38:37", "2025-10-21 16:38:37", "", "81", "http://localhost:8888/intermitent_site/wp-content/uploads/2025/10/cropped-focus-antilles.png", "0", "attachment", "image/png", "0");
INSERT INTO `inter_posts` VALUES("83", "1", "2025-10-21 18:53:47", "2025-10-21 16:53:47", "", "2", "", "inherit", "open", "closed", "", "2", "", "", "2025-10-21 18:53:47", "2025-10-21 16:53:47", "", "0", "http://localhost:8888/intermitent_site/wp-content/uploads/2025/10/2.png", "0", "attachment", "image/png", "0");
INSERT INTO `inter_posts` VALUES("84", "1", "2025-10-21 18:53:47", "2025-10-21 16:53:47", "", "3", "", "inherit", "open", "closed", "", "3", "", "", "2025-10-21 18:53:47", "2025-10-21 16:53:47", "", "0", "http://localhost:8888/intermitent_site/wp-content/uploads/2025/10/3.png", "0", "attachment", "image/png", "0");
INSERT INTO `inter_posts` VALUES("85", "1", "2025-10-21 18:53:47", "2025-10-21 16:53:47", "", "4", "", "inherit", "open", "closed", "", "4", "", "", "2025-10-21 18:53:47", "2025-10-21 16:53:47", "", "0", "http://localhost:8888/intermitent_site/wp-content/uploads/2025/10/4.png", "0", "attachment", "image/png", "0");
INSERT INTO `inter_posts` VALUES("86", "1", "2025-10-21 18:53:47", "2025-10-21 16:53:47", "", "5", "", "inherit", "open", "closed", "", "5", "", "", "2025-10-21 18:53:47", "2025-10-21 16:53:47", "", "0", "http://localhost:8888/intermitent_site/wp-content/uploads/2025/10/5.png", "0", "attachment", "image/png", "0");
INSERT INTO `inter_posts` VALUES("87", "1", "2025-10-21 18:53:47", "2025-10-21 16:53:47", "", "focus-antilles", "", "inherit", "open", "closed", "", "focus-antilles-2", "", "", "2025-10-21 18:53:47", "2025-10-21 16:53:47", "", "0", "http://localhost:8888/intermitent_site/wp-content/uploads/2025/10/focus-antilles-1.png", "0", "attachment", "image/png", "0");
INSERT INTO `inter_posts` VALUES("88", "1", "2025-10-21 18:53:57", "2025-10-21 16:53:57", "", "1", "", "inherit", "open", "closed", "", "1", "", "", "2025-10-21 18:53:57", "2025-10-21 16:53:57", "", "0", "http://localhost:8888/intermitent_site/wp-content/uploads/2025/10/1.png", "0", "attachment", "image/png", "0");
INSERT INTO `inter_posts` VALUES("89", "1", "2025-10-21 18:53:57", "2025-10-21 16:53:57", "", "2", "", "inherit", "open", "closed", "", "2-2", "", "", "2025-10-21 18:53:57", "2025-10-21 16:53:57", "", "0", "http://localhost:8888/intermitent_site/wp-content/uploads/2025/10/2-1.png", "0", "attachment", "image/png", "0");
INSERT INTO `inter_posts` VALUES("90", "1", "2025-10-21 18:53:57", "2025-10-21 16:53:57", "", "3", "", "inherit", "open", "closed", "", "3-2", "", "", "2025-10-21 18:53:57", "2025-10-21 16:53:57", "", "0", "http://localhost:8888/intermitent_site/wp-content/uploads/2025/10/3-1.png", "0", "attachment", "image/png", "0");
INSERT INTO `inter_posts` VALUES("91", "1", "2025-10-21 18:53:57", "2025-10-21 16:53:57", "", "4", "", "inherit", "open", "closed", "", "4-2", "", "", "2025-10-21 18:53:57", "2025-10-21 16:53:57", "", "0", "http://localhost:8888/intermitent_site/wp-content/uploads/2025/10/4-1.png", "0", "attachment", "image/png", "0");
INSERT INTO `inter_posts` VALUES("92", "1", "2025-10-21 18:53:57", "2025-10-21 16:53:57", "", "5", "", "inherit", "open", "closed", "", "5-2", "", "", "2025-10-21 18:53:57", "2025-10-21 16:53:57", "", "0", "http://localhost:8888/intermitent_site/wp-content/uploads/2025/10/5-1.png", "0", "attachment", "image/png", "0");
INSERT INTO `inter_posts` VALUES("93", "1", "2025-10-21 18:53:57", "2025-10-21 16:53:57", "", "6", "", "inherit", "open", "closed", "", "6", "", "", "2025-10-21 18:53:57", "2025-10-21 16:53:57", "", "0", "http://localhost:8888/intermitent_site/wp-content/uploads/2025/10/6.png", "0", "attachment", "image/png", "0");
INSERT INTO `inter_posts` VALUES("94", "1", "2025-10-21 18:54:09", "2025-10-21 16:54:09", "http://localhost:8888/intermitent_site/wp-content/uploads/2025/10/cropped-2-1.png", "2", "", "inherit", "open", "closed", "", "2-3", "", "", "2025-10-21 18:54:09", "2025-10-21 16:54:09", "", "89", "http://localhost:8888/intermitent_site/wp-content/uploads/2025/10/cropped-2-1.png", "0", "attachment", "image/png", "0");
INSERT INTO `inter_posts` VALUES("95", "1", "2025-10-21 19:10:04", "2025-10-21 17:10:04", "{\"fontFamily\":\"\\\"Roca Two\\\"\"}", "Roca Two", "", "publish", "closed", "closed", "", "roca-two", "", "", "2025-10-21 19:10:04", "2025-10-21 17:10:04", "", "0", "http://localhost:8888/intermitent_site/index.php/2025/10/21/roca-two/", "0", "wp_font_family", "", "0");
INSERT INTO `inter_posts` VALUES("96", "1", "2025-10-21 19:10:04", "2025-10-21 17:10:04", "{\"fontFamily\":\"\\\"Roca Two\\\"\",\"fontStyle\":\"normal\",\"fontWeight\":\"400\",\"src\":\"http:\\/\\/localhost:8888\\/intermitent_site\\/wp-content\\/uploads\\/fonts\\/fonnts.com-Roca_Two_Bold.ttf\"}", "roca two;normal;400;100%;U+0-10FFFF", "", "publish", "closed", "closed", "", "roca-twonormal400100u0-10ffff", "", "", "2025-10-21 19:10:04", "2025-10-21 17:10:04", "", "95", "http://localhost:8888/intermitent_site/index.php/2025/10/21/roca-twonormal400100u0-10ffff/", "0", "wp_font_face", "", "0");
INSERT INTO `inter_posts` VALUES("97", "1", "2025-10-21 19:10:04", "2025-10-21 17:10:04", "{\"styles\":[],\"settings\":{\"typography\":{\"fontFamilies\":{\"theme\":[{\"fontFace\":[{\"fontFamily\":\"Inter\",\"fontStretch\":\"normal\",\"fontStyle\":\"normal\",\"fontWeight\":\"300 900\",\"src\":[\"file:.\\/assets\\/fonts\\/inter\\/Inter-VariableFont_slnt,wght.woff2\"]}],\"fontFamily\":\"\\\"Inter\\\", sans-serif\",\"name\":\"Inter\",\"slug\":\"body\"},{\"fontFace\":[{\"fontFamily\":\"Cardo\",\"fontStyle\":\"normal\",\"fontWeight\":\"400\",\"src\":[\"file:.\\/assets\\/fonts\\/cardo\\/cardo_normal_400.woff2\"]},{\"fontFamily\":\"Cardo\",\"fontStyle\":\"italic\",\"fontWeight\":\"400\",\"src\":[\"file:.\\/assets\\/fonts\\/cardo\\/cardo_italic_400.woff2\"]},{\"fontFamily\":\"Cardo\",\"fontStyle\":\"normal\",\"fontWeight\":\"700\",\"src\":[\"file:.\\/assets\\/fonts\\/cardo\\/cardo_normal_700.woff2\"]}],\"fontFamily\":\"Cardo\",\"name\":\"Cardo\",\"slug\":\"heading\"},{\"fontFamily\":\"-apple-system, BlinkMacSystemFont, avenir next, avenir, segoe ui, helvetica neue, helvetica, Cantarell, Ubuntu, roboto, noto, arial, sans-serif\",\"name\":\"System Sans-serif\",\"slug\":\"system-sans-serif\"},{\"fontFamily\":\"Iowan Old Style, Apple Garamond, Baskerville, Times New Roman, Droid Serif, Times, Source Serif Pro, serif, Apple Color Emoji, Segoe UI Emoji, Segoe UI Symbol\",\"name\":\"System Serif\",\"slug\":\"system-serif\"}],\"custom\":[{\"name\":\"Roca Two\",\"slug\":\"roca-two\",\"fontFamily\":\"\\\"Roca Two\\\"\",\"preview\":\"\",\"fontFace\":[{\"fontFamily\":\"\\\"Roca Two\\\"\",\"fontStyle\":\"normal\",\"fontWeight\":\"400\",\"src\":\"http:\\/\\/localhost:8888\\/intermitent_site\\/wp-content\\/uploads\\/fonts\\/fonnts.com-Roca_Two_Bold.ttf\"}]}]}}},\"isGlobalStylesUserThemeJSON\":true,\"version\":3}", "Custom Styles", "", "inherit", "closed", "closed", "", "8-revision-v1", "", "", "2025-10-21 19:10:04", "2025-10-21 17:10:04", "", "8", "http://localhost:8888/intermitent_site/?p=97", "0", "revision", "", "0");
INSERT INTO `inter_posts` VALUES("98", "1", "2025-10-21 19:10:31", "2025-10-21 17:10:31", "{\"styles\":[],\"settings\":{\"typography\":{\"fontFamilies\":{\"theme\":[{\"fontFace\":[{\"fontFamily\":\"Inter\",\"fontStretch\":\"normal\",\"fontStyle\":\"normal\",\"fontWeight\":\"300 900\",\"src\":[\"file:.\\/assets\\/fonts\\/inter\\/Inter-VariableFont_slnt,wght.woff2\"]}],\"fontFamily\":\"\\\"Inter\\\", sans-serif\",\"name\":\"Inter\",\"slug\":\"body\"},{\"fontFace\":[{\"fontFamily\":\"Cardo\",\"fontStyle\":\"normal\",\"fontWeight\":\"400\",\"src\":[\"file:.\\/assets\\/fonts\\/cardo\\/cardo_normal_400.woff2\"]},{\"fontFamily\":\"Cardo\",\"fontStyle\":\"italic\",\"fontWeight\":\"400\",\"src\":[\"file:.\\/assets\\/fonts\\/cardo\\/cardo_italic_400.woff2\"]},{\"fontFamily\":\"Cardo\",\"fontStyle\":\"normal\",\"fontWeight\":\"700\",\"src\":[\"file:.\\/assets\\/fonts\\/cardo\\/cardo_normal_700.woff2\"]}],\"fontFamily\":\"Cardo\",\"name\":\"Cardo\",\"slug\":\"heading\"},{\"fontFamily\":\"-apple-system, BlinkMacSystemFont, avenir next, avenir, segoe ui, helvetica neue, helvetica, Cantarell, Ubuntu, roboto, noto, arial, sans-serif\",\"name\":\"System Sans-serif\",\"slug\":\"system-sans-serif\"},{\"fontFamily\":\"Iowan Old Style, Apple Garamond, Baskerville, Times New Roman, Droid Serif, Times, Source Serif Pro, serif, Apple Color Emoji, Segoe UI Emoji, Segoe UI Symbol\",\"name\":\"System Serif\",\"slug\":\"system-serif\"}],\"custom\":[{\"id\":95,\"name\":\"Roca Two\",\"slug\":\"roca-two\",\"fontFamily\":\"\\\"Roca Two\\\"\",\"preview\":\"\",\"fontFace\":[{\"fontFamily\":\"\\\"Roca Two\\\"\",\"fontStyle\":\"normal\",\"fontWeight\":\"400\",\"src\":\"http:\\/\\/localhost:8888\\/intermitent_site\\/wp-content\\/uploads\\/fonts\\/fonnts.com-Roca_Two_Bold.ttf\"}],\"source\":\"custom\"}]}}},\"isGlobalStylesUserThemeJSON\":true,\"version\":3}", "Custom Styles", "", "inherit", "closed", "closed", "", "8-revision-v1", "", "", "2025-10-21 19:10:31", "2025-10-21 17:10:31", "", "8", "http://localhost:8888/intermitent_site/?p=98", "0", "revision", "", "0");
INSERT INTO `inter_posts` VALUES("99", "1", "2025-10-21 19:10:37", "0000-00-00 00:00:00", "", "Brouillon auto", "", "auto-draft", "open", "open", "", "", "", "", "2025-10-21 19:10:37", "0000-00-00 00:00:00", "", "0", "http://localhost:8888/intermitent_site/?p=99", "0", "post", "", "0");
INSERT INTO `inter_posts` VALUES("100", "1", "2025-10-21 19:11:54", "2025-10-21 17:11:54", "<!-- wp:paragraph {\"fontFamily\":\"roca-two\"} -->\n<p class=\"has-roca-two-font-family\">coucou j\'ai des choses a dire</p>\n<!-- /wp:paragraph -->", "Test", "", "trash", "closed", "closed", "", "test__trashed", "", "", "2025-10-21 19:12:16", "2025-10-21 17:12:16", "", "0", "http://localhost:8888/intermitent_site/?page_id=100", "0", "page", "", "0");
INSERT INTO `inter_posts` VALUES("101", "1", "2025-10-21 19:11:52", "2025-10-21 17:11:52", "<!-- wp:paragraph {\"fontFamily\":\"roca-two\"} -->\n<p class=\"has-roca-two-font-family\">coucou j\'ai des choses a dire</p>\n<!-- /wp:paragraph -->", "Test", "", "inherit", "closed", "closed", "", "100-revision-v1", "", "", "2025-10-21 19:11:52", "2025-10-21 17:11:52", "", "100", "http://localhost:8888/intermitent_site/?p=101", "0", "revision", "", "0");
INSERT INTO `inter_posts` VALUES("102", "1", "2025-10-21 19:11:52", "2025-10-21 17:11:52", "<!-- wp:group {\"style\":{\"spacing\":{\"padding\":{\"top\":\"var:preset|spacing|50\",\"bottom\":\"var:preset|spacing|50\"}}},\"layout\":{\"type\":\"constrained\"}} -->\n<div class=\"wp-block-group\" style=\"padding-top:var(--wp--preset--spacing--50);padding-bottom:var(--wp--preset--spacing--50)\"><!-- wp:columns {\"align\":\"wide\"} -->\n<div class=\"wp-block-columns alignwide\"><!-- wp:column {\"width\":\"30%\"} -->\n<div class=\"wp-block-column\" style=\"flex-basis:30%\"><!-- wp:group {\"style\":{\"dimensions\":{\"minHeight\":\"\"},\"layout\":{\"selfStretch\":\"fit\",\"flexSize\":null}},\"layout\":{\"type\":\"flex\",\"orientation\":\"vertical\"}} -->\n<div class=\"wp-block-group\"><!-- wp:site-logo {\"width\":20,\"shouldSyncIcon\":false,\"style\":{\"layout\":{\"selfStretch\":\"fit\",\"flexSize\":null}}} /-->\n\n<!-- wp:site-title {\"level\":0,\"fontSize\":\"medium\"} /-->\n\n<!-- wp:site-tagline {\"fontSize\":\"small\"} /--></div>\n<!-- /wp:group --></div>\n<!-- /wp:column -->\n\n<!-- wp:column {\"width\":\"20%\"} -->\n<div class=\"wp-block-column\" style=\"flex-basis:20%\"></div>\n<!-- /wp:column -->\n\n<!-- wp:column {\"width\":\"50%\"} -->\n<div class=\"wp-block-column\" style=\"flex-basis:50%\"><!-- wp:group {\"layout\":{\"type\":\"flex\",\"flexWrap\":\"wrap\",\"justifyContent\":\"space-between\",\"verticalAlignment\":\"top\"}} -->\n<div class=\"wp-block-group\"><!-- wp:group {\"layout\":{\"type\":\"flex\",\"orientation\":\"vertical\",\"justifyContent\":\"stretch\"}} -->\n<div class=\"wp-block-group\"><!-- wp:heading {\"className\":\"has-medium-font-size\",\"style\":{\"typography\":{\"fontStyle\":\"normal\",\"fontWeight\":\"600\"}},\"fontFamily\":\"body\"} -->\n<h2 class=\"wp-block-heading has-medium-font-size has-body-font-family\" style=\"font-style:normal;font-weight:600\">À propos</h2>\n<!-- /wp:heading -->\n\n<!-- wp:group {\"style\":{\"spacing\":{\"blockGap\":\"var:preset|spacing|10\"}},\"layout\":{\"type\":\"flex\",\"orientation\":\"vertical\"}} -->\n<div class=\"wp-block-group\"><!-- wp:navigation {\"overlayMenu\":\"never\",\"style\":{\"typography\":{\"fontStyle\":\"normal\",\"fontWeight\":\"400\"},\"spacing\":{\"blockGap\":\"var:preset|spacing|10\"}},\"fontSize\":\"small\",\"layout\":{\"type\":\"flex\",\"orientation\":\"vertical\"},\"ariaLabel\":\"À propos\"} -->\n<!-- wp:navigation-link {\"label\":\"Équipe\",\"url\":\"#\"} /-->\n\n<!-- wp:navigation-link {\"label\":\"Histoire\",\"url\":\"#\"} /-->\n\n<!-- wp:navigation-link {\"label\":\"Emplois\",\"url\":\"#\"} /-->\n<!-- /wp:navigation --></div>\n<!-- /wp:group --></div>\n<!-- /wp:group -->\n\n<!-- wp:group {\"layout\":{\"type\":\"flex\",\"orientation\":\"vertical\",\"justifyContent\":\"stretch\"}} -->\n<div class=\"wp-block-group\"><!-- wp:heading {\"className\":\"has-medium-font-size\",\"style\":{\"typography\":{\"fontStyle\":\"normal\",\"fontWeight\":\"600\"}},\"fontFamily\":\"body\"} -->\n<h2 class=\"wp-block-heading has-medium-font-size has-body-font-family\" style=\"font-style:normal;font-weight:600\">Confidentialité</h2>\n<!-- /wp:heading -->\n\n<!-- wp:group {\"style\":{\"spacing\":{\"blockGap\":\"var:preset|spacing|10\"}},\"layout\":{\"type\":\"flex\",\"orientation\":\"vertical\"}} -->\n<div class=\"wp-block-group\"><!-- wp:navigation {\"overlayMenu\":\"never\",\"style\":{\"typography\":{\"fontStyle\":\"normal\",\"fontWeight\":\"400\"},\"spacing\":{\"blockGap\":\"var:preset|spacing|10\"}},\"fontSize\":\"small\",\"layout\":{\"type\":\"flex\",\"orientation\":\"vertical\"},\"ariaLabel\":\"Confidentialité\"} -->\n<!-- wp:navigation-link {\"label\":\"Politique de confidentialité\",\"url\":\"#\"} /-->\n\n<!-- wp:navigation-link {\"label\":\"Conditions générales\",\"url\":\"#\"} /-->\n\n<!-- wp:navigation-link {\"label\":\"Nous contacter\",\"url\":\"#\"} /-->\n<!-- /wp:navigation --></div>\n<!-- /wp:group --></div>\n<!-- /wp:group -->\n\n<!-- wp:group {\"layout\":{\"type\":\"flex\",\"orientation\":\"vertical\",\"justifyContent\":\"stretch\"}} -->\n<div class=\"wp-block-group\"><!-- wp:heading {\"className\":\"has-medium-font-size\",\"style\":{\"typography\":{\"fontStyle\":\"normal\",\"fontWeight\":\"600\"}},\"fontFamily\":\"body\"} -->\n<h2 class=\"wp-block-heading has-medium-font-size has-body-font-family\" style=\"font-style:normal;font-weight:600\">Réseaux sociaux</h2>\n<!-- /wp:heading -->\n\n<!-- wp:group {\"style\":{\"spacing\":{\"blockGap\":\"var:preset|spacing|10\"}},\"layout\":{\"type\":\"flex\",\"orientation\":\"vertical\"}} -->\n<div class=\"wp-block-group\"><!-- wp:navigation {\"overlayMenu\":\"never\",\"style\":{\"typography\":{\"fontStyle\":\"normal\",\"fontWeight\":\"400\"},\"spacing\":{\"blockGap\":\"var:preset|spacing|10\"}},\"fontSize\":\"small\",\"layout\":{\"type\":\"flex\",\"orientation\":\"vertical\"},\"ariaLabel\":\"Réseaux sociaux\"} -->\n<!-- wp:navigation-link {\"label\":\"Facebook\",\"url\":\"#\"} /-->\n\n<!-- wp:navigation-link {\"label\":\"Instagram\",\"url\":\"#\"} /-->\n\n<!-- wp:navigation-link {\"label\":\"Twitter/X\",\"url\":\"#\"} /-->\n<!-- /wp:navigation --></div>\n<!-- /wp:group --></div>\n<!-- /wp:group --></div>\n<!-- /wp:group --></div>\n<!-- /wp:column --></div>\n<!-- /wp:columns -->\n\n<!-- wp:group {\"align\":\"wide\",\"style\":{\"spacing\":{\"padding\":{\"top\":\"var:preset|spacing|50\",\"bottom\":\"0\"}}}} -->\n<div class=\"wp-block-group alignwide\" style=\"padding-top:var(--wp--preset--spacing--50);padding-bottom:0\"><!-- wp:paragraph {\"style\":{\"elements\":{\"link\":{\"color\":{\"text\":\"var:preset|color|contrast\"}}}},\"textColor\":\"contrast-2\",\"fontSize\":\"small\"} -->\n<p class=\"has-contrast-2-color has-text-color has-link-color has-small-font-size\">\n		Conçu avec <a href=\"https://fr.wordpress.org\" rel=\"nofollow\">WordPress</a>		</p>\n<!-- /wp:paragraph --></div>\n<!-- /wp:group --></div>\n<!-- /wp:group -->", "Footer", "", "publish", "closed", "closed", "", "footer", "", "", "2025-10-21 19:11:52", "2025-10-21 17:11:52", "", "0", "http://localhost:8888/intermitent_site/index.php/2025/10/21/footer/", "0", "wp_template_part", "", "0");
INSERT INTO `inter_posts` VALUES("103", "1", "2025-10-22 19:20:15", "2025-10-22 17:20:15", "<!-- wp:heading -->\n<h2 class=\"wp-block-heading\">Qui sommes-nous ?</h2>\n<!-- /wp:heading -->\n<!-- wp:paragraph -->\n<p><strong class=\"privacy-policy-tutorial\">Texte suggéré : </strong>L’adresse de notre site est : http://localhost:8888/intermitent_site.</p>\n<!-- /wp:paragraph -->\n<!-- wp:heading -->\n<h2 class=\"wp-block-heading\">Commentaires</h2>\n<!-- /wp:heading -->\n<!-- wp:paragraph -->\n<p><strong class=\"privacy-policy-tutorial\">Texte suggéré : </strong>Quand vous laissez un commentaire sur notre site, les données inscrites dans le formulaire de commentaire, ainsi que votre adresse IP et l’agent utilisateur de votre navigateur sont collectés pour nous aider à la détection des commentaires indésirables.</p>\n<!-- /wp:paragraph -->\n<!-- wp:paragraph -->\n<p>Une chaîne anonymisée créée à partir de votre adresse e-mail (également appelée hash) peut être envoyée au service Gravatar pour vérifier si vous utilisez ce dernier. Les clauses de confidentialité du service Gravatar sont disponibles ici : https://automattic.com/privacy/. Après validation de votre commentaire, votre photo de profil sera visible publiquement à coté de votre commentaire.</p>\n<!-- /wp:paragraph -->\n<!-- wp:heading -->\n<h2 class=\"wp-block-heading\">Médias</h2>\n<!-- /wp:heading -->\n<!-- wp:paragraph -->\n<p><strong class=\"privacy-policy-tutorial\">Texte suggéré : </strong>Si vous téléversez des images sur le site, nous vous conseillons d’éviter de téléverser des images contenant des données EXIF de coordonnées GPS. Les personnes visitant votre site peuvent télécharger et extraire des données de localisation depuis ces images.</p>\n<!-- /wp:paragraph -->\n<!-- wp:heading -->\n<h2 class=\"wp-block-heading\">Cookies</h2>\n<!-- /wp:heading -->\n<!-- wp:paragraph -->\n<p><strong class=\"privacy-policy-tutorial\">Texte suggéré : </strong>Si vous déposez un commentaire sur notre site, il vous sera proposé d’enregistrer votre nom, adresse e-mail et site dans des cookies. C’est uniquement pour votre confort afin de ne pas avoir à saisir ces informations si vous déposez un autre commentaire plus tard. Ces cookies expirent au bout d’un an.</p>\n<!-- /wp:paragraph -->\n<!-- wp:paragraph -->\n<p>Si vous vous rendez sur la page de connexion, un cookie temporaire sera créé afin de déterminer si votre navigateur accepte les cookies. Il ne contient pas de données personnelles et sera supprimé automatiquement à la fermeture de votre navigateur.</p>\n<!-- /wp:paragraph -->\n<!-- wp:paragraph -->\n<p>Lorsque vous vous connecterez, nous mettrons en place un certain nombre de cookies pour enregistrer vos informations de connexion et vos préférences d’écran. La durée de vie d’un cookie de connexion est de deux jours, celle d’un cookie d’option d’écran est d’un an. Si vous cochez « Se souvenir de moi », votre cookie de connexion sera conservé pendant deux semaines. Si vous vous déconnectez de votre compte, le cookie de connexion sera effacé.</p>\n<!-- /wp:paragraph -->\n<!-- wp:paragraph -->\n<p>En modifiant ou en publiant une publication, un cookie supplémentaire sera enregistré dans votre navigateur. Ce cookie ne comprend aucune donnée personnelle. Il indique simplement l’ID de la publication que vous venez de modifier. Il expire au bout d’un jour.</p>\n<!-- /wp:paragraph -->\n<!-- wp:heading -->\n<h2 class=\"wp-block-heading\">Contenu embarqué depuis d’autres sites</h2>\n<!-- /wp:heading -->\n<!-- wp:paragraph -->\n<p><strong class=\"privacy-policy-tutorial\">Texte suggéré : </strong>Les articles de ce site peuvent inclure des contenus intégrés (par exemple des vidéos, images, articles…). Le contenu intégré depuis d’autres sites se comporte de la même manière que si le visiteur se rendait sur cet autre site.</p>\n<!-- /wp:paragraph -->\n<!-- wp:paragraph -->\n<p>Ces sites web pourraient collecter des données sur vous, utiliser des cookies, embarquer des outils de suivis tiers, suivre vos interactions avec ces contenus embarqués si vous disposez d’un compte connecté sur leur site web.</p>\n<!-- /wp:paragraph -->\n<!-- wp:heading -->\n<h2 class=\"wp-block-heading\">Utilisation et transmission de vos données personnelles</h2>\n<!-- /wp:heading -->\n<!-- wp:paragraph -->\n<p><strong class=\"privacy-policy-tutorial\">Texte suggéré : </strong>Si vous demandez une réinitialisation de votre mot de passe, votre adresse IP sera incluse dans l’e-mail de réinitialisation.</p>\n<!-- /wp:paragraph -->\n<!-- wp:heading -->\n<h2 class=\"wp-block-heading\">Durées de stockage de vos données</h2>\n<!-- /wp:heading -->\n<!-- wp:paragraph -->\n<p><strong class=\"privacy-policy-tutorial\">Texte suggéré : </strong>Si vous laissez un commentaire, le commentaire et ses métadonnées sont conservés indéfiniment. Cela permet de reconnaître et approuver automatiquement les commentaires suivants au lieu de les laisser dans la file de modération.</p>\n<!-- /wp:paragraph -->\n<!-- wp:paragraph -->\n<p>Pour les comptes qui s’inscrivent sur notre site (le cas échéant), nous stockons également les données personnelles indiquées dans leur profil. Tous les comptes peuvent voir, modifier ou supprimer leurs informations personnelles à tout moment (à l’exception de leur identifiant). Les gestionnaires du site peuvent aussi voir et modifier ces informations.</p>\n<!-- /wp:paragraph -->\n<!-- wp:heading -->\n<h2 class=\"wp-block-heading\">Les droits que vous avez sur vos données</h2>\n<!-- /wp:heading -->\n<!-- wp:paragraph -->\n<p><strong class=\"privacy-policy-tutorial\">Texte suggéré : </strong>Si vous avez un compte ou si vous avez laissé des commentaires sur le site, vous pouvez demander à recevoir un fichier contenant toutes les données personnelles que nous possédons à votre sujet, incluant celles que vous nous avez fournies. Vous pouvez également demander la suppression des données personnelles vous concernant. Cela ne prend pas en compte les données stockées à des fins administratives, légales ou pour des raisons de sécurité.</p>\n<!-- /wp:paragraph -->\n<!-- wp:heading -->\n<h2 class=\"wp-block-heading\">Où vos données sont envoyées</h2>\n<!-- /wp:heading -->\n<!-- wp:paragraph -->\n<p><strong class=\"privacy-policy-tutorial\">Texte suggéré : </strong>Les commentaires des visiteurs peuvent être vérifiés à l’aide d’un service automatisé de détection des commentaires indésirables.</p>\n<!-- /wp:paragraph -->\n", "Politique de confidentialité", "", "inherit", "closed", "closed", "", "3-revision-v1", "", "", "2025-10-22 19:20:15", "2025-10-22 17:20:15", "", "3", "http://localhost:8888/intermitent_site/?p=103", "0", "revision", "", "0");

/* INSERT TABLE DATA: inter_term_relationships */
INSERT INTO `inter_term_relationships` VALUES("1", "1", "0");
INSERT INTO `inter_term_relationships` VALUES("7", "2", "0");
INSERT INTO `inter_term_relationships` VALUES("8", "3", "0");
INSERT INTO `inter_term_relationships` VALUES("9", "4", "0");
INSERT INTO `inter_term_relationships` VALUES("42", "3", "0");
INSERT INTO `inter_term_relationships` VALUES("48", "3", "0");
INSERT INTO `inter_term_relationships` VALUES("51", "3", "0");
INSERT INTO `inter_term_relationships` VALUES("65", "1", "0");
INSERT INTO `inter_term_relationships` VALUES("65", "8", "0");
INSERT INTO `inter_term_relationships` VALUES("65", "36", "0");
INSERT INTO `inter_term_relationships` VALUES("102", "3", "0");
INSERT INTO `inter_term_relationships` VALUES("102", "126", "0");

/* INSERT TABLE DATA: inter_term_taxonomy */
INSERT INTO `inter_term_taxonomy` VALUES("1", "1", "category", "", "0", "0");
INSERT INTO `inter_term_taxonomy` VALUES("2", "2", "wp_theme", "", "0", "1");
INSERT INTO `inter_term_taxonomy` VALUES("3", "3", "wp_theme", "", "0", "5");
INSERT INTO `inter_term_taxonomy` VALUES("4", "4", "wp_theme", "", "0", "1");
INSERT INTO `inter_term_taxonomy` VALUES("5", "5", "wp_template_part_area", "", "0", "0");
INSERT INTO `inter_term_taxonomy` VALUES("6", "6", "sport", "", "0", "0");
INSERT INTO `inter_term_taxonomy` VALUES("7", "7", "sport", "", "6", "0");
INSERT INTO `inter_term_taxonomy` VALUES("8", "8", "sport", "", "6", "1");
INSERT INTO `inter_term_taxonomy` VALUES("9", "9", "metier", "", "0", "0");
INSERT INTO `inter_term_taxonomy` VALUES("10", "10", "metier", "", "9", "0");
INSERT INTO `inter_term_taxonomy` VALUES("11", "11", "metier", "", "9", "0");
INSERT INTO `inter_term_taxonomy` VALUES("12", "12", "metier", "", "9", "0");
INSERT INTO `inter_term_taxonomy` VALUES("13", "13", "metier", "", "9", "0");
INSERT INTO `inter_term_taxonomy` VALUES("14", "14", "metier", "", "9", "0");
INSERT INTO `inter_term_taxonomy` VALUES("15", "15", "metier", "", "9", "0");
INSERT INTO `inter_term_taxonomy` VALUES("16", "16", "metier", "", "9", "0");
INSERT INTO `inter_term_taxonomy` VALUES("17", "17", "metier", "", "0", "0");
INSERT INTO `inter_term_taxonomy` VALUES("18", "18", "metier", "", "17", "0");
INSERT INTO `inter_term_taxonomy` VALUES("19", "19", "metier", "", "17", "0");
INSERT INTO `inter_term_taxonomy` VALUES("20", "20", "metier", "", "17", "0");
INSERT INTO `inter_term_taxonomy` VALUES("21", "21", "metier", "", "17", "0");
INSERT INTO `inter_term_taxonomy` VALUES("22", "22", "metier", "", "17", "0");
INSERT INTO `inter_term_taxonomy` VALUES("23", "23", "metier", "", "17", "0");
INSERT INTO `inter_term_taxonomy` VALUES("24", "24", "metier", "", "0", "0");
INSERT INTO `inter_term_taxonomy` VALUES("25", "25", "metier", "", "24", "0");
INSERT INTO `inter_term_taxonomy` VALUES("26", "26", "metier", "", "24", "0");
INSERT INTO `inter_term_taxonomy` VALUES("27", "27", "metier", "", "24", "0");
INSERT INTO `inter_term_taxonomy` VALUES("28", "28", "metier", "", "24", "0");
INSERT INTO `inter_term_taxonomy` VALUES("29", "29", "metier", "", "24", "0");
INSERT INTO `inter_term_taxonomy` VALUES("30", "30", "metier", "", "24", "0");
INSERT INTO `inter_term_taxonomy` VALUES("31", "31", "metier", "", "24", "0");
INSERT INTO `inter_term_taxonomy` VALUES("32", "32", "metier", "", "24", "0");
INSERT INTO `inter_term_taxonomy` VALUES("33", "33", "metier", "", "24", "0");
INSERT INTO `inter_term_taxonomy` VALUES("34", "34", "metier", "", "24", "0");
INSERT INTO `inter_term_taxonomy` VALUES("35", "35", "metier", "", "0", "0");
INSERT INTO `inter_term_taxonomy` VALUES("36", "36", "metier", "", "35", "0");
INSERT INTO `inter_term_taxonomy` VALUES("37", "37", "metier", "", "35", "0");
INSERT INTO `inter_term_taxonomy` VALUES("38", "38", "metier", "", "35", "0");
INSERT INTO `inter_term_taxonomy` VALUES("39", "39", "metier", "", "35", "0");
INSERT INTO `inter_term_taxonomy` VALUES("40", "40", "permis", "", "67", "0");
INSERT INTO `inter_term_taxonomy` VALUES("41", "41", "permis", "", "67", "0");
INSERT INTO `inter_term_taxonomy` VALUES("42", "42", "permis", "", "67", "0");
INSERT INTO `inter_term_taxonomy` VALUES("43", "43", "permis", "", "67", "0");
INSERT INTO `inter_term_taxonomy` VALUES("45", "45", "permis", "", "67", "0");
INSERT INTO `inter_term_taxonomy` VALUES("46", "46", "permis", "", "67", "0");
INSERT INTO `inter_term_taxonomy` VALUES("47", "47", "permis", "", "67", "0");
INSERT INTO `inter_term_taxonomy` VALUES("48", "48", "permis", "", "67", "0");
INSERT INTO `inter_term_taxonomy` VALUES("49", "49", "permis", "", "67", "0");
INSERT INTO `inter_term_taxonomy` VALUES("50", "50", "permis", "", "67", "0");
INSERT INTO `inter_term_taxonomy` VALUES("51", "51", "permis", "", "67", "0");
INSERT INTO `inter_term_taxonomy` VALUES("53", "53", "permis", "Engin de chantier", "66", "0");
INSERT INTO `inter_term_taxonomy` VALUES("54", "54", "permis", "Grue à tour", "66", "0");
INSERT INTO `inter_term_taxonomy` VALUES("55", "55", "permis", "Grue mobile", "66", "0");
INSERT INTO `inter_term_taxonomy` VALUES("56", "56", "permis", "Nacelle élévatrice", "66", "0");
INSERT INTO `inter_term_taxonomy` VALUES("57", "57", "permis", "Chariot élévateur", "66", "0");
INSERT INTO `inter_term_taxonomy` VALUES("58", "58", "permis", "Camion grue", "66", "0");
INSERT INTO `inter_term_taxonomy` VALUES("59", "59", "permis", "Pont roulant et portique", "66", "0");
INSERT INTO `inter_term_taxonomy` VALUES("60", "60", "permis", "Chariot de manutention automoteur gerbeur à conducteur accompagnant", "66", "0");
INSERT INTO `inter_term_taxonomy` VALUES("61", "61", "region", "", "0", "0");
INSERT INTO `inter_term_taxonomy` VALUES("62", "62", "region", "", "0", "0");
INSERT INTO `inter_term_taxonomy` VALUES("65", "65", "region", "", "0", "0");
INSERT INTO `inter_term_taxonomy` VALUES("66", "66", "permis", "", "0", "0");
INSERT INTO `inter_term_taxonomy` VALUES("67", "67", "permis", "", "0", "0");
INSERT INTO `inter_term_taxonomy` VALUES("68", "68", "metier", "", "0", "0");
INSERT INTO `inter_term_taxonomy` VALUES("69", "69", "metier", "", "68", "0");
INSERT INTO `inter_term_taxonomy` VALUES("70", "70", "metier", "", "68", "0");
INSERT INTO `inter_term_taxonomy` VALUES("71", "71", "metier", "", "68", "0");
INSERT INTO `inter_term_taxonomy` VALUES("72", "72", "metier", "", "24", "0");
INSERT INTO `inter_term_taxonomy` VALUES("73", "73", "metier", "", "0", "0");
INSERT INTO `inter_term_taxonomy` VALUES("74", "74", "metier", "", "73", "0");
INSERT INTO `inter_term_taxonomy` VALUES("75", "75", "metier", "", "73", "0");
INSERT INTO `inter_term_taxonomy` VALUES("76", "76", "metier", "", "73", "0");
INSERT INTO `inter_term_taxonomy` VALUES("77", "77", "metier", "", "73", "0");
INSERT INTO `inter_term_taxonomy` VALUES("78", "78", "metier", "", "0", "0");
INSERT INTO `inter_term_taxonomy` VALUES("79", "79", "metier", "", "78", "0");
INSERT INTO `inter_term_taxonomy` VALUES("80", "80", "metier", "", "78", "0");
INSERT INTO `inter_term_taxonomy` VALUES("81", "81", "metier", "", "78", "0");
INSERT INTO `inter_term_taxonomy` VALUES("82", "82", "metier", "", "78", "0");
INSERT INTO `inter_term_taxonomy` VALUES("83", "83", "metier", "", "78", "0");
INSERT INTO `inter_term_taxonomy` VALUES("84", "84", "metier", "", "78", "0");
INSERT INTO `inter_term_taxonomy` VALUES("85", "85", "metier", "", "78", "0");
INSERT INTO `inter_term_taxonomy` VALUES("86", "86", "metier", "", "78", "0");
INSERT INTO `inter_term_taxonomy` VALUES("87", "87", "metier", "", "78", "0");
INSERT INTO `inter_term_taxonomy` VALUES("88", "88", "metier", "", "0", "0");
INSERT INTO `inter_term_taxonomy` VALUES("89", "89", "metier", "", "88", "0");
INSERT INTO `inter_term_taxonomy` VALUES("90", "90", "metier", "", "88", "0");
INSERT INTO `inter_term_taxonomy` VALUES("91", "91", "metier", "", "88", "0");
INSERT INTO `inter_term_taxonomy` VALUES("92", "92", "metier", "", "88", "0");
INSERT INTO `inter_term_taxonomy` VALUES("93", "93", "metier", "", "0", "0");
INSERT INTO `inter_term_taxonomy` VALUES("94", "94", "metier", "", "93", "0");
INSERT INTO `inter_term_taxonomy` VALUES("95", "95", "metier", "", "93", "0");
INSERT INTO `inter_term_taxonomy` VALUES("96", "96", "metier", "", "93", "0");
INSERT INTO `inter_term_taxonomy` VALUES("97", "97", "metier", "", "93", "0");
INSERT INTO `inter_term_taxonomy` VALUES("98", "98", "metier", "", "0", "0");
INSERT INTO `inter_term_taxonomy` VALUES("99", "99", "metier", "", "98", "0");
INSERT INTO `inter_term_taxonomy` VALUES("100", "100", "metier", "", "98", "0");
INSERT INTO `inter_term_taxonomy` VALUES("101", "101", "metier", "", "98", "0");
INSERT INTO `inter_term_taxonomy` VALUES("102", "102", "metier", "", "98", "0");
INSERT INTO `inter_term_taxonomy` VALUES("103", "103", "metier", "", "0", "0");
INSERT INTO `inter_term_taxonomy` VALUES("104", "104", "metier", "", "103", "0");
INSERT INTO `inter_term_taxonomy` VALUES("105", "105", "metier", "", "103", "0");
INSERT INTO `inter_term_taxonomy` VALUES("106", "106", "metier", "", "103", "0");
INSERT INTO `inter_term_taxonomy` VALUES("107", "107", "metier", "", "103", "0");
INSERT INTO `inter_term_taxonomy` VALUES("108", "108", "metier", "", "103", "0");
INSERT INTO `inter_term_taxonomy` VALUES("109", "109", "metier", "", "103", "0");
INSERT INTO `inter_term_taxonomy` VALUES("110", "110", "metier", "", "103", "0");
INSERT INTO `inter_term_taxonomy` VALUES("111", "111", "metier", "", "103", "0");
INSERT INTO `inter_term_taxonomy` VALUES("112", "112", "metier", "", "103", "0");
INSERT INTO `inter_term_taxonomy` VALUES("113", "113", "metier", "", "103", "0");
INSERT INTO `inter_term_taxonomy` VALUES("114", "114", "metier", "", "0", "0");
INSERT INTO `inter_term_taxonomy` VALUES("115", "115", "metier", "", "114", "0");
INSERT INTO `inter_term_taxonomy` VALUES("116", "116", "metier", "", "114", "0");
INSERT INTO `inter_term_taxonomy` VALUES("117", "117", "metier", "", "114", "0");
INSERT INTO `inter_term_taxonomy` VALUES("118", "118", "metier", "", "114", "0");
INSERT INTO `inter_term_taxonomy` VALUES("119", "119", "metier", "", "114", "0");
INSERT INTO `inter_term_taxonomy` VALUES("120", "120", "metier", "", "0", "0");
INSERT INTO `inter_term_taxonomy` VALUES("121", "121", "metier", "", "120", "0");
INSERT INTO `inter_term_taxonomy` VALUES("122", "122", "metier", "", "120", "0");
INSERT INTO `inter_term_taxonomy` VALUES("123", "123", "metier", "", "120", "0");
INSERT INTO `inter_term_taxonomy` VALUES("124", "124", "metier", "", "120", "0");
INSERT INTO `inter_term_taxonomy` VALUES("125", "125", "metier", "", "120", "0");
INSERT INTO `inter_term_taxonomy` VALUES("126", "126", "wp_template_part_area", "", "0", "1");

/* INSERT TABLE DATA: inter_terms */
INSERT INTO `inter_terms` VALUES("1", "Non classé", "non-classe", "0");
INSERT INTO `inter_terms` VALUES("2", "twentytwentyfive", "twentytwentyfive", "0");
INSERT INTO `inter_terms` VALUES("3", "inter-theme", "inter-theme", "0");
INSERT INTO `inter_terms` VALUES("4", "twentytwentyfour", "twentytwentyfour", "0");
INSERT INTO `inter_terms` VALUES("5", "header", "header", "0");
INSERT INTO `inter_terms` VALUES("6", "test", "test", "0");
INSERT INTO `inter_terms` VALUES("7", "test enfant", "test-enfant", "0");
INSERT INTO `inter_terms` VALUES("8", "encore", "encore", "0");
INSERT INTO `inter_terms` VALUES("9", "Production", "production", "0");
INSERT INTO `inter_terms` VALUES("10", "Producteur / Productrice", "producer", "0");
INSERT INTO `inter_terms` VALUES("11", "Producteur exécutif", "executive-producer", "0");
INSERT INTO `inter_terms` VALUES("12", "Directeur de production", "dir-producer", "0");
INSERT INTO `inter_terms` VALUES("13", "Administrateur de production", "admin-producer", "0");
INSERT INTO `inter_terms` VALUES("14", "Assistant de production", "assist-producer", "0");
INSERT INTO `inter_terms` VALUES("15", "Secrétaire de production", "sec-producer", "0");
INSERT INTO `inter_terms` VALUES("16", "Chargé de production", "charged-producer", "0");
INSERT INTO `inter_terms` VALUES("17", "Réalisation", "realisation", "0");
INSERT INTO `inter_terms` VALUES("18", "Réalisateur / Réalisatrice", "realisateur", "0");
INSERT INTO `inter_terms` VALUES("19", "1er Assistant réalisateur", "first-ad", "0");
INSERT INTO `inter_terms` VALUES("20", "2eme Assistant réalisateur", "second-ad", "0");
INSERT INTO `inter_terms` VALUES("21", "3eme Assistant réalisateur", "third-ad", "0");
INSERT INTO `inter_terms` VALUES("22", "Script / Scripte", "script", "0");
INSERT INTO `inter_terms` VALUES("23", "Storyboarder", "story-boarder", "0");
INSERT INTO `inter_terms` VALUES("24", "Image", "image", "0");
INSERT INTO `inter_terms` VALUES("25", "Directeur de la photographie", "chef-op", "0");
INSERT INTO `inter_terms` VALUES("26", "Chef opérateur caméra", "chef-op-camera", "0");
INSERT INTO `inter_terms` VALUES("27", "Opérateur de prise de vues", "op-vue", "0");
INSERT INTO `inter_terms` VALUES("28", "Cadreur", "cadreur", "0");
INSERT INTO `inter_terms` VALUES("29", "1er assistant caméra", "first-ass-cam", "0");
INSERT INTO `inter_terms` VALUES("30", "2eme assistant caméra", "second-ass-cam", "0");
INSERT INTO `inter_terms` VALUES("31", "3eme assistant caméra", "third-ass-cam", "0");
INSERT INTO `inter_terms` VALUES("32", "Assistant video", "video-asst", "0");
INSERT INTO `inter_terms` VALUES("33", "Digital Imaging Technician", "dig-img-tech", "0");
INSERT INTO `inter_terms` VALUES("34", "Photographe de plateau", "set-photographer", "0");
INSERT INTO `inter_terms` VALUES("35", "Lumière", "lumiere", "0");
INSERT INTO `inter_terms` VALUES("36", "Chef électricien", "gaffer", "0");
INSERT INTO `inter_terms` VALUES("37", "Électricien", "elec", "0");
INSERT INTO `inter_terms` VALUES("38", "Assistant électricien", "asst-elec", "0");
INSERT INTO `inter_terms` VALUES("39", "Pupitreur lumière", "pup-elec", "0");
INSERT INTO `inter_terms` VALUES("40", "A", "permis-a", "0");
INSERT INTO `inter_terms` VALUES("41", "B", "permis-b", "0");
INSERT INTO `inter_terms` VALUES("42", "C", "permis-c", "0");
INSERT INTO `inter_terms` VALUES("43", "D", "permis-d", "0");
INSERT INTO `inter_terms` VALUES("45", "A1", "permis-a1", "0");
INSERT INTO `inter_terms` VALUES("46", "A2", "permis-a2", "0");
INSERT INTO `inter_terms` VALUES("47", "C1", "permis-c1", "0");
INSERT INTO `inter_terms` VALUES("48", "C1E", "permis-c1e", "0");
INSERT INTO `inter_terms` VALUES("49", "BE", "permis-be", "0");
INSERT INTO `inter_terms` VALUES("50", "CE", "permis-ce", "0");
INSERT INTO `inter_terms` VALUES("51", "DE", "permis-de", "0");
INSERT INTO `inter_terms` VALUES("53", "R482", "permis-r482", "0");
INSERT INTO `inter_terms` VALUES("54", "R487", "permis-r487", "0");
INSERT INTO `inter_terms` VALUES("55", "R483", "permis-r483", "0");
INSERT INTO `inter_terms` VALUES("56", "R486", "permis-r486", "0");
INSERT INTO `inter_terms` VALUES("57", "R489", "permis_r489", "0");
INSERT INTO `inter_terms` VALUES("58", "R490", "permis-r490", "0");
INSERT INTO `inter_terms` VALUES("59", "R484", "permis-r484", "0");
INSERT INTO `inter_terms` VALUES("60", "R485", "permis-r485", "0");
INSERT INTO `inter_terms` VALUES("61", "Guadeloupe", "guadeloupe", "0");
INSERT INTO `inter_terms` VALUES("62", "Martinique", "martinique", "0");
INSERT INTO `inter_terms` VALUES("65", "Guyane", "guyane", "0");
INSERT INTO `inter_terms` VALUES("66", "CACES", "caces", "0");
INSERT INTO `inter_terms` VALUES("67", "Classique", "classic", "0");
INSERT INTO `inter_terms` VALUES("68", "Machinerie", "machinerie", "0");
INSERT INTO `inter_terms` VALUES("69", "Chef machiniste", "chef-machiniste", "0");
INSERT INTO `inter_terms` VALUES("70", "Machiniste", "machiniste", "0");
INSERT INTO `inter_terms` VALUES("71", "Grutier", "grutier", "0");
INSERT INTO `inter_terms` VALUES("72", "Opérateur steadicam / stabilisateur", "op-stead-stab", "0");
INSERT INTO `inter_terms` VALUES("73", "Son", "son", "0");
INSERT INTO `inter_terms` VALUES("74", "Ingénieur du son", "inge-son", "0");
INSERT INTO `inter_terms` VALUES("75", "Perchman", "perchman", "0");
INSERT INTO `inter_terms` VALUES("76", "Assistant son", "asst-son", "0");
INSERT INTO `inter_terms` VALUES("77", "Sound designer", "sound-designer", "0");
INSERT INTO `inter_terms` VALUES("78", "Décors &amp; Direction artistique", "deco", "0");
INSERT INTO `inter_terms` VALUES("79", "Directeur artistique", "dir-artistique", "0");
INSERT INTO `inter_terms` VALUES("80", "Chef décorateur", "chef-deco", "0");
INSERT INTO `inter_terms` VALUES("81", "Assistant décorateur", "asst-deco", "0");
INSERT INTO `inter_terms` VALUES("82", "Chef accessoiriste", "chef-accessoiriste", "0");
INSERT INTO `inter_terms` VALUES("83", "Assistant accessoiriste", "asst-accessoiriste", "0");
INSERT INTO `inter_terms` VALUES("84", "Ensemblier", "ensemblier", "0");
INSERT INTO `inter_terms` VALUES("85", "Constructeur", "constructeur", "0");
INSERT INTO `inter_terms` VALUES("86", "Peintre", "peintre", "0");
INSERT INTO `inter_terms` VALUES("87", "Régisseur plateau décor", "regie-set-deco", "0");
INSERT INTO `inter_terms` VALUES("88", "Costumes", "costumes", "0");
INSERT INTO `inter_terms` VALUES("89", "Chef costumier", "chef-costume", "0");
INSERT INTO `inter_terms` VALUES("90", "Habilleur", "habilleur", "0");
INSERT INTO `inter_terms` VALUES("91", "Couturier", "couturier", "0");
INSERT INTO `inter_terms` VALUES("92", "Assistant costumes", "assistant-cost", "0");
INSERT INTO `inter_terms` VALUES("93", "Maquillage / Coiffure", "maq-coif", "0");
INSERT INTO `inter_terms` VALUES("94", "Chef maquilleur", "chef-maq", "0");
INSERT INTO `inter_terms` VALUES("95", "Maquilleur", "maq", "0");
INSERT INTO `inter_terms` VALUES("96", "Coiffeur", "coiffeur", "0");
INSERT INTO `inter_terms` VALUES("97", "Spécialiste FX", "spe-fx", "0");
INSERT INTO `inter_terms` VALUES("98", "Régie", "regie", "0");
INSERT INTO `inter_terms` VALUES("99", "Régisseur général", "regie-g", "0");
INSERT INTO `inter_terms` VALUES("100", "Régisseur adjoint", "regie-adjoint", "0");
INSERT INTO `inter_terms` VALUES("101", "Régisseur d’extérieur", "regie-ext", "0");
INSERT INTO `inter_terms` VALUES("102", "Chauffeurs / coursiers", "chauf-cours", "0");
INSERT INTO `inter_terms` VALUES("103", "Post-production", "post-prod", "0");
INSERT INTO `inter_terms` VALUES("104", "Monteur image", "mont-img", "0");
INSERT INTO `inter_terms` VALUES("105", "Assistant monteur", "asst-monteur", "0");
INSERT INTO `inter_terms` VALUES("106", "Monteur son", "mont-son", "0");
INSERT INTO `inter_terms` VALUES("107", "Mixeur", "mixeur", "0");
INSERT INTO `inter_terms` VALUES("108", "Bruiteur", "bruiteur", "0");
INSERT INTO `inter_terms` VALUES("109", "Étalonneur", "etalonneur", "0");
INSERT INTO `inter_terms` VALUES("110", "Infographiste", "infographiste", "0");
INSERT INTO `inter_terms` VALUES("111", "Motion designer", "motion-designer", "0");
INSERT INTO `inter_terms` VALUES("112", "Superviseur VFX", "superviseur-vfx", "0");
INSERT INTO `inter_terms` VALUES("113", "Monteur VFX / SFX", "monteur-vfx-sfx", "0");
INSERT INTO `inter_terms` VALUES("114", "Administration / Logistique", "admin-logi", "0");
INSERT INTO `inter_terms` VALUES("115", "Chargé de casting", "charg-casting", "0");
INSERT INTO `inter_terms` VALUES("116", "Directeur de casting", "dir-casting", "0");
INSERT INTO `inter_terms` VALUES("117", "Responsable figuration", "respo-figu", "0");
INSERT INTO `inter_terms` VALUES("118", "Chargé de communication / presse", "charge-de-com", "0");
INSERT INTO `inter_terms` VALUES("119", "Comptable de production", "comptable", "0");
INSERT INTO `inter_terms` VALUES("120", "Autres postes spécialisés", "autre-postes", "0");
INSERT INTO `inter_terms` VALUES("121", "Cascadeur", "cascadeur", "0");
INSERT INTO `inter_terms` VALUES("122", "Coordinateur cascades", "coo-cascade", "0");
INSERT INTO `inter_terms` VALUES("123", "Coach comédiens", "coach-com", "0");
INSERT INTO `inter_terms` VALUES("124", "Traducteur", "trad", "0");
INSERT INTO `inter_terms` VALUES("125", "Sous-titrage", "sous-titre", "0");
INSERT INTO `inter_terms` VALUES("126", "footer", "footer", "0");

/* INSERT TABLE DATA: inter_usermeta */
INSERT INTO `inter_usermeta` VALUES("1", "1", "nickname", "ambre_palanque");
INSERT INTO `inter_usermeta` VALUES("2", "1", "first_name", "");
INSERT INTO `inter_usermeta` VALUES("3", "1", "last_name", "");
INSERT INTO `inter_usermeta` VALUES("4", "1", "description", "");
INSERT INTO `inter_usermeta` VALUES("5", "1", "rich_editing", "true");
INSERT INTO `inter_usermeta` VALUES("6", "1", "syntax_highlighting", "true");
INSERT INTO `inter_usermeta` VALUES("7", "1", "comment_shortcuts", "false");
INSERT INTO `inter_usermeta` VALUES("8", "1", "admin_color", "fresh");
INSERT INTO `inter_usermeta` VALUES("9", "1", "use_ssl", "0");
INSERT INTO `inter_usermeta` VALUES("10", "1", "show_admin_bar_front", "true");
INSERT INTO `inter_usermeta` VALUES("11", "1", "locale", "");
INSERT INTO `inter_usermeta` VALUES("12", "1", "inter_capabilities", "a:1:{s:13:\"administrator\";b:1;}");
INSERT INTO `inter_usermeta` VALUES("13", "1", "inter_user_level", "10");
INSERT INTO `inter_usermeta` VALUES("14", "1", "dismissed_wp_pointers", "");
INSERT INTO `inter_usermeta` VALUES("15", "1", "show_welcome_panel", "1");
INSERT INTO `inter_usermeta` VALUES("17", "1", "inter_dashboard_quick_press_last_post_id", "99");
INSERT INTO `inter_usermeta` VALUES("18", "1", "inter_persisted_preferences", "a:4:{s:4:\"core\";a:5:{s:26:\"isComplementaryAreaVisible\";b:1;s:24:\"enableChoosePatternModal\";b:1;s:10:\"editorMode\";s:6:\"visual\";s:14:\"renderingModes\";a:1:{s:11:\"inter-theme\";a:1:{s:4:\"page\";s:15:\"template-locked\";}}s:10:\"openPanels\";a:4:{i:0;s:11:\"post-status\";i:1;s:23:\"taxonomy-panel-category\";i:2;s:20:\"taxonomy-panel-sport\";i:3;s:21:\"taxonomy-panel-metier\";}}s:14:\"core/edit-post\";a:2:{s:12:\"welcomeGuide\";b:0;s:20:\"welcomeGuideTemplate\";b:0;}s:9:\"_modified\";s:24:\"2025-10-21T17:10:54.653Z\";s:14:\"core/edit-site\";a:3:{s:12:\"welcomeGuide\";b:0;s:16:\"welcomeGuidePage\";b:0;s:18:\"welcomeGuideStyles\";b:0;}}");
INSERT INTO `inter_usermeta` VALUES("39", "1", "localisation", "guadeloupe");
INSERT INTO `inter_usermeta` VALUES("40", "1", "permis", "B");
INSERT INTO `inter_usermeta` VALUES("43", "1", "inter_user-settings", "libraryContent=browse");
INSERT INTO `inter_usermeta` VALUES("44", "1", "inter_user-settings-time", "1759593951");
INSERT INTO `inter_usermeta` VALUES("128", "6", "nickname", "Test test");
INSERT INTO `inter_usermeta` VALUES("129", "6", "first_name", "Kevin");
INSERT INTO `inter_usermeta` VALUES("130", "6", "last_name", "Suard");
INSERT INTO `inter_usermeta` VALUES("131", "6", "description", "");
INSERT INTO `inter_usermeta` VALUES("132", "6", "rich_editing", "true");
INSERT INTO `inter_usermeta` VALUES("133", "6", "syntax_highlighting", "true");
INSERT INTO `inter_usermeta` VALUES("134", "6", "comment_shortcuts", "false");
INSERT INTO `inter_usermeta` VALUES("135", "6", "admin_color", "fresh");
INSERT INTO `inter_usermeta` VALUES("136", "6", "use_ssl", "0");
INSERT INTO `inter_usermeta` VALUES("137", "6", "show_admin_bar_front", "true");
INSERT INTO `inter_usermeta` VALUES("138", "6", "locale", "");
INSERT INTO `inter_usermeta` VALUES("139", "6", "inter_capabilities", "a:1:{s:10:\"subscriber\";b:1;}");
INSERT INTO `inter_usermeta` VALUES("140", "6", "inter_user_level", "0");
INSERT INTO `inter_usermeta` VALUES("141", "6", "user_email", "test@mail.com");
INSERT INTO `inter_usermeta` VALUES("144", "6", "telephone", "+33782283287");
INSERT INTO `inter_usermeta` VALUES("145", "6", "show_phone", "");
INSERT INTO `inter_usermeta` VALUES("146", "6", "show_email", "1");
INSERT INTO `inter_usermeta` VALUES("147", "6", "region", "61");
INSERT INTO `inter_usermeta` VALUES("148", "6", "poste_principal", "37");
INSERT INTO `inter_usermeta` VALUES("149", "6", "user_permis", "a:4:{i:0;s:2:\"53\";i:1;s:2:\"60\";i:2;s:2:\"42\";i:3;s:2:\"43\";}");
INSERT INTO `inter_usermeta` VALUES("150", "6", "user_postes", "a:0:{}");
INSERT INTO `inter_usermeta` VALUES("151", "6", "experiences", "a:1:{i:0;a:6:{s:5:\"titre\";s:5:\"Bandi\";s:4:\"year\";s:4:\"2025\";s:4:\"real\";s:15:\"Mathilde Vareil\";s:4:\"prod\";s:18:\"MAUI Intertainmant\";s:5:\"poste\";s:11:\"Electricien\";s:10:\"poste_chef\";s:18:\"Jean-Pierre Garbin\";}}");
INSERT INTO `inter_usermeta` VALUES("152", "6", "competences", "a:2:{i:0;s:6:\"Astera\";i:1;s:6:\"Full D\";}");
INSERT INTO `inter_usermeta` VALUES("153", "6", "presentation", "Lorem ipsum dolor sit amet, consectetur adipiscing elit. Vestibulum sit amet augue lobortis, hendrerit ante non, rutrum ipsum. Aenean pulvinar sapien ipsum, id rhoncus leo rutrum eget. Vivamus euismod enim pulvinar, molestie velit eget, condimentum tellus. In hendrerit ligula commodo, auctor odio quis, interdum leo. Donec fringilla tellus id malesuada porttitor. Nullam eu tempor nunc. Nunc non lorem a purus lacinia tincidunt eu nec nunc. Nullam arcu tortor, dignissim non porttitor vel, congue sit amet nisl. Donec pulvinar augue nec massa ultricies, sed elementum leo imperdiet. Suspendisse a pretium neque.\r\n\r\nVivamus quis orci at erat rhoncus scelerisque. Cras maximus mauris et libero efficitur, pretium rutrum est ornare. Nam pulvinar nisl in dolor varius, non commodo dui bibendum. Proin tincidunt id velit non cursus. Quisque pulvinar ac tellus et varius. Praesent malesuada est imperdiet ex tristique scelerisque eu ut est. Ut quis sapien tempor, aliquam tellus eu, tristique ipsum. Nulla bibendum augue a nunc pharetra placerat. Nunc sagittis tristique lacinia. Phasellus pellentesque tellus neque, at tristique velit vehicula non. Pellentesque volutpat est eget accumsan malesuada. Nulla non auctor dui, ut rhoncus lacus. Vivamus sed mattis nisi. Nam consequat dolor quis urna porta, sit amet aliquet lectus placerat. Nullam sollicitudin odio turpis, non commodo urna congue vel.\r\n\r\nAenean egestas mi vitae sem fringilla mattis. Phasellus vel felis eu libero sagittis iaculis non sit amet dui. Proin in tempor dolor, vel venenatis felis. Pellentesque tempor non sem vitae accumsan. Cras lobortis nulla ut mattis volutpat. In tincidunt est ut felis blandit faucibus. Maecenas dolor magna, egestas nec neque a, consequat ultrices velit. Mauris ornare sit amet nulla quis dapibus. Integer placerat eros sit amet arcu ullamcorper, id aliquet est interdum. Aenean at ligula libero. Nullam molestie nunc purus, et viverra nunc interdum eu. Quisque a urna arcu. Pellentesque et enim eget sem consequat maximus maximus nec augue. Maecenas erat urna, consequat eu dictum ultricies, iaculis a lacus. Donec faucibus feugiat nisi, non fermentum tellus semper at.");
INSERT INTO `inter_usermeta` VALUES("154", "6", "fichier_supplementaire", "http://localhost:8888/intermitent_site/wp-content/uploads/2025/10/Connexion-3.pdf");
INSERT INTO `inter_usermeta` VALUES("155", "6", "profile_photo", "http://localhost:8888/intermitent_site/wp-content/uploads/2025/10/974CDFDE-D854-4A57-B00D-E82C9D5F5DFD.jpg");
INSERT INTO `inter_usermeta` VALUES("156", "7", "nickname", "Jean-Pierre Garbin");
INSERT INTO `inter_usermeta` VALUES("157", "7", "first_name", "Jean-Pierre");
INSERT INTO `inter_usermeta` VALUES("158", "7", "last_name", "Garbin");
INSERT INTO `inter_usermeta` VALUES("159", "7", "description", "coucou");
INSERT INTO `inter_usermeta` VALUES("160", "7", "rich_editing", "true");
INSERT INTO `inter_usermeta` VALUES("161", "7", "syntax_highlighting", "true");
INSERT INTO `inter_usermeta` VALUES("162", "7", "comment_shortcuts", "false");
INSERT INTO `inter_usermeta` VALUES("163", "7", "admin_color", "fresh");
INSERT INTO `inter_usermeta` VALUES("164", "7", "use_ssl", "0");
INSERT INTO `inter_usermeta` VALUES("165", "7", "show_admin_bar_front", "true");
INSERT INTO `inter_usermeta` VALUES("166", "7", "locale", "");
INSERT INTO `inter_usermeta` VALUES("167", "7", "inter_capabilities", "a:1:{s:10:\"subscriber\";b:1;}");
INSERT INTO `inter_usermeta` VALUES("168", "7", "inter_user_level", "0");
INSERT INTO `inter_usermeta` VALUES("169", "7", "user_email", "jp@mail.com");
INSERT INTO `inter_usermeta` VALUES("171", "7", "telephone", "");
INSERT INTO `inter_usermeta` VALUES("172", "7", "show_phone", "1");
INSERT INTO `inter_usermeta` VALUES("173", "7", "show_email", "1");
INSERT INTO `inter_usermeta` VALUES("174", "7", "poste_principal", "36");
INSERT INTO `inter_usermeta` VALUES("175", "7", "user_permis", "a:0:{}");
INSERT INTO `inter_usermeta` VALUES("176", "7", "user_postes", "a:0:{}");
INSERT INTO `inter_usermeta` VALUES("177", "7", "experiences", "a:2:{i:0;a:6:{s:5:\"titre\";s:0:\"\";s:4:\"year\";s:10:\"autre test\";s:4:\"real\";s:4:\"test\";s:4:\"prod\";s:4:\"test\";s:5:\"poste\";s:4:\"test\";s:10:\"poste_chef\";s:4:\"test\";}i:1;a:6:{s:5:\"titre\";s:0:\"\";s:4:\"year\";s:4:\"test\";s:4:\"real\";s:3:\"tst\";s:4:\"prod\";s:4:\"test\";s:5:\"poste\";s:4:\"test\";s:10:\"poste_chef\";s:4:\"test\";}}");
INSERT INTO `inter_usermeta` VALUES("178", "7", "competences", "a:3:{i:0;s:4:\"test\";i:1;s:4:\"test\";i:2;s:6:\"blabla\";}");
INSERT INTO `inter_usermeta` VALUES("179", "7", "presentation", "");
INSERT INTO `inter_usermeta` VALUES("180", "7", "7", "profile_picture");
INSERT INTO `inter_usermeta` VALUES("181", "7", "phone", "+33782283287");
INSERT INTO `inter_usermeta` VALUES("182", "7", "region", "62");
INSERT INTO `inter_usermeta` VALUES("183", "7", "profile_picture", "http://localhost:8888/intermitent_site/wp-content/uploads/2025/10/97F0F61C-88F9-49E4-9677-E1BE7E468444-12.jpg");
INSERT INTO `inter_usermeta` VALUES("184", "7", "postes", "a:4:{i:0;i:38;i:1;i:36;i:2;i:37;i:3;i:39;}");
INSERT INTO `inter_usermeta` VALUES("185", "7", "additionnal_file", "http://localhost:8888/intermitent_site/wp-content/uploads/2025/10/463771463_815065803905357_8059302441959280610_n-1.jpg");
INSERT INTO `inter_usermeta` VALUES("186", "7", "permis", "a:5:{i:0;s:2:\"40\";i:1;s:2:\"42\";i:2;s:2:\"43\";i:3;s:2:\"54\";i:4;s:2:\"58\";}");
INSERT INTO `inter_usermeta` VALUES("187", "8", "nickname", "test");
INSERT INTO `inter_usermeta` VALUES("188", "8", "first_name", "Jacques");
INSERT INTO `inter_usermeta` VALUES("189", "8", "last_name", "Jacques");
INSERT INTO `inter_usermeta` VALUES("190", "8", "description", "");
INSERT INTO `inter_usermeta` VALUES("191", "8", "rich_editing", "true");
INSERT INTO `inter_usermeta` VALUES("192", "8", "syntax_highlighting", "true");
INSERT INTO `inter_usermeta` VALUES("193", "8", "comment_shortcuts", "false");
INSERT INTO `inter_usermeta` VALUES("194", "8", "admin_color", "fresh");
INSERT INTO `inter_usermeta` VALUES("195", "8", "use_ssl", "0");
INSERT INTO `inter_usermeta` VALUES("196", "8", "show_admin_bar_front", "true");
INSERT INTO `inter_usermeta` VALUES("197", "8", "locale", "");
INSERT INTO `inter_usermeta` VALUES("198", "8", "inter_capabilities", "a:1:{s:10:\"subscriber\";b:1;}");
INSERT INTO `inter_usermeta` VALUES("199", "8", "inter_user_level", "0");
INSERT INTO `inter_usermeta` VALUES("200", "8", "user_email", "test@test.com");
INSERT INTO `inter_usermeta` VALUES("202", "8", "phone", "");
INSERT INTO `inter_usermeta` VALUES("203", "8", "region", "61");
INSERT INTO `inter_usermeta` VALUES("204", "8", "show_phone", "");
INSERT INTO `inter_usermeta` VALUES("205", "8", "show_email", "");
INSERT INTO `inter_usermeta` VALUES("206", "8", "poste_principal", "0");
INSERT INTO `inter_usermeta` VALUES("207", "8", "permis", "a:0:{}");
INSERT INTO `inter_usermeta` VALUES("208", "8", "postes", "a:4:{i:0;i:38;i:1;i:36;i:2;i:37;i:3;i:39;}");
INSERT INTO `inter_usermeta` VALUES("209", "8", "experiences", "a:0:{}");
INSERT INTO `inter_usermeta` VALUES("210", "8", "competences", "a:0:{}");
INSERT INTO `inter_usermeta` VALUES("211", "9", "nickname", "test2");
INSERT INTO `inter_usermeta` VALUES("212", "9", "first_name", "test");
INSERT INTO `inter_usermeta` VALUES("213", "9", "last_name", "test");
INSERT INTO `inter_usermeta` VALUES("214", "9", "description", "");
INSERT INTO `inter_usermeta` VALUES("215", "9", "rich_editing", "true");
INSERT INTO `inter_usermeta` VALUES("216", "9", "syntax_highlighting", "true");
INSERT INTO `inter_usermeta` VALUES("217", "9", "comment_shortcuts", "false");
INSERT INTO `inter_usermeta` VALUES("218", "9", "admin_color", "fresh");
INSERT INTO `inter_usermeta` VALUES("219", "9", "use_ssl", "0");
INSERT INTO `inter_usermeta` VALUES("220", "9", "show_admin_bar_front", "true");
INSERT INTO `inter_usermeta` VALUES("221", "9", "locale", "");
INSERT INTO `inter_usermeta` VALUES("222", "9", "inter_capabilities", "a:1:{s:10:\"subscriber\";b:1;}");
INSERT INTO `inter_usermeta` VALUES("223", "9", "inter_user_level", "0");
INSERT INTO `inter_usermeta` VALUES("224", "9", "user_email", "test2@mail.com");
INSERT INTO `inter_usermeta` VALUES("226", "9", "phone", "");
INSERT INTO `inter_usermeta` VALUES("227", "9", "region", "62");
INSERT INTO `inter_usermeta` VALUES("228", "9", "show_phone", "");
INSERT INTO `inter_usermeta` VALUES("229", "9", "show_email", "");
INSERT INTO `inter_usermeta` VALUES("230", "9", "poste_principal", "0");
INSERT INTO `inter_usermeta` VALUES("231", "9", "permis", "a:0:{}");
INSERT INTO `inter_usermeta` VALUES("232", "9", "postes", "a:1:{i:0;i:38;}");
INSERT INTO `inter_usermeta` VALUES("233", "9", "experiences", "a:0:{}");
INSERT INTO `inter_usermeta` VALUES("234", "9", "competences", "a:0:{}");
INSERT INTO `inter_usermeta` VALUES("235", "10", "nickname", "test3");
INSERT INTO `inter_usermeta` VALUES("236", "10", "first_name", "test");
INSERT INTO `inter_usermeta` VALUES("237", "10", "last_name", "test");
INSERT INTO `inter_usermeta` VALUES("238", "10", "description", "Bonjour tout le monde.\r\n\r\nComment allez-vous ?");
INSERT INTO `inter_usermeta` VALUES("239", "10", "rich_editing", "true");
INSERT INTO `inter_usermeta` VALUES("240", "10", "syntax_highlighting", "true");
INSERT INTO `inter_usermeta` VALUES("241", "10", "comment_shortcuts", "false");
INSERT INTO `inter_usermeta` VALUES("242", "10", "admin_color", "fresh");
INSERT INTO `inter_usermeta` VALUES("243", "10", "use_ssl", "0");
INSERT INTO `inter_usermeta` VALUES("244", "10", "show_admin_bar_front", "true");
INSERT INTO `inter_usermeta` VALUES("245", "10", "locale", "");
INSERT INTO `inter_usermeta` VALUES("246", "10", "inter_capabilities", "a:1:{s:10:\"subscriber\";b:1;}");
INSERT INTO `inter_usermeta` VALUES("247", "10", "inter_user_level", "0");
INSERT INTO `inter_usermeta` VALUES("248", "10", "user_email", "test3@mail.com");
INSERT INTO `inter_usermeta` VALUES("250", "10", "phone", "");
INSERT INTO `inter_usermeta` VALUES("251", "10", "region", "62");
INSERT INTO `inter_usermeta` VALUES("252", "10", "show_phone", "");
INSERT INTO `inter_usermeta` VALUES("253", "10", "show_email", "");
INSERT INTO `inter_usermeta` VALUES("254", "10", "poste_principal", "0");
INSERT INTO `inter_usermeta` VALUES("255", "10", "permis", "a:0:{}");
INSERT INTO `inter_usermeta` VALUES("256", "10", "postes", "a:4:{i:0;i:38;i:1;i:36;i:2;i:37;i:3;i:39;}");
INSERT INTO `inter_usermeta` VALUES("257", "10", "experiences", "a:1:{i:0;a:6:{s:5:\"titre\";s:4:\"TEst\";s:4:\"year\";s:4:\"test\";s:4:\"real\";s:4:\"test\";s:4:\"prod\";s:5:\"teste\";s:5:\"poste\";s:4:\"test\";s:10:\"poste_chef\";s:0:\"\";}}");
INSERT INTO `inter_usermeta` VALUES("258", "10", "competences", "a:0:{}");
INSERT INTO `inter_usermeta` VALUES("259", "11", "nickname", "test4");
INSERT INTO `inter_usermeta` VALUES("260", "11", "first_name", "test");
INSERT INTO `inter_usermeta` VALUES("261", "11", "last_name", "test");
INSERT INTO `inter_usermeta` VALUES("262", "11", "description", "");
INSERT INTO `inter_usermeta` VALUES("263", "11", "rich_editing", "true");
INSERT INTO `inter_usermeta` VALUES("264", "11", "syntax_highlighting", "true");
INSERT INTO `inter_usermeta` VALUES("265", "11", "comment_shortcuts", "false");
INSERT INTO `inter_usermeta` VALUES("266", "11", "admin_color", "fresh");
INSERT INTO `inter_usermeta` VALUES("267", "11", "use_ssl", "0");
INSERT INTO `inter_usermeta` VALUES("268", "11", "show_admin_bar_front", "true");
INSERT INTO `inter_usermeta` VALUES("269", "11", "locale", "");
INSERT INTO `inter_usermeta` VALUES("270", "11", "inter_capabilities", "a:1:{s:10:\"subscriber\";b:1;}");
INSERT INTO `inter_usermeta` VALUES("271", "11", "inter_user_level", "0");
INSERT INTO `inter_usermeta` VALUES("272", "11", "user_email", "test4@mail.com");
INSERT INTO `inter_usermeta` VALUES("274", "11", "phone", "");
INSERT INTO `inter_usermeta` VALUES("275", "11", "region", "62");
INSERT INTO `inter_usermeta` VALUES("276", "11", "show_phone", "");
INSERT INTO `inter_usermeta` VALUES("277", "11", "show_email", "");
INSERT INTO `inter_usermeta` VALUES("278", "11", "poste_principal", "0");
INSERT INTO `inter_usermeta` VALUES("279", "11", "permis", "a:0:{}");
INSERT INTO `inter_usermeta` VALUES("280", "11", "postes", "a:1:{i:0;i:38;}");
INSERT INTO `inter_usermeta` VALUES("281", "11", "experiences", "a:0:{}");
INSERT INTO `inter_usermeta` VALUES("282", "11", "competences", "a:0:{}");
INSERT INTO `inter_usermeta` VALUES("283", "12", "nickname", "test5");
INSERT INTO `inter_usermeta` VALUES("284", "12", "first_name", "test5");
INSERT INTO `inter_usermeta` VALUES("285", "12", "last_name", "test5");
INSERT INTO `inter_usermeta` VALUES("286", "12", "description", "");
INSERT INTO `inter_usermeta` VALUES("287", "12", "rich_editing", "true");
INSERT INTO `inter_usermeta` VALUES("288", "12", "syntax_highlighting", "true");
INSERT INTO `inter_usermeta` VALUES("289", "12", "comment_shortcuts", "false");
INSERT INTO `inter_usermeta` VALUES("290", "12", "admin_color", "fresh");
INSERT INTO `inter_usermeta` VALUES("291", "12", "use_ssl", "0");
INSERT INTO `inter_usermeta` VALUES("292", "12", "show_admin_bar_front", "true");
INSERT INTO `inter_usermeta` VALUES("293", "12", "locale", "");
INSERT INTO `inter_usermeta` VALUES("294", "12", "inter_capabilities", "a:1:{s:10:\"subscriber\";b:1;}");
INSERT INTO `inter_usermeta` VALUES("295", "12", "inter_user_level", "0");
INSERT INTO `inter_usermeta` VALUES("296", "12", "user_email", "test5@mail.com");
INSERT INTO `inter_usermeta` VALUES("298", "12", "phone", "");
INSERT INTO `inter_usermeta` VALUES("299", "12", "region", "65");
INSERT INTO `inter_usermeta` VALUES("300", "12", "show_phone", "");
INSERT INTO `inter_usermeta` VALUES("301", "12", "show_email", "");
INSERT INTO `inter_usermeta` VALUES("302", "12", "poste_principal", "0");
INSERT INTO `inter_usermeta` VALUES("303", "12", "permis", "a:0:{}");
INSERT INTO `inter_usermeta` VALUES("304", "12", "postes", "a:1:{i:0;i:38;}");
INSERT INTO `inter_usermeta` VALUES("305", "12", "experiences", "a:0:{}");
INSERT INTO `inter_usermeta` VALUES("306", "12", "competences", "a:0:{}");
INSERT INTO `inter_usermeta` VALUES("307", "13", "nickname", "test6");
INSERT INTO `inter_usermeta` VALUES("308", "13", "first_name", "test");
INSERT INTO `inter_usermeta` VALUES("309", "13", "last_name", "test");
INSERT INTO `inter_usermeta` VALUES("310", "13", "description", "");
INSERT INTO `inter_usermeta` VALUES("311", "13", "rich_editing", "true");
INSERT INTO `inter_usermeta` VALUES("312", "13", "syntax_highlighting", "true");
INSERT INTO `inter_usermeta` VALUES("313", "13", "comment_shortcuts", "false");
INSERT INTO `inter_usermeta` VALUES("314", "13", "admin_color", "fresh");
INSERT INTO `inter_usermeta` VALUES("315", "13", "use_ssl", "0");
INSERT INTO `inter_usermeta` VALUES("316", "13", "show_admin_bar_front", "true");
INSERT INTO `inter_usermeta` VALUES("317", "13", "locale", "");
INSERT INTO `inter_usermeta` VALUES("318", "13", "inter_capabilities", "a:1:{s:10:\"subscriber\";b:1;}");
INSERT INTO `inter_usermeta` VALUES("319", "13", "inter_user_level", "0");
INSERT INTO `inter_usermeta` VALUES("320", "13", "user_email", "test6@mail.com");
INSERT INTO `inter_usermeta` VALUES("322", "13", "phone", "");
INSERT INTO `inter_usermeta` VALUES("323", "13", "region", "62");
INSERT INTO `inter_usermeta` VALUES("324", "13", "show_phone", "");
INSERT INTO `inter_usermeta` VALUES("325", "13", "show_email", "");
INSERT INTO `inter_usermeta` VALUES("326", "13", "poste_principal", "0");
INSERT INTO `inter_usermeta` VALUES("327", "13", "permis", "a:0:{}");
INSERT INTO `inter_usermeta` VALUES("328", "13", "postes", "a:4:{i:0;i:38;i:1;i:36;i:2;i:37;i:3;i:39;}");
INSERT INTO `inter_usermeta` VALUES("329", "13", "experiences", "a:0:{}");
INSERT INTO `inter_usermeta` VALUES("330", "13", "competences", "a:0:{}");
INSERT INTO `inter_usermeta` VALUES("331", "14", "nickname", "test7");
INSERT INTO `inter_usermeta` VALUES("332", "14", "first_name", "test");
INSERT INTO `inter_usermeta` VALUES("333", "14", "last_name", "test");
INSERT INTO `inter_usermeta` VALUES("334", "14", "description", "");
INSERT INTO `inter_usermeta` VALUES("335", "14", "rich_editing", "true");
INSERT INTO `inter_usermeta` VALUES("336", "14", "syntax_highlighting", "true");
INSERT INTO `inter_usermeta` VALUES("337", "14", "comment_shortcuts", "false");
INSERT INTO `inter_usermeta` VALUES("338", "14", "admin_color", "fresh");
INSERT INTO `inter_usermeta` VALUES("339", "14", "use_ssl", "0");
INSERT INTO `inter_usermeta` VALUES("340", "14", "show_admin_bar_front", "true");
INSERT INTO `inter_usermeta` VALUES("341", "14", "locale", "");
INSERT INTO `inter_usermeta` VALUES("342", "14", "inter_capabilities", "a:1:{s:10:\"subscriber\";b:1;}");
INSERT INTO `inter_usermeta` VALUES("343", "14", "inter_user_level", "0");
INSERT INTO `inter_usermeta` VALUES("344", "14", "user_email", "test7@mail.com");
INSERT INTO `inter_usermeta` VALUES("346", "14", "phone", "");
INSERT INTO `inter_usermeta` VALUES("347", "14", "region", "61");
INSERT INTO `inter_usermeta` VALUES("348", "14", "show_phone", "");
INSERT INTO `inter_usermeta` VALUES("349", "14", "show_email", "");
INSERT INTO `inter_usermeta` VALUES("350", "14", "poste_principal", "0");
INSERT INTO `inter_usermeta` VALUES("351", "14", "permis", "a:0:{}");
INSERT INTO `inter_usermeta` VALUES("352", "14", "postes", "a:1:{i:0;i:36;}");
INSERT INTO `inter_usermeta` VALUES("353", "14", "experiences", "a:0:{}");
INSERT INTO `inter_usermeta` VALUES("354", "14", "competences", "a:0:{}");
INSERT INTO `inter_usermeta` VALUES("355", "15", "nickname", "test8");
INSERT INTO `inter_usermeta` VALUES("356", "15", "first_name", "test");
INSERT INTO `inter_usermeta` VALUES("357", "15", "last_name", "test");
INSERT INTO `inter_usermeta` VALUES("358", "15", "description", "");
INSERT INTO `inter_usermeta` VALUES("359", "15", "rich_editing", "true");
INSERT INTO `inter_usermeta` VALUES("360", "15", "syntax_highlighting", "true");
INSERT INTO `inter_usermeta` VALUES("361", "15", "comment_shortcuts", "false");
INSERT INTO `inter_usermeta` VALUES("362", "15", "admin_color", "fresh");
INSERT INTO `inter_usermeta` VALUES("363", "15", "use_ssl", "0");
INSERT INTO `inter_usermeta` VALUES("364", "15", "show_admin_bar_front", "true");
INSERT INTO `inter_usermeta` VALUES("365", "15", "locale", "");
INSERT INTO `inter_usermeta` VALUES("366", "15", "inter_capabilities", "a:1:{s:10:\"subscriber\";b:1;}");
INSERT INTO `inter_usermeta` VALUES("367", "15", "inter_user_level", "0");
INSERT INTO `inter_usermeta` VALUES("368", "15", "user_email", "test8@mail.com");
INSERT INTO `inter_usermeta` VALUES("370", "15", "phone", "");
INSERT INTO `inter_usermeta` VALUES("371", "15", "region", "65");
INSERT INTO `inter_usermeta` VALUES("372", "15", "show_phone", "");
INSERT INTO `inter_usermeta` VALUES("373", "15", "show_email", "");
INSERT INTO `inter_usermeta` VALUES("374", "15", "poste_principal", "0");
INSERT INTO `inter_usermeta` VALUES("375", "15", "permis", "a:0:{}");
INSERT INTO `inter_usermeta` VALUES("376", "15", "postes", "a:1:{i:0;i:38;}");
INSERT INTO `inter_usermeta` VALUES("377", "15", "experiences", "a:0:{}");
INSERT INTO `inter_usermeta` VALUES("378", "15", "competences", "a:0:{}");
INSERT INTO `inter_usermeta` VALUES("379", "16", "nickname", "test9");
INSERT INTO `inter_usermeta` VALUES("380", "16", "first_name", "test");
INSERT INTO `inter_usermeta` VALUES("381", "16", "last_name", "test");
INSERT INTO `inter_usermeta` VALUES("382", "16", "description", "");
INSERT INTO `inter_usermeta` VALUES("383", "16", "rich_editing", "true");
INSERT INTO `inter_usermeta` VALUES("384", "16", "syntax_highlighting", "true");
INSERT INTO `inter_usermeta` VALUES("385", "16", "comment_shortcuts", "false");
INSERT INTO `inter_usermeta` VALUES("386", "16", "admin_color", "fresh");
INSERT INTO `inter_usermeta` VALUES("387", "16", "use_ssl", "0");
INSERT INTO `inter_usermeta` VALUES("388", "16", "show_admin_bar_front", "true");
INSERT INTO `inter_usermeta` VALUES("389", "16", "locale", "");
INSERT INTO `inter_usermeta` VALUES("390", "16", "inter_capabilities", "a:1:{s:10:\"subscriber\";b:1;}");
INSERT INTO `inter_usermeta` VALUES("391", "16", "inter_user_level", "0");
INSERT INTO `inter_usermeta` VALUES("392", "16", "user_email", "test9@mail.com");
INSERT INTO `inter_usermeta` VALUES("394", "16", "phone", "");
INSERT INTO `inter_usermeta` VALUES("395", "16", "region", "62");
INSERT INTO `inter_usermeta` VALUES("396", "16", "show_phone", "");
INSERT INTO `inter_usermeta` VALUES("397", "16", "show_email", "");
INSERT INTO `inter_usermeta` VALUES("398", "16", "poste_principal", "0");
INSERT INTO `inter_usermeta` VALUES("399", "16", "permis", "a:0:{}");
INSERT INTO `inter_usermeta` VALUES("400", "16", "postes", "a:1:{i:0;i:37;}");
INSERT INTO `inter_usermeta` VALUES("401", "16", "experiences", "a:0:{}");
INSERT INTO `inter_usermeta` VALUES("402", "16", "competences", "a:0:{}");
INSERT INTO `inter_usermeta` VALUES("403", "17", "nickname", "test10");
INSERT INTO `inter_usermeta` VALUES("404", "17", "first_name", "test");
INSERT INTO `inter_usermeta` VALUES("405", "17", "last_name", "test");
INSERT INTO `inter_usermeta` VALUES("406", "17", "description", "");
INSERT INTO `inter_usermeta` VALUES("407", "17", "rich_editing", "true");
INSERT INTO `inter_usermeta` VALUES("408", "17", "syntax_highlighting", "true");
INSERT INTO `inter_usermeta` VALUES("409", "17", "comment_shortcuts", "false");
INSERT INTO `inter_usermeta` VALUES("410", "17", "admin_color", "fresh");
INSERT INTO `inter_usermeta` VALUES("411", "17", "use_ssl", "0");
INSERT INTO `inter_usermeta` VALUES("412", "17", "show_admin_bar_front", "true");
INSERT INTO `inter_usermeta` VALUES("413", "17", "locale", "");
INSERT INTO `inter_usermeta` VALUES("414", "17", "inter_capabilities", "a:1:{s:10:\"subscriber\";b:1;}");
INSERT INTO `inter_usermeta` VALUES("415", "17", "inter_user_level", "0");
INSERT INTO `inter_usermeta` VALUES("416", "17", "user_email", "test10@mail.com");
INSERT INTO `inter_usermeta` VALUES("418", "17", "phone", "");
INSERT INTO `inter_usermeta` VALUES("419", "17", "region", "64");
INSERT INTO `inter_usermeta` VALUES("420", "17", "show_phone", "");
INSERT INTO `inter_usermeta` VALUES("421", "17", "show_email", "");
INSERT INTO `inter_usermeta` VALUES("422", "17", "poste_principal", "0");
INSERT INTO `inter_usermeta` VALUES("423", "17", "permis", "a:0:{}");
INSERT INTO `inter_usermeta` VALUES("424", "17", "postes", "a:1:{i:0;i:36;}");
INSERT INTO `inter_usermeta` VALUES("425", "17", "experiences", "a:0:{}");
INSERT INTO `inter_usermeta` VALUES("426", "17", "competences", "a:0:{}");
INSERT INTO `inter_usermeta` VALUES("427", "18", "nickname", "test11");
INSERT INTO `inter_usermeta` VALUES("428", "18", "first_name", "test");
INSERT INTO `inter_usermeta` VALUES("429", "18", "last_name", "test");
INSERT INTO `inter_usermeta` VALUES("430", "18", "description", "");
INSERT INTO `inter_usermeta` VALUES("431", "18", "rich_editing", "true");
INSERT INTO `inter_usermeta` VALUES("432", "18", "syntax_highlighting", "true");
INSERT INTO `inter_usermeta` VALUES("433", "18", "comment_shortcuts", "false");
INSERT INTO `inter_usermeta` VALUES("434", "18", "admin_color", "fresh");
INSERT INTO `inter_usermeta` VALUES("435", "18", "use_ssl", "0");
INSERT INTO `inter_usermeta` VALUES("436", "18", "show_admin_bar_front", "true");
INSERT INTO `inter_usermeta` VALUES("437", "18", "locale", "");
INSERT INTO `inter_usermeta` VALUES("438", "18", "inter_capabilities", "a:1:{s:10:\"subscriber\";b:1;}");
INSERT INTO `inter_usermeta` VALUES("439", "18", "inter_user_level", "0");
INSERT INTO `inter_usermeta` VALUES("440", "18", "user_email", "test11@mail.com");
INSERT INTO `inter_usermeta` VALUES("441", "18", "session_tokens", "a:1:{s:64:\"afa0b7a6c4fdb613af636530b5cf179a6aa1a5b15276b6be18af3629c44329c4\";a:4:{s:10:\"expiration\";i:1760888627;s:2:\"ip\";s:3:\"::1\";s:2:\"ua\";s:117:\"Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/139.0.0.0 Safari/537.36\";s:5:\"login\";i:1760715827;}}");
INSERT INTO `inter_usermeta` VALUES("442", "18", "phone", "");
INSERT INTO `inter_usermeta` VALUES("443", "18", "region", "61");
INSERT INTO `inter_usermeta` VALUES("444", "18", "show_phone", "");
INSERT INTO `inter_usermeta` VALUES("445", "18", "show_email", "");
INSERT INTO `inter_usermeta` VALUES("446", "18", "poste_principal", "0");
INSERT INTO `inter_usermeta` VALUES("447", "18", "permis", "a:0:{}");
INSERT INTO `inter_usermeta` VALUES("448", "18", "postes", "a:1:{i:0;i:38;}");
INSERT INTO `inter_usermeta` VALUES("449", "18", "experiences", "a:0:{}");
INSERT INTO `inter_usermeta` VALUES("450", "18", "competences", "a:0:{}");
INSERT INTO `inter_usermeta` VALUES("451", "10", "session_tokens", "a:1:{s:64:\"5e4c47ed05c8b380cec77ce64e03d60fc3bf172755551f37a8bed694424fed9c\";a:4:{s:10:\"expiration\";i:1761141422;s:2:\"ip\";s:3:\"::1\";s:2:\"ua\";s:117:\"Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/139.0.0.0 Safari/537.36\";s:5:\"login\";i:1760968622;}}");
INSERT INTO `inter_usermeta` VALUES("454", "1", "duplicator_email_subscribed", "1");
INSERT INTO `inter_usermeta` VALUES("484", "20", "nickname", "Hiba Pol");
INSERT INTO `inter_usermeta` VALUES("485", "20", "first_name", "");
INSERT INTO `inter_usermeta` VALUES("486", "20", "last_name", "");
INSERT INTO `inter_usermeta` VALUES("487", "20", "description", "");
INSERT INTO `inter_usermeta` VALUES("488", "20", "rich_editing", "true");
INSERT INTO `inter_usermeta` VALUES("489", "20", "syntax_highlighting", "true");
INSERT INTO `inter_usermeta` VALUES("490", "20", "comment_shortcuts", "false");
INSERT INTO `inter_usermeta` VALUES("491", "20", "admin_color", "fresh");
INSERT INTO `inter_usermeta` VALUES("492", "20", "use_ssl", "0");
INSERT INTO `inter_usermeta` VALUES("493", "20", "show_admin_bar_front", "true");
INSERT INTO `inter_usermeta` VALUES("494", "20", "locale", "");
INSERT INTO `inter_usermeta` VALUES("495", "20", "inter_capabilities", "a:1:{s:10:\"subscriber\";b:1;}");
INSERT INTO `inter_usermeta` VALUES("496", "20", "inter_user_level", "0");
INSERT INTO `inter_usermeta` VALUES("497", "20", "user_email", "hibapol237@elygifts.com");
INSERT INTO `inter_usermeta` VALUES("500", "20", "deletion_requested_at", "2025-10-23 17:54:09");
INSERT INTO `inter_usermeta` VALUES("502", "8", "profile_picture", "http://localhost:8888/intermitent_site/wp-content/uploads/2025/10/Capture-decran-2025-10-01-a-13.20.48.png");
INSERT INTO `inter_usermeta` VALUES("504", "8", "deletion_requested_at", "2025-10-23 19:33:20");
INSERT INTO `inter_usermeta` VALUES("507", "8", "account_status", "pending_deletion");
INSERT INTO `inter_usermeta` VALUES("508", "1", "session_tokens", "a:1:{s:64:\"7888da85ee9858e13b3f184fb00ac9cff4cbe43b04b6067ec8c8faf7689f98f5\";a:4:{s:10:\"expiration\";i:1761505495;s:2:\"ip\";s:3:\"::1\";s:2:\"ua\";s:117:\"Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/139.0.0.0 Safari/537.36\";s:5:\"login\";i:1761332695;}}");

/* INSERT TABLE DATA: inter_users */
INSERT INTO `inter_users` VALUES("1", "ambre_palanque", "$wp$2y$10$u.oWFHoiGCTfmS.sU9RTVemC3Bk.pW6IYPwnlHq2WYIikSLfLmb1O", "ambre_palanque", "ambre.palanque@hotmail.com", "http://localhost:8888/intermitent_site", "2025-09-23 18:25:50", "", "0", "ambre_palanque");
INSERT INTO `inter_users` VALUES("6", "Test test", "$wp$2y$10$/sarFPsofpf7ro8V89n6O.9kaR1RrPuHX95ilwsxkl.ZVaCRH7T82", "test-test", "test@mail.com", "", "2025-10-13 20:24:01", "", "0", "Test test");
INSERT INTO `inter_users` VALUES("7", "Jean-Pierre Garbin", "$wp$2y$10$FX/aD7fy/R2POJ1E5tDZh.Sl5D8udb/zT1HDUUg2zPqaqw5elG5a.", "jean-pierre-garbin", "jp@mail.com", "", "2025-10-15 13:41:26", "1760712675:$generic$lM6uG0gFxnG8xuAGwh38X3r_MgC4tlm6rhvLavfe", "0", "Jean-Pierre Garbin");
INSERT INTO `inter_users` VALUES("8", "test", "$wp$2y$10$l5nHWK7oHxFxtBEARVpdV.klhPwnyK3BODxOaXCfJGgWmGuFK6djm", "test", "test@test.com", "", "2025-10-17 15:30:48", "", "0", "Jean Jacques");
INSERT INTO `inter_users` VALUES("9", "test2", "$wp$2y$10$Ido5r6VMRAmvRsDOvhTpq.C/iu2EftDrtTWtP4zRH.jYlQFOwCqGC", "test2", "test2@mail.com", "", "2025-10-17 15:33:43", "", "0", "test2");
INSERT INTO `inter_users` VALUES("10", "test3", "$wp$2y$10$CRDc15DkuPJHKWTo4MVmsOjjsqaXvNnVP5zc48MmM.5Rec0qE2iBG", "test3", "test3@mail.com", "", "2025-10-17 15:34:25", "", "0", "test3");
INSERT INTO `inter_users` VALUES("11", "test4", "$wp$2y$10$AIYLC36uDa5nGYnDzDpLJu8vQ9pKMiquJ25LQZBCbzM9uhGVIOPye", "test4", "test4@mail.com", "", "2025-10-17 15:35:24", "", "0", "test4");
INSERT INTO `inter_users` VALUES("12", "test5", "$wp$2y$10$bimzFCfXCrPTBYCeZO43tuj60e7lpHZDbNgUBEMMZXOojmgd46qXi", "test5", "test5@mail.com", "", "2025-10-17 15:35:52", "", "0", "test5");
INSERT INTO `inter_users` VALUES("13", "test6", "$wp$2y$10$Z76udOZZLvj9hwI9NxBSJ.UTYykCfJP7VLYkIr1T36YtEhWD4Huza", "test6", "test6@mail.com", "", "2025-10-17 15:36:24", "", "0", "test6");
INSERT INTO `inter_users` VALUES("14", "test7", "$wp$2y$10$mMggFfq9n79ToFQ3VfT5KOCvuZCWFaU.nT0ZRBiqSY4TfqRnLnRhO", "test7", "test7@mail.com", "", "2025-10-17 15:37:04", "", "0", "test7");
INSERT INTO `inter_users` VALUES("15", "test8", "$wp$2y$10$n1b3iCEi7ZAXYqm2PO/12uTKApCfWwgb9pg4muJDparIGoE5xjiI2", "test8", "test8@mail.com", "", "2025-10-17 15:41:11", "", "0", "test8");
INSERT INTO `inter_users` VALUES("16", "test9", "$wp$2y$10$TQcx3VnwHlJfngUoA/pWOufvsqNKeD9nx0VzpLvfiVkAjyK4da6C6", "test9", "test9@mail.com", "", "2025-10-17 15:42:51", "", "0", "test9");
INSERT INTO `inter_users` VALUES("17", "test10", "$wp$2y$10$MEC1cesEQk5n36sb2/y.Cu15smNJJNC7PmmFWn3SlP7nFdDxq9Kpq", "test10", "test10@mail.com", "", "2025-10-17 15:43:18", "", "0", "test10");
INSERT INTO `inter_users` VALUES("18", "test11", "$wp$2y$10$yT/V2Yf6Db9d5stz2.d8Ke0dfbfWQcZyVsMACZGYAgKEFf3/ZnSjC", "test11", "test11@mail.com", "", "2025-10-17 15:43:47", "", "0", "test11");
INSERT INTO `inter_users` VALUES("20", "Hiba Pol", "$wp$2y$10$EFHJPkuCvWnh8XXUKUkp9ui8Nbmpjg5qR4D4X2OdEVFX/q7VrUD4e", "hiba-pol", "hibapol237@elygifts.com", "", "2025-10-23 15:48:49", "", "0", "Hiba Pol");

/* INSERT TABLE DATA: inter_wpmailsmtp_tasks_meta */
INSERT INTO `inter_wpmailsmtp_tasks_meta` VALUES("1", "wp_mail_smtp_admin_notifications_update", "W10=", "2025-10-20 18:24:15");

SET FOREIGN_KEY_CHECKS = 1; 

/* Duplicator WordPress Timestamp: 2025-10-24 19:06:46*/
/* DUPLICATOR_MYSQLDUMP_EOF */
